import tensorflow as tf
gpu=2
gpus = tf.config.experimental.list_physical_devices('GPU')
tf.config.experimental.set_visible_devices(gpus[gpu], 'GPU')
device = gpus[gpu]

for device in tf.config.experimental.get_visible_devices('GPU'):
    tf.config.experimental.set_memory_growth(device, True)


# Stop tensorflow from doing its warning logging.
import logging
logging.getLogger('tensorflow').disabled = True

import warnings
warnings.filterwarnings('ignore')

import os
import tempfile
import shutil
os.environ['TF_CPP_MIN_LOG_LEVEL'] = '3'
os.environ['TF_DETERMINISTIC_OPS'] = '1'

import numpy as np
#import tensorflow as tf
import tensorflow.keras.backend as K
import random as pyrand

K.set_image_data_format('channels_last')

from luf.luf_experiment import LUFExperiment
from luf.rs_experiment import string_to_architecture, RSExperiment
from tensorflow.keras.metrics import binary_accuracy


from datalib.splitters import Split
from datalib import CustomData, FashionMnist


def make_datalib(name, X_train, X_test, y_train, y_test, rat=None):
    if rat is None:
        rat=[len(X_train), len(X_test)]
    D = CustomData(
        name,
        np.concatenate((X_train, X_test)),
        np.concatenate((y_train, y_test)),
        Split(tr=rat[0], te=rat[1]))
    return D




X_train_gc=np.load("../data/german_X_train.npy")
y_train_gc=np.load("../data/german_y_train.npy")
X_test_gc=np.load("../data/german_X_test.npy")
y_test_gc=np.load("../data/german_y_test.npy")

#randomly generated points which will be left out from the training set for LOO-experiments
outliers_gc=np.load("../data/outliers_gc.npy")

GC_Data=make_datalib("gc", X_train_gc, X_test_gc, y_train_gc, y_test_gc, rat=[4,1])
del X_train_gc, X_test_gc, y_train_gc, y_test_gc

LufExpGC=LUFExperiment('128.32.16', GC_Data, indices=outliers_gc, num_trials=None, seed=42,
            multi=False, model_args=[], model_kwargs={},
            compile_kwargs={"loss": tf.keras.losses.BinaryCrossentropy(from_logits=True),
        "metrics": "accuracy",
        "optimizer" : tf.keras.optimizers.Adam(1e-3)}, fit_args=[], fit_kwargs={"batch_size":32, "epochs":100}, 
            custom_objects={}, early_stop_cutoff=1.e-1)
info_gc=LufExpGC.run()
LufExpGC.save()

RSExpGC=RSExperiment('128.32.16', GC_Data, num_trials=500, seed=42,
            multi=False,  model_args=[], model_kwargs={},
            compile_kwargs={"loss": tf.keras.losses.BinaryCrossentropy(from_logits=True),
        "metrics": "accuracy",
        "optimizer" : tf.keras.optimizers.Adam(1e-3)}, fit_args=[], fit_kwargs={"batch_size":32, "epochs":100}, 
            custom_objects={}, early_stop_cutoff=1.e-1)
info_gc_RS = RSExpGC.run()
RSExpGC.save()

del outliers_gc

#ADULT
X_train_ad=np.load("../data/adult_X_train_norm.npy")
y_train_ad=np.load("../data/adult_y_train_norm.npy")
X_test_ad=np.load("../data/adult_X_test_norm.npy")
y_test_ad=np.load("../data/adult_y_test_norm.npy")
outliers_pt1_ad=np.load("../data/adult_outliers.npy")
outliers_pt2_ad=np.load("../data/adult_outliers_ext.npy")
outliers_ad=np.concatenate((outliers_pt1_ad, outliers_pt2_ad))

AD_Data=make_datalib("ad2", X_train_ad, X_test_ad, y_train_ad, y_test_ad)
del X_train_ad, X_test_ad, y_train_ad, y_test_ad

LufExpAD=LUFExperiment('200', AD_Data, indices=outliers_ad, num_trials=None, seed=42,
             model_args=[], model_kwargs={},
            compile_kwargs={"loss": tf.keras.losses.CategoricalCrossentropy(from_logits=True),
        "metrics": "categorical_accuracy",
        "optimizer" : tf.keras.optimizers.Adam(1e-3)}, fit_args=[], fit_kwargs={"batch_size":128, "epochs":100}, 
            custom_objects={}, early_stop_cutoff=1.e-1)
info_AD=LufExpwar.run()
LufExpAD.save()

RSExpAD=RSExperiment('200', AD_Data, num_trials=500, seed=42,
             model_args=[], model_kwargs={},
            compile_kwargs={"loss": tf.keras.losses.CategoricalCrossentropy(from_logits=True),
        "metrics": "categorical_accuracy",
        "optimizer" : tf.keras.optimizers.Adam(1e-3)}, fit_args=[], fit_kwargs={"batch_size":128, "epochs":100}, 
            custom_objects={}, early_stop_cutoff=1.e-1)
info_ad_RS=RSExpwar.run()
RSExpAD.save()

#seizure

X_train_sz=np.load("../data/seizure_X_train.npy")
y_train_sz=np.load("../data/seizure_y_train.npy")
X_test_sz=np.load("../data/seizure_X_test.npy")
y_test_sz=np.load("../data/seizure_y_test.npy")
outliers_sz=np.load("../data/seizure_outliers.npy")


SZ_Data=make_datalib("sz2", X_train_sz, X_test_sz, y_train_sz, y_test_sz)
del X_train_sz, X_test_sz, y_train_sz, y_test_sz


LufExpSZ=LUFExperiment('128.32.16', SZ_Data, indices=outliers_sz, num_trials=None, seed=42,
             multi=False, model_args=[], model_kwargs={},
            compile_kwargs={"loss": tf.keras.losses.BinaryCrossentropy(from_logits=True),
        "metrics": "accuracy",
        "optimizer" : tf.keras.optimizers.Adam(1e-3)}, fit_args=[], fit_kwargs={"batch_size":32, "epochs": 100}, 
            custom_objects={}, early_stop_cutoff=1.e-1)
info_SZ=LufExpSZ.run()
LufExpSZ.save()

RSExpSZ=RSExperiment('128.32.16', SZ_Data, num_trials=500, seed=42,
             multi=False, model_args=[], model_kwargs={},
            compile_kwargs={"loss": tf.keras.losses.BinaryCrossentropy(from_logits=True),
        "metrics": "accuracy",
        "optimizer" : tf.keras.optimizers.Adam(1e-3)}, fit_args=[], fit_kwargs={"batch_size":32, "epochs":100}, 
            custom_objects={}, early_stop_cutoff=1.e-1)
info_SZ_RS=RSExpSZ.run()
RSExpSZ.save()

#TAIWANESE

X_train_tai=np.load("../data/X_train_taiwanese.npy")
y_train_tai=np.load("../data/y_train_taiwanese.npy")
X_test_tai=np.load("../data/X_test_taiwanese.npy")
y_test_tai=np.load("../data/y_test_taiwanese.npy")
outliers_tai=np.load("../data/outliers_tai.npy")

tai_Data=make_datalib("tai2", X_train_tai, X_test_tai, y_train_tai, y_test_tai)
del X_train_tai, X_test_tai, y_train_tai, y_test_tai


LufExptai=LUFExperiment('32.16', tai_Data, indices=outliers_tai, num_trials=None, seed=42,
             multi=False, model_args=[], model_kwargs={},
            compile_kwargs={"loss": tf.keras.losses.BinaryCrossentropy(from_logits=True),
        "metrics": "accuracy",
        "optimizer" : tf.keras.optimizers.Adam(1e-3)}, fit_args=[], fit_kwargs={"batch_size":512, "epochs":50}, 
            custom_objects={}, early_stop_cutoff=1.e-1)
info_tai=LufExptai.run()
LufExptai.save()

RSExptai=RSExperiment('32.16', tai_Data, num_trials=500, seed=42,
             multi=False, model_args=[], model_kwargs={},
            compile_kwargs={"loss": tf.keras.losses.BinaryCrossentropy(from_logits=True),
        "metrics": "accuracy",
        "optimizer" : tf.keras.optimizers.Adam(1e-3)}, fit_args=[], fit_kwargs={"batch_size":512, "epochs":50}, 
            custom_objects={}, early_stop_cutoff=1.e-1)
info_tai_RS=RSExptai.run()
RSExptai.save()


# warafin
X_train_war=np.load("../data/X_train_warafin.npy")
y_train_war=np.load("../data/y_train_warafin.npy")
X_test_war=np.load("../data/X_test_warafin.npy")
y_test_war=np.load("../data/y_test_warafin.npy")
outliers_war=np.load("../data/warafin_outliers.npy")

war_Data=make_datalib("war2", X_train_war, X_test_war, y_train_war, y_test_war)
del X_train_war, X_test_war, y_train_war, y_test_war


LufExpwar=LUFExperiment('100', war_Data, indices=outliers_war, num_trials=None, seed=42,
             model_args=[], model_kwargs={},
            compile_kwargs={"loss": tf.keras.losses.CategoricalCrossentropy(from_logits=True),
        "metrics": "categorical_accuracy",
        "optimizer" : tf.keras.optimizers.Adam(1e-3)}, fit_args=[], fit_kwargs={"batch_size":128, "epochs":100}, 
            custom_objects={}, early_stop_cutoff=1.e-1)
info_war=LufExpwar.run()
LufExpwar.save()

RSExpwar=RSExperiment('100', war_Data, num_trials=500, seed=42,
             model_args=[], model_kwargs={},
            compile_kwargs={"loss": tf.keras.losses.CategoricalCrossentropy(from_logits=True),
        "metrics": "categorical_accuracy",
        "optimizer" : tf.keras.optimizers.Adam(1e-3)}, fit_args=[], fit_kwargs={"batch_size":128, "epochs":100}, 
            custom_objects={}, early_stop_cutoff=1.e-1)
info_war_RS=RSExpwar.run()
RSExpwar.save()


FM_data=FashionMnist()

outliers_fmnist=np.load("../data/FMNIST_outliers.npy")

RSExpFM=RSExperiment('(20,5).p.d25.(50,5).p.d25.200.d50', FM_data, num_trials=200, seed=42,
             model_args=[], model_kwargs={},
            compile_kwargs={"loss": tf.keras.losses.CategoricalCrossentropy(from_logits=True),
        "metrics": "categorical_accuracy",
         "optimizer" : tf.keras.optimizers.SGD()}, fit_args=[], fit_kwargs={"batch_size":64, "epochs":50}, 
            custom_objects={}, early_stop_cutoff=1.e-1)
info_FM_RS=RSExpFM.run()
RSExpFM.save()


LufExpFM=LUFExperiment('(20,5).p.d25.(50,5).p.d25.200.d50', FM_data, indices=np.array(outliers_fmnist), num_trials=None, seed=42,
             model_args=[], model_kwargs={},
            compile_kwargs={"loss": tf.keras.losses.CategoricalCrossentropy(from_logits=True),
        "metrics": "categorical_accuracy",
         "optimizer" : tf.keras.optimizers.SGD()}, fit_args=[], fit_kwargs={"batch_size":64, "epochs":50}, 
            custom_objects={}, early_stop_cutoff=1.e-1)
info_FM=LufExpFM.run()
LufExpFM.save()



