# All results are copied from the Results excel sheet
# These results are not shared in the corresponding papers - should we publish them?
from scipy.stats import mannwhitneyu

def test(a, b, name):
	p = mannwhitneyu(a, b, alternative='greater', method='exact').pvalue
	print(f"{name}:", p < 0.05, p)

mnist_add_4_plia = [
	0.921599984,
	0.914399981,
	0.922399998,
	0.930400014,
	0.923200011,
	0.914399981,	
	0.924799979,
	0.913600028,
	0.903199971,
	0.916000009,
]

mnist_add_4_nesymdm = [
	0.931962025,
	0.901898734,
	0.925632911,
	0.922468354,
	0.935126582,
	0.920886076,
	0.933544304,
	0.926424051,
	0.931962025,
	0.919303797,
]

mnist_add_4_anesi = [
	0.909810127,
	0.921677215,
	0.935917722,
	0.920094937,
	0.928006329,
	0.921677215,
	0.933544304,
	0.922468354,
	0.926424051,
	0.936708861,
]

mnist_add_4_dsl = [
	0.944,
	0.9448,
	0.94,
	0.928,
	0.9328,
	0.9328,
	0.9328,
	0.9296,
	0.9392,
	0.9304,
]

test(mnist_add_4_anesi, mnist_add_4_nesymdm, "A-NeSI vs NESymDM (4-digit addition)")
test(mnist_add_4_anesi, mnist_add_4_plia, "A-NeSI vs P-LIA (4-digit addition)")
test(mnist_add_4_dsl, mnist_add_4_nesymdm, "DSL vs NESymDM (4-digit addition)")
test(mnist_add_4_dsl, mnist_add_4_anesi, "DSL vs A-NeSI (4-digit addition)")
test(mnist_add_4_dsl, mnist_add_4_plia, "DSL vs P-LIA (4-digit addition)")


mnist_add_15_plia = [
	0.769696951,
	0.766666651,
	0.818181813,
	0.803030312,
	0.769696951,
	0.806060612,
	0.781818211,
	0.790909111,
	0.800000012,
	0.793939412,
]

mnist_add_15_nesymdm = [
	0.770146523,
	0.745650184, 
	0.779075095,
	0.777701466,
	0.769459707,
	0.796245422,
	0.775412088,
	0.767170333,
	0.761217952,
]

mnist_add_15_anesi = [
	0.782967034,
	0.791895605,
	0.805173993,
	0.787545789,
	0.737637364,
	0.71474359,
	0.773351649,
	0.737637364,
	0.760531136,
	0.792582418
]

mnist_add_15_dsl = [
	0.7545,
	0.7455,
	0.7844,
	0.7784,
	0.7874,
	0.7874,
	0.7605,
	0.7814,
	0.7784,
	0.7545,
]

test(mnist_add_15_plia, mnist_add_15_anesi, "PLIA vs ANesi (15-digit addition)")
test(mnist_add_15_plia, mnist_add_15_nesymdm, "PLIA vs NESymDM (15-digit addition)")
test(mnist_add_15_plia, mnist_add_15_dsl, "PLIA vs DSL (15-digit addition)")
pp_12_nesymdm = [
	0.993999988,
	0.993999988,
	0.992999986,
	0.994999993,
	0.993999988,
	0.994999993,
	0.993999988,
	0.993999988,
	0.993999988,
	0.993999988,
]

pp_12_anesir = [
	0.995000005,
	0.994166672,
	0.99333332,
	0.995000005,
	0.994166652,
	0.994166672,
	0.99333332,
	0.995000005,
	0.951666653,
	0.991666655,
]

pp_12_anesi = [
	0.984999955,
	0.975833297,
	0.969166636,
	0.963333309,
	0.963333309,
	0.929166655,
	0.929166655,
	0.929166655,
	0.923333307,
	0.919999977,
	0.898333311,
]

pp_12_imle = [
	0.973,
	0.975,
	0.973,
	0.964,
	0.977,
]

test(pp_12_nesymdm, pp_12_anesir, "NESymDM vs A-NeSIRLOO (path-planning 12x12)")
test(pp_12_nesymdm, pp_12_imle, "NESymDM vs IMLE (path-planning 12x12)")

pp_30_nesymdm = [
	0.997,
	0.984,
	0.983,
	0.96,
	0.984,
	0.984,
	0.981,
	0.984,
	0.96,
	0.981,
]

pp_30_anesir = [
	0.984999955,
	0.971666634,
	0.964999974,
	0.959166646,
	0.94749999,
	0.933333317,
	0.250833328,
	0.24999999,
	0.248333325,
	0.246666665,
]

pp_30_imle = [
	0.935,
	0.933,
	0.932,
	0.938,
	0.942,
]

test(pp_30_nesymdm, pp_30_anesir, "NESymDM vs A-NeSi RLOO (path-planning 30x30)")
test(pp_30_nesymdm, pp_30_imle, "NESymDM vs IMLE (path-planning 30x30)")

yacc_half_sl = [
	0.997619048,
	0.995238095,
	0.995238095,
	0.997619048,
	0.995238095,
]

yacc_half_sl_b = [
	0.997619048,
	0.997619048,
	0.997619048,
	0.997619048,
	0.997619048,
]

yacc_half_dpl_b = [
	0.992857143,
	0.99047619,
	0.99047619,
	0.99047619,
	0.99047619,
]

test(yacc_half_sl_b, yacc_half_sl, "SL vs SL-B (yacc half)")
test(yacc_half_sl_b, yacc_half_dpl_b, "SL-B vs DPL-B (yacc half)")

wacc_half_uncond_nesymdm = [
	0.890046296,
	0.849537037,
	0.8125,
	0.675925926,
	0.775462963,
	0.876157407,
	0.782407407,
	0.732638889,
	0.788194444,
]

wacc_half_cond_nesymdm = [
	0.721064815,
	0.71412037,
	0.710648148,
	0.71412037,
	0.716435185,
	0.719907407,
	0.719907407,
	0.662037037,
	0.717592593,
	0.719907407,
]

test(wacc_half_uncond_nesymdm, wacc_half_cond_nesymdm, "NESymDM vs NESymDM-cond (wacc half)")

waccood_half_cond_nesymdm = [
	0.625459559,
	0.605698529,
	0.618566176,
	0.620404412,
	0.619944853,
	0.619944853,
	0.624080882,
	0.633272059,
	0.604319853,
	0.612591912,
]

waccood_half_uncond_nesymdm = [
	0.576286765,
	0.574908088,
	0.574908088,
	0.569393382,
	0.560661765,
	0.5703125,
	0.572150735,
	0.571231618,
	0.577665441,
]

test(waccood_half_cond_nesymdm, waccood_half_uncond_nesymdm, "NESymDM-cond vs NESymDM-uncond (wacc ood half)")

yacc_short_sl_b = [
	0.9875,
	0.982291667,
	0.990625,
	0.9875,
	0.985416667,
]

yacc_short_nesymdm = [
	0.9875,
	0.977083333,
	0.985416667,
	0.9875,
	0.982291667,
	0.984375,
	0.973958333,
	0.984375,
	0.980208333,
	0.984375,
]

test(yacc_short_sl_b, yacc_short_nesymdm, "SL-B vs NESymDM (short)")

cacc_ood_short_nesymdm = [
	0.141865079,
	0.134424603,
	0.140079365,
	0.15952381,
	0.141269841,
	0.148214286,
	0.139384921,
	0.14702381,
	0.132936508,
	0.140575397,
]

cacc_ood_short_dplb = [
	0.100198413,
	0.089880952,
	0.103571429,
	0.055357143,
	0.119146825,
]

test(cacc_ood_short_nesymdm, cacc_ood_short_dplb, "NESymDM vs DPL-B (short, cacc ood)")

yacc_bdd_dpl = [
	0.640014081,
	0.62132299,
	0.615922187,
	0.648837856,
	0.644715563,
	0.65199617,
]

yacc_bdd_nesymdm = [
	0.621690461,
	0.632901684,
	0.626180626,
	0.622636166,
	0.625922159,
	0.637555512,
	0.626851942,
	0.619831063,
	0.625517697,
	0.624338388,
]

test(yacc_bdd_dpl, yacc_bdd_nesymdm, "DPL vs NESymDM (BDD yacc)")

ecec_nesymdm = [
	0.222636908,
	0.201457813,
	0.231547698,
	0.240281016,
	0.209866777,
	0.208245143,
	0.180578977,
	0.23811622,
	0.224961847,
	0.213900656,
]

ecec_dpl_b = [
	0.160366501,
	0.158168658,
	0.158602313,
	0.160006346,
	0.163632999,
	0.159078373,
]

test(ecec_nesymdm, ecec_dpl_b, "NESymDM vs DPL-B (ecec)")

###### Majority voting
tmp_half_id_uncond = [
	0.993055556,
	0.99537037,
	0.99537037,
	0.993055556,
	0.990740741,
	0.993055556,
	0.99537037,
	0.988425926,
	0.993055556,
]

ptm_half_id = [
	0.993055556,
	0.993055556,
	0.990740741,
	0.993055556,
	0.988425926,
	0.988425926,
	0.993055556,
	0.990740741,
	0.990740741,
	0.990740741,
]

tmp_half_id = [
	0.990740741,
	0.988425926,
	0.986111111,
	0.988425926,
	0.983796296,
	0.988425926,
	0.990740741,
	0.990740741,
	0.990740741,
	0.988425926,
]

test(tmp_half_id_uncond, ptm_half_id, "tmp_uncond vs ptm_cond (half id yacc)")

mmp_half_ood_uncond = [
	0.523897059,
	0.455882353,
	0.450367647,
	0.371323529,
	0.427389706,
	0.493566176,
	0.458639706,
	0.386948529,
	0.455882353,
]

mmp_half_ood = [
	0.346507353,
	0.322610294,
	0.341911765,
	0.327205882,
	0.337316176,
	0.333639706,
	0.321691176,
	0.355698529,
	0.317095588,
	0.311580882,
]

ptm_half_ood = [
	0.291360294,
	0.274816176,
	0.282169118,
	0.28125,
	0.282169118,
	0.280330882,
	0.288602941,
	0.306066176,
	0.276654412,
	0.28125,
]

test(mmp_half_ood_uncond, mmp_half_ood, "mmp_uncond vs mmp_cond (half ood)")


ptm_short_id = [
	0.982291667,
	0.984375,
	0.985416667,
	0.985416667,
	0.985416667,
	0.985416667,
	0.99375,
	0.9875,
	0.988541667,
]
tmp_short_id = [
	0.979166667,
	0.96875,
	0.982291667,
	0.976041667,
	0.980208333,
	0.985416667,
	0.976041667,
	0.984375,
	0.979166667,
	0.982291667,
]

tmp_short_id_uncond = [
	0.979166667,
	0.980208333,
	0.983333333,
	0.984375,
	0.984375,
	0.985416667,
	0.980208333,
	0.979166667,
	0.98125,
	0.972916667,
]

test(ptm_short_id, tmp_short_id, "ptm vs tmp (short id)")
test(ptm_short_id, tmp_short_id_uncond, "ptm vs tmp uncond (short id)")


mmp_short_ood_cond = [
	0.053571429,
	0.049007937,
	0.049007937,
	0.054166667,
	0.060515873,
	0.061904762,
	0.053571429,
	0.054761905,
	0.053769841,
	0.048611111,
]

mmp_short_ood_uncond = [
	0.055753968,
	0.043650794,
	0.048611111,
	0.050396825,
	0.045833333,
	0.058531746,
	0.056150794,
	0.056349206,
	0.055753968,
	0.056349206,
]

test(mmp_short_ood_cond, mmp_short_ood_uncond, "mmp_cond vs mmp_uncond (short ood)")

tm_half_id_uncond = [
	0.890046296,
	0.849537037,
	0.8125,
	0.675925926,
	0.775462963,
	0.876157407,
	0.782407407,
	0.732638889,
	0.788194444,
]

mm_half_id_uncond = [
	0.869212963,
	0.854166667,
	0.825231481,
	0.702546296,
	0.770833333,
	0.854166667,
	0.795138889,
	0.765046296,
	0.829861111,
]

test(tm_half_id_uncond, mm_half_id_uncond, "tm_uncond vs mm_uncond (half id)")

mm_half_ood_uncond = [
	0.745863971,
	0.714613971,
	0.710477941,
	0.663143382,
	0.694393382,
	0.734834559,
	0.713694853,
	0.670496324,
	0.714613971,
]

mm_half_ood_cond = [
	0.641084559,
	0.621783088,
	0.630514706,
	0.628676471,
	0.6328125,
	0.635569853,
	0.619025735,
	0.628216912,
	0.617647059,
	0.620863971,
]

test(mm_half_ood_uncond, mm_half_ood_cond, "mm_uncond vs mm_cond (half ood)")

tm_short_id_cond = [
	0.188541667,
	0.209375,
	0.1984375,
	0.227604167,
	0.208333333,
	0.195833333,
	0.190104167,
	0.219791667,
	0.189583333,
	0.205208333,
]

mm_short_id_cond = [
	0.170833333,
	0.200520833,
	0.202083333,
	0.252604167,
	0.1890625,
	0.2109375,
	0.186458333,
	0.199479167,
	0.1765625,
	0.176041667,
]

test(tm_short_id_cond, mm_short_id_cond, "tm_cond vs mm_cond (short id)")

tm_short_ood_cond = [
	0.15406746,
	0.158730159,
	0.146527778,
	0.171924603,
	0.158134921,
	0.150396825,
	0.148313492,
	0.163988095,
	0.140575397,
	0.167361111,
]

mm_short_ood_cond = [
	0.146825397,
	0.134623016,
	0.145039683,
	0.158234127,
	0.150198413,
	0.148015873,
	0.155952381,
	0.141964286,
	0.130456349,
	0.14484127,
]

test(tm_short_ood_cond, mm_short_ood_cond, "tm_cond vs mm_cond (short ood)")

bdd_wf1_bears = [
	0.192136572,
	0.193426201,
	0.189519207,
	0.194154434,
	0.1925638,
	0.193392739,
]

bdd_wf1_nesymdm_uncond = [
	0.187727689,
	0.186394366,
	0.188163266,
	0.188621933,
	0.185789692,
	0.185497809,
	0.188496951,
	0.185770798,
	0.187143523,
	0.188122245,
]

test(bdd_wf1_bears, bdd_wf1_nesymdm_uncond, "bdd_wf1_bears vs bdd_wf1_nesymdm_uncond")
