#!/bin/bash

baseModel='LLAVA'
# baseModel='openFlamingo'

modelPath=${1}
if [ -z "${modelPath}" ]
then
      echo "\$modelPath is empty Using robust model from here: "
      modelPath=/inspire/hdd/global_user/usr-240108540162/RobustVLM-HF-4090/output/ViT-L-14_imagenet_l2_pgd_hf4090_7_0_sBBxT-FARE1/checkpoints/final.pt
      modelPath1=FARE
      # modelPath=/inspire/hdd/global_user/usr-240108540162/offline/clip-vit-large-patch14
      # modelPath1=CLIP
      # modelPath=/inspire/hdd/global_user/usr-240108540162/RobustVLM-HF-4090/output/ViT-L-14_imagenet_ce_pgd_final-pgd_2_0_ijOf2/checkpoints/final.pt
      # modelPath1=TeCoA
      # modelPath=/inspire/hdd/global_user/usr-240108540162/RobustVLM/output/ViT-L-14_imagenet_l2_pgd_fintune_final-3all-Template1-l2-bs64_42_0_WAIZm/checkpoints/final.pt
      # modelPath1=HOT
else
      echo "\$modelPath is NOT empty"
      modelPath1=${modelPath}
fi

answerFile="${baseModel}_${modelPath1}"
echo "Will save to the following json: "
echo $answerFile

CUDA_VISIBLE_DEVICES=1 python -m llava.eval.model_vqa_loader \
    --model-path /inspire/hdd/global_user/usr-240108540162/RobustVLM-HF-4090/llava/llava-v1.5-7b \
    --eval-model ${baseModel} \
    --pretrained_rob_path ${modelPath} \
    --question-file ./pope_eval/llava_pope_test.jsonl \
    --image-folder /inspire/hdd/global_user/usr-240108540162/COCO/val2014 \
    --answers-file ./pope_eval/${answerFile}.jsonl \
    --temperature 0 \
    --conv-mode vicuna_v1


CUDA_VISIBLE_DEVICES=1 python llava/eval/eval_pope.py \
    --model-name $answerFile \
    --annotation-dir ./pope_eval/coco/ \
    --question-file ./pope_eval/llava_pope_test.jsonl \
    --result-file ./pope_eval/${answerFile}.jsonl