import argparse
from typing import Any, Dict

def parse_args() -> Dict[str, Any]:
    parser = argparse.ArgumentParser()

    # environment
    parser.add_argument("--env_name", type=str, default="virtualhome")
    parser.add_argument("--env_ip", type=str, default="127.0.0.1")
    parser.add_argument("--env_port", type=int, default=8080)
    # continual settings
    parser.add_argument("--continual_type", type=str, default="behavior")
    parser.add_argument("--continual_seq", type=str, default="sequence_1")
    parser.add_argument("--continual_set", type=str, default="set_1")
    parser.add_argument("--continual_eval_set", type=str, default=None)
    # dataset
    parser.add_argument("--dataset_dir", type=str, default=None)
    parser.add_argument("--num_topk_edge", type=int, default=6)
    parser.add_argument("--thinking", action="store_true")
    parser.add_argument("--max_think_token", type=int, default=200)
    parser.add_argument("--dataset_size", type=float, default=None)
    parser.add_argument("--percent", type=float, default=1.0)
    # base model
    parser.add_argument("--algo", type=str, default="Ours")
    parser.add_argument("--model_name", type=str, default="Qwen/Qwen2.5-0.5B")
    parser.add_argument("--pi_model_name", type=str, default="Qwen/Qwen2.5-0.5B")
    parser.add_argument("--vf_model_name", type=str, default="Qwen/Qwen2.5-0.5B")
    parser.add_argument("--output_dir", type=str, default=None)
    parser.add_argument("--tag", type=str, default="test")
    parser.add_argument("--prev_tag", type=str, default=None)
    parser.add_argument("--checkpoint", type=int, default=20)
    # training
    parser.add_argument("--warmup", action="store_true")
    parser.add_argument("--batch_size", type=int, default=1)
    parser.add_argument("--phase", type=int, default=1)
    parser.add_argument("--seqft", type=int, default=1)
    parser.add_argument("--ablation", type=int, default=0) 
    parser.add_argument("--base_ablation", type=int, default=0) # base reasoning-policy abl
    parser.add_argument("--dataset_ablation", action="store_true")
    # inference
    parser.add_argument("--correct", action="store_true")
    parser.add_argument("--no_correct", action="store_true")
    parser.add_argument("--no_critic", action="store_true")
    parser.add_argument("--eval_episode", type=int, default=4)
    parser.add_argument("--test_time_control", action="store_true")
    parser.add_argument("--test_time_update", action="store_true")
    parser.add_argument("--total_think", type=int, default=5)
    # msic
    parser.add_argument("--seed", type=int, default=123)
    parser.add_argument("--wandb_off", action="store_true")
    parser.add_argument("--train", action="store_true")
    parser.add_argument("--test", type=str, default=None) # seen or unseen
    parser.add_argument("--evaluate", type=str, default=None) # seen or unseen or both
    parser.add_argument("--perturb", action="store_true") # perturn the input
    
    args = parser.parse_args()
    return args
