import os
from embodied_cd.common import argparse
from embodied_cd.common.print_utils import *


args = argparse.parse_args()

config = {}
with open(f"./configs/{args.env_name}/{args.continual_type}_train.py", "r") as f:
    code = f.read()
exec(code, config)
sequences = config["sequences"][args.continual_seq]

if args.algo == 'ECoC-Think-Whole':
    prefix = f"./results/ECoC-Fine/Think-Whole/{args.env_name}/{args.continual_type}_{args.continual_seq}"
elif args.algo == 'ECoC-Think-Two':
    prefix = f"./results/ECoC-Fine/Think-Two-Step/{args.env_name}/{args.continual_type}_{args.continual_seq}"
elif args.algo == 'ECoC-Think-Three':
    prefix = f"./results/ECoC-Fine/Think-Three-Step/{args.env_name}/{args.continual_type}_{args.continual_seq}"
else:
    prefix = f"./results/{args.algo}/{args.env_name}/{args.continual_type}_{args.continual_seq}"

print_error("=" * 50)
for seq in sequences:
    path = prefix + f"/{seq}_{args.pi_model_name.split('/')[-1]}_{args.tag}/results" 
    
    print_check(f"\n\n>> {args.env_name} {args.continual_type}: Sequence {args.continual_seq}, Set {seq}")
    
    path_dir = path + "/evaluation_seen"
    if args.perturb:
        path_dir = path_dir + "_perturb"
    if args.test_time_control:
        path_dir = path_dir + "_control"
    if args.total_think != 5:
        path_dir = path_dir + f"_think{args.total_think}"
    if args.correct: 
        path_dir = path_dir + "_correct" 
    path_dir = path_dir + ".txt"
    print(path_dir)

    if os.path.isfile(path_dir):
        with open(path_dir, "r") as f:
            lines = f.readlines()
            if "Total Results" in lines[-10]:
                print("="*20)
                print_pass(f"[[Seen Results]]")
                for line in (lines[-9:]):
                    print(line, end="")
            elif "Total Results" in lines[-11]:
                print("="*20)
                print_pass(f"[[Seen Results]]")
                for line in (lines[-10:]):
                    print(line, end="")

    path_dir = path + "/evaluation_unseen"
    if args.perturb:
        path_dir = path_dir + "_perturb"
    if args.test_time_control:
        path_dir = path_dir + "_control"
    if args.total_think != 5:
        path_dir = path_dir + f"_think{args.total_think}"
    if args.correct: 
        path_dir = path_dir + "_correct" 
    path_dir = path_dir + ".txt"
    print(path_dir)

    if os.path.isfile(path_dir):
        with open(path_dir) as f:
            lines = f.readlines()
            if "Total Results" in lines[-10]:
                print("="*20)
                print_warn(f"[[Unseen Results]]")
                for line in (lines[-9:]):
                    print(line, end="")
            elif "Total Results" in lines[-11]:
                print("="*20)
                print_warn(f"[[UnSeen Results]]")
                for line in (lines[-10:]):
                    print(line, end="")
