# **A**mortized **B**ayesian **C**ausal **D**iscovery of **E**xtended **F**actor **G**raphs (ABCDEFG)
This repository includes the following:
1. Main package `abcdefg`
    * Implementation of the method
    * Data simulation methods
2. `make_fg_data.py`: Main script for regenerating datasets used in our paper
3. `run_abcdefg.py`: Main script for training and evaluation
4. `evaluate.py`: Wrapper for collecting results from different runs

## Installation 
To keep anonymity, the package only supports local installation:
```
pip install .
```

## Usage
### Data Simulation
We reported four types of simulations -- interventional data with **known/unknown** targets and a true causal graph sampled from an **SPN-FG/canonical f-DAG** model. To generate these datasets, simply run
```
python make_fg_data.py -i 0 1 2 3 --data-dir <DATA_DIR>
```

### Training ABCDEFG
Each simulated data will be saved in a subdirectory under  `<DATA_DIR>` with a format of ```<DATA_DIR>/<SIMULATION_TYPE>/n<N>_m<M>_<I>``` where `N`, `M` and `I` are the number of nodes, factors and dataset index. 

To train ABCDEFG with known intervention targets, simply run
```
python run_abcdefg \
    -i `<DATA_DIR>/<SIMULATION_TYPE>/n<N>_m<M>_<I> \
    -o <OUT_DIR> \
    -g DAG<I>.npy -d <I> \
    -m <M> \
    -e <NUM_EPOCHS> \
    --graph-model SPNFG \
    --coeff_l1_reg <COEFF_L1_REG> \
```

To train ABCDEFG with unknown intervention targets, run
```
python run_abcdefg \
    -i `<DATA_DIR>/<SIMULATION_TYPE>/n<N>_m<M>_<I> \
    -o <LOG_DIR> \
    -g DAG<I>.npy -d <I> \
    -m <M> \
    -e <NUM_EPOCHS> \
    --num-untargeted-intv <K> --intv-target factor \
    --graph-model SPNFG \
    --coeff_l1_reg <COEFF_L1_REG> \
```

To collect evaluation metrics, run
```
python evaluate.py -o <LOG_DIR> --eval-metric none --fix-type <SIMULATION_TYPE_1> ...
```