living_room_generation_prompt = """
Generate a dataset of 20 living room layouts in JSON format. The output should be a JSON list where each element is a dictionary representing a single layout.

**Layout Structure:**

Each layout dictionary must contain the following keys:
* `layout_id`: An integer uniquely identifying the layout (start from 0).
* `room`: A dictionary describing the room dimensions and shape.
* `objects`: A list of dictionaries, each describing an object placed within the living room.

**`room` Dictionary Details:**
* `width`: A float representing the width of the room in meters (between 2.5 and 6.0).
* `depth`: A float representing the depth of the room in meters (between 2.5 and 6.0).
* `units`: A string, fixed value `"meters"`.
* `shape`: String, must be one of `"rectangular"`, `"L-shape"`, or `"open"`.
* `shape_description`: A string summarizing the room's shape, including details of cutouts or open walls (e.g., "Rectangular living room", "L-shaped room with a 1.5x1.5 cutout at the `"top-right"` (or any other corner) corner (x=3.0-4.5, y=2.5-4.0)", "Open living room (`"top"` wall removed, or `"left"`, or `"right"`, or `"bottom"`.)").

**`objects` List Details:**
Each dictionary in the `objects` list must describe an object and include the keys: `"label"`, `"bbox"`: [y0, x0, y1, x1] and `"comment"` about location.

Coordinate system
"coordinate_system": {
    "y_axis": "depth (vertical, top to bottom)",
    "x_axis": "width (horizontal, left to right)",
    "origin": "(0, 0) - top-left corner",
    "x_range": "[0, width]",
    "y_range": "[0, depth]"
  }

* **Possible `"label"` values:**
    * `"cutout_area"`: Represents the removed area in L-shaped rooms.
    * `"door"`: Represents a doorway into the living room.
    * `"window"`: Represents an opening in a wall that allows the exchange of light and may also allow the passage of sound and sometimes air.
    * `"fireplace"`: Represents a structure made of brick, stone or metal designed to contain a fire.

* ** Recommended room sizes (according to DIN 18011) in square meters depending on the number of residents**
    * 2 residents: 20 m²
    * 3 residents: 20 m²
    * 4 residents: 22 m²
    * 5 residents: 24 m²
    * 6 residents: 24 m²
    * 7 residents: 24 m²

**Constraints and Requirements:**

0. **Room size** - generate different room sizes: small living rooms (20m² or less), medium living rooms (22 m²), and big living rooms (24 m²). Generate different proportions for the width and depth.
1. **Quantity & Distribution:** Generate exactly 20 layouts: 40% rectangular, 40% L-shaped, and 20% open.
2. **L-Shapes:** Cutout areas must be placed in one of the four corners. The remaining 'legs' of the L-shape must each have a minimum width and depth of 1.5 meters.
3. **Doors:** Layouts where the `living_room_layout` object has `shape` `"rectangular"` or `"L-shape"` must contain at least one object of type `"door"`. There can be several doors. Layouts where the `shape` is `"open"` can have **zero** or more objects of type `"door"`.
4. **Door/Window Walls:** In layouts with a door, objects of type `"window"` cannot be placed on the same wall as the object of type `"door"`.
5. **Fireplace:**
   - If the room has a fireplace, it must be included in the layout. The fireplace must be placed on a wall.
   - A fireplace cannot overlap with a door or window.
6. **Window Area Ratio:**  
   - Total window length must be **>15%** of the floor area. Floor area = (room width × room depth) minus any cutout areas.
7. **Window Grouping and Sizes:**
   - Windows on the **same wall** **must** be of **equal size**.
   - **One small window** (less than 1m) alone in the room is **not allowed**, it's impossible.
   - **One large** window is OK; **two small** windows are OK, more windows are OK.
   - If window width exceeds **1.5m**, split it into **multiple standard windows** (0.6m, 0.75m, 0.9m, or 1.2m wide).
   - Add small gaps (0.05m–0.15m) between windows.
8. **Window Placement:**
   - Do **not** place windows on **opposite walls**.
   - Multiple windows should either be on the **same** or on two **adjacent** walls.
9. **Doors, Windows and Fireplace short size:** For simplicity, the short size of a door is *0.1m*, the short size of a window is *0.0m*, and the short size of a fireplace is *0.2m*.
10. **Validity:** All objects must be placed strictly within the usable room boundaries (considering cutouts for L-shapes). Door widths (where present) should be between 0.8m and 1.0m.
11. **Output Format:** The final output must be a single, valid JSON list containing the 20 layout dictionaries, with no comments (`/* ... */`) included.
Example:

{
  "layout_id": 1,
  "room": {
    "width": 4.0,
    "depth": 6.0,
    "units": "meters",
    "shape": "rectangular",
    "shape_description": "Rectangualar living room",
    "num_people": 5
  },
  "coordinate_system": {
    "y_axis": "depth (vertical, top to bottom)",
    "x_axis": "width (horizontal, left to right)",
    "origin": "(0, 0) - top-left corner",
    "x_range": "[0, 4.0]",
    "y_range": "[0, 6.0]"
  },
  "objects": [
    {
      "label": "door",
      "bbox": [0.0, 0.1, 0.1, 1.0],
      "comment": "The single door is placed on the top wall (y=0), near the left corner, allowing ingress/egress without obstructing the main L-shaped counter area."
    },
    {
      "label": "window",
      "bbox": [0.5, 0.0, 2.0, 0.0],
      "comment": "A window on the left wall (x=0), enhancing natural light, particularly near the eating area. Total window length meets the requirement (>15% of area)."
    }
  ]
}
"""

# ==============================================================================
# ADAPTED PROMPT FOR LIVING ROOM LAYOUTS
# ==============================================================================

living_room_layout_generation_prompt = """
# Objective: Given the selected living room layout style, generate the JSON for a 2D bird-view living room layout with objects positioned appropriately, and include insightful comments about object placements (as a field of an object JSON).

## Object properties required in JSON:
- "label" (e.g., "door", "window", "sofa", "loveseat", "armchair", "coffee_table", "side_table", "tv_stand", "television", "bookshelf", "rug", "floor_lamp", "table_lamp", "fireplace", "plant", "ottoman", "foot_stool", "bar_cart", "recamiere", "pouf", "bean bag")
- "bbox": [y0, x0, y1, x1]

### Room details:
{room_details}

*Don`t delete any information from the room details and room objects.*
*If a fireplace is present in room_details, it MUST be included and treated as a potential focal point.*
*If TV is requested or implied by the layout style, include a "television" and a "tv_stand" (or indicate wall-mount in comment).*

### Layout style:
{layout_style}

{living_room_layout_specifics}

## Object positioning considerations:
- **General Object Shape:**
    - Each object must be defined using a rectangular bounding box [y0, x0, y1, x1]
    - In case an object does not have a rectangular footprint (e.g. an L-shaped sofa), the objects must be split into rectangular shapes and be defined using several rectangular objects
- **General Clearances & Overlap:**
    - Floor-standing objects (sofas, tables, stands, large lamps, etc.) must not overlap.
    - Rugs can be under other furniture. Small decor items (like table lamps on side tables) are considered part of the larger item and don't need separate overlap checks if their bbox is within the table's.
    - Chairs/armchairs should not overlap with each other unless they are part of a sectional configuration (which would be a single "sofa" object label).
    - Ensure clear pathways (traffic flow) of at least 0.8 meters wide, especially from doors to main seating areas and other exits/entrances.
- **Door Clearance:**
    - Ensure a clear space of at least 0.8 meters in front of the door (on the swing side, if specified, otherwise assume inward swing) to allow it to open fully without obstruction.
- **Seating Area Clearances:**
    - Ensure a minimum clearance of 0.6 to 0.8 meters around seating areas (sofas, armchairs) for comfortable movement and access.
    - Coffee table should be placed 0.4-0.5 meters from the sofa/loveseat for easy reach but enough legroom.
- **Focal Points:**
    - Living rooms often have focal points (e.g., TV, fireplace, large window with a view). Seating should generally be oriented towards the primary focal point.
    - If a "television" is placed, consider viewing distance (e.g., 1.5-2.5 times the screen diagonal, though this is a general guideline, prioritize comfortable arrangement within room constraints).
    - Avoid placing a "television" directly opposite a large, bright "window" to minimize glare, unless unavoidable.
- **Object Placement Strategy:**
    - **Large Furniture First:** Position largest items first (e.g., "sofa").
    - **Anchor with Rug:** A "rug" can help define the main seating area; it should be large enough that at least the front legs of the main seating furniture (sofa, armchairs) are on it. Leave a border of 0.3-0.5m from walls if possible.
    - **Sofas & Loveseats:** Often placed against a wall or used to divide a larger space. Consider views and focal points.
    - **Armchairs:** Can complement sofas, create separate seating nooks, or flank a focal point.
    - **Coffee Table:** Typically centered in front of the main sofa or within a seating arrangement.
    - **Side Tables:** Placed next to sofas or armchairs for lamps or convenience.
    - **TV Stand / Television:** Should be placed against a suitable wall if possible or in a dedicated media unit. Ensure it doesn't obstruct major pathways.
    - **Bookshelves/Storage:** Should be placed against walls if possible.
    - **Lamps:** Position "floor_lamp"s and "table_lamp"s to provide adequate lighting for different zones (reading, ambient).
    - **Windows:** Maximize natural light. Seating can be oriented to enjoy a view if a window offers one. Avoid blocking windows with tall furniture unless necessary.
- **Cutout Area:** If a cutout area is defined in `room_details`, it isn't part of the usable floor area, though the sides facing the inside of the room can be used as regular walls.
- **Symmetry & Balance:** Consider visual balance in the arrangement, though strict symmetry is not always required or desired.
- **Conversational Groupings:** Arrange seating to facilitate conversation. For example, sofas and armchairs facing each other or in an L or U shape.
- **Traffic Flow Priority:** Non-overlap rules and clearance rules for pathways have a higher priority than ideal object placement according to style guides if space is very constrained. The room must remain functional.

## Mandatory Evaluation Steps & Strict Priority Rules:
1.  **Absolute Clearance Priority:** Minimum clearances (0.8m for pathways/doors, 0.6-0.8m around seating, 0.4-0.5m for coffee table access) are **non-negotiable and inviolable**. This check must be performed *after* placing essential items and *before* considering any optional items.
2.  **Essential Objects:** Placement of primary seating (e.g., `"sofa"`, `"loveseat"`) and the primary focal point (e.g., `"television"` setup, `"fireplace"`) according to their specific rules and the chosen layout style is the next priority.
3.  **Secondary Elements (Core Furniture):** Placement of items like `"coffee_table"`, `"armchair"`s (if not primary), `"side_table"`s, and main storage (e.g., `"tv_stand"`, `"bookshelf"`) according to their specific rules is the next priority. Ensure good grouping and functionality.
4.  **Ancillary Elements & Refinements (e.g., Lighting, Decor):** Smaller elements like `"rug"`, `"floor_lamp"`, `"table_lamp"`, `"plant"`, `"ottoman"` should ONLY be considered *after* all mandatory clearances and essential/secondary object placements are successfully accommodated without conflict.

  *   **Step 1:** After placing essential furniture (sofas, focal point) and defining their required clearance zones, AND defining door clearance zones, calculate the remaining UNRESTRICTED floor area.
  *   **Step 2:** Evaluate if this unrestricted area can comfortably fit secondary and ancillary elements according to the chosen layout style and general principles.
  *   **Step 3:** **IF AND ONLY IF** the space is sufficient, THEN attempt to include these elements thoughtfully. **OTHERWISE, prioritize core functionality and clearances, and omit less critical items or use smaller versions if possible.**

## Ancillary Element Placement Strategy (Only if Step 3 above is met):
    *   Position ancillary elements to enhance the functionality and aesthetics of the primary arrangement.
    *   Rugs should anchor the main seating group.
    *   Lamps should provide task or ambient lighting where needed (e.g., side table next to a sofa for a reading lamp, floor lamp in a darker corner).
    *   Plants or decorative ottomans can fill empty spaces or add visual interest, but must not impede traffic flow.
    *   **Final Check:** Re-verify that these placed items do not infringe on *any* mandatory clearance zones or obstruct pathways.

## Final review:
- Double check all object placements to ensure they are within the room boundaries and do not overlap (unless intended, like a lamp on a table).
- Ensure that all objects are placed according to the rules, layout style, and general living room design principles.
- If any object placement violates the rules, adjust the layout accordingly. You might need to choose smaller furniture sizes or omit some optional items if space is tight.
- Don't change the room size, or the size and location of pre-defined elements like doors, windows, or fireplaces from `room_details`.

Make sure to include all requested objects and their properties in the JSON output.
Don't use slash slash comments // in the JSON file.
Return only the JSON output.

OUTPUT EXAMPLE:
{living_room_layout_example}
"""

# ==============================================================================
# LIVING ROOM SPECIFIC LAYOUT STYLE DESCRIPTIONS
# These would replace l_shaped_kitchen_spec, u_shaped_kitchen_spec, etc.
# ==============================================================================

conversational_living_room_spec = """
### Conversational Living Room Configuration:
- **Primary Goal:** Create an environment conducive to conversation.
- **Main Seating:** Two "sofa"s facing each other, or a "sofa" and two "armchair"s facing each other, or an L-shaped/U-shaped sofa arrangement.
- **Focal Point:** The center of the seating group. A "coffee_table" is usually central. A "fireplace" can also serve as a secondary or primary focal point if present. A "television" might be secondary or absent, or placed to one side.
- **Arrangement:** Seating pieces should be close enough for easy conversation (e.g., within 2.5-3 meters of each other).
- **Coffee Table:** Central to the grouping.
- **Rugs:** Often used to define and unify the conversational area.
"""

fireplace_centric_living_room_spec = """
### Fireplace-Centric Living Room Configuration:
- **Primary Goal:** Emphasize the "fireplace" as the main focal point.
- **Main Seating:** "Sofa"(s) and/or "armchair"(s) arranged to face or flank the "fireplace".
- **Focal Point:** The "fireplace". A "television" might be placed above the fireplace (if appropriate) or on an adjacent wall as a secondary focal point.
- **Arrangement:** Create a cozy and inviting atmosphere around the hearth. Seating should allow comfortable enjoyment of the fireplace.
- **Coffee Table:** Positioned within the seating group.
- **Symmetry:** Often, a symmetrical arrangement around the fireplace works well (e.g., matching bookshelves or armchairs flanking it).
"""

multi_zone_living_room_spec = """
### Multi-Zone Living Room Configuration (for larger rooms):
- **Primary Goal:** Divide a larger living room into distinct functional areas (e.g., main TV/seating area, reading nook, small conversation spot, or even a small desk area).
- **Arrangement:** Use furniture placement (e.g., back of a sofa, a console table, a bookshelf) or "rug"s to visually separate zones.
- **Main Seating Zone:** Could follow TV-focused or conversational principles.
- **Secondary Zone(s):**
    - **Reading Nook:** An "armchair", a "side_table", and a "floor_lamp" or "table_lamp". Often placed in a quieter corner or near a window.
    - **Small Conversation Spot:** Two "armchair"s with a small "side_table" between them.
- **Traffic Flow:** Ensure clear pathways between zones and to exits.
- **Cohesion:** While distinct, zones should feel like part of a cohesive overall design (e.g., through consistent style, color palette).
"""

tv_focused_living_room_spec = """
### TV-Focused Living Room Configuration:
- **Primary Goal:** Optimize viewing experience for a television.
- **Main Seating:** Typically a "sofa" or "loveseat" directly facing the "television". Additional "armchair"(s) can be placed at an angle, also oriented towards the TV.
- **Focal Point:** The "television" (on a "tv_stand" or wall-mounted) is the primary focal point.
- **Coffee Table:** Placed centrally in front of the main sofa.
- **Traffic Flow:** Ensure clear paths, especially if people will be walking past the viewing area. Avoid placing seating where it blocks major thoroughfares.
- **Considerations:** Minimize glare on the TV screen from windows. Consider optimal viewing distances.
"""

# More styles could be added: e.g., Minimalist, Open-Plan Flow-Oriented, Reading-Focused, etc.

# ==============================================================================
# PROMPT FOR CHOOSING A LIVING ROOM LAYOUT STYLE
# ==============================================================================

living_room_layout_style_choice_prompt = """
Objective: Determine the most suitable living room layout style for a given room, based on dimensions, room shape, positions of doors, windows, and any fixed elements like a fireplace.

Living Room Layout Styles:
- TV-Focused: Prioritizes optimal television viewing. Good for media consumption.
- Conversational: Arranges seating to facilitate interaction. Ideal for socializing.
- Fireplace-Centric: Uses the fireplace as the primary focal point. Creates a cozy atmosphere.
- Multi-Zone (for larger rooms): Divides the space into multiple functional areas (e.g., TV area + reading nook).

Selection criteria:
- **Room Size & Shape:**
    - Smaller/Narrow rooms: Often suit a simpler TV-Focused layout or a compact Conversational L-shape.
    - Square rooms: Can accommodate Conversational layouts well (e.g., sofas facing, U-shape).
    - Large/Long rooms: May suit Multi-Zone layouts or elongated TV-Focused/Conversational arrangements.
- **Fixed Elements:**
    - **Fireplace:** If present, a Fireplace-Centric layout is often preferred, or it can be incorporated as a secondary focal point in other styles.
    - **Large Windows/Views:** Consider orienting seating towards views. A TV-Focused layout might need care to avoid window glare on the screen.
    - **Doors/Openings:** Dictate traffic flow. Layouts must not obstruct main pathways. A TV or main sofa shouldn't be placed where traffic constantly passes in front.
- **Primary Use:**
    - If primarily for watching TV/movies: TV-Focused.
    - If primarily for entertaining guests/family interaction: Conversational.
    - If a fireplace is a key feature for ambiance: Fireplace-Centric.
    - If the room needs to serve multiple purposes (e.g., relaxation, reading, occasional work): Multi-Zone (if space allows).

Output example:
{{
  "chosen_layout_style": "TV-Focused",
  "reasoning": "The room is moderately sized (4.5m x 3.5m) and rectangular. The main use is expected to be media consumption. Placing the TV on the shorter wall opposite the main sofa will provide good viewing angles while maintaining clear traffic flow from the door on the adjacent long wall. The window placement does not directly cause glare on the proposed TV wall."
}}

Determine the living room layout style based on this INPUT:
{room_input}

Return only the output in JSON format.
"""


# ==============================================================================
# EXAMPLE LIVING ROOM LAYOUTS (to be used as {living_room_layout_example})
# These would replace the kitchen examples like `open_room`, `l_shaped_room`, etc.
# ==============================================================================

rectangular_living_room_tv_focused_example = """
{
    "layout_id": "0",
    "room": {
        "width": 5.0,
        "depth": 3.8,
        "units": "meters",
        "shape": "rectangular",
        "shape_description": "Standard rectangular living room"
    },
    "coordinate_system": {
        "y_axis": "depth (vertical, top to bottom, 0 to 3.8)",
        "x_axis": "width (horizontal, left to right, 0 to 5.0)",
        "origin": "top-left corner",
        "x_range": "[0, 5.0]",
        "y_range": "[0, 3.8]"
    },
    "layout_style": {
        "chosen_layout_style": "TV-Focused",
        "reasoning": "The room is rectangular (5.0m x 3.8m). A TV-focused layout is suitable. The TV is placed on the right short wall. The main sofa is opposite, maximizing viewing comfort. A door on the top wall and a window on the left wall do not significantly interfere with this arrangement."
    },
    "objects": [
        {
            "label": "door",
            "bbox": [0.0, 1.0, 0.0, 1.8],
            "comment": "Entrance door on the top wall, swings inwards."
        },
        {
            "label": "window",
            "bbox": [1.0, 0.0, 2.8, 0.0],
            "comment": "Large window on the left wall providing natural light."
        },
        {
            "label": "tv_stand",
            "bbox": [1.4, 4.4, 2.4, 5.0],
            "comment": "TV stand (0.6m deep, 1.0m high to top surface) placed against the right wall, holding the TV."
        },
        {
            "label": "television",
            "bbox": [0.6, 4.5, 1.4, 4.9],
            "comment": "Television placed on the TV stand, primary focal point. Assumed dimensions approximately 0.8m high, 0.4m wide from bird's eye (representing screen width). Height from floor: 0.6m (top of stand) + small gap = ~0.6m for bottom edge of TV, 1.4m for top edge."
        },
        {
            "label": "sofa",
            "bbox": [1.5, 0.5, 2.3, 2.5],
            "comment": "Main 3-seater sofa (2.0m wide, 0.8m deep) placed opposite the TV. Provides clear view and maintains 0.5m clearance from the left window wall."
        },
        {
            "label": "coffee_table",
            "bbox": [1.7, 2.8, 2.1, 3.8],
            "comment": "Rectangular coffee table (1.0m wide, 0.4m deep) centered in front of the sofa, 0.3m from sofa edge for legroom."
        },
        {
            "label": "armchair",
            "bbox": [2.8, 0.5, 3.6, 1.3],
            "comment": "Armchair (0.8m x 0.8m) placed in the bottom-left, angled slightly towards the TV and sofa, creating a secondary seating option and balancing the room. Maintains pathway from door."
        },
        {
            "label": "rug",
            "bbox": [1.2, 0.3, 2.6, 4.0],
            "comment": "Large rug (3.7m wide, 1.4m deep) anchoring the main seating area. Front legs of sofa and armchair are on the rug."
        },
        {
            "label": "floor_lamp",
            "bbox": [0.5, 4.0, 1.0, 4.5],
            "comment": "Floor lamp placed in the top-right corner, providing ambient lighting near the TV area without causing glare."
        },
        {
            "label": "bookshelf",
            "bbox": [2.8, 4.4, 3.8, 5.0],
            "comment": "Tall bookshelf (1.0m high, 0.6m deep) in the bottom-right corner, for storage, balancing the TV stand. Height 1m implies it's not full wall height."
        }
    ]
}
"""

l_shaped_living_room_conversational_example = """
{
    "layout_id": "1",
    "room": {
        "width": 6.0,
        "depth": 5.0,
        "units": "meters",
        "shape": "L-shape",
        "shape_description": "L-shaped living room with a cutout at the top-right: area from x=3.0 to x=6.0 and y=0.0 to y=2.0 is NOT usable (cutout_area)."
    },
    "coordinate_system": {
        "y_axis": "depth (vertical, top to bottom, 0 to 5.0)",
        "x_axis": "width (horizontal, left to right, 0 to 6.0)",
        "origin": "top-left corner",
        "x_range": "[0, 6.0]",
        "y_range": "[0, 5.0]"
    },
    "layout_style": {
        "chosen_layout_style": "Conversational",
        "reasoning": "The L-shaped room provides a natural nook for a conversational seating arrangement. The main part of the L (bottom section: 6.0m wide x 3.0m deep; left leg: 3.0m wide x 2.0m deep) can accommodate an L-shaped sofa and an armchair, centered around a coffee table. A fireplace on the bottom wall acts as a focal point."
    },
    "objects": [
        {
            "label": "cutout_area",
            "bbox": [0.0, 3.0, 2.0, 6.0],
            "comment": "Defines the non-usable L-shape cutout area at top-right."
        },
        {
            "label": "door",
            "bbox": [0.0, 0.5, 0.0, 1.3],
            "comment": "Entrance door on the top wall (left leg of L), swings inwards."
        },
        {
            "label": "window",
            "bbox": [2.5, 0.0, 4.5, 0.0],
            "comment": "Large window on the left wall."
        },
        {
            "label": "fireplace",
            "bbox": [4.4, 2.5, 5.0, 3.5],
            "comment": "Fireplace (1.0m wide, 0.6m deep) centered on the bottom wall, primary focal point."
        },
        {
            "label": "sofa",
            "bbox": [2.2, 0.5, 3.0, 2.8],
            "comment": "L-shaped sectional sofa. Long side (2.3m) against the left wall section below the window, short side (imagined as part of the L, total 0.8m depth from wall) extends into the room. Forms the main part of the conversational area."
        },
        {
            "label": "coffee_table",
            "bbox": [3.2, 1.5, 3.6, 2.5],
            "comment": "Square coffee table (1.0m x 0.4m, appears square from top) within the nook of the L-sofa and facing the armchair and fireplace."
        },
        {
            "label": "armchair",
            "bbox": [3.0, 3.5, 3.8, 4.3],
            "comment": "Armchair (0.8m x 0.8m) placed to the right of the fireplace, angled towards the sofa and coffee table, completing the conversational U-shape."
        },
        {
            "label": "rug",
            "bbox": [2.0, 0.3, 4.0, 4.5],
            "comment": "Large rug (4.2m wide, 2.0m deep) anchoring the conversational area. Sofa and armchair front legs are on it."
        },
        {
            "label": "bookshelf",
            "bbox": [0.5, 5.0, 2.0, 6.0],
            "comment": "Tall bookshelf (1.5m high, 1.0m wide, 0.3m deep) in the available wall space on the short right wall, next to the L-cutout."
        },
        {
            "label": "floor_lamp",
            "bbox": [3.8, 0.5, 4.6, 1.0],
            "comment": "Floor lamp (base 0.5x0.5m, height 0.8m in this flat projection) in the corner created by the sofa and the bottom wall, near the fireplace."
        }
    ]
}
"""

open_living_room_tv_focused_example = """
{
    "layout_id": "0",
    "room": {
        "width": 5.0,
        "depth": 3.8,
        "units": "meters",
        "shape": "open",
        "shape_description": "Open living room, bottom wall removed."
    },
    "coordinate_system": {
        "y_axis": "depth (vertical, top to bottom, 0 to 3.8)",
        "x_axis": "width (horizontal, left to right, 0 to 5.0)",
        "origin": "top-left corner",
        "x_range": "[0, 5.0]",
        "y_range": "[0, 3.8]"
    },
    "layout_style": {
        "chosen_layout_style": "TV-Focused",
        "reasoning": "The room is rectangular (5.0m x 3.8m). A TV-focused layout is suitable. The TV is placed on the right short wall. The main sofa is opposite, maximizing viewing comfort. A door on the top wall and a window on the left wall do not significantly interfere with this arrangement."
    },
    "objects": [
        {
            "label": "door",
            "bbox": [0.0, 1.0, 0.0, 1.8],
            "comment": "Entrance door on the top wall, swings inwards."
        },
        {
            "label": "window",
            "bbox": [1.0, 0.0, 2.8, 0.0],
            "comment": "Large window on the left wall providing natural light."
        },
        {
            "label": "tv_stand",
            "bbox": [1.4, 4.4, 2.4, 5.0],
            "comment": "TV stand (0.6m deep, 1.0m high to top surface) placed against the right wall, holding the TV."
        },
        {
            "label": "television",
            "bbox": [0.6, 4.5, 1.4, 4.9],
            "comment": "Television placed on the TV stand, primary focal point. Assumed dimensions approximately 0.8m high, 0.4m wide from bird's eye (representing screen width). Height from floor: 0.6m (top of stand) + small gap = ~0.6m for bottom edge of TV, 1.4m for top edge."
        },
        {
            "label": "sofa",
            "bbox": [1.5, 0.5, 2.3, 2.5],
            "comment": "Main 3-seater sofa (2.0m wide, 0.8m deep) placed opposite the TV. Provides clear view and maintains 0.5m clearance from the left window wall."
        },
        {
            "label": "coffee_table",
            "bbox": [1.7, 2.8, 2.1, 3.8],
            "comment": "Rectangular coffee table (1.0m wide, 0.4m deep) centered in front of the sofa, 0.3m from sofa edge for legroom."
        },
        {
            "label": "armchair",
            "bbox": [2.8, 0.5, 3.6, 1.3],
            "comment": "Armchair (0.8m x 0.8m) placed in the bottom-left, angled slightly towards the TV and sofa, creating a secondary seating option and balancing the room. Maintains pathway from door."
        },
        {
            "label": "rug",
            "bbox": [1.2, 0.3, 2.6, 4.0],
            "comment": "Large rug (3.7m wide, 1.4m deep) anchoring the main seating area. Front legs of sofa and armchair are on the rug."
        },
        {
            "label": "floor_lamp",
            "bbox": [0.5, 4.0, 1.0, 4.5],
            "comment": "Floor lamp placed in the top-right corner, providing ambient lighting near the TV area without causing glare."
        },
        {
            "label": "bookshelf",
            "bbox": [2.8, 4.4, 3.8, 5.0],
            "comment": "Tall bookshelf (1.0m high, 0.6m deep) in the bottom-right corner, for storage, balancing the TV stand. Height 1m implies it's not full wall height."
        }
    ]
}
"""
# ==============================================================================
