bedroom_generation_prompt = """
Generate a dataset of 20 bedroom layouts in JSON format. The output should be a JSON list where each element is a dictionary representing a single layout.

**Layout Structure:**

Each layout dictionary must contain the following keys:
* `layout_id`: An integer uniquely identifying the layout (start from 0).
* `room`: A dictionary describing the room dimensions and shape.
* `objects`: A list of dictionaries, each describing an object placed within the bedroom.

**`room` Dictionary Details:**
* `width`: A float representing the width of the room in meters (between 2.5 and 5.0 for smaller rooms, up to 7.0 for master bedrooms).
* `depth`: A float representing the depth of the room in meters (between 2.5 and 5.0 for smaller rooms, up to 7.0 for master bedrooms).
* `units`: A string, fixed value `"meters"`.
* `shape`: String, must be one of `"rectangular"`, `"L-shape"`, or `"open"`.
* `shape_description`: A string summarizing the room's shape, including details of cutouts or open walls (e.g., "Rectangular bedroom", "L-shaped room with a 1.0x1.0 cutout at the `"bottom-left"` (or any other corner) corner (x=0.0-1.0, y=3.0-4.0)", "Open bedroom (`"top"` wall removed, or `"left"`, or `"right"`, or `"bottom"`.)").
* `intended_use`: String, indicating the primary use (e.g., "master_bedroom", "guest_bedroom", "child_bedroom_single", "child_bedroom_shared", "teen_bedroom").
* `bed_size_suggestion`: String, suggesting bed size (e.g., "single", "twin", "double", "queen", "king").

**`objects` List Details:**
Each dictionary in the `objects` list must describe an object and include the keys: `"label"`, `"bbox"`: [y0, x0, y1, x1] and `"comment"` about location.

Coordinate system
"coordinate_system": {
    "y_axis": "depth (vertical, top to bottom)",
    "x_axis": "width (horizontal, left to right)",
    "origin": "(0, 0) - top-left corner",
    "x_range": "[0, width]",
    "y_range": "[0, depth]"
  }

* **Possible `"label"` values for architectural elements:**
    * `"cutout_area"`: Represents the removed area in L-shaped rooms.
    * `"door"`: Represents a doorway into the bedroom.
    * `"window"`: Represents an opening in a wall that allows the exchange of light and may also allow the passage of sound and sometimes air.
    * `"fireplace"`: Represents a structure made of brick, stone or metal designed to contain a fire (optional, typically for larger master bedrooms).
    * `"closet_alcove"`: Represents a built-in closet area if not a free-standing wardrobe. (This is structural, not a furniture item).

* **Recommended room sizes (general guidelines) in square meters:**
    * Small bedroom (e.g., child's, small guest): 8-12 m²
    * Medium bedroom (e.g., standard double, teen): 12-18 m²
    * Large bedroom (e.g., master bedroom): 18+ m²

**Constraints and Requirements:**

0. **Room size** - generate different room sizes: small bedrooms (approx. 8-12m²), medium bedrooms (approx. 12-18 m²), and large bedrooms (approx. 18m²+). Generate different proportions for the width and depth.
1. **Quantity & Distribution:** Generate exactly 20 layouts: 50% rectangular, 30% L-shaped, and 20% open.
2. **L-Shapes:** Cutout areas must be placed in one of the four corners. The remaining 'legs' of the L-shape must each have a minimum width and depth of 1.5 meters.
3. **Doors:** All bedroom layouts must contain at least one object of type `"door"`. For `"open"` shapes, the door should not be on the open wall(s) but on one of the existing structural walls. There can be several doors (e.g., to en-suite bathroom or walk-in closet).
4. **Door/Window Walls:** In layouts with a door, objects of type `"window"` cannot be placed on the same wall segment as the object of type `"door"` if that segment is short and would make placement awkward. Prioritize functional placement.
5. **Fireplace:**
   - If the `intended_use` suggests a luxury master bedroom and a fireplace is appropriate, it may be included. The fireplace must be placed on a wall.
   - A fireplace cannot overlap with a door or window.
6. **Window Area Ratio:**
   - Total window length must be **>15%** of the floor area. Floor area = (room width × room depth) minus any cutout areas.
7. **Window Grouping and Sizes:**
   - Windows on the **same wall** **must** be of **equal size**.
   - **One small window** (less than 1m in length) alone in the room is **not allowed**, unless it's a very small room and it's a secondary window. Aim for adequate lighting.
   - **One large** window is OK; **two or more** windows are OK.
   - If window width exceeds **1.8m**, consider splitting it into **multiple standard windows** (0.6m, 0.75m, 0.9m, 1.2m, 1.5m wide).
   - Add small gaps (0.05m-0.15m) between windows if grouped.
8. **Window Placement:**
   - Do **not** place windows on **opposite walls** if it creates direct cross-views compromising privacy or creates difficult furniture placement, unless the room is very large.
   - Multiple windows should ideally be on the **same** or on two **adjacent** walls.
9. **Doors, Windows and Fireplace short size:** For simplicity, the short size of a door is *0.1m*, the short size of a window is *0.0m* (flush with wall), and the short size of a fireplace is *0.2m* (depth from wall).
10. **Closet Alcove:** If a `"closet_alcove"` is included, it should be represented as a rectangular area, typically 0.6-0.7m deep, recessed into a wall or occupying a corner. Its bbox should be within the room's overall dimensions but indicates a dedicated closet space.
11. **Validity:** All objects must be placed strictly within the usable room boundaries (considering cutouts for L-shapes). Door widths (where present) should be between 0.7m and 0.9m.
12. **Output Format:** The final output must be a single, valid JSON list containing the 20 layout dictionaries, with no comments (`/* ... */`) included.

Example:
{
  "layout_id": 1,
  "room": {
    "width": 3.5,
    "depth": 4.0,
    "units": "meters",
    "shape": "rectangular",
    "shape_description": "Rectangular master bedroom",
    "intended_use": "master_bedroom",
    "bed_size_suggestion": "queen"
  },
  "coordinate_system": {
    "y_axis": "depth (vertical, top to bottom)",
    "x_axis": "width (horizontal, left to right)",
    "origin": "(0, 0) - top-left corner",
    "x_range": "[0, 3.5]",
    "y_range": "[0, 4.0]"
  },
  "objects": [
    {
      "label": "door",
      "bbox": [0.0, 0.1, 0.1, 0.9],
      "comment": "The single door is placed on the top wall (y=0), near the left corner."
    },
    {
      "label": "window",
      "bbox": [1.5, 3.5, 3.0, 3.5],
      "comment": "A window on the right wall (x=3.5), providing natural light. Total window length meets the requirement (>15% of area)."
    }
  ]
}
"""

# ==============================================================================
# ADAPTED PROMPT FOR BEDROOM LAYOUTS
# ==============================================================================

bedroom_layout_generation_prompt = """
# Objective: Given the selected bedroom layout style, generate the JSON for a 2D bird-view bedroom layout with objects positioned appropriately, and include insightful comments about object placements (as a field of an object JSON).

## Object properties required in JSON:
- "label" (e.g., "door", "window", "bed", "nightstand", "dresser", "wardrobe", "desk", "chair" (desk chair), "armchair" (reading chair), "bookshelf", "rug", "floor_lamp", "table_lamp", "plant", "mirror", "bench" (at foot of bed), "ottoman", "fireplace", "cutout_area", "closet_alcove")
- "bbox": [y0, x0, y1, x1]

### Room details:
{room_details}

*Don`t delete any information from the room details and room objects (like doors, windows, fireplace, closet_alcove, cutout_area).*
*If a fireplace is present in room_details, it MUST be included and treated as a potential feature.*
*If a closet_alcove is defined, furniture like wardrobes should not obstruct it, or it replaces the need for a freestanding wardrobe.*
*The `bed_size_suggestion` from room_details should guide the "bed" object size.*

### Layout style:
{layout_style}

{bedroom_layout_specifics}

## Object positioning considerations:
- **General Object Shape:**
    - Each object must be defined using a rectangular bounding box [y0, x0, y1, x1].
    - For L-shaped desks or complex beds, consider splitting into multiple rectangular objects or simplifying to a primary rectangular footprint.
- **General Clearances & Overlap:**
    - Floor-standing objects (bed, dresser, wardrobe, desk, etc.) must not overlap.
    - Rugs can be under other furniture. Small decor items (like table lamps on nightstands) are considered part of the larger item and don't need separate overlap checks if their bbox is within the table's.
    - Ensure clear pathways (traffic flow) of at least 0.75 meters wide, especially from the door to the bed, wardrobe, and desk (if present).
    - Wardrobe/Dresser Drawers/Doors: Allow 0.6-0.8m clearance in front for opening.
- **Door Clearance:**
    - Ensure a clear space of at least 0.75 meters in front of the door (on the swing side, assume inward swing) to allow it to open fully.
- **Bed Area Clearances:**
    - Sides of Bed: At least 0.6-0.75m for access (unless one side is against a wall for single beds in small rooms).
    - Foot of Bed: At least 0.75m clearance if it's a walkway.
- **Focal Points:**
    - The "bed" is typically the primary focal point. Its headboard wall is often emphasized.
    - A large "window" with a view, a "fireplace", or a significant "desk" area can be secondary focal points.
- **Object Placement Strategy:**
    - **Bed First:** Position the "bed" according to the `bed_size_suggestion`. Ideal placement is against a solid wall (headboard wall), facing the door if possible but not directly in line with it. Avoid placing the head of the bed directly under a window if possible (drafts, light).
    - **Anchor with Rug:** A "rug" can define the bed area. It should be large enough so that it extends beyond the sides of the bed (0.5-0.6m) and possibly the foot. At least the front two-thirds of the bed should be on the rug if it doesn't go fully underneath.
    - **Nightstands:** Place "nightstand"(s) flanking the bed. One for single beds, two for double/queen/king.
    - **Wardrobe/Dresser:** Place against walls, considering door/drawer swing clearance. Not obstructing windows or major pathways. If a "closet_alcove" exists, a freestanding "wardrobe" might be smaller or unnecessary.
    - **Desk & Chair:** If included, place near a "window" for natural light if possible, or in a dedicated corner. Ensure space for the "chair" to be pulled out.
    - **Armchair/Reading Nook:** If space and style allow, an "armchair" and a "side_table" or "floor_lamp" can create a cozy corner.
    - **Bookshelves/Storage:** Against walls, accessible.
    - **Lamps:** "table_lamp"(s) on nightstands/desk, "floor_lamp" for reading nook or general lighting.
    - **Mirror:** "mirror", usually wall-mounted. For simplicity, the short size of a mirror is always *0.05m*. Mirrors must not overlap with any other objects and need a clear space of at least 0.75 meters in front of it.
    - **Windows:** Maximize natural light. Furniture placement should allow access to windows. Consider privacy needs.
- **Cutout Area:** If a cutout area is defined in `room_details`, it isn't part of the usable floor area, though its internal-facing sides can be used as walls.
- **Symmetry & Balance:** Often desirable in bedrooms, especially around the bed (e.g., matching nightstands and lamps).
- **Traffic Flow Priority:** Non-overlap rules and clearance rules for pathways have a higher priority than ideal object placement according to style guides if space is very constrained. The room must remain functional.

## Mandatory Evaluation Steps & Strict Priority Rules:
1.  **Absolute Clearance Priority:** Minimum clearances (0.75m for pathways/doors, 0.6-0.75m around bed sides, 0.6-0.8m for wardrobe/dresser access) are **non-negotiable**. This check must be performed *after* placing essential items and *before* considering any optional items.
2.  **Essential Objects:** Placement of the "bed" according to its specific rules and the chosen layout style is the next priority. Then, essential storage ("wardrobe" or "dresser", or utilizing "closet_alcove").
3.  **Secondary Core Furniture:** Placement of items like "nightstand"(s), and "desk" and "chair" (if style requires), according to their specific rules is the next priority. Ensure good grouping and functionality.
4.  **Ancillary Elements & Refinements (e.g., Rug, Lighting, Decor):** Smaller elements like "rug", "floor_lamp", "table_lamp", "plant", "bench", "mirror", "armchair" should ONLY be considered *after* all mandatory clearances and essential/secondary object placements are successfully accommodated without conflict.

  *   **Step 1:** After placing the bed, essential storage, and defining their required clearance zones, AND defining door clearance zones, calculate the remaining UNRESTRICTED floor area.
  *   **Step 2:** Evaluate if this unrestricted area can comfortably fit secondary and ancillary elements according to the chosen layout style and general principles.
  *   **Step 3:** **IF AND ONLY IF** the space is sufficient, THEN attempt to include these elements thoughtfully. **OTHERWISE, prioritize core functionality and clearances, and omit less critical items or use smaller versions if possible.**

## Ancillary Element Placement Strategy (Only if Step 3 above is met):
    *   Position ancillary elements to enhance the functionality and aesthetics of the primary arrangement.
    *   Rugs should anchor the bed area.
    *   Lamps should provide task or ambient lighting where needed (e.g., nightstand lamps, desk lamp, floor lamp for a reading corner).
    *   Plants or decorative ottomans/benches can fill empty spaces or add visual interest, but must not impede traffic flow.
    *   **Final Check:** Re-verify that these placed items do not infringe on *any* mandatory clearance zones or obstruct pathways.

## Final review:
- Double check all object placements to ensure they are within the room boundaries and do not overlap (unless intended, like a lamp on a table).
- Ensure that all objects are placed according to the rules, layout style, and general bedroom design principles.
- If any object placement violates the rules, adjust the layout accordingly. You might need to choose smaller furniture sizes or omit some optional items if space is tight.
- Don't change the room size, or the size and location of pre-defined elements like doors, windows, fireplaces, or closet_alcoves from `room_details`.

Make sure to include all requested objects and their properties in the JSON output.
Don't use slash slash comments // in the JSON file.
Return only the JSON output.

OUTPUT EXAMPLE:
{bedroom_layout_example}
"""

# ==============================================================================
# BEDROOM SPECIFIC LAYOUT STYLE DESCRIPTIONS
# ==============================================================================

master_bedroom_traditional_spec = """
### Traditional Master Bedroom Configuration:
- **Primary Goal:** Create a comfortable, spacious, and often symmetrical retreat.
- **Bed:** Queen or King size "bed" as the central focal point, typically with a prominent headboard wall.
- **Nightstands:** Two matching "nightstand"s flanking the bed, each with a "table_lamp".
- **Storage:** A "dresser" often with a "mirror" above or nearby, and/or a "wardrobe" or walk-in/built-in closet ("closet_alcove").
- **Seating (Optional):** If space allows, an "armchair" with a "side_table" and "floor_lamp" for a reading nook, or a "bench" at the foot of the bed.
- **Arrangement:** Emphasize balance and classic comfort. Sufficient clearance around the bed.
- **Rug:** A large "rug" under the bed, extending to the sides and foot.
"""

small_bedroom_efficient_spec = """
### Efficient Small Bedroom Configuration:
- **Primary Goal:** Maximize functionality and storage in a compact space.
- **Bed:** "Single", "Twin", or "Double" "bed", possibly placed against a wall or in a corner to save space.
- **Nightstand:** One "nightstand", or a floating shelf if space is very tight.
- **Storage:** Vertical storage solutions like a tall, narrow "wardrobe" or "bookshelf", or a "dresser" that can double as a nightstand or part of a desk setup. Under-bed storage is implied if not explicitly modeled.
- **Desk (Optional):** A small "desk" or wall-mounted desk if needed, with a compact "chair".
- **Arrangement:** Prioritize clear pathways. Multi-functional furniture is a plus.
- **Decor:** Keep it light and uncluttered to make the space feel larger.
"""

bedroom_with_workstation_spec = """
### Bedroom with Workstation Configuration:
- **Primary Goal:** Integrate a functional workspace within the bedroom.
- **Bed:** Appropriate size "bed" (Single to Queen) for the room and occupant.
- **Workstation:** A dedicated "desk" of adequate size, an ergonomic "chair", and task lighting (e.g., "table_lamp" on desk). Consider placement near a "window" for natural light.
- **Storage:** "Bookshelf" or other storage for work/study materials, in addition to regular bedroom storage ("wardrobe", "dresser").
- **Arrangement:** Clearly define the sleeping and working zones, even in smaller rooms. Ensure the work area doesn't feel cramped and doesn't impede access to the bed or other furniture.
- **Nightstand(s):** As appropriate for bed size.
"""

guest_bedroom_welcoming_spec = """
### Welcoming Guest Bedroom Configuration:
- **Primary Goal:** Provide a comfortable and inviting space for guests.
- **Bed:** Typically a "Double" or "Queen" "bed".
- **Nightstand(s):** At least one "nightstand" with a "table_lamp". Two if space allows for a queen bed.
- **Storage:** Some space for guests' belongings, e.g., a small "dresser", part of a "wardrobe", or a luggage rack (not modeled as furniture but comment can imply).
- **Amenities:** Consider a "mirror", a comfortable "chair" if space permits.
- **Arrangement:** Keep the layout uncluttered and easy to navigate. Ensure easy access to essentials.
- **Decor:** Neutral and pleasant. A "rug" can add warmth.
"""

# ==============================================================================
# PROMPT FOR CHOOSING A BEDROOM LAYOUT STYLE
# ==============================================================================

bedroom_layout_style_choice_prompt = """
Objective: Determine the most suitable bedroom layout style for a given room, based on dimensions, room shape, `intended_use`, `bed_size_suggestion`, positions of doors, windows, and any fixed elements.

Bedroom Layout Styles:
- Traditional Master Bedroom: Spacious, symmetrical, queen/king bed, often with seating.
- Efficient Small Bedroom: Maximizes function in limited space, single/double bed, smart storage.
- Bedroom with Workstation: Integrates a dedicated desk and chair for work or study.
- Welcoming Guest Bedroom: Comfortable, uncluttered, typically double/queen bed, essential amenities.

Selection criteria:
- **Room Size & Shape:**
    - Large rooms (e.g., >16m²): Can accommodate Traditional Master Bedroom style, or a Bedroom with Workstation with ample space.
    - Medium rooms (e.g., 12-16m²): Good for Bedroom with Workstation, Welcoming Guest Bedroom, or a more modest Master Bedroom.
    - Small rooms (e.g., <12m²): Best suit Efficient Small Bedroom style. A compact workstation might be possible.
    - L-shapes: Can naturally create zones, e.g., sleeping area in one leg, workstation or small seating in another.
- **`intended_use` & `bed_size_suggestion` from room details:**
    - `"master_bedroom"` with `"queen"` or `"king"`: Strongly suggests Traditional Master Bedroom.
    - `"child_bedroom_single"` or `"teen_bedroom"` with `"single"` or `"twin"`: Could be Efficient Small Bedroom or Bedroom with Workstation depending on size.
    - `"guest_bedroom"` with `"double"` or `"queen"`: Points to Welcoming Guest Bedroom.
- **Fixed Elements:**
    - **Windows:** Location can influence bed placement (avoid head under window) and desk placement (ideal near window).
    - **Doors/Openings:** Dictate traffic flow and main furniture placement. Bed should ideally not face the door directly if it compromises privacy.
    - **Closet Alcove/Fireplace:** If present, these features should be integrated into the chosen style. A fireplace might reinforce a Traditional Master Bedroom feel.
- **Functionality Needs:**
    - If work/study from home is a key requirement: Bedroom with Workstation.
    - If maximizing space in a small footprint is crucial: Efficient Small Bedroom.

Output example:
{{
  "chosen_layout_style": "Bedroom with Workstation",
  "reasoning": "The room is medium-sized (3.5m x 4.0m) and rectangular. The intended_use is 'teen_bedroom' and bed_size_suggestion is 'single'. This allows space for a dedicated workstation. The window on the right wall is suitable for desk placement. The door placement allows for clear zones."
}}

Determine the bedroom layout style based on this INPUT:
{room_input}

Return only the output in JSON format.
"""


# ==============================================================================
# EXAMPLE BEDROOM LAYOUTS (to be used as {bedroom_layout_example})
# ==============================================================================

rectangular_master_bedroom_traditional_example = """
{
    "layout_id": "0",
    "room": {
        "width": 4.0,
        "depth": 4.5,
        "units": "meters",
        "shape": "rectangular",
        "shape_description": "Rectangular master bedroom",
        "intended_use": "master_bedroom",
        "bed_size_suggestion": "queen"
    },
    "coordinate_system": {
        "y_axis": "depth (vertical, top to bottom, 0 to 4.5)",
        "x_axis": "width (horizontal, left to right, 0 to 4.0)",
        "origin": "top-left corner",
        "x_range": "[0, 4.0]",
        "y_range": "[0, 4.5]"
    },
    "layout_style": {
        "chosen_layout_style": "Traditional Master Bedroom",
        "reasoning": "The room size (4.0m x 4.5m = 18m^2) and intended use as a master bedroom with a queen bed suggest a traditional, spacious layout. Symmetry around the bed is achievable."
    },
    "objects": [
        {
            "label": "door",
            "bbox": [0.0, 0.1, 0.1, 0.9],
            "comment": "Entrance door on the top wall, near left corner, opening inwards."
        },
        {
            "label": "window",
            "bbox": [1.75, 4.0, 3.25, 4.0],
            "comment": "Large window (1.5m long) centered on the right wall, providing natural light."
        },
        {
            "label": "bed",
            "bbox": [0.5, 1.2, 2.5, 2.8],
            "comment": "Queen size bed (approx. 1.6m wide x 2.0m long) centered on the top wall, leaving space for nightstands. Headboard against top wall."
        },
        {
            "label": "nightstand",
            "bbox": [0.6, 0.6, 1.1, 1.1],
            "comment": "Left nightstand (0.5m wide, 0.5m deep) beside the bed."
        },
        {
            "label": "table_lamp",
            "bbox": [0.55, 0.7, 0.6, 1.0],
            "comment": "Table lamp on left nightstand. Bbox represents lamp base and shade from top view, slightly smaller than nightstand surface."
        },
        {
            "label": "nightstand",
            "bbox": [0.6, 2.9, 1.1, 3.4],
            "comment": "Right nightstand (0.5m wide, 0.5m deep) beside the bed."
        },
        {
            "label": "table_lamp",
            "bbox": [0.55, 3.0, 0.6, 3.3],
            "comment": "Table lamp on right nightstand."
        },
        {
            "label": "dresser",
            "bbox": [3.8, 0.5, 4.4, 1.7],
            "comment": "Dresser (1.2m wide, 0.6m deep) against the bottom wall, left side."
        },
        {
            "label": "wardrobe",
            "bbox": [3.0, 3.4, 4.4, 4.0],
            "comment": "Wardrobe (1.4m high for bbox, 0.6m wide, 0.6m deep) in the bottom-right corner."
        },
        {
            "label": "armchair",
            "bbox": [0.5, 3.0, 1.3, 3.8],
            "comment": "Armchair (0.8m x 0.8m) in the top-right corner, near the window, creating a small reading nook. This is an alternative if wardrobe is smaller or built-in."
        },
        {
            "label": "rug",
            "bbox": [0.2, 0.8, 3.0, 3.2],
            "comment": "Large rug (2.4m wide, 2.8m deep) under the bed, extending to sides and foot."
        }
    ]
}
"""

l_shaped_bedroom_with_workstation_example = """
{
    "layout_id": "1",
    "room": {
        "width": 4.5,
        "depth": 4.0,
        "units": "meters",
        "shape": "L-shape",
        "shape_description": "L-shaped bedroom with a cutout at the top-right: area from x=2.5 to x=4.5 and y=0.0 to y=1.5 is NOT usable (cutout_area).",
        "intended_use": "teen_bedroom",
        "bed_size_suggestion": "single"
    },
    "coordinate_system": {
        "y_axis": "depth (vertical, top to bottom, 0 to 4.0)",
        "x_axis": "width (horizontal, left to right, 0 to 4.5)",
        "origin": "top-left corner",
        "x_range": "[0, 4.5]",
        "y_range": "[0, 4.0]"
    },
    "layout_style": {
        "chosen_layout_style": "Bedroom with Workstation",
        "reasoning": "The L-shape (main area approx 2.5x4.0m, leg 2.0x1.5m) and 'teen_bedroom' use case are ideal for separating sleeping and study zones. A single bed fits well."
    },
    "objects": [
        {
            "label": "cutout_area",
            "bbox": [0.0, 2.5, 1.5, 4.5],
            "comment": "Defines the non-usable L-shape cutout area at top-right."
        },
        {
            "label": "door",
            "bbox": [0.0, 0.1, 0.1, 0.9],
            "comment": "Entrance door on the top wall (main wider section), near left corner."
        },
        {
            "label": "window",
            "bbox": [2.0, 0.0, 3.5, 0.0],
            "comment": "Window on the left wall of the main room section."
        },
        {
            "label": "window",
            "bbox": [2.0, 4.5, 3.0, 4.5],
            "comment": "Second window on the right wall of the shorter L-leg, good for desk area."
        },
        {
            "label": "bed",
            "bbox": [0.5, 1.2, 2.4, 2.2],
            "comment": "Single bed (1.0m wide x 1.9m long) against the internal wall of the L-shape (right side of main section)."
        },
        {
            "label": "nightstand",
            "bbox": [0.6, 0.6, 1.0, 1.1],
            "comment": "Nightstand (0.5m wide, 0.4m deep) to the left of the bed."
        },
        {
            "label": "desk",
            "bbox": [1.7, 2.8, 2.2, 4.2],
            "comment": "Desk (1.4m wide, 0.5m deep) in the L-leg, under the window on the right wall."
        },
        {
            "label": "chair",
            "bbox": [2.3, 3.2, 2.9, 3.8],
            "comment": "Desk chair (0.6m x 0.6m), positioned at the desk."
        },
        {
            "label": "wardrobe",
            "bbox": [2.8, 0.2, 3.9, 0.8],
            "comment": "Wardrobe (1.1m high, 0.6m wide, 0.6m deep) on the left wall, near the bottom corner."
        },
        {
            "label": "bookshelf",
            "bbox": [0.2, 2.8, 1.4, 3.2],
            "comment": "Bookshelf (0.4m deep, 1.2m high) on the wall above the desk area in the L-leg."
        },
        {
            "label": "rug",
            "bbox": [0.3, 0.4, 2.6, 2.4],
            "comment": "Rug (2.0m wide, 2.3m deep) in the main bed area."
        }
    ]
}
"""

open_concept_small_bedroom_efficient_example = """
{
    "layout_id": "2",
    "room": {
        "width": 3.0,
        "depth": 3.5,
        "units": "meters",
        "shape": "open",
        "shape_description": "Open concept small bedroom, bottom wall removed (opens to another space).",
        "intended_use": "guest_bedroom_single",
        "bed_size_suggestion": "single"
    },
    "coordinate_system": {
        "y_axis": "depth (vertical, top to bottom, 0 to 3.5)",
        "x_axis": "width (horizontal, left to right, 0 to 3.0)",
        "origin": "top-left corner",
        "x_range": "[0, 3.0]",
        "y_range": "[0, 3.5]"
    },
    "layout_style": {
        "chosen_layout_style": "Efficient Small Bedroom",
        "reasoning": "The small size (3.0m x 3.5m = 10.5m^2), open concept, and 'guest_bedroom_single' use require an efficient layout. The open bottom wall influences furniture placement to maintain flow."
    },
    "objects": [
        {
            "label": "door",
            "bbox": [0.0, 2.1, 0.1, 2.9],
            "comment": "Entrance door on the top wall, near right corner, opening inwards. This provides access from a corridor, distinct from the 'open' side."
        },
        {
            "label": "window",
            "bbox": [1.0, 0.0, 2.5, 0.0],
            "comment": "Window (1.5m long) on the left wall."
        },
        {
            "label": "bed",
            "bbox": [0.5, 0.2, 2.4, 1.2],
            "comment": "Single bed (1.0m wide x 1.9m long) placed with its headboard against the top wall, and one side against the left wall to maximize space."
        },
        {
            "label": "nightstand",
            "bbox": [0.5, 1.3, 0.9, 1.8],
            "comment": "Small nightstand (0.5m wide, 0.4m deep) to the right of the bed."
        },
        {
            "label": "table_lamp",
            "bbox": [0.45, 1.4, 0.5, 1.7],
            "comment": "Table lamp on nightstand."
        },
        {
            "label": "dresser",
            "bbox": [1.0, 2.4, 1.8, 2.9],
            "comment": "Compact dresser (0.8m high, 0.5m wide, 0.5m deep) against the right wall, providing storage for guests."
        },
        {
            "label": "mirror",
            "bbox": [0.2, 2.55, 0.9, 2.60],
            "comment": "Small wall mirror (0.05m wide, 0.7m deep) above the dresser."
        },
        {
            "label": "floor_lamp",
            "bbox": [2.8, 0.2, 3.3, 0.7],
            "comment": "Floor lamp in the bottom-left corner (near the open side), providing ambient light. Base 0.5x0.5m."
        },
        {
            "label": "rug",
            "bbox": [0.3, 0.1, 2.6, 2.0],
            "comment": "Small rug (1.9m wide, 2.3m deep) placed by the bed and nightstand."
        }
    ]
}
"""
