layout_generation_prompt = """
# Objective: Given the selected kitchen layout style, generate the JSON for a 2D bird-view kitchen layout with objects positioned appropriately, and include insightful comments about object placements (as a field of an object JSON).

## Object properties required in JSON:
- label (e.g., "door", "window", "base_cabinet", "sink", "fridge", "stove", "table", "chair", "corner_cabinet", "dishwasher")
- "bbox": [y0, x0, y1, x1]

### Room details:
{room_details}

*Don`t delete any information from the room details and room objects.*

### Layout style:
{layout_style}

{kitchen_spec}

## Object positioning considerations:
- Objects that are located on the floor must not overlap (appliance, cabinetes, table). Chairs can be placed under the table, but they should not overlap with each other.
- Maintain an ergonomic work triangle (sink, stove, fridge). Between these zones, there should be a reasonable distance.
- Ensure a clear space of at least 0.8 meters in front of the door to allow it to swing open fully inside the room without obstruction.
- Ensure a minimum clearance of 0.8 meters in front of counters, appliance and on the chair side of the table (to allow for pulling out and sitting down).
- Objects may share clearance space where appropriate.
- There are four main walls and additional walls created by the cutout area (if it exists).
- Cutout area isn't part of the usable area, so no objects should be placed there.
- Tables, base cabinets, ovens, dishwashers, and sinks can be placed near or in front of windows (on any wall), with no gaps to the wall.
- Fridge should not be placed in front of windows (on any wall).
- Dishwasher should ideally be adjacent to the sink (double sink preferred).
- The sink should be positioned between the counter and dishwasher if space allows it.
- The oven should not be placed next to the fridge.
- **Cabinet Continuity:** Ensure base cabinets, and appliances form a continuous run along the walls, *with no gaps*! Usually fridge is located in the end of this run. In rare cases, you can put the fridge separately.
- Minimal `"base_cabinet"` size is 0.2m.
- All the appliances and cabinets should be placed along the wall, not in the middle of the room.
- Non overlap rules and clearance rules have a higher priority than the object placement rules.
- If the room is big enough, consider placing an eating area.

## Mandatory Evaluation Steps & Strict Priority Rules:
1.  **Absolute Clearance Priority:** The 0.8m minimum clearance in front of doors, counters, and appliances is **non-negotiable and inviolable**. No object placement should violate these absolute minimums. This check must be performed *after* placing essential items and *before* considering any optional items.
2.  **Essential Objects:** Placement of work triangle: `"sink"`, `"stove"`, `"fridge"` according to their specific rules is the next priority.
3.  **Optional Elements (counter):** Placement of counters (`"base_cabinet"`), `"corner cabinet"`, and dishwasher according to their specific rules is the next priority. Ensure cabinet continuity.
4.  **Optional Elements (Eating Area):** An eating area should ONLY be considered *after* all mandatory clearances and essential object placements are successfully accommodated without conflict.

  *   **Step 1:** After placing all essential L-shape components (cabinets, appliances) and defining their required 0.8m front clearance zones, AND defining the 0.8m door clearance zone, calculate the exact dimensions of the remaining UNRESTRICTED floor area.
  *   **Step 2:** Evaluate if this unrestricted area can fit a reasonably sized table PLUS at least two chairs PLUS an additional 0.8m clearance on chair sides for pull-out/access. This chair clearance *CAN* overlap with the mandatory clearances defined in Step 1.
  *   **Step 3:** **IF AND ONLY IF** the space is sufficient according to Step 2, THEN attempt to include an eating area using the Placement Strategy below. **OTHERWISE, DO NOT INCLUDE a table or chairs**.

  ## Eating Area Placement Strategy (Only if Step 3 above is met):
      *   Position the eating area thoughtfully within the confirmed available unrestricted space.
      *   Chairs have to be centered related to the table. If you place two chairs on one side, gurantee that there is minimal distance 0.1m between them.
      *   Consider proximity to windows for natural light, but prioritize efficient traffic flow and avoiding obstruction of doorways or main work zones.
      *   For layouts leaving significant open space (like L-shape, U-shape, larger rooms), favor placement in that open area.
      *   For smaller or constrained layouts, consider attaching one side of the `"table"` to a free wall section to maximize space efficiency.
      *   **Final Check:** Re-verify that the placed table and chairs do not infringe on *any* mandatory 0.8m clearance zone.

## Final review:
- Double check all object placements to ensure they are within the room boundaries and do not overlap.
- Ensure that all objects are placed according to the rules and specifications provided.
- If any object placement violates the rules, adjust the layout accordingly, you can choose smaller size for cabinets or other object.
- Don't change the room size, window and door sizes and locations.

Make sure to include all objects and their properties in the JSON output.
Don't use slash slash comments // in the JSON file.
Return only the JSON output.

OUTPUT EXAMPLE:
{layout_room}
"""

l_shaped_kitchen_spec = """
### L-Shaped Counter configuration:
- **Shape:** Must be L-shaped, utilizing two adjacent walls.
- **Corner Cabinet:** Include a dedicated `"corner_cabinet"` object at the intersection of the two wall sections. This cabinet is considered as part of both sections. The `corner_cabinet` bbox must have a standard `base_corner` size along at least one adjacent cabinet run.
- **Wall Preference:** Prefer placing the L-shape opposite the wall containing the door if this placement doesn't significantly compromise the work triangle or overall layout efficiency. If putting it on the door wall is impractical, choose a different corner.
"""

u_shaped_kitchen_spec = """
#### U-Shaped Counter configuration:
- **Shape:** Must be U-shaped, utilizing three adjacent walls.
- **Wall Preference:** Prefer placing the U-shape opposite the wall containing the door if this placement doesn't significantly compromise the work triangle or overall layout efficiency. If putting it on the door wall is impractical, choose a different corner. U-shape counter is suitable for L-shaped kitchen, inside the `leg` of the L.
- **Corner Cabinet:** Include a dedicated `"corner_cabinet"` objects at the intersection of the two wall sections. This cabinet is considered as part of both sections. The `corner_cabinet` bbox must have a standard `base_corner` size along at least one adjacent cabinet run.
"""

g_shaped_kitchen_spec = """
### G-Shaped Kitchen configuration:
- **Shape:** Must be U-shaped with an additional peninsula extending from one end, forming a "G" layout.
- **Peninsula Function:** The peninsula can be used for prep, storage, or seating. It should not block access to essential appliances.
- **Clearance:** Ensure at least 1 meter of clearance between opposing cabinets and around the peninsula for smooth movement.
- **Zoning:** Use the peninsula to define zones—such as separating the kitchen from a dining or living area—while maintaining workflow efficiency.
- **Corner Cabinet:** Include a dedicated `"corner_cabinet"` objects at the intersection of the two wall sections. This cabinet is considered as part of both sections. The `corner_cabinet` bbox must have a standard `base_corner` size along at least one adjacent cabinet run.
"""

galley_kitchen_spec = """
### Galley Kitchen configuration:
- **Shape:** Must be two parallel rows of cabinets and appliances along opposite walls.
- **Passage Space:** Ensure sufficient passage space between the two runs (at least 1 meter).
- **Eating Area:**  If space allows, include a table and chairs; attach one side to the wall as a continuation of the row of cabinets, or place it in the center of the kitchen, ensuring at least 0.8 meters of clearance around the table.
"""

island_kitchen_spec = """
### Island Kitchen configuration:
- **Shape:** Must include a freestanding "island" unit, typically containing additional counter space and/or a sink or cooktop (optional for this task).
- **Eating area:** Chairs couldn't be placed around the island if it is cooktop or sink. Better to place chairs around the table, create an full eating area if there's enough space.
- **Perimeter Cabinets:** Ensure perimeter cabinets and appliances are placed along one or more walls.
- **Island Clearance:** Ensure at least 1 meter of clearance around all sides of the island for movement.
- **Eating Area:** If space allows, include a table and chairs; attach one side to the island or place it in the center of the kitchen, ensuring at least 0.8 meters of clearance around the table.
"""

one_row_kitchen_spec = """
### One Row Kitchen configuration:
- **Shape:** Must consist of a single straight run of cabinets and appliances along one wall.
- **Layout Efficiency:** Prioritize placing the sink between the refrigerator and cooktop to maintain an efficient work triangle, if space allows.
- **Eating Area:** If space allows, include a narrow island or wall-attached table opposite the main counter, ensuring at least 1 meter of clearance.
"""

counter_type_choice = """
Objective: Determine the most suitable kitchen counter style for a given room, based on dimensions, room shape, and positions of doors and windows.

Kitchen counter styles:
- Galley Kitchen counter (two parallel rows)
- One-Wall Kitchen counter (single row)
- L-Shaped Kitchen counter
- U-Shaped Kitchen counter
- G-Shaped Kitchen counter
- Island Kitchen counter

Selection criteria:
- **Galley Kitchen counter**: Narrow, rectangular rooms (length significantly greater than width); suitable when doors/windows are on shorter opposite walls.
- **One-Wall Kitchen counter**: Small, narrow spaces or rooms heavily obstructed by doors/windows on other walls.
- **L-Shaped Kitchen counter**: Square/moderate rectangular rooms, optimal in corners with two adjacent walls available; avoid doors/windows on potential L-shaped walls.
- **U-Shaped Kitchen counter**: Larger rooms, ideal when one long wall and two shorter adjacent walls are free. L-shape room is suitable for this counter style to fill the L leg. 
- **G-Shaped Kitchen counter**: Spacious rooms, suitable if a U-shape could be extended slightly with a peninsula.
- **Island Kitchen counter**: Large open-plan kitchens, requiring minimum 1m clearance around the central island; suitable for rooms unified with dining spaces.


Output example:
{{
  "chosen_counter_style": "Galley Kitchen",
  "reasoning": "The room dimensions (4.0m x 3.0m) are rectangular, and the door placement allows efficient parallel rows along the longer walls, optimizing workspace and passage clearance."
}}

Determine the kitchen counter style based on this INPUT:
{room_input}

Return only the output in JSON format.
"""

room_generation_prompt = """
Generate a dataset of 20 kitchen layouts in JSON format. The output should be a JSON list where each element is a dictionary representing a single layout.

**Layout Structure:**

Each layout dictionary must contain the following keys:
* `layout_id`: An integer uniquely identifying the layout (start from 0).
* `room`: A dictionary describing the room dimensions and shape.
* `objects`: A list of dictionaries, each describing an object placed within the kitchen.

**`room` Dictionary Details:**
* `width`: A float representing the width of the room in meters (between 2.5 and 5.0).
* `depth`: A float representing the depth of the room in meters (between 2.5 and 5.0).
* `units`: A string, fixed value `"meters"`.
* `shape`: String, must be one of `"rectangular"`, `"L-shape"`, or `"open"`.
* `shape_description`: A string summarizing the room's shape, including details of cutouts or open walls (e.g., "Rectangular kitchen", "L-shaped room with a 1.5x1.5 cutout at the `"top-right"` (or any other corner) corner (x=3.0-4.5, y=2.5-4.0)", "Open kitchen (`"top"` wall removed, or `"left"`, or `"right"`, or `"bottom"`.)").

**`objects` List Details:**
Each dictionary in the `objects` list must describe an object and include the keys: `"label"`, `"bbox"`: [y0, x0, y1, x1] and `"comment"` about location.

Coordinate system
"coordinate_system": {
    "y_axis": "depth (vertical, top to bottom)",
    "x_axis": "width (horizontal, left to right)",
    "origin": "(0, 0) - top-left corner",
    "x_range": "[0, width]",
    "y_range": "[0, depth"
  }

* **Possible `"label"` values:**
    * `"cutout_area"`: Represents the removed area in L-shaped rooms.
    * `"door"`: Represents the single doorway into the kitchen (only for Rectangular/L-shape rooms).
    * `"window"`: Represents windows.

**Constraints and Requirements:**

0. **Room size** - generate different room sizes: small kitchens (7m² or less) - 40%, medium kitchens (7–18 m²) - 40%, and big kitchen (> 18 m²) - 20 %. Generate different proportions for the width and depth.
1.  **Quantity & Distribution:** Generate exactly 20 layouts: 40% rectangular, 40% L-shaped, and 20% open.
2.  **L-Shapes:** Cutout areas must be placed in one of the four corners. The remaining 'legs' of the L-shape must each have a minimum width and depth of 1.5 meters.
3.  **Doors:** Layouts where the `kitchen_layout` object has `shape` `"rectangular"` or `"L-shape"` must contain exactly one object of type `"door"`. Layouts where the `shape` is `"open"` must contain **zero** objects of type `"door"`.
4.  **Door/Window Walls:** In layouts with a door, objects of type `"window"` cannot be placed on the same wall as the object of type `"door"`.
5. **Window Area Ratio:**  
   - Total window length must be **>15%** of the floor area. Floor area = (room width × depth) minus any cutout areas.
6. **Window Grouping and Sizes:**  
   - Windows on the **same wall** should be of **equal size** (if it's possible).  
   - **One small window** (less than 1m) alone in the room is **not allowed**, it's impossible.  
   - **One large** window is OK; **two small** windows are OK, more windows are OK.  
   - If window width exceeds **1.5m**, split it into **multiple standard windows** (0.6m, 0.75m, 0.9m, or 1.2m wide).  
   - Add small gaps (0.05m–0.15m) between windows.
7. **Window Placement:**  
   - Do **not** place windows on **opposite walls**.  
   - Multiple windows should be on the **same** or **adjacent** walls.
8. **Doors and Windows short size:** For simplicity, the short size of the door is *0.1m* and the short size of the window is *0.0m*.
9. **Validity:** All objects must be placed strictly within the usable room boundaries (considering cutouts for L-shapes). Door widths (where present) should be between 0.8m and 1.0m.
10. **Output Format:** The final output must be a single, valid JSON list containing the 20 layout dictionaries, with no comments (`/* ... */`) included.
Example:

{
  "layout_id": 1,
  "room": {
    "width": 3.5,
    "depth": 3.0,
    "units": "meters",
    "shape": "rectangular",
    "shape_description": "Rectangualar kitchen"
  },
  "coordinate_system": {
    "y_axis": "depth (vertical, top to bottom)",
    "x_axis": "width (horizontal, left to right)",
    "origin": "(0, 0) - top-left corner",
    "x_range": "[0, 3.5]",
    "y_range": "[0, 3.0]"
  },
  "objects": [
    {
      "label": "door",
      "bbox": [0.0, 0.1, 0.1, 1.0],
      "comment": "The single door is placed on the top wall (y=0), near the left corner, allowing ingress/egress without obstructing the main L-shaped counter area."
    },
    {
      "label": "window",
      "bbox": [0.5, 0.0, 2.0, 0.0],
      "comment": "A window on the left wall (x=0), enhancing natural light, particularly near the eating area. Total window length meets the requirement (>15% of area)."
    }
  ]
}
"""


open_room = """
{
    "layout_id": 9,
    "room": {
        "width": 4.0,
        "depth": 3.0,
        "units": "meters",
        "shape": "open",
        "shape_description": "Open kitchen (right wall removed)"
    },
    "coordinate_system": {
        "y_axis": "depth (vertical, top to bottom)",
        "x_axis": "width (horizontal, left to right)",
        "origin": "top-left corner",
        "x_range": "[0, 4.0]",
        "y_range": "[0, 3.0]"
    },
    "layout_style": {
        "chosen_counter_style": "L-Shaped Kitchen",
        "reasoning": "The room is 4.0m x 3.0m and described as 'open' with the right wall removed. The top wall (y=0) is heavily obstructed by windows. An L-shape utilizing the bottom wall (y=3.0) and the left wall (x=0) is suitable. This configuration avoids the window obstructions, fits the moderate rectangular dimensions, and works well with the open-plan layout by defining the kitchen area while maintaining flow to the adjacent space."
    },
    "objects": [
        {
            "label": "window",
            "bbox": [
                0.0,
                0.7,
                0.0,
                1.7
            ],
            "comment": "Pre-defined window on the top wall, provides natural light."
        },
        {
            "label": "window",
            "bbox": [
                0.0,
                1.8,
                0.0,
                2.8
            ],
            "comment": "Pre-defined window on the top wall, provides natural light."
        },
        {
            "label": "corner_cabinet",
            "bbox": [
                2.4,
                0.0,
                3.0,
                0.6
            ],
            "comment": "Forms the corner of the L-shaped counter layout, utilizing the bottom-left corner of the room."
        },
        {
            "label": "base_cabinet",
            "bbox": [
                2.4,
                0.6,
                3.0,
                1.2
            ],
            "comment": "Counter space along the bottom wall, adjacent to the corner cabinet."
        },
        {
            "label": "sink",
            "bbox": [
                2.4,
                1.2,
                3.0,
                1.8
            ],
            "comment": "Positioned on the bottom wall run, forming part of the work triangle."
        },
        {
            "label": "dishwasher",
            "bbox": [
                2.4,
                1.8,
                3.0,
                2.4
            ],
            "comment": "Located conveniently adjacent to the sink on the bottom wall."
        },
        {
            "label": "base_cabinet",
            "bbox": [
                2.4,
                2.4,
                3.0,
                3.0
            ],
            "comment": "Provides essential counter prep space between the sink/dishwasher and the stove."
        },
        {
            "label": "stove",
            "bbox": [
                2.4,
                3.0,
                3.0,
                3.6
            ],
            "comment": "Positioned on the bottom wall run, completing the main work zone and triangle."
        },
        {
            "label": "base_cabinet",
            "bbox": [
                2.4,
                3.6,
                3.0,
                4.0
            ],
            "comment": "Landing space next to the stove, extending the counter to the edge of the open side."
        },
        {
            "label": "fridge",
            "bbox": [
                0.6,
                0.0,
                1.2,
                0.6
            ],
            "comment": "Placed at the top end of the left counter run, completing the work triangle."
        },
        {
            "label": "base_cabinet",
            "bbox": [
                1.2,
                0.0,
                1.8,
                0.6
            ],
            "comment": "Counter space along the left wall, part of the L-shape."
        },
        {
            "label": "base_cabinet",
            "bbox": [
                1.8,
                0.0,
                2.4,
                0.6
            ],
            "comment": "Counter space along the left wall, connecting towards the corner cabinet."
        },
        {
            "label": "base_cabinet",
            "bbox": [
                0.0,
                0.0,
                0.6,
                0.6
            ],
            "comment": "Fills the remaining space on the left wall run, next to the fridge."
        },
        {
            "label": "table",
            "bbox": [
                0.5,
                1.8,
                1.3,
                3.0
            ],
            "comment": "Rectangular eating table (1.2m x 0.8m) placed in the open area, near windows and maintaining clearance."
        },
        {
            "label": "chair",
            "bbox": [
                0.3,
                2.2,
                0.7,
                2.6
            ],
            "comment": "Seating at the top side of the table (near window), positioned partially under the table."
        },
        {
            "label": "chair",
            "bbox": [
                1.1,
                2.2,
                1.5,
                2.6
            ],
            "comment": "Seating at the bottom side of the table, maintains clearance from the kitchen counters. Positioned partially under the table."
        },
        {
            "label": "chair",
            "bbox": [
                0.7,
                1.6,
                1.1,
                2.0
            ],
            "comment": "Seating at the left side of the table, maintains clearance from the fridge. Positioned partially under the table."
        },
        {
            "label": "chair",
            "bbox": [
                0.7,
                2.8,
                1.1,
                3.2
            ],
            "comment": "Seating at the right side of the table, near the open room edge with adequate clearance. Positioned partially under the table."
        }
    ]
}
"""

l_shaped_room = """
{
    "layout_id": 5,
    "room": {
        "width": 3.0,
        "depth": 3.0,
        "units": "meters",
        "shape": "L-shape",
        "shape_description": "L-shaped room with a 1.5x1.5 cutout at the bottom-left corner (x=0.0-1.5, y=1.5-3.0)"
    },
    "coordinate_system": {
        "y_axis": "depth (vertical, top to bottom)",
        "x_axis": "width (horizontal, left to right)",
        "origin": "(0, 0) - top-left corner",
        "x_range": "[0, 3.0]",
        "y_range": "[0, 3.0]"
    },
    "layout_style": {
        "chosen_counter_style": "U-Shaped Kitchen",
        "reasoning": "The room has an L-shape (overall 3.0m x 3.0m with a 1.5m x 1.5m corner cutout). The U-shaped counter criteria explicitly state suitability for L-shaped rooms to fill the 'L'. Using the Right wall (3.0m), Bottom wall (3.0m), and the available Right top section (1.5m) forms a natural U-shape that maximizes counter space and efficiently utilizes the room's configuration. The window and door placements do not prevent this layout."
    },
    "objects": [
        {
            "label": "cutout_area",
            "bbox": [
                1.5,
                0.0,
                3.0,
                1.5
            ],
            "comment": "Defines the non-usable L-shape cutout area."
        },
        {
            "label": "door",
            "bbox": [
                0.0,
                0.9,
                0.0,
                1.73
            ],
            "comment": "Located on the top wall."
        },
        {
            "label": "window",
            "bbox": [
                0.28,
                3.0,
                1.48,
                3.0
            ],
            "comment": "Located on the right wall."
        },
        {
            "label": "corner_cabinet",
            "bbox": [
                0.0,
                2.4,
                0.6,
                3.0
            ],
            "comment": "Top-right corner cabinet, connecting the top and right counter runs of the U-shape."
        },
        {
            "label": "corner_cabinet",
            "bbox": [
                2.4,
                2.4,
                3.0,
                3.0
            ],
            "comment": "Bottom-right corner cabinet, connecting the right and bottom counter runs of the U-shape."
        },
        {
            "label": "stove",
            "bbox": [
                0.0,
                1.8,
                0.6,
                2.4
            ],
            "comment": "Positioned on the top counter run, completing the work triangle with the sink and fridge."
        },
        {
            "label": "sink",
            "bbox": [
                0.6,
                2.4,
                1.2,
                3.0
            ],
            "comment": "Double sink placed under the window on the right wall for natural light and views."
        },
        {
            "label": "dishwasher",
            "bbox": [
                1.2,
                2.4,
                1.8,
                3.0
            ],
            "comment": "Located adjacent to the sink on the right wall for efficient loading/unloading."
        },
        {
            "label": "base_cabinet",
            "bbox": [
                1.8,
                2.4,
                2.4,
                3.0
            ],
            "comment": "Cabinet on the right wall, providing storage and counter space near the sink area."
        },
        {
            "label": "fridge",
            "bbox": [
                2.4,
                1.5,
                3.0,
                2.1
            ],
            "comment": "Positioned at the start of the bottom counter run, completing the U-shape and easily accessible."
        },
        {
            "label": "base_cabinet",
            "bbox": [
                2.4,
                2.1,
                3.0,
                2.4
            ],
            "comment": "Small cabinet utilizing the remaining space on the bottom run between the fridge and the corner cabinet."
        },
        {
            "label": "table",
            "bbox": [
                0.8,
                0.0,
                1.5,
                0.7
            ],
            "comment": "Compact 0.7x0.7m eating table placed next to the L-shape cutout area to maximize kitchen functionality without obstructing workflow."
        },
        {
            "label": "chair",
            "bbox": [
                0.95,
                0.6,
                1.35,
                1.0
            ],
            "comment": "Chair placed on the right side of the table within the cutout space, positioned partially underneath."
        },
        {
            "label": "chair",
            "bbox": [
                0.6,
                0.15,
                1.0,
                0.55
            ],
            "comment": "Chair placed on the bottom side of the table within the cutout space, positioned partially underneath."
        }
    ]
}
"""

rectangular_room = """
{
    "layout_id": 0,
    "room": {
        "width": 2.5,
        "depth": 2.5,
        "units": "meters",
        "shape": "rectangular",
        "shape_description": "Rectangular kitchen"
    },
    "coordinate_system": {
        "y_axis": "depth (vertical, top to bottom)",
        "x_axis": "width (horizontal, left to right)",
        "origin": "top-left corner",
        "x_range": "[0, 2.5]",
        "y_range": "[0, 2.5]"
    },
    "layout_style": {
        "chosen_counter_style": "L-Shaped Kitchen",
        "reasoning": "The room is small and square (2.5m x 2.5m). An L-shaped layout is suitable for square rooms. The door on the left wall ([0.0, 1.38, 0.0, 2.23]) and the window on the top wall ([0.44, 0.0, 1.64, 0.0]) leave the bottom and right walls fully available, forming an ideal corner for an L-shaped counter, maximizing workspace and storage in the limited space."
    },
    "objects": [
        {
            "label": "door",
            "bbox": [
                0.0,
                1.38,
                0.0,
                2.23
            ],
            "comment": "Existing door located on the top wall, towards the right."
        },
        {
            "label": "window",
            "bbox": [
                0.44,
                0.0,
                1.64,
                0.0
            ],
            "comment": "Existing window located on the left wall."
        },
        {
            "label": "corner_cabinet",
            "bbox": [
                1.9,
                1.9,
                2.5,
                2.5
            ],
            "comment": "Forms the corner of the L-shape in the bottom-right, connecting the two counter runs. Assumes 0.6m depth along each adjacent wall."
        },
        {
            "label": "fridge",
            "bbox": [
                1.9,
                0.0,
                2.5,
                0.7
            ],
            "comment": "Placed at the start of the bottom counter run, providing separation from the sink. Part of the work triangle."
        },
        {
            "label": "dishwasher",
            "bbox": [
                1.9,
                0.7,
                2.5,
                1.3
            ],
            "comment": "Positioned adjacent to the sink cabinet for functional workflow and plumbing efficiency along the bottom counter run."
        },
        {
            "label": "sink",
            "bbox": [
                1.9,
                1.3,
                2.5,
                1.9
            ],
            "comment": "Sink integrated into a base cabinet, located near the corner on the bottom run, next to the dishwasher. Completes the work triangle."
        },
        {
            "label": "stove",
            "bbox": [
                0.7,
                1.9,
                1.3,
                2.5
            ],
            "comment": "Positioned at the start of the right counter run (near the top wall/door), completing the work triangle. Standard 70cm depth assumed."
        },
        {
            "label": "base_cabinet",
            "bbox": [
                1.3,
                1.9,
                1.9,
                2.5
            ],
            "comment": "Completes the base cabinet run up to the corner cabinet along the right wall, maximizing counter space."
        },
        {
            "label": "table",
            "bbox": [
                0.8,
                0.6,
                1.4,
                1.2
            ],
            "comment": "Compact square table (0.6x0.6m) positioned in the free top-left area, providing an eating space without obstructing pathways or clearances significantly."
        },
        {
            "label": "chair",
            "bbox": [
                0.9,
                0.4,
                1.3,
                0.8
            ],
            "comment": "Placed on the left side of the table, partially tucked underneath. Positioned near the window wall."
        },
        {
            "label": "chair",
            "bbox": [
                0.9,
                1.0,
                1.3,
                1.4
            ],
            "comment": "Placed on the right side of the table, partially tucked underneath. Maintains clearance from the main L-shaped work area."
        }
    ]
}
"""
