# Unsupervised-Learning-for-Combinatorial-Optimization-with-Principled-Proxy-Design
The official implementation of Unsupervised Learning for Combinatorial Optimization with Principled Proxy Design.

# Introduction of the Framework - a Simplified Tutorial
Our framework is a general unsupervised framework that could be used in the following problems:

|                                                   | Our framework |
|:-------------------------------------------------:|:-------------:|
|    LCO: learning for combinatorial optimization   |    &#9745;    |
|  PCO: the objective/constraints require learning  |    &#9745;    |
|      Binary optimization variable: X = {0,1}      |    &#9745;    |
| Non-binary optimization variable: X = {0,1,...,n} |   &#9745; *   |

\* The non-binary optimization variables coule be formulated into the binary forms, (e.g.
Choosing from $(1,2,3)$ could be represented as a binary vector $(X_1,X_2,X_3)$ with a constraint $X_1 + X_2 + X_3 \leq 1$), and then solved with our
framework. But note that adding too many constraints might make the training process more difficult. We are working on the future work to solve this problem.

Here we introduce  steps to solve your CO problem!

## Step 1: formulate the problem
List the consiguration $C$ and the optimization variable $X$ of the problem,

Find out the objective $f(X;C)$ and the constraint $g(X;C)$, (when either $f$ or $g$ could not be written out by hand, learn them with neural networks!)
Form the problem into the following form:

$$ \min_{X \in \{0,1\}^n} f(X;C) \ \ \text{s.t. } g(X;C) < 1$$

An example of the normalization of the constraint to follow the above form is: $(g(\cdot;C) - g_{\min})/(g_{\min}^+ - g_{\min})$, where $g_{\min}^+ = \min_{X \in \{0,1\}^n \backslash \Omega} g(X;C)$ and $g_{\min} = \min_{X \in \{0,1\}^n} g(X;C)$. They could be easily eatimated in practice.

*(unfinished)*

# Environment Requirements
The following packages are required to install to implement our code:
```shell
Python 3.7.1
torch 1.9.0
torch-cluster           1.5.9
torch-geometric         1.7.2
torch-scatter           2.0.8
torch-sparse            0.6.11
torch-spline-conv       1.2.1
pandas                  1.3.0
numpy                   1.20.3
torchvision             0.10.0
tqdm                    4.62.2

Optional but recommend:
numba                   0.55.0 (accelerate the dataset generation)
matplotlib              3.5.1 (visualization)


```

# Application I: Feature Based Edge Covering and Node Matching in Graphs

# Application II: Resource Allocation in Circuit Design

# Application III: Imprecise Functional Unit Assignment in Approximate Computing
