#!/usr/bin/env python3
"""
DATE-GFN: Distillation-Aware Twisted Evolutionary GFlowNets
Setup script for package installation.
"""

from setuptools import setup, find_packages
import os

# Read the README file
with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

# Read requirements
with open("requirements.txt", "r", encoding="utf-8") as fh:
    requirements = [line.strip() for line in fh if line.strip() and not line.startswith("#")]

# Remove development dependencies from requirements
core_requirements = []
for req in requirements:
    if not any(dev_pkg in req for dev_pkg in ["pytest", "black", "isort", "mypy", "flake8", "pre-commit"]):
        core_requirements.append(req)

setup(
    name="date-gfn",
    version="1.0.0",
    author="Your Name",
    author_email="your.email@domain.com",
    description="Distillation-Aware Twisted Evolutionary GFlowNets for Constrained Generative Modeling",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/your-username/DATE-GFN-Research",
    packages=find_packages(where="src"),
    package_dir={"": "src"},
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Science/Research",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
    ],
    python_requires=">=3.8",
    install_requires=core_requirements,
    extras_require={
        "dev": [
            "pytest>=6.2.0",
            "black>=21.0.0",
            "isort>=5.9.0",
            "mypy>=0.910",
            "flake8>=3.9.0",
            "pre-commit>=2.15.0",
        ],
        "jupyter": [
            "jupyter>=1.0.0",
            "ipywidgets>=7.6.0",
        ],
        "optim": [
            "optuna>=2.10.0",
            "ray[tune]>=1.13.0",
        ],
        "all": [
            "pytest>=6.2.0",
            "black>=21.0.0",
            "isort>=5.9.0",
            "mypy>=0.910",
            "flake8>=3.9.0",
            "pre-commit>=2.15.0",
            "jupyter>=1.0.0",
            "ipywidgets>=7.6.0",
            "optuna>=2.10.0",
            "ray[tune]>=1.13.0",
        ]
    },
    entry_points={
        "console_scripts": [
            "date-gfn-train=scripts.train:main",
            "date-gfn-evaluate=scripts.evaluate:main",
            "date-gfn-demo=examples.quick_start.demo:main",
        ],
    },
    include_package_data=True,
    package_data={
        "date_gfn": ["configs/*.yaml"],
    },

)
