"""
DATE-GFN: Distillation-Aware Twisted Evolutionary GFlowNets

A framework for constrained generative modeling that combines evolutionary algorithms
with generative flow networks through a distillation-aware fitness function.
"""

__version__ = "1.0.0"
__author__ = "Your Name"
__email__ = "your.email@domain.com"

# Core imports
from .core.date_gfn import DATEGFN, DistillationAwareFitnessFunction, EvolutionaryAlgorithm
from .core.gfn_base import GFlowNetBase, GFlowNetPolicy
from .environments.environments import HypergridEnvironment
from .baselines.baselines import GFNBaseline, EGFNBaseline, SACBaseline, MARSBaseline

# Utilities (only import what exists)
try:
    from .utils.wandb_logger import WandbLogger
except ImportError:
    WandbLogger = None

__all__ = [
    # Core classes
    "DATEGFN",
    "DistillationAwareFitnessFunction", 
    "EvolutionaryAlgorithm",
    "GFlowNetBase",
    "GFlowNetPolicy",
    
    # Environments
    "HypergridEnvironment",
    
    # Baselines
    "GFNBaseline",
    "EGFNBaseline", 
    "SACBaseline",
    "MARSBaseline",
    
    # Utilities
    "WandbLogger",
]