export LC_ALL="POSIX"

# Specify your python env, or just `python`
PYTHON_BIN=/opt/conda_envs/envs/vllm/bin/python

MODEL=Qwen/Qwen2.5-Coder-32B-Instruct # or /path/to/model
TP=8
MODE=chat
QUESTION_MODE=description
JUDGE_MODEL=Qwen/Qwen2.5-VL-72B-Instruct # or /path/to/model
JUDGE_TP=8

ROOT_FOLDER=examples/qwen2.5-coder-32b

# ===================================

${PYTHON_BIN} -u gen.py \
  --backend vllm \
  --model ${MODEL} \
  --tp ${TP} \
  --max_new_tokens 4096 \
  --num_samples 10 \
  --temperature 0.7 \
  --top_p 0.95 \
  --top_k 20 \
  --presence_penalty 1.05 \
  --save_folder ${ROOT_FOLDER} \
  --mode ${MODE} \
  --question_mode ${QUESTION_MODE}


output_folder="${ROOT_FOLDER}/${QUESTION_MODE}"
rendered_svg_file="${output_folder}/rendered_svg.jsonl"
judged_output_file="${output_folder}/judged_svg.jsonl"
metric_output_file="${output_folder}/summarized.json"

${PYTHON_BIN} -u judge_resize.py \
  --judge_model ${JUDGE_MODEL} \
  --input_file ${rendered_svg_file} \
  --output_file ${judged_output_file} \
  --metric_file ${metric_output_file} \
  --tp ${JUDGE_TP}