export LC_ALL="POSIX"

# Specify your python env, or just `python`
PYTHON_BIN=/opt/conda_envs/envs/vllm/bin/python

MODEL=Qwen/Qwen3-8B-Instruct # or /path/to/model
TP=2
MODE=chat
QUESTION_MODE=description
JUDGE_MODEL=Qwen/Qwen2.5-VL-72B-Instruct # or /path/to/model
JUDGE_TP=8

FORCE="thinking"

ROOT_FOLDER=examples/qwen3-8b-think

${PYTHON_BIN} -u gen.py \
  --backend vllm \
  --model ${MODEL} \
  --tp ${TP} \
  --max_new_tokens 32768 \
  --num_samples 10 \
  --temperature 0.6 \
  --top_p 0.95 \
  --top_k 20 \
  --presence_penalty 1.1 \
  --save_folder ${ROOT_FOLDER} \
  --mode ${MODE} \
  --question_mode ${QUESTION_MODE} \
  --force ${FORCE}

output_folder="${ROOT_FOLDER}/${QUESTION_MODE}"
rendered_svg_file="${output_folder}/rendered_svg.jsonl"
judged_output_file="${output_folder}/judged_svg.jsonl"
metric_output_file="${output_folder}/summarized.json"

${PYTHON_BIN} -u judge_resize.py \
  --judge_model ${JUDGE_MODEL} \
  --input_file ${rendered_svg_file} \
  --output_file ${judged_output_file} \
  --metric_file ${metric_output_file} \
  --tp ${JUDGE_TP}