class GenModelBase:
    def __init__(
        self,
        model,
        temperature,
        max_new_tokens,
        stop=None,
        is_chat_model=True,
        inference_args=None,
    ):
        self.model_path = model
        self.temperature = temperature
        self.max_new_tokens = max_new_tokens
        self.stop = stop
        self.is_chat_mode = is_chat_model
        self.inference_args = inference_args or {}

    def preprocess_prompt(self):
        pass

    def generate(self):
        pass

    def close(self):
        pass
