

def get_args():
    import argparse
    parser = argparse.ArgumentParser(description='')
    parser.add_argument('--val_method', '-vm', choices=['holdout', 'kfold', 'jkfold', 'LZO',
                                                        'split_free', 'split_free_joint', 'split_free_random', 'split_free_test',
                                                        'split_free_holdout', 'split_free_noval'], required=True)
    parser.add_argument('--J', type=int, default=1, required=False)
    parser.add_argument('--k', type=int, required=True)

    parser.add_argument('--save_path', type=str, required=False, default='/data/omf/model/DataValidation/NLP/experiments/')
    parser.add_argument('--dst_name', type=str, required=True)

    parser.add_argument('--lr', type=float, default=2e-5, required=False)
    parser.add_argument('--weight_decay', type=float, default=0.01, required=False)
    parser.add_argument('--batch_size', type=int, default=8, required=True)
    parser.add_argument('--num_epochs', type=int, default=10, required=True)

    args = parser.parse_args()
    return args


def get_fe_args():
    import argparse
    parser = argparse.ArgumentParser(description='')
    parser.add_argument('--lr', type=float, default=2e-5, required=False)
    parser.add_argument('--weight_decay', type=float, default=0.01, required=False)
    parser.add_argument('--batch_size', type=int, default=8, required=True)
    parser.add_argument('--num_epochs', type=int, default=10, required=True)
    parser.add_argument('--dst_name', type=str, required=True)
    parser.add_argument('--fe_type', type=str, choices=['default', 'kfold'], required=True)
    parser.add_argument('--k', type=int,  default=5, required=False)

    args = parser.parse_args()

    return args

