import matplotlib.pyplot as plt
import seaborn as sns


def draw_real_syn_distribution(data, hue_key):
    graph = sns.JointGrid(data=data, x="angle", y="diversity", hue=hue_key)
    graph.plot_joint(sns.kdeplot, color="orange", hue=hue_key)
    graph.plot_joint(sns.scatterplot, alpha=.8, s=2, hue=hue_key)
    graph.plot_marginals(sns.histplot, kde=True, bins=50, hue=hue_key, stat='probability') #  hist_kws={"norm_hist":True}
    plt.show()
