import numpy as np
import yaml
import os
import torch


def setup_seed(seed):
    import random
    print("Random Seed: ", seed)
    np.random.seed(seed)
    random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    torch.backends.cudnn.deterministic = True
    torch.backends.cudnn.benchmark = False
    # torch.backends.cudnn.enabled = False


def mkdir(path):
    path=path.strip()
    path=path.rstrip("\\")
    isExists=os.path.exists(path)
    if not isExists:
        os.makedirs(path)
        print(path+' create success!')
        return True
    else:
        print(path+' existed!')
        return False


class PathConfig(object):
    def __init__(self, cfg_path):
        with open(cfg_path, 'r') as f:
            cfg = yaml.safe_load(f)
        self.cfg = cfg


def generate_seed_set(num):
    """ Generate 100 random seeds

    :return: list contains 100 seeds
    """
    np.random.seed(0)
    seed_set = np.random.randint(0, 10000, size=num).tolist()
    return seed_set


if __name__ == '__main__':
    def create_folder_in_config():
        pc = PathConfig()
        mkdir(pc.get_cifar10_dataset_path())
        mkdir(pc.get_cifar10_data_pool_path())
        mkdir(pc.get_cifar10_index_path())
        mkdir(pc.get_cifar10_fe_path())

