
def get_fe_train_args():
    import argparse
    parser = argparse.ArgumentParser(description='')
    parser.add_argument('--k', type=int)
    args = parser.parse_args()
    return args


def get_dst_name_args():
    import argparse
    parser = argparse.ArgumentParser(description='')
    parser.add_argument('--dst_name', type=str,
                        choices=['diabetes', 'bank_marketing', 'mushroom', 'pageblocks', 'job', 'heart'])
    args = parser.parse_args()
    return args


def get_args():
    import argparse
    parser = argparse.ArgumentParser(description='')
    parser.add_argument('--val_method', '-vm', choices=['holdout', 'kfold', 'jkfold', 'aug_holdout', 'aug_kfold', 'aug_jkfold',
                                                        'random_aug_holdout', 'random_aug_kfold',
                                                        'LZO','SPlit',
                                                        'split_free_holdout', 'split_free_joint', 'split_free_random',
                                                        'split_free_test', 'split_free_noval'])
    parser.add_argument('--k', type=int)
    parser.add_argument('--J', type=int)
    parser.add_argument('--val_num_per_class', type=int, required=False)
    parser.add_argument('--model',  type=str, choices=['xgb', 'rfc', 'lr', 'tabtransformer'])
    parser.add_argument('--result_save_name', type=str)
    parser.add_argument('--dst_name', type=str,
                        choices=['car_eval', 'diabetes', 'bank_marketing', 'mushroom', 'pageblocks', 'job', 'heart', 'syn'])
    # parser.add_argument('--coreset_val_ratio', type=float, required=False, default=0)
    args = parser.parse_args()
    return args


def complete_cfg_by_args(cfg, args):
    cfg['dst_name'] = args.dst_name
    cfg['val_method'] = args.val_method
    cfg['k'] = args.k
    cfg['repeat_j'] = args.J
    cfg['model'] = args.model
    cfg['result_save_path'] = args.result_save_name
    return cfg
