# Detect Everything with Few Examples

Paper ID #5466


## Installation

```bash
cd Code/
conda create -n devit  python=3.9 
conda activate devit
pip install -r requirements.txt
pip install -e .
```

Next, check [Downloads.md](Downloads.md) for instructions to setup datasets and model checkpoints.

## Running Scripts

Download datasets and checkpoints before running scripts.

## Demo

![](demo/output/ycb.out.jpg)

```bash
python3 ./demo/demo.py # will generate demo/output/ycb.out.jpg
```

The notebook [demo/build_prototypes.ipynb](demo/build_prototypes.ipynb) builds prototypes for YCB objects using ViT-L/14 and our provided example images.

## Training

Examples:

```bash
vit=s task=fsod dataset=voc split=1 bash scripts/train.sh  # train Few-Shot Pascal VOC Split-1 with ViT-S

########## parameter setup ##########
# task=fsod / osod
# dataset=voc / coco / lvis
# vit=s / b / l

# few-shot env var `shot = 5 / 10 / 30` for COCO
vit=l task=fsod shot=10 dataset=coco bash scripts/train.sh 

# one-shot env var `split = 1 / 2 / 3 / 4`
vit=l task=osod split=1 bash scripts/train.sh

# detectron2 options can be provided through args, e.g.,
dataset=lvis bash scripts/train.sh MODEL.MASK_ON True # train lvis with mask head

# another env var is `num_gpus = 1 / 2 ...`, used to control
# how many gpus are used
```


## Evaluating Pretrained Models

All evaluations can be run without training, as long as the checkpoints and datasets are downloaded. The script-level environment variables are the same to training. 

Examples: 

```bash
vit=l task=fsod dataset=coco bash scripts/eval.sh # evaluate COCO FSOD with ViT-L/14

vit=l dataset=lvis bash scripts/eval.sh DE.TOPK 10  MODEL.MASK_ON True  # evaluate LVIS with ViT-L/14 and T = 10. Note that TOPK is the T parameter mentioned in paper. 
```
