import numpy as np

from utils.aggregations import aggregate
from utils.helpers import compile_param_list

# Unweighted aggregation


def UA(data_params, params):
    name = params.get("name", 'UA')
    mode = data_params['mode']
    voting_rule = params.get("voting_rule", mode)
    n = data_params["df"].shape[0]
    weights = np.ones(n) / n
    answers = aggregate(weights, data_params, params)
    return {'af_name': name, 'af_params': compile_param_list(params), 'outcome': answers, 'weights': weights,
            'vr_name': voting_rule}
