# POLTER: Policy Trajectory Ensemble Regularization for Unsupervised Reinforcement Learning

This source code is based on the [URLB](https://github.com/rll-research/url_benchmark) and adds versions for each agent that use POLTER regularization.

## Abstract

The goal of Unsupervised Reinforcement Learning (URL) is to find a reward-agnostic prior policy on a task domain, such that the sample-efficiency on supervised downstream tasks is improved. Although agents initialized with such a prior policy can achieve a significantly higher reward with fewer samples when finetuned on the downstream task, it is still an open question how an optimal pretrained prior policy can be achieved in practice. In this work, we present POLTER (Policy Trajectory Ensemble Regularization) – a general method to regularize the pretraining that can be applied to any URL algorithm and is especially useful on data- and knowledge-based URL algorithms. It utilizes an ensemble of policies that are discovered during pretraining and moves the policy of the URL algorithm closer to its optimal prior. Our method is based on a theoretical framework, and we analyze its practical effects on a white-box benchmark, allowing us to study POLTER with full control. In our main experiments, we evaluate POLTER on the Unsupervised Reinforcement Learning Benchmark (URLB), which consists of 12 tasks in 3 domains. We demonstrate the generality of our approach by improving the performance of a diverse set of data- and knowledge-based URL algorithms by 19% on average and up to 40% in the best case. Under a fair comparison with tuned baselines and tuned POLTER, we establish a new state-of-the-art for model-free methods on the URLB.

## Explore Results

We provide a notebook `figures.ipynb` to explore the results in the `results.zip` file and reproduce the figures in the submission.

## Requirements

We assume you have access to a GPU that can run CUDA 10.2 and CUDNN 8. Then, the simplest way to install all required dependencies is to create an anaconda environment by running

```sh
conda env create -f conda_env.yml
conda activate urlb
```

## Agents

Besides the agents from the URLB, we provide POLTER regularized agents with the prefix `history_ensemble_*`, so `history_ensemble_rnd` is the `RND+POLTER` agent.

## Pretraining

```sh
python pretrain.py agent=history_ensemble_rnd domain=jaco obs_type=states action_repeat=1 frame_stack=1 agent.batch_size=1024 agent.nstep=1 seed=1 num_train_frames=2000010 eval_every_frames=20000 num_eval_episodes=10
```

## Finetuning

```sh
python finetune.py agent=history_ensemble_rnd task=jaco_reach_bottom_left obs_type=states frame_stack=1 action_repeat=1 agent.batch_size=1024 snapshot_ts=1000000 
```
