# Copyright (c) Meta Platforms, Inc. and affiliates.
# This software may be used and distributed according to the terms of the Llama 2 Community License Agreement.

import os
from dataclasses import dataclass


@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data.json"

class Triviaqa_llama2_7b_chat_threshold_1_0_different:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_contrastive_knowing_0.7_with_anchor.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_contrastive_knowing_0.7_with_anchor.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_contrastive:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_contrastive.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_contrastive.json"

@dataclass
class Triviaqa_mistral_7B_instruct_v0_1_threshold_1_0_contrastive:
    dataset: str = "KB_triviaqa_mistral_7b_instruct_v0_1"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/mistral-7b-instruct-v0.1/triviaqa_train_threshold_1.0_sft_data_contrastive.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/mistral-7b-instruct-v0.1/triviaqa_valid_threshold_1.0_sft_data_contrastive.json"


@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_contrastive_knowing_0_7:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_contrastive_knowing_0.7.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_contrastive_knowing_0.7.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_contrastive_knowing_0_7_with_anchor:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_contrastive_knowing_0.7_with_anchor.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_contrastive_knowing_0.7_with_anchor.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_contrastive_knowing_0_5_with_anchor:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_contrastive_knowing_0.5_with_anchor.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_contrastive_knowing_0.5_with_anchor.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_contrastive_knowing_0_6_with_anchor:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_contrastive_knowing_0.6_with_anchor.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_contrastive_knowing_0.6_with_anchor.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_contrastive_knowing_0_8_with_anchor:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_contrastive_knowing_0.8_with_anchor.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_contrastive_knowing_0.8_with_anchor.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_contrastive_knowing_0_9_with_anchor:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_contrastive_knowing_0.9_with_anchor.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_contrastive_knowing_0.9_with_anchor.json"

@dataclass
class Triviaqa_mistral_7B_instruct_v0_1_threshold_1_0_contrastive_debug:
    dataset: str = "KB_triviaqa_mistral_7b_instruct_v0_1"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/mistral-7b-instruct-v0.1/triviaqa_train_threshold_1.0_sft_data_contrastive_debug.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/mistral-7b-instruct-v0.1/triviaqa_valid_threshold_1.0_sft_data_contrastive_debug.json"

@dataclass
class Triviaqa_mistral_7B_instruct_v0_1_threshold_1_0_contrastive_knowing_0_7_with_anchor:
    dataset: str = "KB_triviaqa_mistral_7b_instruct_v0_1"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/mistral-7b-instruct-v0.1/triviaqa_train_threshold_1.0_sft_data_contrastive_knowing_0.7_with_anchor.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/mistral-7b-instruct-v0.1/triviaqa_valid_threshold_1.0_sft_data_contrastive_knowing_0.7_with_anchor.json"

@dataclass
class Triviaqa_mistral_7B_instruct_v0_1_threshold_1_0_contrastive_knowing_0_5_with_anchor:
    dataset: str = "KB_triviaqa_mistral_7b_instruct_v0_1"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/mistral-7b-instruct-v0.1/triviaqa_train_threshold_1.0_sft_data_contrastive_knowing_0.5_with_anchor.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/mistral-7b-instruct-v0.1/triviaqa_valid_threshold_1.0_sft_data_contrastive_knowing_0.5_with_anchor.json"

@dataclass
class Triviaqa_mistral_7B_instruct_v0_1_threshold_1_0_contrastive_knowing_0_9_with_anchor:
    dataset: str = "KB_triviaqa_mistral_7b_instruct_v0_1"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/mistral-7b-instruct-v0.1/triviaqa_train_threshold_1.0_sft_data_contrastive_knowing_0.9_with_anchor.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/mistral-7b-instruct-v0.1/triviaqa_valid_threshold_1.0_sft_data_contrastive_knowing_0.9_with_anchor.json"

class Triviaqa_mistral_7B_instruct_v0_1_threshold_1_0:
    dataset: str = "KB_triviaqa_mistral_7b_instruct_v0_1"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/mistral-7b-instruct-v0.1/triviaqa_train_threshold_1.0_sft_data.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/mistral-7b-instruct-v0.1/triviaqa_valid_threshold_1.0_sft_data.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_contrastive_knowing_0_7_p2_correct:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_contrastive_knowing_0.7_p2_correct.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_contrastive_knowing_0.7_p2_correct.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_contrastive_knowing_0_7_ablation_1:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_contrastive_knowing_0.7_ablation_1.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_contrastive_knowing_0.7_ablation_1.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_contrastive_knowing_0_7_ablation_2:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_contrastive_knowing_0.7_ablation_2.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_contrastive_knowing_0.7_ablation_2.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_contrastive_knowing_0_7_ablation_3:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_contrastive_knowing_0.7_ablation_3.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_contrastive_knowing_0.7_ablation_3.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_contrastive_debug:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_contrastive_debug.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_contrastive_debug.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_0_9_contrastive2_debug:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_0.9_sft_data_contrastive2_debug.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_0.9_sft_data_contrastive2_debug.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_contrastive2:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_contrastive2.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_contrastive2.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_contrastive2_debug:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_contrastive2_debug.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_contrastive2_debug.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_contrastive3:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_contrastive3.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_contrastive3.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_contrastive3_debug:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_contrastive3_debug.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_contrastive3_debug.json"


@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_debug:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_sft_data_debug.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data_debug.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_half_data:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_threshold_1.0_half_sft_data.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_threshold_1.0_sft_data.json"

@dataclass
class Triviaqa_llama2_7b_chat_threshold_1_0_preference_data:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    data_path: str = os.getcwd() + "/Idk_datasets/preference_data/llama-2-7b-chat/triviaqa_train_and_valid_llama2_7b_chat_threshold_1.0_preference_pairs_for_ppo_reward.json"

@dataclass
class Triviaqa_llama2_7b_chat_hir:
    dataset: str = "KB_triviaqa_llama2_7b_chat"
    train_split: str = "train"
    test_split: str = "val"
    train_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_train_hir_data.json"
    valid_data_path: str = os.getcwd() + "/Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_valid_hir_data.json"
