PEFT_PATH=None
FSDP_PATH=./checkpoint/llama_2_7b_chat_Idk_sft_contrastive_knowing_0_7_p2_correct_tau_0.01-/data/share/models/llama-2-7b-chat-hf
INITIAL_HF_MODEL=/data/share/models/llama-2-7b-chat-hf
CONVERTED_PATH=./models/llama_2_7b_chat_Idk_sft_contrastive_knowing_0_7_p2_correct_tau_0.01_epoch2
SAVE_PATH=./outputs/triviaqa_test_llama_2_7b_chat_threshold_1.0_idk_sft_con_knowing_0_7_p2_correct_tau_0.01_epoch2_greedy_infer_vllm.json

if [ "$PEFT_PATH" == "None" ]
then
    python -m llama_recipes.inference.checkpoint_converter_fsdp_hf \
        --fsdp_checkpoint_path $FSDP_PATH \
        --consolidated_model_path $CONVERTED_PATH \
        --HF_model_path_or_name $INITIAL_HF_MODEL
fi

if [ "$PEFT_PATH" == "None" ]
then
    CUDA_VISIBLE_DEVICES=0 python src/Inference/infer_llama_vllm.py \
        --model_name $CONVERTED_PATH \
        --batch_size 8 \
        --save_name $SAVE_PATH \
        --prompt_file Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_test_threshold_1.0_sft_data.json \
        --response_num 1 \
        --top_k 1 \
        --tensor_parallel_size 1
else
    echo "PEFT_PATH: $PEFT_PATH"
    CUDA_VISIBLE_DEVICES=0 python src/Inference/infer_llama_vllm.py \
        --model_name $INITIAL_HF_MODEL \
        --peft_model $PEFT_PATH \
        --batch_size 8 \
        --save_name $SAVE_PATH \
        --prompt_file Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_test_threshold_1.0_sft_data.json \
        --response_num 1 \
        --top_k 1 \
        --temperature 0.0 \
        --tensor_parallel_size 1
fi

echo "SAVE_PATH: $SAVE_PATH"
python src/evaluation/cal_knowledge_quadrants.py --file_name $SAVE_PATH