PEFT_PATH=None
FSDP_PATH=/data/huanghj/Contrastive/checkpoint/mistral_7B_instruct_v0.1_Idk_sft_epoch2-/data/share/Mistral-7B-Instruct-v0.1
INITIAL_HF_MODEL=/data/share/Mistral-7B-Instruct-v0.1
CONVERTED_PATH=./models/mistral_7B_instruct_Idk_sft
SAVE_PATH=./outputs/triviaqa_test_mistral_7B_instruct_threshold_1.0_idk_sft_epoch2_greedy_infer_vllm.json
gpus=1

if [ "$PEFT_PATH" == "None" ]
then
    python -m llama_recipes.inference.checkpoint_converter_fsdp_hf \
        --fsdp_checkpoint_path $FSDP_PATH \
        --consolidated_model_path $CONVERTED_PATH \
        --HF_model_path_or_name $INITIAL_HF_MODEL
fi

if [ "$PEFT_PATH" == "None" ]
then
    CUDA_VISIBLE_DEVICES=$gpus python src/Inference/infer_llama_vllm.py \
        --model_name $CONVERTED_PATH \
        --batch_size 8 \
        --save_name $SAVE_PATH \
        --prompt_file Idk_datasets/sft_data/mistral-7b-instruct-v0.1/triviaqa_test_threshold_1.0_sft_data.json \
        --response_num 1 \
        --top_k 1 \
        --tensor_parallel_size 1
else
    CUDA_VISIBLE_DEVICES=$gpus python src/Inference/infer_llama_vllm.py \
        --model_name $INITIAL_HF_MODEL \
        --peft_model $PEFT_PATH \
        --batch_size 8 \
        --save_name $SAVE_PATH \
        --prompt_file Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_test_threshold_1.0_sft_data.json \
        --response_num 1 \
        --top_k 1 \
        --temperature 0.0 \
        --tensor_parallel_size 1
fi

# python src/evaluation/cal_knowledge_quadrants.py --file_name $SAVE_PATH