gpus=0
dataset=Triviaqa_llama2_7b_chat_threshold_1_0_contrastive_knowing_0_7_ablation_2
name=llama_2_7b_chat_Idk_sft_contrastive_knowing_0_7_ablation_2_tau_0.01
CONVERTED_PATH=./models/llama_2_7b_chat_Idk_sft_contrastive_knowing_0_7_ablation_2_tau_0.01_epoch2
TRIVIAQA_SAVE_PATH=./outputs/triviaqa_test_llama_2_7b_chat_threshold_1.0_idk_sft_con_knowing_0_7_ablation_2_tau_0.01_epoch2_greedy_infer_vllm.json
NQ_SAVE_PATH=./outputs/nq_open_test_llama_2_7b_chat_threshold_1.0_idk_sft_con_knowing_0_7_ablation_2_tau_0.01_epoch2_greedy_infer_vllm.json

PEFT_PATH=None
FSDP_PATH=./checkpoint/$name-/data/share/models/llama-2-7b-chat-hf
INITIAL_HF_MODEL=/data/share/models/llama-2-7b-chat-hf



CUDA_VISIBLE_DEVICES=$gpus torchrun --nproc_per_node=1 --master-port=$(expr $RANDOM % 55535 + 10000) \
    --nnodes=1 \
    src/llama_recipes/finetuning.py \
    --enable_fsdp \
    --model_name $INITIAL_HF_MODEL \
    --dist_checkpoint_root_folder checkpoint \
    --dist_checkpoint_folder $name \
    --fsdp_config.pure_bf16 \
    --dataset $dataset \
    --gradient_accumulation_steps 4 \
    --batch_size_training 4 \
    --num_epochs 2 \
    --lr 5e-5 \
    --fsdp_config.fsdp_cpu_offload True \
    --context_length 1024 \
    --contrastive True \
    --cnt_rate 0.0 \
    --use_flash_attention True  




if [ "$PEFT_PATH" == "None" ]
then
    python -m llama_recipes.inference.checkpoint_converter_fsdp_hf \
        --fsdp_checkpoint_path $FSDP_PATH \
        --consolidated_model_path $CONVERTED_PATH \
        --HF_model_path_or_name $INITIAL_HF_MODEL
fi

if [ "$PEFT_PATH" == "None" ]
then
    CUDA_VISIBLE_DEVICES=$gpus python src/Inference/infer_llama_vllm.py \
        --model_name $CONVERTED_PATH \
        --batch_size 8 \
        --save_name $TRIVIAQA_SAVE_PATH \
        --prompt_file Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_test_threshold_1.0_sft_data.json \
        --response_num 1 \
        --top_k 1 \
        --tensor_parallel_size 1

    CUDA_VISIBLE_DEVICES=$gpus python src/Inference/infer_llama_vllm.py \
        --model_name $CONVERTED_PATH \
        --batch_size 8 \
        --save_name $NQ_SAVE_PATH \
        --prompt_file Idk_datasets/sft_data/llama-2-7b-chat/nq_open_test_threshold_1.0_sft_data.json \
        --response_num 1 \
        --top_k 1 \
        --tensor_parallel_size 1
else
    echo "PEFT_PATH: $PEFT_PATH"
    CUDA_VISIBLE_DEVICES=$gpus python src/Inference/infer_llama_vllm.py \
        --model_name $INITIAL_HF_MODEL \
        --peft_model $PEFT_PATH \
        --batch_size 8 \
        --save_name $SAVE_PATH \
        --prompt_file Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_test_threshold_1.0_sft_data.json \
        --response_num 1 \
        --top_k 1 \
        --temperature 0.0 \
        --tensor_parallel_size 1
fi

echo "SAVE_PATH: $TRIVIAQA_SAVE_PATH"
python src/evaluation/cal_knowledge_quadrants.py --file_name $TRIVIAQA_SAVE_PATH --ground_truth_file ./Idk_datasets/sft_data/llama-2-7b-chat/triviaqa_dev_tp1.0_10responses_with_em_labels.json

