import numpy as np
from ot import sinkhorn

# Define the two probability distributions
a = np.array([0.3, 0.2, 0.5])
b = np.array([0.1, 0.2, 0.7])

# Define the cost matrix
C = np.array([[0, 1, 2], [1, 0, 1], [2, 1, 0]])

# Calculate the Wasserstein distance
wasserstein_distance = sinkhorn(a=a, b=b, m=C, reg=0.1)
print(wasserstein_distance)