# COREP

Code for the paper "Tackling Non-Stationarity in Reinforcement Learning via Causal-Origin Representation"

### Requirements

The main requirements can be found in `requirements.txt`. We also use the `dmc2gym` library to convert the deepmind control environment into an openai gym interface.

To install the requirements, you can follow the instructions below:

```
pip install -r requirements.txt
pip install -e dmc2gym
```

### Overview

The main training loop for COREP is in `learner.py`, the VAE set-up and losses are in `vae.py`, the graph design is in `graph.py`, the model design is in `models/`, the RL algorithm is in `algorithms/`, and the hyperparameters are in `config/`.


### Running experiments

To evaluate COREP on the deepmind control environment, run

```
python main.py --env-type <env_name>
```

which will use hyperparameters from `config/args_<env_name>.py`. 

To reproduce the results in the paper, run the following commands:

```
python main.py --env-type cartpole_swingup
python main.py --env-type reacher_easy
python main.py --env-type reacher_hard
python main.py --env-type cup_catch
python main.py --env-type cheetah_run
python main.py --env-type hopper_stand
python main.py --env-type swimmer_swimmer6
python main.py --env-type swimmer_swimmer15
python main.py --env-type finger_spin
python main.py --env-type walker_walk
python main.py --env-type fish_upright
python main.py --env-type quadruped_walk
```

The results will be saved at `./logs`, to view the results on tensorboard, run

```
tensorboard --logdir ./logs
```
