import pandas as pd
# from lang_dict import CULTURAX_To_NLLB
import os

## Cultrax 
LANG_NAME_to_CULTURAX = {
    "Afrikaans": "af",
    "Albanian": "sq",
    "Amharic": "am",
    "Arabic": "ar",
    "Aragonese": "an",
    "Armenian": "hy",
    "Assamese": "as",
    "Asturian": "ast",
    "Avaric": "av",
    "Azerbaijani": "az",
    "Bangla": "bn",
    "Bashkir": "ba",
    "Basque": "eu",
    "Bavarian": "bar",
    "Belarusian": "be",
    "Bihari languages": "bh",
    "Bishnupriya": "bpy",
    "Bosnian": "bs",
    "Breton": "br",
    "Bulgarian": "bg",
    "Burmese": "my",
    "Cantonese": "yue",
    "Catalan": "ca",
    "Cebuano": "ceb",
    "Central Bikol": "bcl",
    "Central Kurdish": "ckb",
    "Chavacano": "cbk",
    "Chechen": "ce",
    "Chinese": "zh",
    "Chuvash": "cv",
    "Cornish": "kw",
    "Croatian": "hr",
    "Czech": "cs",
    "Danish": "da",
    "Divehi": "dv",
    "Dutch": "nl",
    "Eastern Mari": "mhr",
    "Egyptian Arabic": "arz",
    "Emiliano-Romagnol": "eml",
    "English": "en",
    "Erzya": "myv",
    "Esperanto": "eo",
    "Estonian": "et",
    "Filipino": "tl",
    "Finnish": "fi",
    "French": "fr",
    "Galician": "gl",
    "Georgian": "ka",
    "German": "de",
    "Goan Konkani": "gom",
    "Greek": "el",
    "Guarani": "gn",
    "Gujarati": "gu",
    "Haitian Creole": "ht",
    "Hebrew": "he",
    "Hindi": "hi",
    "Hungarian": "hu",
    "Icelandic": "is",
    "Ido": "io",
    "Iloko": "ilo",
    "Indonesian": "id",
    "Interlingua": "ia",
    "Interlingue": "ie",
    "Irish": "ga",
    "Italian": "it",
    "Japanese": "ja",
    "Javanese": "jv",
    "Kalmyk": "xal",
    "Kannada": "kn",
    "Karachay-Balkar": "krc",
    "Kazakh": "kk",
    "Khmer": "km",
    "Komi": "kv",
    "Korean": "ko",
    "Kurdish": "ku",
    "Kyrgyz": "ky",
    "Lao": "lo",
    "Latin": "la",
    "Latvian": "lv",
    "Lezghian": "lez",
    "Limburgish": "li",
    "Lithuanian": "lt",
    "Lojban": "jbo",
    "Lombard": "lmo",
    "Low German": "nds",
    "Lower Sorbian": "dsb",
    "Luxembourgish": "lb",
    "Macedonian": "mk",
    "Maithili": "mai",
    "Malagasy": "mg",
    "Malay": "ms",
    "Malayalam": "ml",
    "Maltese": "mt",
    "Marathi": "mr",
    "Mazanderani": "mzn",
    "Minangkabau": "min",
    "Mingrelian": "xmf",
    "Mirandese": "mwl",
    "Mongolian": "mn",
    "Nahuatl languages": "nah",
    "Neapolitan": "nap",
    "Nepali": "ne",
    "Newari": "new",
    "Northern Frisian": "frr",
    "Northern Luri": "lrc",
    "Norwegian": "no",
    "Norwegian Nynorsk": "nn",
    "Occitan": "oc",
    "Odia": "or",
    "Ossetic": "os",
    "Pampanga": "pam",
    "Pashto": "ps",
    "Persian": "fa",
    "Piedmontese": "pms",
    "Polish": "pl",
    "Portuguese": "pt",
    "Punjabi": "pa",
    "Quechua": "qu",
    "Romanian": "ro",
    "Romansh": "rm",
    "Russia Buriat": "bxr",
    "Russian": "ru",
    "Rusyn": "rue",
    "Sakha": "sah",
    "Sanskrit": "sa",
    "Scottish Gaelic": "gd",
    "Serbian": "sr",
    "Serbian (Latin)": "sh",
    "Sicilian": "scn",
    "Sindhi": "sd",
    "Sinhala": "si",
    "Slovak": "sk",
    "Slovenian": "sl",
    "Somali": "so",
    "South Azerbaijani": "azb",
    "Spanish": "es",
    "Sundanese": "su",
    "Swahili": "sw",
    "Swedish": "sv",
    "Swiss German": "als",
    "Tajik": "tg",
    "Tamil": "ta",
    "Tatar": "tt",
    "Telugu": "te",
    "Thai": "th",
    "Tibetan": "bo",
    "Turkish": "tr",
    "Turkmen": "tk",
    "Tuvinian": "tyv",
    "Ukrainian": "uk",
    "Upper Sorbian": "hsb",
    "Urdu": "ur",
    "Uyghur": "ug",
    "Uzbek": "uz",
    "Venetian": "vec",
    "Vietnamese": "vi",
    "Volapuk": "vo",
    "Walloon": "wa",
    "Waray": "war",
    "Welsh": "cy",
    "West Flemish": "vls",
    "Western Frisian": "fy",
    "Western Mari": "mrj",
    "Western Panjabi": "pnb",
    "Wu Chinese": "wuu",
    "Yiddish": "yi",
    "Yoruba": "yo"
}

CULTURAX_to_LANG_NAME = {
    'af': 'Afrikaans',
    'sq': 'Albanian',
    'am': 'Amharic',
    'ar': 'Arabic',
    'an': 'Aragonese',
    'hy': 'Armenian',
    'as': 'Assamese',
    'ast': 'Asturian',
    'av': 'Avaric',
    'az': 'Azerbaijani',
    'bn': 'Bangla',
    'ba': 'Bashkir',
    'eu': 'Basque',
    'bar': 'Bavarian',
    'be': 'Belarusian',
    'bh': 'Bihari languages',
    'bpy': 'Bishnupriya',
    'bs': 'Bosnian',
    'br': 'Breton',
    'bg': 'Bulgarian',
    'my': 'Burmese',
    'yue': 'Cantonese',
    'ca': 'Catalan',
    'ceb': 'Cebuano',
    'bcl': 'Central Bikol',
    'ckb': 'Central Kurdish',
    'cbk': 'Chavacano',
    'ce': 'Chechen',
    'zh': 'Chinese',
    'cv': 'Chuvash',
    'kw': 'Cornish',
    'hr': 'Croatian',
    'cs': 'Czech',
    'da': 'Danish',
    'dv': 'Divehi',
    'nl': 'Dutch',
    'mhr': 'Eastern Mari',
    'arz': 'Egyptian Arabic',
    'eml': 'Emiliano-Romagnol',
    'en': 'English',
    'myv': 'Erzya',
    'eo': 'Esperanto',
    'et': 'Estonian',
    'tl': 'Filipino',
    'fi': 'Finnish',
    'fr': 'French',
    'gl': 'Galician',
    'ka': 'Georgian',
    'de': 'German',
    'gom': 'Goan Konkani',
    'el': 'Greek',
    'gn': 'Guarani',
    'gu': 'Gujarati',
    'ht': 'Haitian Creole',
    'he': 'Hebrew',
    'hi': 'Hindi',
    'hu': 'Hungarian',
    'is': 'Icelandic',
    'io': 'Ido',
    'ilo': 'Iloko',
    'id': 'Indonesian',
    'ia': 'Interlingua',
    'ie': 'Interlingue',
    'ga': 'Irish',
    'it': 'Italian',
    'ja': 'Japanese',
    'jv': 'Javanese',
    'xal': 'Kalmyk',
    'kn': 'Kannada',
    'krc': 'Karachay-Balkar',
    'kk': 'Kazakh',
    'km': 'Khmer',
    'kv': 'Komi',
    'ko': 'Korean',
    'ku': 'Kurdish',
    'ky': 'Kyrgyz',
    'lo': 'Lao',
    'la': 'Latin',
    'lv': 'Latvian',
    'lez': 'Lezghian',
    'li': 'Limburgish',
    'lt': 'Lithuanian',
    'jbo': 'Lojban',
    'lmo': 'Lombard',
    'nds': 'Low German',
    'dsb': 'Lower Sorbian',
    'lb': 'Luxembourgish',
    'mk': 'Macedonian',
    'mai': 'Maithili',
    'mg': 'Malagasy',
    'ms': 'Malay',
    'ml': 'Malayalam',
    'mt': 'Maltese',
    'mr': 'Marathi',
    'mzn': 'Mazanderani',
    'min': 'Minangkabau',
    'xmf': 'Mingrelian',
    'mwl': 'Mirandese',
    'mn': 'Mongolian',
    'nah': 'Nahuatl languages',
    'nap': 'Neapolitan',
    'ne': 'Nepali',
    'new': 'Newari',
    'frr': 'Northern Frisian',
    'lrc': 'Northern Luri',
    'no': 'Norwegian',
    'nn': 'Norwegian Nynorsk',
    'oc': 'Occitan',
    'or': 'Odia',
    'os': 'Ossetic',
    'pam': 'Pampanga',
    'ps': 'Pashto',
    'fa': 'Persian',
    'pms': 'Piedmontese',
    'pl': 'Polish',
    'pt': 'Portuguese',
    'pa': 'Punjabi',
    'qu': 'Quechua',
    'ro': 'Romanian',
    'rm': 'Romansh',
    'bxr': 'Russia Buriat',
    'ru': 'Russian',
    'rue': 'Rusyn',
    'sah': 'Sakha',
    'sa': 'Sanskrit',
    'gd': 'Scottish Gaelic',
    'sr': 'Serbian',
    'sh': 'Serbian (Latin)',
    'scn': 'Sicilian',
    'sd': 'Sindhi',
    'si': 'Sinhala',
    'sk': 'Slovak',
    'sl': 'Slovenian',
    'so': 'Somali',
    'azb': 'South Azerbaijani',
    'es': 'Spanish',
    'su': 'Sundanese',
    'sw': 'Swahili',
    'sv': 'Swedish',
    'als': 'Swiss German',
    'tg': 'Tajik',
    'ta': 'Tamil',
    'tt': 'Tatar',
    'te': 'Telugu',
    'th': 'Thai',
    'bo': 'Tibetan',
    'tr': 'Turkish',
    'tk': 'Turkmen',
    'tyv': 'Tuvinian',
    'uk': 'Ukrainian',
    'hsb': 'Upper Sorbian',
    'ur': 'Urdu',
    'ug': 'Uyghur',
    'uz': 'Uzbek',
    'vec': 'Venetian',
    'vi': 'Vietnamese',
    'vo': 'Volapuk',
    'wa': 'Walloon',
    'war': 'Waray',
    'cy': 'Welsh',
    'vls': 'West Flemish',
    'fy': 'Western Frisian',
    'mrj': 'Western Mari',
    'pnb': 'Western Panjabi',
    'wuu': 'Wu Chinese',
    'yi': 'Yiddish',
    'yo': 'Yoruba'
}

## Language ID support
NLLB_LID_LABEL_LIST = ['srp_Cyrl', 'swe_Latn', 'dan_Latn', 'ita_Latn', 'spa_Latn', 'pes_Arab', 'slk_Latn', 'hun_Latn', 'bul_Cyrl', 'cat_Latn', 'tur_Latn', 'ell_Grek', 'eng_Latn', 'nob_Latn', 'fra_Latn', 'rus_Cyrl', 'hrv_Latn', 'nld_Latn', 'ind_Latn', 'hye_Armn', 'heb_Hebr', 'ceb_Latn', 'ron_Latn', 'pol_Latn', 'kor_Hang', 'vie_Latn', 'deu_Latn', 'slv_Latn', 'por_Latn', 'ces_Latn', 'ukr_Cyrl', 'fin_Latn', 'arb_Arab', 'tgl_Latn', 'afr_Latn', 'est_Latn', 'war_Latn', 'zul_Latn', 'lit_Latn', 'ilo_Latn', 'kat_Geor', 'hin_Deva', 'mkd_Cyrl', 'swh_Latn', 'epo_Latn', 'sot_Latn', 'tsn_Latn', 'xho_Latn', 'lvs_Latn', 'als_Latn', 'tso_Latn', 'kaz_Cyrl', 'sna_Latn', 'amh_Ethi', 'zsm_Latn', 'tha_Thai', 'tah_Latn', 'nso_Latn', 'ewe_Latn', 'urd_Arab', 'isl_Latn', 'lin_Latn', 'bis_Latn', 'twi_Latn', 'sin_Sinh', 'ben_Beng', 'mya_Mymr', 'plt_Latn', 'pan_Guru', 'azj_Latn', 'guj_Gujr', 'glg_Latn', 'kir_Cyrl', 'tel_Telu', 'tpi_Latn', 'ibo_Latn', 'tam_Taml', 'tat_Cyrl', 'bem_Latn', 'bel_Cyrl', 'kin_Latn', 'npi_Deva', 'pap_Latn', 'mar_Deva', 'smo_Latn', 'run_Latn', 'che_Cyrl', 'fij_Latn', 'tir_Ethi', 'ast_Latn', 'kan_Knda', 'mlt_Latn', 'yor_Latn', 'eus_Latn', 'lua_Latn', 'pag_Latn', 'sag_Latn', 'oss_Cyrl', 'khk_Cyrl', 'tum_Latn', 'tgk_Cyrl', 'lug_Latn', 'mal_Mlym', 'umb_Latn', 'hat_Latn', 'kon_Latn', 'azb_Arab', 'hau_Latn', 'mos_Latn', 'kal_Latn', 'nno_Latn', 'lus_Latn', 'oci_Latn', 'bos_Latn', 'gaz_Latn', 'bak_Cyrl', 'chv_Cyrl', 'cym_Latn', 'tuk_Latn', 'luo_Latn', 'ayr_Latn', 'ssw_Latn', 'quy_Latn', 'uzn_Latn', 'kik_Latn', 'kmb_Latn', 'jav_Latn', 'ltz_Latn', 'asm_Beng', 'ton_Latn', 'nya_Latn', 'kam_Latn', 'ckb_Arab', 'min_Latn', 'bod_Tibt', 'lmo_Latn', 'gle_Latn', 'sun_Latn', 'xmf_Geor', 'cjk_Latn', 'nia_Latn', 'kbp_Latn', 'ory_Orya', 'fon_Latn', 'kmr_Latn', 'khm_Khmr', 'ydd_Hebr', 'abk_Cyrl', 'san_Deva', 'uig_Arab', 'lim_Latn', 'scn_Latn', 'mai_Deva', 'snd_Arab', 'wes_Latn', 'pcm_Latn', 'arn_Latn', 'vec_Latn', 'nav_Latn', 'gom_Deva', 'gla_Latn', 'yue_Hant', 'dyu_Latn', 'kac_Latn', 'roh_Latn', 'udm_Cyrl', 'lao_Laoo', 'diq_Latn', 'som_Latn', 'kab_Latn', 'bjn_Latn', 'bxr_Cyrl', 'knc_Arab', 'szl_Latn', 'kea_Latn', 'ban_Latn', 'crh_Latn', 'knc_Latn', 'bug_Latn', 'fur_Latn', 'ace_Latn', 'fuv_Latn', 'prs_Arab', 'mri_Latn', 'dik_Latn', 'taq_Latn', 'kas_Arab', 'pbt_Arab', 'tzm_Tfng', 'bam_Latn', 'mag_Deva', 'hne_Deva', 'kas_Deva', 'nus_Latn', 'krc_Cyrl', 'bho_Deva', 'mni_Beng', 'ltg_Latn', 'alt_Cyrl', 'dzo_Tibt', 'lij_Latn', 'wol_Latn', 'sat_Olck', 'taq_Tfng', 'jpn_Jpan', 'shn_Mymr', 'bjn_Arab', 'ace_Arab', 'grn_Latn', 'fao_Latn', 'zho_Hans', 'zho_Hant', 'awa_Deva', 'aka_Latn', 'arb_Latn', 'ewo_Latn', 'srd_Latn', 'ady_Cyrl']
GLOT_LID_LABEL_LIST = ['eng_Latn', 'rus_Cyrl', 'arb_Arab', 'por_Latn', 'pol_Latn', 'ell_Grek', 'hun_Latn', 'nld_Latn', 'swe_Latn', 'slv_Latn', 'fin_Latn', 'ekk_Latn', 'dan_Latn', 'fas_Arab', 'slk_Latn', 'spa_Latn', 'fra_Latn', 'lvs_Latn', 'ind_Latn', 'nob_Latn', 'kor_Hang', 'lit_Latn', 'ita_Latn', 'deu_Latn', 'kin_Latn', 'nya_Latn', 'tur_Latn', 'ukr_Cyrl', 'mlt_Latn', 'hin_Deva', 'ceb_Latn', 'sna_Latn', 'vie_Latn', 'heb_Hebr', 'cat_Latn', 'jpn_Jpan', 'nso_Latn', 'twi_Latn', 'hrv_Latn', 'bul_Cyrl', 'lin_Latn', 'ces_Latn', 'ben_Beng', 'yor_Latn', 'tpi_Latn', 'hil_Latn', 'uzn_Latn', 'tam_Taml', 'ewe_Latn', 'ron_Latn', 'smo_Latn', 'pap_Latn', 'azj_Latn', 'abk_Cyrl', 'fil_Latn', 'afr_Latn', 'bem_Latn', 'hye_Armn', 'mar_Deva', 'run_Latn', 'srp_Cyrl', 'epo_Latn', 'ton_Latn', 'pag_Latn', 'fij_Latn', 'bcl_Latn', 'gaa_Latn', 'tah_Latn', 'cmn_Hani', 'lua_Latn', 'srn_Latn', 'ilo_Latn', 'guj_Gujr', 'ast_Latn', 'hmo_Latn', 'xho_Latn', 'bis_Latn', 'sag_Latn', 'zul_Latn', 'tha_Thai', 'eus_Latn', 'efi_Latn', 'loz_Latn', 'rar_Latn', 'tir_Ethi', 'kng_Latn', 'tso_Latn', 'wls_Latn', 'tsn_Latn', 'mkd_Cyrl', 'gaz_Latn', 'bel_Cyrl', 'tum_Latn', 'ven_Latn', 'kan_Knda', 'mal_Mlym', 'kab_Latn', 'kir_Cyrl', 'urd_Arab', 'pan_Guru', 'toi_Latn', 'kat_Geor', 'tel_Telu', 'amh_Ethi', 'hyw_Armn', 'guw_Latn', 'zxx_Latn', 'lub_Latn', 'umb_Latn', 'oss_Cyrl', 'iso_Latn', 'war_Latn', 'mos_Latn', 'pis_Latn', 'yua_Latn', 'bos_Latn', 'luo_Latn', 'lue_Latn', 'ibo_Latn', 'tll_Latn', 'mya_Mymr', 'lus_Latn', 'ayr_Latn', 'tzo_Latn', 'swh_Latn', 'sin_Sinh', 'niu_Latn', 'kik_Latn', 'tuk_Latn', 'mah_Latn', 'zsm_Latn', 'tvl_Latn', 'crs_Latn', 'kqn_Latn', 'ndo_Latn', 'kua_Latn', 'gug_Latn', 'tiv_Latn', 'nno_Latn', 'quy_Latn', 'kwy_Latn', 'tdt_Latn', 'swc_Latn', 'hau_Latn', 'pon_Latn', 'hat_Latn', 'mfe_Latn', 'lug_Latn', 'gil_Latn', 'ssw_Latn', 'kaz_Cyrl', 'cnh_Latn', 'als_Latn', 'tat_Cyrl', 'lun_Latn', 'dhv_Latn', 'nzi_Latn', 'quz_Latn', 'bci_Latn', 'kmb_Latn', 'chk_Latn', 'glg_Latn', 'kam_Latn', 'wal_Latn', 'bak_Cyrl', 'cym_Latn', 'yap_Latn', 'lat_Latn', 'zne_Latn', 'seh_Latn', 'bbc_Latn', 'vmw_Latn', 'kwn_Latn', 'pnb_Arab', 'und_Cyrl', 'azb_Arab', 'gle_Latn', 'mam_Latn', 'nyk_Latn', 'tsc_Latn', 'khk_Cyrl', 'npi_Deva', 'zai_Latn', 'kmr_Latn', 'gym_Latn', 'ory_Orya', 'jav_Latn', 'nde_Latn', 'dyu_Latn', 'guc_Latn', 'cak_Latn', 'kbp_Latn', 'plt_Latn', 'tgk_Cyrl', 'kal_Latn', 'nyn_Latn', 'nbl_Latn', 'kac_Latn', 'top_Latn', 'nia_Latn', 'fon_Latn', 'som_Latn', 'cab_Latn', 'tzh_Latn', 'mco_Latn', 'qvi_Latn', 'quc_Latn', 'tog_Latn', 'asm_Beng', 'isl_Latn', 'kek_Latn', 'mhr_Cyrl', 'yao_Latn', 'ctu_Latn', 'sop_Latn', 'sme_Latn', 'koo_Latn', 'ada_Latn', 'mau_Latn', 'und_Grek', 'und_Deva', 'ndc_Latn', 'nch_Latn', 'ncj_Latn', 'arz_Arab', 'btx_Latn', 'iba_Latn', 'ary_Arab', 'kri_Latn', 'toj_Latn', 'ckb_Arab', 'cjk_Latn', 'mww_Latn', 'kss_Latn', 'ngl_Latn', 'urh_Latn', 'nyu_Latn', 'tuk_Cyrl', 'mgr_Latn', 'pau_Latn', 'qug_Latn', 'rmn_Latn', 'mck_Latn', 'min_Latn', 'nba_Latn', 'grc_Grek', 'kiu_Latn', 'ncx_Latn', 'pdt_Latn', 'san_Deva', 'ahk_Latn', 'kea_Latn', 'mxv_Latn', 'her_Latn', 'arn_Latn', 'tyv_Cyrl', 'meu_Latn', 'udm_Cyrl', 'lim_Latn', 'ltz_Latn', 'snd_Arab', 'fry_Latn', 'bum_Latn', 'sdh_Arab', 'oci_Latn', 'uig_Arab', 'sun_Latn', 'ksw_Mymr', 'tsz_Latn', 'bar_Latn', 'ngu_Latn', 'sid_Latn', 'nds_Latn', 'bas_Latn', 'bin_Latn', 'gla_Latn', 'sah_Cyrl', 'yue_Hani', 'vec_Latn', 'tcf_Latn', 'khm_Khmr', 'bzj_Latn', 'xmf_Geor', 'cce_Latn', 'chw_Latn', 'nyy_Latn', 'ibg_Latn', 'bhw_Latn', 'cbk_Latn', 'gsw_Latn', 'alz_Latn', 'nse_Latn', 'naq_Latn', 'toh_Latn', 'vol_Latn', 'ttj_Latn', 'hbo_Hebr', 'ish_Latn', 'sco_Latn', 'djk_Latn', 'ami_Latn', 'und_Tang', 'und_Xsux', 'und_Egyp', 'und_Yiii', 'und_Cans', 'und_Bamu', 'und_Sgnw', 'und_Ethi', 'und_Hluw', 'und_Kits', 'und_Nshu', 'und_Hira', 'und_Lina', 'und_Kana', 'und_Vaii', 'und_Brai', 'und_Mymr', 'und_Linb', 'und_Khmr', 'und_Cher', 'und_Geor', 'und_Mend', 'und_Copt', 'und_Lana', 'und_Plrd', 'und_Sinh', 'und_Glag', 'und_Mong', 'und_Cpmn', 'und_Mlym', 'und_Armn', 'und_Tibt', 'und_Dupl', 'und_Bali', 'und_Hebr', 'und_Newa', 'und_Diak', 'und_Hmng', 'und_Gujr', 'und_Knda', 'und_Hung', 'und_Shrd', 'und_Tnsa', 'und_Talu', 'und_Java', 'und_Brah', 'und_Medf', 'und_Taml', 'und_Tirh', 'und_Khoj', 'und_Gran', 'und_Orkh', 'und_Sidd', 'und_Kawi', 'und_Wara', 'und_Sind', 'und_Cham', 'und_Gong', 'und_Beng', 'und_Bhks', 'und_Syrc', 'und_Khar', 'und_Mtei', 'und_Dogr', 'und_Vith', 'und_Bopo', 'und_Adlm', 'und_Merc', 'und_Limb', 'und_Saur', 'und_Zanb', 'und_Modi', 'und_Tavt', 'und_Telu', 'und_Osge', 'und_Ahom', 'und_Dsrt', 'und_Laoo', 'und_Avst', 'und_Tfng', 'und_Marc', 'und_Orya', 'und_Sund', 'und_Gonm', 'und_Takr', 'und_Thai', 'und_Yezi', 'und_Nkoo', 'und_Hmnp', 'und_Lisu', 'und_Soyo', 'und_Samr', 'und_Nand', 'und_Pauc', 'und_Batk', 'und_Cakm', 'und_Guru', 'und_Cari', 'und_Rohg', 'und_Kthi', 'und_Kali', 'und_Xpeo', 'und_Runr', 'und_Ital', 'und_Mani', 'und_Wcho', 'und_Shaw', 'und_Nagm', 'und_Lepc', 'und_Mroo', 'und_Phag', 'und_Cprt', 'und_Aghb', 'und_Olck', 'und_Mahj', 'und_Perm', 'und_Sogd', 'und_Sora', 'und_Elba', 'und_Sylo', 'und_Rjng', 'und_Thaa', 'und_Mult', 'und_Ugar', 'und_Palm', 'und_Lydi', 'und_Armi', 'und_Bass', 'und_Mero', 'und_Goth', 'und_Lyci', 'und_Sogo', 'und_Osma', 'und_Chrs', 'und_Narb', 'und_Toto', 'und_Nbat', 'und_Tale', 'fao_Latn', 'und_Maka', 'und_Prti', 'und_Bugi', 'und_Phlp', 'und_Ougr', 'und_Hatr', 'und_Elym', 'und_Phli', 'und_Phnx', 'und_Ogam', 'und_Mand', 'und_Sarb', 'und_Tagb', 'und_Tglg', 'und_Buhd', 'und_Hano', 'nnb_Latn', 'lzh_Hani', 'miq_Latn', 'nav_Latn', 'pbt_Arab', 'bba_Latn', 'alt_Cyrl', 'rmn_Grek', 'cfm_Latn', 'srp_Latn', 'gom_Latn', 'gkn_Latn', 'zxx_Zzzz', 'gur_Latn', 'uzs_Arab', 'qub_Latn', 'wuu_Hani', 'mgh_Latn', 'sot_Latn', 'mri_Latn', 'lhu_Latn', 'kos_Latn', 'yom_Latn', 'tcz_Latn', 'wol_Latn', 'rmy_Latn', 'gcf_Latn', 'rng_Latn', 'rmn_Cyrl', 'ige_Latn', 'kpg_Latn', 'ctd_Latn', 'aln_Latn', 'mdy_Ethi', 'srm_Latn', 'hnj_Latn', 'idu_Latn', 'uig_Latn', 'bim_Latn', 'wbm_Latn', 'lmo_Latn', 'xmv_Latn', 'bqc_Latn', 'che_Cyrl', 'ote_Latn', 'scn_Latn', 'apc_Arab', 'tdx_Latn', 'tpm_Latn', 'kpe_Latn', 'leh_Latn', 'acr_Latn', 'suz_Deva', 'ina_Latn', 'gub_Latn', 'poh_Latn', 'hus_Latn', 'wes_Latn', 'mps_Latn', 'tbz_Latn', 'glv_Latn', 'ldi_Latn', 'ifa_Latn', 'rop_Latn', 'ify_Latn', 'oke_Latn', 'bho_Deva', 'szl_Latn', 'sxn_Latn', 'zpa_Latn', 'ogo_Latn', 'dtp_Latn', 'hmr_Latn', 'hne_Deva', 'tok_Latn', 'vro_Latn', 'shp_Latn', 'ace_Latn', 'cac_Latn', 'abn_Latn', 'quh_Latn', 'ixl_Latn', 'myv_Cyrl', 'kbd_Cyrl', 'srd_Latn', 'fur_Latn', 'mwn_Latn', 'bod_Tibt', 'mad_Latn', 'skg_Latn', 'dua_Latn', 'chv_Cyrl', 'lam_Latn', 'tlh_Latn', 'ium_Latn', 'mni_Beng', 'tob_Latn', 'nan_Latn', 'mny_Latn', 'cor_Latn', 'ikk_Latn', 'tar_Latn', 'aoj_Latn', 'bts_Latn', 'teo_Latn', 'cek_Latn', 'fat_Latn', 'ubu_Latn', 'uig_Cyrl', 'mai_Deva', 'zom_Latn', 'tuc_Latn', 'ach_Latn', 'bcc_Arab', 'phm_Latn', 'urd_Latn', 'ydd_Hebr', 'hrx_Latn', 'pck_Latn', 'crn_Latn', 'kia_Latn', 'pww_Thai', 'uzn_Cyrl', 'kpv_Cyrl', 'csy_Latn', 'ban_Latn', 'sba_Latn', 'tih_Latn', 'san_Latn', 'hui_Latn', 'kaa_Cyrl', 'mbb_Latn', 'apy_Latn', 'kjh_Cyrl', 'rmc_Latn', 'agw_Latn', 'tbg_Latn', 'crh_Cyrl', 'hin_Latn', 'gya_Latn', 'cgg_Latn', 'dik_Latn', 'giz_Latn', 'enm_Latn', 'lao_Laoo', 'ame_Latn', 'div_Thaa', 'kha_Latn', 'maa_Latn', 'ido_Latn', 'fub_Latn', 'dop_Latn', 'cuk_Latn', 'bre_Latn', 'izz_Latn', 'ksd_Latn', 'ifb_Latn', 'kjb_Latn', 'shn_Mymr', 'mrw_Latn', 'pls_Latn', 'lij_Latn', 'mas_Latn', 'caq_Latn', 'mrj_Cyrl', 'mcn_Latn', 'tui_Latn', 'njm_Latn', 'nzm_Latn', 'ike_Cans', 'anm_Latn', 'nmf_Latn', 'njo_Latn', 'vap_Latn', 'roh_Latn', 'eza_Latn', 'gnw_Latn', 'hra_Latn', 'rad_Latn', 'yim_Latn', 'nst_Latn', 'mug_Latn', 'trp_Latn', 'poe_Latn', 'nbu_Latn', 'adi_Latn', 'yan_Latn', 'xav_Latn', 'mwm_Latn', 'gjn_Latn', 'pmx_Latn', 'niq_Latn', 'nre_Latn', 'rmy_Cyrl', 'nsm_Latn', 'kmm_Latn', 'njn_Latn', 'nnl_Latn', 'dru_Latn', 'cni_Latn', 'mzh_Latn', 'ron_Cyrl', 'mwl_Latn', 'hak_Hani', 'jam_Latn', 'knv_Latn', 'ajg_Latn', 'cok_Latn', 'quw_Latn', 'tuo_Latn', 'hsb_Latn', 'diq_Latn', 'kij_Latn', 'tzj_Latn', 'hac_Arab', 'snp_Latn', 'sus_Arab', 'orv_Cyrl', 'gyr_Latn', 'cop_Copt', 'ape_Latn', 'taq_Latn', 'noa_Latn', 'yss_Latn', 'bnp_Latn', 'gcr_Latn', 'kde_Latn', 'rug_Latn', 'rwo_Latn', 'gux_Latn', 'ojb_Latn', 'xog_Latn', 'pxm_Latn', 'hch_Latn', 'pam_Latn', 'twx_Latn', 'dln_Latn', 'kck_Latn', 'pms_Latn', 'ojb_Cans', 'nap_Latn', 'mak_Latn', 'mna_Latn', 'azj_Cyrl', 'wap_Latn', 'arg_Latn', 'blk_Mymr', 'kmh_Latn', 'aeb_Arab', 'abt_Latn', 'enx_Latn', 'bxr_Cyrl', 'new_Deva', 'amn_Latn', 'lnd_Latn', 'wln_Latn', 'vls_Latn', 'eml_Latn', 'bpy_Beng', 'mzn_Arab', 'iou_Latn', 'chu_Cyrl', 'llb_Latn', 'fuv_Latn', 'gui_Latn', 'cax_Latn', 'qul_Latn', 'cap_Latn', 'jac_Latn', 'rnd_Latn', 'agr_Latn', 'mmx_Latn', 'ign_Latn', 'acf_Latn', 'xtn_Latn', 'wsk_Latn', 'ons_Latn', 'krc_Cyrl', 'boj_Latn', 'ajp_Arab', 'pcm_Latn', 'bus_Latn', 'pov_Latn', 'bjn_Latn', 'ata_Latn', 'dob_Latn', 'pma_Latn', 'kyc_Latn', 'bex_Latn', 'rnl_Latn', 'myx_Latn', 'hif_Latn', 'jae_Latn', 'nhx_Latn', 'mfq_Latn', 'dnj_Latn', 'glk_Arab', 'ktu_Latn', 'gmv_Latn', 'ctp_Latn', 'nop_Latn', 'pib_Latn', 'mox_Latn', 'bzd_Latn', 'tvk_Latn', 'yka_Latn', 'kyg_Latn', 'nas_Latn', 'bdd_Latn', 'mto_Latn', 'yre_Latn', 'sja_Latn', 'suk_Latn', 'fuh_Latn', 'mcq_Latn', 'xsm_Latn', 'tpz_Latn', 'kaa_Latn', 'bef_Latn', 'ese_Latn', 'aii_Syrc', 'apz_Latn', 'gvc_Latn', 'mek_Latn', 'mpx_Latn', 'cbr_Latn', 'aak_Latn', 'spy_Latn', 'xon_Latn', 'swp_Latn', 'hub_Latn', 'wlx_Latn', 'aso_Latn', 'mav_Latn', 'ded_Latn', 'npl_Latn', 'mcp_Latn', 'med_Latn', 'czt_Latn', 'tod_Latn', 'kyq_Latn', 'yml_Latn', 'adh_Latn', 'awa_Deva', 'kwf_Latn', 'bam_Latn', 'ars_Arab', 'nhe_Latn', 'plu_Latn', 'gum_Latn', 'tcs_Latn', 'mca_Latn', 'ses_Latn', 'ssd_Latn', 'byr_Latn', 'bch_Latn', 'yle_Latn', 'moc_Latn', 'soq_Latn', 'kmu_Latn', 'kbq_Latn', 'amu_Latn', 'plw_Latn', 'mmo_Latn', 'aba_Latn', 'bhl_Latn', 'kpf_Latn', 'kgf_Latn', 'muh_Latn', 'fuf_Latn', 'myk_Latn', 'lmk_Latn', 'xtd_Latn', 'zpu_Latn', 'zpl_Latn', 'azg_Latn', 'moa_Latn', 'nho_Latn', 'tee_Latn', 'vmy_Latn', 'mxb_Latn', 'caa_Latn', 'smt_Latn', 'kub_Latn', 'zpt_Latn', 'kkj_Latn', 'miy_Latn', 'hto_Latn', 'stp_Latn', 'izr_Latn', 'mxq_Latn', 'toc_Latn', 'mfi_Latn', 'xsi_Latn', 'lem_Latn', 'bss_Latn', 'zpc_Latn', 'pbb_Latn', 'bib_Latn', 'sey_Latn', 'yam_Latn', 'tos_Latn', 'tpt_Latn', 'nhr_Latn', 'xtm_Latn', 'cco_Latn', 'bav_Latn', 'vag_Latn', 'mux_Latn', 'bov_Latn', 'mpm_Latn', 'ndz_Latn', 'box_Latn', 'nnw_Latn', 'adj_Latn', 'soy_Latn', 'cbs_Latn', 'jic_Latn', 'ycn_Latn', 'ntr_Latn', 'mta_Latn', 'xsu_Latn', 'biv_Latn', 'yut_Latn', 'zpz_Latn', 'otq_Latn', 'muy_Latn', 'aom_Latn', 'maw_Latn', 'aia_Latn', 'bru_Latn', 'tue_Latn', 'cbc_Latn', 'bbb_Latn', 'mzw_Latn', 'ava_Cyrl', 'mqb_Latn', 'wnc_Latn', 'lee_Latn', 'ife_Latn', 'auy_Latn', 'bjv_Latn', 'fan_Latn', 'jiv_Latn', 'bwu_Latn', 'ots_Latn', 'jra_Latn', 'zas_Latn', 'sim_Latn', 'ncu_Latn', 'mbc_Latn', 'avu_Latn', 'pwg_Latn', 'acu_Latn', 'mzm_Latn', 'dga_Latn', 'tfr_Latn', 'bsn_Latn', 'tpp_Latn', 'cko_Latn', 'sat_Olck', 'txu_Latn', 'sbl_Latn', 'bjr_Latn', 'ood_Latn', 'tab_Cyrl', 'yon_Latn', 'mtp_Latn', 'viv_Latn', 'sus_Latn', 'dwr_Latn', 'mir_Latn', 'lid_Latn', 'nwx_Deva', 'acd_Latn', 'wbp_Latn', 'rmo_Latn', 'tca_Latn', 'myb_Latn', 'xed_Latn', 'cgc_Latn', 'bcw_Latn', 'crh_Latn', 'akp_Latn', 'xla_Latn', 'qxh_Latn', 'cto_Latn', 'ifu_Latn', 'lip_Latn', 'ifk_Latn', 'men_Latn', 'ksr_Latn', 'bmu_Latn', 'mdf_Cyrl', 'geb_Latn', 'tac_Latn', 'omw_Latn', 'kyz_Latn', 'bew_Latn', 'mkl_Latn', 'gso_Latn', 'lcm_Latn', 'mcd_Latn', 'knf_Latn', 'mti_Latn', 'ubr_Latn', 'agd_Latn', 'gde_Latn', 'leu_Latn', 'nhu_Latn', 'kwj_Latn', 'xuo_Latn', 'kew_Latn', 'atb_Latn', 'coe_Latn', 'nin_Latn', 'bfd_Latn', 'pjt_Latn', 'aey_Latn', 'mio_Latn', 'tet_Latn', 'plg_Latn', 'lex_Latn', 'cnl_Latn', 'sny_Latn', 'eka_Latn', 'sxb_Latn', 'quf_Latn', 'yuj_Latn', 'ssx_Latn', 'nhi_Latn', 'huv_Latn', 'aaz_Latn', 'kpr_Latn', 'car_Latn', 'kog_Latn', 'mfy_Latn', 'bgs_Latn', 'wrs_Latn', 'lif_Deva', 'fuq_Latn', 'pao_Latn', 'ffm_Latn', 'fro_Latn', 'ktj_Latn', 'dks_Latn', 'pfe_Latn', 'vut_Latn', 'gnn_Latn', 'kyf_Latn', 'mop_Latn', 'laj_Latn', 'qvc_Latn', 'snw_Latn', 'mvn_Latn', 'mkn_Latn', 'heg_Latn', 'txq_Latn', 'dyi_Latn', 'tbo_Latn', 'ann_Latn', 'zab_Latn', 'aha_Latn', 'nog_Cyrl', 'kgp_Latn', 'hns_Latn', 'dyo_Latn', 'bug_Latn', 'btd_Latn', 'poi_Latn', 'dgr_Latn', 'klv_Latn', 'mlh_Latn', 'lbk_Latn', 'gng_Latn', 'obo_Latn', 'tcc_Latn', 'knj_Latn', 'mbs_Latn', 'ssg_Latn', 'iri_Latn', 'meq_Latn', 'wmw_Latn', 'ppo_Latn', 'krj_Latn', 'gof_Latn', 'xrb_Latn', 'pri_Latn', 'kje_Latn', 'atg_Latn', 'lwo_Latn', 'mif_Latn', 'prf_Latn', 'bps_Latn', 'cme_Latn', 'ile_Latn', 'nhw_Latn', 'nus_Latn', 'agn_Latn', 'kqe_Latn', 'bgr_Latn', 'cub_Latn', 'tke_Latn', 'msm_Latn', 'ter_Latn', 'sig_Latn', 'gag_Latn', 'yva_Latn', 'nwi_Latn', 'sda_Latn', 'kwi_Latn', 'mbt_Latn', 'heh_Latn', 'hag_Latn', 'mee_Latn', 'sps_Latn', 'gog_Latn', 'kqp_Latn', 'kne_Latn', 'qxn_Latn', 'ebk_Latn', 'kdi_Latn', 'gwi_Latn', 'roo_Latn', 'mqj_Latn', 'daa_Latn', 'gag_Cyrl', 'aai_Latn', 'smk_Latn', 'con_Latn', 'hvn_Latn', 'yby_Latn', 'mva_Latn', 'kqc_Latn', 'zar_Latn', 'nfa_Latn', 'atd_Latn', 'emi_Latn', 'yal_Latn', 'des_Latn', 'bzh_Latn', 'myy_Latn', 'cso_Latn', 'alq_Latn', 'usa_Latn', 'mbj_Latn', 'chd_Latn', 'hay_Latn', 'nah_Latn', 'mbh_Latn', 'abx_Latn', 'cmo_Latn', 'tgo_Latn', 'kdl_Latn', 'asg_Latn', 'chf_Latn', 'tsw_Latn', 'qve_Latn', 'emp_Latn', 'rro_Latn', 'ttc_Latn', 'pir_Latn', 'kru_Deva', 'cpu_Latn', 'cpc_Latn', 'wuv_Latn', 'dww_Latn', 'kwd_Latn', 'sll_Latn', 'bao_Latn', 'aau_Latn', 'mda_Latn', 'zao_Latn', 'nyf_Latn', 'amp_Latn', 'kto_Latn', 'kue_Latn', 'ngp_Latn', 'nsn_Latn', 'zae_Latn', 'pab_Latn', 'gqr_Latn', 'cnt_Latn', 'gdr_Latn', 'ptu_Latn', 'kmk_Latn', 'hak_Latn', 'csk_Latn', 'agm_Latn', 'cha_Latn', 'rai_Latn', 'kgk_Latn', 'nim_Latn', 'mhx_Latn', 'msb_Latn', 'caf_Latn', 'gun_Latn', 'zaw_Latn', 'khz_Latn', 'inb_Latn', 'sri_Latn', 'uvl_Latn', 'cya_Latn', 'tgp_Latn', 'nhg_Latn', 'rim_Latn', 'bmh_Latn', 'ikw_Latn', 'mfk_Latn', 'kki_Latn', 'snc_Latn', 'kpz_Latn', 'ptp_Latn', 'mza_Latn', 'ndj_Latn', 'old_Latn', 'gvl_Latn', 'gul_Latn', 'ziw_Latn', 'zos_Latn', 'jmc_Latn', 'att_Latn', 'avt_Latn', 'vun_Latn', 'zad_Latn', 'acn_Latn', 'miz_Latn', 'iws_Latn', 'sur_Latn', 'lsm_Latn', 'hae_Latn', 'ake_Latn', 'tem_Latn', 'zty_Latn', 'nnq_Latn', 'mfh_Latn', 'ruf_Latn', 'mhi_Latn', 'naw_Latn', 'cpa_Latn', 'kms_Latn', 'esk_Latn', 'ken_Latn', 'cpb_Latn', 'cwe_Latn', 'zpv_Latn', 'qvn_Latn', 'faa_Latn', 'big_Latn', 'nyo_Latn', 'gvf_Latn', 'mks_Latn', 'azz_Latn', 'zam_Latn', 'dgi_Latn', 'zac_Latn', 'mic_Latn', 'auc_Latn', 'vid_Latn', 'lob_Latn', 'udu_Latn', 'jbu_Latn', 'mig_Latn', 'akb_Latn', 'ong_Latn', 'kvn_Latn', 'zat_Latn', 'zca_Latn', 'pbc_Latn', 'cle_Latn', 'cly_Latn', 'zyp_Latn', 'eri_Latn', 'xsr_Deva', 'bon_Latn', 'tlj_Latn', 'too_Latn', 'xsb_Latn', 'anv_Latn', 'yaq_Latn', 'arl_Latn', 'irk_Latn', 'ncl_Latn', 'kdc_Latn', 'aoz_Latn', 'gai_Latn', 'mie_Latn', 'nca_Latn', 'tku_Latn', 'kez_Latn', 'maq_Latn', 'awb_Latn', 'hnn_Latn', 'nhy_Latn', 'nfr_Latn', 'agu_Latn', 'mnk_Latn', 'ltg_Latn', 'pne_Latn', 'blz_Latn', 'kdj_Latn', 'mwq_Latn', 'itv_Latn', 'lac_Latn', 'buk_Latn', 'mxp_Latn', 'khs_Latn', 'guq_Latn', 'kaq_Latn', 'ade_Latn', 'mnb_Latn', 'way_Latn', 'bmr_Latn', 'cjp_Latn', 'bmq_Latn', 'chz_Latn', 'bpr_Latn', 'nak_Latn', 'tiy_Latn', 'pdc_Latn', 'zsr_Latn', 'mzk_Latn', 'sue_Latn', 'fal_Latn', 'mxt_Latn', 'upv_Latn', 'mjc_Latn', 'kus_Latn', 'mwv_Latn', 'kjs_Latn', 'fai_Latn', 'bud_Latn', 'taj_Deva', 'pse_Latn', 'grt_Beng', 'mor_Latn', 'bwq_Latn', 'mbl_Latn', 'urk_Thai', 'zpo_Latn', 'nhd_Latn', 'kao_Latn', 'bku_Latn', 'sbd_Latn', 'cta_Latn', 'kyu_Mymr', 'cao_Latn', 'gah_Latn', 'sld_Latn', 'kud_Latn', 'lia_Latn', 'nsu_Latn', 'twu_Latn', 'tlb_Latn', 'tik_Latn', 'mog_Latn', 'cuc_Latn', 'wwa_Latn', 'byx_Latn', 'guk_Ethi', 'lww_Latn', 'ljp_Latn', 'usp_Latn', 'cot_Latn', 'iry_Latn', 'mhy_Latn', 'gor_Latn', 'for_Latn', 'gam_Latn', 'mcu_Latn', 'kxc_Ethi', 'bfo_Latn', 'snn_Latn', 'ceg_Latn', 'lef_Latn', 'ztq_Latn', 'sml_Latn', 'bqp_Latn', 'mil_Latn', 'mih_Latn', 'ozm_Latn', 'kmo_Latn', 'mnf_Latn', 'tnn_Latn', 'sas_Latn', 'mib_Latn', 'nij_Latn', 'zaa_Latn', 'kbh_Latn', 'bvr_Latn', 'bbr_Latn', 'zpq_Latn', 'qvs_Latn', 'nlc_Latn', 'stn_Latn', 'nko_Latn', 'tnk_Latn', 'cui_Latn', 'kbc_Latn', 'bnj_Latn', 'apr_Latn', 'mpg_Latn', 'thk_Latn', 'maj_Latn', 'kpx_Latn', 'tby_Latn', 'yuw_Latn', 'dzo_Tibt', 'naf_Latn', 'maz_Latn', 'alj_Latn', 'tuf_Latn', 'zia_Latn', 'dad_Latn', 'mfz_Latn', 'otn_Latn', 'sgb_Latn', 'tbc_Latn', 'tte_Latn', 'nmz_Latn', 'enb_Latn', 'otm_Latn', 'nii_Latn', 'cbv_Latn', 'zpm_Latn', 'wob_Latn', 'neb_Latn', 'btt_Latn', 'yli_Latn', 'dig_Latn', 'sil_Latn', 'bgz_Latn', 'bkv_Latn', 'guh_Latn', 'wer_Latn', 'qwh_Latn', 'knk_Latn', 'qvo_Latn', 'gnd_Latn', 'lew_Latn', 'mlp_Latn', 'zpi_Latn', 'amk_Latn', 'agg_Latn', 'gaw_Latn', 'icr_Latn', 'aeu_Latn', 'pbi_Latn', 'spp_Latn', 'mtj_Latn', 'mcf_Latn', 'hig_Latn', 'zav_Latn', 'mej_Latn', 'wos_Latn', 'dug_Latn', 'cut_Latn', 'alp_Latn', 'not_Latn', 'urt_Latn', 'mcb_Latn', 'dgc_Latn', 'imo_Latn', 'kno_Latn', 'amm_Latn', 'cwt_Latn', 'nou_Latn', 'pkb_Latn', 'dts_Latn', 'akh_Latn', 'dgz_Latn', 'cul_Latn', 'due_Latn', 'bkq_Latn', 'kbm_Latn', 'mur_Latn', 'mvp_Latn', 'ted_Latn', 'qvz_Latn', 'zyb_Latn', 'guo_Latn', 'jvn_Latn', 'duo_Latn', 'amf_Latn', 'sgz_Latn', 'urb_Latn', 'msk_Latn', 'tim_Latn', 'mit_Latn', 'kqy_Ethi', 'wim_Latn', 'kum_Cyrl', 'cjo_Latn', 'msy_Latn', 'rkb_Latn', 'hix_Latn', 'wiu_Latn', 'pad_Latn', 'pmf_Latn', 'pio_Latn', 'gfk_Latn', 'ppk_Latn', 'dah_Latn', 'hot_Latn', 'cav_Latn', 'gdn_Latn', 'ura_Latn', 'waj_Latn', 'cbu_Latn', 'hla_Latn', 'myu_Latn', 'npy_Latn', 'kpw_Latn', 'tmd_Latn', 'ktb_Ethi', 'uvh_Latn', 'kxm_Thai', 'ntp_Latn', 'qup_Latn', 'taw_Latn', 'nwb_Latn', 'gbi_Latn', 'wnu_Latn', 'tna_Latn', 'tlf_Latn', 'cjv_Latn', 'pah_Latn', 'huu_Latn', 'tif_Latn', 'abz_Latn', 'bkd_Latn', 'amr_Latn', 'tav_Latn', 'ian_Latn', 'qvh_Latn', 'sua_Latn', 'kpj_Latn', 'qvw_Latn', 'boa_Latn', 'opm_Latn', 'yaa_Latn', 'nab_Latn', 'qxo_Latn', 'kup_Latn', 'mhl_Latn', 'kze_Latn', 'agt_Latn', 'blw_Latn', 'kbr_Latn', 'mag_Deva', 'cof_Latn', 'sdq_Latn', 'sab_Latn', 'bvz_Latn', 'ino_Latn', 'ghs_Latn', 'yad_Latn', 'aji_Latn', 'shr_Latn', 'nlg_Latn', 'jbo_Latn', 'qvm_Latn', 'kzf_Latn', 'qxr_Latn', 'apn_Latn', 'bdh_Latn', 'nvm_Latn', 'aer_Latn', 'koi_Cyrl', 'lfn_Latn', 'okv_Latn', 'smn_Latn', 'yrb_Latn', 'ybb_Latn', 'cag_Latn', 'aby_Latn', 'spl_Latn', 'any_Latn', 'dag_Latn', 'tbl_Latn', 'mpt_Latn', 'sma_Latn', 'xal_Cyrl', 'myw_Latn', 'ksh_Latn', 'ksf_Latn', 'ewo_Latn', 'nuy_Latn', 'gvn_Latn', 'apu_Latn', 'mjw_Latn', 'cnk_Latn', 'ajz_Latn', 'gnb_Latn', 'dis_Latn', 'var_Latn', 'cux_Latn', 'ghe_Deva', 'adl_Latn', 'nki_Latn', 'mqy_Latn', 'niy_Latn', 'nbe_Latn', 'crm_Cans', 'npo_Latn', 'nxd_Latn', 'nmh_Latn', 'poy_Latn', 'aim_Latn', 'nph_Latn', 'tro_Latn', 'maf_Latn', 'iqw_Latn', 'whk_Latn', 'nng_Latn', 'lgm_Latn', 'nri_Latn', 'bsc_Latn', 'ria_Latn', 'esu_Latn', 'bom_Latn', 'nnp_Latn', 'pps_Latn', 'ngc_Latn', 'bbj_Latn', 'apt_Latn', 'lol_Latn', 'crx_Latn', 'kuj_Latn', 'nma_Latn', 'gud_Latn', 'kix_Latn', 'apw_Latn', 'ald_Latn', 'beq_Latn', 'biu_Latn', 'kqs_Latn', 'njz_Latn', 'nsa_Latn', 'nct_Latn', 'lmp_Latn', 'ndi_Latn', 'gid_Latn', 'kvj_Latn', 'esi_Latn', 'dhm_Latn', 'lom_Latn', 'ksb_Latn', 'mzl_Latn', 'hop_Latn', 'mua_Latn', 'snf_Latn', 'khy_Latn', 'rub_Latn', 'kqo_Latn', 'dow_Latn', 'etu_Latn', 'ivb_Latn', 'kxw_Latn', 'suc_Latn', 'enl_Latn', 'tsg_Latn', 'mse_Latn', 'mbi_Latn', 'dur_Latn', 'bth_Latn', 'trc_Latn', 'njb_Latn', 'nbc_Latn', 'isd_Latn', 'lai_Latn', 'chq_Latn', 'bzi_Thai', 'ivv_Latn', 'rap_Latn', 'lsi_Latn', 'tnp_Latn', 'log_Latn', 'cbi_Latn', 'cmo_Khmr', 'lhi_Latn', 'sat_Latn', 'ksc_Latn', 'qxl_Latn', 'clu_Latn', 'mtg_Latn', 'qva_Latn', 'mmn_Latn', 'gdg_Latn', 'gmv_Ethi', 'lif_Limb', 'srq_Latn', 'nnh_Latn', 'bqj_Latn', 'crt_Latn', 'cbt_Latn', 'mbd_Latn', 'apb_Latn', 'djr_Latn', 'frr_Latn', 'syb_Latn', 'brh_Arab', 'cpy_Latn', 'fue_Latn', 'sbe_Latn', 'gbr_Latn', 'oym_Latn', 'xnn_Latn', 'mal_Latn', 'tbk_Latn', 'kmy_Latn', 'hwc_Latn', 'rcf_Latn', 'ipi_Latn', 'kmg_Latn', 'kas_Arab', 'frd_Latn', 'daf_Latn', 'lbj_Tibt', 'avn_Latn', 'nmo_Latn', 'ilb_Latn', 'lad_Latn', 'ati_Latn', 'vep_Latn', 'sgw_Ethi', 'mrg_Latn', 'nod_Thai', 'wib_Latn', 'cos_Latn', 'bgt_Latn', 'knc_Latn', 'csb_Latn', 'krl_Latn', 'dsb_Latn', 'llg_Latn', 'row_Latn', 'fud_Latn', 'pny_Latn', 'rej_Latn', 'rtm_Latn', 'lgg_Latn', 'stq_Latn', 'kkc_Latn', 'shi_Latn', 'ext_Latn', 'ntu_Latn', 'syl_Latn', 'sgs_Latn', 'zea_Latn', 'rue_Cyrl', 'pfl_Latn', 'tcy_Knda', 'swg_Latn', 'rgu_Latn', 'enq_Latn', 'gna_Latn', 'pem_Latn', 'wrk_Latn', 'ksp_Latn', 'tew_Latn', 'lln_Latn', 'nqo_Nkoo', 'nuj_Latn', 'bhp_Latn', 'olo_Latn', 'mpp_Latn', 'kqw_Latn', 'sfw_Latn', 'smj_Latn', 'mgo_Latn', 'bsp_Latn', 'sgc_Latn', 'aca_Latn', 'loq_Latn', 'hav_Latn', 'guz_Latn', 'kas_Deva', 'ksj_Latn', 'bxh_Latn', 'syc_Syrc', 'wba_Latn', 'luc_Latn', 'ess_Latn', 'tap_Latn', 'thl_Deva', 'yrl_Latn', 'chr_Cher', 'kvg_Latn', 'keo_Latn', 'loe_Latn', 'sck_Deva', 'dje_Latn', 'chr_Latn', 'kle_Deva', 'yaz_Latn', 'trs_Latn', 'tmc_Latn', 'kpq_Latn', 'pui_Latn', 'gej_Latn', 'rjs_Deva', 'ayp_Arab', 'pua_Latn', 'mip_Latn', 'rav_Deva', 'ndp_Latn', 'kdp_Latn', 'pss_Latn', 'mup_Deva', 'ddn_Latn', 'kcg_Latn', 'szb_Latn', 'cdf_Latn', 'ndy_Latn', 'gbo_Latn', 'nkf_Latn', 'trq_Latn', 'oku_Latn', 'kma_Latn', 'tqo_Latn', 'dip_Latn', 'kff_Telu', 'dos_Latn', 'mbf_Latn', 'cnw_Latn', 'jun_Orya', 'khq_Latn', 'xmm_Latn', 'lok_Latn', 'raw_Latn', 'bmv_Latn', 'ccp_Latn', 'cou_Latn', 'twb_Latn', 'abi_Latn', 'hlt_Latn', 'gwr_Latn', 'gof_Ethi', 'lis_Lisu', 'ker_Latn', 'shk_Latn', 'fuv_Arab', 'kmr_Cyrl', 'otd_Latn', 'las_Latn', 'rel_Latn', 'blh_Latn', 'guu_Latn', 'ayo_Latn', 'dsh_Latn', 'yat_Latn', 'lgl_Latn', 'kmd_Latn', 'far_Latn', 'kgr_Latn', 'bvc_Latn', 'mim_Latn', 'bhz_Latn', 'cas_Latn', 'bbo_Latn', 'met_Latn', 'blt_Latn', 'trn_Latn', 'bkl_Latn', 'cmr_Latn', 'saj_Latn', 'yuz_Latn', 'are_Latn', 'ttq_Latn', 'awi_Latn', 'dbq_Latn', 'atq_Latn', 'dtb_Latn', 'wat_Latn', 'wal_Ethi', 'swk_Latn', 'ury_Latn', 'yas_Latn', 'law_Latn', 'nif_Latn', 'tnr_Latn', 'dnw_Latn', 'haw_Latn', 'xbr_Latn', 'etr_Latn', 'aly_Latn', 'did_Latn', 'mnx_Latn', 'wed_Latn', 'crk_Latn', 'knc_Arab', 'taq_Tfng', 'bjn_Arab', 'ace_Arab', 'sms_Latn', 'xbi_Latn', 'qus_Latn', 'lfn_Cyrl', 'trv_Latn', 'tnc_Latn', 'frp_Latn', 'rup_Latn', 'mgc_Latn', 'kzj_Latn', 'mwp_Latn', 'bhg_Latn', 'tuk_Arab', 'mwc_Latn', 'nrm_Latn', 'oto_Latn', 'acm_Arab', 'aui_Latn', 'kqf_Latn', 'ain_Latn', 'crk_Cans', 'got_Latn', 'kyu_Latn', 'jaa_Latn', 'nza_Latn', 'tul_Latn', 'kbo_Latn', 'prq_Latn', 'crl_Cans', 'lap_Latn', 'crj_Cans', 'shu_Arab', 'pos_Latn', 'zoc_Latn', 'bbk_Latn', 'tbw_Latn', 'chj_Latn', 'kyu_Kali', 'lcp_Thai', 'ttq_Tfng', 'bvd_Latn', 'uth_Latn', 'ncq_Laoo', 'omb_Latn', 'bno_Latn', 'bdq_Latn', 'uri_Latn', 'ady_Cyrl', 'syl_Beng', 'snd_Latn', 'ktm_Latn', 'kan_Latn', 'guj_Latn', 'tam_Latn', 'pan_Latn', 'tel_Latn', 'msc_Latn', 'wsg_Telu', 'gos_Latn', 'mar_Latn', 'ben_Latn', 'fit_Latn', 'rmq_Latn', 'tly_Latn', 'nss_Latn', 'led_Latn', 'doi_Deva', 'anp_Deva', 'pot_Latn', 'kny_Latn', 'gom_Deva', 'brx_Deva', 'mni_Mtei', 'ngb_Latn', 'mer_Latn', 'rhg_Latn', 'aoi_Latn', 'lea_Latn', 'bsq_Latn', 'nhk_Latn', 'nbq_Latn', 'klt_Latn', 'tig_Ethi', 'avk_Latn', 'gmh_Latn', 'ckm_Latn', 'kkl_Latn', 'zgh_Tfng', 'srr_Latn', 'awx_Latn', 'spm_Latn', 'arq_Arab', 'eko_Latn', 'bco_Latn', 'bwd_Latn', 'mui_Latn', 'adz_Latn', 'inh_Cyrl', 'bjp_Latn', 'ckt_Cyrl', 'pcd_Latn', 'szy_Latn', 'snd_Deva', 'nmw_Latn', 'kzn_Latn', 'skr_Arab', 'dak_Latn', 'cri_Latn', 'arp_Latn', 'agx_Cyrl', 'wmt_Latn', 'eve_Cyrl', 'fad_Latn', 'yrk_Cyrl', 'fkv_Latn', 'dar_Cyrl', 'kdh_Latn', 'nrf_Latn', 'nov_Latn', 'rml_Latn', 'byv_Latn', 'atj_Latn', 'amx_Latn', 'vmk_Latn', 'dhg_Latn', 'ikt_Latn', 'nuz_Latn', 'mfg_Latn', 'tzm_Tfng', 'goa_Latn', 'moh_Latn', 'zdj_Latn', 'wlv_Latn', 'mkz_Latn', 'lwg_Latn', 'cnr_Latn', 'abs_Latn', 'ddg_Latn', 'cjs_Cyrl', 'mzz_Latn', 'zxx_Arab', 'lbb_Latn', 'bea_Latn', 'kql_Latn', 'tpa_Latn', 'bmk_Latn', 'kby_Latn', 'swb_Latn', 'bla_Latn', 'cho_Latn', 'mph_Latn', 'urw_Latn', 'itl_Cyrl', 'fmu_Deva', 'mns_Cyrl', 'krx_Latn', 'kca_Cyrl', 'soe_Latn', 'prg_Latn', 'kqa_Latn', 'tat_Latn', 'mni_Latn', 'arb_Latn', 'min_Arab', 'pnt_Grek', 'mrq_Latn', 'zpg_Latn', 'dng_Cyrl', 'lld_Latn', 'mlu_Latn', 'whg_Latn', 'tkr_Cyrl', 'kap_Cyrl', 'tay_Latn', 'kex_Deva', 'wew_Latn', 'sdc_Latn', 'sjo_Mong', 'ota_Arab', 'eme_Latn', 'liv_Latn', 'sdo_Latn', 'say_Latn', 'ndh_Latn', 'sgh_Cyrl', 'pwn_Latn', 'arr_Latn', 'lud_Latn', 'nan_Hani', 'mhw_Latn', 'non_Latn', 'tkl_Latn', 'ang_Latn', 'tpn_Latn', 'asm_Latn', 'ory_Latn', 'tuv_Latn', 'mus_Latn', 'kas_Latn', 'hoc_Wara', 'hoc_Latn', 'brx_Latn', 'thv_Latn', 'rme_Latn', 'tpw_Latn', 'npi_Latn', 'ktz_Latn', 'knx_Latn', 'lez_Cyrl', 'max_Latn', 'pmq_Latn', 'goh_Latn', 'mnw_Mymr', 'zsm_Arab', 'mev_Latn', 'sbs_Latn', 'mwf_Latn', 'yup_Latn', 'aqz_Latn', 'jav_Java', 'csw_Latn', 'nla_Latn', 'cwd_Cans', 'kei_Latn', 'bwi_Latn', 'lki_Arab', 'drg_Latn', 'tzl_Latn', 'mgm_Latn', 'lad_Hebr', 'lbe_Cyrl', 'sby_Latn', 'lrc_Arab', 'diu_Latn', 'kak_Latn', 'bor_Latn', 'eto_Latn', 'dty_Deva', 'abq_Cyrl', 'mrv_Latn', 'got_Goth', 'csw_Cans', 'vot_Latn', 'sel_Cyrl', 'ldn_Latn', 'sju_Latn', 'nio_Cyrl', 'xum_Latn', 'zpj_Latn', 'kdr_Latn', 'otw_Latn']

SP_LM_LIST = ['oc', 'ko', 'sq', 'bpy', 'bs', 'fi', 'or', 'ast', 'dsb', 'war', 'ms', 'hi', 'it', 'br', 'ur', 'als', 'vi', 'th', 'tg', 'ilo', 'bcl', 'li', 'gn', 'bh', 'ky', 'eo', 'af', 'tk', 'dv', 'mt', 'frr', 'mk', 'min', 'nah', 'sa', 'scn', 'la', 'gd', 'jv', 'hr', 'lez', 'gom', 'pt', 'ps', 'pam', 'rue', 'ga', 'vls', 'da', 'myv', 'si', 'hu', 'ja', 'ba', 'ku', 'hy', 'ckb', 'ru', 'te', 'mhr', 'lv', 'hsb', 'kk', 'kw', 'sk', 'mn', 'arz', 'zh', 'bn', 'ht', 'rm', 'ro', 'el', 'pms', 'my', 'eu', 'km', 'mwl', 'mai', 'vo', 'is', 'es', 'mg', 'nl', 'wa', 'pl', 'lb', 'fr', 'fy', 'wuu', 'io', 'nds', 'av', 'lo', 'as', 'uk', 'ce', 'id', 'cv', 'qu', 'cs', 'an', 'kv', 'ceb', 'he', 'ia', 'mr', 'be', '', 'et', 'pnb', 'bo', 'vec', 'ug', 'no', 'tr', 'new', 'sd', 'bxr', 'azb', 'gu', 'lt', 'gl', 'tt', 'sah', 'am', 'lmo', 'ie', 'nn', 'sv', 'su', 'sh', 'tl', 'kn', 'ar', 'az', 'eml', 'de', 'mzn', 'yo', 'ml', 'yi', 'fa', 'jbo', 'sr', 'sw', 'so', 'ta', 'ka', 'nap', 'en', 'cy', 'sl', 'bar', 'ne', 'pa', 'os', 'uz', 'xmf', 'krc', 'mrj', 'xal', 'ca', 'bg', 'tyv']

CULTURAX_LANG_LIST = ['af', 'sq', 'am', 'ar', 'an', 'hy', 'as', 'ast', 'av', 'az', 'bn', 'ba', 'eu', 'bar', 'be', 'bh', 'bpy', 'bs', 'br', 'bg', 'my', 'yue', 'ca', 'ceb', 'bcl', 'ckb', 'cbk', 'ce', 'zh', 'cv', 'kw', 'hr', 'cs', 'da', 'dv', 'nl', 'mhr', 'arz', 'eml', 'en', 'myv', 'eo', 'et', 'tl', 'fi', 'fr', 'gl', 'ka', 'de', 'gom', 'el', 'gn', 'gu', 'ht', 'he', 'hi', 'hu', 'is', 'io', 'ilo', 'id', 'ia', 'ie', 'ga', 'it', 'ja', 'jv', 'xal', 'kn', 'krc', 'kk', 'km', 'kv', 'ko', 'ku', 'ky', 'lo', 'la', 'lv', 'lez', 'li', 'lt', 'jbo', 'lmo', 'nds', 'dsb', 'lb', 'mk', 'mai', 'mg', 'ms', 'ml', 'mt', 'mr', 'mzn', 'min', 'xmf', 'mwl', 'mn', 'nah', 'nap', 'ne', 'new', 'frr', 'lrc', 'no', 'nn', 'oc', 'or', 'os', 'pam', 'ps', 'fa', 'pms', 'pl', 'pt', 'pa', 'qu', 'ro', 'rm', 'bxr', 'ru', 'rue', 'sah', 'sa', 'gd', 'sr', 'sh', 'scn', 'sd', 'si', 'sk', 'sl', 'so', 'azb', 'es', 'su', 'sw', 'sv', 'als', 'tg', 'ta', 'tt', 'te', 'th', 'bo', 'tr', 'tk', 'tyv', 'uk', 'hsb', 'ur', 'ug', 'uz', 'vec', 'vi', 'vo', 'wa', 'war', 'cy', 'vls', 'fy', 'mrj', 'pnb', 'wuu', 'yi', 'yo']

MADLAD_LANG_LIST = ['en', 'ru', 'es', 'fr', 'de', 'it', 'pt', 'pl', 'nl', 'vi', 'tr', 'sv', 'id', 'ro', 'cs', 'zh', 'hu', 'ja', 'th', 'fi', 'fa', 'uk', 'da', 'el', 'no', 'bg', 'sk', 'ko', 'ar', 'lt', 'ca', 'sl', 'he', 'et', 'lv', 'hi', 'sq', 'ms', 'az', 'sr', 'ta', 'hr', 'kk', 'is', 'ml', 'mr', 'te', 'af', 'gl', 'fil', 'be', 'mk', 'eu', 'bn', 'ka', 'mn', 'bs', 'uz', 'ur', 'sw', 'yue', 'ne', 'kn', 'kaa', 'gu', 'si', 'cy', 'eo', 'la', 'hy', 'ky', 'tg', 'ga', 'mt', 'my', 'km', 'tt', 'so', 'ku', 'ps', 'pa', 'rw', 'lo', 'ha', 'dv', 'fy', 'lb', 'ckb', 'mg', 'gd', 'am', 'ug', 'ht', 'grc', 'hmn', 'sd', 'jv', 'mi', 'tk', 'ceb', 'yi', 'ba', 'fo', 'or', 'xh', 'su', 'kl', 'ny', 'sm', 'sn', 'co', 'zu', 'ig', 'yo', 'pap', 'st', 'haw', 'as', 'oc', 'cv', 'lus', 'tet', 'gsw', 'sah', 'br', 'rm', 'sa', 'bo', 'om', 'se', 'ce', 'cnh', 'ilo', 'hil', 'udm', 'os', 'lg', 'ti', 'vec', 'ts', 'tyv', 'kbd', 'ee', 'iba', 'av', 'kha', 'to', 'tn', 'nso', 'fj', 'zza', 'ak', 'ada', 'otq', 'dz', 'bua', 'cfm', 'ln', 'chm', 'gn', 'krc', 'wa', 'hif', 'yua', 'srn', 'war', 'rom', 'bik', 'pam', 'sg', 'lu', 'ady', 'kbp', 'syr', 'ltg', 'myv', 'iso', 'kac', 'bho', 'ay', 'kum', 'qu', 'za', 'pag', 'ngu', 've', 'pck', 'zap', 'tyz', 'hui', 'bbc', 'tzo', 'tiv', 'ksd', 'gom', 'min', 'ang', 'nhe', 'bgp', 'nzi', 'nnb', 'nv', 'zxx', 'bci', 'kv', 'new', 'mps', 'alt', 'meu', 'bew', 'fon', 'iu', 'abt', 'mgh', 'mnw', 'tvl', 'dov', 'tlh', 'ho', 'kw', 'mrj', 'meo', 'crh', 'mbt', 'emp', 'ace', 'ium', 'mam', 'gym', 'mai', 'crs', 'pon', 'ubu', 'fip', 'quc', 'gv', 'kj', 'btx', 'ape', 'chk', 'rcf', 'shn', 'tzh', 'mdf', 'ppk', 'ss', 'gag', 'cab', 'kri', 'seh', 'ibb', 'tbz', 'bru', 'enq', 'ach', 'cuk', 'kmb', 'wo', 'kek', 'qub', 'tab', 'bts', 'kos', 'rwo', 'cak', 'tuc', 'bum', 'cjk', 'gil', 'stq', 'tsg', 'quh', 'mak', 'arn', 'ban', 'jiv', 'sja', 'yap', 'tcy', 'toj', 'twu', 'xal', 'amu', 'rmc', 'hus', 'nia', 'kjh', 'bm', 'guh', 'mas', 'acf', 'dtp', 'ksw', 'bzj', 'din', 'zne', 'mad', 'msi', 'mag', 'mkn', 'kg', 'lhu', 'ch', 'qvi', 'mh', 'djk', 'sus', 'mfe', 'srm', 'dyu', 'ctu', 'gui', 'pau', 'inb', 'bi', 'mni', 'guc', 'jam', 'wal', 'jac', 'bas', 'gor', 'skr', 'nyu', 'noa', 'sda', 'gub', 'nog', 'cni', 'teo', 'tdx', 'sxn', 'rki', 'nr', 'frp', 'alz', 'taj', 'lrc', 'cce', 'rn', 'jvn', 'hvn', 'nij', 'dwr', 'izz', 'msm', 'bus', 'ktu', 'chr', 'maz', 'tzj', 'suz', 'knj', 'bim', 'gvl', 'bqc', 'tca', 'pis', 'prk', 'laj', 'mel', 'qxr', 'niq', 'ahk', 'shp', 'hne', 'spp', 'koi', 'krj', 'quf', 'luz', 'agr', 'tsc', 'mqy', 'gof', 'gbm', 'miq', 'dje', 'awa', 'bjj', 'qvz', 'sjp', 'tll', 'raj', 'kjg', 'bgz', 'quy', 'cbk', 'akb', 'oj', 'ify', 'mey', 'ks', 'cac', 'brx', 'qup', 'syl', 'jax', 'ff', 'ber', 'tks', 'trp', 'mrw', 'adh', 'smt', 'srr', 'ffm', 'qvc', 'mtr', 'ann', 'kaa-Latn', 'aa', 'noe', 'nut', 'gyn', 'kwi', 'xmm', 'msb', 'el-Latn', 'doi', 'mtq', 'dln', 'cyo', 'abs', 'hi-Latn', 'shu', 'yaq', 'nyo', 'cgg', 'sxu', 'mdh', 'rwr', 'xnr', 'mui', 'skg', 'ymm', 'ctd-Latn', 'ayl', 'kjb', 'rhg-Latn', 'bmm', 'azg', 'kfy', 'bto', 'ja-Latn', 'mfb', 'ru-Latn', 'tuf', 'ctg', 'pmy', 'xog', 'te-Latn', 'ber-Latn', 'mdy', 'az-RU', 'ta-Latn', 'clu', 'tly-IR', 'ng', 'bzc', 'nan-Latn-TW', 'ml-Latn', 'max', 'ar-Latn', 'gom-Latn', 'bg-Latn', 'nd', 'zyj', 'rkt', 'kn-Latn', 'zh-Latn', 'el-CY', 'dcc', 'bgc', 'mwr', 'vkt', 'cr-Latn', 'apd-SD', 'trw', 'bn-Latn', 'gu-Latn', 'gju', 'sat-Latn', 'ndc-ZW', 'kmz-Latn', 'mr-Latn', 'en-Cyrl', 'en-Arab', 'ms-Arab', 'ms-Arab-BN', 'bhb-Gujr', 'pa-Arab', 'syl-Latn', 'ff-Adlm', 'pcm', 'tpi', 'gjk', 'bfy', 'sgj', 'nyn']


current_file_path = os.path.abspath(__file__)
current_file_dir = os.path.dirname(current_file_path)
# current_file_dir = os.path.dirname(current_file_dir)

### lang mapping
LANG_MAPPING = {}
langs_id = []
lang_mapping_file = f'{current_file_dir}/post_scripts/lang_dict/glot_mapping.csv'
lang_mapping_pd = pd.read_csv(lang_mapping_file, sep=",", header=None)
for idx, row in lang_mapping_pd.iterrows():
    LANG_MAPPING[row[0]] = [row[1], row[2], row[3]]
    langs_id.append(
            {
                "lang": row[3],
                "dataset_id": row[0],
                "stopwords_id": row[0],
                "flagged_words_id": row[0],
                "fasttext_id": row[0],
                "sentencepiece_id": row[2],
                "kenlm_id": row[2],
            }
        )

langs_id = pd.DataFrame(langs_id)