### 1. 一些dict

NLLB_to_TWO_CHAR = {
    "afr_Latn": "af",
    "als_Latn": "sq",
    "amh_Ethi": "am",
    "arb_Arab": "ar",
    "ast_Latn": "ast",
    "azj_Latn": "az",
    "bel_Cyrl": "be",
    "ben_Beng": "bn",
    "bul_Cyrl": "bg",
    "cat_Latn": "ca",
    "ceb_Latn": "ceb",
    "ces_Latn": "cs",
    "cym_Latn": "cy",
    "dan_Latn": "da",
    "deu_Latn": "de",
    "ell_Grek": "el",
    "eng_Latn": "en",
    "epo_Latn": "eo",
    "est_Latn": "et",
    "fin_Latn": "fi",
    "fra_Latn": "fr",
    "gaz_Latn": "om",
    "gla_Latn": "gd",
    "gle_Latn": "ga",
    "glg_Latn": "gl",
    "hau_Latn": "ha",
    "heb_Hebr": "he",
    "hin_Deva": "hi",
    "hrv_Latn": "hr",
    "hun_Latn": "hu",
    "hye_Armn": "hy",
    "ibo_Latn": "ig",
    "ilo_Latn": "ilo",
    "ind_Latn": "id",
    "isl_Latn": "is",
    "ita_Latn": "it",
    "jav_Latn": "jv",
    "jpn_Jpan": "ja",
    "kat_Geor": "ka",
    "kaz_Cyrl": "kk",
    "khm_Khmr": "km",
    "kor_Hang": "ko",
    "lit_Latn": "lt",
    "ltz_Latn": "lb",
    "lug_Latn": "lg",
    "lvs_Latn": "lv",
    "mal_Mlym": "ml",
    "mar_Deva": "mr",
    "mkd_Cyrl": "mk",
    "mya_Mymr": "my",
    "nld_Latn": "nl",
    "nob_Latn": "no",
    "npi_Deva": "ne",
    "oci_Latn": "oc",
    "ory_Orya": "or",
    "pes_Arab": "fa",
    "plt_Latn": "mg",
    "pol_Latn": "pl",
    "por_Latn": "pt",
    "ron_Latn": "ro",
    "rus_Cyrl": "ru",
    "sin_Sinh": "si",
    "slk_Latn": "sk",
    "slv_Latn": "sl",
    "snd_Arab": "sd",
    "som_Latn": "so",
    "spa_Latn": "es",
    "srp_Cyrl": "sr",
    "sun_Latn": "su",
    "swe_Latn": "sv",
    "swh_Latn": "sw",
    "tam_Taml": "ta",
    "tat_Cyrl": "tt",
    "tgl_Latn": "tl",
    "tur_Latn": "tr",
    "ukr_Cyrl": "uk",
    "urd_Arab": "ur",
    "uzn_Latn": "uz",
    "vie_Latn": "vi",
    "wol_Latn": "wo",
    "xho_Latn": "xh",
    "ydd_Hebr": "yi",
    "yor_Latn": "yo",
    "zho_Hans": "zh",
    "zsm_Latn": "ms",
    "zul_Latn": "zu",
}


### NLLB code to language name
NLLB_to_LANG_NAME = {
    'ace_Arab': 'Acehnese (Arabic script)',
    'ace_Latn': 'Acehnese (Latin script)',
    'acm_Arab': 'Mesopotamian Arabic',
    'acq_Arab': 'Ta’izzi-Adeni Arabic',
    'aeb_Arab': 'Tunisian Arabic',
    'afr_Latn': 'Afrikaans',
    'ajp_Arab': 'South Levantine Arabic',
    'aka_Latn': 'Akan',
    'amh_Ethi': 'Amharic',
    'apc_Arab': 'North Levantine Arabic',
    'arb_Arab': 'Modern Standard Arabic',
    'arb_Latn': 'Modern Standard Arabic (Romanized)',
    'ars_Arab': 'Najdi Arabic',
    'ary_Arab': 'Moroccan Arabic',
    'arz_Arab': 'Egyptian Arabic',
    'asm_Beng': 'Assamese',
    'ast_Latn': 'Asturian',
    'awa_Deva': 'Awadhi',
    'ayr_Latn': 'Central Aymara',
    'azb_Arab': 'South Azerbaijani',
    'azj_Latn': 'North Azerbaijani',
    'bak_Cyrl': 'Bashkir',
    'bam_Latn': 'Bambara',
    'ban_Latn': 'Balinese',
    'bel_Cyrl': 'Belarusian',
    'bem_Latn': 'Bemba',
    'ben_Beng': 'Bengali',
    'bho_Deva': 'Bhojpuri',
    'bjn_Arab': 'Banjar (Arabic script)',
    'bjn_Latn': 'Banjar (Latin script)',
    'bod_Tibt': 'Standard Tibetan',
    'bos_Latn': 'Bosnian',
    'bug_Latn': 'Buginese',
    'bul_Cyrl': 'Bulgarian',
    'cat_Latn': 'Catalan',
    'ceb_Latn': 'Cebuano',
    'ces_Latn': 'Czech',
    'cjk_Latn': 'Chokwe',
    'ckb_Arab': 'Central Kurdish',
    'crh_Latn': 'Crimean Tatar',
    'cym_Latn': 'Welsh',
    'dan_Latn': 'Danish',
    'deu_Latn': 'German',
    'dik_Latn': 'Southwestern Dinka',
    'dyu_Latn': 'Dyula',
    'dzo_Tibt': 'Dzongkha',
    'ell_Grek': 'Greek',
    'eng_Latn': 'English',
    'epo_Latn': 'Esperanto',
    'est_Latn': 'Estonian',
    'eus_Latn': 'Basque',
    'ewe_Latn': 'Ewe',
    'fao_Latn': 'Faroese',
    'fij_Latn': 'Fijian',
    'fin_Latn': 'Finnish',
    'fon_Latn': 'Fon',
    'fra_Latn': 'French',
    'fur_Latn': 'Friulian',
    'fuv_Latn': 'Nigerian Fulfulde',
    'gla_Latn': 'Scottish Gaelic',
    'gle_Latn': 'Irish',
    'glg_Latn': 'Galician',
    'grn_Latn': 'Guarani',
    'guj_Gujr': 'Gujarati',
    'hat_Latn': 'Haitian Creole',
    'hau_Latn': 'Hausa',
    'heb_Hebr': 'Hebrew',
    'hin_Deva': 'Hindi',
    'hne_Deva': 'Chhattisgarhi',
    'hrv_Latn': 'Croatian',
    'hun_Latn': 'Hungarian',
    'hye_Armn': 'Armenian',
    'ibo_Latn': 'Igbo',
    'ilo_Latn': 'Ilocano',
    'ind_Latn': 'Indonesian',
    'isl_Latn': 'Icelandic',
    'ita_Latn': 'Italian',
    'jav_Latn': 'Javanese',
    'jpn_Jpan': 'Japanese',
    'kab_Latn': 'Kabyle',
    'kac_Latn': 'Jingpho',
    'kam_Latn': 'Kamba',
    'kan_Knda': 'Kannada',
    'kas_Arab': 'Kashmiri (Arabic script)',
    'kas_Deva': 'Kashmiri (Devanagari script)',
    'kat_Geor': 'Georgian',
    'knc_Arab': 'Central Kanuri (Arabic script)',
    'knc_Latn': 'Central Kanuri (Latin script)',
    'kaz_Cyrl': 'Kazakh',
    'kbp_Latn': 'Kabiyè',
    'kea_Latn': 'Kabuverdianu',
    'khm_Khmr': 'Khmer',
    'kik_Latn': 'Kikuyu',
    'kin_Latn': 'Kinyarwanda',
    'kir_Cyrl': 'Kyrgyz',
    'kmb_Latn': 'Kimbundu',
    'kmr_Latn': 'Northern Kurdish',
    'kon_Latn': 'Kikongo',
    'kor_Hang': 'Korean',
    'lao_Laoo': 'Lao',
    'lij_Latn': 'Ligurian',
    'lim_Latn': 'Limburgish',
    'lin_Latn': 'Lingala',
    'lit_Latn': 'Lithuanian',
    'lmo_Latn': 'Lombard',
    'ltg_Latn': 'Latgalian',
    'ltz_Latn': 'Luxembourgish',
    'lua_Latn': 'Luba-Kasai',
    'lug_Latn': 'Ganda',
    'luo_Latn': 'Luo',
    'lus_Latn': 'Mizo',
    'lvs_Latn': 'Standard Latvian',
    'mag_Deva': 'Magahi',
    'mai_Deva': 'Maithili',
    'mal_Mlym': 'Malayalam',
    'mar_Deva': 'Marathi',
    'min_Arab': 'Minangkabau (Arabic script)',
    'min_Latn': 'Minangkabau (Latin script)',
    'mkd_Cyrl': 'Macedonian',
    'plt_Latn': 'Plateau Malagasy',
    'mlt_Latn': 'Maltese',
    'mni_Beng': 'Meitei (Bengali script)',
    'khk_Cyrl': 'Halh Mongolian',
    'mos_Latn': 'Mossi',
    'mri_Latn': 'Maori',
    'mya_Mymr': 'Burmese',
    'nld_Latn': 'Dutch',
    'nno_Latn': 'Norwegian Nynorsk',
    'nob_Latn': 'Norwegian Bokmål',
    'npi_Deva': 'Nepali',
    'nso_Latn': 'Northern Sotho',
    'nus_Latn': 'Nuer',
    'nya_Latn': 'Nyanja',
    'oci_Latn': 'Occitan',
    'gaz_Latn': 'West Central Oromo',
    'ory_Orya': 'Odia',
    'pag_Latn': 'Pangasinan',
    'pan_Guru': 'Eastern Panjabi',
    'pap_Latn': 'Papiamento',
    'pes_Arab': 'Western Persian',
    'pol_Latn': 'Polish',
    'por_Latn': 'Portuguese',
    'prs_Arab': 'Dari',
    'pbt_Arab': 'Southern Pashto',
    'quy_Latn': 'Ayacucho Quechua',
    'ron_Latn': 'Romanian',
    'run_Latn': 'Rundi',
    'rus_Cyrl': 'Russian',
    'sag_Latn': 'Sango',
    'san_Deva': 'Sanskrit',
    'sat_Olck': 'Santali',
    'scn_Latn': 'Sicilian',
    'shn_Mymr': 'Shan',
    'sin_Sinh': 'Sinhala',
    'slk_Latn': 'Slovak',
    'slv_Latn': 'Slovenian',
    'smo_Latn': 'Samoan',
    'sna_Latn': 'Shona',
    'snd_Arab': 'Sindhi',
    'som_Latn': 'Somali',
    'sot_Latn': 'Southern Sotho',
    'spa_Latn': 'Spanish',
    'als_Latn': 'Tosk Albanian',
    'srd_Latn': 'Sardinian',
    'srp_Cyrl': 'Serbian',
    'ssw_Latn': 'Swati',
    'sun_Latn': 'Sundanese',
    'swe_Latn': 'Swedish',
    'swh_Latn': 'Swahili',
    'szl_Latn': 'Silesian',
    'tam_Taml': 'Tamil',
    'tat_Cyrl': 'Tatar',
    'tel_Telu': 'Telugu',
    'tgk_Cyrl': 'Tajik',
    'tgl_Latn': 'Tagalog',
    'tha_Thai': 'Thai',
    'tir_Ethi': 'Tigrinya',
    'taq_Latn': 'Tamasheq (Latin script)',
    'taq_Tfng': 'Tamasheq (Tifinagh script)',
    'tpi_Latn': 'Tok Pisin',
    'tsn_Latn': 'Tswana',
    'tso_Latn': 'Tsonga',
    'tuk_Latn': 'Turkmen',
    'tum_Latn': 'Tumbuka',
    'tur_Latn': 'Turkish',
    'twi_Latn': 'Twi',
    'tzm_Tfng': 'Central Atlas Tamazight',
    'uig_Arab': 'Uyghur',
    'ukr_Cyrl': 'Ukrainian',
    'umb_Latn': 'Umbundu',
    'urd_Arab': 'Urdu',
    'uzn_Latn': 'Northern Uzbek',
    'vec_Latn': 'Venetian',
    'vie_Latn': 'Vietnamese',
    'war_Latn': 'Waray',
    'wol_Latn': 'Wolof',
    'xho_Latn': 'Xhosa',
    'ydd_Hebr': 'Eastern Yiddish',
    'yor_Latn': 'Yoruba',
    'yue_Hant': 'Yue Chinese',
    'zho_Hans': 'Chinese (Simplified)',
    'zho_Hant': 'Chinese (Traditional)',
    'zsm_Latn': 'Standard Malay',
    'zul_Latn': 'Zulu',
}

### language name to NLLB code
LANG_NAME_to_NLLB = {
    'Acehnese (Arabic script)': 'ace_Arab',
    'Acehnese (Latin script)': 'ace_Latn',
    'Mesopotamian Arabic': 'acm_Arab',
    'Ta’izzi-Adeni Arabic': 'acq_Arab',
    'Tunisian Arabic': 'aeb_Arab',
    'Afrikaans': 'afr_Latn',
    'South Levantine Arabic': 'ajp_Arab',
    'Akan': 'aka_Latn',
    'Amharic': 'amh_Ethi',
    'North Levantine Arabic': 'apc_Arab',
    'Modern Standard Arabic': 'arb_Arab',
    'Modern Standard Arabic (Romanized)': 'arb_Latn',
    'Najdi Arabic': 'ars_Arab',
    'Moroccan Arabic': 'ary_Arab',
    'Egyptian Arabic': 'arz_Arab',
    'Assamese': 'asm_Beng',
    'Asturian': 'ast_Latn',
    'Awadhi': 'awa_Deva',
    'Central Aymara': 'ayr_Latn',
    'South Azerbaijani': 'azb_Arab',
    'North Azerbaijani': 'azj_Latn',
    'Bashkir': 'bak_Cyrl',
    'Bambara': 'bam_Latn',
    'Balinese': 'ban_Latn',
    'Belarusian': 'bel_Cyrl',
    'Bemba': 'bem_Latn',
    'Bengali': 'ben_Beng',
    'Bhojpuri': 'bho_Deva',
    'Banjar (Arabic script)': 'bjn_Arab',
    'Banjar (Latin script)': 'bjn_Latn',
    'Standard Tibetan': 'bod_Tibt',
    'Bosnian': 'bos_Latn',
    'Buginese': 'bug_Latn',
    'Bulgarian': 'bul_Cyrl',
    'Catalan': 'cat_Latn',
    'Cebuano': 'ceb_Latn',
    'Czech': 'ces_Latn',
    'Chokwe': 'cjk_Latn',
    'Central Kurdish': 'ckb_Arab',
    'Crimean Tatar': 'crh_Latn',
    'Welsh': 'cym_Latn',
    'Danish': 'dan_Latn',
    'German': 'deu_Latn',
    'Southwestern Dinka': 'dik_Latn',
    'Dyula': 'dyu_Latn',
    'Dzongkha': 'dzo_Tibt',
    'Greek': 'ell_Grek',
    'English': 'eng_Latn',
    'Esperanto': 'epo_Latn',
    'Estonian': 'est_Latn',
    'Basque': 'eus_Latn',
    'Ewe': 'ewe_Latn',
    'Faroese': 'fao_Latn',
    'Fijian': 'fij_Latn',
    'Finnish': 'fin_Latn',
    'Fon': 'fon_Latn',
    'French': 'fra_Latn',
    'Friulian': 'fur_Latn',
    'Nigerian Fulfulde': 'fuv_Latn',
    'Scottish Gaelic': 'gla_Latn',
    'Irish': 'gle_Latn',
    'Galician': 'glg_Latn',
    'Guarani': 'grn_Latn',
    'Gujarati': 'guj_Gujr',
    'Haitian Creole': 'hat_Latn',
    'Hausa': 'hau_Latn',
    'Hebrew': 'heb_Hebr',
    'Hindi': 'hin_Deva',
    'Chhattisgarhi': 'hne_Deva',
    'Croatian': 'hrv_Latn',
    'Hungarian': 'hun_Latn',
    'Armenian': 'hye_Armn',
    'Igbo': 'ibo_Latn',
    'Ilocano': 'ilo_Latn',
    'Indonesian': 'ind_Latn',
    'Icelandic': 'isl_Latn',
    'Italian': 'ita_Latn',
    'Javanese': 'jav_Latn',
    'Japanese': 'jpn_Jpan',
    'Kabyle': 'kab_Latn',
    'Jingpho': 'kac_Latn',
    'Kamba': 'kam_Latn',
    'Kannada': 'kan_Knda',
    'Kashmiri (Arabic script)': 'kas_Arab',
    'Kashmiri (Devanagari script)': 'kas_Deva',
    'Georgian': 'kat_Geor',
    'Central Kanuri (Arabic script)': 'knc_Arab',
    'Central Kanuri (Latin script)': 'knc_Latn',
    'Kazakh': 'kaz_Cyrl',
    'Kabiyè': 'kbp_Latn',
    'Kabuverdianu': 'kea_Latn',
    'Khmer': 'khm_Khmr',
    'Kikuyu': 'kik_Latn',
    'Kinyarwanda': 'kin_Latn',
    'Kyrgyz': 'kir_Cyrl',
    'Kimbundu': 'kmb_Latn',
    'Northern Kurdish': 'kmr_Latn',
    'Kikongo': 'kon_Latn',
    'Korean': 'kor_Hang',
    'Lao': 'lao_Laoo',
    'Ligurian': 'lij_Latn',
    'Limburgish': 'lim_Latn',
    'Lingala': 'lin_Latn',
    'Lithuanian': 'lit_Latn',
    'Lombard': 'lmo_Latn',
    'Latgalian': 'ltg_Latn',
    'Luxembourgish': 'ltz_Latn',
    'Luba-Kasai': 'lua_Latn',
    'Ganda': 'lug_Latn',
    'Luo': 'luo_Latn',
    'Mizo': 'lus_Latn',
    'Standard Latvian': 'lvs_Latn',
    'Magahi': 'mag_Deva',
    'Maithili': 'mai_Deva',
    'Malayalam': 'mal_Mlym',
    'Marathi': 'mar_Deva',
    'Minangkabau (Arabic script)': 'min_Arab',
    'Minangkabau (Latin script)': 'min_Latn',
    'Macedonian': 'mkd_Cyrl',
    'Plateau Malagasy': 'plt_Latn',
    'Maltese': 'mlt_Latn',
    'Meitei (Bengali script)': 'mni_Beng',
    'Halh Mongolian': 'khk_Cyrl',
    'Mossi': 'mos_Latn',
    'Maori': 'mri_Latn',
    'Burmese': 'mya_Mymr',
    'Dutch': 'nld_Latn',
    'Norwegian Nynorsk': 'nno_Latn',
    'Norwegian Bokmål': 'nob_Latn',
    'Nepali': 'npi_Deva',
    'Northern Sotho': 'nso_Latn',
    'Nuer': 'nus_Latn',
    'Nyanja': 'nya_Latn',
    'Occitan': 'oci_Latn',
    'West Central Oromo': 'gaz_Latn',
    'Odia': 'ory_Orya',
    'Pangasinan': 'pag_Latn',
    'Eastern Panjabi': 'pan_Guru',
    'Papiamento': 'pap_Latn',
    'Western Persian': 'pes_Arab',
    'Polish': 'pol_Latn',
    'Portuguese': 'por_Latn',
    'Dari': 'prs_Arab',
    'Southern Pashto': 'pbt_Arab',
    'Ayacucho Quechua': 'quy_Latn',
    'Romanian': 'ron_Latn',
    'Rundi': 'run_Latn',
    'Russian': 'rus_Cyrl',
    'Sango': 'sag_Latn',
    'Sanskrit': 'san_Deva',
    'Santali': 'sat_Olck',
    'Sicilian': 'scn_Latn',
    'Shan': 'shn_Mymr',
    'Sinhala': 'sin_Sinh',
    'Slovak': 'slk_Latn',
    'Slovenian': 'slv_Latn',
    'Samoan': 'smo_Latn',
    'Shona': 'sna_Latn',
    'Sindhi': 'snd_Arab',
    'Somali': 'som_Latn',
    'Southern Sotho': 'sot_Latn',
    'Spanish': 'spa_Latn',
    'Tosk Albanian': 'als_Latn',
    'Sardinian': 'srd_Latn',
    'Serbian': 'srp_Cyrl',
    'Swati': 'ssw_Latn',
    'Sundanese': 'sun_Latn',
    'Swedish': 'swe_Latn',
    'Swahili': 'swh_Latn',
    'Silesian': 'szl_Latn',
    'Tamil': 'tam_Taml',
    'Tatar': 'tat_Cyrl',
    'Telugu': 'tel_Telu',
    'Tajik': 'tgk_Cyrl',
    'Tagalog': 'tgl_Latn',
    'Thai': 'tha_Thai',
    'Tigrinya': 'tir_Ethi',
    'Tamasheq (Latin script)': 'taq_Latn',
    'Tamasheq (Tifinagh script)': 'taq_Tfng',
    'Tok Pisin': 'tpi_Latn',
    'Tswana': 'tsn_Latn',
    'Tsonga': 'tso_Latn',
    'Turkmen': 'tuk_Latn',
    'Tumbuka': 'tum_Latn',
    'Turkish': 'tur_Latn',
    'Twi': 'twi_Latn',
    'Central Atlas Tamazight': 'tzm_Tfng',
    'Uyghur': 'uig_Arab',
    'Ukrainian': 'ukr_Cyrl',
    'Umbundu': 'umb_Latn',
    'Urdu': 'urd_Arab',
    'Northern Uzbek': 'uzn_Latn',
    'Venetian': 'vec_Latn',
    'Vietnamese': 'vie_Latn',
    'Waray': 'war_Latn',
    'Wolof': 'wol_Latn',
    'Xhosa': 'xho_Latn',
    'Eastern Yiddish': 'ydd_Hebr',
    'Yoruba': 'yor_Latn',
    'Yue Chinese': 'yue_Hant',
    'Chinese (Simplified)': 'zho_Hans',
    'Chinese (Traditional)': 'zho_Hant',
    'Standard Malay': 'zsm_Latn',
    'Zulu': 'zul_Latn',
}

### NLLB code to three character language code
NLLB_to_THREE_CHAR = {
    'afr_Latn': 'afr',
    'amh_Ethi': 'amh',
    'arb_Arab': 'ara',
    'asm_Beng': 'asm',
    'ast_Latn': 'ast',
    'azj_Latn': 'azj',
    'bel_Cyrl': 'bel',
    'ben_Beng': 'ben',
    'bos_Latn': 'bos',
    'bul_Cyrl': 'bul',
    'cat_Latn': 'cat',
    'ceb_Latn': 'ceb',
    'ces_Latn': 'ces',
    'ckb_Arab': 'ckb',
    'cym_Latn': 'cym',
    'dan_Latn': 'dan',
    'deu_Latn': 'deu',
    'ell_Grek': 'ell',
    'eng_Latn': 'eng',
    'est_Latn': 'est',
    'fin_Latn': 'fin',
    'fra_Latn': 'fra',
    'fuv_Latn': 'ful',
    'gle_Latn': 'gle',
    'glg_Latn': 'glg',
    'guj_Gujr': 'guj',
    'hau_Latn': 'hau',
    'heb_Hebr': 'heb',
    'hin_Deva': 'hin',
    'hrv_Latn': 'hrv',
    'hun_Latn': 'hun',
    'hye_Armn': 'hye',
    'ibo_Latn': 'ibo',
    'ind_Latn': 'ind',
    'isl_Latn': 'isl',
    'ita_Latn': 'ita',
    'jav_Latn': 'jav',
    'jpn_Jpan': 'jpn',
    'kam_Latn': 'kam',
    'kan_Knda': 'kan',
    'kat_Geor': 'kat',
    'kaz_Cyrl': 'kaz',
    'khm_Khmr': 'khm',
    'kir_Cyrl': 'kir',
    'kor_Hang': 'kor',
    'lao_Laoo': 'lao',
    'lij_Latn': 'Latvian',
    'lim_Latn': 'kea',
    'lin_Latn': 'lin',
    'lit_Latn': 'lit',
    'ltz_Latn': 'ltz',
    'lug_Latn': 'lug',
    'luo_Latn': 'luo',
    'lvs_Latn': 'lav',
    'mal_Mlym': 'mal',
    'mar_Deva': 'mar',
    'mkd_Cyrl': 'mkd',
    'mlt_Latn': 'mlt',
    'khk_Cyrl': 'mon',
    'mri_Latn': 'mri',
    'mya_Mymr': 'mya',
    'nld_Latn': 'nld',
    'nob_Latn': 'nob',
    'npi_Deva': 'npi',
    'nso_Latn': 'nso',
    'nya_Latn': 'nya',
    'oci_Latn': 'oci',
    'gaz_Latn': 'orm',
    'ory_Orya': 'ory',
    'pan_Guru': 'pan',
    'pes_Arab': 'fas',
    'pol_Latn': 'pol',
    'por_Latn': 'por',
    'pbt_Arab': 'pus',
    'ron_Latn': 'ron',
    'rus_Cyrl': 'rus',
    'slk_Latn': 'slk',
    'sna_Latn': 'sna',
    'snd_Arab': 'snd',
    'som_Latn': 'som',
    'spa_Latn': 'spa',
    'srp_Cyrl': 'srp',
    'swe_Latn': 'swe',
    'swh_Latn': 'swh',
    'tam_Taml': 'tam',
    'tel_Telu': 'tel',
    'tgk_Cyrl': 'tgk',
    'tgl_Latn': 'tgl',
    'tha_Thai': 'tha',
    'tur_Latn': 'tur',
    'ukr_Cyrl': 'ukr',
    'umb_Latn': 'umb',
    'urd_Arab': 'urd',
    'uzn_Latn': 'uzb',
    'vie_Latn': 'vie',
    'wol_Latn': 'wol',
    'xho_Latn': 'xho',
    'yor_Latn': 'yor',
    'zho_Hans': 'zho_simpl',
    'zho_Hant': 'zho_trad',
    'zsm_Latn': 'msa',
    'zul_Latn': 'zul'
}

### three character language code to NLLB code
THREE_CHAR_to_NLLB = {
    'afr': 'afr_Latn',
    'amh': 'amh_Ethi',
    'ara': 'arb_Arab',
    'asm': 'asm_Beng',
    'ast': 'ast_Latn',
    'azj': 'azj_Latn',
    'bel': 'bel_Cyrl',
    'ben': 'ben_Beng',
    'bos': 'bos_Latn',
    'bul': 'bul_Cyrl',
    'cat': 'cat_Latn',
    'ceb': 'ceb_Latn',
    'ces': 'ces_Latn',
    'ckb': 'ckb_Arab',
    'cym': 'cym_Latn',
    'dan': 'dan_Latn',
    'deu': 'deu_Latn',
    'ell': 'ell_Grek',
    'eng': 'eng_Latn',
    'est': 'est_Latn',
    'fin': 'fin_Latn',
    'fra': 'fra_Latn',
    'ful': 'fuv_Latn',
    'gle': 'gle_Latn',
    'glg': 'glg_Latn',
    'guj': 'guj_Gujr',
    'hau': 'hau_Latn',
    'heb': 'heb_Hebr',
    'hin': 'hin_Deva',
    'hrv': 'hrv_Latn',
    'hun': 'hun_Latn',
    'hye': 'hye_Armn',
    'ibo': 'ibo_Latn',
    'ind': 'ind_Latn',
    'isl': 'isl_Latn',
    'ita': 'ita_Latn',
    'jav': 'jav_Latn',
    'jpn': 'jpn_Jpan',
    'kam': 'kam_Latn',
    'kan': 'kan_Knda',
    'kat': 'kat_Geor',
    'kaz': 'kaz_Cyrl',
    'khm': 'khm_Khmr',
    'kir': 'kir_Cyrl',
    'kor': 'kor_Hang',
    'lao': 'lao_Laoo',
    'Latvian': 'lij_Latn',
    'kea': 'lim_Latn',
    'lin': 'lin_Latn',
    'lit': 'lit_Latn',
    'ltz': 'ltz_Latn',
    'lug': 'lug_Latn',
    'luo': 'luo_Latn',
    'lav': 'lvs_Latn',
    'mal': 'mal_Mlym',
    'mar': 'mar_Deva',
    'mkd': 'mkd_Cyrl',
    'mlt': 'mlt_Latn',
    'mon': 'khk_Cyrl',
    'mri': 'mri_Latn',
    'mya': 'mya_Mymr',
    'nld': 'nld_Latn',
    'nob': 'nob_Latn',
    'npi': 'npi_Deva',
    'nso': 'nso_Latn',
    'nya': 'nya_Latn',
    'oci': 'oci_Latn',
    'orm': 'gaz_Latn',
    'ory': 'ory_Orya',
    'pan': 'pan_Guru',
    'fas': 'pes_Arab',
    'pol': 'pol_Latn',
    'por': 'por_Latn',
    'pus': 'pbt_Arab',
    'ron': 'ron_Latn',
    'rus': 'rus_Cyrl',
    'slk': 'slk_Latn',
    'sna': 'sna_Latn',
    'snd': 'snd_Arab',
    'som': 'som_Latn',
    'spa': 'spa_Latn',
    'srp': 'srp_Cyrl',
    'swe': 'swe_Latn',
    'swh': 'swh_Latn',
    'tam': 'tam_Taml',
    'tel': 'tel_Telu',
    'tgk': 'tgk_Cyrl',
    'tgl': 'tgl_Latn',
    'tha': 'tha_Thai',
    'tur': 'tur_Latn',
    'ukr': 'ukr_Cyrl',
    'umb': 'umb_Latn',
    'urd': 'urd_Arab',
    'uzb': 'uzn_Latn',
    'vie': 'vie_Latn',
    'wol': 'wol_Latn',
    'xho': 'xho_Latn',
    'yor': 'yor_Latn',
    'zho_simpl': 'zho_Hans',
    'zho_trad': 'zho_Hant',
    'msa': 'zsm_Latn',
    'zul': 'zul_Latn'
}

### MADLAD language code to language name
MADLAD_to_LANG_NAME = {
    'en': 'English',
    'ru': 'Russian',
    'es': 'Spanish',
    'fr': 'French',
    'de': 'German',
    'it': 'Italian',
    'pt': 'Portuguese',
    'pl': 'Polish',
    'nl': 'Dutch',
    'vi': 'Vietnamese',
    'tr': 'Turkish',
    'sv': 'Swedish',
    'id': 'Indonesian',
    'ro': 'Romanian',
    'cs': 'Czech',
    'zh': 'Mandarin Chinese',
    'hu': 'Hungarian',
    'ja': 'Japanese',
    'th': 'Thai',
    'fi': 'Finnish',
    'fa': 'Persian',
    'uk': 'Ukrainian',
    'da': 'Danish',
    'el': 'Greek',
    'no': 'Norwegian',
    'bg': 'Bulgarian',
    'sk': 'Slovak',
    'ko': 'Korean',
    'ar': 'Arabic',
    'lt': 'Lithuanian',
    'ca': 'Catalan',
    'sl': 'Slovenian',
    'he': 'Hebrew',
    'et': 'Estonian',
    'lv': 'Latvian',
    'hi': 'Hindi',
    'sq': 'Albanian',
    'ms': 'Malay',
    'az': 'Azerbaijani',
    'sr': 'Serbian',
    'ta': 'Tamil',
    'hr': 'Croatian',
    'kk': 'Kazakh',
    'is': 'Icelandic',
    'ml': 'Malayalam',
    'mr': 'Marathi',
    'te': 'Telugu',
    'af': 'Afrikaans',
    'gl': 'Galician',
    'fil': 'Filipino',
    'be': 'Belarusian',
    'mk': 'Macedonian',
    'eu': 'Basque',
    'bn': 'Bengali',
    'ka': 'Georgian',
    'mn': 'Mongolian',
    'bs': 'Bosnian',
    'uz': 'Uzbek',
    'ur': 'Urdu',
    'sw': 'Swahili',
    'yue': 'Cantonese',
    'ne': 'Nepali',
    'kn': 'Kannada',
    'kaa': 'Kara-Kalpak',
    'gu': 'Gujarati',
    'si': 'Sinhala',
    'cy': 'Welsh',
    'eo': 'Esperanto',
    'la': 'Latin',
    'hy': 'Armenian',
    'ky': 'Kyrghyz',
    'tg': 'Tajik',
    'ga': 'Irish',
    'mt': 'Maltese',
    'my': 'Myanmar (Burmese)',
    'km': 'Khmer',
    'tt': 'Tatar',
    'so': 'Somali',
    'ku': 'Kurdish (Kurmanji)',
    'ps': 'Pashto',
    'pa': 'Punjabi',
    'rw': 'Kinyarwanda',
    'lo': 'Lao',
    'ha': 'Hausa',
    'dv': 'Dhivehi',
    'fy': 'W. Frisian',
    'lb': 'Luxembourgish',
    'ckb': 'Kurdish (Sorani)',
    'mg': 'Malagasy',
    'gd': 'Scottish Gaelic',
    'am': 'Amharic',
    'ug': 'Uyghur',
    'ht': 'Haitian Creole',
    'grc': 'Ancient Greek',
    'hmn': 'Hmong',
    'sd': 'Sindhi',
    'jv': 'Javanese',
    'mi': 'Maori',
    'tk': 'Turkmen',
    'ceb': 'Cebuano',
    'yi': 'Yiddish',
    'ba': 'Bashkir',
    'fo': 'Faroese',
    'or': 'Odia (Oriya)',
    'xh': 'Xhosa',
    'su': 'Sundanese',
    'kl': 'Kalaallisut',
    'ny': 'Chichewa',
    'sm': 'Samoan',
    'sn': 'Shona',
    'co': 'Corsican',
    'zu': 'Zulu',
    'ig': 'Igbo',
    'yo': 'Yoruba',
    'pap': 'Papiamento',
    'st': 'Sesotho',
    'haw': 'Hawaiian',
    'as': 'Assamese',
    'oc': 'Occitan',
    'cv': 'Chuvash',
    'lus': 'Mizo',
    'tet': 'Tetum',
    'gsw': 'Swiss German',
    'sah': 'Yakut',
    'br': 'Breton',
    'rm': 'Romansh',
    'sa': 'Sanskrit',
    'bo': 'Tibetan',
    'om': 'Oromo',
    'se': 'N. Sami',
    'ce': 'Chechen',
    'cnh': 'Hakha Chin',
    'ilo': 'Ilocano',
    'hil': 'Hiligaynon',
    'udm': 'Udmurt',
    'os': 'Ossetian',
    'lg': 'Luganda',
    'ti': 'Tigrinya',
    'vec': 'Venetian',
    'ts': 'Tsonga',
    'tyv': 'Tuvinian',
    'kbd': 'Kabardian',
    'ee': 'Ewe',
    'iba': 'Iban',
    'av': 'Avar',
    'kha': 'Khasi',
    'to': 'Tonga (Tonga Islands)',
    'tn': 'Tswana',
    'nso': 'Sepedi',
    'fj': 'Fijian',
    'zza': 'Zaza',
    'ak': 'Twi',
    'ada': 'Adangme',
    'otq': 'Querétaro Otomi',
    'dz': 'Dzongkha',
    'bua': 'Buryat',
    'cfm': 'Falam Chin',
    'ln': 'Lingala',
    'chm': 'Meadow Mari',
    'gn': 'Guarani',
    'krc': 'Karachay-Balkar',
    'wa': 'Walloon',
    'hif': 'Fiji Hindi',
    'yua': 'Yucateco',
    'srn': 'Sranan Tongo',
    'war': 'Waray (Philippines)',
    'rom': 'Romani',
    'bik': 'Central Bikol',
    'pam': 'Pampanga',
    'sg': 'Sango',
    'lu': 'Luba-Katanga',
    'ady': 'Adyghe',
    'kbp': 'Kabiyè',
    'syr': 'Syriac',
    'ltg': 'Latgalian',
    'myv': 'Erzya',
    'iso': 'Isoko',
    'kac': 'Kachin',
    'bho': 'Bhojpuri',
    'ay': 'Aymara',
    'kum': 'Kumyk',
    'qu': 'Quechua',
    'za': 'Zhuang',
    'pag': 'Pangasinan',
    'ngu': 'Guerrero Nahuatl',
    've': 'Venda',
    'pck': 'Paite Chin',
    'zap': 'Zapotec',
    'tyz': 'Tày',
    'hui': 'Huli',
    'bbc': 'Batak Toba',
    'tzo': 'Tzotzil',
    'tiv': 'Tiv',
    'ksd': 'Kuanua',
    'gom': 'Goan Konkani',
    'min': 'Minangkabau',
    'ang': 'Old English',
    'nhe': 'E. Huasteca Nahuatl',
    'bgp': 'E. Baluchi',
    'nzi': 'Nzima',
    'nnb': 'Nande',
    'nv': 'Navajo',
    'zxx': 'Noise',
    'bci': 'Baoulé',
    'kv': 'Komi',
    'new': 'Newari',
    'mps': 'Dadibi',
    'alt': 'S. Altai',
    'meu': 'Motu',
    'bew': 'Betawi',
    'fon': 'Fon',
    'iu': 'Inuktitut',
    'abt': 'Ambulas',
    'mgh': 'Makhuwa-Meetto',
    'mnw': 'Mon',
    'tvl': 'Tuvalu',
    'dov': 'Dombe',
    'tlh': 'Klingon',
    'ho': 'Hiri Motu',
    'kw': 'Cornish',
    'mrj': 'Hill Mari',
    'meo': 'Kedah Malay',
    'crh': 'Crimean Tatar',
    'mbt': 'Matigsalug Manobo',
    'emp': 'N. Emberá',
    'ace': 'Achinese',
    'ium': 'Iu Mien',
    'mam': 'Mam',
    'gym': 'Ngäbere',
    'mai': 'Maithili',
    'crs': 'Seselwa Creole French',
    'pon': 'Pohnpeian',
    'ubu': 'Umbu-Ungu',
    'fip': 'Fipa',
    'quc': "K'iche'",
    'gv': 'Manx',
    'kj': 'Kuanyama',
    'btx': 'Batak Karo',
    'ape': 'Bukiyip',
    'chk': 'Chuukese',
    'rcf': 'Réunion Creole French',
    'shn': 'Shan',
    'tzh': 'Tzeltal',
    'mdf': 'Moksha',
    'ppk': 'Uma',
    'ss': 'Swati',
    'gag': 'Gagauz',
    'cab': 'Garifuna',
    'kri': 'Krio',
    'seh': 'Sena',
    'ibb': 'Ibibio',
    'tbz': 'Ditammari',
    'bru': 'E. Bru',
    'enq': 'Enga',
    'ach': 'Acoli',
    'cuk': 'San Blas Kuna',
    'kmb': 'Kimbundu',
    'wo': 'Wolof',
    'kek': 'Kekchí',
    'qub': 'Huallaga Huánuco Quechua',
    'tab': 'Tabassaran',
    'bts': 'Batak Simalungun',
    'kos': 'Kosraean',
    'rwo': 'Rawa',
    'cak': 'Kaqchikel',
    'tuc': 'Mutu',
    'bum': 'Bulu',
    'cjk': 'Chokwe',
    'gil': 'Gilbertese',
    'stq': 'Saterfriesisch',
    'tsg': 'Tausug',
    'quh': 'S. Bolivian Quechua',
    'mak': 'Makasar',
    'arn': 'Mapudungun',
    'ban': 'Balinese',
    'jiv': 'Shuar',
    'sja': 'Epena',
    'yap': 'Yapese',
    'tcy': 'Tulu',
    'toj': 'Tojolabal',
    'twu': 'Termanu',
    'xal': 'Kalmyk',
    'amu': 'Guerrero Amuzgo',
    'rmc': 'Carpathian Romani',
    'hus': 'Huastec',
    'nia': 'Nias',
    'kjh': 'Khakas',
    'bm': 'Bambara',
    'guh': 'Guahibo',
    'mas': 'Masai',
    'acf': 'St Lucian Creole French',
    'dtp': 'Kadazan Dusun',
    'ksw': "S'gaw Karen",
    'bzj': 'Belize Kriol English',
    'din': 'Dinka',
    'zne': 'Zande',
    'mad': 'Madurese',
    'msi': 'Sabah Malay',
    'mag': 'Magahi',
    'mkn': 'Kupang Malay',
    'kg': 'Kongo',
    'lhu': 'Lahu',
    'ch': 'Chamorro',
    'qvi': 'Imbabura H. Quichua',
    'mh': 'Marshallese',
    'djk': 'E. Maroon Creole',
    'sus': 'Susu',
    'mfe': 'Morisien',
    'srm': 'Saramaccan',
    'dyu': 'Dyula',
    'ctu': 'Chol',
    'gui': 'E. Bolivian Guaraní',
    'pau': 'Palauan',
    'inb': 'Inga',
    'bi': 'Bislama',
    'mni': 'Meiteilon (Manipuri)',
    'guc': 'Wayuu',
    'jam': 'Jamaican Creole English',
    'wal': 'Wolaytta',
    'jac': "Popti'",
    'bas': 'Basa (Cameroon)',
    'gor': 'Gorontalo',
    'skr': 'Saraiki',
    'nyu': 'Nyungwe',
    'noa': 'Woun Meu',
    'sda': "Toraja-Sa'dan",
    'gub': 'Guajajára',
    'nog': 'Nogai',
    'cni': 'Asháninka',
    'teo': 'Teso',
    'tdx': 'Tandroy-Mahafaly Malagasy',
    'sxn': 'Sangir',
    'rki': 'Rakhine',
    'nr': 'South Ndebele',
    'frp': 'Arpitan',
    'alz': 'Alur',
    'taj': 'E. Tamang',
    'lrc': 'N. Luri',
    'cce': 'Chopi',
    'rn': 'Rundi',
    'jvn': 'Caribbean Javanese',
    'hvn': 'Sabu',
    'nij': 'Ngaju',
    'dwr': 'Dawro',
    'izz': 'Izii',
    'msm': 'Agusan Manobo',
    'bus': 'Bokobaru',
    'ktu': 'Kituba (DRC)',
    'chr': 'Cherokee',
    'maz': 'Central Mazahua',
    'tzj': "Tz'utujil",
    'suz': 'Sunwar',
    'knj': 'W. Kanjobal',
    'bim': 'Bimoba',
    'gvl': 'Gulay',
    'bqc': 'Boko (Benin)',
    'tca': 'Ticuna',
    'pis': 'Pijin',
    'prk': 'Parauk',
    'laj': 'Lango (Uganda)',
    'mel': 'Central Melanau',
    'qxr': 'Cañar H. Quichua',
    'niq': 'Nandi',
    'ahk': 'Akha',
    'shp': 'Shipibo-Conibo',
    'hne': 'Chhattisgarhi',
    'spp': 'Supyire Senoufo',
    'koi': 'Komi-Permyak',
    'krj': 'Kinaray-A',
    'quf': 'Lambayeque Quechua',
    'luz': 'S. Luri',
    'agr': 'Aguaruna',
    'tsc': 'Tswa',
    'mqy': 'Manggarai',
    'gof': 'Gofa',
    'gbm': 'Garhwali',
    'miq': 'Mískito',
    'dje': 'Zarma',
    'awa': 'Awadhi',
    'bjj': 'Kanauji',
    'qvz': 'N. Pastaza Quichua',
    'sjp': 'Surjapuri',
    'tll': 'Tetela',
    'raj': 'Rajasthani',
    'kjg': 'Khmu',
    'bgz': 'Banggai',
    'quy': 'Ayacucho Quechua',
    'cbk': 'Chavacano',
    'akb': 'Batak Angkola',
    'oj': 'Ojibwa',
    'ify': 'Keley-I Kallahan',
    'mey': 'Hassaniyya',
    'ks': 'Kashmiri',
    'cac': 'Chuj',
    'brx': 'Bodo (India)',
    'qup': 'S. Pastaza Quechua',
    'syl': 'Sylheti',
    'jax': 'Jambi Malay',
    'ff': 'Fulfulde',
    'ber': 'Tamazight  (Tfng)',
    'tks': 'Takestani',
    'trp': 'Kok Borok',
    'mrw': 'Maranao',
    'adh': 'Adhola',
    'smt': 'Simte',
    'srr': 'Serer',
    'ffm': 'Maasina Fulfulde',
    'qvc': 'Cajamarca Quechua',
    'mtr': 'Mewari',
    'ann': 'Obolo',
    'kaa-Latn': 'Kara-Kalpak (Latn)',
    'aa': 'Afar',
    'noe': 'Nimadi',
    'nut': 'Nung (Viet Nam)',
    'gyn': 'Guyanese Creole English',
    'kwi': 'Awa-Cuaiquer',
    'xmm': 'Manado Malay',
    'msb': 'Masbatenyo',
    'el-Latn': 'Greek (Latn)',
    'doi': 'Dogri',
    'mtq': 'Muong',
    'dln': 'Darlong',
    'cyo': 'Cuyonon',
    'abs': 'Ambonese Malay',
    'hi-Latn': 'Hindi (Latn)',
    'shu': 'Chadian Arabic',
    'yaq': 'Yaqui',
    'nyo': 'Nyoro',
    'cgg': 'Chiga',
    'sxu': 'Upper Saxon',
    'mdh': 'Maguindanaon',
    'rwr': 'Marwari (India)',
    'xnr': 'Kangri',
    'mui': 'Musi',
    'skg': 'Sakalava Malagasy',
    'ymm': 'Maay',
    'ctd-Latn': 'Tedim Chin (Latn)',
    'ayl': 'Libyan Arabic',
    'kjb': "Q'anjob'al",
    'rhg-Latn': 'Rohingya (Latn)',
    'bmm': 'N. Betsimisaraka Malagasy',
    'azg': 'San Pedro Amuzgos Amuzgo',
    'kfy': 'Kumaoni',
    'bto': 'Rinconada Bikol',
    'ja-Latn': 'Japanese (Latn)',
    'mfb': 'Bangka',
    'ru-Latn': 'Russian (Latn)',
    'tuf': 'Central Tunebo',
    'ctg': 'Chittagonian',
    'pmy': 'Papuan Malay',
    'xog': 'Soga',
    'te-Latn': 'Telugu (Latn)',
    'ber-Latn': 'Tamazight (Latn)',
    'mdy': 'Male (Ethiopia)',
    'az-RU': 'Azerbaijani (Russia)',
    'ta-Latn': 'Tamil (Latn)',
    'clu': 'Caluyanun',
    'tly-IR': 'Talysh (Iran)',
    'ng': 'Ndonga',
    'bzc': 'S. Betsimisaraka Malagasy',
    'nan-Latn-TW': 'Min Nan Chinese (Latn)',
    'ml-Latn': 'Malayalam (Latn)',
    'max': 'North Moluccan Malay',
    'ar-Latn': 'Arabic (Latn)',
    'gom-Latn': 'Goan Konkani (Latn)',
    'bg-Latn': 'Bulgarian (Latn)',
    'nd': 'North Ndebele',
    'zyj': 'Youjiang Zhuang',
    'rkt': 'Rangpuri',
    'kn-Latn': 'Kannada (Latn)',
    'zh-Latn': 'Chinese (Latn)',
    'el-CY': 'Greek (Cypress)',
    'dcc': 'Deccan',
    'bgc': 'Haryanvi',
    'mwr': 'Marwari',
    'vkt': 'Tenggarong Kutai Malay',
    'cr-Latn': 'Cree (Latn)',
    'apd-SD': 'Sudanese Arabic',
    'trw': 'Torwali',
    'bn-Latn': 'Bengali (Latn)',
    'gu-Latn': 'Gujarati (Latn)',
    'gju': 'Gujari',
    'sat-Latn': 'Santali (Latn)',
    'ndc-ZW': 'Ndau',
    'kmz-Latn': 'Khorasani Turkish (Latn)',
    'mr-Latn': 'Marathi (Latn)',
    'en-Cyrl': 'English  (Cyrl)',
    'en-Arab': 'English  (Arab)',
    'ms-Arab': 'Malay (Jawi)',
    'ms-Arab-BN': 'Malay (Jawi, Brunei)',
    'bhb-Gujr': 'Bhili',
    'pa-Arab': 'Lahnda Punjabi (PK)',
    'syl-Latn': 'Sylheti (Latn)',
    'ff-Adlm': 'Fulah',
    'pcm': 'Nigerian Pidgin',
    'tpi': 'Tok Pisin',
    'gjk': 'Kachi Koli',
    'bfy': 'Bagheli',
    'sgj': 'Surgujia',
    'nyn': 'Nyankole'
}

### Language name to MADLAD language code
LANG_NAME_to_MADLAD = {
    'English': 'en',
    'Russian': 'ru',
    'Spanish': 'es',
    'French': 'fr',
    'German': 'de',
    'Italian': 'it',
    'Portuguese': 'pt',
    'Polish': 'pl',
    'Dutch': 'nl',
    'Vietnamese': 'vi',
    'Turkish': 'tr',
    'Swedish': 'sv',
    'Indonesian': 'id',
    'Romanian': 'ro',
    'Czech': 'cs',
    'Mandarin Chinese': 'zh',
    'Hungarian': 'hu',
    'Japanese': 'ja',
    'Thai': 'th',
    'Finnish': 'fi',
    'Persian': 'fa',
    'Ukrainian': 'uk',
    'Danish': 'da',
    'Greek': 'el',
    'Norwegian': 'no',
    'Bulgarian': 'bg',
    'Slovak': 'sk',
    'Korean': 'ko',
    'Arabic': 'ar',
    'Lithuanian': 'lt',
    'Catalan': 'ca',
    'Slovenian': 'sl',
    'Hebrew': 'he',
    'Estonian': 'et',
    'Latvian': 'lv',
    'Hindi': 'hi',
    'Albanian': 'sq',
    'Malay': 'ms',
    'Azerbaijani': 'az',
    'Serbian': 'sr',
    'Tamil': 'ta',
    'Croatian': 'hr',
    'Kazakh': 'kk',
    'Icelandic': 'is',
    'Malayalam': 'ml',
    'Marathi': 'mr',
    'Telugu': 'te',
    'Afrikaans': 'af',
    'Galician': 'gl',
    'Filipino': 'fil',
    'Belarusian': 'be',
    'Macedonian': 'mk',
    'Basque': 'eu',
    'Bengali': 'bn',
    'Georgian': 'ka',
    'Mongolian': 'mn',
    'Bosnian': 'bs',
    'Uzbek': 'uz',
    'Urdu': 'ur',
    'Swahili': 'sw',
    'Cantonese': 'yue',
    'Nepali': 'ne',
    'Kannada': 'kn',
    'Kara-Kalpak': 'kaa',
    'Gujarati': 'gu',
    'Sinhala': 'si',
    'Welsh': 'cy',
    'Esperanto': 'eo',
    'Latin': 'la',
    'Armenian': 'hy',
    'Kyrghyz': 'ky',
    'Tajik': 'tg',
    'Irish': 'ga',
    'Maltese': 'mt',
    'Myanmar (Burmese)': 'my',
    'Khmer': 'km',
    'Tatar': 'tt',
    'Somali': 'so',
    'Kurdish (Kurmanji)': 'ku',
    'Pashto': 'ps',
    'Punjabi': 'pa',
    'Kinyarwanda': 'rw',
    'Lao': 'lo',
    'Hausa': 'ha',
    'Dhivehi': 'dv',
    'W. Frisian': 'fy',
    'Luxembourgish': 'lb',
    'Kurdish (Sorani)': 'ckb',
    'Malagasy': 'mg',
    'Scottish Gaelic': 'gd',
    'Amharic': 'am',
    'Uyghur': 'ug',
    'Haitian Creole': 'ht',
    'Ancient Greek': 'grc',
    'Hmong': 'hmn',
    'Sindhi': 'sd',
    'Javanese': 'jv',
    'Maori': 'mi',
    'Turkmen': 'tk',
    'Cebuano': 'ceb',
    'Yiddish': 'yi',
    'Bashkir': 'ba',
    'Faroese': 'fo',
    'Odia (Oriya)': 'or',
    'Xhosa': 'xh',
    'Sundanese': 'su',
    'Kalaallisut': 'kl',
    'Chichewa': 'ny',
    'Samoan': 'sm',
    'Shona': 'sn',
    'Corsican': 'co',
    'Zulu': 'zu',
    'Igbo': 'ig',
    'Yoruba': 'yo',
    'Papiamento': 'pap',
    'Sesotho': 'st',
    'Hawaiian': 'haw',
    'Assamese': 'as',
    'Occitan': 'oc',
    'Chuvash': 'cv',
    'Mizo': 'lus',
    'Tetum': 'tet',
    'Swiss German': 'gsw',
    'Yakut': 'sah',
    'Breton': 'br',
    'Romansh': 'rm',
    'Sanskrit': 'sa',
    'Tibetan': 'bo',
    'Oromo': 'om',
    'N. Sami': 'se',
    'Chechen': 'ce',
    'Hakha Chin': 'cnh',
    'Ilocano': 'ilo',
    'Hiligaynon': 'hil',
    'Udmurt': 'udm',
    'Ossetian': 'os',
    'Luganda': 'lg',
    'Tigrinya': 'ti',
    'Venetian': 'vec',
    'Tsonga': 'ts',
    'Tuvinian': 'tyv',
    'Kabardian': 'kbd',
    'Ewe': 'ee',
    'Iban': 'iba',
    'Avar': 'av',
    'Khasi': 'kha',
    'Tonga (Tonga Islands)': 'to',
    'Tswana': 'tn',
    'Sepedi': 'nso',
    'Fijian': 'fj',
    'Zaza': 'zza',
    'Twi': 'ak',
    'Adangme': 'ada',
    'Querétaro Otomi': 'otq',
    'Dzongkha': 'dz',
    'Buryat': 'bua',
    'Falam Chin': 'cfm',
    'Lingala': 'ln',
    'Meadow Mari': 'chm',
    'Guarani': 'gn',
    'Karachay-Balkar': 'krc',
    'Walloon': 'wa',
    'Fiji Hindi': 'hif',
    'Yucateco': 'yua',
    'Sranan Tongo': 'srn',
    'Waray (Philippines)': 'war',
    'Romani': 'rom',
    'Central Bikol': 'bik',
    'Pampanga': 'pam',
    'Sango': 'sg',
    'Luba-Katanga': 'lu',
    'Adyghe': 'ady',
    'Kabiyè': 'kbp',
    'Syriac': 'syr',
    'Latgalian': 'ltg',
    'Erzya': 'myv',
    'Isoko': 'iso',
    'Kachin': 'kac',
    'Bhojpuri': 'bho',
    'Aymara': 'ay',
    'Kumyk': 'kum',
    'Quechua': 'qu',
    'Zhuang': 'za',
    'Pangasinan': 'pag',
    'Guerrero Nahuatl': 'ngu',
    'Venda': 've',
    'Paite Chin': 'pck',
    'Zapotec': 'zap',
    'Tày': 'tyz',
    'Huli': 'hui',
    'Batak Toba': 'bbc',
    'Tzotzil': 'tzo',
    'Tiv': 'tiv',
    'Kuanua': 'ksd',
    'Goan Konkani': 'gom',
    'Minangkabau': 'min',
    'Old English': 'ang',
    'E. Huasteca Nahuatl': 'nhe',
    'E. Baluchi': 'bgp',
    'Nzima': 'nzi',
    'Nande': 'nnb',
    'Navajo': 'nv',
    'Noise': 'zxx',
    'Baoulé': 'bci',
    'Komi': 'kv',
    'Newari': 'new',
    'Dadibi': 'mps',
    'S. Altai': 'alt',
    'Motu': 'meu',
    'Betawi': 'bew',
    'Fon': 'fon',
    'Inuktitut': 'iu',
    'Ambulas': 'abt',
    'Makhuwa-Meetto': 'mgh',
    'Mon': 'mnw',
    'Tuvalu': 'tvl',
    'Dombe': 'dov',
    'Klingon': 'tlh',
    'Hiri Motu': 'ho',
    'Cornish': 'kw',
    'Hill Mari': 'mrj',
    'Kedah Malay': 'meo',
    'Crimean Tatar': 'crh',
    'Matigsalug Manobo': 'mbt',
    'N. Emberá': 'emp',
    'Achinese': 'ace',
    'Iu Mien': 'ium',
    'Mam': 'mam',
    'Ngäbere': 'gym',
    'Maithili': 'mai',
    'Seselwa Creole French': 'crs',
    'Pohnpeian': 'pon',
    'Umbu-Ungu': 'ubu',
    'Fipa': 'fip',
    "K'iche'": 'quc',
    'Manx': 'gv',
    'Kuanyama': 'kj',
    'Batak Karo': 'btx',
    'Bukiyip': 'ape',
    'Chuukese': 'chk',
    'Réunion Creole French': 'rcf',
    'Shan': 'shn',
    'Tzeltal': 'tzh',
    'Moksha': 'mdf',
    'Uma': 'ppk',
    'Swati': 'ss',
    'Gagauz': 'gag',
    'Garifuna': 'cab',
    'Krio': 'kri',
    'Sena': 'seh',
    'Ibibio': 'ibb',
    'Ditammari': 'tbz',
    'E. Bru': 'bru',
    'Enga': 'enq',
    'Acoli': 'ach',
    'San Blas Kuna': 'cuk',
    'Kimbundu': 'kmb',
    'Wolof': 'wo',
    'Kekchí': 'kek',
    'Huallaga Huánuco Quechua': 'qub',
    'Tabassaran': 'tab',
    'Batak Simalungun': 'bts',
    'Kosraean': 'kos',
    'Rawa': 'rwo',
    'Kaqchikel': 'cak',
    'Mutu': 'tuc',
    'Bulu': 'bum',
    'Chokwe': 'cjk',
    'Gilbertese': 'gil',
    'Saterfriesisch': 'stq',
    'Tausug': 'tsg',
    'S. Bolivian Quechua': 'quh',
    'Makasar': 'mak',
    'Mapudungun': 'arn',
    'Balinese': 'ban',
    'Shuar': 'jiv',
    'Epena': 'sja',
    'Yapese': 'yap',
    'Tulu': 'tcy',
    'Tojolabal': 'toj',
    'Termanu': 'twu',
    'Kalmyk': 'xal',
    'Guerrero Amuzgo': 'amu',
    'Carpathian Romani': 'rmc',
    'Huastec': 'hus',
    'Nias': 'nia',
    'Khakas': 'kjh',
    'Bambara': 'bm',
    'Guahibo': 'guh',
    'Masai': 'mas',
    'St Lucian Creole French': 'acf',
    'Kadazan Dusun': 'dtp',
    "S'gaw Karen": 'ksw',
    'Belize Kriol English': 'bzj',
    'Dinka': 'din',
    'Zande': 'zne',
    'Madurese': 'mad',
    'Sabah Malay': 'msi',
    'Magahi': 'mag',
    'Kupang Malay': 'mkn',
    'Kongo': 'kg',
    'Lahu': 'lhu',
    'Chamorro': 'ch',
    'Imbabura H. Quichua': 'qvi',
    'Marshallese': 'mh',
    'E. Maroon Creole': 'djk',
    'Susu': 'sus',
    'Morisien': 'mfe',
    'Saramaccan': 'srm',
    'Dyula': 'dyu',
    'Chol': 'ctu',
    'E. Bolivian Guaraní': 'gui',
    'Palauan': 'pau',
    'Inga': 'inb',
    'Bislama': 'bi',
    'Meiteilon (Manipuri)': 'mni',
    'Wayuu': 'guc',
    'Jamaican Creole English': 'jam',
    'Wolaytta': 'wal',
    "Popti'": 'jac',
    'Basa (Cameroon)': 'bas',
    'Gorontalo': 'gor',
    'Saraiki': 'skr',
    'Nyungwe': 'nyu',
    'Woun Meu': 'noa',
    "Toraja-Sa'dan": 'sda',
    'Guajajára': 'gub',
    'Nogai': 'nog',
    'Asháninka': 'cni',
    'Teso': 'teo',
    'Tandroy-Mahafaly Malagasy': 'tdx',
    'Sangir': 'sxn',
    'Rakhine': 'rki',
    'South Ndebele': 'nr',
    'Arpitan': 'frp',
    'Alur': 'alz',
    'E. Tamang': 'taj',
    'N. Luri': 'lrc',
    'Chopi': 'cce',
    'Rundi': 'rn',
    'Caribbean Javanese': 'jvn',
    'Sabu': 'hvn',
    'Ngaju': 'nij',
    'Dawro': 'dwr',
    'Izii': 'izz',
    'Agusan Manobo': 'msm',
    'Bokobaru': 'bus',
    'Kituba (DRC)': 'ktu',
    'Cherokee': 'chr',
    'Central Mazahua': 'maz',
    "Tz'utujil": 'tzj',
    'Sunwar': 'suz',
    'W. Kanjobal': 'knj',
    'Bimoba': 'bim',
    'Gulay': 'gvl',
    'Boko (Benin)': 'bqc',
    'Ticuna': 'tca',
    'Pijin': 'pis',
    'Parauk': 'prk',
    'Lango (Uganda)': 'laj',
    'Central Melanau': 'mel',
    'Cañar H. Quichua': 'qxr',
    'Nandi': 'niq',
    'Akha': 'ahk',
    'Shipibo-Conibo': 'shp',
    'Chhattisgarhi': 'hne',
    'Supyire Senoufo': 'spp',
    'Komi-Permyak': 'koi',
    'Kinaray-A': 'krj',
    'Lambayeque Quechua': 'quf',
    'S. Luri': 'luz',
    'Aguaruna': 'agr',
    'Tswa': 'tsc',
    'Manggarai': 'mqy',
    'Gofa': 'gof',
    'Garhwali': 'gbm',
    'Mískito': 'miq',
    'Zarma': 'dje',
    'Awadhi': 'awa',
    'Kanauji': 'bjj',
    'N. Pastaza Quichua': 'qvz',
    'Surjapuri': 'sjp',
    'Tetela': 'tll',
    'Rajasthani': 'raj',
    'Khmu': 'kjg',
    'Banggai': 'bgz',
    'Ayacucho Quechua': 'quy',
    'Chavacano': 'cbk',
    'Batak Angkola': 'akb',
    'Ojibwa': 'oj',
    'Keley-I Kallahan': 'ify',
    'Hassaniyya': 'mey',
    'Kashmiri': 'ks',
    'Chuj': 'cac',
    'Bodo (India)': 'brx',
    'S. Pastaza Quechua': 'qup',
    'Sylheti': 'syl',
    'Jambi Malay': 'jax',
    'Fulfulde': 'ff',
    'Tamazight  (Tfng)': 'ber',
    'Takestani': 'tks',
    'Kok Borok': 'trp',
    'Maranao': 'mrw',
    'Adhola': 'adh',
    'Simte': 'smt',
    'Serer': 'srr',
    'Maasina Fulfulde': 'ffm',
    'Cajamarca Quechua': 'qvc',
    'Mewari': 'mtr',
    'Obolo': 'ann',
    'Kara-Kalpak (Latn)': 'kaa-Latn',
    'Afar': 'aa',
    'Nimadi': 'noe',
    'Nung (Viet Nam)': 'nut',
    'Guyanese Creole English': 'gyn',
    'Awa-Cuaiquer': 'kwi',
    'Manado Malay': 'xmm',
    'Masbatenyo': 'msb',
    'Greek (Latn)': 'el-Latn',
    'Dogri': 'doi',
    'Muong': 'mtq',
    'Darlong': 'dln',
    'Cuyonon': 'cyo',
    'Ambonese Malay': 'abs',
    'Hindi (Latn)': 'hi-Latn',
    'Chadian Arabic': 'shu',
    'Yaqui': 'yaq',
    'Nyoro': 'nyo',
    'Chiga': 'cgg',
    'Upper Saxon': 'sxu',
    'Maguindanaon': 'mdh',
    'Marwari (India)': 'rwr',
    'Kangri': 'xnr',
    'Musi': 'mui',
    'Sakalava Malagasy': 'skg',
    'Maay': 'ymm',
    'Tedim Chin (Latn)': 'ctd-Latn',
    'Libyan Arabic': 'ayl',
    "Q'anjob'al": 'kjb',
    'Rohingya (Latn)': 'rhg-Latn',
    'N. Betsimisaraka Malagasy': 'bmm',
    'San Pedro Amuzgos Amuzgo': 'azg',
    'Kumaoni': 'kfy',
    'Rinconada Bikol': 'bto',
    'Japanese (Latn)': 'ja-Latn',
    'Bangka': 'mfb',
    'Russian (Latn)': 'ru-Latn',
    'Central Tunebo': 'tuf',
    'Chittagonian': 'ctg',
    'Papuan Malay': 'pmy',
    'Soga': 'xog',
    'Telugu (Latn)': 'te-Latn',
    'Tamazight (Latn)': 'ber-Latn',
    'Male (Ethiopia)': 'mdy',
    'Azerbaijani (Russia)': 'az-RU',
    'Tamil (Latn)': 'ta-Latn',
    'Caluyanun': 'clu',
    'Talysh (Iran)': 'tly-IR',
    'Ndonga': 'ng',
    'S. Betsimisaraka Malagasy': 'bzc',
    'Min Nan Chinese (Latn)': 'nan-Latn-TW',
    'Malayalam (Latn)': 'ml-Latn',
    'North Moluccan Malay': 'max',
    'Arabic (Latn)': 'ar-Latn',
    'Goan Konkani (Latn)': 'gom-Latn',
    'Bulgarian (Latn)': 'bg-Latn',
    'North Ndebele': 'nd',
    'Youjiang Zhuang': 'zyj',
    'Rangpuri': 'rkt',
    'Kannada (Latn)': 'kn-Latn',
    'Chinese (Latn)': 'zh-Latn',
    'Greek (Cypress)': 'el-CY',
    'Deccan': 'dcc',
    'Haryanvi': 'bgc',
    'Marwari': 'mwr',
    'Tenggarong Kutai Malay': 'vkt',
    'Cree (Latn)': 'cr-Latn',
    'Sudanese Arabic': 'apd-SD',
    'Torwali': 'trw',
    'Bengali (Latn)': 'bn-Latn',
    'Gujarati (Latn)': 'gu-Latn',
    'Gujari': 'gju',
    'Santali (Latn)': 'sat-Latn',
    'Ndau': 'ndc-ZW',
    'Khorasani Turkish (Latn)': 'kmz-Latn',
    'Marathi (Latn)': 'mr-Latn',
    'English  (Cyrl)': 'en-Cyrl',
    'English  (Arab)': 'en-Arab',
    'Malay (Jawi)': 'ms-Arab',
    'Malay (Jawi, Brunei)': 'ms-Arab-BN',
    'Bhili': 'bhb-Gujr',
    'Lahnda Punjabi (PK)': 'pa-Arab',
    'Sylheti (Latn)': 'syl-Latn',
    'Fulah': 'ff-Adlm',
    'Nigerian Pidgin': 'pcm',
    'Tok Pisin': 'tpi',
    'Kachi Koli': 'gjk',
    'Bagheli': 'bfy',
    'Surgujia': 'sgj',
    'Nyankole': 'nyn'
}

##### -------  Culturalx --------########
LANG_NAME_to_CULTURAX = {
    "Afrikaans": "af",
    "Albanian": "sq",
    "Amharic": "am",
    "Arabic": "ar",
    "Aragonese": "an",
    "Armenian": "hy",
    "Assamese": "as",
    "Asturian": "ast",
    "Avaric": "av",
    "Azerbaijani": "az",
    "Bangla": "bn",
    "Bashkir": "ba",
    "Basque": "eu",
    "Bavarian": "bar",
    "Belarusian": "be",
    "Bihari languages": "bh",
    "Bishnupriya": "bpy",
    "Bosnian": "bs",
    "Breton": "br",
    "Bulgarian": "bg",
    "Burmese": "my",
    "Cantonese": "yue",
    "Catalan": "ca",
    "Cebuano": "ceb",
    "Central Bikol": "bcl",
    "Central Kurdish": "ckb",
    "Chavacano": "cbk",
    "Chechen": "ce",
    "Chinese": "zh",
    "Chuvash": "cv",
    "Cornish": "kw",
    "Croatian": "hr",
    "Czech": "cs",
    "Danish": "da",
    "Divehi": "dv",
    "Dutch": "nl",
    "Eastern Mari": "mhr",
    "Egyptian Arabic": "arz",
    "Emiliano-Romagnol": "eml",
    "English": "en",
    "Erzya": "myv",
    "Esperanto": "eo",
    "Estonian": "et",
    "Filipino": "tl",
    "Finnish": "fi",
    "French": "fr",
    "Galician": "gl",
    "Georgian": "ka",
    "German": "de",
    "Goan Konkani": "gom",
    "Greek": "el",
    "Guarani": "gn",
    "Gujarati": "gu",
    "Haitian Creole": "ht",
    "Hebrew": "he",
    "Hindi": "hi",
    "Hungarian": "hu",
    "Icelandic": "is",
    "Ido": "io",
    "Iloko": "ilo",
    "Indonesian": "id",
    "Interlingua": "ia",
    "Interlingue": "ie",
    "Irish": "ga",
    "Italian": "it",
    "Japanese": "ja",
    "Javanese": "jv",
    "Kalmyk": "xal",
    "Kannada": "kn",
    "Karachay-Balkar": "krc",
    "Kazakh": "kk",
    "Khmer": "km",
    "Komi": "kv",
    "Korean": "ko",
    "Kurdish": "ku",
    "Kyrgyz": "ky",
    "Lao": "lo",
    "Latin": "la",
    "Latvian": "lv",
    "Lezghian": "lez",
    "Limburgish": "li",
    "Lithuanian": "lt",
    "Lojban": "jbo",
    "Lombard": "lmo",
    "Low German": "nds",
    "Lower Sorbian": "dsb",
    "Luxembourgish": "lb",
    "Macedonian": "mk",
    "Maithili": "mai",
    "Malagasy": "mg",
    "Malay": "ms",
    "Malayalam": "ml",
    "Maltese": "mt",
    "Marathi": "mr",
    "Mazanderani": "mzn",
    "Minangkabau": "min",
    "Mingrelian": "xmf",
    "Mirandese": "mwl",
    "Mongolian": "mn",
    "Nahuatl languages": "nah",
    "Neapolitan": "nap",
    "Nepali": "ne",
    "Newari": "new",
    "Northern Frisian": "frr",
    "Northern Luri": "lrc",
    "Norwegian": "no",
    "Norwegian Nynorsk": "nn",
    "Occitan": "oc",
    "Odia": "or",
    "Ossetic": "os",
    "Pampanga": "pam",
    "Pashto": "ps",
    "Persian": "fa",
    "Piedmontese": "pms",
    "Polish": "pl",
    "Portuguese": "pt",
    "Punjabi": "pa",
    "Quechua": "qu",
    "Romanian": "ro",
    "Romansh": "rm",
    "Russia Buriat": "bxr",
    "Russian": "ru",
    "Rusyn": "rue",
    "Sakha": "sah",
    "Sanskrit": "sa",
    "Scottish Gaelic": "gd",
    "Serbian": "sr",
    "Serbian (Latin)": "sh",
    "Sicilian": "scn",
    "Sindhi": "sd",
    "Sinhala": "si",
    "Slovak": "sk",
    "Slovenian": "sl",
    "Somali": "so",
    "South Azerbaijani": "azb",
    "Spanish": "es",
    "Sundanese": "su",
    "Swahili": "sw",
    "Swedish": "sv",
    "Swiss German": "als",
    "Tajik": "tg",
    "Tamil": "ta",
    "Tatar": "tt",
    "Telugu": "te",
    "Thai": "th",
    "Tibetan": "bo",
    "Turkish": "tr",
    "Turkmen": "tk",
    "Tuvinian": "tyv",
    "Ukrainian": "uk",
    "Upper Sorbian": "hsb",
    "Urdu": "ur",
    "Uyghur": "ug",
    "Uzbek": "uz",
    "Venetian": "vec",
    "Vietnamese": "vi",
    "Volapuk": "vo",
    "Walloon": "wa",
    "Waray": "war",
    "Welsh": "cy",
    "West Flemish": "vls",
    "Western Frisian": "fy",
    "Western Mari": "mrj",
    "Western Panjabi": "pnb",
    "Wu Chinese": "wuu",
    "Yiddish": "yi",
    "Yoruba": "yo"
}

# CULTURAX_to_LANG_NAME = {v: k for k,v in LANG_NAME_to_CULTURAX.items()}
CULTURAX_to_LANG_NAME = {
    'af': 'Afrikaans',
    'sq': 'Albanian',
    'am': 'Amharic',
    'ar': 'Arabic',
    'an': 'Aragonese',
    'hy': 'Armenian',
    'as': 'Assamese',
    'ast': 'Asturian',
    'av': 'Avaric',
    'az': 'Azerbaijani',
    'bn': 'Bangla',
    'ba': 'Bashkir',
    'eu': 'Basque',
    'bar': 'Bavarian',
    'be': 'Belarusian',
    'bh': 'Bihari languages',
    'bpy': 'Bishnupriya',
    'bs': 'Bosnian',
    'br': 'Breton',
    'bg': 'Bulgarian',
    'my': 'Burmese',
    'yue': 'Cantonese',
    'ca': 'Catalan',
    'ceb': 'Cebuano',
    'bcl': 'Central Bikol',
    'ckb': 'Central Kurdish',
    'cbk': 'Chavacano',
    'ce': 'Chechen',
    'zh': 'Chinese',
    'cv': 'Chuvash',
    'kw': 'Cornish',
    'hr': 'Croatian',
    'cs': 'Czech',
    'da': 'Danish',
    'dv': 'Divehi',
    'nl': 'Dutch',
    'mhr': 'Eastern Mari',
    'arz': 'Egyptian Arabic',
    'eml': 'Emiliano-Romagnol',
    'en': 'English',
    'myv': 'Erzya',
    'eo': 'Esperanto',
    'et': 'Estonian',
    'tl': 'Filipino',
    'fi': 'Finnish',
    'fr': 'French',
    'gl': 'Galician',
    'ka': 'Georgian',
    'de': 'German',
    'gom': 'Goan Konkani',
    'el': 'Greek',
    'gn': 'Guarani',
    'gu': 'Gujarati',
    'ht': 'Haitian Creole',
    'he': 'Hebrew',
    'hi': 'Hindi',
    'hu': 'Hungarian',
    'is': 'Icelandic',
    'io': 'Ido',
    'ilo': 'Iloko',
    'id': 'Indonesian',
    'ia': 'Interlingua',
    'ie': 'Interlingue',
    'ga': 'Irish',
    'it': 'Italian',
    'ja': 'Japanese',
    'jv': 'Javanese',
    'xal': 'Kalmyk',
    'kn': 'Kannada',
    'krc': 'Karachay-Balkar',
    'kk': 'Kazakh',
    'km': 'Khmer',
    'kv': 'Komi',
    'ko': 'Korean',
    'ku': 'Kurdish',
    'ky': 'Kyrgyz',
    'lo': 'Lao',
    'la': 'Latin',
    'lv': 'Latvian',
    'lez': 'Lezghian',
    'li': 'Limburgish',
    'lt': 'Lithuanian',
    'jbo': 'Lojban',
    'lmo': 'Lombard',
    'nds': 'Low German',
    'dsb': 'Lower Sorbian',
    'lb': 'Luxembourgish',
    'mk': 'Macedonian',
    'mai': 'Maithili',
    'mg': 'Malagasy',
    'ms': 'Malay',
    'ml': 'Malayalam',
    'mt': 'Maltese',
    'mr': 'Marathi',
    'mzn': 'Mazanderani',
    'min': 'Minangkabau',
    'xmf': 'Mingrelian',
    'mwl': 'Mirandese',
    'mn': 'Mongolian',
    'nah': 'Nahuatl languages',
    'nap': 'Neapolitan',
    'ne': 'Nepali',
    'new': 'Newari',
    'frr': 'Northern Frisian',
    'lrc': 'Northern Luri',
    'no': 'Norwegian',
    'nn': 'Norwegian Nynorsk',
    'oc': 'Occitan',
    'or': 'Odia',
    'os': 'Ossetic',
    'pam': 'Pampanga',
    'ps': 'Pashto',
    'fa': 'Persian',
    'pms': 'Piedmontese',
    'pl': 'Polish',
    'pt': 'Portuguese',
    'pa': 'Punjabi',
    'qu': 'Quechua',
    'ro': 'Romanian',
    'rm': 'Romansh',
    'bxr': 'Russia Buriat',
    'ru': 'Russian',
    'rue': 'Rusyn',
    'sah': 'Sakha',
    'sa': 'Sanskrit',
    'gd': 'Scottish Gaelic',
    'sr': 'Serbian',
    'sh': 'Serbian (Latin)',
    'scn': 'Sicilian',
    'sd': 'Sindhi',
    'si': 'Sinhala',
    'sk': 'Slovak',
    'sl': 'Slovenian',
    'so': 'Somali',
    'azb': 'South Azerbaijani',
    'es': 'Spanish',
    'su': 'Sundanese',
    'sw': 'Swahili',
    'sv': 'Swedish',
    'als': 'Swiss German',
    'tg': 'Tajik',
    'ta': 'Tamil',
    'tt': 'Tatar',
    'te': 'Telugu',
    'th': 'Thai',
    'bo': 'Tibetan',
    'tr': 'Turkish',
    'tk': 'Turkmen',
    'tyv': 'Tuvinian',
    'uk': 'Ukrainian',
    'hsb': 'Upper Sorbian',
    'ur': 'Urdu',
    'ug': 'Uyghur',
    'uz': 'Uzbek',
    'vec': 'Venetian',
    'vi': 'Vietnamese',
    'vo': 'Volapuk',
    'wa': 'Walloon',
    'war': 'Waray',
    'cy': 'Welsh',
    'vls': 'West Flemish',
    'fy': 'Western Frisian',
    'mrj': 'Western Mari',
    'pnb': 'Western Panjabi',
    'wuu': 'Wu Chinese',
    'yi': 'Yiddish',
    'yo': 'Yoruba'
}