import pandas as pd
from bilevel.utils import *
import numpy as np
import time
from tqdm import tqdm
from bilevel.Anh import Adanormal_sleepingexps
from bilevel.ExpertsAbstract import Expert
from bilevel.utils import  fill_subsequence_losses

class build_Anh:
    def __init__(self, dir_name : str, filename: str, A_t: np.ndarray, experts: list[Expert]):
        self.timestamp = time.strftime("%Y%m%d-%H%M%S")
        self.dir_name = dir_name
        self.filename = filename + self.timestamp
        self.A_t = A_t
        self.T = A_t.shape[0]
        self.N = A_t.shape[1]
        self.experts = experts
        self.build()

    def build(self):
        self.Anh = Adanormal_sleepingexps(self.A_t, self.experts)
        for t in tqdm(range(self.T)):
            self.Anh.get_prob_over_experts(t) #get probability over meta-experts
            self.Anh.update_metaexps_loss(t) # update internal states of the meta-experts
        self.Anh.build_cumloss_curve()
        self.Anh.cleanup()

class build_baseline_alwayson:
    def __init__(self, dir_name : str, filename: str, A_t: np.ndarray, expert: Expert):
        self.timestamp = time.strftime("%Y%m%d-%H%M%S")
        self.dir_name = dir_name
        self.filename = filename + self.timestamp
        self.A_t = A_t
        self.T = A_t.shape[0]
        self.expert = expert
        self.build()
    
    def build(self):
        for t in tqdm(range(self.T)):
            self.expert.get_ypred_t(t)
            self.expert.update_t(t)
        self.expert.cumloss_groupwise = fill_subsequence_losses(self.expert, self.A_t)
        self.expert.cleanup()