from enum import Enum
 
class CTypes(Enum):
    RANKING_GROUP_ID_COLUMN = "RANKING_GROUP_ID_COLUMN"
    RANKING_ELEMENT_ID_COLUMN = "RANKING_ELEMENT_ID_COLUMN"
    RANKING_TARGET_COLUMN = "RANKING_TARGET_COLUMN"
    RANKING_SCORE_COLUMN = "RANKING_SCORE_COLUMN"
    NUMERICAL = "NUMERICAL"
    

COLUMN_TYPES_RANK = {
    "tid": CTypes.RANKING_GROUP_ID_COLUMN,
    "model_id": CTypes.RANKING_ELEMENT_ID_COLUMN,
    "ranking": CTypes.RANKING_TARGET_COLUMN,
    "test_scores": CTypes.RANKING_SCORE_COLUMN,
    'rank_mean': CTypes.NUMERICAL,
    "column_type_id": CTypes.NUMERICAL,
}

COLUMN_TYPES_SCORE = {
    "tid": CTypes.RANKING_GROUP_ID_COLUMN,
    "model_id": CTypes.RANKING_ELEMENT_ID_COLUMN,
    "ranking": CTypes.RANKING_TARGET_COLUMN,
    "test_scores": CTypes.RANKING_SCORE_COLUMN,   
    'test_score_mean': CTypes.NUMERICAL,
    "column_type_id": CTypes.NUMERICAL,
}

COLUMN_TYPES_FEATURES_AMLB = {
    'attr_to_inst': CTypes.NUMERICAL,
    'cat_to_num': CTypes.NUMERICAL, 
    'freq_class.mean': CTypes.NUMERICAL, 
    'freq_class.sd': CTypes.NUMERICAL,
    'inst_to_attr': CTypes.NUMERICAL,
    'nr_attr': CTypes.NUMERICAL, 
    'nr_bin': CTypes.NUMERICAL, 
    'nr_cat': CTypes.NUMERICAL, 
    'nr_class': CTypes.NUMERICAL, 
    'nr_inst': CTypes.NUMERICAL, 
    'nr_num': CTypes.NUMERICAL,
    'num_to_cat': CTypes.NUMERICAL
}

COLUMN_TYPES_FEATURES_ASLIB = {
    'MeanAttributeEntropy': CTypes.NUMERICAL,
    'NaiveBayesAdwin.warnings': CTypes.NUMERICAL,
    'NoiseToSignalRatio': CTypes.NUMERICAL,
    'NumberOfNumericFeatures': CTypes.NUMERICAL,
    'NumberOfBinaryFeatures': CTypes.NUMERICAL,
    'DecisionStumpKappa': CTypes.NUMERICAL,
    'Quartile3SkewnessOfNumericAtts': CTypes.NUMERICAL,
    'NumberOfMissingValues': CTypes.NUMERICAL,
    'J48.001.ErrRate': CTypes.NUMERICAL,
    'HoeffdingAdwin.changes': CTypes.NUMERICAL,
    'PercentageOfNumericFeatures': CTypes.NUMERICAL,
    'MeanSkewnessOfNumericAtts': CTypes.NUMERICAL,
    'MinStdDevOfNumericAtts': CTypes.NUMERICAL,
    'NaiveBayesErrRate': CTypes.NUMERICAL,
    'MinMutualInformation': CTypes.NUMERICAL,
    'MajorityClassPercentage': CTypes.NUMERICAL,
    'NumberOfSymbolicFeatures': CTypes.NUMERICAL,
    'J48.00001.ErrRate': CTypes.NUMERICAL,
    'MaxNominalAttDistinctValues': CTypes.NUMERICAL,
    'PercentageOfMissingValues': CTypes.NUMERICAL,
    'MinKurtosisOfNumericAtts': CTypes.NUMERICAL,
    'MaxKurtosisOfNumericAtts': CTypes.NUMERICAL,
    'EquivalentNumberOfAtts': CTypes.NUMERICAL,
    'DecisionStumpErrRate': CTypes.NUMERICAL,
    'RandomTreeDepth3ErrRate': CTypes.NUMERICAL,
    'MaxStdDevOfNumericAtts': CTypes.NUMERICAL,
    'NaiveBayesAdwin.changes': CTypes.NUMERICAL,
    'Quartile3AttributeEntropy': CTypes.NUMERICAL,
    'MeanKurtosisOfNumericAtts': CTypes.NUMERICAL,
    'MinorityClassPerentage': CTypes.NUMERICAL,
    'J48.00001.Kappa': CTypes.NUMERICAL,
    'REPTreeDepth2ErrRate': CTypes.NUMERICAL,
    'Quartile2KurtosisOfNumericAtts': CTypes.NUMERICAL,
    'REPTreeDepth3AUC': CTypes.NUMERICAL,
    'RandomTreeDepth2ErrRate': CTypes.NUMERICAL,
    'Quartile1AttributeEntropy': CTypes.NUMERICAL,
    'MeanMeansOfNumericAtts': CTypes.NUMERICAL,
    'MeanStdDevOfNumericAtts': CTypes.NUMERICAL,
    'REPTreeDepth1Kappa': CTypes.NUMERICAL,
    'Dimensionality': CTypes.NUMERICAL,
    'REPTreeDepth2AUC': CTypes.NUMERICAL,
    'MinAttributeEntropy': CTypes.NUMERICAL,
    'NaiveBayesDdm.changes': CTypes.NUMERICAL,
    'MinNominalAttDistinctValues': CTypes.NUMERICAL,
    'MinorityClassSize': CTypes.NUMERICAL,
    'Quartile2AttributeEntropy': CTypes.NUMERICAL,
    'Quartile1SkewnessOfNumericAtts': CTypes.NUMERICAL,
    'Quartile3StdDevOfNumericAtts': CTypes.NUMERICAL,
    'Quartile1MutualInformation': CTypes.NUMERICAL,
    'Quartile2SkewnessOfNumericAtts': CTypes.NUMERICAL,
    'MajorityClassSize': CTypes.NUMERICAL,
    'REPTreeDepth3ErrRate': CTypes.NUMERICAL,
    'MaxAttributeEntropy': CTypes.NUMERICAL,
    'RandomTreeDepth2Kappa': CTypes.NUMERICAL,
    'HoeffdingDDM.changes': CTypes.NUMERICAL,
    'Quartile3KurtosisOfNumericAtts': CTypes.NUMERICAL,
    'NaiveBayesKappa': CTypes.NUMERICAL,
    'HoeffdingDDM.warnings': CTypes.NUMERICAL,
    'Quartile2StdDevOfNumericAtts': CTypes.NUMERICAL,
    'MeanNominalAttDistinctValues': CTypes.NUMERICAL,
    'REPTreeDepth1ErrRate': CTypes.NUMERICAL,
    'MaxMeansOfNumericAtts': CTypes.NUMERICAL,
    'NumberOfInstances': CTypes.NUMERICAL,
    'RandomTreeDepth1Kappa': CTypes.NUMERICAL,
    'J48.001.AUC': CTypes.NUMERICAL,
    'MaxSkewnessOfNumericAtts': CTypes.NUMERICAL,
    'J48.0001.AUC': CTypes.NUMERICAL,
    'RandomTreeDepth3AUC': CTypes.NUMERICAL,
    'MeanMutualInformation': CTypes.NUMERICAL,
    'RandomTreeDepth1ErrRate': CTypes.NUMERICAL,
    'RandomTreeDepth2AUC': CTypes.NUMERICAL,
    'MinMeansOfNumericAtts': CTypes.NUMERICAL,
    'PercentageOfBinaryFeatures': CTypes.NUMERICAL,
    'NumberOfFeatures': CTypes.NUMERICAL,
    'NaiveBayesAUC': CTypes.NUMERICAL,
    'DefaultAccuracy': CTypes.NUMERICAL,
    'NaiveBayesDdm.warnings': CTypes.NUMERICAL,
    'Quartile3MeansOfNumericAtts': CTypes.NUMERICAL,
    'REPTreeDepth1AUC': CTypes.NUMERICAL,
    'MaxMutualInformation': CTypes.NUMERICAL,
    'HoeffdingAdwin.warnings': CTypes.NUMERICAL,
    'RandomTreeDepth1AUC': CTypes.NUMERICAL,
    'J48.0001.Kappa': CTypes.NUMERICAL,
    'Quartile1MeansOfNumericAtts': CTypes.NUMERICAL,
    'RandomTreeDepth3Kappa': CTypes.NUMERICAL,
    'Quartile1StdDevOfNumericAtts': CTypes.NUMERICAL,
    'REPTreeDepth2Kappa': CTypes.NUMERICAL,
    'Quartile2MeansOfNumericAtts': CTypes.NUMERICAL,
    'J48.00001.AUC': CTypes.NUMERICAL,
    'Quartile2MutualInformation': CTypes.NUMERICAL,
    'J48.001.Kappa': CTypes.NUMERICAL,
    'PercentageOfInstancesWithMissingValues': CTypes.NUMERICAL,
    'NumberOfClasses': CTypes.NUMERICAL,
    'StdvNominalAttDistinctValues': CTypes.NUMERICAL,
    'ClassEntropy': CTypes.NUMERICAL,
    'Quartile1KurtosisOfNumericAtts': CTypes.NUMERICAL,
    'Quartile3MutualInformation': CTypes.NUMERICAL,
    'MinSkewnessOfNumericAtts': CTypes.NUMERICAL,
    'PercentageOfSymbolicFeatures': CTypes.NUMERICAL,
    'J48.0001.ErrRate': CTypes.NUMERICAL,
    'NumberOfInstancesWithMissingValues': CTypes.NUMERICAL,
    'REPTreeDepth3Kappa': CTypes.NUMERICAL,
    'DecisionStumpAUC': CTypes.NUMERICAL,
}


COLUMN_TYPES_PCA = {
    "c1": CTypes.NUMERICAL,
    "c2": CTypes.NUMERICAL,
    "c3": CTypes.NUMERICAL,
}


AMLB = 'AMLB'
ASLIB = 'ASLIB'

def get_column_types(benchmark):
    
    column_types_ranking = COLUMN_TYPES_RANK.copy()
    column_types_score   = COLUMN_TYPES_SCORE.copy()

    if benchmark == AMLB:
        column_types_ranking.update(COLUMN_TYPES_FEATURES_AMLB)
        column_types_score.update(COLUMN_TYPES_FEATURES_AMLB)
    elif benchmark == ASLIB:
        column_types_ranking.update(COLUMN_TYPES_FEATURES_ASLIB)
        column_types_score.update(COLUMN_TYPES_FEATURES_ASLIB)
    else:
        raise ValueError('Unknown benchmark dataset, no task features included.')
    
    return column_types_ranking, column_types_score


COMPONENT_NAMES = ['Pipeline', 'FeatureUnion', 'ColumnTransformer', 'SimpleImputerCategorical', 'SimpleImputerNumerical', 'Passthrough', 'OneHotEncoder', 'FunctionTransformer', 'FunctionTransformerCategorical', 'StandardScaler', 'LogisticRegression', 'AdaboostClassifier', 'BernoulliNBClassifier', 'DecisionTreeClassifier', 'ExtraTreesClassifier', 'GaussianNBClassifier', 'GradientBoostingClassifier', 'KNearestNeighborsClassifier', 'LDAClassifier', 'LibLinear_SVCClassifier', 'LibSVM_SVCClassifier', 'MLPClassifier', 'MultinomialNBClassifier', 'PassiveAggressiveClassifier', 'QDAClassifier', 'RandomForestClassifier', 'SGDClassifier', 'LinearRegression', 'AdaboostRegressor', 'ARDRegressor', 'DecisionTreeRegressor', 'ExtraTreesRegressor', 'GaussianProcessRegressor', 'GradientBoostingRegressor', 'KNearestNeighborsRegressor', 'LibLinear_SVRRegressor', 'LibSVM_SVRRegressor', 'MLPRegressor', 'RandomForestRegressor', 'SGDRegressor', 'Densifier', 'ExtraTreesPreprocessorClassification', 'ExtraTreesPreprocessorRegression', 'FastICA', 'FeatureAgglomeration', 'KernelPCA', 'RandomKitchenSinks', 'LibLinear_Preprocessor', 'NoPreprocessing', 'Nystroem', 'PCA', 'PolynomialFeatures', 'RandomTreesEmbedding', 'SelectPercentileClassification', 'SelectPercentileRegression', 'SelectClassificationRates', 'SelectRegressionRates', 'TruncatedSVD', 'Balancing', 'OrdinalEncoding', 'NoEncoding', 'CategoryShift', 'CategoricalImputation', 'NumericalImputation', 'MinorityCoalescer', 'NoCoalescence', 'MinMaxScalerComponent', 'NoRescalingComponent', 'NormalizerComponent', 'PowerTransformerComponent', 'QuantileTransformerComponent', 'RobustScalerComponent', 'StandardScalerComponent', 'VarianceThreshold']