import pandas as pd

def judge_accuracy(df: pd.DataFrame) -> float:
    if 'judge' not in df:
        raise ValueError("judge column not found in dataframe")
    if len(df) == 0:
        raise ValueError("DataFrame is empty")
    true_count = df['judge'].value_counts().get('yes', 0)
    return true_count / len(df)