#!/bin/bash

mkdir -p ./log/acasxu_statistic


for i in {60..74}; do
    if [[ $i -eq 65 || $i -eq 73 ]]; then
        continue
    fi

    echo "Running abcrown.py with --select_instance $i"
    CUDA_VISIBLE_DEVICES=2 python abcrown.py --config exp_configs/vnncomp21/acasxu_new.yaml \
        --select_instance $i \
        --enable_constrained_concretize \
        --sanity_check_constraints gurobi \
        --skip_enhance \
        --timeout 10000.0 \
        --timeout_scale 10 \
        --pgd_order skip \
        --skip_enhance \
        2>&1 | tee ./log/acasxu_statistic/output_${i}.log
done