library(WeightIt)

max_moment <- 4
top_source_dir = './data/train_data'
source_dir_names <- c('N1000', 'N10000', 'N100000')

for(s_dir in source_dir_names){
  parent_source_dir <- file.path(top_source_dir, s_dir)
  source_dirs <- dir(parent_source_dir, 
                     full.names = TRUE,
                     no..=TRUE)
  set.seed(0)
  for(s_dir in source_dirs){
    in_data_path <- file.path(s_dir, 'train.csv')
    out_res_path <- file.path(s_dir, 'train_EBweights.csv')
    d <- read.csv(in_data_path)
    weights_list = vector(mode = "list", max_moment)
    for(m in 1:max_moment){
      W <- weightit(A~X1_1+X1_2+X1_3+X2+X3_1+X3_2+X3_3,
                    data = d,
                    method = "ebal", moments = m,
                    d.moments = max(m,3))
      weights_list[[m]] <- W$weights
    }
    weights_table <- do.call(cbind, weights_list)
    colnames(weights_table) <- paste('moment', 1:max_moment, sep='_')
    write.csv(weights_table, file=out_res_path, row.names=FALSE)
  }
}
