# %%
from __future__ import division
import os
import datetime
import random
import pickle

import numpy as np
import pandas as pd

from libs import CreateData


# Script Global Parameters
N_DATA_TEST_LIST = [1000, 10000, 100000]

# For output directory
OUTPUT_PARENT_DIRECTORY = f'./data/test_data'
N_EXPERIMENTS = 100

# data_column_names
columns_for_dataframe = [
  'Y',
  'A',
  'X1_1', 'X1_2', 'X1_3',
  'X2',
  'X3_1', 'X3_2', 'X3_3']


# %%
for n_data_test in N_DATA_TEST_LIST:
    if __name__ == '__main__':
        np.random.seed(1)
        random.seed(1)
        for _i_d in range(N_EXPERIMENTS):
            """
            Generate data
            """
            test_expls_Expr1, test_resp_Expr1, \
                test_expls_Expr2, test_resp_Expr2\
                = CreateData.gen_test(n_data_test)
            test_data_Expr1_mat = np.concatenate(
              [test_resp_Expr1] + test_expls_Expr1, axis=1)
            test_data_Expr2_mat = np.concatenate(
              [test_resp_Expr2] + test_expls_Expr2, axis=1)
            test_data_Expr1_df = pd.DataFrame(
                test_data_Expr1_mat,
                columns=columns_for_dataframe)
            test_data_Expr2_df = pd.DataFrame(
                test_data_Expr2_mat,
                columns=columns_for_dataframe)

            """
            Output data
            """
            out_dir_base = f'D{_i_d:03}'
            out_dir = os.path.join(
                OUTPUT_PARENT_DIRECTORY,
                out_dir_base)
            os.makedirs(out_dir, exist_ok=True)

            # test data for Experiment1
            test_data_Expr1_df.to_csv(
              os.path.join(
                out_dir, 'test_Experiment1.csv'), index=False)

            # test data for Experiment2
            test_data_Expr2_df.to_csv(
              os.path.join(
                out_dir, 'test_Experiment2.csv'), index=False)