# %%
from __future__ import division
import os
import datetime
import random
import pickle

import numpy as np
import pandas as pd

from libs import CreateData


# Script Global Parameters
N_DATA_TRAIN_LIST = [1000, 10000, 100000]
N_EXPERIMENTS = 100

# data_column_names
columns_for_dataframe = [
  'Y',
  'A',
  'X1_1', 'X1_2', 'X1_3',
  'X2',
  'X3_1', 'X3_2', 'X3_3']


# %%
for n_data_train in N_DATA_TRAIN_LIST:
    if __name__ == '__main__':
        np.random.seed(1)
        random.seed(1)
        n_data_validate = n_data_train
        # For output directory
        out_parent_dir = f'./data/train_data/N{n_data_train}'

        for _i_d in range(N_EXPERIMENTS):
            """
            Generate data
            """
            train_expls, train_resp = CreateData.gen_train(
                n_data_train + n_data_validate)

            train_data_mat = np.concatenate(
                [train_resp, train_expls], axis=1)

            train_data_df = pd.DataFrame(
                train_data_mat,
                columns=columns_for_dataframe)

            """
            Output data
            """
            out_dir_base = f'D{_i_d:03}'
            out_dir = os.path.join(
                out_parent_dir,
                out_dir_base)
            os.makedirs(out_dir, exist_ok=True)

            # train data
            train_data_df.to_csv(
              os.path.join(
                out_dir, 'train.csv'), index=False)
