```
Thank you for reviewing our work.

We appreciate your feedbacks!
```

# Hiearchical World Models with Semantic Communications for Autonomous Driving

## Tasks

The task names include:

```bash
- carla_message
- carla_left_turn
- carla_right_turn
- carla_message_obstacle
```

- `carla_message` is the `DenseTraffic` task in the paper. It also allows for intention sharing through our implementation of message handler.
- `carla_left_turn`

### Training

Speicify the task name and run the following command.

```bash
bash train_hansome.sh 2000 0 --task task_name --dreamerv3.logdir ./path/to/logdir --dreamerv3.task_behavior Hansome
```

For tasks other than `DenseTraffic`, we experimented with both training these tasks on a pre-trained `DenseTraffic` checkpoint, or training from scratch. You can reporduce the results through both options.

`DenseTraffic` is a challenging tasks with dense traffic and complex dynamics, so it can serve as the foundation model for the rest of tasks to speed up training.

To fine-tune `carla_message` to `LeftTurn` and `RightTurn`, just load in a `DenseTraffic` checkpoint:

```bash
bash train_hansome.sh 2003 1 --task carla_left_turn_hard --dreamerv3.logdir ./hansome_logdir/finetune_left_turn_hard --dreamerv3.run.from_checkpoint ./hansome_logdir/hansome_old.ckpt
bash train_hansome.sh 2006 2 --task carla_right_turn_hard --dreamerv3.logdir ./hansome_logdir/finetune_right_turn_hard --dreamerv3.run.from_checkpoint ./hansome_logdir/hansome_old.ckpt
```

Otherwise, remove the checkpoint path to train from scratch.

### Evaluation

Specify the checkpoint path and run evaluation:

```bash
bash eval_hansome.sh 2000 0 ./hansome_logdir/checkpoint.ckpt --task carla_message --dreamerv3.logdir ./hansome_logdir/eval_carla_message
```

Compute performance metrics:

```bash
python dreamerv3/eval_stats.py --logdir ./logdir/eval_carla_four_lane
```

### Multi-Agent Execution

Use `eval_ma_hansome.sh` and specify the checkpoint path. The script loads in checkpoint duplicates to multiple GPU cards for all the agents (up to 4). We suggest using 2 to improve the chance of successful execution. The agents interact within the `DenseTraffic` environment. It is quite suprising that two HANSOME agents can neogotiate when meeting each other.

______________________________________________________________________

Unleash the power of **hierarchical planning** and **semantic communications** of world models for self-driving cars.

### Credits

`HANSOME` builds on the several projects within the autonomous driving and machine learning communities.

- [CarDreamer](https://github.com/ucd-dare/CarDreamer)
- [gym-carla](https://github.com/cjy1992/gym-carla)
- [DreamerV2](https://github.com/danijar/director)
- [DreamerV3](https://github.com/danijar/dreamerv3)
- [CuriousReplay](https://github.com/AutonomousAgentsLab/curiousreplay)
