import random

import carla
import numpy as np

from .carla_wpt_env import CarlaWptEnv
from .toolkit import FixedPathPlanner, get_vehicle_pos


class CarlaFourLaneObstacleEnv(CarlaWptEnv):
    """
    This task generates fixed route in a four-lane system with obstacles on route.

    **Provided Tasks**: ``carla_four_lane_obstacle``
    """

    def on_reset(self) -> None:
        self.ego_src = self._config.lane_start_point
        ego_transform = carla.Transform(carla.Location(x=self.ego_src[0], y=self.ego_src[1], z=self.ego_src[2]), carla.Rotation(yaw=-90))
        self.ego = self._world.spawn_actor(transform=ego_transform)
        self.spawn_obstacle(transform_list=self._config.obstacle_positions)
        self.ego_path = self._config.ego_path
        self.ego_path_wave_line = self._config.ego_path_wave_line
        self.ego_planner = FixedPathPlanner(vehicle=self.ego, vehicle_path=self.ego_path, wave_line=self.ego_path_wave_line)
        self.waypoints, self.planner_stats = self.ego_planner.run_step()
        self.num_completed = self.planner_stats["num_completed"]

    def spawn_obstacle(self, transform_list) -> None:
        """
        Spawn still vehicles as obstacles.
        """
        for trans in transform_list:
            ob_transform = carla.Transform(carla.Location(x=trans[0], y=trans[1], z=trans[2]), carla.Rotation(yaw=-90))
            self._world.spawn_actor(transform=ob_transform)
