from typing import Optional

import numpy as np
from gym import spaces

from car_dreamer.toolkit import EnvMonitorOpenCV, Observer, WorldManager
from car_dreamer.toolkit.carla_manager.utils import get_vehicle_pos

from .carla_wpt_fixed_env import CarlaWptFixedEnv


class CarlaLeftTurnEnv(CarlaWptFixedEnv):
    def __init__(self, config, world: Optional[WorldManager] = None, observer: Optional[Observer] = None, monitor: Optional[EnvMonitorOpenCV] = None):
        super().__init__(config, world, observer, monitor)
        self._observer.register_simple_handler("worker_reward", lambda env_state: np.float32(0.0), spaces.Box(low=0.0, high=1.0, dtype=np.float32))
        self.observation_space = self._get_observation_space()

    def get_state(self):
        state = super().get_state()
        return {**state, "task": "carla_left_turn"}

    def on_step(self) -> None:
        if len(self.actor_flow) > 0:
            vehicle = self.actor_flow[0]
            x, y = get_vehicle_pos(self.actor_flow[0])
            if y > -99.4 or y < -171.4 or x > 57.6:
                self._world.destroy_actor(vehicle.id)
                self.actor_flow.popleft()
        super().on_step()
