from enum import Enum

from .handlers import BirdeyeHandler, CameraHandler, CollisionHandler, LidarHandler, MaMessageHandler, MessageHandler, SpectatorHandler


class HandlerType(Enum):
    """User-defiend data sources"""

    RGB_CAMERA = "camera"
    LIDAR = "lidar"
    COLLISION = "collision"
    BIRDEYE = "birdeye"
    MESSAGE = "message"
    MA_MESSAGE = "ma_message"
    SPECTATOR = "spectator"


HANDLER_DICT = {
    HandlerType.BIRDEYE: BirdeyeHandler,
    HandlerType.MESSAGE: MessageHandler,
    HandlerType.MA_MESSAGE: MaMessageHandler,
    HandlerType.RGB_CAMERA: CameraHandler,
    HandlerType.LIDAR: LidarHandler,
    HandlerType.COLLISION: CollisionHandler,
    HandlerType.SPECTATOR: SpectatorHandler,
}
