import matplotlib.pyplot as plt

x0 = [0.795, 0.777, 0.776, 0.777, 0.777, 0.778, 0.778]
y0 = [0, 0.011, 0.017, 0.019, 0.021, 0.022, 0.022]

x1 = [0.886, 0.795, 0.777, 0.776, 0.776, 0.777, 0.778]
y1 = [0, 0.011, 0.017, 0.019, 0.021, 0.022, 0.022]

x2 = [4.291, 1.604, 0.959, 0.811, 0.780, 0.776, 0.776]
y2 = [0, 0.011, 0.017, 0.02, 0.021, 0.022, 0.022]

x3 = [15.288, 4.291, 1.604, 0.959, 0.811, 0.78, 0.776]
y3 = [0, 0.011, 0.017, 0.019, 0.021, 0.022, 0.022]

from pylab import *

font = {"family": "normal", "size": 13}
matplotlib.rc("font", **font)

fig = plt.figure(figsize=(5, 4.4))
p1, = plt.plot(x0, y0, "r*-", label="$\eta=10$", linewidth=2)
p2, = plt.plot(x1, y1, "c>:", label="$\eta=5$", linewidth=2)
p3, = plt.plot(x2, y2, "y^-", label="$\eta=1$", linewidth=2)
p4, = plt.plot(x3, y3, "bx--", label="$\eta=0.5$", linewidth=2)
plt.legend()

plt.xlabel("MSE")
plt.ylabel("FCE")
plt.grid()
plt.show()
fig.savefig("trade_off_curves.png")