#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2202
#define LARGE_STATE_COUNT 175
#define SYMBOL_COUNT 245
#define ALIAS_COUNT 2
#define TOKEN_COUNT 106
#define EXTERNAL_TOKEN_COUNT 10
#define FIELD_COUNT 29
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 120

enum {
  sym_identifier = 1,
  anon_sym_SEMI = 2,
  anon_sym_import = 3,
  anon_sym_DOT = 4,
  anon_sym_from = 5,
  anon_sym___future__ = 6,
  anon_sym_LPAREN = 7,
  anon_sym_RPAREN = 8,
  anon_sym_COMMA = 9,
  anon_sym_as = 10,
  anon_sym_STAR = 11,
  anon_sym_print = 12,
  anon_sym_GT_GT = 13,
  anon_sym_assert = 14,
  anon_sym_COLON_EQ = 15,
  anon_sym_match = 16,
  anon_sym_return = 17,
  anon_sym_del = 18,
  anon_sym_raise = 19,
  anon_sym_pass = 20,
  anon_sym_break = 21,
  anon_sym_continue = 22,
  anon_sym_if = 23,
  anon_sym_COLON = 24,
  anon_sym_elif = 25,
  anon_sym_else = 26,
  anon_sym_case = 27,
  anon_sym_async = 28,
  anon_sym_for = 29,
  anon_sym_in = 30,
  anon_sym_while = 31,
  anon_sym_try = 32,
  anon_sym_except = 33,
  anon_sym_except_STAR = 34,
  anon_sym_finally = 35,
  anon_sym_with = 36,
  anon_sym_def = 37,
  anon_sym_DASH_GT = 38,
  anon_sym_STAR_STAR = 39,
  anon_sym_global = 40,
  anon_sym_nonlocal = 41,
  anon_sym_exec = 42,
  anon_sym_class = 43,
  anon_sym_AT = 44,
  anon_sym_LBRACK = 45,
  anon_sym_RBRACK = 46,
  anon_sym_EQ = 47,
  anon_sym_not = 48,
  anon_sym_and = 49,
  anon_sym_or = 50,
  anon_sym_PLUS = 51,
  anon_sym_DASH = 52,
  anon_sym_SLASH = 53,
  anon_sym_PERCENT = 54,
  anon_sym_SLASH_SLASH = 55,
  anon_sym_PIPE = 56,
  anon_sym_AMP = 57,
  anon_sym_CARET = 58,
  anon_sym_LT_LT = 59,
  anon_sym_TILDE = 60,
  anon_sym_LT = 61,
  anon_sym_LT_EQ = 62,
  anon_sym_EQ_EQ = 63,
  anon_sym_BANG_EQ = 64,
  anon_sym_GT_EQ = 65,
  anon_sym_GT = 66,
  anon_sym_LT_GT = 67,
  anon_sym_is = 68,
  anon_sym_lambda = 69,
  anon_sym_PLUS_EQ = 70,
  anon_sym_DASH_EQ = 71,
  anon_sym_STAR_EQ = 72,
  anon_sym_SLASH_EQ = 73,
  anon_sym_AT_EQ = 74,
  anon_sym_SLASH_SLASH_EQ = 75,
  anon_sym_PERCENT_EQ = 76,
  anon_sym_STAR_STAR_EQ = 77,
  anon_sym_GT_GT_EQ = 78,
  anon_sym_LT_LT_EQ = 79,
  anon_sym_AMP_EQ = 80,
  anon_sym_CARET_EQ = 81,
  anon_sym_PIPE_EQ = 82,
  anon_sym_yield = 83,
  sym_ellipsis = 84,
  anon_sym_LBRACE = 85,
  anon_sym_RBRACE = 86,
  anon_sym_LBRACE_LBRACE = 87,
  anon_sym_RBRACE_RBRACE = 88,
  sym_escape_sequence = 89,
  sym__not_escape_sequence = 90,
  aux_sym_format_specifier_token1 = 91,
  sym_type_conversion = 92,
  sym_integer = 93,
  sym_float = 94,
  anon_sym_await = 95,
  sym_true = 96,
  sym_false = 97,
  sym_none = 98,
  sym_comment = 99,
  sym__newline = 100,
  sym__indent = 101,
  sym__dedent = 102,
  sym__string_start = 103,
  sym__string_content = 104,
  sym__string_end = 105,
  sym_module = 106,
  sym__statement = 107,
  sym__simple_statements = 108,
  sym_import_statement = 109,
  sym_import_prefix = 110,
  sym_relative_import = 111,
  sym_future_import_statement = 112,
  sym_import_from_statement = 113,
  sym__import_list = 114,
  sym_aliased_import = 115,
  sym_wildcard_import = 116,
  sym_print_statement = 117,
  sym_chevron = 118,
  sym_assert_statement = 119,
  sym_expression_statement = 120,
  sym_named_expression = 121,
  sym__named_expresssion_lhs = 122,
  sym_return_statement = 123,
  sym_delete_statement = 124,
  sym_raise_statement = 125,
  sym_pass_statement = 126,
  sym_break_statement = 127,
  sym_continue_statement = 128,
  sym_if_statement = 129,
  sym_elif_clause = 130,
  sym_else_clause = 131,
  sym_match_statement = 132,
  sym_case_clause = 133,
  sym_for_statement = 134,
  sym_while_statement = 135,
  sym_try_statement = 136,
  sym_except_clause = 137,
  sym_except_group_clause = 138,
  sym_finally_clause = 139,
  sym_with_statement = 140,
  sym_with_clause = 141,
  sym_with_item = 142,
  sym_function_definition = 143,
  sym_parameters = 144,
  sym_lambda_parameters = 145,
  sym_list_splat = 146,
  sym_dictionary_splat = 147,
  sym_global_statement = 148,
  sym_nonlocal_statement = 149,
  sym_exec_statement = 150,
  sym_class_definition = 151,
  sym_parenthesized_list_splat = 152,
  sym_argument_list = 153,
  sym_decorated_definition = 154,
  sym_decorator = 155,
  sym_block = 156,
  sym_expression_list = 157,
  sym_dotted_name = 158,
  sym__parameters = 159,
  sym__patterns = 160,
  sym_parameter = 161,
  sym_pattern = 162,
  sym_tuple_pattern = 163,
  sym_list_pattern = 164,
  sym_default_parameter = 165,
  sym_typed_default_parameter = 166,
  sym_list_splat_pattern = 167,
  sym_dictionary_splat_pattern = 168,
  sym_as_pattern = 169,
  sym__expression_within_for_in_clause = 170,
  sym_expression = 171,
  sym_primary_expression = 172,
  sym_not_operator = 173,
  sym_boolean_operator = 174,
  sym_binary_operator = 175,
  sym_unary_operator = 176,
  sym_comparison_operator = 177,
  sym_lambda = 178,
  sym_lambda_within_for_in_clause = 179,
  sym_assignment = 180,
  sym_augmented_assignment = 181,
  sym_pattern_list = 182,
  sym__right_hand_side = 183,
  sym_yield = 184,
  sym_attribute = 185,
  sym_subscript = 186,
  sym_slice = 187,
  sym_call = 188,
  sym_typed_parameter = 189,
  sym_type = 190,
  sym_keyword_argument = 191,
  sym_list = 192,
  sym_set = 193,
  sym_tuple = 194,
  sym_dictionary = 195,
  sym_pair = 196,
  sym_list_comprehension = 197,
  sym_dictionary_comprehension = 198,
  sym_set_comprehension = 199,
  sym_generator_expression = 200,
  sym__comprehension_clauses = 201,
  sym_parenthesized_expression = 202,
  sym__collection_elements = 203,
  sym_for_in_clause = 204,
  sym_if_clause = 205,
  sym_conditional_expression = 206,
  sym_concatenated_string = 207,
  sym_string = 208,
  sym_interpolation = 209,
  sym__f_expression = 210,
  sym__escape_interpolation = 211,
  sym_format_specifier = 212,
  sym_format_expression = 213,
  sym_await = 214,
  sym_positional_separator = 215,
  sym_keyword_separator = 216,
  aux_sym_module_repeat1 = 217,
  aux_sym__simple_statements_repeat1 = 218,
  aux_sym_import_prefix_repeat1 = 219,
  aux_sym__import_list_repeat1 = 220,
  aux_sym_print_statement_repeat1 = 221,
  aux_sym_assert_statement_repeat1 = 222,
  aux_sym_if_statement_repeat1 = 223,
  aux_sym_match_statement_repeat1 = 224,
  aux_sym_match_statement_repeat2 = 225,
  aux_sym_case_clause_repeat1 = 226,
  aux_sym_try_statement_repeat1 = 227,
  aux_sym_try_statement_repeat2 = 228,
  aux_sym_with_clause_repeat1 = 229,
  aux_sym_global_statement_repeat1 = 230,
  aux_sym_argument_list_repeat1 = 231,
  aux_sym_decorated_definition_repeat1 = 232,
  aux_sym_dotted_name_repeat1 = 233,
  aux_sym__parameters_repeat1 = 234,
  aux_sym__patterns_repeat1 = 235,
  aux_sym_comparison_operator_repeat1 = 236,
  aux_sym_subscript_repeat1 = 237,
  aux_sym_dictionary_repeat1 = 238,
  aux_sym__comprehension_clauses_repeat1 = 239,
  aux_sym__collection_elements_repeat1 = 240,
  aux_sym_for_in_clause_repeat1 = 241,
  aux_sym_concatenated_string_repeat1 = 242,
  aux_sym_string_repeat1 = 243,
  aux_sym_format_specifier_repeat1 = 244,
  alias_sym_as_pattern_target = 245,
  alias_sym_case_pattern = 246,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_SEMI] = ";",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_from] = "from",
  [anon_sym___future__] = "__future__",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COMMA] = ",",
  [anon_sym_as] = "as",
  [anon_sym_STAR] = "*",
  [anon_sym_print] = "print",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_assert] = "assert",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_match] = "match",
  [anon_sym_return] = "return",
  [anon_sym_del] = "del",
  [anon_sym_raise] = "raise",
  [anon_sym_pass] = "pass",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_if] = "if",
  [anon_sym_COLON] = ":",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_case] = "case",
  [anon_sym_async] = "async",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_try] = "try",
  [anon_sym_except] = "except",
  [anon_sym_except_STAR] = "except*",
  [anon_sym_finally] = "finally",
  [anon_sym_with] = "with",
  [anon_sym_def] = "def",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_global] = "global",
  [anon_sym_nonlocal] = "nonlocal",
  [anon_sym_exec] = "exec",
  [anon_sym_class] = "class",
  [anon_sym_AT] = "@",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_EQ] = "=",
  [anon_sym_not] = "not",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_TILDE] = "~",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_is] = "is",
  [anon_sym_lambda] = "lambda",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AT_EQ] = "@=",
  [anon_sym_SLASH_SLASH_EQ] = "//=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_yield] = "yield",
  [sym_ellipsis] = "ellipsis",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_LBRACE_LBRACE] = "{{",
  [anon_sym_RBRACE_RBRACE] = "}}",
  [sym_escape_sequence] = "escape_sequence",
  [sym__not_escape_sequence] = "_not_escape_sequence",
  [aux_sym_format_specifier_token1] = "format_specifier_token1",
  [sym_type_conversion] = "type_conversion",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_await] = "await",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_none] = "none",
  [sym_comment] = "comment",
  [sym__newline] = "_newline",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym__string_start] = "\"",
  [sym__string_content] = "_string_content",
  [sym__string_end] = "\"",
  [sym_module] = "module",
  [sym__statement] = "_statement",
  [sym__simple_statements] = "_simple_statements",
  [sym_import_statement] = "import_statement",
  [sym_import_prefix] = "import_prefix",
  [sym_relative_import] = "relative_import",
  [sym_future_import_statement] = "future_import_statement",
  [sym_import_from_statement] = "import_from_statement",
  [sym__import_list] = "_import_list",
  [sym_aliased_import] = "aliased_import",
  [sym_wildcard_import] = "wildcard_import",
  [sym_print_statement] = "print_statement",
  [sym_chevron] = "chevron",
  [sym_assert_statement] = "assert_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_named_expression] = "named_expression",
  [sym__named_expresssion_lhs] = "_named_expresssion_lhs",
  [sym_return_statement] = "return_statement",
  [sym_delete_statement] = "delete_statement",
  [sym_raise_statement] = "raise_statement",
  [sym_pass_statement] = "pass_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_match_statement] = "match_statement",
  [sym_case_clause] = "case_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_try_statement] = "try_statement",
  [sym_except_clause] = "except_clause",
  [sym_except_group_clause] = "except_group_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_with_statement] = "with_statement",
  [sym_with_clause] = "with_clause",
  [sym_with_item] = "with_item",
  [sym_function_definition] = "function_definition",
  [sym_parameters] = "parameters",
  [sym_lambda_parameters] = "lambda_parameters",
  [sym_list_splat] = "list_splat",
  [sym_dictionary_splat] = "dictionary_splat",
  [sym_global_statement] = "global_statement",
  [sym_nonlocal_statement] = "nonlocal_statement",
  [sym_exec_statement] = "exec_statement",
  [sym_class_definition] = "class_definition",
  [sym_parenthesized_list_splat] = "parenthesized_list_splat",
  [sym_argument_list] = "argument_list",
  [sym_decorated_definition] = "decorated_definition",
  [sym_decorator] = "decorator",
  [sym_block] = "block",
  [sym_expression_list] = "expression_list",
  [sym_dotted_name] = "dotted_name",
  [sym__parameters] = "_parameters",
  [sym__patterns] = "_patterns",
  [sym_parameter] = "parameter",
  [sym_pattern] = "pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_list_pattern] = "list_pattern",
  [sym_default_parameter] = "default_parameter",
  [sym_typed_default_parameter] = "typed_default_parameter",
  [sym_list_splat_pattern] = "list_splat_pattern",
  [sym_dictionary_splat_pattern] = "dictionary_splat_pattern",
  [sym_as_pattern] = "as_pattern",
  [sym__expression_within_for_in_clause] = "_expression_within_for_in_clause",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_not_operator] = "not_operator",
  [sym_boolean_operator] = "boolean_operator",
  [sym_binary_operator] = "binary_operator",
  [sym_unary_operator] = "unary_operator",
  [sym_comparison_operator] = "comparison_operator",
  [sym_lambda] = "lambda",
  [sym_lambda_within_for_in_clause] = "lambda",
  [sym_assignment] = "assignment",
  [sym_augmented_assignment] = "augmented_assignment",
  [sym_pattern_list] = "pattern_list",
  [sym__right_hand_side] = "_right_hand_side",
  [sym_yield] = "yield",
  [sym_attribute] = "attribute",
  [sym_subscript] = "subscript",
  [sym_slice] = "slice",
  [sym_call] = "call",
  [sym_typed_parameter] = "typed_parameter",
  [sym_type] = "type",
  [sym_keyword_argument] = "keyword_argument",
  [sym_list] = "list",
  [sym_set] = "set",
  [sym_tuple] = "tuple",
  [sym_dictionary] = "dictionary",
  [sym_pair] = "pair",
  [sym_list_comprehension] = "list_comprehension",
  [sym_dictionary_comprehension] = "dictionary_comprehension",
  [sym_set_comprehension] = "set_comprehension",
  [sym_generator_expression] = "generator_expression",
  [sym__comprehension_clauses] = "_comprehension_clauses",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym__collection_elements] = "_collection_elements",
  [sym_for_in_clause] = "for_in_clause",
  [sym_if_clause] = "if_clause",
  [sym_conditional_expression] = "conditional_expression",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string] = "string",
  [sym_interpolation] = "interpolation",
  [sym__f_expression] = "_f_expression",
  [sym__escape_interpolation] = "_escape_interpolation",
  [sym_format_specifier] = "format_specifier",
  [sym_format_expression] = "format_expression",
  [sym_await] = "await",
  [sym_positional_separator] = "positional_separator",
  [sym_keyword_separator] = "keyword_separator",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym__simple_statements_repeat1] = "_simple_statements_repeat1",
  [aux_sym_import_prefix_repeat1] = "import_prefix_repeat1",
  [aux_sym__import_list_repeat1] = "_import_list_repeat1",
  [aux_sym_print_statement_repeat1] = "print_statement_repeat1",
  [aux_sym_assert_statement_repeat1] = "assert_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_match_statement_repeat1] = "match_statement_repeat1",
  [aux_sym_match_statement_repeat2] = "match_statement_repeat2",
  [aux_sym_case_clause_repeat1] = "case_clause_repeat1",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_try_statement_repeat2] = "try_statement_repeat2",
  [aux_sym_with_clause_repeat1] = "with_clause_repeat1",
  [aux_sym_global_statement_repeat1] = "global_statement_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_decorated_definition_repeat1] = "decorated_definition_repeat1",
  [aux_sym_dotted_name_repeat1] = "dotted_name_repeat1",
  [aux_sym__parameters_repeat1] = "_parameters_repeat1",
  [aux_sym__patterns_repeat1] = "_patterns_repeat1",
  [aux_sym_comparison_operator_repeat1] = "comparison_operator_repeat1",
  [aux_sym_subscript_repeat1] = "subscript_repeat1",
  [aux_sym_dictionary_repeat1] = "dictionary_repeat1",
  [aux_sym__comprehension_clauses_repeat1] = "_comprehension_clauses_repeat1",
  [aux_sym__collection_elements_repeat1] = "_collection_elements_repeat1",
  [aux_sym_for_in_clause_repeat1] = "for_in_clause_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_format_specifier_repeat1] = "format_specifier_repeat1",
  [alias_sym_as_pattern_target] = "as_pattern_target",
  [alias_sym_case_pattern] = "case_pattern",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_from] = anon_sym_from,
  [anon_sym___future__] = anon_sym___future__,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_print] = anon_sym_print,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_del] = anon_sym_del,
  [anon_sym_raise] = anon_sym_raise,
  [anon_sym_pass] = anon_sym_pass,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_except] = anon_sym_except,
  [anon_sym_except_STAR] = anon_sym_except_STAR,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_nonlocal] = anon_sym_nonlocal,
  [anon_sym_exec] = anon_sym_exec,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_lambda] = anon_sym_lambda,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AT_EQ] = anon_sym_AT_EQ,
  [anon_sym_SLASH_SLASH_EQ] = anon_sym_SLASH_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_yield] = anon_sym_yield,
  [sym_ellipsis] = sym_ellipsis,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_LBRACE_LBRACE] = anon_sym_LBRACE_LBRACE,
  [anon_sym_RBRACE_RBRACE] = anon_sym_RBRACE_RBRACE,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__not_escape_sequence] = sym__not_escape_sequence,
  [aux_sym_format_specifier_token1] = aux_sym_format_specifier_token1,
  [sym_type_conversion] = sym_type_conversion,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_await] = anon_sym_await,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_none] = sym_none,
  [sym_comment] = sym_comment,
  [sym__newline] = sym__newline,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym__string_start] = sym__string_start,
  [sym__string_content] = sym__string_content,
  [sym__string_end] = sym__string_start,
  [sym_module] = sym_module,
  [sym__statement] = sym__statement,
  [sym__simple_statements] = sym__simple_statements,
  [sym_import_statement] = sym_import_statement,
  [sym_import_prefix] = sym_import_prefix,
  [sym_relative_import] = sym_relative_import,
  [sym_future_import_statement] = sym_future_import_statement,
  [sym_import_from_statement] = sym_import_from_statement,
  [sym__import_list] = sym__import_list,
  [sym_aliased_import] = sym_aliased_import,
  [sym_wildcard_import] = sym_wildcard_import,
  [sym_print_statement] = sym_print_statement,
  [sym_chevron] = sym_chevron,
  [sym_assert_statement] = sym_assert_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_named_expression] = sym_named_expression,
  [sym__named_expresssion_lhs] = sym__named_expresssion_lhs,
  [sym_return_statement] = sym_return_statement,
  [sym_delete_statement] = sym_delete_statement,
  [sym_raise_statement] = sym_raise_statement,
  [sym_pass_statement] = sym_pass_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_match_statement] = sym_match_statement,
  [sym_case_clause] = sym_case_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_except_clause] = sym_except_clause,
  [sym_except_group_clause] = sym_except_group_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_with_statement] = sym_with_statement,
  [sym_with_clause] = sym_with_clause,
  [sym_with_item] = sym_with_item,
  [sym_function_definition] = sym_function_definition,
  [sym_parameters] = sym_parameters,
  [sym_lambda_parameters] = sym_lambda_parameters,
  [sym_list_splat] = sym_list_splat,
  [sym_dictionary_splat] = sym_dictionary_splat,
  [sym_global_statement] = sym_global_statement,
  [sym_nonlocal_statement] = sym_nonlocal_statement,
  [sym_exec_statement] = sym_exec_statement,
  [sym_class_definition] = sym_class_definition,
  [sym_parenthesized_list_splat] = sym_parenthesized_list_splat,
  [sym_argument_list] = sym_argument_list,
  [sym_decorated_definition] = sym_decorated_definition,
  [sym_decorator] = sym_decorator,
  [sym_block] = sym_block,
  [sym_expression_list] = sym_expression_list,
  [sym_dotted_name] = sym_dotted_name,
  [sym__parameters] = sym__parameters,
  [sym__patterns] = sym__patterns,
  [sym_parameter] = sym_parameter,
  [sym_pattern] = sym_pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_list_pattern] = sym_list_pattern,
  [sym_default_parameter] = sym_default_parameter,
  [sym_typed_default_parameter] = sym_typed_default_parameter,
  [sym_list_splat_pattern] = sym_list_splat_pattern,
  [sym_dictionary_splat_pattern] = sym_dictionary_splat_pattern,
  [sym_as_pattern] = sym_as_pattern,
  [sym__expression_within_for_in_clause] = sym__expression_within_for_in_clause,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_not_operator] = sym_not_operator,
  [sym_boolean_operator] = sym_boolean_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym_unary_operator] = sym_unary_operator,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_lambda] = sym_lambda,
  [sym_lambda_within_for_in_clause] = sym_lambda,
  [sym_assignment] = sym_assignment,
  [sym_augmented_assignment] = sym_augmented_assignment,
  [sym_pattern_list] = sym_pattern_list,
  [sym__right_hand_side] = sym__right_hand_side,
  [sym_yield] = sym_yield,
  [sym_attribute] = sym_attribute,
  [sym_subscript] = sym_subscript,
  [sym_slice] = sym_slice,
  [sym_call] = sym_call,
  [sym_typed_parameter] = sym_typed_parameter,
  [sym_type] = sym_type,
  [sym_keyword_argument] = sym_keyword_argument,
  [sym_list] = sym_list,
  [sym_set] = sym_set,
  [sym_tuple] = sym_tuple,
  [sym_dictionary] = sym_dictionary,
  [sym_pair] = sym_pair,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_dictionary_comprehension] = sym_dictionary_comprehension,
  [sym_set_comprehension] = sym_set_comprehension,
  [sym_generator_expression] = sym_generator_expression,
  [sym__comprehension_clauses] = sym__comprehension_clauses,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym__collection_elements] = sym__collection_elements,
  [sym_for_in_clause] = sym_for_in_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string] = sym_string,
  [sym_interpolation] = sym_interpolation,
  [sym__f_expression] = sym__f_expression,
  [sym__escape_interpolation] = sym__escape_interpolation,
  [sym_format_specifier] = sym_format_specifier,
  [sym_format_expression] = sym_format_expression,
  [sym_await] = sym_await,
  [sym_positional_separator] = sym_positional_separator,
  [sym_keyword_separator] = sym_keyword_separator,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym__simple_statements_repeat1] = aux_sym__simple_statements_repeat1,
  [aux_sym_import_prefix_repeat1] = aux_sym_import_prefix_repeat1,
  [aux_sym__import_list_repeat1] = aux_sym__import_list_repeat1,
  [aux_sym_print_statement_repeat1] = aux_sym_print_statement_repeat1,
  [aux_sym_assert_statement_repeat1] = aux_sym_assert_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_match_statement_repeat1] = aux_sym_match_statement_repeat1,
  [aux_sym_match_statement_repeat2] = aux_sym_match_statement_repeat2,
  [aux_sym_case_clause_repeat1] = aux_sym_case_clause_repeat1,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_try_statement_repeat2] = aux_sym_try_statement_repeat2,
  [aux_sym_with_clause_repeat1] = aux_sym_with_clause_repeat1,
  [aux_sym_global_statement_repeat1] = aux_sym_global_statement_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_decorated_definition_repeat1] = aux_sym_decorated_definition_repeat1,
  [aux_sym_dotted_name_repeat1] = aux_sym_dotted_name_repeat1,
  [aux_sym__parameters_repeat1] = aux_sym__parameters_repeat1,
  [aux_sym__patterns_repeat1] = aux_sym__patterns_repeat1,
  [aux_sym_comparison_operator_repeat1] = aux_sym_comparison_operator_repeat1,
  [aux_sym_subscript_repeat1] = aux_sym_subscript_repeat1,
  [aux_sym_dictionary_repeat1] = aux_sym_dictionary_repeat1,
  [aux_sym__comprehension_clauses_repeat1] = aux_sym__comprehension_clauses_repeat1,
  [aux_sym__collection_elements_repeat1] = aux_sym__collection_elements_repeat1,
  [aux_sym_for_in_clause_repeat1] = aux_sym_for_in_clause_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_format_specifier_repeat1] = aux_sym_format_specifier_repeat1,
  [alias_sym_as_pattern_target] = alias_sym_as_pattern_target,
  [alias_sym_case_pattern] = alias_sym_case_pattern,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym___future__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_print] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_del] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_raise] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_except_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonlocal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lambda] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [sym_ellipsis] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__not_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_format_specifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_type_conversion] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_none] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym__string_start] = {
    .visible = true,
    .named = false,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym__string_end] = {
    .visible = true,
    .named = false,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_statements] = {
    .visible = false,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_relative_import] = {
    .visible = true,
    .named = true,
  },
  [sym_future_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_from_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__import_list] = {
    .visible = false,
    .named = true,
  },
  [sym_aliased_import] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard_import] = {
    .visible = true,
    .named = true,
  },
  [sym_print_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_chevron] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_named_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__named_expresssion_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_raise_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pass_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_match_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_except_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_except_group_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_global_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_nonlocal_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_exec_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_decorated_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_dotted_name] = {
    .visible = true,
    .named = true,
  },
  [sym__parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__patterns] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_as_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_within_for_in_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_not_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_within_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_list] = {
    .visible = true,
    .named = true,
  },
  [sym__right_hand_side] = {
    .visible = false,
    .named = true,
  },
  [sym_yield] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_slice] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_set_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__comprehension_clauses] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__collection_elements] = {
    .visible = false,
    .named = true,
  },
  [sym_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__f_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__escape_interpolation] = {
    .visible = false,
    .named = true,
  },
  [sym_format_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_format_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await] = {
    .visible = true,
    .named = true,
  },
  [sym_positional_separator] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_separator] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__import_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_print_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assert_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_with_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_decorated_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dotted_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comparison_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comprehension_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__collection_elements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_in_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_as_pattern_target] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_case_pattern] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_cause = 7,
  field_code = 8,
  field_condition = 9,
  field_consequence = 10,
  field_definition = 11,
  field_function = 12,
  field_guard = 13,
  field_key = 14,
  field_left = 15,
  field_module_name = 16,
  field_name = 17,
  field_object = 18,
  field_operator = 19,
  field_operators = 20,
  field_parameters = 21,
  field_pattern = 22,
  field_return_type = 23,
  field_right = 24,
  field_subject = 25,
  field_subscript = 26,
  field_superclasses = 27,
  field_type = 28,
  field_value = 29,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_cause] = "cause",
  [field_code] = "code",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_definition] = "definition",
  [field_function] = "function",
  [field_guard] = "guard",
  [field_key] = "key",
  [field_left] = "left",
  [field_module_name] = "module_name",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_operators] = "operators",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_subject] = "subject",
  [field_subscript] = "subscript",
  [field_superclasses] = "superclasses",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 1},
  [7] = {.index = 4, .length = 1},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 2},
  [10] = {.index = 9, .length = 1},
  [11] = {.index = 10, .length = 1},
  [12] = {.index = 11, .length = 2},
  [13] = {.index = 13, .length = 1},
  [14] = {.index = 14, .length = 2},
  [15] = {.index = 16, .length = 1},
  [16] = {.index = 17, .length = 1},
  [17] = {.index = 18, .length = 1},
  [18] = {.index = 19, .length = 2},
  [19] = {.index = 21, .length = 2},
  [20] = {.index = 23, .length = 2},
  [21] = {.index = 25, .length = 3},
  [22] = {.index = 28, .length = 1},
  [23] = {.index = 29, .length = 2},
  [24] = {.index = 31, .length = 1},
  [25] = {.index = 32, .length = 2},
  [26] = {.index = 34, .length = 1},
  [27] = {.index = 35, .length = 2},
  [28] = {.index = 37, .length = 2},
  [29] = {.index = 39, .length = 1},
  [30] = {.index = 40, .length = 2},
  [31] = {.index = 42, .length = 1},
  [33] = {.index = 43, .length = 1},
  [34] = {.index = 44, .length = 2},
  [35] = {.index = 46, .length = 1},
  [36] = {.index = 47, .length = 2},
  [37] = {.index = 49, .length = 2},
  [38] = {.index = 51, .length = 2},
  [39] = {.index = 53, .length = 1},
  [40] = {.index = 54, .length = 2},
  [41] = {.index = 56, .length = 2},
  [42] = {.index = 18, .length = 1},
  [43] = {.index = 58, .length = 1},
  [44] = {.index = 59, .length = 2},
  [45] = {.index = 61, .length = 1},
  [46] = {.index = 62, .length = 2},
  [47] = {.index = 64, .length = 2},
  [48] = {.index = 66, .length = 2},
  [49] = {.index = 68, .length = 2},
  [50] = {.index = 70, .length = 2},
  [51] = {.index = 72, .length = 2},
  [52] = {.index = 74, .length = 3},
  [53] = {.index = 77, .length = 3},
  [54] = {.index = 80, .length = 3},
  [55] = {.index = 83, .length = 3},
  [56] = {.index = 86, .length = 1},
  [57] = {.index = 87, .length = 3},
  [58] = {.index = 90, .length = 3},
  [59] = {.index = 93, .length = 2},
  [60] = {.index = 95, .length = 2},
  [61] = {.index = 97, .length = 3},
  [62] = {.index = 100, .length = 3},
  [63] = {.index = 103, .length = 3},
  [64] = {.index = 106, .length = 3},
  [65] = {.index = 19, .length = 2},
  [66] = {.index = 109, .length = 1},
  [67] = {.index = 110, .length = 3},
  [68] = {.index = 113, .length = 2},
  [69] = {.index = 115, .length = 1},
  [70] = {.index = 116, .length = 2},
  [71] = {.index = 118, .length = 2},
  [72] = {.index = 120, .length = 3},
  [73] = {.index = 123, .length = 4},
  [74] = {.index = 127, .length = 4},
  [75] = {.index = 131, .length = 4},
  [76] = {.index = 135, .length = 2},
  [77] = {.index = 137, .length = 3},
  [78] = {.index = 140, .length = 3},
  [79] = {.index = 143, .length = 4},
  [81] = {.index = 147, .length = 4},
  [82] = {.index = 151, .length = 4},
  [83] = {.index = 155, .length = 3},
  [84] = {.index = 158, .length = 2},
  [85] = {.index = 160, .length = 3},
  [86] = {.index = 163, .length = 1},
  [87] = {.index = 164, .length = 2},
  [88] = {.index = 166, .length = 2},
  [89] = {.index = 168, .length = 5},
  [90] = {.index = 173, .length = 3},
  [91] = {.index = 176, .length = 4},
  [92] = {.index = 180, .length = 4},
  [93] = {.index = 184, .length = 4},
  [95] = {.index = 188, .length = 4},
  [96] = {.index = 192, .length = 3},
  [97] = {.index = 195, .length = 2},
  [98] = {.index = 197, .length = 3},
  [99] = {.index = 200, .length = 3},
  [100] = {.index = 203, .length = 3},
  [101] = {.index = 206, .length = 4},
  [102] = {.index = 210, .length = 4},
  [103] = {.index = 214, .length = 4},
  [104] = {.index = 218, .length = 5},
  [105] = {.index = 223, .length = 5},
  [106] = {.index = 228, .length = 3},
  [107] = {.index = 231, .length = 3},
  [108] = {.index = 234, .length = 4},
  [109] = {.index = 238, .length = 3},
  [110] = {.index = 241, .length = 4},
  [111] = {.index = 245, .length = 4},
  [112] = {.index = 249, .length = 5},
  [113] = {.index = 254, .length = 5},
  [115] = {.index = 259, .length = 4},
  [116] = {.index = 263, .length = 4},
  [117] = {.index = 267, .length = 4},
  [118] = {.index = 271, .length = 5},
  [119] = {.index = 276, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1, .inherited = true},
  [1] =
    {field_name, 0},
  [2] =
    {field_argument, 1},
  [3] =
    {field_value, 0},
  [4] =
    {field_code, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_operators, 1, .inherited = true},
  [10] =
    {field_definition, 1},
  [11] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
  [13] =
    {field_argument, 2, .inherited = true},
  [14] =
    {field_argument, 1},
    {field_argument, 2, .inherited = true},
  [16] =
    {field_subject, 1},
  [17] =
    {field_cause, 2},
  [18] =
    {field_body, 2},
  [19] =
    {field_name, 0},
    {field_value, 2},
  [21] =
    {field_left, 0},
    {field_type, 2},
  [23] =
    {field_left, 0},
    {field_right, 2},
  [25] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [28] =
    {field_alias, 2},
  [29] =
    {field_attribute, 2},
    {field_object, 0},
  [31] =
    {field_operators, 0},
  [32] =
    {field_operators, 0, .inherited = true},
    {field_operators, 1, .inherited = true},
  [34] =
    {field_name, 1},
  [35] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [37] =
    {field_alias, 2},
    {field_name, 0},
  [39] =
    {field_name, 3, .inherited = true},
  [40] =
    {field_module_name, 1},
    {field_name, 3, .inherited = true},
  [42] =
    {field_module_name, 1},
  [43] =
    {field_body, 1},
  [44] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [46] =
    {field_alternative, 0},
  [47] =
    {field_alternative, 3, .inherited = true},
    {field_subject, 1},
  [49] =
    {field_subject, 1},
    {field_subject, 2, .inherited = true},
  [51] =
    {field_subject, 0, .inherited = true},
    {field_subject, 1, .inherited = true},
  [53] =
    {field_cause, 3},
  [54] =
    {field_condition, 1},
    {field_consequence, 3},
  [56] =
    {field_body, 3},
    {field_condition, 1},
  [58] =
    {field_body, 3},
  [59] =
    {field_body, 3},
    {field_name, 1},
  [61] =
    {field_type, 2},
  [62] =
    {field_body, 3},
    {field_parameters, 1},
  [64] =
    {field_key, 0},
    {field_value, 2},
  [66] =
    {field_subscript, 2},
    {field_value, 0},
  [68] =
    {field_operators, 0},
    {field_operators, 1},
  [70] =
    {field_alternative, 4, .inherited = true},
    {field_subject, 1},
  [72] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [74] =
    {field_alternative, 4, .inherited = true},
    {field_subject, 1},
    {field_subject, 2, .inherited = true},
  [77] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [80] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [83] =
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [86] =
    {field_body, 4},
  [87] =
    {field_alternative, 4},
    {field_body, 3},
    {field_condition, 1},
  [90] =
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [93] =
    {field_body, 2},
    {field_body, 3},
  [95] =
    {field_body, 3},
    {field_body, 4},
  [97] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [100] =
    {field_body, 3},
    {field_body, 4},
    {field_name, 1},
  [103] =
    {field_body, 4},
    {field_name, 1},
    {field_superclasses, 2},
  [106] =
    {field_left, 0},
    {field_right, 4},
    {field_type, 2},
  [109] =
    {field_subscript, 1},
  [110] =
    {field_subscript, 2},
    {field_subscript, 3, .inherited = true},
    {field_value, 0},
  [113] =
    {field_subscript, 0, .inherited = true},
    {field_subscript, 1, .inherited = true},
  [115] =
    {field_name, 4, .inherited = true},
  [116] =
    {field_module_name, 1},
    {field_name, 4, .inherited = true},
  [118] =
    {field_left, 1},
    {field_right, 3},
  [120] =
    {field_alternative, 5, .inherited = true},
    {field_subject, 1},
    {field_subject, 2, .inherited = true},
  [123] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [127] =
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [131] =
    {field_alternative, 5, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [135] =
    {field_body, 4},
    {field_body, 5},
  [137] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [140] =
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [143] =
    {field_alternative, 5},
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [147] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
  [151] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_superclasses, 2},
  [155] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 4},
  [158] =
    {field_left, 2},
    {field_right, 4},
  [160] =
    {field_left, 1},
    {field_right, 3},
    {field_right, 4},
  [163] =
    {field_pattern, 1},
  [164] =
    {field_consequence, 3},
    {field_pattern, 1},
  [166] =
    {field_pattern, 0, .inherited = true},
    {field_pattern, 1, .inherited = true},
  [168] =
    {field_alternative, 5, .inherited = true},
    {field_alternative, 6},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [173] =
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [176] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
  [180] =
    {field_alternative, 6},
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [184] =
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [188] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [192] =
    {field_left, 2},
    {field_right, 4},
    {field_right, 5},
  [195] =
    {field_consequence, 4},
    {field_pattern, 1},
  [197] =
    {field_consequence, 3},
    {field_consequence, 4},
    {field_pattern, 1},
  [200] =
    {field_consequence, 4},
    {field_guard, 2},
    {field_pattern, 1},
  [203] =
    {field_consequence, 4},
    {field_pattern, 1},
    {field_pattern, 2, .inherited = true},
  [206] =
    {field_alternative, 7},
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [210] =
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [214] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [218] =
    {field_alternative, 7},
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [223] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [228] =
    {field_consequence, 4},
    {field_consequence, 5},
    {field_pattern, 1},
  [231] =
    {field_consequence, 5},
    {field_guard, 3},
    {field_pattern, 1},
  [234] =
    {field_consequence, 4},
    {field_consequence, 5},
    {field_guard, 2},
    {field_pattern, 1},
  [238] =
    {field_consequence, 5},
    {field_pattern, 1},
    {field_pattern, 2, .inherited = true},
  [241] =
    {field_consequence, 4},
    {field_consequence, 5},
    {field_pattern, 1},
    {field_pattern, 2, .inherited = true},
  [245] =
    {field_consequence, 5},
    {field_guard, 3},
    {field_pattern, 1},
    {field_pattern, 2, .inherited = true},
  [249] =
    {field_alternative, 8},
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [254] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [259] =
    {field_consequence, 5},
    {field_consequence, 6},
    {field_guard, 3},
    {field_pattern, 1},
  [263] =
    {field_consequence, 5},
    {field_consequence, 6},
    {field_pattern, 1},
    {field_pattern, 2, .inherited = true},
  [267] =
    {field_consequence, 6},
    {field_guard, 4},
    {field_pattern, 1},
    {field_pattern, 2, .inherited = true},
  [271] =
    {field_consequence, 5},
    {field_consequence, 6},
    {field_guard, 3},
    {field_pattern, 1},
    {field_pattern, 2, .inherited = true},
  [276] =
    {field_consequence, 6},
    {field_consequence, 7},
    {field_guard, 4},
    {field_pattern, 1},
    {field_pattern, 2, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [4] = {
    [1] = sym_identifier,
  },
  [22] = {
    [2] = alias_sym_as_pattern_target,
  },
  [32] = {
    [1] = sym_parenthesized_expression,
  },
  [40] = {
    [3] = sym_block,
  },
  [41] = {
    [3] = sym_block,
  },
  [42] = {
    [2] = sym_block,
  },
  [43] = {
    [3] = sym_block,
  },
  [44] = {
    [3] = sym_block,
  },
  [53] = {
    [3] = sym_block,
  },
  [54] = {
    [3] = sym_block,
  },
  [56] = {
    [4] = sym_block,
  },
  [57] = {
    [3] = sym_block,
  },
  [61] = {
    [4] = sym_block,
  },
  [63] = {
    [4] = sym_block,
  },
  [65] = {
    [0] = sym_identifier,
  },
  [73] = {
    [3] = sym_block,
  },
  [77] = {
    [5] = sym_block,
  },
  [78] = {
    [5] = sym_block,
  },
  [80] = {
    [2] = sym_block,
  },
  [86] = {
    [1] = alias_sym_case_pattern,
  },
  [87] = {
    [1] = alias_sym_case_pattern,
    [3] = sym_block,
  },
  [90] = {
    [6] = sym_block,
  },
  [92] = {
    [5] = sym_block,
  },
  [94] = {
    [3] = sym_block,
  },
  [95] = {
    [6] = sym_block,
  },
  [97] = {
    [1] = alias_sym_case_pattern,
    [4] = sym_block,
  },
  [98] = {
    [1] = alias_sym_case_pattern,
  },
  [99] = {
    [1] = alias_sym_case_pattern,
    [4] = sym_block,
  },
  [100] = {
    [1] = alias_sym_case_pattern,
    [4] = sym_block,
  },
  [101] = {
    [6] = sym_block,
  },
  [103] = {
    [7] = sym_block,
  },
  [106] = {
    [1] = alias_sym_case_pattern,
  },
  [107] = {
    [1] = alias_sym_case_pattern,
    [5] = sym_block,
  },
  [108] = {
    [1] = alias_sym_case_pattern,
  },
  [109] = {
    [1] = alias_sym_case_pattern,
    [5] = sym_block,
  },
  [110] = {
    [1] = alias_sym_case_pattern,
  },
  [111] = {
    [1] = alias_sym_case_pattern,
    [5] = sym_block,
  },
  [114] = {
    [5] = sym_block,
  },
  [115] = {
    [1] = alias_sym_case_pattern,
  },
  [116] = {
    [1] = alias_sym_case_pattern,
  },
  [117] = {
    [1] = alias_sym_case_pattern,
    [6] = sym_block,
  },
  [118] = {
    [1] = alias_sym_case_pattern,
  },
  [119] = {
    [1] = alias_sym_case_pattern,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__simple_statements, 2,
    sym__simple_statements,
    sym_block,
  sym_parenthesized_list_splat, 2,
    sym_parenthesized_list_splat,
    sym_parenthesized_expression,
  sym_list_splat_pattern, 2,
    sym_list_splat_pattern,
    alias_sym_case_pattern,
  sym_expression, 3,
    sym_expression,
    alias_sym_as_pattern_target,
    alias_sym_case_pattern,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 7,
  [14] = 12,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 2,
  [23] = 23,
  [24] = 9,
  [25] = 25,
  [26] = 23,
  [27] = 10,
  [28] = 28,
  [29] = 19,
  [30] = 30,
  [31] = 4,
  [32] = 20,
  [33] = 8,
  [34] = 18,
  [35] = 5,
  [36] = 6,
  [37] = 37,
  [38] = 17,
  [39] = 39,
  [40] = 40,
  [41] = 25,
  [42] = 42,
  [43] = 30,
  [44] = 16,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 3,
  [50] = 50,
  [51] = 21,
  [52] = 52,
  [53] = 28,
  [54] = 54,
  [55] = 54,
  [56] = 50,
  [57] = 15,
  [58] = 11,
  [59] = 42,
  [60] = 46,
  [61] = 40,
  [62] = 52,
  [63] = 45,
  [64] = 37,
  [65] = 48,
  [66] = 47,
  [67] = 39,
  [68] = 68,
  [69] = 68,
  [70] = 70,
  [71] = 68,
  [72] = 68,
  [73] = 73,
  [74] = 68,
  [75] = 68,
  [76] = 73,
  [77] = 68,
  [78] = 78,
  [79] = 78,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 84,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 90,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 83,
  [103] = 103,
  [104] = 99,
  [105] = 105,
  [106] = 103,
  [107] = 107,
  [108] = 86,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 88,
  [113] = 113,
  [114] = 85,
  [115] = 115,
  [116] = 109,
  [117] = 111,
  [118] = 118,
  [119] = 119,
  [120] = 113,
  [121] = 96,
  [122] = 82,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 87,
  [127] = 118,
  [128] = 128,
  [129] = 107,
  [130] = 97,
  [131] = 125,
  [132] = 123,
  [133] = 128,
  [134] = 105,
  [135] = 115,
  [136] = 100,
  [137] = 91,
  [138] = 124,
  [139] = 101,
  [140] = 98,
  [141] = 110,
  [142] = 119,
  [143] = 94,
  [144] = 95,
  [145] = 92,
  [146] = 146,
  [147] = 147,
  [148] = 146,
  [149] = 146,
  [150] = 147,
  [151] = 146,
  [152] = 147,
  [153] = 147,
  [154] = 146,
  [155] = 146,
  [156] = 147,
  [157] = 147,
  [158] = 147,
  [159] = 146,
  [160] = 160,
  [161] = 161,
  [162] = 161,
  [163] = 163,
  [164] = 161,
  [165] = 161,
  [166] = 161,
  [167] = 81,
  [168] = 161,
  [169] = 161,
  [170] = 161,
  [171] = 163,
  [172] = 81,
  [173] = 173,
  [174] = 173,
  [175] = 175,
  [176] = 176,
  [177] = 175,
  [178] = 178,
  [179] = 179,
  [180] = 179,
  [181] = 181,
  [182] = 181,
  [183] = 181,
  [184] = 184,
  [185] = 181,
  [186] = 181,
  [187] = 179,
  [188] = 181,
  [189] = 179,
  [190] = 190,
  [191] = 190,
  [192] = 190,
  [193] = 190,
  [194] = 190,
  [195] = 190,
  [196] = 190,
  [197] = 190,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 200,
  [202] = 200,
  [203] = 200,
  [204] = 204,
  [205] = 205,
  [206] = 200,
  [207] = 200,
  [208] = 200,
  [209] = 200,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 212,
  [215] = 210,
  [216] = 216,
  [217] = 216,
  [218] = 211,
  [219] = 219,
  [220] = 220,
  [221] = 220,
  [222] = 212,
  [223] = 210,
  [224] = 210,
  [225] = 212,
  [226] = 213,
  [227] = 213,
  [228] = 219,
  [229] = 220,
  [230] = 219,
  [231] = 220,
  [232] = 211,
  [233] = 219,
  [234] = 216,
  [235] = 213,
  [236] = 211,
  [237] = 219,
  [238] = 211,
  [239] = 213,
  [240] = 216,
  [241] = 216,
  [242] = 210,
  [243] = 216,
  [244] = 211,
  [245] = 219,
  [246] = 220,
  [247] = 220,
  [248] = 219,
  [249] = 210,
  [250] = 212,
  [251] = 212,
  [252] = 213,
  [253] = 216,
  [254] = 220,
  [255] = 210,
  [256] = 220,
  [257] = 219,
  [258] = 210,
  [259] = 212,
  [260] = 212,
  [261] = 213,
  [262] = 216,
  [263] = 213,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 265,
  [269] = 267,
  [270] = 265,
  [271] = 267,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 276,
  [280] = 277,
  [281] = 273,
  [282] = 282,
  [283] = 282,
  [284] = 274,
  [285] = 285,
  [286] = 277,
  [287] = 273,
  [288] = 276,
  [289] = 278,
  [290] = 274,
  [291] = 291,
  [292] = 272,
  [293] = 278,
  [294] = 285,
  [295] = 295,
  [296] = 295,
  [297] = 297,
  [298] = 264,
  [299] = 264,
  [300] = 297,
  [301] = 295,
  [302] = 297,
  [303] = 297,
  [304] = 297,
  [305] = 305,
  [306] = 295,
  [307] = 297,
  [308] = 297,
  [309] = 295,
  [310] = 295,
  [311] = 295,
  [312] = 297,
  [313] = 313,
  [314] = 264,
  [315] = 295,
  [316] = 316,
  [317] = 316,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 316,
  [322] = 322,
  [323] = 318,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 316,
  [328] = 316,
  [329] = 326,
  [330] = 316,
  [331] = 320,
  [332] = 320,
  [333] = 316,
  [334] = 326,
  [335] = 320,
  [336] = 291,
  [337] = 326,
  [338] = 320,
  [339] = 316,
  [340] = 275,
  [341] = 326,
  [342] = 320,
  [343] = 326,
  [344] = 320,
  [345] = 320,
  [346] = 326,
  [347] = 326,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 350,
  [358] = 358,
  [359] = 348,
  [360] = 360,
  [361] = 360,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 364,
  [371] = 364,
  [372] = 354,
  [373] = 369,
  [374] = 366,
  [375] = 375,
  [376] = 362,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 377,
  [381] = 363,
  [382] = 291,
  [383] = 383,
  [384] = 362,
  [385] = 385,
  [386] = 386,
  [387] = 275,
  [388] = 388,
  [389] = 354,
  [390] = 367,
  [391] = 360,
  [392] = 358,
  [393] = 367,
  [394] = 367,
  [395] = 275,
  [396] = 367,
  [397] = 363,
  [398] = 291,
  [399] = 367,
  [400] = 367,
  [401] = 401,
  [402] = 367,
  [403] = 403,
  [404] = 385,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 275,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 418,
  [420] = 414,
  [421] = 417,
  [422] = 422,
  [423] = 423,
  [424] = 413,
  [425] = 423,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 415,
  [431] = 431,
  [432] = 416,
  [433] = 433,
  [434] = 291,
  [435] = 433,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 438,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 442,
  [450] = 450,
  [451] = 445,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 439,
  [456] = 456,
  [457] = 442,
  [458] = 442,
  [459] = 459,
  [460] = 445,
  [461] = 461,
  [462] = 438,
  [463] = 463,
  [464] = 464,
  [465] = 442,
  [466] = 466,
  [467] = 467,
  [468] = 439,
  [469] = 454,
  [470] = 439,
  [471] = 461,
  [472] = 459,
  [473] = 473,
  [474] = 453,
  [475] = 452,
  [476] = 445,
  [477] = 454,
  [478] = 478,
  [479] = 479,
  [480] = 445,
  [481] = 481,
  [482] = 481,
  [483] = 479,
  [484] = 438,
  [485] = 438,
  [486] = 486,
  [487] = 450,
  [488] = 488,
  [489] = 489,
  [490] = 453,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 464,
  [498] = 450,
  [499] = 499,
  [500] = 486,
  [501] = 452,
  [502] = 453,
  [503] = 454,
  [504] = 439,
  [505] = 493,
  [506] = 473,
  [507] = 442,
  [508] = 452,
  [509] = 454,
  [510] = 453,
  [511] = 452,
  [512] = 486,
  [513] = 453,
  [514] = 514,
  [515] = 439,
  [516] = 450,
  [517] = 438,
  [518] = 452,
  [519] = 445,
  [520] = 489,
  [521] = 438,
  [522] = 454,
  [523] = 453,
  [524] = 478,
  [525] = 493,
  [526] = 450,
  [527] = 463,
  [528] = 528,
  [529] = 467,
  [530] = 445,
  [531] = 463,
  [532] = 532,
  [533] = 442,
  [534] = 438,
  [535] = 535,
  [536] = 452,
  [537] = 486,
  [538] = 538,
  [539] = 450,
  [540] = 473,
  [541] = 494,
  [542] = 493,
  [543] = 488,
  [544] = 544,
  [545] = 486,
  [546] = 546,
  [547] = 544,
  [548] = 473,
  [549] = 450,
  [550] = 538,
  [551] = 445,
  [552] = 473,
  [553] = 473,
  [554] = 499,
  [555] = 555,
  [556] = 532,
  [557] = 557,
  [558] = 495,
  [559] = 478,
  [560] = 528,
  [561] = 450,
  [562] = 437,
  [563] = 473,
  [564] = 473,
  [565] = 442,
  [566] = 439,
  [567] = 452,
  [568] = 478,
  [569] = 439,
  [570] = 454,
  [571] = 453,
  [572] = 454,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 429,
  [577] = 577,
  [578] = 406,
  [579] = 579,
  [580] = 407,
  [581] = 408,
  [582] = 575,
  [583] = 431,
  [584] = 428,
  [585] = 577,
  [586] = 574,
  [587] = 579,
  [588] = 588,
  [589] = 412,
  [590] = 588,
  [591] = 573,
  [592] = 592,
  [593] = 593,
  [594] = 579,
  [595] = 595,
  [596] = 573,
  [597] = 597,
  [598] = 575,
  [599] = 575,
  [600] = 600,
  [601] = 601,
  [602] = 579,
  [603] = 577,
  [604] = 588,
  [605] = 573,
  [606] = 588,
  [607] = 577,
  [608] = 597,
  [609] = 609,
  [610] = 577,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 601,
  [617] = 617,
  [618] = 618,
  [619] = 619,
  [620] = 579,
  [621] = 588,
  [622] = 611,
  [623] = 615,
  [624] = 612,
  [625] = 579,
  [626] = 609,
  [627] = 613,
  [628] = 614,
  [629] = 575,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 595,
  [634] = 573,
  [635] = 600,
  [636] = 588,
  [637] = 637,
  [638] = 592,
  [639] = 593,
  [640] = 617,
  [641] = 575,
  [642] = 630,
  [643] = 573,
  [644] = 577,
  [645] = 632,
  [646] = 631,
  [647] = 637,
  [648] = 619,
  [649] = 618,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 653,
  [654] = 653,
  [655] = 655,
  [656] = 656,
  [657] = 657,
  [658] = 658,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 652,
  [663] = 650,
  [664] = 660,
  [665] = 661,
  [666] = 656,
  [667] = 651,
  [668] = 657,
  [669] = 655,
  [670] = 659,
  [671] = 658,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 677,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 684,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 688,
  [692] = 692,
  [693] = 693,
  [694] = 694,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 698,
  [699] = 699,
  [700] = 675,
  [701] = 701,
  [702] = 702,
  [703] = 695,
  [704] = 690,
  [705] = 705,
  [706] = 706,
  [707] = 707,
  [708] = 672,
  [709] = 707,
  [710] = 710,
  [711] = 711,
  [712] = 710,
  [713] = 711,
  [714] = 714,
  [715] = 680,
  [716] = 674,
  [717] = 714,
  [718] = 676,
  [719] = 677,
  [720] = 689,
  [721] = 679,
  [722] = 687,
  [723] = 686,
  [724] = 681,
  [725] = 685,
  [726] = 682,
  [727] = 684,
  [728] = 692,
  [729] = 693,
  [730] = 694,
  [731] = 696,
  [732] = 697,
  [733] = 698,
  [734] = 699,
  [735] = 701,
  [736] = 702,
  [737] = 705,
  [738] = 706,
  [739] = 683,
  [740] = 678,
  [741] = 673,
  [742] = 742,
  [743] = 743,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 747,
  [748] = 747,
  [749] = 746,
  [750] = 745,
  [751] = 744,
  [752] = 752,
  [753] = 752,
  [754] = 754,
  [755] = 755,
  [756] = 756,
  [757] = 742,
  [758] = 758,
  [759] = 754,
  [760] = 760,
  [761] = 761,
  [762] = 762,
  [763] = 755,
  [764] = 764,
  [765] = 765,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 743,
  [772] = 772,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 773,
  [777] = 777,
  [778] = 758,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 756,
  [783] = 783,
  [784] = 770,
  [785] = 779,
  [786] = 786,
  [787] = 765,
  [788] = 766,
  [789] = 760,
  [790] = 790,
  [791] = 762,
  [792] = 764,
  [793] = 767,
  [794] = 768,
  [795] = 786,
  [796] = 761,
  [797] = 775,
  [798] = 798,
  [799] = 777,
  [800] = 772,
  [801] = 780,
  [802] = 781,
  [803] = 783,
  [804] = 804,
  [805] = 805,
  [806] = 774,
  [807] = 804,
  [808] = 790,
  [809] = 769,
  [810] = 798,
  [811] = 805,
  [812] = 812,
  [813] = 812,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 819,
  [821] = 814,
  [822] = 818,
  [823] = 816,
  [824] = 815,
  [825] = 819,
  [826] = 817,
  [827] = 816,
  [828] = 828,
  [829] = 828,
  [830] = 828,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 832,
  [835] = 835,
  [836] = 836,
  [837] = 833,
  [838] = 833,
  [839] = 832,
  [840] = 835,
  [841] = 836,
  [842] = 831,
  [843] = 835,
  [844] = 831,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 835,
  [849] = 849,
  [850] = 850,
  [851] = 850,
  [852] = 852,
  [853] = 850,
  [854] = 846,
  [855] = 833,
  [856] = 833,
  [857] = 857,
  [858] = 858,
  [859] = 832,
  [860] = 846,
  [861] = 833,
  [862] = 849,
  [863] = 858,
  [864] = 864,
  [865] = 835,
  [866] = 832,
  [867] = 850,
  [868] = 857,
  [869] = 831,
  [870] = 832,
  [871] = 850,
  [872] = 850,
  [873] = 845,
  [874] = 831,
  [875] = 875,
  [876] = 831,
  [877] = 877,
  [878] = 852,
  [879] = 858,
  [880] = 847,
  [881] = 852,
  [882] = 864,
  [883] = 864,
  [884] = 847,
  [885] = 877,
  [886] = 845,
  [887] = 875,
  [888] = 877,
  [889] = 850,
  [890] = 849,
  [891] = 835,
  [892] = 875,
  [893] = 857,
  [894] = 850,
  [895] = 847,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 849,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 899,
  [905] = 899,
  [906] = 906,
  [907] = 899,
  [908] = 908,
  [909] = 909,
  [910] = 910,
  [911] = 896,
  [912] = 912,
  [913] = 913,
  [914] = 899,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 899,
  [919] = 899,
  [920] = 897,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 906,
  [925] = 899,
  [926] = 897,
  [927] = 832,
  [928] = 923,
  [929] = 835,
  [930] = 916,
  [931] = 915,
  [932] = 913,
  [933] = 912,
  [934] = 910,
  [935] = 909,
  [936] = 908,
  [937] = 833,
  [938] = 831,
  [939] = 832,
  [940] = 923,
  [941] = 917,
  [942] = 835,
  [943] = 916,
  [944] = 915,
  [945] = 913,
  [946] = 912,
  [947] = 896,
  [948] = 910,
  [949] = 909,
  [950] = 908,
  [951] = 901,
  [952] = 847,
  [953] = 864,
  [954] = 833,
  [955] = 831,
  [956] = 923,
  [957] = 917,
  [958] = 877,
  [959] = 916,
  [960] = 875,
  [961] = 923,
  [962] = 857,
  [963] = 858,
  [964] = 845,
  [965] = 846,
  [966] = 915,
  [967] = 913,
  [968] = 912,
  [969] = 896,
  [970] = 910,
  [971] = 909,
  [972] = 908,
  [973] = 901,
  [974] = 923,
  [975] = 916,
  [976] = 915,
  [977] = 913,
  [978] = 912,
  [979] = 896,
  [980] = 910,
  [981] = 909,
  [982] = 908,
  [983] = 849,
  [984] = 847,
  [985] = 864,
  [986] = 877,
  [987] = 875,
  [988] = 923,
  [989] = 857,
  [990] = 858,
  [991] = 845,
  [992] = 846,
  [993] = 916,
  [994] = 915,
  [995] = 913,
  [996] = 912,
  [997] = 896,
  [998] = 910,
  [999] = 909,
  [1000] = 908,
  [1001] = 852,
  [1002] = 903,
  [1003] = 902,
  [1004] = 849,
  [1005] = 852,
  [1006] = 864,
  [1007] = 877,
  [1008] = 875,
  [1009] = 923,
  [1010] = 857,
  [1011] = 858,
  [1012] = 845,
  [1013] = 846,
  [1014] = 916,
  [1015] = 915,
  [1016] = 913,
  [1017] = 912,
  [1018] = 916,
  [1019] = 896,
  [1020] = 910,
  [1021] = 909,
  [1022] = 908,
  [1023] = 915,
  [1024] = 908,
  [1025] = 909,
  [1026] = 910,
  [1027] = 896,
  [1028] = 912,
  [1029] = 902,
  [1030] = 903,
  [1031] = 913,
  [1032] = 852,
  [1033] = 877,
  [1034] = 1034,
  [1035] = 1035,
  [1036] = 1036,
  [1037] = 1037,
  [1038] = 1038,
  [1039] = 1039,
  [1040] = 1040,
  [1041] = 1041,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 1044,
  [1045] = 408,
  [1046] = 407,
  [1047] = 406,
  [1048] = 1048,
  [1049] = 901,
  [1050] = 1050,
  [1051] = 1036,
  [1052] = 1052,
  [1053] = 849,
  [1054] = 847,
  [1055] = 864,
  [1056] = 875,
  [1057] = 857,
  [1058] = 917,
  [1059] = 858,
  [1060] = 845,
  [1061] = 846,
  [1062] = 1062,
  [1063] = 431,
  [1064] = 428,
  [1065] = 1065,
  [1066] = 1066,
  [1067] = 1067,
  [1068] = 1034,
  [1069] = 1069,
  [1070] = 1070,
  [1071] = 852,
  [1072] = 849,
  [1073] = 847,
  [1074] = 864,
  [1075] = 877,
  [1076] = 875,
  [1077] = 857,
  [1078] = 858,
  [1079] = 845,
  [1080] = 846,
  [1081] = 852,
  [1082] = 903,
  [1083] = 902,
  [1084] = 428,
  [1085] = 431,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 408,
  [1089] = 407,
  [1090] = 406,
  [1091] = 1091,
  [1092] = 410,
  [1093] = 1093,
  [1094] = 917,
  [1095] = 1095,
  [1096] = 429,
  [1097] = 1070,
  [1098] = 429,
  [1099] = 1069,
  [1100] = 1066,
  [1101] = 1065,
  [1102] = 1052,
  [1103] = 1048,
  [1104] = 1043,
  [1105] = 1095,
  [1106] = 1039,
  [1107] = 412,
  [1108] = 1037,
  [1109] = 1035,
  [1110] = 1041,
  [1111] = 1042,
  [1112] = 1044,
  [1113] = 412,
  [1114] = 1093,
  [1115] = 1050,
  [1116] = 1091,
  [1117] = 902,
  [1118] = 1118,
  [1119] = 1062,
  [1120] = 903,
  [1121] = 902,
  [1122] = 428,
  [1123] = 431,
  [1124] = 1086,
  [1125] = 1087,
  [1126] = 408,
  [1127] = 407,
  [1128] = 406,
  [1129] = 1091,
  [1130] = 1093,
  [1131] = 1095,
  [1132] = 429,
  [1133] = 1118,
  [1134] = 1070,
  [1135] = 1069,
  [1136] = 1066,
  [1137] = 1065,
  [1138] = 1052,
  [1139] = 1048,
  [1140] = 1043,
  [1141] = 409,
  [1142] = 1039,
  [1143] = 412,
  [1144] = 1038,
  [1145] = 1037,
  [1146] = 1035,
  [1147] = 1087,
  [1148] = 1041,
  [1149] = 1042,
  [1150] = 917,
  [1151] = 1086,
  [1152] = 1044,
  [1153] = 1050,
  [1154] = 409,
  [1155] = 903,
  [1156] = 1118,
  [1157] = 901,
  [1158] = 901,
  [1159] = 1062,
  [1160] = 1038,
  [1161] = 1034,
  [1162] = 1067,
  [1163] = 1036,
  [1164] = 410,
  [1165] = 1067,
  [1166] = 1039,
  [1167] = 902,
  [1168] = 1062,
  [1169] = 1034,
  [1170] = 1039,
  [1171] = 456,
  [1172] = 1065,
  [1173] = 901,
  [1174] = 1095,
  [1175] = 1036,
  [1176] = 446,
  [1177] = 1050,
  [1178] = 1043,
  [1179] = 1091,
  [1180] = 1093,
  [1181] = 1034,
  [1182] = 1067,
  [1183] = 456,
  [1184] = 1042,
  [1185] = 1118,
  [1186] = 1041,
  [1187] = 1118,
  [1188] = 922,
  [1189] = 921,
  [1190] = 1039,
  [1191] = 1035,
  [1192] = 1048,
  [1193] = 1044,
  [1194] = 1035,
  [1195] = 1069,
  [1196] = 1095,
  [1197] = 1042,
  [1198] = 1041,
  [1199] = 1070,
  [1200] = 496,
  [1201] = 1067,
  [1202] = 1052,
  [1203] = 1035,
  [1204] = 1065,
  [1205] = 1034,
  [1206] = 903,
  [1207] = 1037,
  [1208] = 1038,
  [1209] = 1048,
  [1210] = 917,
  [1211] = 1066,
  [1212] = 1067,
  [1213] = 1069,
  [1214] = 1070,
  [1215] = 1036,
  [1216] = 412,
  [1217] = 1038,
  [1218] = 1066,
  [1219] = 1095,
  [1220] = 1037,
  [1221] = 1093,
  [1222] = 1091,
  [1223] = 1087,
  [1224] = 1086,
  [1225] = 1037,
  [1226] = 1044,
  [1227] = 1227,
  [1228] = 1062,
  [1229] = 1043,
  [1230] = 1118,
  [1231] = 1231,
  [1232] = 1048,
  [1233] = 901,
  [1234] = 1052,
  [1235] = 1065,
  [1236] = 1066,
  [1237] = 902,
  [1238] = 496,
  [1239] = 1069,
  [1240] = 1070,
  [1241] = 429,
  [1242] = 1038,
  [1243] = 903,
  [1244] = 1041,
  [1245] = 1042,
  [1246] = 1086,
  [1247] = 1093,
  [1248] = 1091,
  [1249] = 406,
  [1250] = 407,
  [1251] = 408,
  [1252] = 1087,
  [1253] = 1086,
  [1254] = 431,
  [1255] = 428,
  [1256] = 491,
  [1257] = 1087,
  [1258] = 1044,
  [1259] = 1043,
  [1260] = 446,
  [1261] = 491,
  [1262] = 1062,
  [1263] = 1050,
  [1264] = 917,
  [1265] = 1050,
  [1266] = 1052,
  [1267] = 1036,
  [1268] = 1039,
  [1269] = 1091,
  [1270] = 1270,
  [1271] = 1062,
  [1272] = 1118,
  [1273] = 496,
  [1274] = 1050,
  [1275] = 491,
  [1276] = 1276,
  [1277] = 1039,
  [1278] = 412,
  [1279] = 1038,
  [1280] = 1037,
  [1281] = 1035,
  [1282] = 1034,
  [1283] = 1067,
  [1284] = 1041,
  [1285] = 1040,
  [1286] = 1042,
  [1287] = 1044,
  [1288] = 1044,
  [1289] = 1042,
  [1290] = 1041,
  [1291] = 456,
  [1292] = 1035,
  [1293] = 428,
  [1294] = 1043,
  [1295] = 1048,
  [1296] = 431,
  [1297] = 1067,
  [1298] = 1034,
  [1299] = 1036,
  [1300] = 1037,
  [1301] = 1050,
  [1302] = 1038,
  [1303] = 1270,
  [1304] = 1052,
  [1305] = 1065,
  [1306] = 1066,
  [1307] = 1036,
  [1308] = 1118,
  [1309] = 412,
  [1310] = 1062,
  [1311] = 428,
  [1312] = 1069,
  [1313] = 431,
  [1314] = 446,
  [1315] = 1070,
  [1316] = 1086,
  [1317] = 1087,
  [1318] = 408,
  [1319] = 407,
  [1320] = 429,
  [1321] = 406,
  [1322] = 1091,
  [1323] = 1086,
  [1324] = 1087,
  [1325] = 408,
  [1326] = 1093,
  [1327] = 1095,
  [1328] = 407,
  [1329] = 406,
  [1330] = 429,
  [1331] = 1095,
  [1332] = 1093,
  [1333] = 1070,
  [1334] = 1069,
  [1335] = 1066,
  [1336] = 1065,
  [1337] = 1052,
  [1338] = 1043,
  [1339] = 1048,
  [1340] = 1231,
  [1341] = 1231,
  [1342] = 1227,
  [1343] = 1227,
  [1344] = 1344,
  [1345] = 1345,
  [1346] = 1345,
  [1347] = 1345,
  [1348] = 1344,
  [1349] = 1344,
  [1350] = 1344,
  [1351] = 1345,
  [1352] = 1344,
  [1353] = 1231,
  [1354] = 1344,
  [1355] = 1227,
  [1356] = 1345,
  [1357] = 1357,
  [1358] = 1358,
  [1359] = 1345,
  [1360] = 1360,
  [1361] = 1345,
  [1362] = 446,
  [1363] = 1344,
  [1364] = 446,
  [1365] = 1344,
  [1366] = 1231,
  [1367] = 456,
  [1368] = 1368,
  [1369] = 1369,
  [1370] = 1227,
  [1371] = 1371,
  [1372] = 491,
  [1373] = 1368,
  [1374] = 1276,
  [1375] = 456,
  [1376] = 1360,
  [1377] = 1345,
  [1378] = 496,
  [1379] = 1276,
  [1380] = 1368,
  [1381] = 1358,
  [1382] = 491,
  [1383] = 496,
  [1384] = 1384,
  [1385] = 1385,
  [1386] = 1386,
  [1387] = 1387,
  [1388] = 1384,
  [1389] = 1384,
  [1390] = 1390,
  [1391] = 1385,
  [1392] = 1384,
  [1393] = 1384,
  [1394] = 1384,
  [1395] = 1384,
  [1396] = 1385,
  [1397] = 1397,
  [1398] = 1398,
  [1399] = 1384,
  [1400] = 1400,
  [1401] = 1401,
  [1402] = 1402,
  [1403] = 1403,
  [1404] = 1401,
  [1405] = 1402,
  [1406] = 1406,
  [1407] = 1406,
  [1408] = 1408,
  [1409] = 1408,
  [1410] = 1408,
  [1411] = 1408,
  [1412] = 1408,
  [1413] = 1408,
  [1414] = 1408,
  [1415] = 1408,
  [1416] = 1416,
  [1417] = 1417,
  [1418] = 1418,
  [1419] = 1416,
  [1420] = 1416,
  [1421] = 1418,
  [1422] = 1417,
  [1423] = 1416,
  [1424] = 1418,
  [1425] = 1417,
  [1426] = 1417,
  [1427] = 1416,
  [1428] = 1418,
  [1429] = 1416,
  [1430] = 1417,
  [1431] = 1418,
  [1432] = 1418,
  [1433] = 1417,
  [1434] = 1416,
  [1435] = 1418,
  [1436] = 1417,
  [1437] = 1417,
  [1438] = 1438,
  [1439] = 1418,
  [1440] = 1416,
  [1441] = 1441,
  [1442] = 1442,
  [1443] = 1442,
  [1444] = 1442,
  [1445] = 1445,
  [1446] = 1442,
  [1447] = 1442,
  [1448] = 1441,
  [1449] = 1449,
  [1450] = 1442,
  [1451] = 1442,
  [1452] = 1441,
  [1453] = 1441,
  [1454] = 1441,
  [1455] = 1441,
  [1456] = 1441,
  [1457] = 1441,
  [1458] = 1442,
  [1459] = 1442,
  [1460] = 1441,
  [1461] = 1461,
  [1462] = 1462,
  [1463] = 1463,
  [1464] = 1464,
  [1465] = 1465,
  [1466] = 1466,
  [1467] = 1467,
  [1468] = 1462,
  [1469] = 1469,
  [1470] = 1470,
  [1471] = 1463,
  [1472] = 1472,
  [1473] = 1462,
  [1474] = 1464,
  [1475] = 1475,
  [1476] = 1469,
  [1477] = 1466,
  [1478] = 1466,
  [1479] = 1479,
  [1480] = 1464,
  [1481] = 1465,
  [1482] = 1469,
  [1483] = 1467,
  [1484] = 1475,
  [1485] = 1470,
  [1486] = 1486,
  [1487] = 1465,
  [1488] = 1463,
  [1489] = 1467,
  [1490] = 1472,
  [1491] = 1475,
  [1492] = 1492,
  [1493] = 1472,
  [1494] = 1470,
  [1495] = 1495,
  [1496] = 1496,
  [1497] = 1497,
  [1498] = 1462,
  [1499] = 1470,
  [1500] = 1472,
  [1501] = 1469,
  [1502] = 1469,
  [1503] = 1462,
  [1504] = 1472,
  [1505] = 1505,
  [1506] = 1461,
  [1507] = 1463,
  [1508] = 1466,
  [1509] = 1509,
  [1510] = 1475,
  [1511] = 1511,
  [1512] = 1512,
  [1513] = 1470,
  [1514] = 1465,
  [1515] = 1511,
  [1516] = 1463,
  [1517] = 1517,
  [1518] = 1475,
  [1519] = 1519,
  [1520] = 1512,
  [1521] = 1465,
  [1522] = 1466,
  [1523] = 1486,
  [1524] = 1511,
  [1525] = 1464,
  [1526] = 1526,
  [1527] = 1462,
  [1528] = 1467,
  [1529] = 1529,
  [1530] = 1530,
  [1531] = 1512,
  [1532] = 1467,
  [1533] = 1526,
  [1534] = 1464,
  [1535] = 1470,
  [1536] = 1511,
  [1537] = 1464,
  [1538] = 1511,
  [1539] = 1465,
  [1540] = 1463,
  [1541] = 1472,
  [1542] = 1475,
  [1543] = 1496,
  [1544] = 1544,
  [1545] = 1511,
  [1546] = 1517,
  [1547] = 1505,
  [1548] = 1548,
  [1549] = 1466,
  [1550] = 1467,
  [1551] = 1519,
  [1552] = 1505,
  [1553] = 1553,
  [1554] = 1554,
  [1555] = 1511,
  [1556] = 1495,
  [1557] = 1517,
  [1558] = 1469,
  [1559] = 1511,
  [1560] = 1560,
  [1561] = 1561,
  [1562] = 1562,
  [1563] = 1462,
  [1564] = 1564,
  [1565] = 1565,
  [1566] = 1566,
  [1567] = 1469,
  [1568] = 1465,
  [1569] = 1463,
  [1570] = 1475,
  [1571] = 1571,
  [1572] = 1572,
  [1573] = 1561,
  [1574] = 1461,
  [1575] = 1562,
  [1576] = 1576,
  [1577] = 1577,
  [1578] = 1472,
  [1579] = 1579,
  [1580] = 1580,
  [1581] = 1581,
  [1582] = 1571,
  [1583] = 1466,
  [1584] = 1584,
  [1585] = 1464,
  [1586] = 1467,
  [1587] = 1464,
  [1588] = 1588,
  [1589] = 1561,
  [1590] = 1584,
  [1591] = 1475,
  [1592] = 1576,
  [1593] = 1466,
  [1594] = 1461,
  [1595] = 1562,
  [1596] = 1470,
  [1597] = 1580,
  [1598] = 1571,
  [1599] = 1571,
  [1600] = 1571,
  [1601] = 1472,
  [1602] = 1571,
  [1603] = 1580,
  [1604] = 1604,
  [1605] = 1470,
  [1606] = 1606,
  [1607] = 1462,
  [1608] = 1608,
  [1609] = 1571,
  [1610] = 1467,
  [1611] = 1611,
  [1612] = 1581,
  [1613] = 1571,
  [1614] = 1469,
  [1615] = 1465,
  [1616] = 1616,
  [1617] = 1588,
  [1618] = 1576,
  [1619] = 1463,
  [1620] = 1620,
  [1621] = 1588,
  [1622] = 1564,
  [1623] = 1486,
  [1624] = 1624,
  [1625] = 1625,
  [1626] = 1492,
  [1627] = 1627,
  [1628] = 1628,
  [1629] = 1629,
  [1630] = 1630,
  [1631] = 1631,
  [1632] = 1627,
  [1633] = 1625,
  [1634] = 1634,
  [1635] = 1635,
  [1636] = 1486,
  [1637] = 1637,
  [1638] = 1638,
  [1639] = 1635,
  [1640] = 1640,
  [1641] = 1641,
  [1642] = 1631,
  [1643] = 1643,
  [1644] = 1644,
  [1645] = 1629,
  [1646] = 1646,
  [1647] = 1492,
  [1648] = 1643,
  [1649] = 1649,
  [1650] = 1492,
  [1651] = 1651,
  [1652] = 1635,
  [1653] = 1653,
  [1654] = 1654,
  [1655] = 1655,
  [1656] = 1638,
  [1657] = 1653,
  [1658] = 1658,
  [1659] = 1659,
  [1660] = 1628,
  [1661] = 1661,
  [1662] = 1553,
  [1663] = 1486,
  [1664] = 1664,
  [1665] = 1628,
  [1666] = 1666,
  [1667] = 1630,
  [1668] = 1646,
  [1669] = 1669,
  [1670] = 1670,
  [1671] = 1671,
  [1672] = 1672,
  [1673] = 1631,
  [1674] = 1625,
  [1675] = 1629,
  [1676] = 1646,
  [1677] = 1661,
  [1678] = 1638,
  [1679] = 1679,
  [1680] = 1576,
  [1681] = 1681,
  [1682] = 1679,
  [1683] = 1683,
  [1684] = 1684,
  [1685] = 1685,
  [1686] = 1683,
  [1687] = 1683,
  [1688] = 1688,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 1691,
  [1692] = 1664,
  [1693] = 1693,
  [1694] = 1683,
  [1695] = 1695,
  [1696] = 1696,
  [1697] = 1697,
  [1698] = 1698,
  [1699] = 1672,
  [1700] = 1696,
  [1701] = 1701,
  [1702] = 1702,
  [1703] = 1703,
  [1704] = 1704,
  [1705] = 1705,
  [1706] = 1697,
  [1707] = 1707,
  [1708] = 1708,
  [1709] = 1683,
  [1710] = 1683,
  [1711] = 1711,
  [1712] = 1712,
  [1713] = 1713,
  [1714] = 1698,
  [1715] = 1707,
  [1716] = 1698,
  [1717] = 1711,
  [1718] = 1649,
  [1719] = 1693,
  [1720] = 1690,
  [1721] = 1690,
  [1722] = 1697,
  [1723] = 1641,
  [1724] = 1683,
  [1725] = 1725,
  [1726] = 1683,
  [1727] = 1727,
  [1728] = 1691,
  [1729] = 1685,
  [1730] = 1634,
  [1731] = 1705,
  [1732] = 1732,
  [1733] = 1733,
  [1734] = 1734,
  [1735] = 1735,
  [1736] = 1736,
  [1737] = 1712,
  [1738] = 1738,
  [1739] = 1739,
  [1740] = 1689,
  [1741] = 1741,
  [1742] = 1708,
  [1743] = 1743,
  [1744] = 1744,
  [1745] = 1745,
  [1746] = 1704,
  [1747] = 1701,
  [1748] = 1748,
  [1749] = 1749,
  [1750] = 1750,
  [1751] = 1751,
  [1752] = 1752,
  [1753] = 1753,
  [1754] = 1754,
  [1755] = 1755,
  [1756] = 1756,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 1759,
  [1760] = 1760,
  [1761] = 1761,
  [1762] = 1762,
  [1763] = 1763,
  [1764] = 1764,
  [1765] = 1765,
  [1766] = 1766,
  [1767] = 1767,
  [1768] = 573,
  [1769] = 1769,
  [1770] = 1770,
  [1771] = 1771,
  [1772] = 1772,
  [1773] = 1773,
  [1774] = 1763,
  [1775] = 1763,
  [1776] = 1776,
  [1777] = 1634,
  [1778] = 1764,
  [1779] = 1779,
  [1780] = 1780,
  [1781] = 1369,
  [1782] = 1641,
  [1783] = 1664,
  [1784] = 1784,
  [1785] = 1761,
  [1786] = 1786,
  [1787] = 1759,
  [1788] = 1788,
  [1789] = 1789,
  [1790] = 1790,
  [1791] = 1765,
  [1792] = 1738,
  [1793] = 1793,
  [1794] = 1794,
  [1795] = 1795,
  [1796] = 1796,
  [1797] = 1672,
  [1798] = 901,
  [1799] = 1766,
  [1800] = 1800,
  [1801] = 1801,
  [1802] = 1769,
  [1803] = 917,
  [1804] = 1804,
  [1805] = 1805,
  [1806] = 1804,
  [1807] = 1634,
  [1808] = 1808,
  [1809] = 1809,
  [1810] = 1810,
  [1811] = 1811,
  [1812] = 1641,
  [1813] = 1813,
  [1814] = 1767,
  [1815] = 1815,
  [1816] = 1793,
  [1817] = 1817,
  [1818] = 1818,
  [1819] = 1796,
  [1820] = 1820,
  [1821] = 1805,
  [1822] = 1808,
  [1823] = 1823,
  [1824] = 1824,
  [1825] = 1765,
  [1826] = 1826,
  [1827] = 1800,
  [1828] = 1828,
  [1829] = 1773,
  [1830] = 1830,
  [1831] = 1831,
  [1832] = 588,
  [1833] = 1795,
  [1834] = 1794,
  [1835] = 1369,
  [1836] = 1790,
  [1837] = 1818,
  [1838] = 1763,
  [1839] = 1773,
  [1840] = 1817,
  [1841] = 1641,
  [1842] = 1764,
  [1843] = 1764,
  [1844] = 1815,
  [1845] = 1818,
  [1846] = 1817,
  [1847] = 1815,
  [1848] = 1813,
  [1849] = 1813,
  [1850] = 1786,
  [1851] = 1808,
  [1852] = 1852,
  [1853] = 1788,
  [1854] = 1789,
  [1855] = 1634,
  [1856] = 1805,
  [1857] = 1804,
  [1858] = 1766,
  [1859] = 1786,
  [1860] = 1796,
  [1861] = 1766,
  [1862] = 1764,
  [1863] = 579,
  [1864] = 1864,
  [1865] = 1865,
  [1866] = 575,
  [1867] = 1804,
  [1868] = 1805,
  [1869] = 1808,
  [1870] = 1805,
  [1871] = 1808,
  [1872] = 1804,
  [1873] = 1793,
  [1874] = 1818,
  [1875] = 1817,
  [1876] = 1813,
  [1877] = 1877,
  [1878] = 1815,
  [1879] = 1815,
  [1880] = 1817,
  [1881] = 1818,
  [1882] = 1772,
  [1883] = 1813,
  [1884] = 1766,
  [1885] = 1649,
  [1886] = 577,
  [1887] = 1808,
  [1888] = 1748,
  [1889] = 1889,
  [1890] = 1805,
  [1891] = 1891,
  [1892] = 1763,
  [1893] = 1804,
  [1894] = 1750,
  [1895] = 1811,
  [1896] = 1764,
  [1897] = 1770,
  [1898] = 1766,
  [1899] = 1789,
  [1900] = 1786,
  [1901] = 1901,
  [1902] = 1764,
  [1903] = 1903,
  [1904] = 1786,
  [1905] = 1795,
  [1906] = 1763,
  [1907] = 1794,
  [1908] = 1789,
  [1909] = 1818,
  [1910] = 1817,
  [1911] = 1815,
  [1912] = 1813,
  [1913] = 1913,
  [1914] = 1831,
  [1915] = 1766,
  [1916] = 1818,
  [1917] = 1817,
  [1918] = 1815,
  [1919] = 1813,
  [1920] = 1891,
  [1921] = 1804,
  [1922] = 1805,
  [1923] = 1923,
  [1924] = 1808,
  [1925] = 1808,
  [1926] = 1789,
  [1927] = 1805,
  [1928] = 1789,
  [1929] = 1813,
  [1930] = 1786,
  [1931] = 1815,
  [1932] = 1804,
  [1933] = 1817,
  [1934] = 1818,
  [1935] = 1935,
  [1936] = 1766,
  [1937] = 1786,
  [1938] = 1935,
  [1939] = 1743,
  [1940] = 1789,
  [1941] = 1771,
  [1942] = 1786,
  [1943] = 1764,
  [1944] = 1779,
  [1945] = 1763,
  [1946] = 1788,
  [1947] = 1947,
  [1948] = 1830,
  [1949] = 1949,
  [1950] = 1390,
  [1951] = 1951,
  [1952] = 1952,
  [1953] = 1953,
  [1954] = 1954,
  [1955] = 1955,
  [1956] = 1956,
  [1957] = 1684,
  [1958] = 1958,
  [1959] = 1959,
  [1960] = 1386,
  [1961] = 1961,
  [1962] = 1684,
  [1963] = 1397,
  [1964] = 1952,
  [1965] = 1965,
  [1966] = 1398,
  [1967] = 1959,
  [1968] = 1968,
  [1969] = 1969,
  [1970] = 1970,
  [1971] = 1968,
  [1972] = 1972,
  [1973] = 1973,
  [1974] = 1390,
  [1975] = 1684,
  [1976] = 1958,
  [1977] = 1977,
  [1978] = 1386,
  [1979] = 1397,
  [1980] = 1980,
  [1981] = 1981,
  [1982] = 1982,
  [1983] = 1983,
  [1984] = 1949,
  [1985] = 1776,
  [1986] = 1947,
  [1987] = 1956,
  [1988] = 1988,
  [1989] = 1989,
  [1990] = 1990,
  [1991] = 1398,
  [1992] = 1992,
  [1993] = 1969,
  [1994] = 1994,
  [1995] = 1972,
  [1996] = 1961,
  [1997] = 1997,
  [1998] = 1972,
  [1999] = 1999,
  [2000] = 1970,
  [2001] = 1980,
  [2002] = 1828,
  [2003] = 1969,
  [2004] = 2004,
  [2005] = 2005,
  [2006] = 1955,
  [2007] = 1708,
  [2008] = 2008,
  [2009] = 1970,
  [2010] = 2010,
  [2011] = 2011,
  [2012] = 2012,
  [2013] = 2013,
  [2014] = 2014,
  [2015] = 2015,
  [2016] = 2016,
  [2017] = 2017,
  [2018] = 2018,
  [2019] = 2019,
  [2020] = 2020,
  [2021] = 2019,
  [2022] = 2022,
  [2023] = 2023,
  [2024] = 2024,
  [2025] = 2018,
  [2026] = 2026,
  [2027] = 2027,
  [2028] = 2017,
  [2029] = 2029,
  [2030] = 2030,
  [2031] = 2027,
  [2032] = 2014,
  [2033] = 2033,
  [2034] = 2016,
  [2035] = 2035,
  [2036] = 2036,
  [2037] = 2029,
  [2038] = 2038,
  [2039] = 2039,
  [2040] = 2040,
  [2041] = 2041,
  [2042] = 2014,
  [2043] = 2033,
  [2044] = 2044,
  [2045] = 2035,
  [2046] = 2046,
  [2047] = 2047,
  [2048] = 2033,
  [2049] = 2049,
  [2050] = 2050,
  [2051] = 2035,
  [2052] = 2052,
  [2053] = 2053,
  [2054] = 2054,
  [2055] = 2015,
  [2056] = 2033,
  [2057] = 2016,
  [2058] = 2058,
  [2059] = 2018,
  [2060] = 2019,
  [2061] = 2020,
  [2062] = 2014,
  [2063] = 2063,
  [2064] = 2023,
  [2065] = 2026,
  [2066] = 2027,
  [2067] = 2017,
  [2068] = 2029,
  [2069] = 2029,
  [2070] = 2014,
  [2071] = 2033,
  [2072] = 2035,
  [2073] = 2017,
  [2074] = 2027,
  [2075] = 2026,
  [2076] = 2023,
  [2077] = 2077,
  [2078] = 2053,
  [2079] = 2023,
  [2080] = 2053,
  [2081] = 2020,
  [2082] = 2082,
  [2083] = 2019,
  [2084] = 2018,
  [2085] = 2085,
  [2086] = 2016,
  [2087] = 2087,
  [2088] = 2016,
  [2089] = 2026,
  [2090] = 2036,
  [2091] = 2053,
  [2092] = 2027,
  [2093] = 2017,
  [2094] = 2029,
  [2095] = 2054,
  [2096] = 2024,
  [2097] = 2050,
  [2098] = 2014,
  [2099] = 2099,
  [2100] = 2100,
  [2101] = 2101,
  [2102] = 2102,
  [2103] = 2103,
  [2104] = 2104,
  [2105] = 2105,
  [2106] = 2017,
  [2107] = 2020,
  [2108] = 2033,
  [2109] = 2044,
  [2110] = 2110,
  [2111] = 2111,
  [2112] = 2040,
  [2113] = 2026,
  [2114] = 2049,
  [2115] = 2035,
  [2116] = 2116,
  [2117] = 2052,
  [2118] = 2104,
  [2119] = 2027,
  [2120] = 2120,
  [2121] = 2035,
  [2122] = 2063,
  [2123] = 2018,
  [2124] = 2124,
  [2125] = 2082,
  [2126] = 2126,
  [2127] = 2127,
  [2128] = 2128,
  [2129] = 2085,
  [2130] = 2099,
  [2131] = 2103,
  [2132] = 2035,
  [2133] = 2110,
  [2134] = 2134,
  [2135] = 2111,
  [2136] = 2033,
  [2137] = 2126,
  [2138] = 2128,
  [2139] = 2026,
  [2140] = 2023,
  [2141] = 2023,
  [2142] = 2014,
  [2143] = 2143,
  [2144] = 2029,
  [2145] = 2015,
  [2146] = 2017,
  [2147] = 2049,
  [2148] = 2050,
  [2149] = 2099,
  [2150] = 2027,
  [2151] = 2102,
  [2152] = 2020,
  [2153] = 2026,
  [2154] = 2035,
  [2155] = 2019,
  [2156] = 2033,
  [2157] = 2014,
  [2158] = 2018,
  [2159] = 2023,
  [2160] = 2020,
  [2161] = 2019,
  [2162] = 2018,
  [2163] = 2020,
  [2164] = 2029,
  [2165] = 2116,
  [2166] = 2017,
  [2167] = 2027,
  [2168] = 2016,
  [2169] = 2054,
  [2170] = 2053,
  [2171] = 2019,
  [2172] = 2172,
  [2173] = 2053,
  [2174] = 2174,
  [2175] = 2175,
  [2176] = 2026,
  [2177] = 2116,
  [2178] = 2178,
  [2179] = 2023,
  [2180] = 2016,
  [2181] = 2020,
  [2182] = 2174,
  [2183] = 2183,
  [2184] = 2184,
  [2185] = 2185,
  [2186] = 2172,
  [2187] = 2053,
  [2188] = 2019,
  [2189] = 2018,
  [2190] = 2053,
  [2191] = 2185,
  [2192] = 2039,
  [2193] = 2193,
  [2194] = 2030,
  [2195] = 2041,
  [2196] = 2101,
  [2197] = 2105,
  [2198] = 2143,
  [2199] = 2101,
  [2200] = 2029,
  [2201] = 2016,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 931
            ? (c < 748
              ? (c < 192
                ? (c < 170
                  ? (c < 'a'
                    ? (c >= 'A' && c <= '_')
                    : c <= 'z')
                  : (c <= 170 || (c < 186
                    ? c == 181
                    : c <= 186)))
                : (c <= 214 || (c < 710
                  ? (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)
                  : (c <= 721 || (c >= 736 && c <= 740)))))
              : (c <= 748 || (c < 895
                ? (c < 886
                  ? (c < 880
                    ? c == 750
                    : c <= 884)
                  : (c <= 887 || (c >= 891 && c <= 893)))
                : (c <= 895 || (c < 908
                  ? (c < 904
                    ? c == 902
                    : c <= 906)
                  : (c <= 908 || (c >= 910 && c <= 929)))))))
            : (c <= 1013 || (c < 1649
              ? (c < 1376
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1015 && c <= 1153)
                    : c <= 1327)
                  : (c <= 1366 || c == 1369))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 43514
    ? (c < 4193
      ? (c < 2707
        ? (c < 1994
          ? (c < 910
            ? (c < 736
              ? (c < 186
                ? (c < 'a'
                  ? (c < '_'
                    ? (c >= 'A' && c <= 'Z')
                    : c <= '_')
                  : (c <= 'z' || (c < 181
                    ? c == 170
                    : c <= 181)))
                : (c <= 186 || (c < 248
                  ? (c < 216
                    ? (c >= 192 && c <= 214)
                    : c <= 246)
                  : (c <= 705 || (c >= 710 && c <= 721)))))
              : (c <= 740 || (c < 891
                ? (c < 880
                  ? (c < 750
                    ? c == 748
                    : c <= 750)
                  : (c <= 884 || (c >= 886 && c <= 887)))
                : (c <= 893 || (c < 904
                  ? (c < 902
                    ? c == 895
                    : c <= 902)
                  : (c <= 906 || c == 908))))))
            : (c <= 929 || (c < 1649
              ? (c < 1376
                ? (c < 1162
                  ? (c < 1015
                    ? (c >= 931 && c <= 1013)
                    : c <= 1153)
                  : (c <= 1327 || (c < 1369
                    ? (c >= 1329 && c <= 1366)
                    : c <= 1369)))
                : (c <= 1416 || (c < 1568
                  ? (c < 1519
                    ? (c >= 1488 && c <= 1514)
                    : c <= 1522)
                  : (c <= 1610 || (c >= 1646 && c <= 1647)))))
              : (c <= 1747 || (c < 1791
                ? (c < 1774
                  ? (c < 1765
                    ? c == 1749
                    : c <= 1766)
                  : (c <= 1775 || (c >= 1786 && c <= 1788)))
                : (c <= 1791 || (c < 1869
                  ? (c < 1810
                    ? c == 1808
                    : c <= 1839)
                  : (c <= 1957 || c == 1969))))))))
          : (c <= 2026 || (c < 2482
            ? (c < 2208
              ? (c < 2088
                ? (c < 2048
                  ? (c < 2042
                    ? (c >= 2036 && c <= 2037)
                    : c <= 2042)
                  : (c <= 2069 || (c < 2084
                    ? c == 2074
                    : c <= 2084)))
                : (c <= 2088 || (c < 2160
                  ? (c < 2144
                    ? (c >= 2112 && c <= 2136)
                    : c <= 2154)
                  : (c <= 2183 || (c >= 2185 && c <= 2190)))))
              : (c <= 2249 || (c < 2417
                ? (c < 2384
                  ? (c < 2365
                    ? (c >= 2308 && c <= 2361)
                    : c <= 2365)
                  : (c <= 2384 || (c >= 2392 && c <= 2401)))
                : (c <= 2432 || (c < 2451
                  ? (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)
                  : (c <= 2472 || (c >= 2474 && c <= 2480)))))))
            : (c <= 2482 || (c < 2579
              ? (c < 2527
                ? (c < 2510
                  ? (c < 2493
                    ? (c >= 2486 && c <= 2489)
                    : c <= 2493)
                  : (c <= 2510 || (c >= 2524 && c <= 2525)))
                : (c <= 2529 || (c < 2565
                  ? (c < 2556
                    ? (c >= 2544 && c <= 2545)
                    : c <= 2556)
                  : (c <= 2570 || (c >= 2575 && c <= 2576)))))
              : (c <= 2600 || (c < 2649
                ? (c < 2613
                  ? (c < 2610
                    ? (c >= 2602 && c <= 2608)
                    : c <= 2611)
                  : (c <= 2614 || (c >= 2616 && c <= 2617)))
                : (c <= 2652 || (c < 2693
                  ? (c < 2674
                    ? c == 2654
                    : c <= 2676)
                  : (c <= 2701 || (c >= 2703 && c <= 2705)))))))))))
        : (c <= 2728 || (c < 3242
          ? (c < 2962
            ? (c < 2858
              ? (c < 2784
                ? (c < 2741
                  ? (c < 2738
                    ? (c >= 2730 && c <= 2736)
                    : c <= 2739)
                  : (c <= 2745 || (c < 2768
                    ? c == 2749
                    : c <= 2768)))
                : (c <= 2785 || (c < 2831
                  ? (c < 2821
                    ? c == 2809
                    : c <= 2828)
                  : (c <= 2832 || (c >= 2835 && c <= 2856)))))
              : (c <= 2864 || (c < 2911
                ? (c < 2877
                  ? (c < 2869
                    ? (c >= 2866 && c <= 2867)
                    : c <= 2873)
                  : (c <= 2877 || (c >= 2908 && c <= 2909)))
                : (c <= 2913 || (c < 2949
                  ? (c < 2947
                    ? c == 2929
                    : c <= 2947)
                  : (c <= 2954 || (c >= 2958 && c <= 2960)))))))
            : (c <= 2965 || (c < 3090
              ? (c < 2984
                ? (c < 2974
                  ? (c < 2972
                    ? (c >= 2969 && c <= 2970)
                    : c <= 2972)
                  : (c <= 2975 || (c >= 2979 && c <= 2980)))
                : (c <= 2986 || (c < 3077
                  ? (c < 3024
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3024)
                  : (c <= 3084 || (c >= 3086 && c <= 3088)))))
              : (c <= 3112 || (c < 3168
                ? (c < 3160
                  ? (c < 3133
                    ? (c >= 3114 && c <= 3129)
                    : c <= 3133)
                  : (c <= 3162 || c == 3165))
                : (c <= 3169 || (c < 3214
                  ? (c < 3205
                    ? c == 3200
                    : c <= 3212)
                  : (c <= 3216 || (c >= 3218 && c <= 3240)))))))))
          : (c <= 3251 || (c < 3648
            ? (c < 3412
              ? (c < 3332
                ? (c < 3293
                  ? (c < 3261
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3261)
                  : (c <= 3294 || (c < 3313
                    ? (c >= 3296 && c <= 3297)
                    : c <= 3314)))
                : (c <= 3340 || (c < 3389
                  ? (c < 3346
                    ? (c >= 3342 && c <= 3344)
                    : c <= 3386)
                  : (c <= 3389 || c == 3406))))
              : (c <= 3414 || (c < 3507
                ? (c < 3461
                  ? (c < 3450
                    ? (c >= 3423 && c <= 3425)
                    : c <= 3455)
                  : (c <= 3478 || (c >= 3482 && c <= 3505)))
                : (c <= 3515 || (c < 3585
                  ? (c < 3520
                    ? c == 3517
                    : c <= 3526)
                  : (c <= 3632 || c == 3634))))))
            : (c <= 3654 || (c < 3782
              ? (c < 3749
                ? (c < 3718
                  ? (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)
                  : (c <= 3722 || (c >= 3724 && c <= 3747)))
                : (c <= 3749 || (c < 3773
                  ? (c < 3762
                    ? (c >= 3751 && c <= 3760)
                    : c <= 3762)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))
              : (c <= 3782 || (c < 3976
                ? (c < 3904
                  ? (c < 3840
                    ? (c >= 3804 && c <= 3807)
                    : c <= 3840)
                  : (c <= 3911 || (c >= 3913 && c <= 3948)))
                : (c <= 3980 || (c < 4176
                  ? (c < 4159
                    ? (c >= 4096 && c <= 4138)
                    : c <= 4159)
                  : (c <= 4181 || (c >= 4186 && c <= 4189)))))))))))))
      : (c <= 4193 || (c < 8134
        ? (c < 6176
          ? (c < 4808
            ? (c < 4688
              ? (c < 4295
                ? (c < 4213
                  ? (c < 4206
                    ? (c >= 4197 && c <= 4198)
                    : c <= 4208)
                  : (c <= 4225 || (c < 4256
                    ? c == 4238
                    : c <= 4293)))
                : (c <= 4295 || (c < 4348
                  ? (c < 4304
                    ? c == 4301
                    : c <= 4346)
                  : (c <= 4680 || (c >= 4682 && c <= 4685)))))
              : (c <= 4694 || (c < 4752
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c >= 4746 && c <= 4749)))
                : (c <= 4784 || (c < 4800
                  ? (c < 4792
                    ? (c >= 4786 && c <= 4789)
                    : c <= 4798)
                  : (c <= 4800 || (c >= 4802 && c <= 4805)))))))
            : (c <= 4822 || (c < 5792
              ? (c < 5024
                ? (c < 4888
                  ? (c < 4882
                    ? (c >= 4824 && c <= 4880)
                    : c <= 4885)
                  : (c <= 4954 || (c >= 4992 && c <= 5007)))
                : (c <= 5109 || (c < 5743
                  ? (c < 5121
                    ? (c >= 5112 && c <= 5117)
                    : c <= 5740)
                  : (c <= 5759 || (c >= 5761 && c <= 5786)))))
              : (c <= 5866 || (c < 5984
                ? (c < 5919
                  ? (c < 5888
                    ? (c >= 5870 && c <= 5880)
                    : c <= 5905)
                  : (c <= 5937 || (c >= 5952 && c <= 5969)))
                : (c <= 5996 || (c < 6103
                  ? (c < 6016
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6067)
                  : (c <= 6103 || c == 6108))))))))
          : (c <= 6264 || (c < 7312
            ? (c < 6823
              ? (c < 6512
                ? (c < 6320
                  ? (c < 6314
                    ? (c >= 6272 && c <= 6312)
                    : c <= 6314)
                  : (c <= 6389 || (c < 6480
                    ? (c >= 6400 && c <= 6430)
                    : c <= 6509)))
                : (c <= 6516 || (c < 6656
                  ? (c < 6576
                    ? (c >= 6528 && c <= 6571)
                    : c <= 6601)
                  : (c <= 6678 || (c >= 6688 && c <= 6740)))))
              : (c <= 6823 || (c < 7098
                ? (c < 7043
                  ? (c < 6981
                    ? (c >= 6917 && c <= 6963)
                    : c <= 6988)
                  : (c <= 7072 || (c >= 7086 && c <= 7087)))
                : (c <= 7141 || (c < 7258
                  ? (c < 7245
                    ? (c >= 7168 && c <= 7203)
                    : c <= 7247)
                  : (c <= 7293 || (c >= 7296 && c <= 7304)))))))
            : (c <= 7354 || (c < 8008
              ? (c < 7418
                ? (c < 7406
                  ? (c < 7401
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7404)
                  : (c <= 7411 || (c >= 7413 && c <= 7414)))
                : (c <= 7418 || (c < 7960
                  ? (c < 7680
                    ? (c >= 7424 && c <= 7615)
                    : c <= 7957)
                  : (c <= 7965 || (c >= 7968 && c <= 8005)))))
              : (c <= 8013 || (c < 8031
                ? (c < 8027
                  ? (c < 8025
                    ? (c >= 8016 && c <= 8023)
                    : c <= 8025)
                  : (c <= 8027 || c == 8029))
                : (c <= 8061 || (c < 8126
                  ? (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)
                  : (c <= 8126 || (c >= 8130 && c <= 8132)))))))))))
        : (c <= 8140 || (c < 12337
          ? (c < 8544
            ? (c < 8458
              ? (c < 8305
                ? (c < 8160
                  ? (c < 8150
                    ? (c >= 8144 && c <= 8147)
                    : c <= 8155)
                  : (c <= 8172 || (c < 8182
                    ? (c >= 8178 && c <= 8180)
                    : c <= 8188)))
                : (c <= 8305 || (c < 8450
                  ? (c < 8336
                    ? c == 8319
                    : c <= 8348)
                  : (c <= 8450 || c == 8455))))
              : (c <= 8467 || (c < 8488
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || c == 8486))
                : (c <= 8488 || (c < 8517
                  ? (c < 8508
                    ? (c >= 8490 && c <= 8505)
                    : c <= 8511)
                  : (c <= 8521 || c == 8526))))))
            : (c <= 8584 || (c < 11680
              ? (c < 11559
                ? (c < 11506
                  ? (c < 11499
                    ? (c >= 11264 && c <= 11492)
                    : c <= 11502)
                  : (c <= 11507 || (c >= 11520 && c <= 11557)))
                : (c <= 11559 || (c < 11631
                  ? (c < 11568
                    ? c == 11565
                    : c <= 11623)
                  : (c <= 11631 || (c >= 11648 && c <= 11670)))))
              : (c <= 11686 || (c < 11720
                ? (c < 11704
                  ? (c < 11696
                    ? (c >= 11688 && c <= 11694)
                    : c <= 11702)
                  : (c <= 11710 || (c >= 11712 && c <= 11718)))
                : (c <= 11726 || (c < 12293
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 12295 || (c >= 12321 && c <= 12329)))))))))
          : (c <= 12341 || (c < 42891
            ? (c < 19968
              ? (c < 12549
                ? (c < 12445
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12447 || (c < 12540
                    ? (c >= 12449 && c <= 12538)
                    : c <= 12543)))
                : (c <= 12591 || (c < 12784
                  ? (c < 12704
                    ? (c >= 12593 && c <= 12686)
                    : c <= 12735)
                  : (c <= 12799 || (c >= 13312 && c <= 19903)))))
              : (c <= 42124 || (c < 42560
                ? (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42527 || (c >= 42538 && c <= 42539)))
                : (c <= 42606 || (c < 42775
                  ? (c < 42656
                    ? (c >= 42623 && c <= 42653)
                    : c <= 42735)
                  : (c <= 42783 || (c >= 42786 && c <= 42888)))))))
            : (c <= 42954 || (c < 43250
              ? (c < 43011
                ? (c < 42965
                  ? (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)
                  : (c <= 42969 || (c >= 42994 && c <= 43009)))
                : (c <= 43013 || (c < 43072
                  ? (c < 43020
                    ? (c >= 43015 && c <= 43018)
                    : c <= 43042)
                  : (c <= 43123 || (c >= 43138 && c <= 43187)))))
              : (c <= 43255 || (c < 43360
                ? (c < 43274
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43262)
                  : (c <= 43301 || (c >= 43312 && c <= 43334)))
                : (c <= 43388 || (c < 43488
                  ? (c < 43471
                    ? (c >= 43396 && c <= 43442)
                    : c <= 43471)
                  : (c <= 43492 || (c >= 43494 && c <= 43503)))))))))))))))
    : (c <= 43518 || (c < 70727
      ? (c < 66956
        ? (c < 64914
          ? (c < 43868
            ? (c < 43714
              ? (c < 43646
                ? (c < 43588
                  ? (c < 43584
                    ? (c >= 43520 && c <= 43560)
                    : c <= 43586)
                  : (c <= 43595 || (c < 43642
                    ? (c >= 43616 && c <= 43638)
                    : c <= 43642)))
                : (c <= 43695 || (c < 43705
                  ? (c < 43701
                    ? c == 43697
                    : c <= 43702)
                  : (c <= 43709 || c == 43712))))
              : (c <= 43714 || (c < 43785
                ? (c < 43762
                  ? (c < 43744
                    ? (c >= 43739 && c <= 43741)
                    : c <= 43754)
                  : (c <= 43764 || (c >= 43777 && c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c >= 43824 && c <= 43866)))))))
            : (c <= 43881 || (c < 64287
              ? (c < 63744
                ? (c < 55216
                  ? (c < 44032
                    ? (c >= 43888 && c <= 44002)
                    : c <= 55203)
                  : (c <= 55238 || (c >= 55243 && c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || c == 64285))))
              : (c <= 64296 || (c < 64323
                ? (c < 64318
                  ? (c < 64312
                    ? (c >= 64298 && c <= 64310)
                    : c <= 64316)
                  : (c <= 64318 || (c >= 64320 && c <= 64321)))
                : (c <= 64324 || (c < 64612
                  ? (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)
                  : (c <= 64829 || (c >= 64848 && c <= 64911)))))))))
          : (c <= 64967 || (c < 65599
            ? (c < 65382
              ? (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65008 && c <= 65017)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65313
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65338 || (c >= 65345 && c <= 65370)))))
              : (c <= 65437 || (c < 65498
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65440 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c >= 65490 && c <= 65495)))
                : (c <= 65500 || (c < 65576
                  ? (c < 65549
                    ? (c >= 65536 && c <= 65547)
                    : c <= 65574)
                  : (c <= 65594 || (c >= 65596 && c <= 65597)))))))
            : (c <= 65613 || (c < 66464
              ? (c < 66208
                ? (c < 65856
                  ? (c < 65664
                    ? (c >= 65616 && c <= 65629)
                    : c <= 65786)
                  : (c <= 65908 || (c >= 66176 && c <= 66204)))
                : (c <= 66256 || (c < 66384
                  ? (c < 66349
                    ? (c >= 66304 && c <= 66335)
                    : c <= 66378)
                  : (c <= 66421 || (c >= 66432 && c <= 66461)))))
              : (c <= 66499 || (c < 66776
                ? (c < 66560
                  ? (c < 66513
                    ? (c >= 66504 && c <= 66511)
                    : c <= 66517)
                  : (c <= 66717 || (c >= 66736 && c <= 66771)))
                : (c <= 66811 || (c < 66928
                  ? (c < 66864
                    ? (c >= 66816 && c <= 66855)
                    : c <= 66915)
                  : (c <= 66938 || (c >= 66940 && c <= 66954)))))))))))
        : (c <= 66962 || (c < 68864
          ? (c < 67828
            ? (c < 67506
              ? (c < 67072
                ? (c < 66979
                  ? (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)
                  : (c <= 66993 || (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)))
                : (c <= 67382 || (c < 67456
                  ? (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)
                  : (c <= 67461 || (c >= 67463 && c <= 67504)))))
              : (c <= 67514 || (c < 67644
                ? (c < 67594
                  ? (c < 67592
                    ? (c >= 67584 && c <= 67589)
                    : c <= 67592)
                  : (c <= 67637 || (c >= 67639 && c <= 67640)))
                : (c <= 67644 || (c < 67712
                  ? (c < 67680
                    ? (c >= 67647 && c <= 67669)
                    : c <= 67702)
                  : (c <= 67742 || (c >= 67808 && c <= 67826)))))))
            : (c <= 67829 || (c < 68224
              ? (c < 68096
                ? (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c >= 68030 && c <= 68031)))
                : (c <= 68096 || (c < 68121
                  ? (c < 68117
                    ? (c >= 68112 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c >= 68192 && c <= 68220)))))
              : (c <= 68252 || (c < 68448
                ? (c < 68352
                  ? (c < 68297
                    ? (c >= 68288 && c <= 68295)
                    : c <= 68324)
                  : (c <= 68405 || (c >= 68416 && c <= 68437)))
                : (c <= 68466 || (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c >= 68800 && c <= 68850)))))))))
          : (c <= 68899 || (c < 70106
            ? (c < 69749
              ? (c < 69488
                ? (c < 69376
                  ? (c < 69296
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69297)
                  : (c <= 69404 || (c < 69424
                    ? c == 69415
                    : c <= 69445)))
                : (c <= 69505 || (c < 69635
                  ? (c < 69600
                    ? (c >= 69552 && c <= 69572)
                    : c <= 69622)
                  : (c <= 69687 || (c >= 69745 && c <= 69746)))))
              : (c <= 69749 || (c < 69959
                ? (c < 69891
                  ? (c < 69840
                    ? (c >= 69763 && c <= 69807)
                    : c <= 69864)
                  : (c <= 69926 || c == 69956))
                : (c <= 69959 || (c < 70019
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70002)
                    : c <= 70006)
                  : (c <= 70066 || (c >= 70081 && c <= 70084)))))))
            : (c <= 70106 || (c < 70405
              ? (c < 70280
                ? (c < 70163
                  ? (c < 70144
                    ? c == 70108
                    : c <= 70161)
                  : (c <= 70187 || (c >= 70272 && c <= 70278)))
                : (c <= 70280 || (c < 70303
                  ? (c < 70287
                    ? (c >= 70282 && c <= 70285)
                    : c <= 70301)
                  : (c <= 70312 || (c >= 70320 && c <= 70366)))))
              : (c <= 70412 || (c < 70453
                ? (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c >= 70450 && c <= 70451)))
                : (c <= 70457 || (c < 70493
                  ? (c < 70480
                    ? c == 70461
                    : c <= 70480)
                  : (c <= 70497 || (c >= 70656 && c <= 70708)))))))))))))
      : (c <= 70730 || (c < 119894
        ? (c < 73056
          ? (c < 72001
            ? (c < 71424
              ? (c < 71128
                ? (c < 70852
                  ? (c < 70784
                    ? (c >= 70751 && c <= 70753)
                    : c <= 70831)
                  : (c <= 70853 || (c < 71040
                    ? c == 70855
                    : c <= 71086)))
                : (c <= 71131 || (c < 71296
                  ? (c < 71236
                    ? (c >= 71168 && c <= 71215)
                    : c <= 71236)
                  : (c <= 71338 || c == 71352))))
              : (c <= 71450 || (c < 71945
                ? (c < 71840
                  ? (c < 71680
                    ? (c >= 71488 && c <= 71494)
                    : c <= 71723)
                  : (c <= 71903 || (c >= 71935 && c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71983 || c == 71999))))))
            : (c <= 72001 || (c < 72349
              ? (c < 72192
                ? (c < 72161
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72144)
                  : (c <= 72161 || c == 72163))
                : (c <= 72192 || (c < 72272
                  ? (c < 72250
                    ? (c >= 72203 && c <= 72242)
                    : c <= 72250)
                  : (c <= 72272 || (c >= 72284 && c <= 72329)))))
              : (c <= 72349 || (c < 72818
                ? (c < 72714
                  ? (c < 72704
                    ? (c >= 72368 && c <= 72440)
                    : c <= 72712)
                  : (c <= 72750 || c == 72768))
                : (c <= 72847 || (c < 72971
                  ? (c < 72968
                    ? (c >= 72960 && c <= 72966)
                    : c <= 72969)
                  : (c <= 73008 || c == 73030))))))))
          : (c <= 73061 || (c < 93952
            ? (c < 82944
              ? (c < 73728
                ? (c < 73112
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73097)
                  : (c <= 73112 || (c < 73648
                    ? (c >= 73440 && c <= 73458)
                    : c <= 73648)))
                : (c <= 74649 || (c < 77712
                  ? (c < 74880
                    ? (c >= 74752 && c <= 74862)
                    : c <= 75075)
                  : (c <= 77808 || (c >= 77824 && c <= 78894)))))
              : (c <= 83526 || (c < 92928
                ? (c < 92784
                  ? (c < 92736
                    ? (c >= 92160 && c <= 92728)
                    : c <= 92766)
                  : (c <= 92862 || (c >= 92880 && c <= 92909)))
                : (c <= 92975 || (c < 93053
                  ? (c < 93027
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93047)
                  : (c <= 93071 || (c >= 93760 && c <= 93823)))))))
            : (c <= 94026 || (c < 110589
              ? (c < 94208
                ? (c < 94176
                  ? (c < 94099
                    ? c == 94032
                    : c <= 94111)
                  : (c <= 94177 || c == 94179))
                : (c <= 100343 || (c < 110576
                  ? (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)
                  : (c <= 110579 || (c >= 110581 && c <= 110587)))))
              : (c <= 110590 || (c < 113664
                ? (c < 110948
                  ? (c < 110928
                    ? (c >= 110592 && c <= 110882)
                    : c <= 110930)
                  : (c <= 110951 || (c >= 110960 && c <= 111355)))
                : (c <= 113770 || (c < 113808
                  ? (c < 113792
                    ? (c >= 113776 && c <= 113788)
                    : c <= 113800)
                  : (c <= 113817 || (c >= 119808 && c <= 119892)))))))))))
        : (c <= 119964 || (c < 125259
          ? (c < 120572
            ? (c < 120086
              ? (c < 119995
                ? (c < 119973
                  ? (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)
                  : (c <= 119974 || (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)))
                : (c <= 119995 || (c < 120071
                  ? (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)
                  : (c <= 120074 || (c >= 120077 && c <= 120084)))))
              : (c <= 120092 || (c < 120138
                ? (c < 120128
                  ? (c < 120123
                    ? (c >= 120094 && c <= 120121)
                    : c <= 120126)
                  : (c <= 120132 || c == 120134))
                : (c <= 120144 || (c < 120514
                  ? (c < 120488
                    ? (c >= 120146 && c <= 120485)
                    : c <= 120512)
                  : (c <= 120538 || (c >= 120540 && c <= 120570)))))))
            : (c <= 120596 || (c < 123191
              ? (c < 120714
                ? (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c >= 120688 && c <= 120712)))
                : (c <= 120744 || (c < 122624
                  ? (c < 120772
                    ? (c >= 120746 && c <= 120770)
                    : c <= 120779)
                  : (c <= 122654 || (c >= 123136 && c <= 123180)))))
              : (c <= 123197 || (c < 124904
                ? (c < 123584
                  ? (c < 123536
                    ? c == 123214
                    : c <= 123565)
                  : (c <= 123627 || (c >= 124896 && c <= 124902)))
                : (c <= 124907 || (c < 124928
                  ? (c < 124912
                    ? (c >= 124909 && c <= 124910)
                    : c <= 124926)
                  : (c <= 125124 || (c >= 125184 && c <= 125251)))))))))
          : (c <= 125259 || (c < 126559
            ? (c < 126535
              ? (c < 126505
                ? (c < 126497
                  ? (c < 126469
                    ? (c >= 126464 && c <= 126467)
                    : c <= 126495)
                  : (c <= 126498 || (c < 126503
                    ? c == 126500
                    : c <= 126503)))
                : (c <= 126514 || (c < 126523
                  ? (c < 126521
                    ? (c >= 126516 && c <= 126519)
                    : c <= 126521)
                  : (c <= 126523 || c == 126530))))
              : (c <= 126535 || (c < 126548
                ? (c < 126541
                  ? (c < 126539
                    ? c == 126537
                    : c <= 126539)
                  : (c <= 126543 || (c >= 126545 && c <= 126546)))
                : (c <= 126548 || (c < 126555
                  ? (c < 126553
                    ? c == 126551
                    : c <= 126553)
                  : (c <= 126555 || c == 126557))))))
            : (c <= 126559 || (c < 126625
              ? (c < 126580
                ? (c < 126567
                  ? (c < 126564
                    ? (c >= 126561 && c <= 126562)
                    : c <= 126564)
                  : (c <= 126570 || (c >= 126572 && c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c >= 126603 && c <= 126619)))))
              : (c <= 126627 || (c < 177984
                ? (c < 131072
                  ? (c < 126635
                    ? (c >= 126629 && c <= 126633)
                    : c <= 126651)
                  : (c <= 173791 || (c >= 173824 && c <= 177976)))
                : (c <= 178205 || (c < 194560
                  ? (c < 183984
                    ? (c >= 178208 && c <= 183969)
                    : c <= 191456)
                  : (c <= 195101 || (c >= 196608 && c <= 201546)))))))))))))))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 43616
    ? (c < 3782
      ? (c < 2748
        ? (c < 2045
          ? (c < 1015
            ? (c < 710
              ? (c < 181
                ? (c < '_'
                  ? (c < 'A'
                    ? (c >= '0' && c <= '9')
                    : c <= 'Z')
                  : (c <= '_' || (c < 170
                    ? (c >= 'a' && c <= 'z')
                    : c <= 170)))
                : (c <= 181 || (c < 192
                  ? (c < 186
                    ? c == 183
                    : c <= 186)
                  : (c <= 214 || (c < 248
                    ? (c >= 216 && c <= 246)
                    : c <= 705)))))
              : (c <= 721 || (c < 891
                ? (c < 750
                  ? (c < 748
                    ? (c >= 736 && c <= 740)
                    : c <= 748)
                  : (c <= 750 || (c < 886
                    ? (c >= 768 && c <= 884)
                    : c <= 887)))
                : (c <= 893 || (c < 908
                  ? (c < 902
                    ? c == 895
                    : c <= 906)
                  : (c <= 908 || (c < 931
                    ? (c >= 910 && c <= 929)
                    : c <= 1013)))))))
            : (c <= 1153 || (c < 1519
              ? (c < 1425
                ? (c < 1329
                  ? (c < 1162
                    ? (c >= 1155 && c <= 1159)
                    : c <= 1327)
                  : (c <= 1366 || (c < 1376
                    ? c == 1369
                    : c <= 1416)))
                : (c <= 1469 || (c < 1476
                  ? (c < 1473
                    ? c == 1471
                    : c <= 1474)
                  : (c <= 1477 || (c < 1488
                    ? c == 1479
                    : c <= 1514)))))
              : (c <= 1522 || (c < 1770
                ? (c < 1646
                  ? (c < 1568
                    ? (c >= 1552 && c <= 1562)
                    : c <= 1641)
                  : (c <= 1747 || (c < 1759
                    ? (c >= 1749 && c <= 1756)
                    : c <= 1768)))
                : (c <= 1788 || (c < 1869
                  ? (c < 1808
                    ? c == 1791
                    : c <= 1866)
                  : (c <= 1969 || (c < 2042
                    ? (c >= 1984 && c <= 2037)
                    : c <= 2042)))))))))
          : (c <= 2045 || (c < 2558
            ? (c < 2451
              ? (c < 2200
                ? (c < 2144
                  ? (c < 2112
                    ? (c >= 2048 && c <= 2093)
                    : c <= 2139)
                  : (c <= 2154 || (c < 2185
                    ? (c >= 2160 && c <= 2183)
                    : c <= 2190)))
                : (c <= 2273 || (c < 2417
                  ? (c < 2406
                    ? (c >= 2275 && c <= 2403)
                    : c <= 2415)
                  : (c <= 2435 || (c < 2447
                    ? (c >= 2437 && c <= 2444)
                    : c <= 2448)))))
              : (c <= 2472 || (c < 2507
                ? (c < 2486
                  ? (c < 2482
                    ? (c >= 2474 && c <= 2480)
                    : c <= 2482)
                  : (c <= 2489 || (c < 2503
                    ? (c >= 2492 && c <= 2500)
                    : c <= 2504)))
                : (c <= 2510 || (c < 2527
                  ? (c < 2524
                    ? c == 2519
                    : c <= 2525)
                  : (c <= 2531 || (c < 2556
                    ? (c >= 2534 && c <= 2545)
                    : c <= 2556)))))))
            : (c <= 2558 || (c < 2635
              ? (c < 2610
                ? (c < 2575
                  ? (c < 2565
                    ? (c >= 2561 && c <= 2563)
                    : c <= 2570)
                  : (c <= 2576 || (c < 2602
                    ? (c >= 2579 && c <= 2600)
                    : c <= 2608)))
                : (c <= 2611 || (c < 2620
                  ? (c < 2616
                    ? (c >= 2613 && c <= 2614)
                    : c <= 2617)
                  : (c <= 2620 || (c < 2631
                    ? (c >= 2622 && c <= 2626)
                    : c <= 2632)))))
              : (c <= 2637 || (c < 2693
                ? (c < 2654
                  ? (c < 2649
                    ? c == 2641
                    : c <= 2652)
                  : (c <= 2654 || (c < 2689
                    ? (c >= 2662 && c <= 2677)
                    : c <= 2691)))
                : (c <= 2701 || (c < 2730
                  ? (c < 2707
                    ? (c >= 2703 && c <= 2705)
                    : c <= 2728)
                  : (c <= 2736 || (c < 2741
                    ? (c >= 2738 && c <= 2739)
                    : c <= 2745)))))))))))
        : (c <= 2757 || (c < 3168
          ? (c < 2958
            ? (c < 2866
              ? (c < 2809
                ? (c < 2768
                  ? (c < 2763
                    ? (c >= 2759 && c <= 2761)
                    : c <= 2765)
                  : (c <= 2768 || (c < 2790
                    ? (c >= 2784 && c <= 2787)
                    : c <= 2799)))
                : (c <= 2815 || (c < 2831
                  ? (c < 2821
                    ? (c >= 2817 && c <= 2819)
                    : c <= 2828)
                  : (c <= 2832 || (c < 2858
                    ? (c >= 2835 && c <= 2856)
                    : c <= 2864)))))
              : (c <= 2867 || (c < 2908
                ? (c < 2887
                  ? (c < 2876
                    ? (c >= 2869 && c <= 2873)
                    : c <= 2884)
                  : (c <= 2888 || (c < 2901
                    ? (c >= 2891 && c <= 2893)
                    : c <= 2903)))
                : (c <= 2909 || (c < 2929
                  ? (c < 2918
                    ? (c >= 2911 && c <= 2915)
                    : c <= 2927)
                  : (c <= 2929 || (c < 2949
                    ? (c >= 2946 && c <= 2947)
                    : c <= 2954)))))))
            : (c <= 2960 || (c < 3031
              ? (c < 2984
                ? (c < 2972
                  ? (c < 2969
                    ? (c >= 2962 && c <= 2965)
                    : c <= 2970)
                  : (c <= 2972 || (c < 2979
                    ? (c >= 2974 && c <= 2975)
                    : c <= 2980)))
                : (c <= 2986 || (c < 3014
                  ? (c < 3006
                    ? (c >= 2990 && c <= 3001)
                    : c <= 3010)
                  : (c <= 3016 || (c < 3024
                    ? (c >= 3018 && c <= 3021)
                    : c <= 3024)))))
              : (c <= 3031 || (c < 3132
                ? (c < 3086
                  ? (c < 3072
                    ? (c >= 3046 && c <= 3055)
                    : c <= 3084)
                  : (c <= 3088 || (c < 3114
                    ? (c >= 3090 && c <= 3112)
                    : c <= 3129)))
                : (c <= 3140 || (c < 3157
                  ? (c < 3146
                    ? (c >= 3142 && c <= 3144)
                    : c <= 3149)
                  : (c <= 3158 || (c < 3165
                    ? (c >= 3160 && c <= 3162)
                    : c <= 3165)))))))))
          : (c <= 3171 || (c < 3450
            ? (c < 3293
              ? (c < 3242
                ? (c < 3205
                  ? (c < 3200
                    ? (c >= 3174 && c <= 3183)
                    : c <= 3203)
                  : (c <= 3212 || (c < 3218
                    ? (c >= 3214 && c <= 3216)
                    : c <= 3240)))
                : (c <= 3251 || (c < 3270
                  ? (c < 3260
                    ? (c >= 3253 && c <= 3257)
                    : c <= 3268)
                  : (c <= 3272 || (c < 3285
                    ? (c >= 3274 && c <= 3277)
                    : c <= 3286)))))
              : (c <= 3294 || (c < 3346
                ? (c < 3313
                  ? (c < 3302
                    ? (c >= 3296 && c <= 3299)
                    : c <= 3311)
                  : (c <= 3314 || (c < 3342
                    ? (c >= 3328 && c <= 3340)
                    : c <= 3344)))
                : (c <= 3396 || (c < 3412
                  ? (c < 3402
                    ? (c >= 3398 && c <= 3400)
                    : c <= 3406)
                  : (c <= 3415 || (c < 3430
                    ? (c >= 3423 && c <= 3427)
                    : c <= 3439)))))))
            : (c <= 3455 || (c < 3570
              ? (c < 3520
                ? (c < 3482
                  ? (c < 3461
                    ? (c >= 3457 && c <= 3459)
                    : c <= 3478)
                  : (c <= 3505 || (c < 3517
                    ? (c >= 3507 && c <= 3515)
                    : c <= 3517)))
                : (c <= 3526 || (c < 3542
                  ? (c < 3535
                    ? c == 3530
                    : c <= 3540)
                  : (c <= 3542 || (c < 3558
                    ? (c >= 3544 && c <= 3551)
                    : c <= 3567)))))
              : (c <= 3571 || (c < 3718
                ? (c < 3664
                  ? (c < 3648
                    ? (c >= 3585 && c <= 3642)
                    : c <= 3662)
                  : (c <= 3673 || (c < 3716
                    ? (c >= 3713 && c <= 3714)
                    : c <= 3716)))
                : (c <= 3722 || (c < 3751
                  ? (c < 3749
                    ? (c >= 3724 && c <= 3747)
                    : c <= 3749)
                  : (c <= 3773 || (c >= 3776 && c <= 3780)))))))))))))
      : (c <= 3782 || (c < 8025
        ? (c < 5888
          ? (c < 4688
            ? (c < 3953
              ? (c < 3872
                ? (c < 3804
                  ? (c < 3792
                    ? (c >= 3784 && c <= 3789)
                    : c <= 3801)
                  : (c <= 3807 || (c < 3864
                    ? c == 3840
                    : c <= 3865)))
                : (c <= 3881 || (c < 3897
                  ? (c < 3895
                    ? c == 3893
                    : c <= 3895)
                  : (c <= 3897 || (c < 3913
                    ? (c >= 3902 && c <= 3911)
                    : c <= 3948)))))
              : (c <= 3972 || (c < 4256
                ? (c < 4038
                  ? (c < 3993
                    ? (c >= 3974 && c <= 3991)
                    : c <= 4028)
                  : (c <= 4038 || (c < 4176
                    ? (c >= 4096 && c <= 4169)
                    : c <= 4253)))
                : (c <= 4293 || (c < 4304
                  ? (c < 4301
                    ? c == 4295
                    : c <= 4301)
                  : (c <= 4346 || (c < 4682
                    ? (c >= 4348 && c <= 4680)
                    : c <= 4685)))))))
            : (c <= 4694 || (c < 4882
              ? (c < 4786
                ? (c < 4704
                  ? (c < 4698
                    ? c == 4696
                    : c <= 4701)
                  : (c <= 4744 || (c < 4752
                    ? (c >= 4746 && c <= 4749)
                    : c <= 4784)))
                : (c <= 4789 || (c < 4802
                  ? (c < 4800
                    ? (c >= 4792 && c <= 4798)
                    : c <= 4800)
                  : (c <= 4805 || (c < 4824
                    ? (c >= 4808 && c <= 4822)
                    : c <= 4880)))))
              : (c <= 4885 || (c < 5112
                ? (c < 4969
                  ? (c < 4957
                    ? (c >= 4888 && c <= 4954)
                    : c <= 4959)
                  : (c <= 4977 || (c < 5024
                    ? (c >= 4992 && c <= 5007)
                    : c <= 5109)))
                : (c <= 5117 || (c < 5761
                  ? (c < 5743
                    ? (c >= 5121 && c <= 5740)
                    : c <= 5759)
                  : (c <= 5786 || (c < 5870
                    ? (c >= 5792 && c <= 5866)
                    : c <= 5880)))))))))
          : (c <= 5909 || (c < 6688
            ? (c < 6176
              ? (c < 6016
                ? (c < 5984
                  ? (c < 5952
                    ? (c >= 5919 && c <= 5940)
                    : c <= 5971)
                  : (c <= 5996 || (c < 6002
                    ? (c >= 5998 && c <= 6000)
                    : c <= 6003)))
                : (c <= 6099 || (c < 6112
                  ? (c < 6108
                    ? c == 6103
                    : c <= 6109)
                  : (c <= 6121 || (c < 6159
                    ? (c >= 6155 && c <= 6157)
                    : c <= 6169)))))
              : (c <= 6264 || (c < 6470
                ? (c < 6400
                  ? (c < 6320
                    ? (c >= 6272 && c <= 6314)
                    : c <= 6389)
                  : (c <= 6430 || (c < 6448
                    ? (c >= 6432 && c <= 6443)
                    : c <= 6459)))
                : (c <= 6509 || (c < 6576
                  ? (c < 6528
                    ? (c >= 6512 && c <= 6516)
                    : c <= 6571)
                  : (c <= 6601 || (c < 6656
                    ? (c >= 6608 && c <= 6618)
                    : c <= 6683)))))))
            : (c <= 6750 || (c < 7232
              ? (c < 6847
                ? (c < 6800
                  ? (c < 6783
                    ? (c >= 6752 && c <= 6780)
                    : c <= 6793)
                  : (c <= 6809 || (c < 6832
                    ? c == 6823
                    : c <= 6845)))
                : (c <= 6862 || (c < 7019
                  ? (c < 6992
                    ? (c >= 6912 && c <= 6988)
                    : c <= 7001)
                  : (c <= 7027 || (c < 7168
                    ? (c >= 7040 && c <= 7155)
                    : c <= 7223)))))
              : (c <= 7241 || (c < 7380
                ? (c < 7312
                  ? (c < 7296
                    ? (c >= 7245 && c <= 7293)
                    : c <= 7304)
                  : (c <= 7354 || (c < 7376
                    ? (c >= 7357 && c <= 7359)
                    : c <= 7378)))
                : (c <= 7418 || (c < 7968
                  ? (c < 7960
                    ? (c >= 7424 && c <= 7957)
                    : c <= 7965)
                  : (c <= 8005 || (c < 8016
                    ? (c >= 8008 && c <= 8013)
                    : c <= 8023)))))))))))
        : (c <= 8025 || (c < 11720
          ? (c < 8458
            ? (c < 8178
              ? (c < 8126
                ? (c < 8031
                  ? (c < 8029
                    ? c == 8027
                    : c <= 8029)
                  : (c <= 8061 || (c < 8118
                    ? (c >= 8064 && c <= 8116)
                    : c <= 8124)))
                : (c <= 8126 || (c < 8144
                  ? (c < 8134
                    ? (c >= 8130 && c <= 8132)
                    : c <= 8140)
                  : (c <= 8147 || (c < 8160
                    ? (c >= 8150 && c <= 8155)
                    : c <= 8172)))))
              : (c <= 8180 || (c < 8336
                ? (c < 8276
                  ? (c < 8255
                    ? (c >= 8182 && c <= 8188)
                    : c <= 8256)
                  : (c <= 8276 || (c < 8319
                    ? c == 8305
                    : c <= 8319)))
                : (c <= 8348 || (c < 8421
                  ? (c < 8417
                    ? (c >= 8400 && c <= 8412)
                    : c <= 8417)
                  : (c <= 8432 || (c < 8455
                    ? c == 8450
                    : c <= 8455)))))))
            : (c <= 8467 || (c < 11499
              ? (c < 8490
                ? (c < 8484
                  ? (c < 8472
                    ? c == 8469
                    : c <= 8477)
                  : (c <= 8484 || (c < 8488
                    ? c == 8486
                    : c <= 8488)))
                : (c <= 8505 || (c < 8526
                  ? (c < 8517
                    ? (c >= 8508 && c <= 8511)
                    : c <= 8521)
                  : (c <= 8526 || (c < 11264
                    ? (c >= 8544 && c <= 8584)
                    : c <= 11492)))))
              : (c <= 11507 || (c < 11647
                ? (c < 11565
                  ? (c < 11559
                    ? (c >= 11520 && c <= 11557)
                    : c <= 11559)
                  : (c <= 11565 || (c < 11631
                    ? (c >= 11568 && c <= 11623)
                    : c <= 11631)))
                : (c <= 11670 || (c < 11696
                  ? (c < 11688
                    ? (c >= 11680 && c <= 11686)
                    : c <= 11694)
                  : (c <= 11702 || (c < 11712
                    ? (c >= 11704 && c <= 11710)
                    : c <= 11718)))))))))
          : (c <= 11726 || (c < 42623
            ? (c < 12540
              ? (c < 12337
                ? (c < 11744
                  ? (c < 11736
                    ? (c >= 11728 && c <= 11734)
                    : c <= 11742)
                  : (c <= 11775 || (c < 12321
                    ? (c >= 12293 && c <= 12295)
                    : c <= 12335)))
                : (c <= 12341 || (c < 12441
                  ? (c < 12353
                    ? (c >= 12344 && c <= 12348)
                    : c <= 12438)
                  : (c <= 12442 || (c < 12449
                    ? (c >= 12445 && c <= 12447)
                    : c <= 12538)))))
              : (c <= 12543 || (c < 19968
                ? (c < 12704
                  ? (c < 12593
                    ? (c >= 12549 && c <= 12591)
                    : c <= 12686)
                  : (c <= 12735 || (c < 13312
                    ? (c >= 12784 && c <= 12799)
                    : c <= 19903)))
                : (c <= 42124 || (c < 42512
                  ? (c < 42240
                    ? (c >= 42192 && c <= 42237)
                    : c <= 42508)
                  : (c <= 42539 || (c < 42612
                    ? (c >= 42560 && c <= 42607)
                    : c <= 42621)))))))
            : (c <= 42737 || (c < 43232
              ? (c < 42965
                ? (c < 42891
                  ? (c < 42786
                    ? (c >= 42775 && c <= 42783)
                    : c <= 42888)
                  : (c <= 42954 || (c < 42963
                    ? (c >= 42960 && c <= 42961)
                    : c <= 42963)))
                : (c <= 42969 || (c < 43072
                  ? (c < 43052
                    ? (c >= 42994 && c <= 43047)
                    : c <= 43052)
                  : (c <= 43123 || (c < 43216
                    ? (c >= 43136 && c <= 43205)
                    : c <= 43225)))))
              : (c <= 43255 || (c < 43471
                ? (c < 43312
                  ? (c < 43261
                    ? c == 43259
                    : c <= 43309)
                  : (c <= 43347 || (c < 43392
                    ? (c >= 43360 && c <= 43388)
                    : c <= 43456)))
                : (c <= 43481 || (c < 43584
                  ? (c < 43520
                    ? (c >= 43488 && c <= 43518)
                    : c <= 43574)
                  : (c <= 43597 || (c >= 43600 && c <= 43609)))))))))))))))
    : (c <= 43638 || (c < 71453
      ? (c < 67639
        ? (c < 65345
          ? (c < 64312
            ? (c < 43888
              ? (c < 43785
                ? (c < 43744
                  ? (c < 43739
                    ? (c >= 43642 && c <= 43714)
                    : c <= 43741)
                  : (c <= 43759 || (c < 43777
                    ? (c >= 43762 && c <= 43766)
                    : c <= 43782)))
                : (c <= 43790 || (c < 43816
                  ? (c < 43808
                    ? (c >= 43793 && c <= 43798)
                    : c <= 43814)
                  : (c <= 43822 || (c < 43868
                    ? (c >= 43824 && c <= 43866)
                    : c <= 43881)))))
              : (c <= 44010 || (c < 63744
                ? (c < 44032
                  ? (c < 44016
                    ? (c >= 44012 && c <= 44013)
                    : c <= 44025)
                  : (c <= 55203 || (c < 55243
                    ? (c >= 55216 && c <= 55238)
                    : c <= 55291)))
                : (c <= 64109 || (c < 64275
                  ? (c < 64256
                    ? (c >= 64112 && c <= 64217)
                    : c <= 64262)
                  : (c <= 64279 || (c < 64298
                    ? (c >= 64285 && c <= 64296)
                    : c <= 64310)))))))
            : (c <= 64316 || (c < 65075
              ? (c < 64612
                ? (c < 64323
                  ? (c < 64320
                    ? c == 64318
                    : c <= 64321)
                  : (c <= 64324 || (c < 64467
                    ? (c >= 64326 && c <= 64433)
                    : c <= 64605)))
                : (c <= 64829 || (c < 65008
                  ? (c < 64914
                    ? (c >= 64848 && c <= 64911)
                    : c <= 64967)
                  : (c <= 65017 || (c < 65056
                    ? (c >= 65024 && c <= 65039)
                    : c <= 65071)))))
              : (c <= 65076 || (c < 65147
                ? (c < 65139
                  ? (c < 65137
                    ? (c >= 65101 && c <= 65103)
                    : c <= 65137)
                  : (c <= 65139 || (c < 65145
                    ? c == 65143
                    : c <= 65145)))
                : (c <= 65147 || (c < 65296
                  ? (c < 65151
                    ? c == 65149
                    : c <= 65276)
                  : (c <= 65305 || (c < 65343
                    ? (c >= 65313 && c <= 65338)
                    : c <= 65343)))))))))
          : (c <= 65370 || (c < 66513
            ? (c < 65664
              ? (c < 65536
                ? (c < 65482
                  ? (c < 65474
                    ? (c >= 65382 && c <= 65470)
                    : c <= 65479)
                  : (c <= 65487 || (c < 65498
                    ? (c >= 65490 && c <= 65495)
                    : c <= 65500)))
                : (c <= 65547 || (c < 65596
                  ? (c < 65576
                    ? (c >= 65549 && c <= 65574)
                    : c <= 65594)
                  : (c <= 65597 || (c < 65616
                    ? (c >= 65599 && c <= 65613)
                    : c <= 65629)))))
              : (c <= 65786 || (c < 66304
                ? (c < 66176
                  ? (c < 66045
                    ? (c >= 65856 && c <= 65908)
                    : c <= 66045)
                  : (c <= 66204 || (c < 66272
                    ? (c >= 66208 && c <= 66256)
                    : c <= 66272)))
                : (c <= 66335 || (c < 66432
                  ? (c < 66384
                    ? (c >= 66349 && c <= 66378)
                    : c <= 66426)
                  : (c <= 66461 || (c < 66504
                    ? (c >= 66464 && c <= 66499)
                    : c <= 66511)))))))
            : (c <= 66517 || (c < 66979
              ? (c < 66864
                ? (c < 66736
                  ? (c < 66720
                    ? (c >= 66560 && c <= 66717)
                    : c <= 66729)
                  : (c <= 66771 || (c < 66816
                    ? (c >= 66776 && c <= 66811)
                    : c <= 66855)))
                : (c <= 66915 || (c < 66956
                  ? (c < 66940
                    ? (c >= 66928 && c <= 66938)
                    : c <= 66954)
                  : (c <= 66962 || (c < 66967
                    ? (c >= 66964 && c <= 66965)
                    : c <= 66977)))))
              : (c <= 66993 || (c < 67456
                ? (c < 67072
                  ? (c < 67003
                    ? (c >= 66995 && c <= 67001)
                    : c <= 67004)
                  : (c <= 67382 || (c < 67424
                    ? (c >= 67392 && c <= 67413)
                    : c <= 67431)))
                : (c <= 67461 || (c < 67584
                  ? (c < 67506
                    ? (c >= 67463 && c <= 67504)
                    : c <= 67514)
                  : (c <= 67589 || (c < 67594
                    ? c == 67592
                    : c <= 67637)))))))))))
        : (c <= 67640 || (c < 69956
          ? (c < 68448
            ? (c < 68101
              ? (c < 67828
                ? (c < 67680
                  ? (c < 67647
                    ? c == 67644
                    : c <= 67669)
                  : (c <= 67702 || (c < 67808
                    ? (c >= 67712 && c <= 67742)
                    : c <= 67826)))
                : (c <= 67829 || (c < 67968
                  ? (c < 67872
                    ? (c >= 67840 && c <= 67861)
                    : c <= 67897)
                  : (c <= 68023 || (c < 68096
                    ? (c >= 68030 && c <= 68031)
                    : c <= 68099)))))
              : (c <= 68102 || (c < 68192
                ? (c < 68121
                  ? (c < 68117
                    ? (c >= 68108 && c <= 68115)
                    : c <= 68119)
                  : (c <= 68149 || (c < 68159
                    ? (c >= 68152 && c <= 68154)
                    : c <= 68159)))
                : (c <= 68220 || (c < 68297
                  ? (c < 68288
                    ? (c >= 68224 && c <= 68252)
                    : c <= 68295)
                  : (c <= 68326 || (c < 68416
                    ? (c >= 68352 && c <= 68405)
                    : c <= 68437)))))))
            : (c <= 68466 || (c < 69424
              ? (c < 68912
                ? (c < 68736
                  ? (c < 68608
                    ? (c >= 68480 && c <= 68497)
                    : c <= 68680)
                  : (c <= 68786 || (c < 68864
                    ? (c >= 68800 && c <= 68850)
                    : c <= 68903)))
                : (c <= 68921 || (c < 69296
                  ? (c < 69291
                    ? (c >= 69248 && c <= 69289)
                    : c <= 69292)
                  : (c <= 69297 || (c < 69415
                    ? (c >= 69376 && c <= 69404)
                    : c <= 69415)))))
              : (c <= 69456 || (c < 69759
                ? (c < 69600
                  ? (c < 69552
                    ? (c >= 69488 && c <= 69509)
                    : c <= 69572)
                  : (c <= 69622 || (c < 69734
                    ? (c >= 69632 && c <= 69702)
                    : c <= 69749)))
                : (c <= 69818 || (c < 69872
                  ? (c < 69840
                    ? c == 69826
                    : c <= 69864)
                  : (c <= 69881 || (c < 69942
                    ? (c >= 69888 && c <= 69940)
                    : c <= 69951)))))))))
          : (c <= 69959 || (c < 70459
            ? (c < 70282
              ? (c < 70108
                ? (c < 70016
                  ? (c < 70006
                    ? (c >= 69968 && c <= 70003)
                    : c <= 70006)
                  : (c <= 70084 || (c < 70094
                    ? (c >= 70089 && c <= 70092)
                    : c <= 70106)))
                : (c <= 70108 || (c < 70206
                  ? (c < 70163
                    ? (c >= 70144 && c <= 70161)
                    : c <= 70199)
                  : (c <= 70206 || (c < 70280
                    ? (c >= 70272 && c <= 70278)
                    : c <= 70280)))))
              : (c <= 70285 || (c < 70405
                ? (c < 70320
                  ? (c < 70303
                    ? (c >= 70287 && c <= 70301)
                    : c <= 70312)
                  : (c <= 70378 || (c < 70400
                    ? (c >= 70384 && c <= 70393)
                    : c <= 70403)))
                : (c <= 70412 || (c < 70442
                  ? (c < 70419
                    ? (c >= 70415 && c <= 70416)
                    : c <= 70440)
                  : (c <= 70448 || (c < 70453
                    ? (c >= 70450 && c <= 70451)
                    : c <= 70457)))))))
            : (c <= 70468 || (c < 70855
              ? (c < 70502
                ? (c < 70480
                  ? (c < 70475
                    ? (c >= 70471 && c <= 70472)
                    : c <= 70477)
                  : (c <= 70480 || (c < 70493
                    ? c == 70487
                    : c <= 70499)))
                : (c <= 70508 || (c < 70736
                  ? (c < 70656
                    ? (c >= 70512 && c <= 70516)
                    : c <= 70730)
                  : (c <= 70745 || (c < 70784
                    ? (c >= 70750 && c <= 70753)
                    : c <= 70853)))))
              : (c <= 70855 || (c < 71236
                ? (c < 71096
                  ? (c < 71040
                    ? (c >= 70864 && c <= 70873)
                    : c <= 71093)
                  : (c <= 71104 || (c < 71168
                    ? (c >= 71128 && c <= 71133)
                    : c <= 71232)))
                : (c <= 71236 || (c < 71360
                  ? (c < 71296
                    ? (c >= 71248 && c <= 71257)
                    : c <= 71352)
                  : (c <= 71369 || (c >= 71424 && c <= 71450)))))))))))))
      : (c <= 71467 || (c < 119973
        ? (c < 77824
          ? (c < 72760
            ? (c < 72016
              ? (c < 71945
                ? (c < 71680
                  ? (c < 71488
                    ? (c >= 71472 && c <= 71481)
                    : c <= 71494)
                  : (c <= 71738 || (c < 71935
                    ? (c >= 71840 && c <= 71913)
                    : c <= 71942)))
                : (c <= 71945 || (c < 71960
                  ? (c < 71957
                    ? (c >= 71948 && c <= 71955)
                    : c <= 71958)
                  : (c <= 71989 || (c < 71995
                    ? (c >= 71991 && c <= 71992)
                    : c <= 72003)))))
              : (c <= 72025 || (c < 72263
                ? (c < 72154
                  ? (c < 72106
                    ? (c >= 72096 && c <= 72103)
                    : c <= 72151)
                  : (c <= 72161 || (c < 72192
                    ? (c >= 72163 && c <= 72164)
                    : c <= 72254)))
                : (c <= 72263 || (c < 72368
                  ? (c < 72349
                    ? (c >= 72272 && c <= 72345)
                    : c <= 72349)
                  : (c <= 72440 || (c < 72714
                    ? (c >= 72704 && c <= 72712)
                    : c <= 72758)))))))
            : (c <= 72768 || (c < 73056
              ? (c < 72968
                ? (c < 72850
                  ? (c < 72818
                    ? (c >= 72784 && c <= 72793)
                    : c <= 72847)
                  : (c <= 72871 || (c < 72960
                    ? (c >= 72873 && c <= 72886)
                    : c <= 72966)))
                : (c <= 72969 || (c < 73020
                  ? (c < 73018
                    ? (c >= 72971 && c <= 73014)
                    : c <= 73018)
                  : (c <= 73021 || (c < 73040
                    ? (c >= 73023 && c <= 73031)
                    : c <= 73049)))))
              : (c <= 73061 || (c < 73440
                ? (c < 73104
                  ? (c < 73066
                    ? (c >= 73063 && c <= 73064)
                    : c <= 73102)
                  : (c <= 73105 || (c < 73120
                    ? (c >= 73107 && c <= 73112)
                    : c <= 73129)))
                : (c <= 73462 || (c < 74752
                  ? (c < 73728
                    ? c == 73648
                    : c <= 74649)
                  : (c <= 74862 || (c < 77712
                    ? (c >= 74880 && c <= 75075)
                    : c <= 77808)))))))))
          : (c <= 78894 || (c < 110576
            ? (c < 93027
              ? (c < 92864
                ? (c < 92736
                  ? (c < 92160
                    ? (c >= 82944 && c <= 83526)
                    : c <= 92728)
                  : (c <= 92766 || (c < 92784
                    ? (c >= 92768 && c <= 92777)
                    : c <= 92862)))
                : (c <= 92873 || (c < 92928
                  ? (c < 92912
                    ? (c >= 92880 && c <= 92909)
                    : c <= 92916)
                  : (c <= 92982 || (c < 93008
                    ? (c >= 92992 && c <= 92995)
                    : c <= 93017)))))
              : (c <= 93047 || (c < 94176
                ? (c < 93952
                  ? (c < 93760
                    ? (c >= 93053 && c <= 93071)
                    : c <= 93823)
                  : (c <= 94026 || (c < 94095
                    ? (c >= 94031 && c <= 94087)
                    : c <= 94111)))
                : (c <= 94177 || (c < 94208
                  ? (c < 94192
                    ? (c >= 94179 && c <= 94180)
                    : c <= 94193)
                  : (c <= 100343 || (c < 101632
                    ? (c >= 100352 && c <= 101589)
                    : c <= 101640)))))))
            : (c <= 110579 || (c < 118528
              ? (c < 110960
                ? (c < 110592
                  ? (c < 110589
                    ? (c >= 110581 && c <= 110587)
                    : c <= 110590)
                  : (c <= 110882 || (c < 110948
                    ? (c >= 110928 && c <= 110930)
                    : c <= 110951)))
                : (c <= 111355 || (c < 113792
                  ? (c < 113776
                    ? (c >= 113664 && c <= 113770)
                    : c <= 113788)
                  : (c <= 113800 || (c < 113821
                    ? (c >= 113808 && c <= 113817)
                    : c <= 113822)))))
              : (c <= 118573 || (c < 119210
                ? (c < 119149
                  ? (c < 119141
                    ? (c >= 118576 && c <= 118598)
                    : c <= 119145)
                  : (c <= 119154 || (c < 119173
                    ? (c >= 119163 && c <= 119170)
                    : c <= 119179)))
                : (c <= 119213 || (c < 119894
                  ? (c < 119808
                    ? (c >= 119362 && c <= 119364)
                    : c <= 119892)
                  : (c <= 119964 || (c < 119970
                    ? (c >= 119966 && c <= 119967)
                    : c <= 119970)))))))))))
        : (c <= 119974 || (c < 124912
          ? (c < 120746
            ? (c < 120134
              ? (c < 120071
                ? (c < 119995
                  ? (c < 119982
                    ? (c >= 119977 && c <= 119980)
                    : c <= 119993)
                  : (c <= 119995 || (c < 120005
                    ? (c >= 119997 && c <= 120003)
                    : c <= 120069)))
                : (c <= 120074 || (c < 120094
                  ? (c < 120086
                    ? (c >= 120077 && c <= 120084)
                    : c <= 120092)
                  : (c <= 120121 || (c < 120128
                    ? (c >= 120123 && c <= 120126)
                    : c <= 120132)))))
              : (c <= 120134 || (c < 120572
                ? (c < 120488
                  ? (c < 120146
                    ? (c >= 120138 && c <= 120144)
                    : c <= 120485)
                  : (c <= 120512 || (c < 120540
                    ? (c >= 120514 && c <= 120538)
                    : c <= 120570)))
                : (c <= 120596 || (c < 120656
                  ? (c < 120630
                    ? (c >= 120598 && c <= 120628)
                    : c <= 120654)
                  : (c <= 120686 || (c < 120714
                    ? (c >= 120688 && c <= 120712)
                    : c <= 120744)))))))
            : (c <= 120770 || (c < 122907
              ? (c < 121476
                ? (c < 121344
                  ? (c < 120782
                    ? (c >= 120772 && c <= 120779)
                    : c <= 120831)
                  : (c <= 121398 || (c < 121461
                    ? (c >= 121403 && c <= 121452)
                    : c <= 121461)))
                : (c <= 121476 || (c < 122624
                  ? (c < 121505
                    ? (c >= 121499 && c <= 121503)
                    : c <= 121519)
                  : (c <= 122654 || (c < 122888
                    ? (c >= 122880 && c <= 122886)
                    : c <= 122904)))))
              : (c <= 122913 || (c < 123214
                ? (c < 123136
                  ? (c < 122918
                    ? (c >= 122915 && c <= 122916)
                    : c <= 122922)
                  : (c <= 123180 || (c < 123200
                    ? (c >= 123184 && c <= 123197)
                    : c <= 123209)))
                : (c <= 123214 || (c < 124896
                  ? (c < 123584
                    ? (c >= 123536 && c <= 123566)
                    : c <= 123641)
                  : (c <= 124902 || (c < 124909
                    ? (c >= 124904 && c <= 124907)
                    : c <= 124910)))))))))
          : (c <= 124926 || (c < 126557
            ? (c < 126521
              ? (c < 126469
                ? (c < 125184
                  ? (c < 125136
                    ? (c >= 124928 && c <= 125124)
                    : c <= 125142)
                  : (c <= 125259 || (c < 126464
                    ? (c >= 125264 && c <= 125273)
                    : c <= 126467)))
                : (c <= 126495 || (c < 126503
                  ? (c < 126500
                    ? (c >= 126497 && c <= 126498)
                    : c <= 126500)
                  : (c <= 126503 || (c < 126516
                    ? (c >= 126505 && c <= 126514)
                    : c <= 126519)))))
              : (c <= 126521 || (c < 126541
                ? (c < 126535
                  ? (c < 126530
                    ? c == 126523
                    : c <= 126530)
                  : (c <= 126535 || (c < 126539
                    ? c == 126537
                    : c <= 126539)))
                : (c <= 126543 || (c < 126551
                  ? (c < 126548
                    ? (c >= 126545 && c <= 126546)
                    : c <= 126548)
                  : (c <= 126551 || (c < 126555
                    ? c == 126553
                    : c <= 126555)))))))
            : (c <= 126557 || (c < 126629
              ? (c < 126580
                ? (c < 126564
                  ? (c < 126561
                    ? c == 126559
                    : c <= 126562)
                  : (c <= 126564 || (c < 126572
                    ? (c >= 126567 && c <= 126570)
                    : c <= 126578)))
                : (c <= 126583 || (c < 126592
                  ? (c < 126590
                    ? (c >= 126585 && c <= 126588)
                    : c <= 126590)
                  : (c <= 126601 || (c < 126625
                    ? (c >= 126603 && c <= 126619)
                    : c <= 126627)))))
              : (c <= 126633 || (c < 178208
                ? (c < 131072
                  ? (c < 130032
                    ? (c >= 126635 && c <= 126651)
                    : c <= 130041)
                  : (c <= 173791 || (c < 177984
                    ? (c >= 173824 && c <= 177976)
                    : c <= 178205)))
                : (c <= 183969 || (c < 196608
                  ? (c < 194560
                    ? (c >= 183984 && c <= 191456)
                    : c <= 195101)
                  : (c <= 201546 || (c >= 917760 && c <= 917999)))))))))))))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(51);
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(149);
      if (lookahead == '%') ADVANCE(80);
      if (lookahead == '&') ADVANCE(83);
      if (lookahead == '(') ADVANCE(55);
      if (lookahead == ')') ADVANCE(56);
      if (lookahead == '*') ADVANCE(59);
      if (lookahead == '+') ADVANCE(75);
      if (lookahead == ',') ADVANCE(57);
      if (lookahead == '-') ADVANCE(78);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '0') ADVANCE(122);
      if (lookahead == ':') ADVANCE(63);
      if (lookahead == ';') ADVANCE(52);
      if (lookahead == '<') ADVANCE(87);
      if (lookahead == '=') ADVANCE(73);
      if (lookahead == '>') ADVANCE(92);
      if (lookahead == '@') ADVANCE(70);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(41)
      if (lookahead == ']') ADVANCE(72);
      if (lookahead == '^') ADVANCE(84);
      if (lookahead == 'e') ADVANCE(145);
      if (lookahead == '{') ADVANCE(109);
      if (lookahead == '|') ADVANCE(82);
      if (lookahead == '}') ADVANCE(110);
      if (lookahead == '~') ADVANCE(86);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(121);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(148);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(11)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(11)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(13)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(13)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(114);
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(6)
      if (lookahead == '#') ADVANCE(118);
      if (lookahead == '\\') ADVANCE(116);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '}') ADVANCE(110);
      if (lookahead == '\t' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(117);
      if (lookahead != 0) ADVANCE(118);
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(14)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(14)
      if (lookahead == '\r') SKIP(7)
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(12)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(12)
      if (lookahead == '\r') SKIP(9)
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(149);
      if (lookahead == '%') ADVANCE(80);
      if (lookahead == '&') ADVANCE(83);
      if (lookahead == '(') ADVANCE(55);
      if (lookahead == ')') ADVANCE(56);
      if (lookahead == '*') ADVANCE(59);
      if (lookahead == '+') ADVANCE(75);
      if (lookahead == ',') ADVANCE(57);
      if (lookahead == '-') ADVANCE(77);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '0') ADVANCE(122);
      if (lookahead == ':') ADVANCE(62);
      if (lookahead == ';') ADVANCE(52);
      if (lookahead == '<') ADVANCE(87);
      if (lookahead == '=') ADVANCE(73);
      if (lookahead == '>') ADVANCE(92);
      if (lookahead == '@') ADVANCE(70);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == ']') ADVANCE(72);
      if (lookahead == '^') ADVANCE(84);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '|') ADVANCE(82);
      if (lookahead == '}') ADVANCE(110);
      if (lookahead == '~') ADVANCE(86);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(11)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(121);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(148);
      END_STATE();
    case 12:
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(149);
      if (lookahead == '%') ADVANCE(80);
      if (lookahead == '&') ADVANCE(83);
      if (lookahead == '(') ADVANCE(55);
      if (lookahead == ')') ADVANCE(56);
      if (lookahead == '*') ADVANCE(59);
      if (lookahead == '+') ADVANCE(75);
      if (lookahead == ',') ADVANCE(57);
      if (lookahead == '-') ADVANCE(77);
      if (lookahead == '.') ADVANCE(53);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == ':') ADVANCE(63);
      if (lookahead == ';') ADVANCE(52);
      if (lookahead == '<') ADVANCE(87);
      if (lookahead == '=') ADVANCE(73);
      if (lookahead == '>') ADVANCE(92);
      if (lookahead == '@') ADVANCE(70);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(10)
      if (lookahead == ']') ADVANCE(72);
      if (lookahead == '^') ADVANCE(84);
      if (lookahead == '|') ADVANCE(82);
      if (lookahead == '}') ADVANCE(110);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(12)
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(148);
      END_STATE();
    case 13:
      if (lookahead == '!') ADVANCE(19);
      if (lookahead == '#') ADVANCE(149);
      if (lookahead == '%') ADVANCE(80);
      if (lookahead == '&') ADVANCE(83);
      if (lookahead == '(') ADVANCE(55);
      if (lookahead == ')') ADVANCE(56);
      if (lookahead == '*') ADVANCE(59);
      if (lookahead == '+') ADVANCE(75);
      if (lookahead == ',') ADVANCE(57);
      if (lookahead == '-') ADVANCE(77);
      if (lookahead == '.') ADVANCE(53);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == ':') ADVANCE(62);
      if (lookahead == ';') ADVANCE(52);
      if (lookahead == '<') ADVANCE(87);
      if (lookahead == '=') ADVANCE(73);
      if (lookahead == '>') ADVANCE(92);
      if (lookahead == '@') ADVANCE(70);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == ']') ADVANCE(72);
      if (lookahead == '^') ADVANCE(84);
      if (lookahead == '|') ADVANCE(82);
      if (lookahead == '}') ADVANCE(110);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(13)
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(148);
      END_STATE();
    case 14:
      if (lookahead == '#') ADVANCE(149);
      if (lookahead == '-') ADVANCE(20);
      if (lookahead == ':') ADVANCE(62);
      if (lookahead == '\\') SKIP(8)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(14)
      END_STATE();
    case 15:
      if (lookahead == '#') ADVANCE(149);
      if (lookahead == '\\') ADVANCE(115);
      if (lookahead == '{') ADVANCE(109);
      if (lookahead == '}') ADVANCE(24);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(15)
      END_STATE();
    case 16:
      if (lookahead == '.') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(128);
      END_STATE();
    case 17:
      if (lookahead == '.') ADVANCE(107);
      END_STATE();
    case 18:
      if (lookahead == '=') ADVANCE(90);
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(90);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(119);
      END_STATE();
    case 20:
      if (lookahead == '>') ADVANCE(67);
      END_STATE();
    case 21:
      if (lookahead == '_') ADVANCE(26);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(124);
      END_STATE();
    case 22:
      if (lookahead == '_') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(125);
      END_STATE();
    case 23:
      if (lookahead == '_') ADVANCE(31);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(126);
      END_STATE();
    case 24:
      if (lookahead == '}') ADVANCE(112);
      END_STATE();
    case 25:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(28);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(129);
      END_STATE();
    case 26:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(124);
      END_STATE();
    case 27:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(125);
      END_STATE();
    case 28:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(129);
      END_STATE();
    case 29:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(113);
      END_STATE();
    case 30:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(29);
      END_STATE();
    case 31:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(126);
      END_STATE();
    case 32:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(113);
      END_STATE();
    case 33:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(32);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(33);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(38);
      END_STATE();
    case 40:
      if (eof) ADVANCE(51);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 41:
      if (eof) ADVANCE(51);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(40)
      END_STATE();
    case 42:
      if (eof) ADVANCE(51);
      if (lookahead == '\n') SKIP(48)
      END_STATE();
    case 43:
      if (eof) ADVANCE(51);
      if (lookahead == '\n') SKIP(48)
      if (lookahead == '\r') SKIP(42)
      END_STATE();
    case 44:
      if (eof) ADVANCE(51);
      if (lookahead == '\n') SKIP(49)
      END_STATE();
    case 45:
      if (eof) ADVANCE(51);
      if (lookahead == '\n') SKIP(49)
      if (lookahead == '\r') SKIP(44)
      END_STATE();
    case 46:
      if (eof) ADVANCE(51);
      if (lookahead == '\n') SKIP(50)
      END_STATE();
    case 47:
      if (eof) ADVANCE(51);
      if (lookahead == '\n') SKIP(50)
      if (lookahead == '\r') SKIP(46)
      END_STATE();
    case 48:
      if (eof) ADVANCE(51);
      if (lookahead == '!') ADVANCE(18);
      if (lookahead == '#') ADVANCE(149);
      if (lookahead == '%') ADVANCE(80);
      if (lookahead == '&') ADVANCE(83);
      if (lookahead == '(') ADVANCE(55);
      if (lookahead == ')') ADVANCE(56);
      if (lookahead == '*') ADVANCE(59);
      if (lookahead == '+') ADVANCE(75);
      if (lookahead == ',') ADVANCE(57);
      if (lookahead == '-') ADVANCE(77);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == '/') ADVANCE(79);
      if (lookahead == '0') ADVANCE(122);
      if (lookahead == ':') ADVANCE(63);
      if (lookahead == ';') ADVANCE(52);
      if (lookahead == '<') ADVANCE(87);
      if (lookahead == '=') ADVANCE(73);
      if (lookahead == '>') ADVANCE(92);
      if (lookahead == '@') ADVANCE(70);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(43)
      if (lookahead == ']') ADVANCE(72);
      if (lookahead == '^') ADVANCE(84);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '|') ADVANCE(82);
      if (lookahead == '}') ADVANCE(110);
      if (lookahead == '~') ADVANCE(86);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(48)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(121);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(148);
      END_STATE();
    case 49:
      if (eof) ADVANCE(51);
      if (lookahead == '#') ADVANCE(149);
      if (lookahead == '(') ADVANCE(55);
      if (lookahead == '*') ADVANCE(58);
      if (lookahead == '+') ADVANCE(74);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '0') ADVANCE(122);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(45)
      if (lookahead == 'e') ADVANCE(146);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '~') ADVANCE(86);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(49)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(121);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(148);
      END_STATE();
    case 50:
      if (eof) ADVANCE(51);
      if (lookahead == '#') ADVANCE(149);
      if (lookahead == '(') ADVANCE(55);
      if (lookahead == '*') ADVANCE(58);
      if (lookahead == '+') ADVANCE(74);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == '0') ADVANCE(122);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(47)
      if (lookahead == 'e') ADVANCE(147);
      if (lookahead == '{') ADVANCE(108);
      if (lookahead == '~') ADVANCE(86);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(50)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(121);
      if (sym_identifier_character_set_2(lookahead)) ADVANCE(148);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(128);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(68);
      if (lookahead == '=') ADVANCE(96);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(102);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(61);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_except);
      if (lookahead == '*') ADVANCE(66);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_except);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_except_STAR);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(101);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '=') ADVANCE(98);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(89);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(94);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(95);
      if (lookahead == '>') ADVANCE(67);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(81);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(100);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '=') ADVANCE(99);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '=') ADVANCE(104);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(103);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(85);
      if (lookahead == '=') ADVANCE(88);
      if (lookahead == '>') ADVANCE(93);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(91);
      if (lookahead == '>') ADVANCE(60);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_AT_EQ);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_EQ);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_ellipsis);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '{') ADVANCE(111);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_RBRACE_RBRACE);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(115);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym__not_escape_sequence);
      if (lookahead == '\n') ADVANCE(114);
      if (lookahead == '\r') ADVANCE(5);
      if (lookahead == 'U') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(35);
      if (lookahead == 'x') ADVANCE(33);
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'a' ||
          lookahead == 'b' ||
          lookahead == 'f' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          ('t' <= lookahead && lookahead <= 'v')) ADVANCE(113);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(30);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == '\r') ADVANCE(118);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(118);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead == '#') ADVANCE(118);
      if (lookahead == '\\') ADVANCE(116);
      if (lookahead == '\t' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(117);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(118);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(118);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_type_conversion);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(130);
      if (lookahead == '_') ADVANCE(123);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(25);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(120);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(121);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(130);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(21);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(22);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(23);
      if (lookahead == '_') ADVANCE(123);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(25);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(120);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(121);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(130);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(25);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(120);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(121);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(26);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(120);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(124);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(27);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(120);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(125);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(31);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(120);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(126);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_float);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(130);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(25);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(128);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(131);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(129);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(25);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(128);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(129);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '*') ADVANCE(66);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(136);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(137);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(138);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(139);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(140);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(141);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(142);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(143);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(144);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(64);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(65);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(132);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(133);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(134);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(135);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_identifier);
      if (sym_identifier_character_set_3(lookahead)) ADVANCE(148);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(149);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'N') ADVANCE(2);
      if (lookahead == 'T') ADVANCE(3);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == '_') ADVANCE(5);
      if (lookahead == 'a') ADVANCE(6);
      if (lookahead == 'b') ADVANCE(7);
      if (lookahead == 'c') ADVANCE(8);
      if (lookahead == 'd') ADVANCE(9);
      if (lookahead == 'e') ADVANCE(10);
      if (lookahead == 'f') ADVANCE(11);
      if (lookahead == 'g') ADVANCE(12);
      if (lookahead == 'i') ADVANCE(13);
      if (lookahead == 'l') ADVANCE(14);
      if (lookahead == 'm') ADVANCE(15);
      if (lookahead == 'n') ADVANCE(16);
      if (lookahead == 'o') ADVANCE(17);
      if (lookahead == 'p') ADVANCE(18);
      if (lookahead == 'r') ADVANCE(19);
      if (lookahead == 't') ADVANCE(20);
      if (lookahead == 'w') ADVANCE(21);
      if (lookahead == 'y') ADVANCE(22);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'a') ADVANCE(23);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(24);
      END_STATE();
    case 3:
      if (lookahead == 'r') ADVANCE(25);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(26)
      END_STATE();
    case 5:
      if (lookahead == '_') ADVANCE(27);
      END_STATE();
    case 6:
      if (lookahead == 'n') ADVANCE(28);
      if (lookahead == 's') ADVANCE(29);
      if (lookahead == 'w') ADVANCE(30);
      END_STATE();
    case 7:
      if (lookahead == 'r') ADVANCE(31);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(32);
      if (lookahead == 'l') ADVANCE(33);
      if (lookahead == 'o') ADVANCE(34);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(35);
      END_STATE();
    case 10:
      if (lookahead == 'l') ADVANCE(36);
      if (lookahead == 'x') ADVANCE(37);
      END_STATE();
    case 11:
      if (lookahead == 'i') ADVANCE(38);
      if (lookahead == 'o') ADVANCE(39);
      if (lookahead == 'r') ADVANCE(40);
      END_STATE();
    case 12:
      if (lookahead == 'l') ADVANCE(41);
      END_STATE();
    case 13:
      if (lookahead == 'f') ADVANCE(42);
      if (lookahead == 'm') ADVANCE(43);
      if (lookahead == 'n') ADVANCE(44);
      if (lookahead == 's') ADVANCE(45);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(46);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(47);
      END_STATE();
    case 16:
      if (lookahead == 'o') ADVANCE(48);
      END_STATE();
    case 17:
      if (lookahead == 'r') ADVANCE(49);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(50);
      if (lookahead == 'r') ADVANCE(51);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 20:
      if (lookahead == 'r') ADVANCE(54);
      END_STATE();
    case 21:
      if (lookahead == 'h') ADVANCE(55);
      if (lookahead == 'i') ADVANCE(56);
      END_STATE();
    case 22:
      if (lookahead == 'i') ADVANCE(57);
      END_STATE();
    case 23:
      if (lookahead == 'l') ADVANCE(58);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(59);
      END_STATE();
    case 25:
      if (lookahead == 'u') ADVANCE(60);
      END_STATE();
    case 26:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 27:
      if (lookahead == 'f') ADVANCE(61);
      END_STATE();
    case 28:
      if (lookahead == 'd') ADVANCE(62);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(63);
      if (lookahead == 'y') ADVANCE(64);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(65);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 32:
      if (lookahead == 's') ADVANCE(67);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(68);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(69);
      END_STATE();
    case 35:
      if (lookahead == 'f') ADVANCE(70);
      if (lookahead == 'l') ADVANCE(71);
      END_STATE();
    case 36:
      if (lookahead == 'i') ADVANCE(72);
      if (lookahead == 's') ADVANCE(73);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 38:
      if (lookahead == 'n') ADVANCE(75);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(76);
      END_STATE();
    case 40:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 41:
      if (lookahead == 'o') ADVANCE(78);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 43:
      if (lookahead == 'p') ADVANCE(79);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 46:
      if (lookahead == 'm') ADVANCE(80);
      END_STATE();
    case 47:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 48:
      if (lookahead == 'n') ADVANCE(82);
      if (lookahead == 't') ADVANCE(83);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 50:
      if (lookahead == 's') ADVANCE(84);
      END_STATE();
    case 51:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 52:
      if (lookahead == 'i') ADVANCE(86);
      END_STATE();
    case 53:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 54:
      if (lookahead == 'y') ADVANCE(88);
      END_STATE();
    case 55:
      if (lookahead == 'i') ADVANCE(89);
      END_STATE();
    case 56:
      if (lookahead == 't') ADVANCE(90);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(91);
      END_STATE();
    case 58:
      if (lookahead == 's') ADVANCE(92);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(93);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 61:
      if (lookahead == 'u') ADVANCE(95);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 64:
      if (lookahead == 'n') ADVANCE(97);
      END_STATE();
    case 65:
      if (lookahead == 'i') ADVANCE(98);
      END_STATE();
    case 66:
      if (lookahead == 'a') ADVANCE(99);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 68:
      if (lookahead == 's') ADVANCE(101);
      END_STATE();
    case 69:
      if (lookahead == 't') ADVANCE(102);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_del);
      END_STATE();
    case 72:
      if (lookahead == 'f') ADVANCE(103);
      END_STATE();
    case 73:
      if (lookahead == 'e') ADVANCE(104);
      END_STATE();
    case 74:
      if (lookahead == 'c') ADVANCE(105);
      END_STATE();
    case 75:
      if (lookahead == 'a') ADVANCE(106);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 77:
      if (lookahead == 'm') ADVANCE(107);
      END_STATE();
    case 78:
      if (lookahead == 'b') ADVANCE(108);
      END_STATE();
    case 79:
      if (lookahead == 'o') ADVANCE(109);
      END_STATE();
    case 80:
      if (lookahead == 'b') ADVANCE(110);
      END_STATE();
    case 81:
      if (lookahead == 'c') ADVANCE(111);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(112);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 84:
      if (lookahead == 's') ADVANCE(113);
      END_STATE();
    case 85:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 86:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 87:
      if (lookahead == 'u') ADVANCE(116);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 89:
      if (lookahead == 'l') ADVANCE(117);
      END_STATE();
    case 90:
      if (lookahead == 'h') ADVANCE(118);
      END_STATE();
    case 91:
      if (lookahead == 'l') ADVANCE(119);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_none);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 95:
      if (lookahead == 't') ADVANCE(121);
      END_STATE();
    case 96:
      if (lookahead == 'r') ADVANCE(122);
      END_STATE();
    case 97:
      if (lookahead == 'c') ADVANCE(123);
      END_STATE();
    case 98:
      if (lookahead == 't') ADVANCE(124);
      END_STATE();
    case 99:
      if (lookahead == 'k') ADVANCE(125);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 101:
      if (lookahead == 's') ADVANCE(126);
      END_STATE();
    case 102:
      if (lookahead == 'i') ADVANCE(127);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_exec);
      END_STATE();
    case 106:
      if (lookahead == 'l') ADVANCE(128);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 108:
      if (lookahead == 'a') ADVANCE(129);
      END_STATE();
    case 109:
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 110:
      if (lookahead == 'd') ADVANCE(131);
      END_STATE();
    case 111:
      if (lookahead == 'h') ADVANCE(132);
      END_STATE();
    case 112:
      if (lookahead == 'o') ADVANCE(133);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_pass);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(135);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(136);
      END_STATE();
    case 117:
      if (lookahead == 'e') ADVANCE(137);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 119:
      if (lookahead == 'd') ADVANCE(138);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 121:
      if (lookahead == 'u') ADVANCE(139);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(140);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 127:
      if (lookahead == 'n') ADVANCE(141);
      END_STATE();
    case 128:
      if (lookahead == 'l') ADVANCE(142);
      END_STATE();
    case 129:
      if (lookahead == 'l') ADVANCE(143);
      END_STATE();
    case 130:
      if (lookahead == 't') ADVANCE(144);
      END_STATE();
    case 131:
      if (lookahead == 'a') ADVANCE(145);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 133:
      if (lookahead == 'c') ADVANCE(146);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_print);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_raise);
      END_STATE();
    case 136:
      if (lookahead == 'n') ADVANCE(147);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 139:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 141:
      if (lookahead == 'u') ADVANCE(149);
      END_STATE();
    case 142:
      if (lookahead == 'y') ADVANCE(150);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_lambda);
      END_STATE();
    case 146:
      if (lookahead == 'a') ADVANCE(151);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 148:
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 149:
      if (lookahead == 'e') ADVANCE(153);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 151:
      if (lookahead == 'l') ADVANCE(154);
      END_STATE();
    case 152:
      if (lookahead == '_') ADVANCE(155);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_nonlocal);
      END_STATE();
    case 155:
      if (lookahead == '_') ADVANCE(156);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym___future__);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 48, .external_lex_state = 2},
  [2] = {.lex_state = 48, .external_lex_state = 3},
  [3] = {.lex_state = 48, .external_lex_state = 3},
  [4] = {.lex_state = 48, .external_lex_state = 3},
  [5] = {.lex_state = 48, .external_lex_state = 3},
  [6] = {.lex_state = 48, .external_lex_state = 3},
  [7] = {.lex_state = 48, .external_lex_state = 3},
  [8] = {.lex_state = 48, .external_lex_state = 3},
  [9] = {.lex_state = 48, .external_lex_state = 3},
  [10] = {.lex_state = 48, .external_lex_state = 3},
  [11] = {.lex_state = 48, .external_lex_state = 3},
  [12] = {.lex_state = 48, .external_lex_state = 3},
  [13] = {.lex_state = 48, .external_lex_state = 3},
  [14] = {.lex_state = 48, .external_lex_state = 3},
  [15] = {.lex_state = 48, .external_lex_state = 3},
  [16] = {.lex_state = 48, .external_lex_state = 3},
  [17] = {.lex_state = 48, .external_lex_state = 3},
  [18] = {.lex_state = 48, .external_lex_state = 3},
  [19] = {.lex_state = 48, .external_lex_state = 3},
  [20] = {.lex_state = 48, .external_lex_state = 3},
  [21] = {.lex_state = 48, .external_lex_state = 3},
  [22] = {.lex_state = 48, .external_lex_state = 3},
  [23] = {.lex_state = 48, .external_lex_state = 3},
  [24] = {.lex_state = 48, .external_lex_state = 3},
  [25] = {.lex_state = 48, .external_lex_state = 3},
  [26] = {.lex_state = 48, .external_lex_state = 3},
  [27] = {.lex_state = 48, .external_lex_state = 3},
  [28] = {.lex_state = 48, .external_lex_state = 3},
  [29] = {.lex_state = 48, .external_lex_state = 3},
  [30] = {.lex_state = 48, .external_lex_state = 3},
  [31] = {.lex_state = 48, .external_lex_state = 3},
  [32] = {.lex_state = 48, .external_lex_state = 3},
  [33] = {.lex_state = 48, .external_lex_state = 3},
  [34] = {.lex_state = 48, .external_lex_state = 3},
  [35] = {.lex_state = 48, .external_lex_state = 3},
  [36] = {.lex_state = 48, .external_lex_state = 3},
  [37] = {.lex_state = 48, .external_lex_state = 3},
  [38] = {.lex_state = 48, .external_lex_state = 3},
  [39] = {.lex_state = 48, .external_lex_state = 3},
  [40] = {.lex_state = 48, .external_lex_state = 3},
  [41] = {.lex_state = 48, .external_lex_state = 3},
  [42] = {.lex_state = 48, .external_lex_state = 3},
  [43] = {.lex_state = 48, .external_lex_state = 3},
  [44] = {.lex_state = 48, .external_lex_state = 3},
  [45] = {.lex_state = 48, .external_lex_state = 3},
  [46] = {.lex_state = 48, .external_lex_state = 3},
  [47] = {.lex_state = 48, .external_lex_state = 3},
  [48] = {.lex_state = 48, .external_lex_state = 3},
  [49] = {.lex_state = 48, .external_lex_state = 3},
  [50] = {.lex_state = 48, .external_lex_state = 3},
  [51] = {.lex_state = 48, .external_lex_state = 3},
  [52] = {.lex_state = 48, .external_lex_state = 3},
  [53] = {.lex_state = 48, .external_lex_state = 3},
  [54] = {.lex_state = 48, .external_lex_state = 3},
  [55] = {.lex_state = 48, .external_lex_state = 3},
  [56] = {.lex_state = 48, .external_lex_state = 3},
  [57] = {.lex_state = 48, .external_lex_state = 3},
  [58] = {.lex_state = 48, .external_lex_state = 3},
  [59] = {.lex_state = 48, .external_lex_state = 3},
  [60] = {.lex_state = 48, .external_lex_state = 3},
  [61] = {.lex_state = 48, .external_lex_state = 3},
  [62] = {.lex_state = 48, .external_lex_state = 3},
  [63] = {.lex_state = 48, .external_lex_state = 3},
  [64] = {.lex_state = 48, .external_lex_state = 3},
  [65] = {.lex_state = 48, .external_lex_state = 3},
  [66] = {.lex_state = 48, .external_lex_state = 3},
  [67] = {.lex_state = 48, .external_lex_state = 3},
  [68] = {.lex_state = 48, .external_lex_state = 3},
  [69] = {.lex_state = 48, .external_lex_state = 3},
  [70] = {.lex_state = 48, .external_lex_state = 2},
  [71] = {.lex_state = 48, .external_lex_state = 3},
  [72] = {.lex_state = 48, .external_lex_state = 3},
  [73] = {.lex_state = 48, .external_lex_state = 3},
  [74] = {.lex_state = 48, .external_lex_state = 3},
  [75] = {.lex_state = 48, .external_lex_state = 3},
  [76] = {.lex_state = 48, .external_lex_state = 2},
  [77] = {.lex_state = 48, .external_lex_state = 3},
  [78] = {.lex_state = 48, .external_lex_state = 4},
  [79] = {.lex_state = 48, .external_lex_state = 4},
  [80] = {.lex_state = 11, .external_lex_state = 4},
  [81] = {.lex_state = 11, .external_lex_state = 4},
  [82] = {.lex_state = 48, .external_lex_state = 5},
  [83] = {.lex_state = 48, .external_lex_state = 5},
  [84] = {.lex_state = 48, .external_lex_state = 5},
  [85] = {.lex_state = 48, .external_lex_state = 5},
  [86] = {.lex_state = 48, .external_lex_state = 5},
  [87] = {.lex_state = 48, .external_lex_state = 5},
  [88] = {.lex_state = 48, .external_lex_state = 5},
  [89] = {.lex_state = 48, .external_lex_state = 5},
  [90] = {.lex_state = 48, .external_lex_state = 5},
  [91] = {.lex_state = 48, .external_lex_state = 5},
  [92] = {.lex_state = 48, .external_lex_state = 5},
  [93] = {.lex_state = 48, .external_lex_state = 5},
  [94] = {.lex_state = 48, .external_lex_state = 5},
  [95] = {.lex_state = 48, .external_lex_state = 5},
  [96] = {.lex_state = 48, .external_lex_state = 5},
  [97] = {.lex_state = 48, .external_lex_state = 5},
  [98] = {.lex_state = 48, .external_lex_state = 5},
  [99] = {.lex_state = 48, .external_lex_state = 5},
  [100] = {.lex_state = 48, .external_lex_state = 5},
  [101] = {.lex_state = 48, .external_lex_state = 5},
  [102] = {.lex_state = 48, .external_lex_state = 5},
  [103] = {.lex_state = 48, .external_lex_state = 5},
  [104] = {.lex_state = 48, .external_lex_state = 5},
  [105] = {.lex_state = 48, .external_lex_state = 5},
  [106] = {.lex_state = 48, .external_lex_state = 5},
  [107] = {.lex_state = 48, .external_lex_state = 5},
  [108] = {.lex_state = 48, .external_lex_state = 5},
  [109] = {.lex_state = 48, .external_lex_state = 5},
  [110] = {.lex_state = 48, .external_lex_state = 5},
  [111] = {.lex_state = 48, .external_lex_state = 5},
  [112] = {.lex_state = 48, .external_lex_state = 5},
  [113] = {.lex_state = 48, .external_lex_state = 5},
  [114] = {.lex_state = 48, .external_lex_state = 5},
  [115] = {.lex_state = 48, .external_lex_state = 5},
  [116] = {.lex_state = 48, .external_lex_state = 5},
  [117] = {.lex_state = 48, .external_lex_state = 5},
  [118] = {.lex_state = 48, .external_lex_state = 5},
  [119] = {.lex_state = 48, .external_lex_state = 5},
  [120] = {.lex_state = 48, .external_lex_state = 5},
  [121] = {.lex_state = 48, .external_lex_state = 5},
  [122] = {.lex_state = 48, .external_lex_state = 5},
  [123] = {.lex_state = 48, .external_lex_state = 5},
  [124] = {.lex_state = 48, .external_lex_state = 5},
  [125] = {.lex_state = 48, .external_lex_state = 5},
  [126] = {.lex_state = 48, .external_lex_state = 5},
  [127] = {.lex_state = 48, .external_lex_state = 5},
  [128] = {.lex_state = 48, .external_lex_state = 5},
  [129] = {.lex_state = 48, .external_lex_state = 5},
  [130] = {.lex_state = 48, .external_lex_state = 5},
  [131] = {.lex_state = 48, .external_lex_state = 5},
  [132] = {.lex_state = 48, .external_lex_state = 5},
  [133] = {.lex_state = 48, .external_lex_state = 5},
  [134] = {.lex_state = 48, .external_lex_state = 5},
  [135] = {.lex_state = 48, .external_lex_state = 5},
  [136] = {.lex_state = 48, .external_lex_state = 5},
  [137] = {.lex_state = 48, .external_lex_state = 5},
  [138] = {.lex_state = 48, .external_lex_state = 5},
  [139] = {.lex_state = 48, .external_lex_state = 5},
  [140] = {.lex_state = 48, .external_lex_state = 5},
  [141] = {.lex_state = 48, .external_lex_state = 5},
  [142] = {.lex_state = 48, .external_lex_state = 5},
  [143] = {.lex_state = 48, .external_lex_state = 5},
  [144] = {.lex_state = 48, .external_lex_state = 5},
  [145] = {.lex_state = 48, .external_lex_state = 5},
  [146] = {.lex_state = 48, .external_lex_state = 4},
  [147] = {.lex_state = 48, .external_lex_state = 4},
  [148] = {.lex_state = 48, .external_lex_state = 4},
  [149] = {.lex_state = 48, .external_lex_state = 4},
  [150] = {.lex_state = 48, .external_lex_state = 4},
  [151] = {.lex_state = 48, .external_lex_state = 4},
  [152] = {.lex_state = 48, .external_lex_state = 4},
  [153] = {.lex_state = 48, .external_lex_state = 4},
  [154] = {.lex_state = 48, .external_lex_state = 4},
  [155] = {.lex_state = 48, .external_lex_state = 4},
  [156] = {.lex_state = 48, .external_lex_state = 4},
  [157] = {.lex_state = 48, .external_lex_state = 4},
  [158] = {.lex_state = 48, .external_lex_state = 4},
  [159] = {.lex_state = 48, .external_lex_state = 4},
  [160] = {.lex_state = 48, .external_lex_state = 2},
  [161] = {.lex_state = 48, .external_lex_state = 4},
  [162] = {.lex_state = 11, .external_lex_state = 6},
  [163] = {.lex_state = 48, .external_lex_state = 7},
  [164] = {.lex_state = 11, .external_lex_state = 6},
  [165] = {.lex_state = 11, .external_lex_state = 2},
  [166] = {.lex_state = 48, .external_lex_state = 7},
  [167] = {.lex_state = 48, .external_lex_state = 7},
  [168] = {.lex_state = 48, .external_lex_state = 8},
  [169] = {.lex_state = 48, .external_lex_state = 7},
  [170] = {.lex_state = 11, .external_lex_state = 8},
  [171] = {.lex_state = 48, .external_lex_state = 7},
  [172] = {.lex_state = 48, .external_lex_state = 8},
  [173] = {.lex_state = 48, .external_lex_state = 7},
  [174] = {.lex_state = 48, .external_lex_state = 8},
  [175] = {.lex_state = 48, .external_lex_state = 7},
  [176] = {.lex_state = 48, .external_lex_state = 2},
  [177] = {.lex_state = 48, .external_lex_state = 7},
  [178] = {.lex_state = 48, .external_lex_state = 2},
  [179] = {.lex_state = 48, .external_lex_state = 7},
  [180] = {.lex_state = 48, .external_lex_state = 7},
  [181] = {.lex_state = 48, .external_lex_state = 8},
  [182] = {.lex_state = 48, .external_lex_state = 8},
  [183] = {.lex_state = 48, .external_lex_state = 8},
  [184] = {.lex_state = 48, .external_lex_state = 2},
  [185] = {.lex_state = 48, .external_lex_state = 8},
  [186] = {.lex_state = 48, .external_lex_state = 8},
  [187] = {.lex_state = 48, .external_lex_state = 7},
  [188] = {.lex_state = 48, .external_lex_state = 8},
  [189] = {.lex_state = 48, .external_lex_state = 7},
  [190] = {.lex_state = 48, .external_lex_state = 6},
  [191] = {.lex_state = 48, .external_lex_state = 6},
  [192] = {.lex_state = 48, .external_lex_state = 6},
  [193] = {.lex_state = 48, .external_lex_state = 6},
  [194] = {.lex_state = 48, .external_lex_state = 6},
  [195] = {.lex_state = 48, .external_lex_state = 6},
  [196] = {.lex_state = 48, .external_lex_state = 6},
  [197] = {.lex_state = 48, .external_lex_state = 6},
  [198] = {.lex_state = 11, .external_lex_state = 2},
  [199] = {.lex_state = 11, .external_lex_state = 2},
  [200] = {.lex_state = 48, .external_lex_state = 7},
  [201] = {.lex_state = 48, .external_lex_state = 7},
  [202] = {.lex_state = 48, .external_lex_state = 7},
  [203] = {.lex_state = 48, .external_lex_state = 7},
  [204] = {.lex_state = 48, .external_lex_state = 7},
  [205] = {.lex_state = 48, .external_lex_state = 7},
  [206] = {.lex_state = 48, .external_lex_state = 7},
  [207] = {.lex_state = 48, .external_lex_state = 7},
  [208] = {.lex_state = 48, .external_lex_state = 7},
  [209] = {.lex_state = 48, .external_lex_state = 7},
  [210] = {.lex_state = 48, .external_lex_state = 7},
  [211] = {.lex_state = 48, .external_lex_state = 7},
  [212] = {.lex_state = 48, .external_lex_state = 7},
  [213] = {.lex_state = 48, .external_lex_state = 7},
  [214] = {.lex_state = 48, .external_lex_state = 7},
  [215] = {.lex_state = 48, .external_lex_state = 7},
  [216] = {.lex_state = 48, .external_lex_state = 8},
  [217] = {.lex_state = 48, .external_lex_state = 8},
  [218] = {.lex_state = 48, .external_lex_state = 7},
  [219] = {.lex_state = 48, .external_lex_state = 7},
  [220] = {.lex_state = 48, .external_lex_state = 7},
  [221] = {.lex_state = 48, .external_lex_state = 7},
  [222] = {.lex_state = 48, .external_lex_state = 7},
  [223] = {.lex_state = 48, .external_lex_state = 7},
  [224] = {.lex_state = 48, .external_lex_state = 7},
  [225] = {.lex_state = 48, .external_lex_state = 7},
  [226] = {.lex_state = 48, .external_lex_state = 7},
  [227] = {.lex_state = 48, .external_lex_state = 7},
  [228] = {.lex_state = 48, .external_lex_state = 7},
  [229] = {.lex_state = 48, .external_lex_state = 7},
  [230] = {.lex_state = 48, .external_lex_state = 7},
  [231] = {.lex_state = 48, .external_lex_state = 7},
  [232] = {.lex_state = 48, .external_lex_state = 7},
  [233] = {.lex_state = 48, .external_lex_state = 7},
  [234] = {.lex_state = 48, .external_lex_state = 8},
  [235] = {.lex_state = 48, .external_lex_state = 7},
  [236] = {.lex_state = 48, .external_lex_state = 7},
  [237] = {.lex_state = 48, .external_lex_state = 7},
  [238] = {.lex_state = 48, .external_lex_state = 7},
  [239] = {.lex_state = 48, .external_lex_state = 7},
  [240] = {.lex_state = 48, .external_lex_state = 8},
  [241] = {.lex_state = 48, .external_lex_state = 8},
  [242] = {.lex_state = 48, .external_lex_state = 7},
  [243] = {.lex_state = 48, .external_lex_state = 8},
  [244] = {.lex_state = 48, .external_lex_state = 7},
  [245] = {.lex_state = 48, .external_lex_state = 7},
  [246] = {.lex_state = 48, .external_lex_state = 7},
  [247] = {.lex_state = 48, .external_lex_state = 7},
  [248] = {.lex_state = 48, .external_lex_state = 7},
  [249] = {.lex_state = 48, .external_lex_state = 7},
  [250] = {.lex_state = 48, .external_lex_state = 7},
  [251] = {.lex_state = 48, .external_lex_state = 7},
  [252] = {.lex_state = 48, .external_lex_state = 7},
  [253] = {.lex_state = 48, .external_lex_state = 8},
  [254] = {.lex_state = 48, .external_lex_state = 7},
  [255] = {.lex_state = 48, .external_lex_state = 7},
  [256] = {.lex_state = 48, .external_lex_state = 7},
  [257] = {.lex_state = 48, .external_lex_state = 7},
  [258] = {.lex_state = 48, .external_lex_state = 7},
  [259] = {.lex_state = 48, .external_lex_state = 7},
  [260] = {.lex_state = 48, .external_lex_state = 7},
  [261] = {.lex_state = 48, .external_lex_state = 7},
  [262] = {.lex_state = 48, .external_lex_state = 8},
  [263] = {.lex_state = 48, .external_lex_state = 7},
  [264] = {.lex_state = 11, .external_lex_state = 6},
  [265] = {.lex_state = 48, .external_lex_state = 7},
  [266] = {.lex_state = 48, .external_lex_state = 2},
  [267] = {.lex_state = 48, .external_lex_state = 6},
  [268] = {.lex_state = 48, .external_lex_state = 6},
  [269] = {.lex_state = 48, .external_lex_state = 7},
  [270] = {.lex_state = 48, .external_lex_state = 8},
  [271] = {.lex_state = 48, .external_lex_state = 8},
  [272] = {.lex_state = 11, .external_lex_state = 2},
  [273] = {.lex_state = 48, .external_lex_state = 7},
  [274] = {.lex_state = 48, .external_lex_state = 2},
  [275] = {.lex_state = 11, .external_lex_state = 6},
  [276] = {.lex_state = 48, .external_lex_state = 7},
  [277] = {.lex_state = 48, .external_lex_state = 7},
  [278] = {.lex_state = 48, .external_lex_state = 6},
  [279] = {.lex_state = 48, .external_lex_state = 6},
  [280] = {.lex_state = 48, .external_lex_state = 8},
  [281] = {.lex_state = 48, .external_lex_state = 6},
  [282] = {.lex_state = 11, .external_lex_state = 2},
  [283] = {.lex_state = 11, .external_lex_state = 2},
  [284] = {.lex_state = 48, .external_lex_state = 2},
  [285] = {.lex_state = 11, .external_lex_state = 2},
  [286] = {.lex_state = 48, .external_lex_state = 6},
  [287] = {.lex_state = 48, .external_lex_state = 8},
  [288] = {.lex_state = 48, .external_lex_state = 8},
  [289] = {.lex_state = 48, .external_lex_state = 8},
  [290] = {.lex_state = 48, .external_lex_state = 2},
  [291] = {.lex_state = 11, .external_lex_state = 6},
  [292] = {.lex_state = 11, .external_lex_state = 2},
  [293] = {.lex_state = 48, .external_lex_state = 7},
  [294] = {.lex_state = 11, .external_lex_state = 2},
  [295] = {.lex_state = 48, .external_lex_state = 6},
  [296] = {.lex_state = 48, .external_lex_state = 6},
  [297] = {.lex_state = 48, .external_lex_state = 6},
  [298] = {.lex_state = 48, .external_lex_state = 4},
  [299] = {.lex_state = 48, .external_lex_state = 8},
  [300] = {.lex_state = 48, .external_lex_state = 6},
  [301] = {.lex_state = 48, .external_lex_state = 6},
  [302] = {.lex_state = 48, .external_lex_state = 6},
  [303] = {.lex_state = 48, .external_lex_state = 6},
  [304] = {.lex_state = 48, .external_lex_state = 6},
  [305] = {.lex_state = 48, .external_lex_state = 2},
  [306] = {.lex_state = 48, .external_lex_state = 6},
  [307] = {.lex_state = 48, .external_lex_state = 6},
  [308] = {.lex_state = 48, .external_lex_state = 6},
  [309] = {.lex_state = 48, .external_lex_state = 6},
  [310] = {.lex_state = 48, .external_lex_state = 6},
  [311] = {.lex_state = 48, .external_lex_state = 6},
  [312] = {.lex_state = 48, .external_lex_state = 6},
  [313] = {.lex_state = 48, .external_lex_state = 4},
  [314] = {.lex_state = 48, .external_lex_state = 7},
  [315] = {.lex_state = 48, .external_lex_state = 6},
  [316] = {.lex_state = 11, .external_lex_state = 8},
  [317] = {.lex_state = 11, .external_lex_state = 8},
  [318] = {.lex_state = 13, .external_lex_state = 9},
  [319] = {.lex_state = 11, .external_lex_state = 8},
  [320] = {.lex_state = 11, .external_lex_state = 8},
  [321] = {.lex_state = 11, .external_lex_state = 8},
  [322] = {.lex_state = 48, .external_lex_state = 4},
  [323] = {.lex_state = 13, .external_lex_state = 9},
  [324] = {.lex_state = 11, .external_lex_state = 8},
  [325] = {.lex_state = 48, .external_lex_state = 2},
  [326] = {.lex_state = 11, .external_lex_state = 8},
  [327] = {.lex_state = 11, .external_lex_state = 8},
  [328] = {.lex_state = 11, .external_lex_state = 8},
  [329] = {.lex_state = 11, .external_lex_state = 8},
  [330] = {.lex_state = 11, .external_lex_state = 8},
  [331] = {.lex_state = 11, .external_lex_state = 8},
  [332] = {.lex_state = 11, .external_lex_state = 8},
  [333] = {.lex_state = 11, .external_lex_state = 8},
  [334] = {.lex_state = 11, .external_lex_state = 8},
  [335] = {.lex_state = 11, .external_lex_state = 8},
  [336] = {.lex_state = 48, .external_lex_state = 4},
  [337] = {.lex_state = 11, .external_lex_state = 8},
  [338] = {.lex_state = 11, .external_lex_state = 8},
  [339] = {.lex_state = 11, .external_lex_state = 8},
  [340] = {.lex_state = 48, .external_lex_state = 4},
  [341] = {.lex_state = 11, .external_lex_state = 8},
  [342] = {.lex_state = 11, .external_lex_state = 8},
  [343] = {.lex_state = 11, .external_lex_state = 8},
  [344] = {.lex_state = 11, .external_lex_state = 8},
  [345] = {.lex_state = 11, .external_lex_state = 8},
  [346] = {.lex_state = 11, .external_lex_state = 8},
  [347] = {.lex_state = 11, .external_lex_state = 8},
  [348] = {.lex_state = 49, .external_lex_state = 3},
  [349] = {.lex_state = 11, .external_lex_state = 2},
  [350] = {.lex_state = 50, .external_lex_state = 2},
  [351] = {.lex_state = 48, .external_lex_state = 4},
  [352] = {.lex_state = 48, .external_lex_state = 4},
  [353] = {.lex_state = 48, .external_lex_state = 8},
  [354] = {.lex_state = 48, .external_lex_state = 2},
  [355] = {.lex_state = 48, .external_lex_state = 4},
  [356] = {.lex_state = 48, .external_lex_state = 4},
  [357] = {.lex_state = 50, .external_lex_state = 3},
  [358] = {.lex_state = 48, .external_lex_state = 2},
  [359] = {.lex_state = 49, .external_lex_state = 2},
  [360] = {.lex_state = 48, .external_lex_state = 2},
  [361] = {.lex_state = 48, .external_lex_state = 2},
  [362] = {.lex_state = 48, .external_lex_state = 2},
  [363] = {.lex_state = 48, .external_lex_state = 2},
  [364] = {.lex_state = 48, .external_lex_state = 2},
  [365] = {.lex_state = 48, .external_lex_state = 2},
  [366] = {.lex_state = 50, .external_lex_state = 3},
  [367] = {.lex_state = 11, .external_lex_state = 2},
  [368] = {.lex_state = 48, .external_lex_state = 4},
  [369] = {.lex_state = 49, .external_lex_state = 3},
  [370] = {.lex_state = 48, .external_lex_state = 2},
  [371] = {.lex_state = 48, .external_lex_state = 2},
  [372] = {.lex_state = 48, .external_lex_state = 2},
  [373] = {.lex_state = 49, .external_lex_state = 2},
  [374] = {.lex_state = 50, .external_lex_state = 2},
  [375] = {.lex_state = 48, .external_lex_state = 8},
  [376] = {.lex_state = 48, .external_lex_state = 2},
  [377] = {.lex_state = 48, .external_lex_state = 2},
  [378] = {.lex_state = 48, .external_lex_state = 7},
  [379] = {.lex_state = 48, .external_lex_state = 7},
  [380] = {.lex_state = 48, .external_lex_state = 2},
  [381] = {.lex_state = 48, .external_lex_state = 2},
  [382] = {.lex_state = 48, .external_lex_state = 8},
  [383] = {.lex_state = 11, .external_lex_state = 2},
  [384] = {.lex_state = 48, .external_lex_state = 2},
  [385] = {.lex_state = 48, .external_lex_state = 2},
  [386] = {.lex_state = 11, .external_lex_state = 2},
  [387] = {.lex_state = 48, .external_lex_state = 8},
  [388] = {.lex_state = 13, .external_lex_state = 4},
  [389] = {.lex_state = 48, .external_lex_state = 2},
  [390] = {.lex_state = 11, .external_lex_state = 2},
  [391] = {.lex_state = 48, .external_lex_state = 2},
  [392] = {.lex_state = 48, .external_lex_state = 2},
  [393] = {.lex_state = 11, .external_lex_state = 2},
  [394] = {.lex_state = 11, .external_lex_state = 2},
  [395] = {.lex_state = 48, .external_lex_state = 7},
  [396] = {.lex_state = 11, .external_lex_state = 2},
  [397] = {.lex_state = 48, .external_lex_state = 2},
  [398] = {.lex_state = 48, .external_lex_state = 7},
  [399] = {.lex_state = 11, .external_lex_state = 2},
  [400] = {.lex_state = 11, .external_lex_state = 2},
  [401] = {.lex_state = 48, .external_lex_state = 4},
  [402] = {.lex_state = 11, .external_lex_state = 2},
  [403] = {.lex_state = 48, .external_lex_state = 8},
  [404] = {.lex_state = 48, .external_lex_state = 2},
  [405] = {.lex_state = 48, .external_lex_state = 2},
  [406] = {.lex_state = 13, .external_lex_state = 9},
  [407] = {.lex_state = 13, .external_lex_state = 9},
  [408] = {.lex_state = 13, .external_lex_state = 9},
  [409] = {.lex_state = 12, .external_lex_state = 9},
  [410] = {.lex_state = 12, .external_lex_state = 9},
  [411] = {.lex_state = 11, .external_lex_state = 2},
  [412] = {.lex_state = 13, .external_lex_state = 9},
  [413] = {.lex_state = 48, .external_lex_state = 2},
  [414] = {.lex_state = 11, .external_lex_state = 2},
  [415] = {.lex_state = 11, .external_lex_state = 2},
  [416] = {.lex_state = 48, .external_lex_state = 2},
  [417] = {.lex_state = 48, .external_lex_state = 2},
  [418] = {.lex_state = 48, .external_lex_state = 2},
  [419] = {.lex_state = 48, .external_lex_state = 2},
  [420] = {.lex_state = 11, .external_lex_state = 2},
  [421] = {.lex_state = 48, .external_lex_state = 2},
  [422] = {.lex_state = 48, .external_lex_state = 2},
  [423] = {.lex_state = 48, .external_lex_state = 2},
  [424] = {.lex_state = 48, .external_lex_state = 2},
  [425] = {.lex_state = 48, .external_lex_state = 2},
  [426] = {.lex_state = 48, .external_lex_state = 2},
  [427] = {.lex_state = 48, .external_lex_state = 2},
  [428] = {.lex_state = 13, .external_lex_state = 9},
  [429] = {.lex_state = 13, .external_lex_state = 9},
  [430] = {.lex_state = 11, .external_lex_state = 2},
  [431] = {.lex_state = 13, .external_lex_state = 9},
  [432] = {.lex_state = 48, .external_lex_state = 2},
  [433] = {.lex_state = 11, .external_lex_state = 2},
  [434] = {.lex_state = 11, .external_lex_state = 2},
  [435] = {.lex_state = 11, .external_lex_state = 2},
  [436] = {.lex_state = 48, .external_lex_state = 2},
  [437] = {.lex_state = 48, .external_lex_state = 2},
  [438] = {.lex_state = 48, .external_lex_state = 2},
  [439] = {.lex_state = 48, .external_lex_state = 2},
  [440] = {.lex_state = 48, .external_lex_state = 2},
  [441] = {.lex_state = 48, .external_lex_state = 2},
  [442] = {.lex_state = 48, .external_lex_state = 2},
  [443] = {.lex_state = 48, .external_lex_state = 2},
  [444] = {.lex_state = 48, .external_lex_state = 2},
  [445] = {.lex_state = 48, .external_lex_state = 2},
  [446] = {.lex_state = 13, .external_lex_state = 9},
  [447] = {.lex_state = 48, .external_lex_state = 2},
  [448] = {.lex_state = 48, .external_lex_state = 2},
  [449] = {.lex_state = 48, .external_lex_state = 2},
  [450] = {.lex_state = 48, .external_lex_state = 2},
  [451] = {.lex_state = 48, .external_lex_state = 2},
  [452] = {.lex_state = 48, .external_lex_state = 2},
  [453] = {.lex_state = 48, .external_lex_state = 2},
  [454] = {.lex_state = 48, .external_lex_state = 2},
  [455] = {.lex_state = 48, .external_lex_state = 2},
  [456] = {.lex_state = 13, .external_lex_state = 9},
  [457] = {.lex_state = 48, .external_lex_state = 2},
  [458] = {.lex_state = 48, .external_lex_state = 2},
  [459] = {.lex_state = 48, .external_lex_state = 3},
  [460] = {.lex_state = 48, .external_lex_state = 2},
  [461] = {.lex_state = 48, .external_lex_state = 3},
  [462] = {.lex_state = 48, .external_lex_state = 2},
  [463] = {.lex_state = 48, .external_lex_state = 2},
  [464] = {.lex_state = 48, .external_lex_state = 2},
  [465] = {.lex_state = 48, .external_lex_state = 2},
  [466] = {.lex_state = 48, .external_lex_state = 2},
  [467] = {.lex_state = 48, .external_lex_state = 2},
  [468] = {.lex_state = 48, .external_lex_state = 2},
  [469] = {.lex_state = 48, .external_lex_state = 2},
  [470] = {.lex_state = 48, .external_lex_state = 2},
  [471] = {.lex_state = 48, .external_lex_state = 2},
  [472] = {.lex_state = 48, .external_lex_state = 2},
  [473] = {.lex_state = 48, .external_lex_state = 2},
  [474] = {.lex_state = 48, .external_lex_state = 2},
  [475] = {.lex_state = 48, .external_lex_state = 2},
  [476] = {.lex_state = 48, .external_lex_state = 2},
  [477] = {.lex_state = 48, .external_lex_state = 2},
  [478] = {.lex_state = 48, .external_lex_state = 2},
  [479] = {.lex_state = 50, .external_lex_state = 3},
  [480] = {.lex_state = 48, .external_lex_state = 2},
  [481] = {.lex_state = 49, .external_lex_state = 3},
  [482] = {.lex_state = 49, .external_lex_state = 2},
  [483] = {.lex_state = 50, .external_lex_state = 2},
  [484] = {.lex_state = 48, .external_lex_state = 2},
  [485] = {.lex_state = 48, .external_lex_state = 2},
  [486] = {.lex_state = 48, .external_lex_state = 2},
  [487] = {.lex_state = 48, .external_lex_state = 2},
  [488] = {.lex_state = 48, .external_lex_state = 3},
  [489] = {.lex_state = 48, .external_lex_state = 2},
  [490] = {.lex_state = 48, .external_lex_state = 2},
  [491] = {.lex_state = 13, .external_lex_state = 9},
  [492] = {.lex_state = 48, .external_lex_state = 2},
  [493] = {.lex_state = 48, .external_lex_state = 2},
  [494] = {.lex_state = 48, .external_lex_state = 2},
  [495] = {.lex_state = 48, .external_lex_state = 3},
  [496] = {.lex_state = 13, .external_lex_state = 9},
  [497] = {.lex_state = 48, .external_lex_state = 2},
  [498] = {.lex_state = 48, .external_lex_state = 2},
  [499] = {.lex_state = 48, .external_lex_state = 2},
  [500] = {.lex_state = 48, .external_lex_state = 2},
  [501] = {.lex_state = 48, .external_lex_state = 2},
  [502] = {.lex_state = 48, .external_lex_state = 2},
  [503] = {.lex_state = 48, .external_lex_state = 2},
  [504] = {.lex_state = 48, .external_lex_state = 2},
  [505] = {.lex_state = 48, .external_lex_state = 2},
  [506] = {.lex_state = 48, .external_lex_state = 2},
  [507] = {.lex_state = 48, .external_lex_state = 2},
  [508] = {.lex_state = 48, .external_lex_state = 2},
  [509] = {.lex_state = 48, .external_lex_state = 2},
  [510] = {.lex_state = 48, .external_lex_state = 2},
  [511] = {.lex_state = 48, .external_lex_state = 2},
  [512] = {.lex_state = 48, .external_lex_state = 2},
  [513] = {.lex_state = 48, .external_lex_state = 2},
  [514] = {.lex_state = 48, .external_lex_state = 2},
  [515] = {.lex_state = 48, .external_lex_state = 2},
  [516] = {.lex_state = 48, .external_lex_state = 2},
  [517] = {.lex_state = 48, .external_lex_state = 2},
  [518] = {.lex_state = 48, .external_lex_state = 2},
  [519] = {.lex_state = 48, .external_lex_state = 2},
  [520] = {.lex_state = 48, .external_lex_state = 2},
  [521] = {.lex_state = 48, .external_lex_state = 2},
  [522] = {.lex_state = 48, .external_lex_state = 2},
  [523] = {.lex_state = 48, .external_lex_state = 2},
  [524] = {.lex_state = 48, .external_lex_state = 2},
  [525] = {.lex_state = 48, .external_lex_state = 2},
  [526] = {.lex_state = 48, .external_lex_state = 2},
  [527] = {.lex_state = 48, .external_lex_state = 2},
  [528] = {.lex_state = 48, .external_lex_state = 2},
  [529] = {.lex_state = 48, .external_lex_state = 2},
  [530] = {.lex_state = 48, .external_lex_state = 2},
  [531] = {.lex_state = 48, .external_lex_state = 2},
  [532] = {.lex_state = 48, .external_lex_state = 2},
  [533] = {.lex_state = 48, .external_lex_state = 2},
  [534] = {.lex_state = 48, .external_lex_state = 2},
  [535] = {.lex_state = 48, .external_lex_state = 2},
  [536] = {.lex_state = 48, .external_lex_state = 2},
  [537] = {.lex_state = 48, .external_lex_state = 2},
  [538] = {.lex_state = 48, .external_lex_state = 2},
  [539] = {.lex_state = 48, .external_lex_state = 2},
  [540] = {.lex_state = 48, .external_lex_state = 2},
  [541] = {.lex_state = 48, .external_lex_state = 2},
  [542] = {.lex_state = 48, .external_lex_state = 2},
  [543] = {.lex_state = 48, .external_lex_state = 2},
  [544] = {.lex_state = 48, .external_lex_state = 2},
  [545] = {.lex_state = 48, .external_lex_state = 2},
  [546] = {.lex_state = 48, .external_lex_state = 2},
  [547] = {.lex_state = 48, .external_lex_state = 2},
  [548] = {.lex_state = 48, .external_lex_state = 2},
  [549] = {.lex_state = 48, .external_lex_state = 2},
  [550] = {.lex_state = 48, .external_lex_state = 2},
  [551] = {.lex_state = 48, .external_lex_state = 2},
  [552] = {.lex_state = 48, .external_lex_state = 2},
  [553] = {.lex_state = 48, .external_lex_state = 2},
  [554] = {.lex_state = 48, .external_lex_state = 2},
  [555] = {.lex_state = 48, .external_lex_state = 2},
  [556] = {.lex_state = 48, .external_lex_state = 2},
  [557] = {.lex_state = 48, .external_lex_state = 2},
  [558] = {.lex_state = 48, .external_lex_state = 2},
  [559] = {.lex_state = 48, .external_lex_state = 2},
  [560] = {.lex_state = 48, .external_lex_state = 2},
  [561] = {.lex_state = 48, .external_lex_state = 2},
  [562] = {.lex_state = 48, .external_lex_state = 2},
  [563] = {.lex_state = 48, .external_lex_state = 2},
  [564] = {.lex_state = 48, .external_lex_state = 2},
  [565] = {.lex_state = 48, .external_lex_state = 2},
  [566] = {.lex_state = 48, .external_lex_state = 2},
  [567] = {.lex_state = 48, .external_lex_state = 2},
  [568] = {.lex_state = 48, .external_lex_state = 2},
  [569] = {.lex_state = 48, .external_lex_state = 2},
  [570] = {.lex_state = 48, .external_lex_state = 2},
  [571] = {.lex_state = 48, .external_lex_state = 2},
  [572] = {.lex_state = 48, .external_lex_state = 2},
  [573] = {.lex_state = 48, .external_lex_state = 3},
  [574] = {.lex_state = 48, .external_lex_state = 2},
  [575] = {.lex_state = 48, .external_lex_state = 3},
  [576] = {.lex_state = 13, .external_lex_state = 10},
  [577] = {.lex_state = 48, .external_lex_state = 3},
  [578] = {.lex_state = 13, .external_lex_state = 10},
  [579] = {.lex_state = 48, .external_lex_state = 3},
  [580] = {.lex_state = 13, .external_lex_state = 10},
  [581] = {.lex_state = 13, .external_lex_state = 10},
  [582] = {.lex_state = 48, .external_lex_state = 2},
  [583] = {.lex_state = 13, .external_lex_state = 10},
  [584] = {.lex_state = 13, .external_lex_state = 10},
  [585] = {.lex_state = 48, .external_lex_state = 2},
  [586] = {.lex_state = 48, .external_lex_state = 3},
  [587] = {.lex_state = 48, .external_lex_state = 2},
  [588] = {.lex_state = 48, .external_lex_state = 3},
  [589] = {.lex_state = 13, .external_lex_state = 10},
  [590] = {.lex_state = 48, .external_lex_state = 2},
  [591] = {.lex_state = 48, .external_lex_state = 2},
  [592] = {.lex_state = 49, .external_lex_state = 2},
  [593] = {.lex_state = 48, .external_lex_state = 3},
  [594] = {.lex_state = 50, .external_lex_state = 2},
  [595] = {.lex_state = 48, .external_lex_state = 2},
  [596] = {.lex_state = 50, .external_lex_state = 2},
  [597] = {.lex_state = 50, .external_lex_state = 3},
  [598] = {.lex_state = 49, .external_lex_state = 2},
  [599] = {.lex_state = 50, .external_lex_state = 3},
  [600] = {.lex_state = 48, .external_lex_state = 2},
  [601] = {.lex_state = 49, .external_lex_state = 3},
  [602] = {.lex_state = 50, .external_lex_state = 3},
  [603] = {.lex_state = 50, .external_lex_state = 3},
  [604] = {.lex_state = 50, .external_lex_state = 3},
  [605] = {.lex_state = 50, .external_lex_state = 3},
  [606] = {.lex_state = 50, .external_lex_state = 2},
  [607] = {.lex_state = 49, .external_lex_state = 2},
  [608] = {.lex_state = 50, .external_lex_state = 2},
  [609] = {.lex_state = 49, .external_lex_state = 2},
  [610] = {.lex_state = 50, .external_lex_state = 2},
  [611] = {.lex_state = 50, .external_lex_state = 3},
  [612] = {.lex_state = 49, .external_lex_state = 2},
  [613] = {.lex_state = 49, .external_lex_state = 3},
  [614] = {.lex_state = 48, .external_lex_state = 3},
  [615] = {.lex_state = 50, .external_lex_state = 2},
  [616] = {.lex_state = 49, .external_lex_state = 2},
  [617] = {.lex_state = 48, .external_lex_state = 2},
  [618] = {.lex_state = 50, .external_lex_state = 3},
  [619] = {.lex_state = 49, .external_lex_state = 3},
  [620] = {.lex_state = 49, .external_lex_state = 3},
  [621] = {.lex_state = 49, .external_lex_state = 2},
  [622] = {.lex_state = 50, .external_lex_state = 2},
  [623] = {.lex_state = 50, .external_lex_state = 3},
  [624] = {.lex_state = 49, .external_lex_state = 3},
  [625] = {.lex_state = 49, .external_lex_state = 2},
  [626] = {.lex_state = 49, .external_lex_state = 3},
  [627] = {.lex_state = 49, .external_lex_state = 2},
  [628] = {.lex_state = 48, .external_lex_state = 2},
  [629] = {.lex_state = 50, .external_lex_state = 2},
  [630] = {.lex_state = 48, .external_lex_state = 2},
  [631] = {.lex_state = 48, .external_lex_state = 2},
  [632] = {.lex_state = 48, .external_lex_state = 3},
  [633] = {.lex_state = 48, .external_lex_state = 3},
  [634] = {.lex_state = 49, .external_lex_state = 3},
  [635] = {.lex_state = 48, .external_lex_state = 3},
  [636] = {.lex_state = 49, .external_lex_state = 3},
  [637] = {.lex_state = 48, .external_lex_state = 2},
  [638] = {.lex_state = 49, .external_lex_state = 3},
  [639] = {.lex_state = 48, .external_lex_state = 2},
  [640] = {.lex_state = 48, .external_lex_state = 3},
  [641] = {.lex_state = 49, .external_lex_state = 3},
  [642] = {.lex_state = 48, .external_lex_state = 3},
  [643] = {.lex_state = 49, .external_lex_state = 2},
  [644] = {.lex_state = 49, .external_lex_state = 3},
  [645] = {.lex_state = 48, .external_lex_state = 2},
  [646] = {.lex_state = 48, .external_lex_state = 3},
  [647] = {.lex_state = 48, .external_lex_state = 3},
  [648] = {.lex_state = 49, .external_lex_state = 2},
  [649] = {.lex_state = 50, .external_lex_state = 2},
  [650] = {.lex_state = 48, .external_lex_state = 2},
  [651] = {.lex_state = 48, .external_lex_state = 2},
  [652] = {.lex_state = 48, .external_lex_state = 2},
  [653] = {.lex_state = 48, .external_lex_state = 3},
  [654] = {.lex_state = 48, .external_lex_state = 2},
  [655] = {.lex_state = 48, .external_lex_state = 2},
  [656] = {.lex_state = 48, .external_lex_state = 3},
  [657] = {.lex_state = 48, .external_lex_state = 3},
  [658] = {.lex_state = 48, .external_lex_state = 3},
  [659] = {.lex_state = 48, .external_lex_state = 3},
  [660] = {.lex_state = 48, .external_lex_state = 2},
  [661] = {.lex_state = 48, .external_lex_state = 3},
  [662] = {.lex_state = 48, .external_lex_state = 3},
  [663] = {.lex_state = 48, .external_lex_state = 3},
  [664] = {.lex_state = 48, .external_lex_state = 3},
  [665] = {.lex_state = 48, .external_lex_state = 2},
  [666] = {.lex_state = 48, .external_lex_state = 2},
  [667] = {.lex_state = 48, .external_lex_state = 3},
  [668] = {.lex_state = 48, .external_lex_state = 2},
  [669] = {.lex_state = 48, .external_lex_state = 3},
  [670] = {.lex_state = 48, .external_lex_state = 2},
  [671] = {.lex_state = 48, .external_lex_state = 2},
  [672] = {.lex_state = 48, .external_lex_state = 2},
  [673] = {.lex_state = 48, .external_lex_state = 3},
  [674] = {.lex_state = 48, .external_lex_state = 2},
  [675] = {.lex_state = 48, .external_lex_state = 2},
  [676] = {.lex_state = 48, .external_lex_state = 2},
  [677] = {.lex_state = 48, .external_lex_state = 2},
  [678] = {.lex_state = 48, .external_lex_state = 3},
  [679] = {.lex_state = 48, .external_lex_state = 2},
  [680] = {.lex_state = 48, .external_lex_state = 2},
  [681] = {.lex_state = 48, .external_lex_state = 2},
  [682] = {.lex_state = 48, .external_lex_state = 2},
  [683] = {.lex_state = 48, .external_lex_state = 3},
  [684] = {.lex_state = 48, .external_lex_state = 2},
  [685] = {.lex_state = 48, .external_lex_state = 3},
  [686] = {.lex_state = 48, .external_lex_state = 3},
  [687] = {.lex_state = 48, .external_lex_state = 3},
  [688] = {.lex_state = 48, .external_lex_state = 2},
  [689] = {.lex_state = 48, .external_lex_state = 3},
  [690] = {.lex_state = 48, .external_lex_state = 2},
  [691] = {.lex_state = 48, .external_lex_state = 3},
  [692] = {.lex_state = 48, .external_lex_state = 2},
  [693] = {.lex_state = 48, .external_lex_state = 2},
  [694] = {.lex_state = 48, .external_lex_state = 2},
  [695] = {.lex_state = 48, .external_lex_state = 3},
  [696] = {.lex_state = 48, .external_lex_state = 2},
  [697] = {.lex_state = 48, .external_lex_state = 2},
  [698] = {.lex_state = 48, .external_lex_state = 2},
  [699] = {.lex_state = 48, .external_lex_state = 2},
  [700] = {.lex_state = 48, .external_lex_state = 3},
  [701] = {.lex_state = 48, .external_lex_state = 2},
  [702] = {.lex_state = 48, .external_lex_state = 2},
  [703] = {.lex_state = 48, .external_lex_state = 2},
  [704] = {.lex_state = 48, .external_lex_state = 3},
  [705] = {.lex_state = 48, .external_lex_state = 2},
  [706] = {.lex_state = 48, .external_lex_state = 2},
  [707] = {.lex_state = 48, .external_lex_state = 2},
  [708] = {.lex_state = 48, .external_lex_state = 3},
  [709] = {.lex_state = 48, .external_lex_state = 3},
  [710] = {.lex_state = 48, .external_lex_state = 2},
  [711] = {.lex_state = 48, .external_lex_state = 2},
  [712] = {.lex_state = 48, .external_lex_state = 3},
  [713] = {.lex_state = 48, .external_lex_state = 3},
  [714] = {.lex_state = 48, .external_lex_state = 3},
  [715] = {.lex_state = 48, .external_lex_state = 3},
  [716] = {.lex_state = 48, .external_lex_state = 3},
  [717] = {.lex_state = 48, .external_lex_state = 2},
  [718] = {.lex_state = 48, .external_lex_state = 3},
  [719] = {.lex_state = 48, .external_lex_state = 3},
  [720] = {.lex_state = 48, .external_lex_state = 2},
  [721] = {.lex_state = 48, .external_lex_state = 3},
  [722] = {.lex_state = 48, .external_lex_state = 2},
  [723] = {.lex_state = 48, .external_lex_state = 2},
  [724] = {.lex_state = 48, .external_lex_state = 3},
  [725] = {.lex_state = 48, .external_lex_state = 2},
  [726] = {.lex_state = 48, .external_lex_state = 3},
  [727] = {.lex_state = 48, .external_lex_state = 3},
  [728] = {.lex_state = 48, .external_lex_state = 3},
  [729] = {.lex_state = 48, .external_lex_state = 3},
  [730] = {.lex_state = 48, .external_lex_state = 3},
  [731] = {.lex_state = 48, .external_lex_state = 3},
  [732] = {.lex_state = 48, .external_lex_state = 3},
  [733] = {.lex_state = 48, .external_lex_state = 3},
  [734] = {.lex_state = 48, .external_lex_state = 3},
  [735] = {.lex_state = 48, .external_lex_state = 3},
  [736] = {.lex_state = 48, .external_lex_state = 3},
  [737] = {.lex_state = 48, .external_lex_state = 3},
  [738] = {.lex_state = 48, .external_lex_state = 3},
  [739] = {.lex_state = 48, .external_lex_state = 2},
  [740] = {.lex_state = 48, .external_lex_state = 2},
  [741] = {.lex_state = 48, .external_lex_state = 2},
  [742] = {.lex_state = 48, .external_lex_state = 2},
  [743] = {.lex_state = 48, .external_lex_state = 3},
  [744] = {.lex_state = 48, .external_lex_state = 3},
  [745] = {.lex_state = 48, .external_lex_state = 3},
  [746] = {.lex_state = 48, .external_lex_state = 3},
  [747] = {.lex_state = 48, .external_lex_state = 2},
  [748] = {.lex_state = 48, .external_lex_state = 3},
  [749] = {.lex_state = 48, .external_lex_state = 2},
  [750] = {.lex_state = 48, .external_lex_state = 2},
  [751] = {.lex_state = 48, .external_lex_state = 2},
  [752] = {.lex_state = 48, .external_lex_state = 2},
  [753] = {.lex_state = 48, .external_lex_state = 3},
  [754] = {.lex_state = 48, .external_lex_state = 3},
  [755] = {.lex_state = 48, .external_lex_state = 3},
  [756] = {.lex_state = 48, .external_lex_state = 2},
  [757] = {.lex_state = 48, .external_lex_state = 3},
  [758] = {.lex_state = 48, .external_lex_state = 3},
  [759] = {.lex_state = 48, .external_lex_state = 2},
  [760] = {.lex_state = 48, .external_lex_state = 2},
  [761] = {.lex_state = 48, .external_lex_state = 3},
  [762] = {.lex_state = 48, .external_lex_state = 3},
  [763] = {.lex_state = 48, .external_lex_state = 2},
  [764] = {.lex_state = 48, .external_lex_state = 2},
  [765] = {.lex_state = 48, .external_lex_state = 3},
  [766] = {.lex_state = 48, .external_lex_state = 2},
  [767] = {.lex_state = 48, .external_lex_state = 3},
  [768] = {.lex_state = 48, .external_lex_state = 2},
  [769] = {.lex_state = 48, .external_lex_state = 3},
  [770] = {.lex_state = 48, .external_lex_state = 3},
  [771] = {.lex_state = 48, .external_lex_state = 2},
  [772] = {.lex_state = 48, .external_lex_state = 3},
  [773] = {.lex_state = 48, .external_lex_state = 3},
  [774] = {.lex_state = 48, .external_lex_state = 3},
  [775] = {.lex_state = 48, .external_lex_state = 2},
  [776] = {.lex_state = 48, .external_lex_state = 2},
  [777] = {.lex_state = 48, .external_lex_state = 2},
  [778] = {.lex_state = 48, .external_lex_state = 2},
  [779] = {.lex_state = 48, .external_lex_state = 3},
  [780] = {.lex_state = 48, .external_lex_state = 2},
  [781] = {.lex_state = 48, .external_lex_state = 2},
  [782] = {.lex_state = 48, .external_lex_state = 3},
  [783] = {.lex_state = 48, .external_lex_state = 2},
  [784] = {.lex_state = 48, .external_lex_state = 2},
  [785] = {.lex_state = 48, .external_lex_state = 2},
  [786] = {.lex_state = 48, .external_lex_state = 7},
  [787] = {.lex_state = 48, .external_lex_state = 2},
  [788] = {.lex_state = 48, .external_lex_state = 3},
  [789] = {.lex_state = 48, .external_lex_state = 3},
  [790] = {.lex_state = 48, .external_lex_state = 3},
  [791] = {.lex_state = 48, .external_lex_state = 2},
  [792] = {.lex_state = 48, .external_lex_state = 3},
  [793] = {.lex_state = 48, .external_lex_state = 2},
  [794] = {.lex_state = 48, .external_lex_state = 3},
  [795] = {.lex_state = 48, .external_lex_state = 7},
  [796] = {.lex_state = 48, .external_lex_state = 2},
  [797] = {.lex_state = 48, .external_lex_state = 3},
  [798] = {.lex_state = 48, .external_lex_state = 2},
  [799] = {.lex_state = 48, .external_lex_state = 3},
  [800] = {.lex_state = 48, .external_lex_state = 2},
  [801] = {.lex_state = 48, .external_lex_state = 3},
  [802] = {.lex_state = 48, .external_lex_state = 3},
  [803] = {.lex_state = 48, .external_lex_state = 3},
  [804] = {.lex_state = 48, .external_lex_state = 2},
  [805] = {.lex_state = 48, .external_lex_state = 2},
  [806] = {.lex_state = 48, .external_lex_state = 2},
  [807] = {.lex_state = 48, .external_lex_state = 3},
  [808] = {.lex_state = 48, .external_lex_state = 2},
  [809] = {.lex_state = 48, .external_lex_state = 2},
  [810] = {.lex_state = 48, .external_lex_state = 3},
  [811] = {.lex_state = 48, .external_lex_state = 3},
  [812] = {.lex_state = 48, .external_lex_state = 2},
  [813] = {.lex_state = 48, .external_lex_state = 3},
  [814] = {.lex_state = 48, .external_lex_state = 7},
  [815] = {.lex_state = 48, .external_lex_state = 2},
  [816] = {.lex_state = 48, .external_lex_state = 2},
  [817] = {.lex_state = 48, .external_lex_state = 7},
  [818] = {.lex_state = 48, .external_lex_state = 2},
  [819] = {.lex_state = 48, .external_lex_state = 2},
  [820] = {.lex_state = 48, .external_lex_state = 2},
  [821] = {.lex_state = 48, .external_lex_state = 8},
  [822] = {.lex_state = 48, .external_lex_state = 2},
  [823] = {.lex_state = 48, .external_lex_state = 2},
  [824] = {.lex_state = 48, .external_lex_state = 2},
  [825] = {.lex_state = 48, .external_lex_state = 2},
  [826] = {.lex_state = 48, .external_lex_state = 8},
  [827] = {.lex_state = 48, .external_lex_state = 2},
  [828] = {.lex_state = 48, .external_lex_state = 2},
  [829] = {.lex_state = 48, .external_lex_state = 2},
  [830] = {.lex_state = 48, .external_lex_state = 2},
  [831] = {.lex_state = 13, .external_lex_state = 11},
  [832] = {.lex_state = 13, .external_lex_state = 6},
  [833] = {.lex_state = 13, .external_lex_state = 6},
  [834] = {.lex_state = 13, .external_lex_state = 4},
  [835] = {.lex_state = 13, .external_lex_state = 6},
  [836] = {.lex_state = 48, .external_lex_state = 7},
  [837] = {.lex_state = 13, .external_lex_state = 4},
  [838] = {.lex_state = 13, .external_lex_state = 6},
  [839] = {.lex_state = 13, .external_lex_state = 6},
  [840] = {.lex_state = 13, .external_lex_state = 4},
  [841] = {.lex_state = 11, .external_lex_state = 2},
  [842] = {.lex_state = 13, .external_lex_state = 9},
  [843] = {.lex_state = 13, .external_lex_state = 6},
  [844] = {.lex_state = 13, .external_lex_state = 11},
  [845] = {.lex_state = 13, .external_lex_state = 11},
  [846] = {.lex_state = 13, .external_lex_state = 9},
  [847] = {.lex_state = 13, .external_lex_state = 11},
  [848] = {.lex_state = 13, .external_lex_state = 8},
  [849] = {.lex_state = 13, .external_lex_state = 11},
  [850] = {.lex_state = 48, .external_lex_state = 2},
  [851] = {.lex_state = 48, .external_lex_state = 2},
  [852] = {.lex_state = 13, .external_lex_state = 11},
  [853] = {.lex_state = 48, .external_lex_state = 2},
  [854] = {.lex_state = 13, .external_lex_state = 11},
  [855] = {.lex_state = 13, .external_lex_state = 8},
  [856] = {.lex_state = 13, .external_lex_state = 7},
  [857] = {.lex_state = 13, .external_lex_state = 11},
  [858] = {.lex_state = 13, .external_lex_state = 9},
  [859] = {.lex_state = 13, .external_lex_state = 2},
  [860] = {.lex_state = 13, .external_lex_state = 11},
  [861] = {.lex_state = 13, .external_lex_state = 2},
  [862] = {.lex_state = 13, .external_lex_state = 9},
  [863] = {.lex_state = 13, .external_lex_state = 11},
  [864] = {.lex_state = 13, .external_lex_state = 11},
  [865] = {.lex_state = 13, .external_lex_state = 7},
  [866] = {.lex_state = 13, .external_lex_state = 7},
  [867] = {.lex_state = 48, .external_lex_state = 2},
  [868] = {.lex_state = 13, .external_lex_state = 11},
  [869] = {.lex_state = 13, .external_lex_state = 10},
  [870] = {.lex_state = 13, .external_lex_state = 8},
  [871] = {.lex_state = 48, .external_lex_state = 2},
  [872] = {.lex_state = 48, .external_lex_state = 2},
  [873] = {.lex_state = 13, .external_lex_state = 11},
  [874] = {.lex_state = 13, .external_lex_state = 12},
  [875] = {.lex_state = 13, .external_lex_state = 11},
  [876] = {.lex_state = 13, .external_lex_state = 13},
  [877] = {.lex_state = 13, .external_lex_state = 11},
  [878] = {.lex_state = 13, .external_lex_state = 9},
  [879] = {.lex_state = 13, .external_lex_state = 11},
  [880] = {.lex_state = 13, .external_lex_state = 9},
  [881] = {.lex_state = 13, .external_lex_state = 11},
  [882] = {.lex_state = 13, .external_lex_state = 9},
  [883] = {.lex_state = 13, .external_lex_state = 11},
  [884] = {.lex_state = 13, .external_lex_state = 11},
  [885] = {.lex_state = 13, .external_lex_state = 11},
  [886] = {.lex_state = 13, .external_lex_state = 9},
  [887] = {.lex_state = 13, .external_lex_state = 11},
  [888] = {.lex_state = 13, .external_lex_state = 9},
  [889] = {.lex_state = 48, .external_lex_state = 2},
  [890] = {.lex_state = 13, .external_lex_state = 11},
  [891] = {.lex_state = 13, .external_lex_state = 2},
  [892] = {.lex_state = 13, .external_lex_state = 9},
  [893] = {.lex_state = 13, .external_lex_state = 9},
  [894] = {.lex_state = 48, .external_lex_state = 2},
  [895] = {.lex_state = 13, .external_lex_state = 10},
  [896] = {.lex_state = 48, .external_lex_state = 2},
  [897] = {.lex_state = 48, .external_lex_state = 2},
  [898] = {.lex_state = 48, .external_lex_state = 2},
  [899] = {.lex_state = 48, .external_lex_state = 2},
  [900] = {.lex_state = 13, .external_lex_state = 13},
  [901] = {.lex_state = 13, .external_lex_state = 4},
  [902] = {.lex_state = 12, .external_lex_state = 9},
  [903] = {.lex_state = 12, .external_lex_state = 9},
  [904] = {.lex_state = 48, .external_lex_state = 2},
  [905] = {.lex_state = 48, .external_lex_state = 2},
  [906] = {.lex_state = 48, .external_lex_state = 2},
  [907] = {.lex_state = 48, .external_lex_state = 2},
  [908] = {.lex_state = 48, .external_lex_state = 2},
  [909] = {.lex_state = 48, .external_lex_state = 2},
  [910] = {.lex_state = 48, .external_lex_state = 2},
  [911] = {.lex_state = 48, .external_lex_state = 2},
  [912] = {.lex_state = 48, .external_lex_state = 2},
  [913] = {.lex_state = 48, .external_lex_state = 2},
  [914] = {.lex_state = 48, .external_lex_state = 2},
  [915] = {.lex_state = 48, .external_lex_state = 2},
  [916] = {.lex_state = 48, .external_lex_state = 2},
  [917] = {.lex_state = 13, .external_lex_state = 4},
  [918] = {.lex_state = 48, .external_lex_state = 2},
  [919] = {.lex_state = 48, .external_lex_state = 2},
  [920] = {.lex_state = 48, .external_lex_state = 2},
  [921] = {.lex_state = 12, .external_lex_state = 13},
  [922] = {.lex_state = 12, .external_lex_state = 13},
  [923] = {.lex_state = 48, .external_lex_state = 2},
  [924] = {.lex_state = 48, .external_lex_state = 2},
  [925] = {.lex_state = 48, .external_lex_state = 2},
  [926] = {.lex_state = 48, .external_lex_state = 2},
  [927] = {.lex_state = 13, .external_lex_state = 8},
  [928] = {.lex_state = 48, .external_lex_state = 2},
  [929] = {.lex_state = 13, .external_lex_state = 8},
  [930] = {.lex_state = 48, .external_lex_state = 2},
  [931] = {.lex_state = 48, .external_lex_state = 2},
  [932] = {.lex_state = 48, .external_lex_state = 2},
  [933] = {.lex_state = 48, .external_lex_state = 2},
  [934] = {.lex_state = 48, .external_lex_state = 2},
  [935] = {.lex_state = 48, .external_lex_state = 2},
  [936] = {.lex_state = 48, .external_lex_state = 2},
  [937] = {.lex_state = 13, .external_lex_state = 8},
  [938] = {.lex_state = 13, .external_lex_state = 12},
  [939] = {.lex_state = 13, .external_lex_state = 7},
  [940] = {.lex_state = 48, .external_lex_state = 2},
  [941] = {.lex_state = 13, .external_lex_state = 6},
  [942] = {.lex_state = 13, .external_lex_state = 7},
  [943] = {.lex_state = 48, .external_lex_state = 2},
  [944] = {.lex_state = 48, .external_lex_state = 2},
  [945] = {.lex_state = 48, .external_lex_state = 2},
  [946] = {.lex_state = 48, .external_lex_state = 2},
  [947] = {.lex_state = 48, .external_lex_state = 2},
  [948] = {.lex_state = 48, .external_lex_state = 2},
  [949] = {.lex_state = 48, .external_lex_state = 2},
  [950] = {.lex_state = 48, .external_lex_state = 2},
  [951] = {.lex_state = 13, .external_lex_state = 6},
  [952] = {.lex_state = 13, .external_lex_state = 13},
  [953] = {.lex_state = 13, .external_lex_state = 13},
  [954] = {.lex_state = 13, .external_lex_state = 7},
  [955] = {.lex_state = 13, .external_lex_state = 13},
  [956] = {.lex_state = 48, .external_lex_state = 2},
  [957] = {.lex_state = 13, .external_lex_state = 6},
  [958] = {.lex_state = 13, .external_lex_state = 13},
  [959] = {.lex_state = 48, .external_lex_state = 2},
  [960] = {.lex_state = 13, .external_lex_state = 13},
  [961] = {.lex_state = 48, .external_lex_state = 2},
  [962] = {.lex_state = 13, .external_lex_state = 13},
  [963] = {.lex_state = 13, .external_lex_state = 13},
  [964] = {.lex_state = 13, .external_lex_state = 13},
  [965] = {.lex_state = 13, .external_lex_state = 13},
  [966] = {.lex_state = 48, .external_lex_state = 2},
  [967] = {.lex_state = 48, .external_lex_state = 2},
  [968] = {.lex_state = 48, .external_lex_state = 2},
  [969] = {.lex_state = 48, .external_lex_state = 2},
  [970] = {.lex_state = 48, .external_lex_state = 2},
  [971] = {.lex_state = 48, .external_lex_state = 2},
  [972] = {.lex_state = 48, .external_lex_state = 2},
  [973] = {.lex_state = 13, .external_lex_state = 6},
  [974] = {.lex_state = 48, .external_lex_state = 2},
  [975] = {.lex_state = 48, .external_lex_state = 2},
  [976] = {.lex_state = 48, .external_lex_state = 2},
  [977] = {.lex_state = 48, .external_lex_state = 2},
  [978] = {.lex_state = 48, .external_lex_state = 2},
  [979] = {.lex_state = 48, .external_lex_state = 2},
  [980] = {.lex_state = 48, .external_lex_state = 2},
  [981] = {.lex_state = 48, .external_lex_state = 2},
  [982] = {.lex_state = 48, .external_lex_state = 2},
  [983] = {.lex_state = 13, .external_lex_state = 12},
  [984] = {.lex_state = 13, .external_lex_state = 12},
  [985] = {.lex_state = 13, .external_lex_state = 12},
  [986] = {.lex_state = 13, .external_lex_state = 12},
  [987] = {.lex_state = 13, .external_lex_state = 12},
  [988] = {.lex_state = 48, .external_lex_state = 2},
  [989] = {.lex_state = 13, .external_lex_state = 12},
  [990] = {.lex_state = 13, .external_lex_state = 12},
  [991] = {.lex_state = 13, .external_lex_state = 12},
  [992] = {.lex_state = 13, .external_lex_state = 12},
  [993] = {.lex_state = 48, .external_lex_state = 2},
  [994] = {.lex_state = 48, .external_lex_state = 2},
  [995] = {.lex_state = 48, .external_lex_state = 2},
  [996] = {.lex_state = 48, .external_lex_state = 2},
  [997] = {.lex_state = 48, .external_lex_state = 2},
  [998] = {.lex_state = 48, .external_lex_state = 2},
  [999] = {.lex_state = 48, .external_lex_state = 2},
  [1000] = {.lex_state = 48, .external_lex_state = 2},
  [1001] = {.lex_state = 13, .external_lex_state = 12},
  [1002] = {.lex_state = 12, .external_lex_state = 11},
  [1003] = {.lex_state = 12, .external_lex_state = 11},
  [1004] = {.lex_state = 13, .external_lex_state = 10},
  [1005] = {.lex_state = 13, .external_lex_state = 13},
  [1006] = {.lex_state = 13, .external_lex_state = 10},
  [1007] = {.lex_state = 13, .external_lex_state = 10},
  [1008] = {.lex_state = 13, .external_lex_state = 10},
  [1009] = {.lex_state = 48, .external_lex_state = 2},
  [1010] = {.lex_state = 13, .external_lex_state = 10},
  [1011] = {.lex_state = 13, .external_lex_state = 10},
  [1012] = {.lex_state = 13, .external_lex_state = 10},
  [1013] = {.lex_state = 13, .external_lex_state = 10},
  [1014] = {.lex_state = 48, .external_lex_state = 2},
  [1015] = {.lex_state = 48, .external_lex_state = 2},
  [1016] = {.lex_state = 48, .external_lex_state = 2},
  [1017] = {.lex_state = 48, .external_lex_state = 2},
  [1018] = {.lex_state = 48, .external_lex_state = 2},
  [1019] = {.lex_state = 48, .external_lex_state = 2},
  [1020] = {.lex_state = 48, .external_lex_state = 2},
  [1021] = {.lex_state = 48, .external_lex_state = 2},
  [1022] = {.lex_state = 48, .external_lex_state = 2},
  [1023] = {.lex_state = 48, .external_lex_state = 2},
  [1024] = {.lex_state = 48, .external_lex_state = 2},
  [1025] = {.lex_state = 48, .external_lex_state = 2},
  [1026] = {.lex_state = 48, .external_lex_state = 2},
  [1027] = {.lex_state = 48, .external_lex_state = 2},
  [1028] = {.lex_state = 48, .external_lex_state = 2},
  [1029] = {.lex_state = 12, .external_lex_state = 11},
  [1030] = {.lex_state = 12, .external_lex_state = 11},
  [1031] = {.lex_state = 48, .external_lex_state = 2},
  [1032] = {.lex_state = 13, .external_lex_state = 10},
  [1033] = {.lex_state = 13, .external_lex_state = 12},
  [1034] = {.lex_state = 13, .external_lex_state = 9},
  [1035] = {.lex_state = 13, .external_lex_state = 9},
  [1036] = {.lex_state = 13, .external_lex_state = 11},
  [1037] = {.lex_state = 13, .external_lex_state = 9},
  [1038] = {.lex_state = 13, .external_lex_state = 9},
  [1039] = {.lex_state = 13, .external_lex_state = 9},
  [1040] = {.lex_state = 13, .external_lex_state = 13},
  [1041] = {.lex_state = 13, .external_lex_state = 9},
  [1042] = {.lex_state = 13, .external_lex_state = 9},
  [1043] = {.lex_state = 13, .external_lex_state = 9},
  [1044] = {.lex_state = 13, .external_lex_state = 9},
  [1045] = {.lex_state = 13, .external_lex_state = 13},
  [1046] = {.lex_state = 13, .external_lex_state = 13},
  [1047] = {.lex_state = 13, .external_lex_state = 13},
  [1048] = {.lex_state = 13, .external_lex_state = 9},
  [1049] = {.lex_state = 13, .external_lex_state = 2},
  [1050] = {.lex_state = 13, .external_lex_state = 9},
  [1051] = {.lex_state = 13, .external_lex_state = 9},
  [1052] = {.lex_state = 13, .external_lex_state = 9},
  [1053] = {.lex_state = 13, .external_lex_state = 12},
  [1054] = {.lex_state = 13, .external_lex_state = 12},
  [1055] = {.lex_state = 13, .external_lex_state = 12},
  [1056] = {.lex_state = 13, .external_lex_state = 12},
  [1057] = {.lex_state = 13, .external_lex_state = 12},
  [1058] = {.lex_state = 13, .external_lex_state = 2},
  [1059] = {.lex_state = 13, .external_lex_state = 12},
  [1060] = {.lex_state = 13, .external_lex_state = 12},
  [1061] = {.lex_state = 13, .external_lex_state = 12},
  [1062] = {.lex_state = 13, .external_lex_state = 9},
  [1063] = {.lex_state = 13, .external_lex_state = 13},
  [1064] = {.lex_state = 13, .external_lex_state = 13},
  [1065] = {.lex_state = 13, .external_lex_state = 9},
  [1066] = {.lex_state = 13, .external_lex_state = 9},
  [1067] = {.lex_state = 13, .external_lex_state = 11},
  [1068] = {.lex_state = 13, .external_lex_state = 11},
  [1069] = {.lex_state = 13, .external_lex_state = 9},
  [1070] = {.lex_state = 13, .external_lex_state = 9},
  [1071] = {.lex_state = 13, .external_lex_state = 12},
  [1072] = {.lex_state = 13, .external_lex_state = 13},
  [1073] = {.lex_state = 13, .external_lex_state = 13},
  [1074] = {.lex_state = 13, .external_lex_state = 13},
  [1075] = {.lex_state = 13, .external_lex_state = 13},
  [1076] = {.lex_state = 13, .external_lex_state = 13},
  [1077] = {.lex_state = 13, .external_lex_state = 13},
  [1078] = {.lex_state = 13, .external_lex_state = 13},
  [1079] = {.lex_state = 13, .external_lex_state = 13},
  [1080] = {.lex_state = 13, .external_lex_state = 13},
  [1081] = {.lex_state = 13, .external_lex_state = 13},
  [1082] = {.lex_state = 12, .external_lex_state = 12},
  [1083] = {.lex_state = 12, .external_lex_state = 12},
  [1084] = {.lex_state = 13, .external_lex_state = 11},
  [1085] = {.lex_state = 13, .external_lex_state = 11},
  [1086] = {.lex_state = 13, .external_lex_state = 11},
  [1087] = {.lex_state = 13, .external_lex_state = 11},
  [1088] = {.lex_state = 13, .external_lex_state = 11},
  [1089] = {.lex_state = 13, .external_lex_state = 11},
  [1090] = {.lex_state = 13, .external_lex_state = 11},
  [1091] = {.lex_state = 13, .external_lex_state = 11},
  [1092] = {.lex_state = 12, .external_lex_state = 12},
  [1093] = {.lex_state = 13, .external_lex_state = 11},
  [1094] = {.lex_state = 13, .external_lex_state = 7},
  [1095] = {.lex_state = 13, .external_lex_state = 11},
  [1096] = {.lex_state = 13, .external_lex_state = 11},
  [1097] = {.lex_state = 13, .external_lex_state = 11},
  [1098] = {.lex_state = 13, .external_lex_state = 13},
  [1099] = {.lex_state = 13, .external_lex_state = 11},
  [1100] = {.lex_state = 13, .external_lex_state = 11},
  [1101] = {.lex_state = 13, .external_lex_state = 11},
  [1102] = {.lex_state = 13, .external_lex_state = 11},
  [1103] = {.lex_state = 13, .external_lex_state = 11},
  [1104] = {.lex_state = 13, .external_lex_state = 11},
  [1105] = {.lex_state = 13, .external_lex_state = 9},
  [1106] = {.lex_state = 13, .external_lex_state = 11},
  [1107] = {.lex_state = 13, .external_lex_state = 11},
  [1108] = {.lex_state = 13, .external_lex_state = 11},
  [1109] = {.lex_state = 13, .external_lex_state = 11},
  [1110] = {.lex_state = 13, .external_lex_state = 11},
  [1111] = {.lex_state = 13, .external_lex_state = 11},
  [1112] = {.lex_state = 13, .external_lex_state = 11},
  [1113] = {.lex_state = 13, .external_lex_state = 13},
  [1114] = {.lex_state = 13, .external_lex_state = 9},
  [1115] = {.lex_state = 13, .external_lex_state = 11},
  [1116] = {.lex_state = 13, .external_lex_state = 9},
  [1117] = {.lex_state = 12, .external_lex_state = 13},
  [1118] = {.lex_state = 13, .external_lex_state = 11},
  [1119] = {.lex_state = 13, .external_lex_state = 11},
  [1120] = {.lex_state = 12, .external_lex_state = 10},
  [1121] = {.lex_state = 12, .external_lex_state = 10},
  [1122] = {.lex_state = 13, .external_lex_state = 11},
  [1123] = {.lex_state = 13, .external_lex_state = 11},
  [1124] = {.lex_state = 13, .external_lex_state = 11},
  [1125] = {.lex_state = 13, .external_lex_state = 11},
  [1126] = {.lex_state = 13, .external_lex_state = 11},
  [1127] = {.lex_state = 13, .external_lex_state = 11},
  [1128] = {.lex_state = 13, .external_lex_state = 11},
  [1129] = {.lex_state = 13, .external_lex_state = 11},
  [1130] = {.lex_state = 13, .external_lex_state = 11},
  [1131] = {.lex_state = 13, .external_lex_state = 11},
  [1132] = {.lex_state = 13, .external_lex_state = 11},
  [1133] = {.lex_state = 13, .external_lex_state = 9},
  [1134] = {.lex_state = 13, .external_lex_state = 11},
  [1135] = {.lex_state = 13, .external_lex_state = 11},
  [1136] = {.lex_state = 13, .external_lex_state = 11},
  [1137] = {.lex_state = 13, .external_lex_state = 11},
  [1138] = {.lex_state = 13, .external_lex_state = 11},
  [1139] = {.lex_state = 13, .external_lex_state = 11},
  [1140] = {.lex_state = 13, .external_lex_state = 11},
  [1141] = {.lex_state = 12, .external_lex_state = 12},
  [1142] = {.lex_state = 13, .external_lex_state = 11},
  [1143] = {.lex_state = 13, .external_lex_state = 11},
  [1144] = {.lex_state = 13, .external_lex_state = 11},
  [1145] = {.lex_state = 13, .external_lex_state = 11},
  [1146] = {.lex_state = 13, .external_lex_state = 11},
  [1147] = {.lex_state = 13, .external_lex_state = 9},
  [1148] = {.lex_state = 13, .external_lex_state = 11},
  [1149] = {.lex_state = 13, .external_lex_state = 11},
  [1150] = {.lex_state = 13, .external_lex_state = 8},
  [1151] = {.lex_state = 13, .external_lex_state = 9},
  [1152] = {.lex_state = 13, .external_lex_state = 11},
  [1153] = {.lex_state = 13, .external_lex_state = 11},
  [1154] = {.lex_state = 12, .external_lex_state = 13},
  [1155] = {.lex_state = 12, .external_lex_state = 13},
  [1156] = {.lex_state = 13, .external_lex_state = 11},
  [1157] = {.lex_state = 13, .external_lex_state = 8},
  [1158] = {.lex_state = 13, .external_lex_state = 7},
  [1159] = {.lex_state = 13, .external_lex_state = 11},
  [1160] = {.lex_state = 13, .external_lex_state = 11},
  [1161] = {.lex_state = 13, .external_lex_state = 11},
  [1162] = {.lex_state = 13, .external_lex_state = 11},
  [1163] = {.lex_state = 13, .external_lex_state = 11},
  [1164] = {.lex_state = 12, .external_lex_state = 13},
  [1165] = {.lex_state = 13, .external_lex_state = 9},
  [1166] = {.lex_state = 13, .external_lex_state = 12},
  [1167] = {.lex_state = 12, .external_lex_state = 13},
  [1168] = {.lex_state = 13, .external_lex_state = 10},
  [1169] = {.lex_state = 13, .external_lex_state = 10},
  [1170] = {.lex_state = 13, .external_lex_state = 10},
  [1171] = {.lex_state = 13, .external_lex_state = 12},
  [1172] = {.lex_state = 13, .external_lex_state = 13},
  [1173] = {.lex_state = 13, .external_lex_state = 8},
  [1174] = {.lex_state = 13, .external_lex_state = 12},
  [1175] = {.lex_state = 13, .external_lex_state = 12},
  [1176] = {.lex_state = 13, .external_lex_state = 12},
  [1177] = {.lex_state = 13, .external_lex_state = 12},
  [1178] = {.lex_state = 13, .external_lex_state = 10},
  [1179] = {.lex_state = 13, .external_lex_state = 13},
  [1180] = {.lex_state = 13, .external_lex_state = 13},
  [1181] = {.lex_state = 13, .external_lex_state = 13},
  [1182] = {.lex_state = 13, .external_lex_state = 13},
  [1183] = {.lex_state = 13, .external_lex_state = 13},
  [1184] = {.lex_state = 13, .external_lex_state = 13},
  [1185] = {.lex_state = 13, .external_lex_state = 13},
  [1186] = {.lex_state = 13, .external_lex_state = 13},
  [1187] = {.lex_state = 13, .external_lex_state = 12},
  [1188] = {.lex_state = 12, .external_lex_state = 13},
  [1189] = {.lex_state = 12, .external_lex_state = 13},
  [1190] = {.lex_state = 13, .external_lex_state = 13},
  [1191] = {.lex_state = 13, .external_lex_state = 13},
  [1192] = {.lex_state = 13, .external_lex_state = 10},
  [1193] = {.lex_state = 13, .external_lex_state = 12},
  [1194] = {.lex_state = 13, .external_lex_state = 10},
  [1195] = {.lex_state = 13, .external_lex_state = 13},
  [1196] = {.lex_state = 13, .external_lex_state = 13},
  [1197] = {.lex_state = 13, .external_lex_state = 12},
  [1198] = {.lex_state = 13, .external_lex_state = 12},
  [1199] = {.lex_state = 13, .external_lex_state = 13},
  [1200] = {.lex_state = 13, .external_lex_state = 12},
  [1201] = {.lex_state = 13, .external_lex_state = 12},
  [1202] = {.lex_state = 13, .external_lex_state = 10},
  [1203] = {.lex_state = 13, .external_lex_state = 12},
  [1204] = {.lex_state = 13, .external_lex_state = 10},
  [1205] = {.lex_state = 13, .external_lex_state = 12},
  [1206] = {.lex_state = 12, .external_lex_state = 13},
  [1207] = {.lex_state = 13, .external_lex_state = 12},
  [1208] = {.lex_state = 13, .external_lex_state = 12},
  [1209] = {.lex_state = 13, .external_lex_state = 13},
  [1210] = {.lex_state = 13, .external_lex_state = 8},
  [1211] = {.lex_state = 13, .external_lex_state = 10},
  [1212] = {.lex_state = 13, .external_lex_state = 10},
  [1213] = {.lex_state = 13, .external_lex_state = 10},
  [1214] = {.lex_state = 13, .external_lex_state = 10},
  [1215] = {.lex_state = 13, .external_lex_state = 10},
  [1216] = {.lex_state = 13, .external_lex_state = 12},
  [1217] = {.lex_state = 13, .external_lex_state = 10},
  [1218] = {.lex_state = 13, .external_lex_state = 13},
  [1219] = {.lex_state = 13, .external_lex_state = 10},
  [1220] = {.lex_state = 13, .external_lex_state = 10},
  [1221] = {.lex_state = 13, .external_lex_state = 10},
  [1222] = {.lex_state = 13, .external_lex_state = 10},
  [1223] = {.lex_state = 13, .external_lex_state = 10},
  [1224] = {.lex_state = 13, .external_lex_state = 10},
  [1225] = {.lex_state = 13, .external_lex_state = 13},
  [1226] = {.lex_state = 13, .external_lex_state = 13},
  [1227] = {.lex_state = 13, .external_lex_state = 10},
  [1228] = {.lex_state = 13, .external_lex_state = 13},
  [1229] = {.lex_state = 13, .external_lex_state = 12},
  [1230] = {.lex_state = 13, .external_lex_state = 10},
  [1231] = {.lex_state = 13, .external_lex_state = 10},
  [1232] = {.lex_state = 13, .external_lex_state = 12},
  [1233] = {.lex_state = 13, .external_lex_state = 7},
  [1234] = {.lex_state = 13, .external_lex_state = 12},
  [1235] = {.lex_state = 13, .external_lex_state = 12},
  [1236] = {.lex_state = 13, .external_lex_state = 12},
  [1237] = {.lex_state = 12, .external_lex_state = 12},
  [1238] = {.lex_state = 13, .external_lex_state = 13},
  [1239] = {.lex_state = 13, .external_lex_state = 12},
  [1240] = {.lex_state = 13, .external_lex_state = 12},
  [1241] = {.lex_state = 13, .external_lex_state = 12},
  [1242] = {.lex_state = 13, .external_lex_state = 13},
  [1243] = {.lex_state = 12, .external_lex_state = 12},
  [1244] = {.lex_state = 13, .external_lex_state = 10},
  [1245] = {.lex_state = 13, .external_lex_state = 10},
  [1246] = {.lex_state = 13, .external_lex_state = 13},
  [1247] = {.lex_state = 13, .external_lex_state = 12},
  [1248] = {.lex_state = 13, .external_lex_state = 12},
  [1249] = {.lex_state = 13, .external_lex_state = 12},
  [1250] = {.lex_state = 13, .external_lex_state = 12},
  [1251] = {.lex_state = 13, .external_lex_state = 12},
  [1252] = {.lex_state = 13, .external_lex_state = 12},
  [1253] = {.lex_state = 13, .external_lex_state = 12},
  [1254] = {.lex_state = 13, .external_lex_state = 12},
  [1255] = {.lex_state = 13, .external_lex_state = 12},
  [1256] = {.lex_state = 13, .external_lex_state = 13},
  [1257] = {.lex_state = 13, .external_lex_state = 13},
  [1258] = {.lex_state = 13, .external_lex_state = 10},
  [1259] = {.lex_state = 13, .external_lex_state = 13},
  [1260] = {.lex_state = 13, .external_lex_state = 13},
  [1261] = {.lex_state = 13, .external_lex_state = 12},
  [1262] = {.lex_state = 13, .external_lex_state = 12},
  [1263] = {.lex_state = 13, .external_lex_state = 10},
  [1264] = {.lex_state = 13, .external_lex_state = 7},
  [1265] = {.lex_state = 13, .external_lex_state = 13},
  [1266] = {.lex_state = 13, .external_lex_state = 13},
  [1267] = {.lex_state = 13, .external_lex_state = 13},
  [1268] = {.lex_state = 13, .external_lex_state = 13},
  [1269] = {.lex_state = 13, .external_lex_state = 12},
  [1270] = {.lex_state = 12, .external_lex_state = 12},
  [1271] = {.lex_state = 13, .external_lex_state = 13},
  [1272] = {.lex_state = 13, .external_lex_state = 13},
  [1273] = {.lex_state = 13, .external_lex_state = 10},
  [1274] = {.lex_state = 13, .external_lex_state = 13},
  [1275] = {.lex_state = 13, .external_lex_state = 10},
  [1276] = {.lex_state = 13, .external_lex_state = 10},
  [1277] = {.lex_state = 13, .external_lex_state = 12},
  [1278] = {.lex_state = 13, .external_lex_state = 12},
  [1279] = {.lex_state = 13, .external_lex_state = 12},
  [1280] = {.lex_state = 13, .external_lex_state = 12},
  [1281] = {.lex_state = 13, .external_lex_state = 12},
  [1282] = {.lex_state = 13, .external_lex_state = 12},
  [1283] = {.lex_state = 13, .external_lex_state = 12},
  [1284] = {.lex_state = 13, .external_lex_state = 12},
  [1285] = {.lex_state = 13, .external_lex_state = 13},
  [1286] = {.lex_state = 13, .external_lex_state = 12},
  [1287] = {.lex_state = 13, .external_lex_state = 13},
  [1288] = {.lex_state = 13, .external_lex_state = 12},
  [1289] = {.lex_state = 13, .external_lex_state = 13},
  [1290] = {.lex_state = 13, .external_lex_state = 13},
  [1291] = {.lex_state = 13, .external_lex_state = 10},
  [1292] = {.lex_state = 13, .external_lex_state = 13},
  [1293] = {.lex_state = 13, .external_lex_state = 12},
  [1294] = {.lex_state = 13, .external_lex_state = 12},
  [1295] = {.lex_state = 13, .external_lex_state = 12},
  [1296] = {.lex_state = 13, .external_lex_state = 12},
  [1297] = {.lex_state = 13, .external_lex_state = 13},
  [1298] = {.lex_state = 13, .external_lex_state = 13},
  [1299] = {.lex_state = 13, .external_lex_state = 13},
  [1300] = {.lex_state = 13, .external_lex_state = 13},
  [1301] = {.lex_state = 13, .external_lex_state = 12},
  [1302] = {.lex_state = 13, .external_lex_state = 13},
  [1303] = {.lex_state = 12, .external_lex_state = 13},
  [1304] = {.lex_state = 13, .external_lex_state = 12},
  [1305] = {.lex_state = 13, .external_lex_state = 12},
  [1306] = {.lex_state = 13, .external_lex_state = 12},
  [1307] = {.lex_state = 13, .external_lex_state = 12},
  [1308] = {.lex_state = 13, .external_lex_state = 12},
  [1309] = {.lex_state = 13, .external_lex_state = 13},
  [1310] = {.lex_state = 13, .external_lex_state = 12},
  [1311] = {.lex_state = 13, .external_lex_state = 13},
  [1312] = {.lex_state = 13, .external_lex_state = 12},
  [1313] = {.lex_state = 13, .external_lex_state = 13},
  [1314] = {.lex_state = 13, .external_lex_state = 10},
  [1315] = {.lex_state = 13, .external_lex_state = 12},
  [1316] = {.lex_state = 13, .external_lex_state = 13},
  [1317] = {.lex_state = 13, .external_lex_state = 13},
  [1318] = {.lex_state = 13, .external_lex_state = 13},
  [1319] = {.lex_state = 13, .external_lex_state = 13},
  [1320] = {.lex_state = 13, .external_lex_state = 12},
  [1321] = {.lex_state = 13, .external_lex_state = 13},
  [1322] = {.lex_state = 13, .external_lex_state = 13},
  [1323] = {.lex_state = 13, .external_lex_state = 12},
  [1324] = {.lex_state = 13, .external_lex_state = 12},
  [1325] = {.lex_state = 13, .external_lex_state = 12},
  [1326] = {.lex_state = 13, .external_lex_state = 13},
  [1327] = {.lex_state = 13, .external_lex_state = 13},
  [1328] = {.lex_state = 13, .external_lex_state = 12},
  [1329] = {.lex_state = 13, .external_lex_state = 12},
  [1330] = {.lex_state = 13, .external_lex_state = 13},
  [1331] = {.lex_state = 13, .external_lex_state = 12},
  [1332] = {.lex_state = 13, .external_lex_state = 12},
  [1333] = {.lex_state = 13, .external_lex_state = 13},
  [1334] = {.lex_state = 13, .external_lex_state = 13},
  [1335] = {.lex_state = 13, .external_lex_state = 13},
  [1336] = {.lex_state = 13, .external_lex_state = 13},
  [1337] = {.lex_state = 13, .external_lex_state = 13},
  [1338] = {.lex_state = 13, .external_lex_state = 13},
  [1339] = {.lex_state = 13, .external_lex_state = 13},
  [1340] = {.lex_state = 13, .external_lex_state = 13},
  [1341] = {.lex_state = 13, .external_lex_state = 12},
  [1342] = {.lex_state = 13, .external_lex_state = 13},
  [1343] = {.lex_state = 13, .external_lex_state = 12},
  [1344] = {.lex_state = 11, .external_lex_state = 11},
  [1345] = {.lex_state = 11, .external_lex_state = 11},
  [1346] = {.lex_state = 48, .external_lex_state = 9},
  [1347] = {.lex_state = 11, .external_lex_state = 11},
  [1348] = {.lex_state = 48, .external_lex_state = 9},
  [1349] = {.lex_state = 11, .external_lex_state = 11},
  [1350] = {.lex_state = 48, .external_lex_state = 12},
  [1351] = {.lex_state = 11, .external_lex_state = 10},
  [1352] = {.lex_state = 11, .external_lex_state = 10},
  [1353] = {.lex_state = 13, .external_lex_state = 13},
  [1354] = {.lex_state = 48, .external_lex_state = 13},
  [1355] = {.lex_state = 13, .external_lex_state = 13},
  [1356] = {.lex_state = 48, .external_lex_state = 13},
  [1357] = {.lex_state = 13, .external_lex_state = 9},
  [1358] = {.lex_state = 13, .external_lex_state = 13},
  [1359] = {.lex_state = 48, .external_lex_state = 12},
  [1360] = {.lex_state = 13, .external_lex_state = 13},
  [1361] = {.lex_state = 11, .external_lex_state = 12},
  [1362] = {.lex_state = 13, .external_lex_state = 12},
  [1363] = {.lex_state = 48, .external_lex_state = 13},
  [1364] = {.lex_state = 13, .external_lex_state = 13},
  [1365] = {.lex_state = 11, .external_lex_state = 12},
  [1366] = {.lex_state = 13, .external_lex_state = 12},
  [1367] = {.lex_state = 13, .external_lex_state = 12},
  [1368] = {.lex_state = 13, .external_lex_state = 10},
  [1369] = {.lex_state = 11, .external_lex_state = 10},
  [1370] = {.lex_state = 13, .external_lex_state = 12},
  [1371] = {.lex_state = 11, .external_lex_state = 10},
  [1372] = {.lex_state = 13, .external_lex_state = 13},
  [1373] = {.lex_state = 13, .external_lex_state = 10},
  [1374] = {.lex_state = 13, .external_lex_state = 13},
  [1375] = {.lex_state = 13, .external_lex_state = 13},
  [1376] = {.lex_state = 13, .external_lex_state = 10},
  [1377] = {.lex_state = 48, .external_lex_state = 13},
  [1378] = {.lex_state = 13, .external_lex_state = 13},
  [1379] = {.lex_state = 13, .external_lex_state = 12},
  [1380] = {.lex_state = 13, .external_lex_state = 10},
  [1381] = {.lex_state = 13, .external_lex_state = 10},
  [1382] = {.lex_state = 13, .external_lex_state = 12},
  [1383] = {.lex_state = 13, .external_lex_state = 12},
  [1384] = {.lex_state = 11, .external_lex_state = 10},
  [1385] = {.lex_state = 11, .external_lex_state = 10},
  [1386] = {.lex_state = 11, .external_lex_state = 10},
  [1387] = {.lex_state = 11, .external_lex_state = 10},
  [1388] = {.lex_state = 11, .external_lex_state = 10},
  [1389] = {.lex_state = 11, .external_lex_state = 10},
  [1390] = {.lex_state = 11, .external_lex_state = 10},
  [1391] = {.lex_state = 11, .external_lex_state = 10},
  [1392] = {.lex_state = 11, .external_lex_state = 10},
  [1393] = {.lex_state = 11, .external_lex_state = 10},
  [1394] = {.lex_state = 11, .external_lex_state = 10},
  [1395] = {.lex_state = 11, .external_lex_state = 10},
  [1396] = {.lex_state = 11, .external_lex_state = 10},
  [1397] = {.lex_state = 11, .external_lex_state = 10},
  [1398] = {.lex_state = 11, .external_lex_state = 10},
  [1399] = {.lex_state = 11, .external_lex_state = 10},
  [1400] = {.lex_state = 48, .external_lex_state = 13},
  [1401] = {.lex_state = 11, .external_lex_state = 10},
  [1402] = {.lex_state = 11, .external_lex_state = 10},
  [1403] = {.lex_state = 11, .external_lex_state = 10},
  [1404] = {.lex_state = 48, .external_lex_state = 13},
  [1405] = {.lex_state = 48, .external_lex_state = 13},
  [1406] = {.lex_state = 48, .external_lex_state = 10},
  [1407] = {.lex_state = 48, .external_lex_state = 10},
  [1408] = {.lex_state = 11, .external_lex_state = 11},
  [1409] = {.lex_state = 11, .external_lex_state = 11},
  [1410] = {.lex_state = 11, .external_lex_state = 11},
  [1411] = {.lex_state = 11, .external_lex_state = 11},
  [1412] = {.lex_state = 11, .external_lex_state = 11},
  [1413] = {.lex_state = 11, .external_lex_state = 11},
  [1414] = {.lex_state = 11, .external_lex_state = 11},
  [1415] = {.lex_state = 11, .external_lex_state = 11},
  [1416] = {.lex_state = 48, .external_lex_state = 12},
  [1417] = {.lex_state = 48, .external_lex_state = 13},
  [1418] = {.lex_state = 48, .external_lex_state = 13},
  [1419] = {.lex_state = 48, .external_lex_state = 12},
  [1420] = {.lex_state = 48, .external_lex_state = 12},
  [1421] = {.lex_state = 48, .external_lex_state = 13},
  [1422] = {.lex_state = 48, .external_lex_state = 13},
  [1423] = {.lex_state = 48, .external_lex_state = 12},
  [1424] = {.lex_state = 48, .external_lex_state = 13},
  [1425] = {.lex_state = 48, .external_lex_state = 13},
  [1426] = {.lex_state = 48, .external_lex_state = 13},
  [1427] = {.lex_state = 48, .external_lex_state = 12},
  [1428] = {.lex_state = 48, .external_lex_state = 13},
  [1429] = {.lex_state = 48, .external_lex_state = 12},
  [1430] = {.lex_state = 48, .external_lex_state = 13},
  [1431] = {.lex_state = 48, .external_lex_state = 13},
  [1432] = {.lex_state = 48, .external_lex_state = 13},
  [1433] = {.lex_state = 48, .external_lex_state = 13},
  [1434] = {.lex_state = 48, .external_lex_state = 12},
  [1435] = {.lex_state = 48, .external_lex_state = 13},
  [1436] = {.lex_state = 48, .external_lex_state = 13},
  [1437] = {.lex_state = 48, .external_lex_state = 13},
  [1438] = {.lex_state = 48, .external_lex_state = 13},
  [1439] = {.lex_state = 48, .external_lex_state = 13},
  [1440] = {.lex_state = 48, .external_lex_state = 12},
  [1441] = {.lex_state = 15, .external_lex_state = 14},
  [1442] = {.lex_state = 15, .external_lex_state = 14},
  [1443] = {.lex_state = 15, .external_lex_state = 14},
  [1444] = {.lex_state = 15, .external_lex_state = 14},
  [1445] = {.lex_state = 15, .external_lex_state = 14},
  [1446] = {.lex_state = 15, .external_lex_state = 14},
  [1447] = {.lex_state = 15, .external_lex_state = 14},
  [1448] = {.lex_state = 15, .external_lex_state = 14},
  [1449] = {.lex_state = 11, .external_lex_state = 11},
  [1450] = {.lex_state = 15, .external_lex_state = 14},
  [1451] = {.lex_state = 15, .external_lex_state = 14},
  [1452] = {.lex_state = 15, .external_lex_state = 14},
  [1453] = {.lex_state = 15, .external_lex_state = 14},
  [1454] = {.lex_state = 15, .external_lex_state = 14},
  [1455] = {.lex_state = 15, .external_lex_state = 14},
  [1456] = {.lex_state = 15, .external_lex_state = 14},
  [1457] = {.lex_state = 15, .external_lex_state = 14},
  [1458] = {.lex_state = 15, .external_lex_state = 14},
  [1459] = {.lex_state = 15, .external_lex_state = 14},
  [1460] = {.lex_state = 15, .external_lex_state = 14},
  [1461] = {.lex_state = 11, .external_lex_state = 11},
  [1462] = {.lex_state = 11, .external_lex_state = 11},
  [1463] = {.lex_state = 11, .external_lex_state = 11},
  [1464] = {.lex_state = 11, .external_lex_state = 11},
  [1465] = {.lex_state = 48, .external_lex_state = 9},
  [1466] = {.lex_state = 11, .external_lex_state = 11},
  [1467] = {.lex_state = 11, .external_lex_state = 11},
  [1468] = {.lex_state = 48, .external_lex_state = 9},
  [1469] = {.lex_state = 11, .external_lex_state = 11},
  [1470] = {.lex_state = 11, .external_lex_state = 11},
  [1471] = {.lex_state = 48, .external_lex_state = 9},
  [1472] = {.lex_state = 48, .external_lex_state = 9},
  [1473] = {.lex_state = 11, .external_lex_state = 11},
  [1474] = {.lex_state = 48, .external_lex_state = 9},
  [1475] = {.lex_state = 11, .external_lex_state = 11},
  [1476] = {.lex_state = 48, .external_lex_state = 9},
  [1477] = {.lex_state = 11, .external_lex_state = 11},
  [1478] = {.lex_state = 48, .external_lex_state = 9},
  [1479] = {.lex_state = 48, .external_lex_state = 9},
  [1480] = {.lex_state = 11, .external_lex_state = 11},
  [1481] = {.lex_state = 11, .external_lex_state = 11},
  [1482] = {.lex_state = 11, .external_lex_state = 11},
  [1483] = {.lex_state = 48, .external_lex_state = 9},
  [1484] = {.lex_state = 48, .external_lex_state = 9},
  [1485] = {.lex_state = 48, .external_lex_state = 9},
  [1486] = {.lex_state = 11, .external_lex_state = 11},
  [1487] = {.lex_state = 11, .external_lex_state = 11},
  [1488] = {.lex_state = 11, .external_lex_state = 11},
  [1489] = {.lex_state = 11, .external_lex_state = 11},
  [1490] = {.lex_state = 11, .external_lex_state = 11},
  [1491] = {.lex_state = 11, .external_lex_state = 11},
  [1492] = {.lex_state = 11, .external_lex_state = 11},
  [1493] = {.lex_state = 11, .external_lex_state = 11},
  [1494] = {.lex_state = 11, .external_lex_state = 11},
  [1495] = {.lex_state = 0, .external_lex_state = 10},
  [1496] = {.lex_state = 48, .external_lex_state = 10},
  [1497] = {.lex_state = 48, .external_lex_state = 9},
  [1498] = {.lex_state = 11, .external_lex_state = 10},
  [1499] = {.lex_state = 11, .external_lex_state = 10},
  [1500] = {.lex_state = 11, .external_lex_state = 10},
  [1501] = {.lex_state = 11, .external_lex_state = 10},
  [1502] = {.lex_state = 48, .external_lex_state = 12},
  [1503] = {.lex_state = 48, .external_lex_state = 12},
  [1504] = {.lex_state = 48, .external_lex_state = 13},
  [1505] = {.lex_state = 48, .external_lex_state = 13},
  [1506] = {.lex_state = 48, .external_lex_state = 9},
  [1507] = {.lex_state = 48, .external_lex_state = 13},
  [1508] = {.lex_state = 11, .external_lex_state = 10},
  [1509] = {.lex_state = 48, .external_lex_state = 9},
  [1510] = {.lex_state = 48, .external_lex_state = 13},
  [1511] = {.lex_state = 11, .external_lex_state = 12},
  [1512] = {.lex_state = 48, .external_lex_state = 11},
  [1513] = {.lex_state = 48, .external_lex_state = 13},
  [1514] = {.lex_state = 48, .external_lex_state = 12},
  [1515] = {.lex_state = 11, .external_lex_state = 12},
  [1516] = {.lex_state = 48, .external_lex_state = 12},
  [1517] = {.lex_state = 48, .external_lex_state = 13},
  [1518] = {.lex_state = 48, .external_lex_state = 12},
  [1519] = {.lex_state = 11, .external_lex_state = 10},
  [1520] = {.lex_state = 48, .external_lex_state = 13},
  [1521] = {.lex_state = 48, .external_lex_state = 13},
  [1522] = {.lex_state = 48, .external_lex_state = 12},
  [1523] = {.lex_state = 48, .external_lex_state = 9},
  [1524] = {.lex_state = 11, .external_lex_state = 12},
  [1525] = {.lex_state = 11, .external_lex_state = 10},
  [1526] = {.lex_state = 0, .external_lex_state = 10},
  [1527] = {.lex_state = 48, .external_lex_state = 13},
  [1528] = {.lex_state = 48, .external_lex_state = 12},
  [1529] = {.lex_state = 48, .external_lex_state = 9},
  [1530] = {.lex_state = 48, .external_lex_state = 9},
  [1531] = {.lex_state = 48, .external_lex_state = 12},
  [1532] = {.lex_state = 11, .external_lex_state = 10},
  [1533] = {.lex_state = 0, .external_lex_state = 10},
  [1534] = {.lex_state = 48, .external_lex_state = 12},
  [1535] = {.lex_state = 48, .external_lex_state = 12},
  [1536] = {.lex_state = 11, .external_lex_state = 12},
  [1537] = {.lex_state = 48, .external_lex_state = 13},
  [1538] = {.lex_state = 11, .external_lex_state = 12},
  [1539] = {.lex_state = 11, .external_lex_state = 10},
  [1540] = {.lex_state = 11, .external_lex_state = 10},
  [1541] = {.lex_state = 48, .external_lex_state = 12},
  [1542] = {.lex_state = 11, .external_lex_state = 10},
  [1543] = {.lex_state = 48, .external_lex_state = 10},
  [1544] = {.lex_state = 48, .external_lex_state = 9},
  [1545] = {.lex_state = 11, .external_lex_state = 12},
  [1546] = {.lex_state = 48, .external_lex_state = 11},
  [1547] = {.lex_state = 48, .external_lex_state = 12},
  [1548] = {.lex_state = 48, .external_lex_state = 9},
  [1549] = {.lex_state = 48, .external_lex_state = 13},
  [1550] = {.lex_state = 48, .external_lex_state = 13},
  [1551] = {.lex_state = 11, .external_lex_state = 10},
  [1552] = {.lex_state = 48, .external_lex_state = 11},
  [1553] = {.lex_state = 48, .external_lex_state = 11},
  [1554] = {.lex_state = 48, .external_lex_state = 9},
  [1555] = {.lex_state = 11, .external_lex_state = 12},
  [1556] = {.lex_state = 0, .external_lex_state = 10},
  [1557] = {.lex_state = 48, .external_lex_state = 12},
  [1558] = {.lex_state = 48, .external_lex_state = 13},
  [1559] = {.lex_state = 11, .external_lex_state = 12},
  [1560] = {.lex_state = 11, .external_lex_state = 12},
  [1561] = {.lex_state = 48, .external_lex_state = 13},
  [1562] = {.lex_state = 48, .external_lex_state = 12},
  [1563] = {.lex_state = 11, .external_lex_state = 12},
  [1564] = {.lex_state = 11, .external_lex_state = 10},
  [1565] = {.lex_state = 15, .external_lex_state = 14},
  [1566] = {.lex_state = 48, .external_lex_state = 10},
  [1567] = {.lex_state = 11, .external_lex_state = 12},
  [1568] = {.lex_state = 11, .external_lex_state = 12},
  [1569] = {.lex_state = 11, .external_lex_state = 12},
  [1570] = {.lex_state = 11, .external_lex_state = 12},
  [1571] = {.lex_state = 48, .external_lex_state = 11},
  [1572] = {.lex_state = 13, .external_lex_state = 10},
  [1573] = {.lex_state = 48, .external_lex_state = 9},
  [1574] = {.lex_state = 48, .external_lex_state = 13},
  [1575] = {.lex_state = 48, .external_lex_state = 13},
  [1576] = {.lex_state = 48, .external_lex_state = 12},
  [1577] = {.lex_state = 48, .external_lex_state = 9},
  [1578] = {.lex_state = 48, .external_lex_state = 13},
  [1579] = {.lex_state = 15, .external_lex_state = 14},
  [1580] = {.lex_state = 48, .external_lex_state = 11},
  [1581] = {.lex_state = 11, .external_lex_state = 10},
  [1582] = {.lex_state = 48, .external_lex_state = 11},
  [1583] = {.lex_state = 11, .external_lex_state = 12},
  [1584] = {.lex_state = 11, .external_lex_state = 10},
  [1585] = {.lex_state = 11, .external_lex_state = 12},
  [1586] = {.lex_state = 11, .external_lex_state = 12},
  [1587] = {.lex_state = 48, .external_lex_state = 13},
  [1588] = {.lex_state = 48, .external_lex_state = 12},
  [1589] = {.lex_state = 11, .external_lex_state = 10},
  [1590] = {.lex_state = 11, .external_lex_state = 10},
  [1591] = {.lex_state = 48, .external_lex_state = 13},
  [1592] = {.lex_state = 48, .external_lex_state = 13},
  [1593] = {.lex_state = 48, .external_lex_state = 13},
  [1594] = {.lex_state = 48, .external_lex_state = 12},
  [1595] = {.lex_state = 48, .external_lex_state = 11},
  [1596] = {.lex_state = 11, .external_lex_state = 12},
  [1597] = {.lex_state = 48, .external_lex_state = 13},
  [1598] = {.lex_state = 48, .external_lex_state = 11},
  [1599] = {.lex_state = 48, .external_lex_state = 11},
  [1600] = {.lex_state = 48, .external_lex_state = 11},
  [1601] = {.lex_state = 11, .external_lex_state = 12},
  [1602] = {.lex_state = 48, .external_lex_state = 11},
  [1603] = {.lex_state = 48, .external_lex_state = 12},
  [1604] = {.lex_state = 48, .external_lex_state = 13},
  [1605] = {.lex_state = 48, .external_lex_state = 13},
  [1606] = {.lex_state = 11, .external_lex_state = 12},
  [1607] = {.lex_state = 48, .external_lex_state = 13},
  [1608] = {.lex_state = 15, .external_lex_state = 14},
  [1609] = {.lex_state = 48, .external_lex_state = 11},
  [1610] = {.lex_state = 48, .external_lex_state = 13},
  [1611] = {.lex_state = 15, .external_lex_state = 14},
  [1612] = {.lex_state = 11, .external_lex_state = 10},
  [1613] = {.lex_state = 48, .external_lex_state = 11},
  [1614] = {.lex_state = 48, .external_lex_state = 13},
  [1615] = {.lex_state = 48, .external_lex_state = 13},
  [1616] = {.lex_state = 48, .external_lex_state = 9},
  [1617] = {.lex_state = 48, .external_lex_state = 11},
  [1618] = {.lex_state = 48, .external_lex_state = 11},
  [1619] = {.lex_state = 48, .external_lex_state = 13},
  [1620] = {.lex_state = 11, .external_lex_state = 12},
  [1621] = {.lex_state = 48, .external_lex_state = 13},
  [1622] = {.lex_state = 11, .external_lex_state = 10},
  [1623] = {.lex_state = 11, .external_lex_state = 10},
  [1624] = {.lex_state = 48, .external_lex_state = 9},
  [1625] = {.lex_state = 48, .external_lex_state = 12},
  [1626] = {.lex_state = 48, .external_lex_state = 12},
  [1627] = {.lex_state = 11, .external_lex_state = 10},
  [1628] = {.lex_state = 48, .external_lex_state = 13},
  [1629] = {.lex_state = 48, .external_lex_state = 12},
  [1630] = {.lex_state = 11, .external_lex_state = 10},
  [1631] = {.lex_state = 48, .external_lex_state = 13},
  [1632] = {.lex_state = 48, .external_lex_state = 13},
  [1633] = {.lex_state = 48, .external_lex_state = 13},
  [1634] = {.lex_state = 11, .external_lex_state = 11},
  [1635] = {.lex_state = 48, .external_lex_state = 11},
  [1636] = {.lex_state = 48, .external_lex_state = 12},
  [1637] = {.lex_state = 48, .external_lex_state = 12},
  [1638] = {.lex_state = 48, .external_lex_state = 11},
  [1639] = {.lex_state = 48, .external_lex_state = 13},
  [1640] = {.lex_state = 48, .external_lex_state = 13},
  [1641] = {.lex_state = 11, .external_lex_state = 11},
  [1642] = {.lex_state = 48, .external_lex_state = 12},
  [1643] = {.lex_state = 11, .external_lex_state = 10},
  [1644] = {.lex_state = 48, .external_lex_state = 13},
  [1645] = {.lex_state = 48, .external_lex_state = 11},
  [1646] = {.lex_state = 48, .external_lex_state = 12},
  [1647] = {.lex_state = 48, .external_lex_state = 9},
  [1648] = {.lex_state = 48, .external_lex_state = 13},
  [1649] = {.lex_state = 13, .external_lex_state = 9},
  [1650] = {.lex_state = 48, .external_lex_state = 13},
  [1651] = {.lex_state = 48, .external_lex_state = 13},
  [1652] = {.lex_state = 48, .external_lex_state = 12},
  [1653] = {.lex_state = 48, .external_lex_state = 13},
  [1654] = {.lex_state = 48, .external_lex_state = 12},
  [1655] = {.lex_state = 11, .external_lex_state = 10},
  [1656] = {.lex_state = 48, .external_lex_state = 12},
  [1657] = {.lex_state = 48, .external_lex_state = 11},
  [1658] = {.lex_state = 11, .external_lex_state = 10},
  [1659] = {.lex_state = 48, .external_lex_state = 10},
  [1660] = {.lex_state = 48, .external_lex_state = 11},
  [1661] = {.lex_state = 11, .external_lex_state = 10},
  [1662] = {.lex_state = 48, .external_lex_state = 11},
  [1663] = {.lex_state = 48, .external_lex_state = 13},
  [1664] = {.lex_state = 13, .external_lex_state = 9},
  [1665] = {.lex_state = 48, .external_lex_state = 12},
  [1666] = {.lex_state = 48, .external_lex_state = 12},
  [1667] = {.lex_state = 11, .external_lex_state = 10},
  [1668] = {.lex_state = 48, .external_lex_state = 11},
  [1669] = {.lex_state = 48, .external_lex_state = 9},
  [1670] = {.lex_state = 11, .external_lex_state = 10},
  [1671] = {.lex_state = 11, .external_lex_state = 10},
  [1672] = {.lex_state = 13, .external_lex_state = 9},
  [1673] = {.lex_state = 48, .external_lex_state = 11},
  [1674] = {.lex_state = 48, .external_lex_state = 11},
  [1675] = {.lex_state = 48, .external_lex_state = 13},
  [1676] = {.lex_state = 48, .external_lex_state = 13},
  [1677] = {.lex_state = 48, .external_lex_state = 13},
  [1678] = {.lex_state = 48, .external_lex_state = 13},
  [1679] = {.lex_state = 11, .external_lex_state = 10},
  [1680] = {.lex_state = 11, .external_lex_state = 10},
  [1681] = {.lex_state = 11, .external_lex_state = 11},
  [1682] = {.lex_state = 11, .external_lex_state = 10},
  [1683] = {.lex_state = 48, .external_lex_state = 10},
  [1684] = {.lex_state = 11, .external_lex_state = 11},
  [1685] = {.lex_state = 11, .external_lex_state = 10},
  [1686] = {.lex_state = 48, .external_lex_state = 10},
  [1687] = {.lex_state = 48, .external_lex_state = 10},
  [1688] = {.lex_state = 48, .external_lex_state = 10},
  [1689] = {.lex_state = 48, .external_lex_state = 9},
  [1690] = {.lex_state = 48, .external_lex_state = 13},
  [1691] = {.lex_state = 11, .external_lex_state = 10},
  [1692] = {.lex_state = 13, .external_lex_state = 13},
  [1693] = {.lex_state = 11, .external_lex_state = 10},
  [1694] = {.lex_state = 48, .external_lex_state = 10},
  [1695] = {.lex_state = 11, .external_lex_state = 10},
  [1696] = {.lex_state = 11, .external_lex_state = 10},
  [1697] = {.lex_state = 48, .external_lex_state = 13},
  [1698] = {.lex_state = 48, .external_lex_state = 13},
  [1699] = {.lex_state = 13, .external_lex_state = 13},
  [1700] = {.lex_state = 11, .external_lex_state = 10},
  [1701] = {.lex_state = 48, .external_lex_state = 9},
  [1702] = {.lex_state = 6, .external_lex_state = 11},
  [1703] = {.lex_state = 11, .external_lex_state = 10},
  [1704] = {.lex_state = 48, .external_lex_state = 9},
  [1705] = {.lex_state = 11, .external_lex_state = 10},
  [1706] = {.lex_state = 48, .external_lex_state = 11},
  [1707] = {.lex_state = 11, .external_lex_state = 10},
  [1708] = {.lex_state = 13, .external_lex_state = 9},
  [1709] = {.lex_state = 48, .external_lex_state = 10},
  [1710] = {.lex_state = 48, .external_lex_state = 10},
  [1711] = {.lex_state = 11, .external_lex_state = 10},
  [1712] = {.lex_state = 48, .external_lex_state = 9},
  [1713] = {.lex_state = 6, .external_lex_state = 11},
  [1714] = {.lex_state = 48, .external_lex_state = 12},
  [1715] = {.lex_state = 11, .external_lex_state = 10},
  [1716] = {.lex_state = 48, .external_lex_state = 11},
  [1717] = {.lex_state = 11, .external_lex_state = 10},
  [1718] = {.lex_state = 13, .external_lex_state = 13},
  [1719] = {.lex_state = 11, .external_lex_state = 10},
  [1720] = {.lex_state = 48, .external_lex_state = 12},
  [1721] = {.lex_state = 48, .external_lex_state = 11},
  [1722] = {.lex_state = 48, .external_lex_state = 12},
  [1723] = {.lex_state = 48, .external_lex_state = 9},
  [1724] = {.lex_state = 48, .external_lex_state = 10},
  [1725] = {.lex_state = 48, .external_lex_state = 11},
  [1726] = {.lex_state = 48, .external_lex_state = 10},
  [1727] = {.lex_state = 6, .external_lex_state = 11},
  [1728] = {.lex_state = 11, .external_lex_state = 10},
  [1729] = {.lex_state = 11, .external_lex_state = 10},
  [1730] = {.lex_state = 48, .external_lex_state = 9},
  [1731] = {.lex_state = 11, .external_lex_state = 10},
  [1732] = {.lex_state = 0, .external_lex_state = 9},
  [1733] = {.lex_state = 0, .external_lex_state = 9},
  [1734] = {.lex_state = 0, .external_lex_state = 9},
  [1735] = {.lex_state = 0, .external_lex_state = 9},
  [1736] = {.lex_state = 0, .external_lex_state = 9},
  [1737] = {.lex_state = 48, .external_lex_state = 13},
  [1738] = {.lex_state = 0, .external_lex_state = 9},
  [1739] = {.lex_state = 0, .external_lex_state = 9},
  [1740] = {.lex_state = 48, .external_lex_state = 13},
  [1741] = {.lex_state = 0, .external_lex_state = 9},
  [1742] = {.lex_state = 13, .external_lex_state = 13},
  [1743] = {.lex_state = 11, .external_lex_state = 13},
  [1744] = {.lex_state = 11, .external_lex_state = 10},
  [1745] = {.lex_state = 11, .external_lex_state = 11},
  [1746] = {.lex_state = 48, .external_lex_state = 13},
  [1747] = {.lex_state = 48, .external_lex_state = 13},
  [1748] = {.lex_state = 48, .external_lex_state = 9},
  [1749] = {.lex_state = 13, .external_lex_state = 10},
  [1750] = {.lex_state = 0, .external_lex_state = 9},
  [1751] = {.lex_state = 48, .external_lex_state = 10},
  [1752] = {.lex_state = 48, .external_lex_state = 10},
  [1753] = {.lex_state = 0, .external_lex_state = 9},
  [1754] = {.lex_state = 13, .external_lex_state = 10},
  [1755] = {.lex_state = 48, .external_lex_state = 10},
  [1756] = {.lex_state = 0, .external_lex_state = 9},
  [1757] = {.lex_state = 0, .external_lex_state = 9},
  [1758] = {.lex_state = 48, .external_lex_state = 10},
  [1759] = {.lex_state = 0, .external_lex_state = 9},
  [1760] = {.lex_state = 0, .external_lex_state = 9},
  [1761] = {.lex_state = 0, .external_lex_state = 9},
  [1762] = {.lex_state = 0, .external_lex_state = 9},
  [1763] = {.lex_state = 0, .external_lex_state = 9},
  [1764] = {.lex_state = 0, .external_lex_state = 13},
  [1765] = {.lex_state = 0, .external_lex_state = 11},
  [1766] = {.lex_state = 0, .external_lex_state = 11},
  [1767] = {.lex_state = 11, .external_lex_state = 10},
  [1768] = {.lex_state = 0, .external_lex_state = 10},
  [1769] = {.lex_state = 48, .external_lex_state = 10},
  [1770] = {.lex_state = 48, .external_lex_state = 10},
  [1771] = {.lex_state = 0, .external_lex_state = 13},
  [1772] = {.lex_state = 48, .external_lex_state = 10},
  [1773] = {.lex_state = 0, .external_lex_state = 11},
  [1774] = {.lex_state = 0, .external_lex_state = 9},
  [1775] = {.lex_state = 0, .external_lex_state = 9},
  [1776] = {.lex_state = 11, .external_lex_state = 13},
  [1777] = {.lex_state = 0, .external_lex_state = 13},
  [1778] = {.lex_state = 0, .external_lex_state = 13},
  [1779] = {.lex_state = 0, .external_lex_state = 13},
  [1780] = {.lex_state = 11, .external_lex_state = 10},
  [1781] = {.lex_state = 0, .external_lex_state = 12},
  [1782] = {.lex_state = 0, .external_lex_state = 13},
  [1783] = {.lex_state = 13, .external_lex_state = 10},
  [1784] = {.lex_state = 0, .external_lex_state = 13},
  [1785] = {.lex_state = 0, .external_lex_state = 13},
  [1786] = {.lex_state = 0, .external_lex_state = 11},
  [1787] = {.lex_state = 0, .external_lex_state = 13},
  [1788] = {.lex_state = 0, .external_lex_state = 11},
  [1789] = {.lex_state = 0, .external_lex_state = 9},
  [1790] = {.lex_state = 0, .external_lex_state = 12},
  [1791] = {.lex_state = 0, .external_lex_state = 12},
  [1792] = {.lex_state = 0, .external_lex_state = 13},
  [1793] = {.lex_state = 48, .external_lex_state = 10},
  [1794] = {.lex_state = 0, .external_lex_state = 13},
  [1795] = {.lex_state = 0, .external_lex_state = 13},
  [1796] = {.lex_state = 48, .external_lex_state = 10},
  [1797] = {.lex_state = 13, .external_lex_state = 10},
  [1798] = {.lex_state = 48, .external_lex_state = 9},
  [1799] = {.lex_state = 0, .external_lex_state = 11},
  [1800] = {.lex_state = 0, .external_lex_state = 12},
  [1801] = {.lex_state = 48, .external_lex_state = 10},
  [1802] = {.lex_state = 48, .external_lex_state = 10},
  [1803] = {.lex_state = 48, .external_lex_state = 9},
  [1804] = {.lex_state = 0, .external_lex_state = 13},
  [1805] = {.lex_state = 0, .external_lex_state = 13},
  [1806] = {.lex_state = 0, .external_lex_state = 13},
  [1807] = {.lex_state = 0, .external_lex_state = 12},
  [1808] = {.lex_state = 0, .external_lex_state = 12},
  [1809] = {.lex_state = 0, .external_lex_state = 9},
  [1810] = {.lex_state = 0, .external_lex_state = 9},
  [1811] = {.lex_state = 11, .external_lex_state = 10},
  [1812] = {.lex_state = 0, .external_lex_state = 12},
  [1813] = {.lex_state = 0, .external_lex_state = 13},
  [1814] = {.lex_state = 0, .external_lex_state = 13},
  [1815] = {.lex_state = 0, .external_lex_state = 13},
  [1816] = {.lex_state = 48, .external_lex_state = 10},
  [1817] = {.lex_state = 0, .external_lex_state = 12},
  [1818] = {.lex_state = 0, .external_lex_state = 12},
  [1819] = {.lex_state = 48, .external_lex_state = 10},
  [1820] = {.lex_state = 11, .external_lex_state = 10},
  [1821] = {.lex_state = 0, .external_lex_state = 13},
  [1822] = {.lex_state = 0, .external_lex_state = 12},
  [1823] = {.lex_state = 11, .external_lex_state = 11},
  [1824] = {.lex_state = 11, .external_lex_state = 10},
  [1825] = {.lex_state = 0, .external_lex_state = 13},
  [1826] = {.lex_state = 6, .external_lex_state = 11},
  [1827] = {.lex_state = 0, .external_lex_state = 13},
  [1828] = {.lex_state = 0, .external_lex_state = 9},
  [1829] = {.lex_state = 0, .external_lex_state = 13},
  [1830] = {.lex_state = 0, .external_lex_state = 9},
  [1831] = {.lex_state = 11, .external_lex_state = 10},
  [1832] = {.lex_state = 0, .external_lex_state = 10},
  [1833] = {.lex_state = 0, .external_lex_state = 13},
  [1834] = {.lex_state = 0, .external_lex_state = 13},
  [1835] = {.lex_state = 0, .external_lex_state = 13},
  [1836] = {.lex_state = 0, .external_lex_state = 13},
  [1837] = {.lex_state = 0, .external_lex_state = 12},
  [1838] = {.lex_state = 0, .external_lex_state = 9},
  [1839] = {.lex_state = 0, .external_lex_state = 12},
  [1840] = {.lex_state = 0, .external_lex_state = 12},
  [1841] = {.lex_state = 11, .external_lex_state = 10},
  [1842] = {.lex_state = 0, .external_lex_state = 13},
  [1843] = {.lex_state = 0, .external_lex_state = 13},
  [1844] = {.lex_state = 0, .external_lex_state = 13},
  [1845] = {.lex_state = 0, .external_lex_state = 12},
  [1846] = {.lex_state = 0, .external_lex_state = 12},
  [1847] = {.lex_state = 0, .external_lex_state = 13},
  [1848] = {.lex_state = 0, .external_lex_state = 13},
  [1849] = {.lex_state = 0, .external_lex_state = 13},
  [1850] = {.lex_state = 0, .external_lex_state = 11},
  [1851] = {.lex_state = 0, .external_lex_state = 12},
  [1852] = {.lex_state = 0, .external_lex_state = 12},
  [1853] = {.lex_state = 0, .external_lex_state = 13},
  [1854] = {.lex_state = 0, .external_lex_state = 9},
  [1855] = {.lex_state = 11, .external_lex_state = 10},
  [1856] = {.lex_state = 0, .external_lex_state = 13},
  [1857] = {.lex_state = 0, .external_lex_state = 13},
  [1858] = {.lex_state = 0, .external_lex_state = 11},
  [1859] = {.lex_state = 0, .external_lex_state = 11},
  [1860] = {.lex_state = 48, .external_lex_state = 10},
  [1861] = {.lex_state = 0, .external_lex_state = 11},
  [1862] = {.lex_state = 0, .external_lex_state = 13},
  [1863] = {.lex_state = 0, .external_lex_state = 10},
  [1864] = {.lex_state = 0, .external_lex_state = 13},
  [1865] = {.lex_state = 0, .external_lex_state = 11},
  [1866] = {.lex_state = 0, .external_lex_state = 10},
  [1867] = {.lex_state = 0, .external_lex_state = 13},
  [1868] = {.lex_state = 0, .external_lex_state = 13},
  [1869] = {.lex_state = 0, .external_lex_state = 12},
  [1870] = {.lex_state = 0, .external_lex_state = 13},
  [1871] = {.lex_state = 0, .external_lex_state = 12},
  [1872] = {.lex_state = 0, .external_lex_state = 13},
  [1873] = {.lex_state = 48, .external_lex_state = 10},
  [1874] = {.lex_state = 0, .external_lex_state = 12},
  [1875] = {.lex_state = 0, .external_lex_state = 12},
  [1876] = {.lex_state = 0, .external_lex_state = 13},
  [1877] = {.lex_state = 48, .external_lex_state = 9},
  [1878] = {.lex_state = 0, .external_lex_state = 13},
  [1879] = {.lex_state = 0, .external_lex_state = 13},
  [1880] = {.lex_state = 0, .external_lex_state = 12},
  [1881] = {.lex_state = 0, .external_lex_state = 12},
  [1882] = {.lex_state = 48, .external_lex_state = 10},
  [1883] = {.lex_state = 0, .external_lex_state = 13},
  [1884] = {.lex_state = 0, .external_lex_state = 11},
  [1885] = {.lex_state = 13, .external_lex_state = 10},
  [1886] = {.lex_state = 0, .external_lex_state = 10},
  [1887] = {.lex_state = 0, .external_lex_state = 12},
  [1888] = {.lex_state = 48, .external_lex_state = 13},
  [1889] = {.lex_state = 0, .external_lex_state = 13},
  [1890] = {.lex_state = 0, .external_lex_state = 13},
  [1891] = {.lex_state = 11, .external_lex_state = 10},
  [1892] = {.lex_state = 0, .external_lex_state = 9},
  [1893] = {.lex_state = 0, .external_lex_state = 13},
  [1894] = {.lex_state = 0, .external_lex_state = 13},
  [1895] = {.lex_state = 11, .external_lex_state = 10},
  [1896] = {.lex_state = 0, .external_lex_state = 13},
  [1897] = {.lex_state = 48, .external_lex_state = 10},
  [1898] = {.lex_state = 0, .external_lex_state = 11},
  [1899] = {.lex_state = 0, .external_lex_state = 9},
  [1900] = {.lex_state = 0, .external_lex_state = 11},
  [1901] = {.lex_state = 11, .external_lex_state = 10},
  [1902] = {.lex_state = 0, .external_lex_state = 13},
  [1903] = {.lex_state = 11, .external_lex_state = 11},
  [1904] = {.lex_state = 0, .external_lex_state = 11},
  [1905] = {.lex_state = 0, .external_lex_state = 13},
  [1906] = {.lex_state = 0, .external_lex_state = 9},
  [1907] = {.lex_state = 0, .external_lex_state = 13},
  [1908] = {.lex_state = 0, .external_lex_state = 9},
  [1909] = {.lex_state = 0, .external_lex_state = 12},
  [1910] = {.lex_state = 0, .external_lex_state = 12},
  [1911] = {.lex_state = 0, .external_lex_state = 13},
  [1912] = {.lex_state = 0, .external_lex_state = 13},
  [1913] = {.lex_state = 48, .external_lex_state = 9},
  [1914] = {.lex_state = 11, .external_lex_state = 10},
  [1915] = {.lex_state = 0, .external_lex_state = 11},
  [1916] = {.lex_state = 0, .external_lex_state = 12},
  [1917] = {.lex_state = 0, .external_lex_state = 12},
  [1918] = {.lex_state = 0, .external_lex_state = 13},
  [1919] = {.lex_state = 0, .external_lex_state = 13},
  [1920] = {.lex_state = 0, .external_lex_state = 13},
  [1921] = {.lex_state = 0, .external_lex_state = 13},
  [1922] = {.lex_state = 0, .external_lex_state = 13},
  [1923] = {.lex_state = 0, .external_lex_state = 9},
  [1924] = {.lex_state = 0, .external_lex_state = 12},
  [1925] = {.lex_state = 0, .external_lex_state = 12},
  [1926] = {.lex_state = 0, .external_lex_state = 9},
  [1927] = {.lex_state = 0, .external_lex_state = 13},
  [1928] = {.lex_state = 0, .external_lex_state = 9},
  [1929] = {.lex_state = 0, .external_lex_state = 13},
  [1930] = {.lex_state = 0, .external_lex_state = 11},
  [1931] = {.lex_state = 0, .external_lex_state = 13},
  [1932] = {.lex_state = 0, .external_lex_state = 13},
  [1933] = {.lex_state = 0, .external_lex_state = 12},
  [1934] = {.lex_state = 0, .external_lex_state = 12},
  [1935] = {.lex_state = 0, .external_lex_state = 13},
  [1936] = {.lex_state = 0, .external_lex_state = 11},
  [1937] = {.lex_state = 0, .external_lex_state = 11},
  [1938] = {.lex_state = 11, .external_lex_state = 10},
  [1939] = {.lex_state = 11, .external_lex_state = 10},
  [1940] = {.lex_state = 0, .external_lex_state = 9},
  [1941] = {.lex_state = 11, .external_lex_state = 10},
  [1942] = {.lex_state = 0, .external_lex_state = 11},
  [1943] = {.lex_state = 0, .external_lex_state = 13},
  [1944] = {.lex_state = 11, .external_lex_state = 10},
  [1945] = {.lex_state = 0, .external_lex_state = 9},
  [1946] = {.lex_state = 0, .external_lex_state = 12},
  [1947] = {.lex_state = 14, .external_lex_state = 10},
  [1948] = {.lex_state = 0, .external_lex_state = 13},
  [1949] = {.lex_state = 11, .external_lex_state = 10},
  [1950] = {.lex_state = 0, .external_lex_state = 12},
  [1951] = {.lex_state = 0, .external_lex_state = 9},
  [1952] = {.lex_state = 11, .external_lex_state = 10},
  [1953] = {.lex_state = 0, .external_lex_state = 9},
  [1954] = {.lex_state = 0, .external_lex_state = 9},
  [1955] = {.lex_state = 0, .external_lex_state = 13},
  [1956] = {.lex_state = 14, .external_lex_state = 10},
  [1957] = {.lex_state = 0, .external_lex_state = 9},
  [1958] = {.lex_state = 0, .external_lex_state = 13},
  [1959] = {.lex_state = 0, .external_lex_state = 10},
  [1960] = {.lex_state = 0, .external_lex_state = 12},
  [1961] = {.lex_state = 0, .external_lex_state = 10},
  [1962] = {.lex_state = 0, .external_lex_state = 13},
  [1963] = {.lex_state = 0, .external_lex_state = 12},
  [1964] = {.lex_state = 0, .external_lex_state = 13},
  [1965] = {.lex_state = 0, .external_lex_state = 9},
  [1966] = {.lex_state = 0, .external_lex_state = 12},
  [1967] = {.lex_state = 0, .external_lex_state = 10},
  [1968] = {.lex_state = 0, .external_lex_state = 13},
  [1969] = {.lex_state = 0, .external_lex_state = 11},
  [1970] = {.lex_state = 0, .external_lex_state = 11},
  [1971] = {.lex_state = 11, .external_lex_state = 10},
  [1972] = {.lex_state = 0, .external_lex_state = 11},
  [1973] = {.lex_state = 0, .external_lex_state = 9},
  [1974] = {.lex_state = 0, .external_lex_state = 13},
  [1975] = {.lex_state = 0, .external_lex_state = 12},
  [1976] = {.lex_state = 11, .external_lex_state = 10},
  [1977] = {.lex_state = 0, .external_lex_state = 11},
  [1978] = {.lex_state = 0, .external_lex_state = 13},
  [1979] = {.lex_state = 0, .external_lex_state = 13},
  [1980] = {.lex_state = 0, .external_lex_state = 13},
  [1981] = {.lex_state = 0, .external_lex_state = 9},
  [1982] = {.lex_state = 0, .external_lex_state = 9},
  [1983] = {.lex_state = 0, .external_lex_state = 9},
  [1984] = {.lex_state = 0, .external_lex_state = 13},
  [1985] = {.lex_state = 11, .external_lex_state = 10},
  [1986] = {.lex_state = 14, .external_lex_state = 10},
  [1987] = {.lex_state = 14, .external_lex_state = 10},
  [1988] = {.lex_state = 0, .external_lex_state = 9},
  [1989] = {.lex_state = 0, .external_lex_state = 9},
  [1990] = {.lex_state = 0, .external_lex_state = 9},
  [1991] = {.lex_state = 0, .external_lex_state = 13},
  [1992] = {.lex_state = 0, .external_lex_state = 9},
  [1993] = {.lex_state = 0, .external_lex_state = 13},
  [1994] = {.lex_state = 0, .external_lex_state = 12},
  [1995] = {.lex_state = 0, .external_lex_state = 12},
  [1996] = {.lex_state = 0, .external_lex_state = 10},
  [1997] = {.lex_state = 0, .external_lex_state = 9},
  [1998] = {.lex_state = 0, .external_lex_state = 13},
  [1999] = {.lex_state = 0, .external_lex_state = 9},
  [2000] = {.lex_state = 0, .external_lex_state = 12},
  [2001] = {.lex_state = 11, .external_lex_state = 10},
  [2002] = {.lex_state = 0, .external_lex_state = 13},
  [2003] = {.lex_state = 0, .external_lex_state = 12},
  [2004] = {.lex_state = 14, .external_lex_state = 10},
  [2005] = {.lex_state = 0, .external_lex_state = 13},
  [2006] = {.lex_state = 11, .external_lex_state = 10},
  [2007] = {.lex_state = 13, .external_lex_state = 10},
  [2008] = {.lex_state = 0, .external_lex_state = 9},
  [2009] = {.lex_state = 0, .external_lex_state = 13},
  [2010] = {.lex_state = 0, .external_lex_state = 13},
  [2011] = {.lex_state = 0, .external_lex_state = 9},
  [2012] = {.lex_state = 14, .external_lex_state = 10},
  [2013] = {.lex_state = 0, .external_lex_state = 9},
  [2014] = {.lex_state = 0, .external_lex_state = 11},
  [2015] = {.lex_state = 48, .external_lex_state = 10},
  [2016] = {.lex_state = 0, .external_lex_state = 13},
  [2017] = {.lex_state = 0, .external_lex_state = 13},
  [2018] = {.lex_state = 0, .external_lex_state = 12},
  [2019] = {.lex_state = 11, .external_lex_state = 10},
  [2020] = {.lex_state = 0, .external_lex_state = 11},
  [2021] = {.lex_state = 11, .external_lex_state = 10},
  [2022] = {.lex_state = 0, .external_lex_state = 11},
  [2023] = {.lex_state = 0, .external_lex_state = 11},
  [2024] = {.lex_state = 11, .external_lex_state = 10},
  [2025] = {.lex_state = 0, .external_lex_state = 12},
  [2026] = {.lex_state = 48, .external_lex_state = 10},
  [2027] = {.lex_state = 48, .external_lex_state = 10},
  [2028] = {.lex_state = 0, .external_lex_state = 13},
  [2029] = {.lex_state = 0, .external_lex_state = 12},
  [2030] = {.lex_state = 48, .external_lex_state = 10},
  [2031] = {.lex_state = 48, .external_lex_state = 10},
  [2032] = {.lex_state = 0, .external_lex_state = 11},
  [2033] = {.lex_state = 0, .external_lex_state = 11},
  [2034] = {.lex_state = 0, .external_lex_state = 13},
  [2035] = {.lex_state = 0, .external_lex_state = 13},
  [2036] = {.lex_state = 48, .external_lex_state = 10},
  [2037] = {.lex_state = 0, .external_lex_state = 12},
  [2038] = {.lex_state = 11, .external_lex_state = 10},
  [2039] = {.lex_state = 48, .external_lex_state = 10},
  [2040] = {.lex_state = 11, .external_lex_state = 10},
  [2041] = {.lex_state = 48, .external_lex_state = 10},
  [2042] = {.lex_state = 0, .external_lex_state = 11},
  [2043] = {.lex_state = 0, .external_lex_state = 11},
  [2044] = {.lex_state = 11, .external_lex_state = 10},
  [2045] = {.lex_state = 0, .external_lex_state = 13},
  [2046] = {.lex_state = 0, .external_lex_state = 13},
  [2047] = {.lex_state = 0, .external_lex_state = 13},
  [2048] = {.lex_state = 0, .external_lex_state = 11},
  [2049] = {.lex_state = 48, .external_lex_state = 10},
  [2050] = {.lex_state = 48, .external_lex_state = 10},
  [2051] = {.lex_state = 0, .external_lex_state = 13},
  [2052] = {.lex_state = 11, .external_lex_state = 10},
  [2053] = {.lex_state = 0, .external_lex_state = 10},
  [2054] = {.lex_state = 0, .external_lex_state = 13},
  [2055] = {.lex_state = 48, .external_lex_state = 10},
  [2056] = {.lex_state = 0, .external_lex_state = 11},
  [2057] = {.lex_state = 0, .external_lex_state = 13},
  [2058] = {.lex_state = 11, .external_lex_state = 10},
  [2059] = {.lex_state = 0, .external_lex_state = 12},
  [2060] = {.lex_state = 11, .external_lex_state = 10},
  [2061] = {.lex_state = 0, .external_lex_state = 11},
  [2062] = {.lex_state = 0, .external_lex_state = 11},
  [2063] = {.lex_state = 11, .external_lex_state = 10},
  [2064] = {.lex_state = 0, .external_lex_state = 11},
  [2065] = {.lex_state = 48, .external_lex_state = 10},
  [2066] = {.lex_state = 48, .external_lex_state = 10},
  [2067] = {.lex_state = 0, .external_lex_state = 13},
  [2068] = {.lex_state = 0, .external_lex_state = 12},
  [2069] = {.lex_state = 0, .external_lex_state = 12},
  [2070] = {.lex_state = 0, .external_lex_state = 11},
  [2071] = {.lex_state = 0, .external_lex_state = 11},
  [2072] = {.lex_state = 0, .external_lex_state = 13},
  [2073] = {.lex_state = 0, .external_lex_state = 13},
  [2074] = {.lex_state = 48, .external_lex_state = 10},
  [2075] = {.lex_state = 48, .external_lex_state = 10},
  [2076] = {.lex_state = 0, .external_lex_state = 11},
  [2077] = {.lex_state = 0, .external_lex_state = 11},
  [2078] = {.lex_state = 0, .external_lex_state = 10},
  [2079] = {.lex_state = 0, .external_lex_state = 11},
  [2080] = {.lex_state = 0, .external_lex_state = 10},
  [2081] = {.lex_state = 0, .external_lex_state = 11},
  [2082] = {.lex_state = 11, .external_lex_state = 10},
  [2083] = {.lex_state = 11, .external_lex_state = 10},
  [2084] = {.lex_state = 0, .external_lex_state = 12},
  [2085] = {.lex_state = 11, .external_lex_state = 10},
  [2086] = {.lex_state = 0, .external_lex_state = 13},
  [2087] = {.lex_state = 48, .external_lex_state = 10},
  [2088] = {.lex_state = 0, .external_lex_state = 13},
  [2089] = {.lex_state = 48, .external_lex_state = 10},
  [2090] = {.lex_state = 48, .external_lex_state = 10},
  [2091] = {.lex_state = 0, .external_lex_state = 10},
  [2092] = {.lex_state = 48, .external_lex_state = 10},
  [2093] = {.lex_state = 0, .external_lex_state = 13},
  [2094] = {.lex_state = 0, .external_lex_state = 12},
  [2095] = {.lex_state = 0, .external_lex_state = 13},
  [2096] = {.lex_state = 11, .external_lex_state = 10},
  [2097] = {.lex_state = 48, .external_lex_state = 10},
  [2098] = {.lex_state = 0, .external_lex_state = 11},
  [2099] = {.lex_state = 11, .external_lex_state = 10},
  [2100] = {.lex_state = 0, .external_lex_state = 11},
  [2101] = {.lex_state = 48, .external_lex_state = 10},
  [2102] = {.lex_state = 11, .external_lex_state = 10},
  [2103] = {.lex_state = 11, .external_lex_state = 10},
  [2104] = {.lex_state = 11, .external_lex_state = 10},
  [2105] = {.lex_state = 11, .external_lex_state = 10},
  [2106] = {.lex_state = 0, .external_lex_state = 13},
  [2107] = {.lex_state = 0, .external_lex_state = 11},
  [2108] = {.lex_state = 0, .external_lex_state = 11},
  [2109] = {.lex_state = 11, .external_lex_state = 10},
  [2110] = {.lex_state = 11, .external_lex_state = 10},
  [2111] = {.lex_state = 11, .external_lex_state = 10},
  [2112] = {.lex_state = 11, .external_lex_state = 10},
  [2113] = {.lex_state = 48, .external_lex_state = 10},
  [2114] = {.lex_state = 48, .external_lex_state = 10},
  [2115] = {.lex_state = 0, .external_lex_state = 13},
  [2116] = {.lex_state = 0, .external_lex_state = 12},
  [2117] = {.lex_state = 11, .external_lex_state = 10},
  [2118] = {.lex_state = 11, .external_lex_state = 10},
  [2119] = {.lex_state = 48, .external_lex_state = 10},
  [2120] = {.lex_state = 0, .external_lex_state = 13},
  [2121] = {.lex_state = 0, .external_lex_state = 13},
  [2122] = {.lex_state = 11, .external_lex_state = 10},
  [2123] = {.lex_state = 0, .external_lex_state = 12},
  [2124] = {.lex_state = 48, .external_lex_state = 10},
  [2125] = {.lex_state = 11, .external_lex_state = 10},
  [2126] = {.lex_state = 11, .external_lex_state = 10},
  [2127] = {.lex_state = 11, .external_lex_state = 10},
  [2128] = {.lex_state = 11, .external_lex_state = 10},
  [2129] = {.lex_state = 11, .external_lex_state = 10},
  [2130] = {.lex_state = 11, .external_lex_state = 10},
  [2131] = {.lex_state = 11, .external_lex_state = 10},
  [2132] = {.lex_state = 0, .external_lex_state = 13},
  [2133] = {.lex_state = 11, .external_lex_state = 10},
  [2134] = {.lex_state = 48, .external_lex_state = 10},
  [2135] = {.lex_state = 11, .external_lex_state = 10},
  [2136] = {.lex_state = 0, .external_lex_state = 11},
  [2137] = {.lex_state = 11, .external_lex_state = 10},
  [2138] = {.lex_state = 11, .external_lex_state = 10},
  [2139] = {.lex_state = 48, .external_lex_state = 10},
  [2140] = {.lex_state = 0, .external_lex_state = 11},
  [2141] = {.lex_state = 0, .external_lex_state = 11},
  [2142] = {.lex_state = 0, .external_lex_state = 11},
  [2143] = {.lex_state = 48, .external_lex_state = 10},
  [2144] = {.lex_state = 0, .external_lex_state = 12},
  [2145] = {.lex_state = 48, .external_lex_state = 10},
  [2146] = {.lex_state = 0, .external_lex_state = 13},
  [2147] = {.lex_state = 48, .external_lex_state = 10},
  [2148] = {.lex_state = 48, .external_lex_state = 10},
  [2149] = {.lex_state = 11, .external_lex_state = 10},
  [2150] = {.lex_state = 48, .external_lex_state = 10},
  [2151] = {.lex_state = 11, .external_lex_state = 10},
  [2152] = {.lex_state = 0, .external_lex_state = 11},
  [2153] = {.lex_state = 48, .external_lex_state = 10},
  [2154] = {.lex_state = 0, .external_lex_state = 13},
  [2155] = {.lex_state = 11, .external_lex_state = 10},
  [2156] = {.lex_state = 0, .external_lex_state = 11},
  [2157] = {.lex_state = 0, .external_lex_state = 11},
  [2158] = {.lex_state = 0, .external_lex_state = 12},
  [2159] = {.lex_state = 0, .external_lex_state = 11},
  [2160] = {.lex_state = 0, .external_lex_state = 11},
  [2161] = {.lex_state = 11, .external_lex_state = 10},
  [2162] = {.lex_state = 0, .external_lex_state = 12},
  [2163] = {.lex_state = 0, .external_lex_state = 11},
  [2164] = {.lex_state = 0, .external_lex_state = 12},
  [2165] = {.lex_state = 0, .external_lex_state = 12},
  [2166] = {.lex_state = 0, .external_lex_state = 13},
  [2167] = {.lex_state = 48, .external_lex_state = 10},
  [2168] = {.lex_state = 0, .external_lex_state = 13},
  [2169] = {.lex_state = 0, .external_lex_state = 13},
  [2170] = {.lex_state = 0, .external_lex_state = 10},
  [2171] = {.lex_state = 11, .external_lex_state = 10},
  [2172] = {.lex_state = 11, .external_lex_state = 10},
  [2173] = {.lex_state = 0, .external_lex_state = 10},
  [2174] = {.lex_state = 48, .external_lex_state = 10},
  [2175] = {.lex_state = 0, .external_lex_state = 10},
  [2176] = {.lex_state = 48, .external_lex_state = 10},
  [2177] = {.lex_state = 0, .external_lex_state = 12},
  [2178] = {.lex_state = 11, .external_lex_state = 10},
  [2179] = {.lex_state = 0, .external_lex_state = 11},
  [2180] = {.lex_state = 0, .external_lex_state = 13},
  [2181] = {.lex_state = 0, .external_lex_state = 11},
  [2182] = {.lex_state = 48, .external_lex_state = 10},
  [2183] = {.lex_state = 48, .external_lex_state = 10},
  [2184] = {.lex_state = 48, .external_lex_state = 10},
  [2185] = {.lex_state = 48, .external_lex_state = 10},
  [2186] = {.lex_state = 11, .external_lex_state = 10},
  [2187] = {.lex_state = 0, .external_lex_state = 10},
  [2188] = {.lex_state = 11, .external_lex_state = 10},
  [2189] = {.lex_state = 0, .external_lex_state = 12},
  [2190] = {.lex_state = 0, .external_lex_state = 10},
  [2191] = {.lex_state = 48, .external_lex_state = 10},
  [2192] = {.lex_state = 48, .external_lex_state = 10},
  [2193] = {.lex_state = 48, .external_lex_state = 10},
  [2194] = {.lex_state = 48, .external_lex_state = 10},
  [2195] = {.lex_state = 48, .external_lex_state = 10},
  [2196] = {.lex_state = 48, .external_lex_state = 10},
  [2197] = {.lex_state = 11, .external_lex_state = 10},
  [2198] = {.lex_state = 48, .external_lex_state = 10},
  [2199] = {.lex_state = 48, .external_lex_state = 10},
  [2200] = {.lex_state = 0, .external_lex_state = 12},
  [2201] = {.lex_state = 0, .external_lex_state = 13},
};

enum {
  ts_external_token__newline = 0,
  ts_external_token__indent = 1,
  ts_external_token__dedent = 2,
  ts_external_token__string_start = 3,
  ts_external_token__string_content = 4,
  ts_external_token__string_end = 5,
  ts_external_token_comment = 6,
  ts_external_token_RBRACK = 7,
  ts_external_token_RPAREN = 8,
  ts_external_token_RBRACE = 9,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__newline] = sym__newline,
  [ts_external_token__indent] = sym__indent,
  [ts_external_token__dedent] = sym__dedent,
  [ts_external_token__string_start] = sym__string_start,
  [ts_external_token__string_content] = sym__string_content,
  [ts_external_token__string_end] = sym__string_end,
  [ts_external_token_comment] = sym_comment,
  [ts_external_token_RBRACK] = anon_sym_RBRACK,
  [ts_external_token_RPAREN] = anon_sym_RPAREN,
  [ts_external_token_RBRACE] = anon_sym_RBRACE,
};

static const bool ts_external_scanner_states[15][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__newline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACK] = true,
    [ts_external_token_RPAREN] = true,
    [ts_external_token_RBRACE] = true,
  },
  [2] = {
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
  },
  [3] = {
    [ts_external_token__dedent] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
  },
  [4] = {
    [ts_external_token__newline] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
  },
  [5] = {
    [ts_external_token__newline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
  },
  [6] = {
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACE] = true,
  },
  [7] = {
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_RPAREN] = true,
  },
  [8] = {
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACK] = true,
  },
  [9] = {
    [ts_external_token__newline] = true,
    [ts_external_token_comment] = true,
  },
  [10] = {
    [ts_external_token_comment] = true,
  },
  [11] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACE] = true,
  },
  [12] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACK] = true,
  },
  [13] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RPAREN] = true,
  },
  [14] = {
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
    [ts_external_token_comment] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym___future__] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_print] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_del] = ACTIONS(1),
    [anon_sym_raise] = ACTIONS(1),
    [anon_sym_pass] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_except] = ACTIONS(1),
    [anon_sym_except_STAR] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_nonlocal] = ACTIONS(1),
    [anon_sym_exec] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_lambda] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AT_EQ] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [sym_ellipsis] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(1),
    [sym_type_conversion] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_none] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym__string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym__string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_module] = STATE(2175),
    [sym__statement] = STATE(70),
    [sym__simple_statements] = STATE(70),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_if_statement] = STATE(70),
    [sym_match_statement] = STATE(70),
    [sym_for_statement] = STATE(70),
    [sym_while_statement] = STATE(70),
    [sym_try_statement] = STATE(70),
    [sym_with_statement] = STATE(70),
    [sym_function_definition] = STATE(70),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_class_definition] = STATE(70),
    [sym_decorated_definition] = STATE(70),
    [sym_decorator] = STATE(1543),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(70),
    [aux_sym_decorated_definition_repeat1] = STATE(1543),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_async] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_def] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(77),
  },
  [2] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(651),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [3] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(697),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [4] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(680),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [5] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(728),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [6] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(710),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [7] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(724),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [8] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(780),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [9] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(765),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [10] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(789),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [11] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(650),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [12] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(472),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [13] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(681),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [14] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(459),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [15] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(690),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [16] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(723),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [17] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(797),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [18] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(661),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [19] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(626),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym__string_start] = ACTIONS(77),
  },
  [20] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(788),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [21] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(672),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [22] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(667),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [23] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(664),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [24] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(787),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [25] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(754),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [26] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(660),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [27] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(760),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [28] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(757),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [29] = {
    [sym__statement] = STATE(72),
    [sym__simple_statements] = STATE(72),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(72),
    [sym_match_statement] = STATE(72),
    [sym_for_statement] = STATE(72),
    [sym_while_statement] = STATE(72),
    [sym_try_statement] = STATE(72),
    [sym_with_statement] = STATE(72),
    [sym_function_definition] = STATE(72),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(72),
    [sym_decorated_definition] = STATE(72),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(609),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(72),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym__string_start] = ACTIONS(77),
  },
  [30] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(764),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [31] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(715),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [32] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(766),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [33] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(801),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [34] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(665),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [35] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(692),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [36] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(712),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [37] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(804),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [38] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [39] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(693),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [40] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(1495),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym__string_start] = ACTIONS(77),
  },
  [41] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(759),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [42] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(698),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [43] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(792),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [44] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(686),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [45] = {
    [sym__statement] = STATE(77),
    [sym__simple_statements] = STATE(77),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(77),
    [sym_match_statement] = STATE(77),
    [sym_for_statement] = STATE(77),
    [sym_while_statement] = STATE(77),
    [sym_try_statement] = STATE(77),
    [sym_with_statement] = STATE(77),
    [sym_function_definition] = STATE(77),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(77),
    [sym_decorated_definition] = STATE(77),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(649),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(77),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym__string_start] = ACTIONS(77),
  },
  [46] = {
    [sym__statement] = STATE(72),
    [sym__simple_statements] = STATE(72),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(72),
    [sym_match_statement] = STATE(72),
    [sym_for_statement] = STATE(72),
    [sym_while_statement] = STATE(72),
    [sym_try_statement] = STATE(72),
    [sym_with_statement] = STATE(72),
    [sym_function_definition] = STATE(72),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(72),
    [sym_decorated_definition] = STATE(72),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(648),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(72),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym__string_start] = ACTIONS(77),
  },
  [47] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(702),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [48] = {
    [sym__statement] = STATE(72),
    [sym__simple_statements] = STATE(72),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(72),
    [sym_match_statement] = STATE(72),
    [sym_for_statement] = STATE(72),
    [sym_while_statement] = STATE(72),
    [sym_try_statement] = STATE(72),
    [sym_with_statement] = STATE(72),
    [sym_function_definition] = STATE(72),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(72),
    [sym_decorated_definition] = STATE(72),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(616),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(72),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(103),
    [sym__string_start] = ACTIONS(77),
  },
  [49] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(732),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [50] = {
    [sym__statement] = STATE(77),
    [sym__simple_statements] = STATE(77),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(77),
    [sym_match_statement] = STATE(77),
    [sym_for_statement] = STATE(77),
    [sym_while_statement] = STATE(77),
    [sym_try_statement] = STATE(77),
    [sym_with_statement] = STATE(77),
    [sym_function_definition] = STATE(77),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(77),
    [sym_decorated_definition] = STATE(77),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(608),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(77),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(107),
    [sym__string_start] = ACTIONS(77),
  },
  [51] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(708),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [52] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(738),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [53] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(742),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [54] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(705),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [55] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(737),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [56] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(597),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym__string_start] = ACTIONS(77),
  },
  [57] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(704),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [58] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(663),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [59] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(733),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [60] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(619),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym__string_start] = ACTIONS(77),
  },
  [61] = {
    [sym__statement] = STATE(68),
    [sym__simple_statements] = STATE(68),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(68),
    [sym_match_statement] = STATE(68),
    [sym_for_statement] = STATE(68),
    [sym_while_statement] = STATE(68),
    [sym_try_statement] = STATE(68),
    [sym_with_statement] = STATE(68),
    [sym_function_definition] = STATE(68),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(68),
    [sym_decorated_definition] = STATE(68),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(1556),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(68),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(105),
    [sym__string_start] = ACTIONS(77),
  },
  [62] = {
    [sym__statement] = STATE(75),
    [sym__simple_statements] = STATE(75),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(75),
    [sym_match_statement] = STATE(75),
    [sym_for_statement] = STATE(75),
    [sym_while_statement] = STATE(75),
    [sym_try_statement] = STATE(75),
    [sym_with_statement] = STATE(75),
    [sym_function_definition] = STATE(75),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(75),
    [sym_decorated_definition] = STATE(75),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(706),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(75),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(77),
  },
  [63] = {
    [sym__statement] = STATE(71),
    [sym__simple_statements] = STATE(71),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(71),
    [sym_match_statement] = STATE(71),
    [sym_for_statement] = STATE(71),
    [sym_while_statement] = STATE(71),
    [sym_try_statement] = STATE(71),
    [sym_with_statement] = STATE(71),
    [sym_function_definition] = STATE(71),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(71),
    [sym_decorated_definition] = STATE(71),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(618),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(71),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(109),
    [sym__string_start] = ACTIONS(77),
  },
  [64] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(807),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [65] = {
    [sym__statement] = STATE(69),
    [sym__simple_statements] = STATE(69),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(69),
    [sym_match_statement] = STATE(69),
    [sym_for_statement] = STATE(69),
    [sym_while_statement] = STATE(69),
    [sym_try_statement] = STATE(69),
    [sym_with_statement] = STATE(69),
    [sym_function_definition] = STATE(69),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(69),
    [sym_decorated_definition] = STATE(69),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(601),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(69),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(101),
    [sym__string_start] = ACTIONS(77),
  },
  [66] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(736),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [67] = {
    [sym__statement] = STATE(74),
    [sym__simple_statements] = STATE(74),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(74),
    [sym_match_statement] = STATE(74),
    [sym_for_statement] = STATE(74),
    [sym_while_statement] = STATE(74),
    [sym_try_statement] = STATE(74),
    [sym_with_statement] = STATE(74),
    [sym_function_definition] = STATE(74),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(74),
    [sym_decorated_definition] = STATE(74),
    [sym_decorator] = STATE(1496),
    [sym_block] = STATE(729),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(74),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(77),
  },
  [68] = {
    [sym__statement] = STATE(73),
    [sym__simple_statements] = STATE(73),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(73),
    [sym_match_statement] = STATE(73),
    [sym_for_statement] = STATE(73),
    [sym_while_statement] = STATE(73),
    [sym_try_statement] = STATE(73),
    [sym_with_statement] = STATE(73),
    [sym_function_definition] = STATE(73),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(73),
    [sym_decorated_definition] = STATE(73),
    [sym_decorator] = STATE(1496),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(73),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(111),
    [sym__string_start] = ACTIONS(77),
  },
  [69] = {
    [sym__statement] = STATE(73),
    [sym__simple_statements] = STATE(73),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(73),
    [sym_match_statement] = STATE(73),
    [sym_for_statement] = STATE(73),
    [sym_while_statement] = STATE(73),
    [sym_try_statement] = STATE(73),
    [sym_with_statement] = STATE(73),
    [sym_function_definition] = STATE(73),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(73),
    [sym_decorated_definition] = STATE(73),
    [sym_decorator] = STATE(1496),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(73),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(113),
    [sym__string_start] = ACTIONS(77),
  },
  [70] = {
    [sym__statement] = STATE(76),
    [sym__simple_statements] = STATE(76),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_if_statement] = STATE(76),
    [sym_match_statement] = STATE(76),
    [sym_for_statement] = STATE(76),
    [sym_while_statement] = STATE(76),
    [sym_try_statement] = STATE(76),
    [sym_with_statement] = STATE(76),
    [sym_function_definition] = STATE(76),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_class_definition] = STATE(76),
    [sym_decorated_definition] = STATE(76),
    [sym_decorator] = STATE(1543),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(76),
    [aux_sym_decorated_definition_repeat1] = STATE(1543),
    [ts_builtin_sym_end] = ACTIONS(115),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(21),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(35),
    [anon_sym_async] = ACTIONS(37),
    [anon_sym_for] = ACTIONS(39),
    [anon_sym_while] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_with] = ACTIONS(45),
    [anon_sym_def] = ACTIONS(47),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(55),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(77),
  },
  [71] = {
    [sym__statement] = STATE(73),
    [sym__simple_statements] = STATE(73),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(73),
    [sym_match_statement] = STATE(73),
    [sym_for_statement] = STATE(73),
    [sym_while_statement] = STATE(73),
    [sym_try_statement] = STATE(73),
    [sym_with_statement] = STATE(73),
    [sym_function_definition] = STATE(73),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(73),
    [sym_decorated_definition] = STATE(73),
    [sym_decorator] = STATE(1496),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(73),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(117),
    [sym__string_start] = ACTIONS(77),
  },
  [72] = {
    [sym__statement] = STATE(73),
    [sym__simple_statements] = STATE(73),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(73),
    [sym_match_statement] = STATE(73),
    [sym_for_statement] = STATE(73),
    [sym_while_statement] = STATE(73),
    [sym_try_statement] = STATE(73),
    [sym_with_statement] = STATE(73),
    [sym_function_definition] = STATE(73),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(73),
    [sym_decorated_definition] = STATE(73),
    [sym_decorator] = STATE(1496),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(73),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(119),
    [sym__string_start] = ACTIONS(77),
  },
  [73] = {
    [sym__statement] = STATE(73),
    [sym__simple_statements] = STATE(73),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(73),
    [sym_match_statement] = STATE(73),
    [sym_for_statement] = STATE(73),
    [sym_while_statement] = STATE(73),
    [sym_try_statement] = STATE(73),
    [sym_with_statement] = STATE(73),
    [sym_function_definition] = STATE(73),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(73),
    [sym_decorated_definition] = STATE(73),
    [sym_decorator] = STATE(1496),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(73),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(121),
    [anon_sym_import] = ACTIONS(124),
    [anon_sym_from] = ACTIONS(127),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_STAR] = ACTIONS(133),
    [anon_sym_print] = ACTIONS(136),
    [anon_sym_assert] = ACTIONS(139),
    [anon_sym_match] = ACTIONS(142),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_del] = ACTIONS(148),
    [anon_sym_raise] = ACTIONS(151),
    [anon_sym_pass] = ACTIONS(154),
    [anon_sym_break] = ACTIONS(157),
    [anon_sym_continue] = ACTIONS(160),
    [anon_sym_if] = ACTIONS(163),
    [anon_sym_async] = ACTIONS(166),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_while] = ACTIONS(172),
    [anon_sym_try] = ACTIONS(175),
    [anon_sym_with] = ACTIONS(178),
    [anon_sym_def] = ACTIONS(181),
    [anon_sym_global] = ACTIONS(184),
    [anon_sym_nonlocal] = ACTIONS(187),
    [anon_sym_exec] = ACTIONS(190),
    [anon_sym_class] = ACTIONS(193),
    [anon_sym_AT] = ACTIONS(196),
    [anon_sym_LBRACK] = ACTIONS(199),
    [anon_sym_not] = ACTIONS(202),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_TILDE] = ACTIONS(205),
    [anon_sym_lambda] = ACTIONS(208),
    [anon_sym_yield] = ACTIONS(211),
    [sym_ellipsis] = ACTIONS(214),
    [anon_sym_LBRACE] = ACTIONS(217),
    [sym_integer] = ACTIONS(220),
    [sym_float] = ACTIONS(214),
    [anon_sym_await] = ACTIONS(223),
    [sym_true] = ACTIONS(220),
    [sym_false] = ACTIONS(220),
    [sym_none] = ACTIONS(220),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(226),
    [sym__string_start] = ACTIONS(228),
  },
  [74] = {
    [sym__statement] = STATE(73),
    [sym__simple_statements] = STATE(73),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(73),
    [sym_match_statement] = STATE(73),
    [sym_for_statement] = STATE(73),
    [sym_while_statement] = STATE(73),
    [sym_try_statement] = STATE(73),
    [sym_with_statement] = STATE(73),
    [sym_function_definition] = STATE(73),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(73),
    [sym_decorated_definition] = STATE(73),
    [sym_decorator] = STATE(1496),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(73),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(231),
    [sym__string_start] = ACTIONS(77),
  },
  [75] = {
    [sym__statement] = STATE(73),
    [sym__simple_statements] = STATE(73),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(73),
    [sym_match_statement] = STATE(73),
    [sym_for_statement] = STATE(73),
    [sym_while_statement] = STATE(73),
    [sym_try_statement] = STATE(73),
    [sym_with_statement] = STATE(73),
    [sym_function_definition] = STATE(73),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(73),
    [sym_decorated_definition] = STATE(73),
    [sym_decorator] = STATE(1496),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(73),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(233),
    [sym__string_start] = ACTIONS(77),
  },
  [76] = {
    [sym__statement] = STATE(76),
    [sym__simple_statements] = STATE(76),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_if_statement] = STATE(76),
    [sym_match_statement] = STATE(76),
    [sym_for_statement] = STATE(76),
    [sym_while_statement] = STATE(76),
    [sym_try_statement] = STATE(76),
    [sym_with_statement] = STATE(76),
    [sym_function_definition] = STATE(76),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_class_definition] = STATE(76),
    [sym_decorated_definition] = STATE(76),
    [sym_decorator] = STATE(1543),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(76),
    [aux_sym_decorated_definition_repeat1] = STATE(1543),
    [ts_builtin_sym_end] = ACTIONS(226),
    [sym_identifier] = ACTIONS(121),
    [anon_sym_import] = ACTIONS(124),
    [anon_sym_from] = ACTIONS(127),
    [anon_sym_LPAREN] = ACTIONS(130),
    [anon_sym_STAR] = ACTIONS(133),
    [anon_sym_print] = ACTIONS(136),
    [anon_sym_assert] = ACTIONS(139),
    [anon_sym_match] = ACTIONS(235),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_del] = ACTIONS(148),
    [anon_sym_raise] = ACTIONS(151),
    [anon_sym_pass] = ACTIONS(154),
    [anon_sym_break] = ACTIONS(157),
    [anon_sym_continue] = ACTIONS(160),
    [anon_sym_if] = ACTIONS(238),
    [anon_sym_async] = ACTIONS(241),
    [anon_sym_for] = ACTIONS(244),
    [anon_sym_while] = ACTIONS(247),
    [anon_sym_try] = ACTIONS(250),
    [anon_sym_with] = ACTIONS(253),
    [anon_sym_def] = ACTIONS(256),
    [anon_sym_global] = ACTIONS(184),
    [anon_sym_nonlocal] = ACTIONS(187),
    [anon_sym_exec] = ACTIONS(190),
    [anon_sym_class] = ACTIONS(259),
    [anon_sym_AT] = ACTIONS(196),
    [anon_sym_LBRACK] = ACTIONS(199),
    [anon_sym_not] = ACTIONS(202),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_TILDE] = ACTIONS(205),
    [anon_sym_lambda] = ACTIONS(208),
    [anon_sym_yield] = ACTIONS(211),
    [sym_ellipsis] = ACTIONS(214),
    [anon_sym_LBRACE] = ACTIONS(217),
    [sym_integer] = ACTIONS(220),
    [sym_float] = ACTIONS(214),
    [anon_sym_await] = ACTIONS(223),
    [sym_true] = ACTIONS(220),
    [sym_false] = ACTIONS(220),
    [sym_none] = ACTIONS(220),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(228),
  },
  [77] = {
    [sym__statement] = STATE(73),
    [sym__simple_statements] = STATE(73),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_if_statement] = STATE(73),
    [sym_match_statement] = STATE(73),
    [sym_for_statement] = STATE(73),
    [sym_while_statement] = STATE(73),
    [sym_try_statement] = STATE(73),
    [sym_with_statement] = STATE(73),
    [sym_function_definition] = STATE(73),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_class_definition] = STATE(73),
    [sym_decorated_definition] = STATE(73),
    [sym_decorator] = STATE(1496),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [aux_sym_module_repeat1] = STATE(73),
    [aux_sym_decorated_definition_repeat1] = STATE(1496),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_if] = ACTIONS(81),
    [anon_sym_async] = ACTIONS(83),
    [anon_sym_for] = ACTIONS(85),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_try] = ACTIONS(89),
    [anon_sym_with] = ACTIONS(91),
    [anon_sym_def] = ACTIONS(93),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_class] = ACTIONS(95),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__dedent] = ACTIONS(262),
    [sym__string_start] = ACTIONS(77),
  },
  [78] = {
    [sym_named_expression] = STATE(1500),
    [sym__named_expresssion_lhs] = STATE(2173),
    [sym_as_pattern] = STATE(1500),
    [sym_expression] = STATE(1612),
    [sym_primary_expression] = STATE(869),
    [sym_not_operator] = STATE(1500),
    [sym_boolean_operator] = STATE(1500),
    [sym_binary_operator] = STATE(1168),
    [sym_unary_operator] = STATE(1168),
    [sym_comparison_operator] = STATE(1500),
    [sym_lambda] = STATE(1500),
    [sym_attribute] = STATE(1168),
    [sym_subscript] = STATE(1168),
    [sym_call] = STATE(1168),
    [sym_list] = STATE(1168),
    [sym_set] = STATE(1168),
    [sym_tuple] = STATE(1168),
    [sym_dictionary] = STATE(1168),
    [sym_list_comprehension] = STATE(1168),
    [sym_dictionary_comprehension] = STATE(1168),
    [sym_set_comprehension] = STATE(1168),
    [sym_generator_expression] = STATE(1168),
    [sym_parenthesized_expression] = STATE(1168),
    [sym_conditional_expression] = STATE(1500),
    [sym_concatenated_string] = STATE(1168),
    [sym_string] = STATE(861),
    [sym_await] = STATE(1500),
    [sym_identifier] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_DOT] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [anon_sym_COMMA] = ACTIONS(273),
    [anon_sym_as] = ACTIONS(268),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_print] = ACTIONS(276),
    [anon_sym_GT_GT] = ACTIONS(268),
    [anon_sym_COLON_EQ] = ACTIONS(278),
    [anon_sym_match] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(282),
    [anon_sym_async] = ACTIONS(276),
    [anon_sym_in] = ACTIONS(268),
    [anon_sym_STAR_STAR] = ACTIONS(268),
    [anon_sym_exec] = ACTIONS(276),
    [anon_sym_AT] = ACTIONS(268),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_EQ] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(287),
    [anon_sym_and] = ACTIONS(268),
    [anon_sym_or] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(290),
    [anon_sym_DASH] = ACTIONS(290),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_PERCENT] = ACTIONS(268),
    [anon_sym_SLASH_SLASH] = ACTIONS(268),
    [anon_sym_PIPE] = ACTIONS(268),
    [anon_sym_AMP] = ACTIONS(268),
    [anon_sym_CARET] = ACTIONS(268),
    [anon_sym_LT_LT] = ACTIONS(268),
    [anon_sym_TILDE] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(266),
    [anon_sym_EQ_EQ] = ACTIONS(266),
    [anon_sym_BANG_EQ] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(266),
    [anon_sym_GT] = ACTIONS(268),
    [anon_sym_LT_GT] = ACTIONS(266),
    [anon_sym_is] = ACTIONS(268),
    [anon_sym_lambda] = ACTIONS(295),
    [anon_sym_PLUS_EQ] = ACTIONS(297),
    [anon_sym_DASH_EQ] = ACTIONS(297),
    [anon_sym_STAR_EQ] = ACTIONS(297),
    [anon_sym_SLASH_EQ] = ACTIONS(297),
    [anon_sym_AT_EQ] = ACTIONS(297),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(297),
    [anon_sym_PERCENT_EQ] = ACTIONS(297),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(297),
    [anon_sym_GT_GT_EQ] = ACTIONS(297),
    [anon_sym_LT_LT_EQ] = ACTIONS(297),
    [anon_sym_AMP_EQ] = ACTIONS(297),
    [anon_sym_CARET_EQ] = ACTIONS(297),
    [anon_sym_PIPE_EQ] = ACTIONS(297),
    [sym_ellipsis] = ACTIONS(299),
    [anon_sym_LBRACE] = ACTIONS(301),
    [sym_integer] = ACTIONS(303),
    [sym_float] = ACTIONS(299),
    [anon_sym_await] = ACTIONS(305),
    [sym_true] = ACTIONS(303),
    [sym_false] = ACTIONS(303),
    [sym_none] = ACTIONS(303),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(266),
    [sym__string_start] = ACTIONS(307),
  },
  [79] = {
    [sym_named_expression] = STATE(1500),
    [sym__named_expresssion_lhs] = STATE(2173),
    [sym_as_pattern] = STATE(1500),
    [sym_expression] = STATE(1581),
    [sym_primary_expression] = STATE(869),
    [sym_not_operator] = STATE(1500),
    [sym_boolean_operator] = STATE(1500),
    [sym_binary_operator] = STATE(1168),
    [sym_unary_operator] = STATE(1168),
    [sym_comparison_operator] = STATE(1500),
    [sym_lambda] = STATE(1500),
    [sym_attribute] = STATE(1168),
    [sym_subscript] = STATE(1168),
    [sym_call] = STATE(1168),
    [sym_list] = STATE(1168),
    [sym_set] = STATE(1168),
    [sym_tuple] = STATE(1168),
    [sym_dictionary] = STATE(1168),
    [sym_list_comprehension] = STATE(1168),
    [sym_dictionary_comprehension] = STATE(1168),
    [sym_set_comprehension] = STATE(1168),
    [sym_generator_expression] = STATE(1168),
    [sym_parenthesized_expression] = STATE(1168),
    [sym_conditional_expression] = STATE(1500),
    [sym_concatenated_string] = STATE(1168),
    [sym_string] = STATE(861),
    [sym_await] = STATE(1500),
    [sym_identifier] = ACTIONS(264),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_DOT] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(270),
    [anon_sym_COMMA] = ACTIONS(273),
    [anon_sym_as] = ACTIONS(268),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_print] = ACTIONS(276),
    [anon_sym_GT_GT] = ACTIONS(268),
    [anon_sym_COLON_EQ] = ACTIONS(278),
    [anon_sym_match] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(282),
    [anon_sym_async] = ACTIONS(276),
    [anon_sym_in] = ACTIONS(268),
    [anon_sym_STAR_STAR] = ACTIONS(268),
    [anon_sym_exec] = ACTIONS(276),
    [anon_sym_AT] = ACTIONS(268),
    [anon_sym_LBRACK] = ACTIONS(284),
    [anon_sym_EQ] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(287),
    [anon_sym_and] = ACTIONS(268),
    [anon_sym_or] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(290),
    [anon_sym_DASH] = ACTIONS(290),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_PERCENT] = ACTIONS(268),
    [anon_sym_SLASH_SLASH] = ACTIONS(268),
    [anon_sym_PIPE] = ACTIONS(268),
    [anon_sym_AMP] = ACTIONS(268),
    [anon_sym_CARET] = ACTIONS(268),
    [anon_sym_LT_LT] = ACTIONS(268),
    [anon_sym_TILDE] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(266),
    [anon_sym_EQ_EQ] = ACTIONS(266),
    [anon_sym_BANG_EQ] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(266),
    [anon_sym_GT] = ACTIONS(268),
    [anon_sym_LT_GT] = ACTIONS(266),
    [anon_sym_is] = ACTIONS(268),
    [anon_sym_lambda] = ACTIONS(295),
    [anon_sym_PLUS_EQ] = ACTIONS(297),
    [anon_sym_DASH_EQ] = ACTIONS(297),
    [anon_sym_STAR_EQ] = ACTIONS(297),
    [anon_sym_SLASH_EQ] = ACTIONS(297),
    [anon_sym_AT_EQ] = ACTIONS(297),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(297),
    [anon_sym_PERCENT_EQ] = ACTIONS(297),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(297),
    [anon_sym_GT_GT_EQ] = ACTIONS(297),
    [anon_sym_LT_LT_EQ] = ACTIONS(297),
    [anon_sym_AMP_EQ] = ACTIONS(297),
    [anon_sym_CARET_EQ] = ACTIONS(297),
    [anon_sym_PIPE_EQ] = ACTIONS(297),
    [sym_ellipsis] = ACTIONS(299),
    [anon_sym_LBRACE] = ACTIONS(301),
    [sym_integer] = ACTIONS(303),
    [sym_float] = ACTIONS(299),
    [anon_sym_await] = ACTIONS(305),
    [sym_true] = ACTIONS(303),
    [sym_false] = ACTIONS(303),
    [sym_none] = ACTIONS(303),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(266),
    [sym__string_start] = ACTIONS(307),
  },
  [80] = {
    [sym_chevron] = STATE(1735),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1548),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_attribute] = STATE(1062),
    [sym_subscript] = STATE(1062),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(309),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_DOT] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(266),
    [anon_sym_COMMA] = ACTIONS(273),
    [anon_sym_as] = ACTIONS(268),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_print] = ACTIONS(311),
    [anon_sym_GT_GT] = ACTIONS(313),
    [anon_sym_match] = ACTIONS(315),
    [anon_sym_if] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(297),
    [anon_sym_async] = ACTIONS(311),
    [anon_sym_in] = ACTIONS(268),
    [anon_sym_STAR_STAR] = ACTIONS(268),
    [anon_sym_exec] = ACTIONS(311),
    [anon_sym_AT] = ACTIONS(268),
    [anon_sym_LBRACK] = ACTIONS(266),
    [anon_sym_EQ] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(268),
    [anon_sym_and] = ACTIONS(268),
    [anon_sym_or] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(268),
    [anon_sym_DASH] = ACTIONS(268),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_PERCENT] = ACTIONS(268),
    [anon_sym_SLASH_SLASH] = ACTIONS(268),
    [anon_sym_PIPE] = ACTIONS(268),
    [anon_sym_AMP] = ACTIONS(268),
    [anon_sym_CARET] = ACTIONS(268),
    [anon_sym_LT_LT] = ACTIONS(268),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(266),
    [anon_sym_EQ_EQ] = ACTIONS(266),
    [anon_sym_BANG_EQ] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(266),
    [anon_sym_GT] = ACTIONS(268),
    [anon_sym_LT_GT] = ACTIONS(266),
    [anon_sym_is] = ACTIONS(268),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_PLUS_EQ] = ACTIONS(297),
    [anon_sym_DASH_EQ] = ACTIONS(297),
    [anon_sym_STAR_EQ] = ACTIONS(297),
    [anon_sym_SLASH_EQ] = ACTIONS(297),
    [anon_sym_AT_EQ] = ACTIONS(297),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(297),
    [anon_sym_PERCENT_EQ] = ACTIONS(297),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(297),
    [anon_sym_GT_GT_EQ] = ACTIONS(297),
    [anon_sym_LT_LT_EQ] = ACTIONS(297),
    [anon_sym_AMP_EQ] = ACTIONS(297),
    [anon_sym_CARET_EQ] = ACTIONS(297),
    [anon_sym_PIPE_EQ] = ACTIONS(297),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(317),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(266),
    [sym__string_start] = ACTIONS(77),
  },
  [81] = {
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1478),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_attribute] = STATE(1062),
    [sym_subscript] = STATE(1062),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(309),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_DOT] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(319),
    [anon_sym_COMMA] = ACTIONS(273),
    [anon_sym_as] = ACTIONS(268),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_print] = ACTIONS(311),
    [anon_sym_GT_GT] = ACTIONS(268),
    [anon_sym_match] = ACTIONS(315),
    [anon_sym_if] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(297),
    [anon_sym_async] = ACTIONS(311),
    [anon_sym_in] = ACTIONS(268),
    [anon_sym_STAR_STAR] = ACTIONS(268),
    [anon_sym_exec] = ACTIONS(311),
    [anon_sym_AT] = ACTIONS(268),
    [anon_sym_LBRACK] = ACTIONS(321),
    [anon_sym_EQ] = ACTIONS(282),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_and] = ACTIONS(268),
    [anon_sym_or] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(323),
    [anon_sym_DASH] = ACTIONS(323),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_PERCENT] = ACTIONS(268),
    [anon_sym_SLASH_SLASH] = ACTIONS(268),
    [anon_sym_PIPE] = ACTIONS(268),
    [anon_sym_AMP] = ACTIONS(268),
    [anon_sym_CARET] = ACTIONS(268),
    [anon_sym_LT_LT] = ACTIONS(268),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(266),
    [anon_sym_EQ_EQ] = ACTIONS(266),
    [anon_sym_BANG_EQ] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(266),
    [anon_sym_GT] = ACTIONS(268),
    [anon_sym_LT_GT] = ACTIONS(266),
    [anon_sym_is] = ACTIONS(268),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_PLUS_EQ] = ACTIONS(297),
    [anon_sym_DASH_EQ] = ACTIONS(297),
    [anon_sym_STAR_EQ] = ACTIONS(297),
    [anon_sym_SLASH_EQ] = ACTIONS(297),
    [anon_sym_AT_EQ] = ACTIONS(297),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(297),
    [anon_sym_PERCENT_EQ] = ACTIONS(297),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(297),
    [anon_sym_GT_GT_EQ] = ACTIONS(297),
    [anon_sym_LT_LT_EQ] = ACTIONS(297),
    [anon_sym_AMP_EQ] = ACTIONS(297),
    [anon_sym_CARET_EQ] = ACTIONS(297),
    [anon_sym_PIPE_EQ] = ACTIONS(297),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(317),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(266),
    [sym__string_start] = ACTIONS(77),
  },
  [82] = {
    [sym__simple_statements] = STATE(735),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(329),
    [sym__indent] = ACTIONS(331),
    [sym__string_start] = ACTIONS(77),
  },
  [83] = {
    [sym__simple_statements] = STATE(739),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(333),
    [sym__indent] = ACTIONS(335),
    [sym__string_start] = ACTIONS(77),
  },
  [84] = {
    [sym__simple_statements] = STATE(718),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(337),
    [sym__indent] = ACTIONS(339),
    [sym__string_start] = ACTIONS(77),
  },
  [85] = {
    [sym__simple_statements] = STATE(675),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(341),
    [sym__indent] = ACTIONS(343),
    [sym__string_start] = ACTIONS(77),
  },
  [86] = {
    [sym__simple_statements] = STATE(721),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(345),
    [sym__indent] = ACTIONS(347),
    [sym__string_start] = ACTIONS(77),
  },
  [87] = {
    [sym__simple_statements] = STATE(727),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(349),
    [sym__indent] = ACTIONS(351),
    [sym__string_start] = ACTIONS(77),
  },
  [88] = {
    [sym__simple_statements] = STATE(652),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(353),
    [sym__indent] = ACTIONS(355),
    [sym__string_start] = ACTIONS(77),
  },
  [89] = {
    [sym__simple_statements] = STATE(676),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(357),
    [sym__indent] = ACTIONS(359),
    [sym__string_start] = ACTIONS(77),
  },
  [90] = {
    [sym__simple_statements] = STATE(673),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(361),
    [sym__indent] = ACTIONS(363),
    [sym__string_start] = ACTIONS(77),
  },
  [91] = {
    [sym__simple_statements] = STATE(657),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(365),
    [sym__indent] = ACTIONS(367),
    [sym__string_start] = ACTIONS(77),
  },
  [92] = {
    [sym__simple_statements] = STATE(613),
    [sym_import_statement] = STATE(1945),
    [sym_future_import_statement] = STATE(1945),
    [sym_import_from_statement] = STATE(1945),
    [sym_print_statement] = STATE(1945),
    [sym_assert_statement] = STATE(1945),
    [sym_expression_statement] = STATE(1945),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1945),
    [sym_delete_statement] = STATE(1945),
    [sym_raise_statement] = STATE(1945),
    [sym_pass_statement] = STATE(1945),
    [sym_break_statement] = STATE(1945),
    [sym_continue_statement] = STATE(1945),
    [sym_global_statement] = STATE(1945),
    [sym_nonlocal_statement] = STATE(1945),
    [sym_exec_statement] = STATE(1945),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(369),
    [sym__indent] = ACTIONS(371),
    [sym__string_start] = ACTIONS(77),
  },
  [93] = {
    [sym__simple_statements] = STATE(741),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(373),
    [sym__indent] = ACTIONS(375),
    [sym__string_start] = ACTIONS(77),
  },
  [94] = {
    [sym__simple_statements] = STATE(615),
    [sym_import_statement] = STATE(1892),
    [sym_future_import_statement] = STATE(1892),
    [sym_import_from_statement] = STATE(1892),
    [sym_print_statement] = STATE(1892),
    [sym_assert_statement] = STATE(1892),
    [sym_expression_statement] = STATE(1892),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1892),
    [sym_delete_statement] = STATE(1892),
    [sym_raise_statement] = STATE(1892),
    [sym_pass_statement] = STATE(1892),
    [sym_break_statement] = STATE(1892),
    [sym_continue_statement] = STATE(1892),
    [sym_global_statement] = STATE(1892),
    [sym_nonlocal_statement] = STATE(1892),
    [sym_exec_statement] = STATE(1892),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(377),
    [sym__indent] = ACTIONS(379),
    [sym__string_start] = ACTIONS(77),
  },
  [95] = {
    [sym__simple_statements] = STATE(612),
    [sym_import_statement] = STATE(1838),
    [sym_future_import_statement] = STATE(1838),
    [sym_import_from_statement] = STATE(1838),
    [sym_print_statement] = STATE(1838),
    [sym_assert_statement] = STATE(1838),
    [sym_expression_statement] = STATE(1838),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1838),
    [sym_delete_statement] = STATE(1838),
    [sym_raise_statement] = STATE(1838),
    [sym_pass_statement] = STATE(1838),
    [sym_break_statement] = STATE(1838),
    [sym_continue_statement] = STATE(1838),
    [sym_global_statement] = STATE(1838),
    [sym_nonlocal_statement] = STATE(1838),
    [sym_exec_statement] = STATE(1838),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(381),
    [sym__indent] = ACTIONS(383),
    [sym__string_start] = ACTIONS(77),
  },
  [96] = {
    [sym__simple_statements] = STATE(592),
    [sym_import_statement] = STATE(1838),
    [sym_future_import_statement] = STATE(1838),
    [sym_import_from_statement] = STATE(1838),
    [sym_print_statement] = STATE(1838),
    [sym_assert_statement] = STATE(1838),
    [sym_expression_statement] = STATE(1838),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1838),
    [sym_delete_statement] = STATE(1838),
    [sym_raise_statement] = STATE(1838),
    [sym_pass_statement] = STATE(1838),
    [sym_break_statement] = STATE(1838),
    [sym_continue_statement] = STATE(1838),
    [sym_global_statement] = STATE(1838),
    [sym_nonlocal_statement] = STATE(1838),
    [sym_exec_statement] = STATE(1838),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(385),
    [sym__indent] = ACTIONS(387),
    [sym__string_start] = ACTIONS(77),
  },
  [97] = {
    [sym__simple_statements] = STATE(774),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(389),
    [sym__indent] = ACTIONS(391),
    [sym__string_start] = ACTIONS(77),
  },
  [98] = {
    [sym__simple_statements] = STATE(495),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(393),
    [sym__indent] = ACTIONS(395),
    [sym__string_start] = ACTIONS(77),
  },
  [99] = {
    [sym__simple_statements] = STATE(707),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(397),
    [sym__indent] = ACTIONS(399),
    [sym__string_start] = ACTIONS(77),
  },
  [100] = {
    [sym__simple_statements] = STATE(731),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(401),
    [sym__indent] = ACTIONS(403),
    [sym__string_start] = ACTIONS(77),
  },
  [101] = {
    [sym__simple_statements] = STATE(714),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(405),
    [sym__indent] = ACTIONS(407),
    [sym__string_start] = ACTIONS(77),
  },
  [102] = {
    [sym__simple_statements] = STATE(683),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(409),
    [sym__indent] = ACTIONS(411),
    [sym__string_start] = ACTIONS(77),
  },
  [103] = {
    [sym__simple_statements] = STATE(1533),
    [sym_import_statement] = STATE(1763),
    [sym_future_import_statement] = STATE(1763),
    [sym_import_from_statement] = STATE(1763),
    [sym_print_statement] = STATE(1763),
    [sym_assert_statement] = STATE(1763),
    [sym_expression_statement] = STATE(1763),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1763),
    [sym_delete_statement] = STATE(1763),
    [sym_raise_statement] = STATE(1763),
    [sym_pass_statement] = STATE(1763),
    [sym_break_statement] = STATE(1763),
    [sym_continue_statement] = STATE(1763),
    [sym_global_statement] = STATE(1763),
    [sym_nonlocal_statement] = STATE(1763),
    [sym_exec_statement] = STATE(1763),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(413),
    [sym__indent] = ACTIONS(415),
    [sym__string_start] = ACTIONS(77),
  },
  [104] = {
    [sym__simple_statements] = STATE(709),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(417),
    [sym__indent] = ACTIONS(419),
    [sym__string_start] = ACTIONS(77),
  },
  [105] = {
    [sym__simple_statements] = STATE(763),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(421),
    [sym__indent] = ACTIONS(423),
    [sym__string_start] = ACTIONS(77),
  },
  [106] = {
    [sym__simple_statements] = STATE(1526),
    [sym_import_statement] = STATE(1763),
    [sym_future_import_statement] = STATE(1763),
    [sym_import_from_statement] = STATE(1763),
    [sym_print_statement] = STATE(1763),
    [sym_assert_statement] = STATE(1763),
    [sym_expression_statement] = STATE(1763),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1763),
    [sym_delete_statement] = STATE(1763),
    [sym_raise_statement] = STATE(1763),
    [sym_pass_statement] = STATE(1763),
    [sym_break_statement] = STATE(1763),
    [sym_continue_statement] = STATE(1763),
    [sym_global_statement] = STATE(1763),
    [sym_nonlocal_statement] = STATE(1763),
    [sym_exec_statement] = STATE(1763),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(425),
    [sym__indent] = ACTIONS(427),
    [sym__string_start] = ACTIONS(77),
  },
  [107] = {
    [sym__simple_statements] = STATE(769),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(429),
    [sym__indent] = ACTIONS(431),
    [sym__string_start] = ACTIONS(77),
  },
  [108] = {
    [sym__simple_statements] = STATE(679),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(433),
    [sym__indent] = ACTIONS(435),
    [sym__string_start] = ACTIONS(77),
  },
  [109] = {
    [sym__simple_statements] = STATE(772),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(437),
    [sym__indent] = ACTIONS(439),
    [sym__string_start] = ACTIONS(77),
  },
  [110] = {
    [sym__simple_statements] = STATE(783),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(441),
    [sym__indent] = ACTIONS(443),
    [sym__string_start] = ACTIONS(77),
  },
  [111] = {
    [sym__simple_statements] = STATE(811),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(445),
    [sym__indent] = ACTIONS(447),
    [sym__string_start] = ACTIONS(77),
  },
  [112] = {
    [sym__simple_statements] = STATE(662),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(449),
    [sym__indent] = ACTIONS(451),
    [sym__string_start] = ACTIONS(77),
  },
  [113] = {
    [sym__simple_statements] = STATE(688),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(453),
    [sym__indent] = ACTIONS(455),
    [sym__string_start] = ACTIONS(77),
  },
  [114] = {
    [sym__simple_statements] = STATE(700),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(457),
    [sym__indent] = ACTIONS(459),
    [sym__string_start] = ACTIONS(77),
  },
  [115] = {
    [sym__simple_statements] = STATE(659),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(461),
    [sym__indent] = ACTIONS(463),
    [sym__string_start] = ACTIONS(77),
  },
  [116] = {
    [sym__simple_statements] = STATE(800),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(465),
    [sym__indent] = ACTIONS(467),
    [sym__string_start] = ACTIONS(77),
  },
  [117] = {
    [sym__simple_statements] = STATE(805),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(469),
    [sym__indent] = ACTIONS(471),
    [sym__string_start] = ACTIONS(77),
  },
  [118] = {
    [sym__simple_statements] = STATE(656),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(473),
    [sym__indent] = ACTIONS(475),
    [sym__string_start] = ACTIONS(77),
  },
  [119] = {
    [sym__simple_statements] = STATE(778),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(477),
    [sym__indent] = ACTIONS(479),
    [sym__string_start] = ACTIONS(77),
  },
  [120] = {
    [sym__simple_statements] = STATE(691),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(481),
    [sym__indent] = ACTIONS(483),
    [sym__string_start] = ACTIONS(77),
  },
  [121] = {
    [sym__simple_statements] = STATE(638),
    [sym_import_statement] = STATE(1945),
    [sym_future_import_statement] = STATE(1945),
    [sym_import_from_statement] = STATE(1945),
    [sym_print_statement] = STATE(1945),
    [sym_assert_statement] = STATE(1945),
    [sym_expression_statement] = STATE(1945),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1945),
    [sym_delete_statement] = STATE(1945),
    [sym_raise_statement] = STATE(1945),
    [sym_pass_statement] = STATE(1945),
    [sym_break_statement] = STATE(1945),
    [sym_continue_statement] = STATE(1945),
    [sym_global_statement] = STATE(1945),
    [sym_nonlocal_statement] = STATE(1945),
    [sym_exec_statement] = STATE(1945),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(485),
    [sym__indent] = ACTIONS(487),
    [sym__string_start] = ACTIONS(77),
  },
  [122] = {
    [sym__simple_statements] = STATE(701),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(489),
    [sym__indent] = ACTIONS(491),
    [sym__string_start] = ACTIONS(77),
  },
  [123] = {
    [sym__simple_statements] = STATE(725),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(493),
    [sym__indent] = ACTIONS(495),
    [sym__string_start] = ACTIONS(77),
  },
  [124] = {
    [sym__simple_statements] = STATE(776),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(497),
    [sym__indent] = ACTIONS(499),
    [sym__string_start] = ACTIONS(77),
  },
  [125] = {
    [sym__simple_statements] = STATE(749),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(501),
    [sym__indent] = ACTIONS(503),
    [sym__string_start] = ACTIONS(77),
  },
  [126] = {
    [sym__simple_statements] = STATE(684),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(505),
    [sym__indent] = ACTIONS(507),
    [sym__string_start] = ACTIONS(77),
  },
  [127] = {
    [sym__simple_statements] = STATE(666),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(509),
    [sym__indent] = ACTIONS(511),
    [sym__string_start] = ACTIONS(77),
  },
  [128] = {
    [sym__simple_statements] = STATE(687),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(513),
    [sym__indent] = ACTIONS(515),
    [sym__string_start] = ACTIONS(77),
  },
  [129] = {
    [sym__simple_statements] = STATE(809),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(517),
    [sym__indent] = ACTIONS(519),
    [sym__string_start] = ACTIONS(77),
  },
  [130] = {
    [sym__simple_statements] = STATE(806),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(521),
    [sym__indent] = ACTIONS(523),
    [sym__string_start] = ACTIONS(77),
  },
  [131] = {
    [sym__simple_statements] = STATE(746),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(525),
    [sym__indent] = ACTIONS(527),
    [sym__string_start] = ACTIONS(77),
  },
  [132] = {
    [sym__simple_statements] = STATE(685),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(529),
    [sym__indent] = ACTIONS(531),
    [sym__string_start] = ACTIONS(77),
  },
  [133] = {
    [sym__simple_statements] = STATE(722),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(533),
    [sym__indent] = ACTIONS(535),
    [sym__string_start] = ACTIONS(77),
  },
  [134] = {
    [sym__simple_statements] = STATE(755),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(537),
    [sym__indent] = ACTIONS(539),
    [sym__string_start] = ACTIONS(77),
  },
  [135] = {
    [sym__simple_statements] = STATE(670),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(541),
    [sym__indent] = ACTIONS(543),
    [sym__string_start] = ACTIONS(77),
  },
  [136] = {
    [sym__simple_statements] = STATE(696),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(545),
    [sym__indent] = ACTIONS(547),
    [sym__string_start] = ACTIONS(77),
  },
  [137] = {
    [sym__simple_statements] = STATE(668),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(549),
    [sym__indent] = ACTIONS(551),
    [sym__string_start] = ACTIONS(77),
  },
  [138] = {
    [sym__simple_statements] = STATE(773),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(553),
    [sym__indent] = ACTIONS(555),
    [sym__string_start] = ACTIONS(77),
  },
  [139] = {
    [sym__simple_statements] = STATE(717),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(557),
    [sym__indent] = ACTIONS(559),
    [sym__string_start] = ACTIONS(77),
  },
  [140] = {
    [sym__simple_statements] = STATE(558),
    [sym_import_statement] = STATE(1774),
    [sym_future_import_statement] = STATE(1774),
    [sym_import_from_statement] = STATE(1774),
    [sym_print_statement] = STATE(1774),
    [sym_assert_statement] = STATE(1774),
    [sym_expression_statement] = STATE(1774),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1774),
    [sym_delete_statement] = STATE(1774),
    [sym_raise_statement] = STATE(1774),
    [sym_pass_statement] = STATE(1774),
    [sym_break_statement] = STATE(1774),
    [sym_continue_statement] = STATE(1774),
    [sym_global_statement] = STATE(1774),
    [sym_nonlocal_statement] = STATE(1774),
    [sym_exec_statement] = STATE(1774),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(561),
    [sym__indent] = ACTIONS(563),
    [sym__string_start] = ACTIONS(77),
  },
  [141] = {
    [sym__simple_statements] = STATE(803),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(565),
    [sym__indent] = ACTIONS(567),
    [sym__string_start] = ACTIONS(77),
  },
  [142] = {
    [sym__simple_statements] = STATE(758),
    [sym_import_statement] = STATE(1775),
    [sym_future_import_statement] = STATE(1775),
    [sym_import_from_statement] = STATE(1775),
    [sym_print_statement] = STATE(1775),
    [sym_assert_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1775),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1775),
    [sym_delete_statement] = STATE(1775),
    [sym_raise_statement] = STATE(1775),
    [sym_pass_statement] = STATE(1775),
    [sym_break_statement] = STATE(1775),
    [sym_continue_statement] = STATE(1775),
    [sym_global_statement] = STATE(1775),
    [sym_nonlocal_statement] = STATE(1775),
    [sym_exec_statement] = STATE(1775),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(569),
    [sym__indent] = ACTIONS(571),
    [sym__string_start] = ACTIONS(77),
  },
  [143] = {
    [sym__simple_statements] = STATE(623),
    [sym_import_statement] = STATE(1906),
    [sym_future_import_statement] = STATE(1906),
    [sym_import_from_statement] = STATE(1906),
    [sym_print_statement] = STATE(1906),
    [sym_assert_statement] = STATE(1906),
    [sym_expression_statement] = STATE(1906),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1906),
    [sym_delete_statement] = STATE(1906),
    [sym_raise_statement] = STATE(1906),
    [sym_pass_statement] = STATE(1906),
    [sym_break_statement] = STATE(1906),
    [sym_continue_statement] = STATE(1906),
    [sym_global_statement] = STATE(1906),
    [sym_nonlocal_statement] = STATE(1906),
    [sym_exec_statement] = STATE(1906),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(573),
    [sym__indent] = ACTIONS(575),
    [sym__string_start] = ACTIONS(77),
  },
  [144] = {
    [sym__simple_statements] = STATE(624),
    [sym_import_statement] = STATE(1945),
    [sym_future_import_statement] = STATE(1945),
    [sym_import_from_statement] = STATE(1945),
    [sym_print_statement] = STATE(1945),
    [sym_assert_statement] = STATE(1945),
    [sym_expression_statement] = STATE(1945),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1945),
    [sym_delete_statement] = STATE(1945),
    [sym_raise_statement] = STATE(1945),
    [sym_pass_statement] = STATE(1945),
    [sym_break_statement] = STATE(1945),
    [sym_continue_statement] = STATE(1945),
    [sym_global_statement] = STATE(1945),
    [sym_nonlocal_statement] = STATE(1945),
    [sym_exec_statement] = STATE(1945),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(577),
    [sym__indent] = ACTIONS(579),
    [sym__string_start] = ACTIONS(77),
  },
  [145] = {
    [sym__simple_statements] = STATE(627),
    [sym_import_statement] = STATE(1838),
    [sym_future_import_statement] = STATE(1838),
    [sym_import_from_statement] = STATE(1838),
    [sym_print_statement] = STATE(1838),
    [sym_assert_statement] = STATE(1838),
    [sym_expression_statement] = STATE(1838),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1838),
    [sym_delete_statement] = STATE(1838),
    [sym_raise_statement] = STATE(1838),
    [sym_pass_statement] = STATE(1838),
    [sym_break_statement] = STATE(1838),
    [sym_continue_statement] = STATE(1838),
    [sym_global_statement] = STATE(1838),
    [sym_nonlocal_statement] = STATE(1838),
    [sym_exec_statement] = STATE(1838),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(581),
    [sym__indent] = ACTIONS(583),
    [sym__string_start] = ACTIONS(77),
  },
  [146] = {
    [sym_import_statement] = STATE(1981),
    [sym_future_import_statement] = STATE(1981),
    [sym_import_from_statement] = STATE(1981),
    [sym_print_statement] = STATE(1981),
    [sym_assert_statement] = STATE(1981),
    [sym_expression_statement] = STATE(1981),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1981),
    [sym_delete_statement] = STATE(1981),
    [sym_raise_statement] = STATE(1981),
    [sym_pass_statement] = STATE(1981),
    [sym_break_statement] = STATE(1981),
    [sym_continue_statement] = STATE(1981),
    [sym_global_statement] = STATE(1981),
    [sym_nonlocal_statement] = STATE(1981),
    [sym_exec_statement] = STATE(1981),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(585),
    [sym__string_start] = ACTIONS(77),
  },
  [147] = {
    [sym_import_statement] = STATE(1981),
    [sym_future_import_statement] = STATE(1981),
    [sym_import_from_statement] = STATE(1981),
    [sym_print_statement] = STATE(1981),
    [sym_assert_statement] = STATE(1981),
    [sym_expression_statement] = STATE(1981),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1981),
    [sym_delete_statement] = STATE(1981),
    [sym_raise_statement] = STATE(1981),
    [sym_pass_statement] = STATE(1981),
    [sym_break_statement] = STATE(1981),
    [sym_continue_statement] = STATE(1981),
    [sym_global_statement] = STATE(1981),
    [sym_nonlocal_statement] = STATE(1981),
    [sym_exec_statement] = STATE(1981),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(587),
    [sym__string_start] = ACTIONS(77),
  },
  [148] = {
    [sym_import_statement] = STATE(1981),
    [sym_future_import_statement] = STATE(1981),
    [sym_import_from_statement] = STATE(1981),
    [sym_print_statement] = STATE(1981),
    [sym_assert_statement] = STATE(1981),
    [sym_expression_statement] = STATE(1981),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1981),
    [sym_delete_statement] = STATE(1981),
    [sym_raise_statement] = STATE(1981),
    [sym_pass_statement] = STATE(1981),
    [sym_break_statement] = STATE(1981),
    [sym_continue_statement] = STATE(1981),
    [sym_global_statement] = STATE(1981),
    [sym_nonlocal_statement] = STATE(1981),
    [sym_exec_statement] = STATE(1981),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(589),
    [sym__string_start] = ACTIONS(77),
  },
  [149] = {
    [sym_import_statement] = STATE(1981),
    [sym_future_import_statement] = STATE(1981),
    [sym_import_from_statement] = STATE(1981),
    [sym_print_statement] = STATE(1981),
    [sym_assert_statement] = STATE(1981),
    [sym_expression_statement] = STATE(1981),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1981),
    [sym_delete_statement] = STATE(1981),
    [sym_raise_statement] = STATE(1981),
    [sym_pass_statement] = STATE(1981),
    [sym_break_statement] = STATE(1981),
    [sym_continue_statement] = STATE(1981),
    [sym_global_statement] = STATE(1981),
    [sym_nonlocal_statement] = STATE(1981),
    [sym_exec_statement] = STATE(1981),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(591),
    [sym__string_start] = ACTIONS(77),
  },
  [150] = {
    [sym_import_statement] = STATE(1981),
    [sym_future_import_statement] = STATE(1981),
    [sym_import_from_statement] = STATE(1981),
    [sym_print_statement] = STATE(1981),
    [sym_assert_statement] = STATE(1981),
    [sym_expression_statement] = STATE(1981),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1981),
    [sym_delete_statement] = STATE(1981),
    [sym_raise_statement] = STATE(1981),
    [sym_pass_statement] = STATE(1981),
    [sym_break_statement] = STATE(1981),
    [sym_continue_statement] = STATE(1981),
    [sym_global_statement] = STATE(1981),
    [sym_nonlocal_statement] = STATE(1981),
    [sym_exec_statement] = STATE(1981),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(593),
    [sym__string_start] = ACTIONS(77),
  },
  [151] = {
    [sym_import_statement] = STATE(1981),
    [sym_future_import_statement] = STATE(1981),
    [sym_import_from_statement] = STATE(1981),
    [sym_print_statement] = STATE(1981),
    [sym_assert_statement] = STATE(1981),
    [sym_expression_statement] = STATE(1981),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1981),
    [sym_delete_statement] = STATE(1981),
    [sym_raise_statement] = STATE(1981),
    [sym_pass_statement] = STATE(1981),
    [sym_break_statement] = STATE(1981),
    [sym_continue_statement] = STATE(1981),
    [sym_global_statement] = STATE(1981),
    [sym_nonlocal_statement] = STATE(1981),
    [sym_exec_statement] = STATE(1981),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(595),
    [sym__string_start] = ACTIONS(77),
  },
  [152] = {
    [sym_import_statement] = STATE(1981),
    [sym_future_import_statement] = STATE(1981),
    [sym_import_from_statement] = STATE(1981),
    [sym_print_statement] = STATE(1981),
    [sym_assert_statement] = STATE(1981),
    [sym_expression_statement] = STATE(1981),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1981),
    [sym_delete_statement] = STATE(1981),
    [sym_raise_statement] = STATE(1981),
    [sym_pass_statement] = STATE(1981),
    [sym_break_statement] = STATE(1981),
    [sym_continue_statement] = STATE(1981),
    [sym_global_statement] = STATE(1981),
    [sym_nonlocal_statement] = STATE(1981),
    [sym_exec_statement] = STATE(1981),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(597),
    [sym__string_start] = ACTIONS(77),
  },
  [153] = {
    [sym_import_statement] = STATE(1981),
    [sym_future_import_statement] = STATE(1981),
    [sym_import_from_statement] = STATE(1981),
    [sym_print_statement] = STATE(1981),
    [sym_assert_statement] = STATE(1981),
    [sym_expression_statement] = STATE(1981),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1981),
    [sym_delete_statement] = STATE(1981),
    [sym_raise_statement] = STATE(1981),
    [sym_pass_statement] = STATE(1981),
    [sym_break_statement] = STATE(1981),
    [sym_continue_statement] = STATE(1981),
    [sym_global_statement] = STATE(1981),
    [sym_nonlocal_statement] = STATE(1981),
    [sym_exec_statement] = STATE(1981),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(599),
    [sym__string_start] = ACTIONS(77),
  },
  [154] = {
    [sym_import_statement] = STATE(1981),
    [sym_future_import_statement] = STATE(1981),
    [sym_import_from_statement] = STATE(1981),
    [sym_print_statement] = STATE(1981),
    [sym_assert_statement] = STATE(1981),
    [sym_expression_statement] = STATE(1981),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1981),
    [sym_delete_statement] = STATE(1981),
    [sym_raise_statement] = STATE(1981),
    [sym_pass_statement] = STATE(1981),
    [sym_break_statement] = STATE(1981),
    [sym_continue_statement] = STATE(1981),
    [sym_global_statement] = STATE(1981),
    [sym_nonlocal_statement] = STATE(1981),
    [sym_exec_statement] = STATE(1981),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(601),
    [sym__string_start] = ACTIONS(77),
  },
  [155] = {
    [sym_import_statement] = STATE(1981),
    [sym_future_import_statement] = STATE(1981),
    [sym_import_from_statement] = STATE(1981),
    [sym_print_statement] = STATE(1981),
    [sym_assert_statement] = STATE(1981),
    [sym_expression_statement] = STATE(1981),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1981),
    [sym_delete_statement] = STATE(1981),
    [sym_raise_statement] = STATE(1981),
    [sym_pass_statement] = STATE(1981),
    [sym_break_statement] = STATE(1981),
    [sym_continue_statement] = STATE(1981),
    [sym_global_statement] = STATE(1981),
    [sym_nonlocal_statement] = STATE(1981),
    [sym_exec_statement] = STATE(1981),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(603),
    [sym__string_start] = ACTIONS(77),
  },
  [156] = {
    [sym_import_statement] = STATE(1981),
    [sym_future_import_statement] = STATE(1981),
    [sym_import_from_statement] = STATE(1981),
    [sym_print_statement] = STATE(1981),
    [sym_assert_statement] = STATE(1981),
    [sym_expression_statement] = STATE(1981),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1981),
    [sym_delete_statement] = STATE(1981),
    [sym_raise_statement] = STATE(1981),
    [sym_pass_statement] = STATE(1981),
    [sym_break_statement] = STATE(1981),
    [sym_continue_statement] = STATE(1981),
    [sym_global_statement] = STATE(1981),
    [sym_nonlocal_statement] = STATE(1981),
    [sym_exec_statement] = STATE(1981),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(605),
    [sym__string_start] = ACTIONS(77),
  },
  [157] = {
    [sym_import_statement] = STATE(1981),
    [sym_future_import_statement] = STATE(1981),
    [sym_import_from_statement] = STATE(1981),
    [sym_print_statement] = STATE(1981),
    [sym_assert_statement] = STATE(1981),
    [sym_expression_statement] = STATE(1981),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1981),
    [sym_delete_statement] = STATE(1981),
    [sym_raise_statement] = STATE(1981),
    [sym_pass_statement] = STATE(1981),
    [sym_break_statement] = STATE(1981),
    [sym_continue_statement] = STATE(1981),
    [sym_global_statement] = STATE(1981),
    [sym_nonlocal_statement] = STATE(1981),
    [sym_exec_statement] = STATE(1981),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(607),
    [sym__string_start] = ACTIONS(77),
  },
  [158] = {
    [sym_import_statement] = STATE(1981),
    [sym_future_import_statement] = STATE(1981),
    [sym_import_from_statement] = STATE(1981),
    [sym_print_statement] = STATE(1981),
    [sym_assert_statement] = STATE(1981),
    [sym_expression_statement] = STATE(1981),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1981),
    [sym_delete_statement] = STATE(1981),
    [sym_raise_statement] = STATE(1981),
    [sym_pass_statement] = STATE(1981),
    [sym_break_statement] = STATE(1981),
    [sym_continue_statement] = STATE(1981),
    [sym_global_statement] = STATE(1981),
    [sym_nonlocal_statement] = STATE(1981),
    [sym_exec_statement] = STATE(1981),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(609),
    [sym__string_start] = ACTIONS(77),
  },
  [159] = {
    [sym_import_statement] = STATE(1981),
    [sym_future_import_statement] = STATE(1981),
    [sym_import_from_statement] = STATE(1981),
    [sym_print_statement] = STATE(1981),
    [sym_assert_statement] = STATE(1981),
    [sym_expression_statement] = STATE(1981),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1981),
    [sym_delete_statement] = STATE(1981),
    [sym_raise_statement] = STATE(1981),
    [sym_pass_statement] = STATE(1981),
    [sym_break_statement] = STATE(1981),
    [sym_continue_statement] = STATE(1981),
    [sym_global_statement] = STATE(1981),
    [sym_nonlocal_statement] = STATE(1981),
    [sym_exec_statement] = STATE(1981),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(611),
    [sym__string_start] = ACTIONS(77),
  },
  [160] = {
    [sym_import_statement] = STATE(1981),
    [sym_future_import_statement] = STATE(1981),
    [sym_import_from_statement] = STATE(1981),
    [sym_print_statement] = STATE(1981),
    [sym_assert_statement] = STATE(1981),
    [sym_expression_statement] = STATE(1981),
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_return_statement] = STATE(1981),
    [sym_delete_statement] = STATE(1981),
    [sym_raise_statement] = STATE(1981),
    [sym_pass_statement] = STATE(1981),
    [sym_break_statement] = STATE(1981),
    [sym_continue_statement] = STATE(1981),
    [sym_global_statement] = STATE(1981),
    [sym_nonlocal_statement] = STATE(1981),
    [sym_exec_statement] = STATE(1981),
    [sym_pattern] = STATE(1387),
    [sym_tuple_pattern] = STATE(1390),
    [sym_list_pattern] = STATE(1390),
    [sym_list_splat_pattern] = STATE(1390),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1497),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_assignment] = STATE(1965),
    [sym_augmented_assignment] = STATE(1965),
    [sym_pattern_list] = STATE(1403),
    [sym_yield] = STATE(1965),
    [sym_attribute] = STATE(491),
    [sym_subscript] = STATE(491),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_from] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_STAR] = ACTIONS(15),
    [anon_sym_print] = ACTIONS(17),
    [anon_sym_assert] = ACTIONS(19),
    [anon_sym_match] = ACTIONS(325),
    [anon_sym_return] = ACTIONS(23),
    [anon_sym_del] = ACTIONS(25),
    [anon_sym_raise] = ACTIONS(27),
    [anon_sym_pass] = ACTIONS(29),
    [anon_sym_break] = ACTIONS(31),
    [anon_sym_continue] = ACTIONS(33),
    [anon_sym_async] = ACTIONS(327),
    [anon_sym_global] = ACTIONS(49),
    [anon_sym_nonlocal] = ACTIONS(51),
    [anon_sym_exec] = ACTIONS(53),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_lambda] = ACTIONS(65),
    [anon_sym_yield] = ACTIONS(67),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(75),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(77),
  },
  [161] = {
    [sym_named_expression] = STATE(1472),
    [sym__named_expresssion_lhs] = STATE(2170),
    [sym_as_pattern] = STATE(1472),
    [sym_expression] = STATE(1478),
    [sym_primary_expression] = STATE(842),
    [sym_not_operator] = STATE(1472),
    [sym_boolean_operator] = STATE(1472),
    [sym_binary_operator] = STATE(1062),
    [sym_unary_operator] = STATE(1062),
    [sym_comparison_operator] = STATE(1472),
    [sym_lambda] = STATE(1472),
    [sym_attribute] = STATE(1062),
    [sym_subscript] = STATE(1062),
    [sym_call] = STATE(1062),
    [sym_list] = STATE(1062),
    [sym_set] = STATE(1062),
    [sym_tuple] = STATE(1062),
    [sym_dictionary] = STATE(1062),
    [sym_list_comprehension] = STATE(1062),
    [sym_dictionary_comprehension] = STATE(1062),
    [sym_set_comprehension] = STATE(1062),
    [sym_generator_expression] = STATE(1062),
    [sym_parenthesized_expression] = STATE(1062),
    [sym_conditional_expression] = STATE(1472),
    [sym_concatenated_string] = STATE(1062),
    [sym_string] = STATE(837),
    [sym_await] = STATE(1472),
    [sym_identifier] = ACTIONS(309),
    [anon_sym_SEMI] = ACTIONS(266),
    [anon_sym_DOT] = ACTIONS(268),
    [anon_sym_from] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(319),
    [anon_sym_COMMA] = ACTIONS(266),
    [anon_sym_as] = ACTIONS(268),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_print] = ACTIONS(311),
    [anon_sym_GT_GT] = ACTIONS(266),
    [anon_sym_match] = ACTIONS(315),
    [anon_sym_if] = ACTIONS(268),
    [anon_sym_async] = ACTIONS(311),
    [anon_sym_in] = ACTIONS(268),
    [anon_sym_STAR_STAR] = ACTIONS(266),
    [anon_sym_exec] = ACTIONS(311),
    [anon_sym_AT] = ACTIONS(266),
    [anon_sym_LBRACK] = ACTIONS(321),
    [anon_sym_EQ] = ACTIONS(268),
    [anon_sym_not] = ACTIONS(61),
    [anon_sym_and] = ACTIONS(268),
    [anon_sym_or] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_PERCENT] = ACTIONS(266),
    [anon_sym_SLASH_SLASH] = ACTIONS(266),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_AMP] = ACTIONS(266),
    [anon_sym_CARET] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(266),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LT] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(266),
    [anon_sym_EQ_EQ] = ACTIONS(266),
    [anon_sym_BANG_EQ] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(266),
    [anon_sym_GT] = ACTIONS(268),
    [anon_sym_LT_GT] = ACTIONS(266),
    [anon_sym_is] = ACTIONS(268),
    [anon_sym_lambda] = ACTIONS(65),
    [sym_ellipsis] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(71),
    [sym_integer] = ACTIONS(73),
    [sym_float] = ACTIONS(69),
    [anon_sym_await] = ACTIONS(317),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_none] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [sym__newline] = ACTIONS(266),
    [sym__string_start] = ACTIONS(77),
  },
  [162] = {
    [sym_named_expression] = STATE(1490),
    [sym__named_expresssion_lhs] = STATE(2078),
    [sym_as_pattern] = STATE(1490),
    [sym_expression] = STATE(1477),
    [sym_primary_expression] = STATE(831),
    [sym_not_operator] = STATE(1490),
    [sym_boolean_operator] = STATE(1490),
    [sym_binary_operator] = STATE(1119),
    [sym_unary_operator] = STATE(1119),
    [sym_comparison_operator] = STATE(1490),
    [sym_lambda] = STATE(1490),
    [sym_attribute] = STATE(1119),
    [sym_subscript] = STATE(1119),
    [sym_call] = STATE(1119),
    [sym_list] = STATE(1119),
    [sym_set] = STATE(1119),
    [sym_tuple] = STATE(1119),
    [sym_dictionary] = STATE(1119),
    [sym_list_comprehension] = STATE(1119),
    [sym_dictionary_comprehension] = STATE(1119),
    [sym_set_comprehension] = STATE(1119),
    [sym_generator_expression] = STATE(1119),
    [sym_parenthesized_expression] = STATE(1119),
    [sym_conditional_expression] = STATE(1490),
    [sym_concatenated_string] = STATE(1119),
    [sym_string] = STATE(838),
    [sym_await] = STATE(1490),
    [sym_identifier] = ACTIONS(613),
    [anon_sym_DOT] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(615),
    [anon_sym_COMMA] = ACTIONS(266),
    [anon_sym_as] = ACTIONS(268),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_print] = ACTIONS(617),
    [anon_sym_GT_GT] = ACTIONS(266),
    [anon_sym_match] = ACTIONS(619),
    [anon_sym_if] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(266),
    [anon_sym_async] = ACTIONS(617),
    [anon_sym_in] = ACTIONS(268),
    [anon_sym_STAR_STAR] = ACTIONS(266),
    [anon_sym_exec] = ACTIONS(617),
    [anon_sym_AT] = ACTIONS(266),
    [anon_sym_LBRACK] = ACTIONS(621),
    [anon_sym_EQ] = ACTIONS(268),
    [anon_sym_not] = ACTIONS(623),
    [anon_sym_and] = ACTIONS(268),
    [anon_sym_or] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(625),
    [anon_sym_DASH] = ACTIONS(625),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_PERCENT] = ACTIONS(266),
    [anon_sym_SLASH_SLASH] = ACTIONS(266),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_AMP] = ACTIONS(266),
    [anon_sym_CARET] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(266),
    [anon_sym_TILDE] = ACTIONS(625),
    [anon_sym_LT] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(266),
    [anon_sym_EQ_EQ] = ACTIONS(266),
    [anon_sym_BANG_EQ] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(266),
    [anon_sym_GT] = ACTIONS(268),
    [anon_sym_LT_GT] = ACTIONS(266),
    [anon_sym_is] = ACTIONS(268),
    [anon_sym_lambda] = ACTIONS(627),
    [sym_ellipsis] = ACTIONS(629),
    [anon_sym_LBRACE] = ACTIONS(631),
    [anon_sym_RBRACE] = ACTIONS(266),
    [sym_type_conversion] = ACTIONS(266),
    [sym_integer] = ACTIONS(633),
    [sym_float] = ACTIONS(629),
    [anon_sym_await] = ACTIONS(635),
    [sym_true] = ACTIONS(633),
    [sym_false] = ACTIONS(633),
    [sym_none] = ACTIONS(633),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(637),
  },
  [163] = {
    [sym_named_expression] = STATE(1504),
    [sym__named_expresssion_lhs] = STATE(2190),
    [sym_as_pattern] = STATE(1504),
    [sym_expression] = STATE(1549),
    [sym_primary_expression] = STATE(876),
    [sym_not_operator] = STATE(1504),
    [sym_boolean_operator] = STATE(1504),
    [sym_binary_operator] = STATE(1228),
    [sym_unary_operator] = STATE(1228),
    [sym_comparison_operator] = STATE(1504),
    [sym_lambda] = STATE(1504),
    [sym_attribute] = STATE(1228),
    [sym_subscript] = STATE(1228),
    [sym_call] = STATE(1228),
    [sym_list] = STATE(1228),
    [sym_set] = STATE(1228),
    [sym_tuple] = STATE(1228),
    [sym_dictionary] = STATE(1228),
    [sym_list_comprehension] = STATE(1228),
    [sym_dictionary_comprehension] = STATE(1228),
    [sym_set_comprehension] = STATE(1228),
    [sym_generator_expression] = STATE(1228),
    [sym_parenthesized_expression] = STATE(1228),
    [sym_conditional_expression] = STATE(1504),
    [sym_concatenated_string] = STATE(1228),
    [sym_string] = STATE(856),
    [sym_await] = STATE(1504),
    [sym_identifier] = ACTIONS(639),
    [anon_sym_DOT] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(641),
    [anon_sym_RPAREN] = ACTIONS(266),
    [anon_sym_COMMA] = ACTIONS(266),
    [anon_sym_as] = ACTIONS(268),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_print] = ACTIONS(643),
    [anon_sym_GT_GT] = ACTIONS(266),
    [anon_sym_match] = ACTIONS(645),
    [anon_sym_if] = ACTIONS(268),
    [anon_sym_async] = ACTIONS(643),
    [anon_sym_for] = ACTIONS(268),
    [anon_sym_in] = ACTIONS(268),
    [anon_sym_STAR_STAR] = ACTIONS(266),
    [anon_sym_exec] = ACTIONS(643),
    [anon_sym_AT] = ACTIONS(266),
    [anon_sym_LBRACK] = ACTIONS(647),
    [anon_sym_EQ] = ACTIONS(649),
    [anon_sym_not] = ACTIONS(651),
    [anon_sym_and] = ACTIONS(268),
    [anon_sym_or] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(653),
    [anon_sym_DASH] = ACTIONS(653),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_PERCENT] = ACTIONS(266),
    [anon_sym_SLASH_SLASH] = ACTIONS(266),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_AMP] = ACTIONS(266),
    [anon_sym_CARET] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(266),
    [anon_sym_TILDE] = ACTIONS(653),
    [anon_sym_LT] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(266),
    [anon_sym_EQ_EQ] = ACTIONS(266),
    [anon_sym_BANG_EQ] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(266),
    [anon_sym_GT] = ACTIONS(268),
    [anon_sym_LT_GT] = ACTIONS(266),
    [anon_sym_is] = ACTIONS(268),
    [anon_sym_lambda] = ACTIONS(655),
    [sym_ellipsis] = ACTIONS(657),
    [anon_sym_LBRACE] = ACTIONS(659),
    [sym_integer] = ACTIONS(661),
    [sym_float] = ACTIONS(657),
    [anon_sym_await] = ACTIONS(663),
    [sym_true] = ACTIONS(661),
    [sym_false] = ACTIONS(661),
    [sym_none] = ACTIONS(661),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(665),
  },
  [164] = {
    [sym_named_expression] = STATE(1493),
    [sym__named_expresssion_lhs] = STATE(2187),
    [sym_as_pattern] = STATE(1493),
    [sym_expression] = STATE(1466),
    [sym_primary_expression] = STATE(844),
    [sym_not_operator] = STATE(1493),
    [sym_boolean_operator] = STATE(1493),
    [sym_binary_operator] = STATE(1159),
    [sym_unary_operator] = STATE(1159),
    [sym_comparison_operator] = STATE(1493),
    [sym_lambda] = STATE(1493),
    [sym_attribute] = STATE(1159),
    [sym_subscript] = STATE(1159),
    [sym_call] = STATE(1159),
    [sym_list] = STATE(1159),
    [sym_set] = STATE(1159),
    [sym_tuple] = STATE(1159),
    [sym_dictionary] = STATE(1159),
    [sym_list_comprehension] = STATE(1159),
    [sym_dictionary_comprehension] = STATE(1159),
    [sym_set_comprehension] = STATE(1159),
    [sym_generator_expression] = STATE(1159),
    [sym_parenthesized_expression] = STATE(1159),
    [sym_conditional_expression] = STATE(1493),
    [sym_concatenated_string] = STATE(1159),
    [sym_string] = STATE(833),
    [sym_await] = STATE(1493),
    [sym_identifier] = ACTIONS(667),
    [anon_sym_DOT] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(669),
    [anon_sym_COMMA] = ACTIONS(266),
    [anon_sym_as] = ACTIONS(268),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_print] = ACTIONS(671),
    [anon_sym_GT_GT] = ACTIONS(266),
    [anon_sym_match] = ACTIONS(673),
    [anon_sym_if] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(266),
    [anon_sym_async] = ACTIONS(671),
    [anon_sym_for] = ACTIONS(268),
    [anon_sym_in] = ACTIONS(268),
    [anon_sym_STAR_STAR] = ACTIONS(266),
    [anon_sym_exec] = ACTIONS(671),
    [anon_sym_AT] = ACTIONS(266),
    [anon_sym_LBRACK] = ACTIONS(675),
    [anon_sym_not] = ACTIONS(677),
    [anon_sym_and] = ACTIONS(268),
    [anon_sym_or] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(679),
    [anon_sym_DASH] = ACTIONS(679),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_PERCENT] = ACTIONS(266),
    [anon_sym_SLASH_SLASH] = ACTIONS(266),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_AMP] = ACTIONS(266),
    [anon_sym_CARET] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(266),
    [anon_sym_TILDE] = ACTIONS(679),
    [anon_sym_LT] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(266),
    [anon_sym_EQ_EQ] = ACTIONS(266),
    [anon_sym_BANG_EQ] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(266),
    [anon_sym_GT] = ACTIONS(268),
    [anon_sym_LT_GT] = ACTIONS(266),
    [anon_sym_is] = ACTIONS(268),
    [anon_sym_lambda] = ACTIONS(681),
    [sym_ellipsis] = ACTIONS(683),
    [anon_sym_LBRACE] = ACTIONS(685),
    [anon_sym_RBRACE] = ACTIONS(266),
    [sym_integer] = ACTIONS(687),
    [sym_float] = ACTIONS(683),
    [anon_sym_await] = ACTIONS(689),
    [sym_true] = ACTIONS(687),
    [sym_false] = ACTIONS(687),
    [sym_none] = ACTIONS(687),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(691),
  },
  [165] = {
    [sym_named_expression] = STATE(1500),
    [sym__named_expresssion_lhs] = STATE(2173),
    [sym_as_pattern] = STATE(1500),
    [sym_expression] = STATE(1508),
    [sym_primary_expression] = STATE(869),
    [sym_not_operator] = STATE(1500),
    [sym_boolean_operator] = STATE(1500),
    [sym_binary_operator] = STATE(1168),
    [sym_unary_operator] = STATE(1168),
    [sym_comparison_operator] = STATE(1500),
    [sym_lambda] = STATE(1500),
    [sym_attribute] = STATE(1168),
    [sym_subscript] = STATE(1168),
    [sym_call] = STATE(1168),
    [sym_list] = STATE(1168),
    [sym_set] = STATE(1168),
    [sym_tuple] = STATE(1168),
    [sym_dictionary] = STATE(1168),
    [sym_list_comprehension] = STATE(1168),
    [sym_dictionary_comprehension] = STATE(1168),
    [sym_set_comprehension] = STATE(1168),
    [sym_generator_expression] = STATE(1168),
    [sym_parenthesized_expression] = STATE(1168),
    [sym_conditional_expression] = STATE(1500),
    [sym_concatenated_string] = STATE(1168),
    [sym_string] = STATE(861),
    [sym_await] = STATE(1500),
    [sym_identifier] = ACTIONS(264),
    [anon_sym_DOT] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(693),
    [anon_sym_COMMA] = ACTIONS(266),
    [anon_sym_as] = ACTIONS(268),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_print] = ACTIONS(276),
    [anon_sym_GT_GT] = ACTIONS(266),
    [anon_sym_match] = ACTIONS(280),
    [anon_sym_if] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(266),
    [anon_sym_else] = ACTIONS(268),
    [anon_sym_async] = ACTIONS(276),
    [anon_sym_in] = ACTIONS(268),
    [anon_sym_STAR_STAR] = ACTIONS(266),
    [anon_sym_exec] = ACTIONS(276),
    [anon_sym_AT] = ACTIONS(266),
    [anon_sym_LBRACK] = ACTIONS(695),
    [anon_sym_EQ] = ACTIONS(268),
    [anon_sym_not] = ACTIONS(697),
    [anon_sym_and] = ACTIONS(268),
    [anon_sym_or] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(293),
    [anon_sym_DASH] = ACTIONS(293),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_PERCENT] = ACTIONS(266),
    [anon_sym_SLASH_SLASH] = ACTIONS(266),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_AMP] = ACTIONS(266),
    [anon_sym_CARET] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(266),
    [anon_sym_TILDE] = ACTIONS(293),
    [anon_sym_LT] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(266),
    [anon_sym_EQ_EQ] = ACTIONS(266),
    [anon_sym_BANG_EQ] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(266),
    [anon_sym_GT] = ACTIONS(268),
    [anon_sym_LT_GT] = ACTIONS(266),
    [anon_sym_is] = ACTIONS(268),
    [anon_sym_lambda] = ACTIONS(295),
    [sym_ellipsis] = ACTIONS(299),
    [anon_sym_LBRACE] = ACTIONS(301),
    [sym_integer] = ACTIONS(303),
    [sym_float] = ACTIONS(299),
    [anon_sym_await] = ACTIONS(305),
    [sym_true] = ACTIONS(303),
    [sym_false] = ACTIONS(303),
    [sym_none] = ACTIONS(303),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(307),
  },
  [166] = {
    [sym_named_expression] = STATE(1578),
    [sym__named_expresssion_lhs] = STATE(2080),
    [sym_as_pattern] = STATE(1578),
    [sym_expression] = STATE(1593),
    [sym_primary_expression] = STATE(955),
    [sym_not_operator] = STATE(1578),
    [sym_boolean_operator] = STATE(1578),
    [sym_binary_operator] = STATE(1271),
    [sym_unary_operator] = STATE(1271),
    [sym_comparison_operator] = STATE(1578),
    [sym_lambda] = STATE(1578),
    [sym_attribute] = STATE(1271),
    [sym_subscript] = STATE(1271),
    [sym_call] = STATE(1271),
    [sym_list] = STATE(1271),
    [sym_set] = STATE(1271),
    [sym_tuple] = STATE(1271),
    [sym_dictionary] = STATE(1271),
    [sym_list_comprehension] = STATE(1271),
    [sym_dictionary_comprehension] = STATE(1271),
    [sym_set_comprehension] = STATE(1271),
    [sym_generator_expression] = STATE(1271),
    [sym_parenthesized_expression] = STATE(1271),
    [sym_conditional_expression] = STATE(1578),
    [sym_concatenated_string] = STATE(1271),
    [sym_string] = STATE(954),
    [sym_await] = STATE(1578),
    [sym_identifier] = ACTIONS(699),
    [anon_sym_DOT] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(701),
    [anon_sym_RPAREN] = ACTIONS(266),
    [anon_sym_COMMA] = ACTIONS(266),
    [anon_sym_as] = ACTIONS(268),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_print] = ACTIONS(703),
    [anon_sym_GT_GT] = ACTIONS(266),
    [anon_sym_match] = ACTIONS(705),
    [anon_sym_if] = ACTIONS(268),
    [anon_sym_async] = ACTIONS(703),
    [anon_sym_in] = ACTIONS(268),
    [anon_sym_STAR_STAR] = ACTIONS(266),
    [anon_sym_exec] = ACTIONS(703),
    [anon_sym_AT] = ACTIONS(266),
    [anon_sym_LBRACK] = ACTIONS(707),
    [anon_sym_EQ] = ACTIONS(268),
    [anon_sym_not] = ACTIONS(709),
    [anon_sym_and] = ACTIONS(268),
    [anon_sym_or] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(711),
    [anon_sym_DASH] = ACTIONS(711),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_PERCENT] = ACTIONS(266),
    [anon_sym_SLASH_SLASH] = ACTIONS(266),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_AMP] = ACTIONS(266),
    [anon_sym_CARET] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(266),
    [anon_sym_TILDE] = ACTIONS(711),
    [anon_sym_LT] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(266),
    [anon_sym_EQ_EQ] = ACTIONS(266),
    [anon_sym_BANG_EQ] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(266),
    [anon_sym_GT] = ACTIONS(268),
    [anon_sym_LT_GT] = ACTIONS(266),
    [anon_sym_is] = ACTIONS(268),
    [anon_sym_lambda] = ACTIONS(713),
    [sym_ellipsis] = ACTIONS(715),
    [anon_sym_LBRACE] = ACTIONS(717),
    [sym_integer] = ACTIONS(719),
    [sym_float] = ACTIONS(715),
    [anon_sym_await] = ACTIONS(721),
    [sym_true] = ACTIONS(719),
    [sym_false] = ACTIONS(719),
    [sym_none] = ACTIONS(719),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(723),
  },
  [167] = {
    [sym_named_expression] = STATE(1504),
    [sym__named_expresssion_lhs] = STATE(2190),
    [sym_as_pattern] = STATE(1504),
    [sym_expression] = STATE(1549),
    [sym_primary_expression] = STATE(876),
    [sym_not_operator] = STATE(1504),
    [sym_boolean_operator] = STATE(1504),
    [sym_binary_operator] = STATE(1228),
    [sym_unary_operator] = STATE(1228),
    [sym_comparison_operator] = STATE(1504),
    [sym_lambda] = STATE(1504),
    [sym_attribute] = STATE(1228),
    [sym_subscript] = STATE(1228),
    [sym_call] = STATE(1228),
    [sym_list] = STATE(1228),
    [sym_set] = STATE(1228),
    [sym_tuple] = STATE(1228),
    [sym_dictionary] = STATE(1228),
    [sym_list_comprehension] = STATE(1228),
    [sym_dictionary_comprehension] = STATE(1228),
    [sym_set_comprehension] = STATE(1228),
    [sym_generator_expression] = STATE(1228),
    [sym_parenthesized_expression] = STATE(1228),
    [sym_conditional_expression] = STATE(1504),
    [sym_concatenated_string] = STATE(1228),
    [sym_string] = STATE(856),
    [sym_await] = STATE(1504),
    [sym_identifier] = ACTIONS(639),
    [anon_sym_DOT] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(641),
    [anon_sym_RPAREN] = ACTIONS(273),
    [anon_sym_COMMA] = ACTIONS(273),
    [anon_sym_as] = ACTIONS(268),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_print] = ACTIONS(643),
    [anon_sym_GT_GT] = ACTIONS(266),
    [anon_sym_match] = ACTIONS(645),
    [anon_sym_if] = ACTIONS(268),
    [anon_sym_async] = ACTIONS(643),
    [anon_sym_for] = ACTIONS(268),
    [anon_sym_in] = ACTIONS(268),
    [anon_sym_STAR_STAR] = ACTIONS(266),
    [anon_sym_exec] = ACTIONS(643),
    [anon_sym_AT] = ACTIONS(266),
    [anon_sym_LBRACK] = ACTIONS(647),
    [anon_sym_not] = ACTIONS(651),
    [anon_sym_and] = ACTIONS(268),
    [anon_sym_or] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(653),
    [anon_sym_DASH] = ACTIONS(653),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_PERCENT] = ACTIONS(266),
    [anon_sym_SLASH_SLASH] = ACTIONS(266),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_AMP] = ACTIONS(266),
    [anon_sym_CARET] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(266),
    [anon_sym_TILDE] = ACTIONS(653),
    [anon_sym_LT] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(266),
    [anon_sym_EQ_EQ] = ACTIONS(266),
    [anon_sym_BANG_EQ] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(266),
    [anon_sym_GT] = ACTIONS(268),
    [anon_sym_LT_GT] = ACTIONS(266),
    [anon_sym_is] = ACTIONS(268),
    [anon_sym_lambda] = ACTIONS(655),
    [sym_ellipsis] = ACTIONS(657),
    [anon_sym_LBRACE] = ACTIONS(659),
    [sym_integer] = ACTIONS(661),
    [sym_float] = ACTIONS(657),
    [anon_sym_await] = ACTIONS(663),
    [sym_true] = ACTIONS(661),
    [sym_false] = ACTIONS(661),
    [sym_none] = ACTIONS(661),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(665),
  },
  [168] = {
    [sym_named_expression] = STATE(1541),
    [sym__named_expresssion_lhs] = STATE(2091),
    [sym_as_pattern] = STATE(1541),
    [sym_expression] = STATE(1522),
    [sym_primary_expression] = STATE(874),
    [sym_not_operator] = STATE(1541),
    [sym_boolean_operator] = STATE(1541),
    [sym_binary_operator] = STATE(1262),
    [sym_unary_operator] = STATE(1262),
    [sym_comparison_operator] = STATE(1541),
    [sym_lambda] = STATE(1541),
    [sym_attribute] = STATE(1262),
    [sym_subscript] = STATE(1262),
    [sym_call] = STATE(1262),
    [sym_list] = STATE(1262),
    [sym_set] = STATE(1262),
    [sym_tuple] = STATE(1262),
    [sym_dictionary] = STATE(1262),
    [sym_list_comprehension] = STATE(1262),
    [sym_dictionary_comprehension] = STATE(1262),
    [sym_set_comprehension] = STATE(1262),
    [sym_generator_expression] = STATE(1262),
    [sym_parenthesized_expression] = STATE(1262),
    [sym_conditional_expression] = STATE(1541),
    [sym_concatenated_string] = STATE(1262),
    [sym_string] = STATE(855),
    [sym_await] = STATE(1541),
    [sym_identifier] = ACTIONS(725),
    [anon_sym_DOT] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(727),
    [anon_sym_COMMA] = ACTIONS(266),
    [anon_sym_as] = ACTIONS(268),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_print] = ACTIONS(729),
    [anon_sym_GT_GT] = ACTIONS(266),
    [anon_sym_match] = ACTIONS(731),
    [anon_sym_if] = ACTIONS(268),
    [anon_sym_async] = ACTIONS(729),
    [anon_sym_for] = ACTIONS(268),
    [anon_sym_in] = ACTIONS(268),
    [anon_sym_STAR_STAR] = ACTIONS(266),
    [anon_sym_exec] = ACTIONS(729),
    [anon_sym_AT] = ACTIONS(266),
    [anon_sym_LBRACK] = ACTIONS(733),
    [anon_sym_RBRACK] = ACTIONS(266),
    [anon_sym_not] = ACTIONS(735),
    [anon_sym_and] = ACTIONS(268),
    [anon_sym_or] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(737),
    [anon_sym_DASH] = ACTIONS(737),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_PERCENT] = ACTIONS(266),
    [anon_sym_SLASH_SLASH] = ACTIONS(266),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_AMP] = ACTIONS(266),
    [anon_sym_CARET] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(266),
    [anon_sym_TILDE] = ACTIONS(737),
    [anon_sym_LT] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(266),
    [anon_sym_EQ_EQ] = ACTIONS(266),
    [anon_sym_BANG_EQ] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(266),
    [anon_sym_GT] = ACTIONS(268),
    [anon_sym_LT_GT] = ACTIONS(266),
    [anon_sym_is] = ACTIONS(268),
    [anon_sym_lambda] = ACTIONS(739),
    [sym_ellipsis] = ACTIONS(741),
    [anon_sym_LBRACE] = ACTIONS(743),
    [sym_integer] = ACTIONS(745),
    [sym_float] = ACTIONS(741),
    [anon_sym_await] = ACTIONS(747),
    [sym_true] = ACTIONS(745),
    [sym_false] = ACTIONS(745),
    [sym_none] = ACTIONS(745),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(749),
  },
  [169] = {
    [sym_named_expression] = STATE(1504),
    [sym__named_expresssion_lhs] = STATE(2190),
    [sym_as_pattern] = STATE(1504),
    [sym_expression] = STATE(1549),
    [sym_primary_expression] = STATE(876),
    [sym_not_operator] = STATE(1504),
    [sym_boolean_operator] = STATE(1504),
    [sym_binary_operator] = STATE(1228),
    [sym_unary_operator] = STATE(1228),
    [sym_comparison_operator] = STATE(1504),
    [sym_lambda] = STATE(1504),
    [sym_attribute] = STATE(1228),
    [sym_subscript] = STATE(1228),
    [sym_call] = STATE(1228),
    [sym_list] = STATE(1228),
    [sym_set] = STATE(1228),
    [sym_tuple] = STATE(1228),
    [sym_dictionary] = STATE(1228),
    [sym_list_comprehension] = STATE(1228),
    [sym_dictionary_comprehension] = STATE(1228),
    [sym_set_comprehension] = STATE(1228),
    [sym_generator_expression] = STATE(1228),
    [sym_parenthesized_expression] = STATE(1228),
    [sym_conditional_expression] = STATE(1504),
    [sym_concatenated_string] = STATE(1228),
    [sym_string] = STATE(856),
    [sym_await] = STATE(1504),
    [sym_identifier] = ACTIONS(639),
    [anon_sym_DOT] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(641),
    [anon_sym_RPAREN] = ACTIONS(266),
    [anon_sym_COMMA] = ACTIONS(266),
    [anon_sym_as] = ACTIONS(268),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_print] = ACTIONS(643),
    [anon_sym_GT_GT] = ACTIONS(266),
    [anon_sym_match] = ACTIONS(645),
    [anon_sym_if] = ACTIONS(268),
    [anon_sym_async] = ACTIONS(643),
    [anon_sym_for] = ACTIONS(268),
    [anon_sym_in] = ACTIONS(268),
    [anon_sym_STAR_STAR] = ACTIONS(266),
    [anon_sym_exec] = ACTIONS(643),
    [anon_sym_AT] = ACTIONS(266),
    [anon_sym_LBRACK] = ACTIONS(647),
    [anon_sym_not] = ACTIONS(651),
    [anon_sym_and] = ACTIONS(268),
    [anon_sym_or] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(653),
    [anon_sym_DASH] = ACTIONS(653),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_PERCENT] = ACTIONS(266),
    [anon_sym_SLASH_SLASH] = ACTIONS(266),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_AMP] = ACTIONS(266),
    [anon_sym_CARET] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(266),
    [anon_sym_TILDE] = ACTIONS(653),
    [anon_sym_LT] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(266),
    [anon_sym_EQ_EQ] = ACTIONS(266),
    [anon_sym_BANG_EQ] = ACTIONS(266),
    [anon_sym_GT_EQ] = ACTIONS(266),
    [anon_sym_GT] = ACTIONS(268),
    [anon_sym_LT_GT] = ACTIONS(266),
    [anon_sym_is] = ACTIONS(268),
    [anon_sym_lambda] = ACTIONS(655),
    [sym_ellipsis] = ACTIONS(657),
    [anon_sym_LBRACE] = ACTIONS(659),
    [sym_integer] = ACTIONS(661),
    [sym_float] = ACTIONS(657),
    [anon_sym_await] = ACTIONS(663),
    [sym_true] = ACTIONS(661),
    [sym_false] = ACTIONS(661),
    [sym_none] = ACTIONS(661),
    [sym_comment] = ACTIONS(3),
    [sym__string_start] = ACTIONS(665),
  },
  [170] = {
    [sym_named_expression] = STATE(1601),
    [sym__named_expresssion_lhs] = STATE(2053),
    [sym_as_pattern] = STATE(1601),
    [sym_expression] = STATE(1583),
    [sym_primary_expression] = STATE(938),
    [sym_not_operator] = STATE(1601),
    [sym_boolean_operator] = STATE(1601),
    [sym_binary_operator] = STATE(1310),
    [sym_unary_operator] = STATE(1310),
    [sym_comparison_operator] = STATE(1601),
    [sym_lambda] = STATE(1601),
    [sym_attribute] = STATE(1310),
    [sym_subscript] = STATE(1310),
    [sym_call] = STATE(1310),
    [sym_list] = STATE(1310),
    [sym_set] = STATE(1310),
    [sym_tuple] = STATE(1310),
    [sym_dictionary] = STATE(1310),
    [sym_list_comprehension] = STATE(1310),
    [sym_dictionary_comprehension] = STATE(1310),
    [sym_set_comprehension] = STATE(1310),
    [sym_generator_expression] = STATE(1310),
    [sym_parenthesized_expression] = STATE(1310),
    [sym_conditional_expression] = STATE(1601),
    [sym_concatenated_string] = STATE(1310),
    [sym_string] = STATE(937),
    [sym_await] = STATE(1601),
    [sym_identifier] = ACTIONS(751),
    [anon_sym_DOT] = ACTIONS(268),
    [anon_sym_LPAREN] = ACTIONS(753),
    [anon_sym_COMMA] = ACTIONS(266),
    [anon_sym_as] = ACTIONS(268),
    [anon_sym_STAR] = ACTIONS(268),
    [anon_sym_print] = ACTIONS(755),
    [anon_sym_GT_GT] = ACTIONS(266),
    [anon_sym_match] = ACTIONS(757),
    [anon_sym_if] = ACTIONS(268),
    [anon_sym_COLON] = ACTIONS(266),
    [anon_sym_async] = ACTIONS(755),
    [anon_sym_in] = ACTIONS(268),
    [anon_sym_STAR_STAR] = ACTIONS(266),
    [anon_sym_exec] = ACTIONS(755),
    [anon_sym_AT] = ACTIONS(266),
    [anon_sym_LBRACK] = ACTIONS(759),
    [anon_sym_RBRACK] = ACTIONS(266),
    [anon_sym_not] = ACTIONS(761),
    [anon_sym_and] = ACTIONS(268),
    [anon_sym_or] = ACTIONS(268),
    [anon_sym_PLUS] = ACTIONS(763),
    [anon_sym_DASH] = ACTIONS(763),
    [anon_sym_SLASH] = ACTIONS(268),
    [anon_sym_PERCENT] = ACTIONS(266),
    [anon_sym_SLASH_SLASH] = ACTIONS(266),
    [anon_sym_PIPE] = ACTIONS(266),
    [anon_sym_AMP] = ACTIONS(266),
    [anon_sym_CARET] = ACTIONS(266),
    [anon_sym_LT_LT] = ACTIONS(266),
    [anon_sym_TILDE] = ACTIONS(763),
    [anon_sym_LT] = ACTIONS(268),
    [anon_sym_LT_EQ] = ACTIONS(266),
    [anon_sym_EQ_EQ] = ACTIONS(266),
    [anon_sym_BANG_EQ] = ACTIONS(266),
    [anon_sym_GT_EQ] =