# Understanding Domain Generalization with Label Noise

The main code is based on [Domainbed](https://github.com/facebookresearch/DomainBed) from Facebook. 

The toy example is based on [overparam_spur_corr](https://github.com/ssagawa/overparam_spur_corr) by [Sagawa et al., 2020](https://arxiv.org/pdf/2005.04345.pdf)

## Additional Datasets Based on WILDS ([Koh et al., 2020](https://arxiv.org/abs/2012.07421))

* Waterbirds 
* Waterbirds+
* CelebA
* CelebA+

## Compared Algorithms

* ERM
* Mixup
* GroupDRO
* IRM
* V-REx

<!-- ## Additional model selection criteria -->

## To Reproduce Our Main Results

Choose the datasets in `domainbed/scripts/download.py`, then download the datasets:

```sh
python3 -m domainbed.scripts.download \
       --data_dir=./domainbed/data
```

Train a model with label noise:

```sh
python3 -m domainbed.scripts.train\
       --data_dir=./domainbed/data/MNIST/\
       --algorithm ERM\
       --dataset CMNISTMod\
       --test_env 2\
       --hparams '{"flip_prob":0.1}' \
```

Launch a sweep for label noise study for standard datasets:

```sh
python -m domainbed.scripts.sweep launch\
    --data_dir=./domainbed/data/\
    --output_dir=./results/noise_pacs/\
    --command_launcher multi_gpu\
    --algorithms IRM GroupDRO Mixup ERM VREx    \
    --datasets PACS  \
    --n_hparams 20       \
    --n_trials 3       \
    --steps 5000      \
    --single_test_envs         \
    --hparams '{"flip_prob":0.1, "study_noise":1}' \
```


To launch a sweep for Waterbirds and CelebA datasets with 4 groups as environments, we
must specify the `--test_envs` to be `4 5`, the data processor will allocate the standard val and test splits to those envs.
The `--holdout_fraction` should be set to 0.
```sh
python -m domainbed.scripts.sweep launch\
    --data_dir=./domainbed/data/\
    --output_dir=./results/noise_waterbirds/\
    --command_launcher multi_gpu\
    --algorithms ERM IRM GroupDRO Mixup VREx    \
    --datasets WILDSWaterbirds  \
    --n_hparams 20       \
    --n_trials 3       \
    --steps 5000      \
    --test_envs 4 5        \
    --holdout_fraction 0 \
    --hparams '{"flip_prob":0.1, "study_noise":1}' \
```



To launch a sweep for Waterbirds+ or CelebA+ datasets with 2 newly created environments, we
must specify the `--test_envs` to be `2 3`.
The `--holdout_fraction` should be set to 0. Lastly, set `wilds_spu_study` to true for `--hparams`
```sh
python -m domainbed.scripts.sweep launch\
    --data_dir=./domainbed/data/\
    --output_dir=./results/waterbirds_subpop/\
    --command_launcher multi_gpu\
    --algorithms ERM IRM GroupDRO Mixup VREx    \
    --datasets WILDSWaterbirds  \
    --n_hparams 20       \
    --n_trials 3       \
    --steps 5000      \
    --test_envs 2 3        \
    --holdout_fraction 0 \
    --hparams '{"wilds_spu_study":1, "flip_prob":0.1, "study_noise":1}' \
```

### NOTE
`hparams` affects the seed hashed by Domainbed. To reproduce the results, please make sure the order of the string are consistent with no additional spacing added. Will update this in the future. 

## Synthetic Toy Example

To run a simulated experiment with label noise:
```sh
cd toy_example 
python run_toy_example.py  -o results.csv -N 3000 -n 1000\
    --toy_example_name complete --p_correlation 0.99\
    --mean_causal 1 --var_causal 0.25\
    --mean_spurious 1 --var_spurious 0.25\
    --mean_noise 0 --var_noise 1 \
    --model_type logistic --error_type zero_one\
    --Lambda 1e-04 -q --d_causal 5 --d_spurious 5 \
    --label_noise 0.1
```