# ---------------------------------------
# Copyright (c) Meta Platforms, Inc. and affiliates.
# All rights reserved.

# This source code is licensed under the license found in the
# LICENSE file in the root directory of this source tree.
# ---------------------------------------

"""
List of class names per dataset, used to make prompts for zero-shot evaluation.
Keys are name of Torchvision dataset classes, and values are list of class names.

Credits: https://github.com/facebookresearch/SLIP (labels.json)
"""

CLASS_NAMES = dict(
    food101=[
        "apple pie",
        "baby back ribs",
        "baklava",
        "beef carpaccio",
        "beef tartare",
        "beet salad",
        "beignets",
        "bibimbap",
        "bread pudding",
        "breakfast burrito",
        "bruschetta",
        "caesar salad",
        "cannoli",
        "caprese salad",
        "carrot cake",
        "ceviche",
        "cheese plate",
        "cheesecake",
        "chicken curry",
        "chicken quesadilla",
        "chicken wings",
        "chocolate cake",
        "chocolate mousse",
        "churros",
        "clam chowder",
        "club sandwich",
        "crab cakes",
        "creme brulee",
        "croque madame",
        "cup cakes",
        "deviled eggs",
        "donuts",
        "dumplings",
        "edamame",
        "eggs benedict",
        "escargots",
        "falafel",
        "filet mignon",
        "fish and chips",
        "foie gras",
        "french fries",
        "french onion soup",
        "french toast",
        "fried calamari",
        "fried rice",
        "frozen yogurt",
        "garlic bread",
        "gnocchi",
        "greek salad",
        "grilled cheese sandwich",
        "grilled salmon",
        "guacamole",
        "gyoza",
        "hamburger",
        "hot and sour soup",
        "hot dog",
        "huevos rancheros",
        "hummus",
        "ice cream",
        "lasagna",
        "lobster bisque",
        "lobster roll sandwich",
        "macaroni and cheese",
        "macarons",
        "miso soup",
        "mussels",
        "nachos",
        "omelette",
        "onion rings",
        "oysters",
        "pad thai",
        "paella",
        "pancakes",
        "panna cotta",
        "peking duck",
        "pho",
        "pizza",
        "pork chop",
        "poutine",
        "prime rib",
        "pulled pork sandwich",
        "ramen",
        "ravioli",
        "red velvet cake",
        "risotto",
        "samosa",
        "sashimi",
        "scallops",
        "seaweed salad",
        "shrimp and grits",
        "spaghetti bolognese",
        "spaghetti carbonara",
        "spring rolls",
        "steak",
        "strawberry shortcake",
        "sushi",
        "tacos",
        "takoyaki",
        "tiramisu",
        "tuna tartare",
        "waffles",
    ],
    cifar10=[
        "airplane",
        "automobile",
        "bird",
        "cat",
        "deer",
        "dog",
        "frog",
        "horse",
        "ship",
        "truck",
    ],
    cifar100=[
        "apple",
        "aquarium fish",
        "baby",
        "bear",
        "beaver",
        "bed",
        "bee",
        "beetle",
        "bicycle",
        "bottle",
        "bowl",
        "boy",
        "bridge",
        "bus",
        "butterfly",
        "camel",
        "can",
        "castle",
        "caterpillar",
        "cattle",
        "chair",
        "chimpanzee",
        "clock",
        "cloud",
        "cockroach",
        "couch",
        "crab",
        "crocodile",
        "cup",
        "dinosaur",
        "dolphin",
        "elephant",
        "flatfish",
        "forest",
        "fox",
        "girl",
        "hamster",
        "house",
        "kangaroo",
        "keyboard",
        "lamp",
        "lawn mower",
        "leopard",
        "lion",
        "lizard",
        "lobster",
        "man",
        "maple tree",
        "motorcycle",
        "mountain",
        "mouse",
        "mushroom",
        "oak tree",
        "orange",
        "orchid",
        "otter",
        "palm tree",
        "pear",
        "pickup truck",
        "pine tree",
        "plain",
        "plate",
        "poppy",
        "porcupine",
        "possum",
        "rabbit",
        "raccoon",
        "ray",
        "road",
        "rocket",
        "rose",
        "sea",
        "seal",
        "shark",
        "shrew",
        "skunk",
        "skyscraper",
        "snail",
        "snake",
        "spider",
        "squirrel",
        "streetcar",
        "sunflower",
        "sweet pepper",
        "table",
        "tank",
        "telephone",
        "television",
        "tiger",
        "tractor",
        "train",
        "trout",
        "tulip",
        "turtle",
        "wardrobe",
        "whale",
        "willow tree",
        "wolf",
        "woman",
        "worm",
    ],
    cub2011=[
        "Black footed Albatross",
        "Laysan Albatross",
        "Sooty Albatross",
        "Groove billed Ani",
        "Crested Auklet",
        "Least Auklet",
        "Parakeet Auklet",
        "Rhinoceros Auklet",
        "Brewer Blackbird",
        "Red winged Blackbird",
        "Rusty Blackbird",
        "Yellow headed Blackbird",
        "Bobolink",
        "Indigo Bunting",
        "Lazuli Bunting",
        "Painted Bunting",
        "Cardinal",
        "Spotted Catbird",
        "Gray Catbird",
        "Yellow breasted Chat",
        "Eastern Towhee",
        "Chuck will Widow",
        "Brandt Cormorant",
        "Red faced Cormorant",
        "Pelagic Cormorant",
        "Bronzed Cowbird",
        "Shiny Cowbird",
        "Brown Creeper",
        "American Crow",
        "Fish Crow",
        "Black billed Cuckoo",
        "Mangrove Cuckoo",
        "Yellow billed Cuckoo",
        "Gray crowned Rosy Finch",
        "Purple Finch",
        "Northern Flicker",
        "Acadian Flycatcher",
        "Great Crested Flycatcher",
        "Least Flycatcher",
        "Olive sided Flycatcher",
        "Scissor tailed Flycatcher",
        "Vermilion Flycatcher",
        "Yellow bellied Flycatcher",
        "Frigatebird",
        "Northern Fulmar",
        "Gadwall",
        "American Goldfinch",
        "European Goldfinch",
        "Boat tailed Grackle",
        "Eared Grebe",
        "Horned Grebe",
        "Pied billed Grebe",
        "Western Grebe",
        "Blue Grosbeak",
        "Evening Grosbeak",
        "Pine Grosbeak",
        "Rose breasted Grosbeak",
        "Pigeon Guillemot",
        "California Gull",
        "Glaucous winged Gull",
        "Heermann Gull",
        "Herring Gull",
        "Ivory Gull",
        "Ring billed Gull",
        "Slaty backed Gull",
        "Western Gull",
        "Anna Hummingbird",
        "Ruby throated Hummingbird",
        "Rufous Hummingbird",
        "Green Violetear",
        "Long tailed Jaeger",
        "Pomarine Jaeger",
        "Blue Jay",
        "Florida Jay",
        "Green Jay",
        "Dark eyed Junco",
        "Tropical Kingbird",
        "Gray Kingbird",
        "Belted Kingfisher",
        "Green Kingfisher",
        "Pied Kingfisher",
        "Ringed Kingfisher",
        "White breasted Kingfisher",
        "Red legged Kittiwake",
        "Horned Lark",
        "Pacific Loon",
        "Mallard",
        "Western Meadowlark",
        "Hooded Merganser",
        "Red breasted Merganser",
        "Mockingbird",
        "Nighthawk",
        "Clark Nutcracker",
        "White breasted Nuthatch",
        "Baltimore Oriole",
        "Hooded Oriole",
        "Orchard Oriole",
        "Scott Oriole",
        "Ovenbird",
        "Brown Pelican",
        "White Pelican",
        "Western Wood Pewee",
        "Sayornis",
        "American Pipit",
        "Whip poor Will",
        "Horned Puffin",
        "Common Raven",
        "White necked Raven",
        "American Redstart",
        "Geococcyx",
        "Loggerhead Shrike",
        "Great Grey Shrike",
        "Baird Sparrow",
        "Black throated Sparrow",
        "Brewer Sparrow",
        "Chipping Sparrow",
        "Clay colored Sparrow",
        "House Sparrow",
        "Field Sparrow",
        "Fox Sparrow",
        "Grasshopper Sparrow",
        "Harris Sparrow",
        "Henslow Sparrow",
        "Le Conte Sparrow",
        "Lincoln Sparrow",
        "Nelson Sharp tailed Sparrow",
        "Savannah Sparrow",
        "Seaside Sparrow",
        "Song Sparrow",
        "Tree Sparrow",
        "Vesper Sparrow",
        "White crowned Sparrow",
        "White throated Sparrow",
        "Cape Glossy Starling",
        "Bank Swallow",
        "Barn Swallow",
        "Cliff Swallow",
        "Tree Swallow",
        "Scarlet Tanager",
        "Summer Tanager",
        "Artic Tern",
        "Black Tern",
        "Caspian Tern",
        "Common Tern",
        "Elegant Tern",
        "Forsters Tern",
        "Least Tern",
        "Green tailed Towhee",
        "Brown Thrasher",
        "Sage Thrasher",
        "Black capped Vireo",
        "Blue headed Vireo",
        "Philadelphia Vireo",
        "Red eyed Vireo",
        "Warbling Vireo",
        "White eyed Vireo",
        "Yellow throated Vireo",
        "Bay breasted Warbler",
        "Black and white Warbler",
        "Black throated Blue Warbler",
        "Blue winged Warbler",
        "Canada Warbler",
        "Cape May Warbler",
        "Cerulean Warbler",
        "Chestnut sided Warbler",
        "Golden winged Warbler",
        "Hooded Warbler",
        "Kentucky Warbler",
        "Magnolia Warbler",
        "Mourning Warbler",
        "Myrtle Warbler",
        "Nashville Warbler",
        "Orange crowned Warbler",
        "Palm Warbler",
        "Pine Warbler",
        "Prairie Warbler",
        "Prothonotary Warbler",
        "Swainson Warbler",
        "Tennessee Warbler",
        "Wilson Warbler",
        "Worm eating Warbler",
        "Yellow Warbler",
        "Northern Waterthrush",
        "Louisiana Waterthrush",
        "Bohemian Waxwing",
        "Cedar Waxwing",
        "American Three toed Woodpecker",
        "Pileated Woodpecker",
        "Red bellied Woodpecker",
        "Red cockaded Woodpecker",
        "Red headed Woodpecker",
        "Downy Woodpecker",
        "Bewick Wren",
        "Cactus Wren",
        "Carolina Wren",
        "House Wren",
        "Marsh Wren",
        "Rock Wren",
        "Winter Wren",
        "Common Yellowthroat",
    ],
    sun397=[
        "abbey",
        "airplane cabin",
        "airport terminal",
        "alley",
        "amphitheater",
        "amusement arcade",
        "amusement park",
        "anechoic chamber",
        "apartment building outdoor",
        "apse indoor",
        "aquarium",
        "aqueduct",
        "arch",
        "archive",
        "arrival gate outdoor",
        "art gallery",
        "art school",
        "art studio",
        "assembly line",
        "athletic field outdoor",
        "atrium public",
        "attic",
        "auditorium",
        "auto factory",
        "badlands",
        "badminton court indoor",
        "baggage claim",
        "bakery shop",
        "balcony exterior",
        "balcony interior",
        "ball pit",
        "ballroom",
        "bamboo forest",
        "banquet hall",
        "bar",
        "barn",
        "barndoor",
        "baseball field",
        "basement",
        "basilica",
        "basketball court outdoor",
        "bathroom",
        "batters box",
        "bayou",
        "bazaar indoor",
        "bazaar outdoor",
        "beach",
        "beauty salon",
        "bedroom",
        "berth",
        "biology laboratory",
        "bistro indoor",
        "boardwalk",
        "boat deck",
        "boathouse",
        "bookstore",
        "booth indoor",
        "botanical garden",
        "bow window indoor",
        "bow window outdoor",
        "bowling alley",
        "boxing ring",
        "brewery indoor",
        "bridge",
        "building facade",
        "bullring",
        "burial chamber",
        "bus interior",
        "butchers shop",
        "butte",
        "cabin outdoor",
        "cafeteria",
        "campsite",
        "campus",
        "canal natural",
        "canal urban",
        "candy store",
        "canyon",
        "car interior backseat",
        "car interior frontseat",
        "carrousel",
        "casino indoor",
        "castle",
        "catacomb",
        "cathedral indoor",
        "cathedral outdoor",
        "cavern indoor",
        "cemetery",
        "chalet",
        "cheese factory",
        "chemistry lab",
        "chicken coop indoor",
        "chicken coop outdoor",
        "childs room",
        "church indoor",
        "church outdoor",
        "classroom",
        "clean room",
        "cliff",
        "cloister indoor",
        "closet",
        "clothing store",
        "coast",
        "cockpit",
        "coffee shop",
        "computer room",
        "conference center",
        "conference room",
        "construction site",
        "control room",
        "control tower outdoor",
        "corn field",
        "corral",
        "corridor",
        "cottage garden",
        "courthouse",
        "courtroom",
        "courtyard",
        "covered bridge exterior",
        "creek",
        "crevasse",
        "crosswalk",
        "cubicle office",
        "dam",
        "delicatessen",
        "dentists office",
        "desert sand",
        "desert vegetation",
        "diner indoor",
        "diner outdoor",
        "dinette home",
        "dinette vehicle",
        "dining car",
        "dining room",
        "discotheque",
        "dock",
        "doorway outdoor",
        "dorm room",
        "driveway",
        "driving range outdoor",
        "drugstore",
        "electrical substation",
        "elevator door",
        "elevator interior",
        "elevator shaft",
        "engine room",
        "escalator indoor",
        "excavation",
        "factory indoor",
        "fairway",
        "fastfood restaurant",
        "field cultivated",
        "field wild",
        "fire escape",
        "fire station",
        "firing range indoor",
        "fishpond",
        "florist shop indoor",
        "food court",
        "forest broadleaf",
        "forest needleleaf",
        "forest path",
        "forest road",
        "formal garden",
        "fountain",
        "galley",
        "game room",
        "garage indoor",
        "garbage dump",
        "gas station",
        "gazebo exterior",
        "general store indoor",
        "general store outdoor",
        "gift shop",
        "golf course",
        "greenhouse indoor",
        "greenhouse outdoor",
        "gymnasium indoor",
        "hangar indoor",
        "hangar outdoor",
        "harbor",
        "hayfield",
        "heliport",
        "herb garden",
        "highway",
        "hill",
        "home office",
        "hospital",
        "hospital room",
        "hot spring",
        "hot tub outdoor",
        "hotel outdoor",
        "hotel room",
        "house",
        "hunting lodge outdoor",
        "ice cream parlor",
        "ice floe",
        "ice shelf",
        "ice skating rink indoor",
        "ice skating rink outdoor",
        "iceberg",
        "igloo",
        "industrial area",
        "inn outdoor",
        "islet",
        "jacuzzi indoor",
        "jail cell",
        "jail indoor",
        "jewelry shop",
        "kasbah",
        "kennel indoor",
        "kennel outdoor",
        "kindergarden classroom",
        "kitchen",
        "kitchenette",
        "labyrinth outdoor",
        "lake natural",
        "landfill",
        "landing deck",
        "laundromat",
        "lecture room",
        "library indoor",
        "library outdoor",
        "lido deck outdoor",
        "lift bridge",
        "lighthouse",
        "limousine interior",
        "living room",
        "lobby",
        "lock chamber",
        "locker room",
        "mansion",
        "manufactured home",
        "market indoor",
        "market outdoor",
        "marsh",
        "martial arts gym",
        "mausoleum",
        "medina",
        "moat water",
        "monastery outdoor",
        "mosque indoor",
        "mosque outdoor",
        "motel",
        "mountain",
        "mountain snowy",
        "movie theater indoor",
        "museum indoor",
        "music store",
        "music studio",
        "nuclear power plant outdoor",
        "nursery",
        "oast house",
        "observatory outdoor",
        "ocean",
        "office",
        "office building",
        "oil refinery outdoor",
        "oilrig",
        "operating room",
        "orchard",
        "outhouse outdoor",
        "pagoda",
        "palace",
        "pantry",
        "park",
        "parking garage indoor",
        "parking garage outdoor",
        "parking lot",
        "parlor",
        "pasture",
        "patio",
        "pavilion",
        "pharmacy",
        "phone booth",
        "physics laboratory",
        "picnic area",
        "pilothouse indoor",
        "planetarium outdoor",
        "playground",
        "playroom",
        "plaza",
        "podium indoor",
        "podium outdoor",
        "pond",
        "poolroom establishment",
        "poolroom home",
        "power plant outdoor",
        "promenade deck",
        "pub indoor",
        "pulpit",
        "putting green",
        "racecourse",
        "raceway",
        "raft",
        "railroad track",
        "rainforest",
        "reception",
        "recreation room",
        "residential neighborhood",
        "restaurant",
        "restaurant kitchen",
        "restaurant patio",
        "rice paddy",
        "riding arena",
        "river",
        "rock arch",
        "rope bridge",
        "ruin",
        "runway",
        "sandbar",
        "sandbox",
        "sauna",
        "schoolhouse",
        "sea cliff",
        "server room",
        "shed",
        "shoe shop",
        "shopfront",
        "shopping mall indoor",
        "shower",
        "skatepark",
        "ski lodge",
        "ski resort",
        "ski slope",
        "sky",
        "skyscraper",
        "slum",
        "snowfield",
        "squash court",
        "stable",
        "stadium baseball",
        "stadium football",
        "stage indoor",
        "staircase",
        "street",
        "subway interior",
        "subway station platform",
        "supermarket",
        "sushi bar",
        "swamp",
        "swimming pool indoor",
        "swimming pool outdoor",
        "synagogue indoor",
        "synagogue outdoor",
        "television studio",
        "temple east asia",
        "temple south asia",
        "tennis court indoor",
        "tennis court outdoor",
        "tent outdoor",
        "theater indoor procenium",
        "theater indoor seats",
        "thriftshop",
        "throne room",
        "ticket booth",
        "toll plaza",
        "topiary garden",
        "tower",
        "toyshop",
        "track outdoor",
        "train railway",
        "train station platform",
        "tree farm",
        "tree house",
        "trench",
        "underwater coral reef",
        "utility room",
        "valley",
        "van interior",
        "vegetable garden",
        "veranda",
        "veterinarians office",
        "viaduct",
        "videostore",
        "village",
        "vineyard",
        "volcano",
        "volleyball court indoor",
        "volleyball court outdoor",
        "waiting room",
        "warehouse indoor",
        "water tower",
        "waterfall block",
        "waterfall fan",
        "waterfall plunge",
        "watering hole",
        "wave",
        "wet bar",
        "wheat field",
        "wind farm",
        "windmill",
        "wine cellar barrel storage",
        "wine cellar bottle storage",
        "wrestling ring indoor",
        "yard",
        "youth hostel",
    ],
    cars=[
        "AM General Hummer SUV 2000",
        "Acura RL Sedan 2012",
        "Acura TL Sedan 2012",
        "Acura TL Type-S 2008",
        "Acura TSX Sedan 2012",
        "Acura Integra Type R 2001",
        "Acura ZDX Hatchback 2012",
        "Aston Martin V8 Vantage Convertible 2012",
        "Aston Martin V8 Vantage Coupe 2012",
        "Aston Martin Virage Convertible 2012",
        "Aston Martin Virage Coupe 2012",
        "Audi RS 4 Convertible 2008",
        "Audi A5 Coupe 2012",
        "Audi TTS Coupe 2012",
        "Audi R8 Coupe 2012",
        "Audi V8 Sedan 1994",
        "Audi 100 Sedan 1994",
        "Audi 100 Wagon 1994",
        "Audi TT Hatchback 2011",
        "Audi S6 Sedan 2011",
        "Audi S5 Convertible 2012",
        "Audi S5 Coupe 2012",
        "Audi S4 Sedan 2012",
        "Audi S4 Sedan 2007",
        "Audi TT RS Coupe 2012",
        "BMW ActiveHybrid 5 Sedan 2012",
        "BMW 1 Series Convertible 2012",
        "BMW 1 Series Coupe 2012",
        "BMW 3 Series Sedan 2012",
        "BMW 3 Series Wagon 2012",
        "BMW 6 Series Convertible 2007",
        "BMW X5 SUV 2007",
        "BMW X6 SUV 2012",
        "BMW M3 Coupe 2012",
        "BMW M5 Sedan 2010",
        "BMW M6 Convertible 2010",
        "BMW X3 SUV 2012",
        "BMW Z4 Convertible 2012",
        "Bentley Continental Supersports Conv. Convertible 2012",
        "Bentley Arnage Sedan 2009",
        "Bentley Mulsanne Sedan 2011",
        "Bentley Continental GT Coupe 2012",
        "Bentley Continental GT Coupe 2007",
        "Bentley Continental Flying Spur Sedan 2007",
        "Bugatti Veyron 16.4 Convertible 2009",
        "Bugatti Veyron 16.4 Coupe 2009",
        "Buick Regal GS 2012",
        "Buick Rainier SUV 2007",
        "Buick Verano Sedan 2012",
        "Buick Enclave SUV 2012",
        "Cadillac CTS-V Sedan 2012",
        "Cadillac SRX SUV 2012",
        "Cadillac Escalade EXT Crew Cab 2007",
        "Chevrolet Silverado 1500 Hybrid Crew Cab 2012",
        "Chevrolet Corvette Convertible 2012",
        "Chevrolet Corvette ZR1 2012",
        "Chevrolet Corvette Ron Fellows Edition Z06 2007",
        "Chevrolet Traverse SUV 2012",
        "Chevrolet Camaro Convertible 2012",
        "Chevrolet HHR SS 2010",
        "Chevrolet Impala Sedan 2007",
        "Chevrolet Tahoe Hybrid SUV 2012",
        "Chevrolet Sonic Sedan 2012",
        "Chevrolet Express Cargo Van 2007",
        "Chevrolet Avalanche Crew Cab 2012",
        "Chevrolet Cobalt SS 2010",
        "Chevrolet Malibu Hybrid Sedan 2010",
        "Chevrolet TrailBlazer SS 2009",
        "Chevrolet Silverado 2500HD Regular Cab 2012",
        "Chevrolet Silverado 1500 Classic Extended Cab 2007",
        "Chevrolet Express Van 2007",
        "Chevrolet Monte Carlo Coupe 2007",
        "Chevrolet Malibu Sedan 2007",
        "Chevrolet Silverado 1500 Extended Cab 2012",
        "Chevrolet Silverado 1500 Regular Cab 2012",
        "Chrysler Aspen SUV 2009",
        "Chrysler Sebring Convertible 2010",
        "Chrysler Town and Country Minivan 2012",
        "Chrysler 300 SRT-8 2010",
        "Chrysler Crossfire Convertible 2008",
        "Chrysler PT Cruiser Convertible 2008",
        "Daewoo Nubira Wagon 2002",
        "Dodge Caliber Wagon 2012",
        "Dodge Caliber Wagon 2007",
        "Dodge Caravan Minivan 1997",
        "Dodge Ram Pickup 3500 Crew Cab 2010",
        "Dodge Ram Pickup 3500 Quad Cab 2009",
        "Dodge Sprinter Cargo Van 2009",
        "Dodge Journey SUV 2012",
        "Dodge Dakota Crew Cab 2010",
        "Dodge Dakota Club Cab 2007",
        "Dodge Magnum Wagon 2008",
        "Dodge Challenger SRT8 2011",
        "Dodge Durango SUV 2012",
        "Dodge Durango SUV 2007",
        "Dodge Charger Sedan 2012",
        "Dodge Charger SRT-8 2009",
        "Eagle Talon Hatchback 1998",
        "FIAT 500 Abarth 2012",
        "FIAT 500 Convertible 2012",
        "Ferrari FF Coupe 2012",
        "Ferrari California Convertible 2012",
        "Ferrari 458 Italia Convertible 2012",
        "Ferrari 458 Italia Coupe 2012",
        "Fisker Karma Sedan 2012",
        "Ford F-450 Super Duty Crew Cab 2012",
        "Ford Mustang Convertible 2007",
        "Ford Freestar Minivan 2007",
        "Ford Expedition EL SUV 2009",
        "Ford Edge SUV 2012",
        "Ford Ranger SuperCab 2011",
        "Ford GT Coupe 2006",
        "Ford F-150 Regular Cab 2012",
        "Ford F-150 Regular Cab 2007",
        "Ford Focus Sedan 2007",
        "Ford E-Series Wagon Van 2012",
        "Ford Fiesta Sedan 2012",
        "GMC Terrain SUV 2012",
        "GMC Savana Van 2012",
        "GMC Yukon Hybrid SUV 2012",
        "GMC Acadia SUV 2012",
        "GMC Canyon Extended Cab 2012",
        "Geo Metro Convertible 1993",
        "HUMMER H3T Crew Cab 2010",
        "HUMMER H2 SUT Crew Cab 2009",
        "Honda Odyssey Minivan 2012",
        "Honda Odyssey Minivan 2007",
        "Honda Accord Coupe 2012",
        "Honda Accord Sedan 2012",
        "Hyundai Veloster Hatchback 2012",
        "Hyundai Santa Fe SUV 2012",
        "Hyundai Tucson SUV 2012",
        "Hyundai Veracruz SUV 2012",
        "Hyundai Sonata Hybrid Sedan 2012",
        "Hyundai Elantra Sedan 2007",
        "Hyundai Accent Sedan 2012",
        "Hyundai Genesis Sedan 2012",
        "Hyundai Sonata Sedan 2012",
        "Hyundai Elantra Touring Hatchback 2012",
        "Hyundai Azera Sedan 2012",
        "Infiniti G Coupe IPL 2012",
        "Infiniti QX56 SUV 2011",
        "Isuzu Ascender SUV 2008",
        "Jaguar XK XKR 2012",
        "Jeep Patriot SUV 2012",
        "Jeep Wrangler SUV 2012",
        "Jeep Liberty SUV 2012",
        "Jeep Grand Cherokee SUV 2012",
        "Jeep Compass SUV 2012",
        "Lamborghini Reventon Coupe 2008",
        "Lamborghini Aventador Coupe 2012",
        "Lamborghini Gallardo LP 570-4 Superleggera 2012",
        "Lamborghini Diablo Coupe 2001",
        "Land Rover Range Rover SUV 2012",
        "Land Rover LR2 SUV 2012",
        "Lincoln Town Car Sedan 2011",
        "MINI Cooper Roadster Convertible 2012",
        "Maybach Landaulet Convertible 2012",
        "Mazda Tribute SUV 2011",
        "McLaren MP4-12C Coupe 2012",
        "Mercedes-Benz 300-Class Convertible 1993",
        "Mercedes-Benz C-Class Sedan 2012",
        "Mercedes-Benz SL-Class Coupe 2009",
        "Mercedes-Benz E-Class Sedan 2012",
        "Mercedes-Benz S-Class Sedan 2012",
        "Mercedes-Benz Sprinter Van 2012",
        "Mitsubishi Lancer Sedan 2012",
        "Nissan Leaf Hatchback 2012",
        "Nissan NV Passenger Van 2012",
        "Nissan Juke Hatchback 2012",
        "Nissan 240SX Coupe 1998",
        "Plymouth Neon Coupe 1999",
        "Porsche Panamera Sedan 2012",
        "Ram C/V Cargo Van Minivan 2012",
        "Rolls-Royce Phantom Drophead Coupe Convertible 2012",
        "Rolls-Royce Ghost Sedan 2012",
        "Rolls-Royce Phantom Sedan 2012",
        "Scion xD Hatchback 2012",
        "Spyker C8 Convertible 2009",
        "Spyker C8 Coupe 2009",
        "Suzuki Aerio Sedan 2007",
        "Suzuki Kizashi Sedan 2012",
        "Suzuki SX4 Hatchback 2012",
        "Suzuki SX4 Sedan 2012",
        "Tesla Model S Sedan 2012",
        "Toyota Sequoia SUV 2012",
        "Toyota Camry Sedan 2012",
        "Toyota Corolla Sedan 2012",
        "Toyota 4Runner SUV 2012",
        "Volkswagen Golf Hatchback 2012",
        "Volkswagen Golf Hatchback 1991",
        "Volkswagen Beetle Hatchback 2012",
        "Volvo C30 Hatchback 2012",
        "Volvo 240 Sedan 1993",
        "Volvo XC90 SUV 2007",
        "smart fortwo Convertible 2012",
    ],
    aircraft=[
        "707-320",
        "727-200",
        "737-200",
        "737-300",
        "737-400",
        "737-500",
        "737-600",
        "737-700",
        "737-800",
        "737-900",
        "747-100",
        "747-200",
        "747-300",
        "747-400",
        "757-200",
        "757-300",
        "767-200",
        "767-300",
        "767-400",
        "777-200",
        "777-300",
        "A300B4",
        "A310",
        "A318",
        "A319",
        "A320",
        "A321",
        "A330-200",
        "A330-300",
        "A340-200",
        "A340-300",
        "A340-500",
        "A340-600",
        "A380",
        "ATR-42",
        "ATR-72",
        "An-12",
        "BAE 146-200",
        "BAE 146-300",
        "BAE-125",
        "Beechcraft 1900",
        "Boeing 717",
        "C-130",
        "C-47",
        "CRJ-200",
        "CRJ-700",
        "CRJ-900",
        "Cessna 172",
        "Cessna 208",
        "Cessna 525",
        "Cessna 560",
        "Challenger 600",
        "DC-10",
        "DC-3",
        "DC-6",
        "DC-8",
        "DC-9-30",
        "DH-82",
        "DHC-1",
        "DHC-6",
        "DHC-8-100",
        "DHC-8-300",
        "DR-400",
        "Dornier 328",
        "E-170",
        "E-190",
        "E-195",
        "EMB-120",
        "ERJ 135",
        "ERJ 145",
        "Embraer Legacy 600",
        "Eurofighter Typhoon",
        "F-16A/B",
        "F/A-18",
        "Falcon 2000",
        "Falcon 900",
        "Fokker 100",
        "Fokker 50",
        "Fokker 70",
        "Global Express",
        "Gulfstream IV",
        "Gulfstream V",
        "Hawk T1",
        "Il-76",
        "L-1011",
        "MD-11",
        "MD-80",
        "MD-87",
        "MD-90",
        "Metroliner",
        "Model B200",
        "PA-28",
        "SR-20",
        "Saab 2000",
        "Saab 340",
        "Spitfire",
        "Tornado",
        "Tu-134",
        "Tu-154",
        "Yak-42",
    ],
    dtd=[
        "banded",
        "blotchy",
        "braided",
        "bubbly",
        "bumpy",
        "chequered",
        "cobwebbed",
        "cracked",
        "crosshatched",
        "crystalline",
        "dotted",
        "fibrous",
        "flecked",
        "freckled",
        "frilly",
        "gauzy",
        "grid",
        "grooved",
        "honeycombed",
        "interlaced",
        "knitted",
        "lacelike",
        "lined",
        "marbled",
        "matted",
        "meshed",
        "paisley",
        "perforated",
        "pitted",
        "pleated",
        "polka-dotted",
        "porous",
        "potholed",
        "scaly",
        "smeared",
        "spiralled",
        "sprinkled",
        "stained",
        "stratified",
        "striped",
        "studded",
        "swirly",
        "veined",
        "waffled",
        "woven",
        "wrinkled",
        "zigzagged",
    ],
    pets=[
        "abyssinian",
        "american bulldog",
        "american pit bull terrier",
        "basset hound",
        "beagle",
        "bengal",
        "birman",
        "bombay",
        "boxer",
        "british shorthair",
        "chihuahua",
        "egyptian mau",
        "english cocker spaniel",
        "english setter",
        "german shorthaired",
        "great pyrenees",
        "havanese",
        "japanese chin",
        "keeshond",
        "leonberger",
        "maine coon",
        "miniature pinscher",
        "newfoundland",
        "persian",
        "pomeranian",
        "pug",
        "ragdoll",
        "russian blue",
        "saint bernard",
        "samoyed",
        "scottish terrier",
        "shiba inu",
        "siamese",
        "sphynx",
        "staffordshire bull terrier",
        "wheaten terrier",
        "yorkshire terrier",
    ],
    caltech101=[
        "accordion",
        "airplane",
        "anchor",
        "ant",
        "background",
        "barrel",
        "bass",
        "beaver",
        "binocular",
        "bonsai",
        "brain",
        "brontosaurus",
        "buddha",
        "butterfly",
        "camera",
        "cannon",
        "side of a car",
        "ceiling fan",
        "cellphone",
        "chair",
        "chandelier",
        "body of a cougar cat",
        "face of a cougar cat",
        "crab",
        "crayfish",
        "crocodile",
        "head of a crocodile",
        "cup",
        "dalmatian",
        "dollar bill",
        "dolphin",
        "dragonfly",
        "electric guitar",
        "elephant",
        "emu",
        "euphonium",
        "ewer",
        "off-center face",
        "centered face",
        "ferry",
        "flamingo",
        "head of a flamingo",
        "garfield",
        "gerenuk",
        "gramophone",
        "grand piano",
        "hawksbill",
        "headphone",
        "hedgehog",
        "helicopter",
        "ibis",
        "inline skate",
        "joshua tree",
        "kangaroo",
        "ketch",
        "lamp",
        "laptop",
        "leopard",
        "llama",
        "lobster",
        "lotus",
        "mandolin",
        "mayfly",
        "menorah",
        "metronome",
        "minaret",
        "motorbike",
        "nautilus",
        "octopus",
        "okapi",
        "pagoda",
        "panda",
        "pigeon",
        "pizza",
        "platypus",
        "pyramid",
        "revolver",
        "rhino",
        "rooster",
        "saxophone",
        "schooner",
        "scissors",
        "scorpion",
        "sea horse",
        "snoopy (cartoon beagle)",
        "soccer ball",
        "stapler",
        "starfish",
        "stegosaurus",
        "stop sign",
        "strawberry",
        "sunflower",
        "tick",
        "trilobite",
        "umbrella",
        "watch",
        "water lilly",
        "wheelchair",
        "wild cat",
        "windsor chair",
        "wrench",
        "yin and yang symbol",
    ],
    flowers102=[
        "pink primrose",
        "hard-leaved pocket orchid",
        "canterbury bells",
        "sweet pea",
        "english marigold",
        "tiger lily",
        "moon orchid",
        "bird of paradise",
        "monkshood",
        "globe thistle",
        "snapdragon",
        "colt's foot",
        "king protea",
        "spear thistle",
        "yellow iris",
        "globe flower",
        "purple coneflower",
        "peruvian lily",
        "balloon flower",
        "giant white arum lily",
        "fire lily",
        "pincushion flower",
        "fritillary",
        "red ginger",
        "grape hyacinth",
        "corn poppy",
        "prince of wales feathers",
        "stemless gentian",
        "artichoke",
        "sweet william",
        "carnation",
        "garden phlox",
        "love in the mist",
        "mexican aster",
        "alpine sea holly",
        "ruby-lipped cattleya",
        "cape flower",
        "great masterwort",
        "siam tulip",
        "lenten rose",
        "barbeton daisy",
        "daffodil",
        "sword lily",
        "poinsettia",
        "bolero deep blue",
        "wallflower",
        "marigold",
        "buttercup",
        "oxeye daisy",
        "common dandelion",
        "petunia",
        "wild pansy",
        "primula",
        "sunflower",
        "pelargonium",
        "bishop of llandaff",
        "gaura",
        "geranium",
        "orange dahlia",
        "pink and yellow dahlia",
        "cautleya spicata",
        "japanese anemone",
        "black-eyed susan",
        "silverbush",
        "californian poppy",
        "osteospermum",
        "spring crocus",
        "bearded iris",
        "windflower",
        "tree poppy",
        "gazania",
        "azalea",
        "water lily",
        "rose",
        "thorn apple",
        "morning glory",
        "passion flower",
        "lotus",
        "toad lily",
        "anthurium",
        "frangipani",
        "clematis",
        "hibiscus",
        "columbine",
        "desert-rose",
        "tree mallow",
        "magnolia",
        "cyclamen",
        "watercress",
        "canna lily",
        "hippeastrum",
        "bee balm",
        "air plant",
        "foxglove",
        "bougainvillea",
        "camellia",
        "mallow",
        "mexican petunia",
        "bromelia",
        "blanket flower",
        "trumpet creeper",
        "blackberry lily",
    ],
    stl10=[
        "airplane",
        "bird",
        "car",
        "cat",
        "deer",
        "dog",
        "horse",
        "monkey",
        "ship",
        "truck",
    ],
    eurosat=[
        "annual crop land",
        "forest",
        "brushland or shrubland",
        "highway or road",
        "industrial buildings or commercial buildings",
        "pasture land",
        "permanent crop land",
        "residential buildings or homes or apartments",
        "river",
        "lake or sea",
    ],
    resisc45=[
        "airplane",
        "airport",
        "baseball diamond",
        "basketball court",
        "beach",
        "bridge",
        "chaparral",
        "church",
        "circular farmland",
        "cloud",
        "commercial area",
        "dense residential",
        "desert",
        "forest",
        "freeway",
        "golf course",
        "ground track field",
        "harbor",
        "industrial area",
        "intersection",
        "island",
        "lake",
        "meadow",
        "medium residential",
        "mobile home park",
        "mountain",
        "overpass",
        "palace",
        "parking lot",
        "railway",
        "railway station",
        "rectangular farmland",
        "river",
        "roundabout",
        "runway",
        "sea ice",
        "ship",
        "snowberg",
        "sparse residential",
        "stadium",
        "storage tank",
        "tennis court",
        "terrace",
        "thermal power station",
        "wetland",
    ],
    mnist=[
        "0",
        "1",
        "2",
        "3",
        "4",
        "5",
        "6",
        "7",
        "8",
        "9",
    ],
    pcam=[
        "lymph node",
        "lymph node containing metastatic tumor tissue",
    ],
    clevr=[
        "10",
        "3",
        "4",
        "5",
        "6",
        "7",
        "8",
        "9",
    ],
    country211=[
        "Andorra",
        "United Arab Emirates",
        "Afghanistan",
        "Antigua and Barbuda",
        "Anguilla",
        "Albania",
        "Armenia",
        "Angola",
        "Antarctica",
        "Argentina",
        "Austria",
        "Australia",
        "Aruba",
        "Aland Islands",
        "Azerbaijan",
        "Bosnia and Herzegovina",
        "Barbados",
        "Bangladesh",
        "Belgium",
        "Burkina Faso",
        "Bulgaria",
        "Bahrain",
        "Benin",
        "Bermuda",
        "Brunei Darussalam",
        "Bolivia",
        "Bonaire, Saint Eustatius and Saba",
        "Brazil",
        "Bahamas",
        "Bhutan",
        "Botswana",
        "Belarus",
        "Belize",
        "Canada",
        "DR Congo",
        "Central African Republic",
        "Switzerland",
        "Cote d'Ivoire",
        "Cook Islands",
        "Chile",
        "Cameroon",
        "China",
        "Colombia",
        "Costa Rica",
        "Cuba",
        "Cabo Verde",
        "Curacao",
        "Cyprus",
        "Czech Republic",
        "Germany",
        "Denmark",
        "Dominica",
        "Dominican Republic",
        "Algeria",
        "Ecuador",
        "Estonia",
        "Egypt",
        "Spain",
        "Ethiopia",
        "Finland",
        "Fiji",
        "Falkland Islands",
        "Faeroe Islands",
        "France",
        "Gabon",
        "United Kingdom",
        "Grenada",
        "Georgia",
        "French Guiana",
        "Guernsey",
        "Ghana",
        "Gibraltar",
        "Greenland",
        "Gambia",
        "Guadeloupe",
        "Greece",
        "South Georgia and South Sandwich Is.",
        "Guatemala",
        "Guam",
        "Guyana",
        "Hong Kong",
        "Honduras",
        "Croatia",
        "Haiti",
        "Hungary",
        "Indonesia",
        "Ireland",
        "Israel",
        "Isle of Man",
        "India",
        "Iraq",
        "Iran",
        "Iceland",
        "Italy",
        "Jersey",
        "Jamaica",
        "Jordan",
        "Japan",
        "Kenya",
        "Kyrgyz Republic",
        "Cambodia",
        "St. Kitts and Nevis",
        "North Korea",
        "South Korea",
        "Kuwait",
        "Cayman Islands",
        "Kazakhstan",
        "Laos",
        "Lebanon",
        "St. Lucia",
        "Liechtenstein",
        "Sri Lanka",
        "Liberia",
        "Lithuania",
        "Luxembourg",
        "Latvia",
        "Libya",
        "Morocco",
        "Monaco",
        "Moldova",
        "Montenegro",
        "Saint-Martin",
        "Madagascar",
        "Macedonia",
        "Mali",
        "Myanmar",
        "Mongolia",
        "Macau",
        "Martinique",
        "Mauritania",
        "Malta",
        "Mauritius",
        "Maldives",
        "Malawi",
        "Mexico",
        "Malaysia",
        "Mozambique",
        "Namibia",
        "New Caledonia",
        "Nigeria",
        "Nicaragua",
        "Netherlands",
        "Norway",
        "Nepal",
        "New Zealand",
        "Oman",
        "Panama",
        "Peru",
        "French Polynesia",
        "Papua New Guinea",
        "Philippines",
        "Pakistan",
        "Poland",
        "Puerto Rico",
        "Palestine",
        "Portugal",
        "Palau",
        "Paraguay",
        "Qatar",
        "Reunion",
        "Romania",
        "Serbia",
        "Russia",
        "Rwanda",
        "Saudi Arabia",
        "Solomon Islands",
        "Seychelles",
        "Sudan",
        "Sweden",
        "Singapore",
        "St. Helena",
        "Slovenia",
        "Svalbard and Jan Mayen Islands",
        "Slovakia",
        "Sierra Leone",
        "San Marino",
        "Senegal",
        "Somalia",
        "South Sudan",
        "El Salvador",
        "Sint Maarten",
        "Syria",
        "Eswatini",
        "Togo",
        "Thailand",
        "Tajikistan",
        "Timor-Leste",
        "Turkmenistan",
        "Tunisia",
        "Tonga",
        "Turkey",
        "Trinidad and Tobago",
        "Taiwan",
        "Tanzania",
        "Ukraine",
        "Uganda",
        "United States",
        "Uruguay",
        "Uzbekistan",
        "Vatican",
        "Venezuela",
        "British Virgin Islands",
        "United States Virgin Islands",
        "Vietnam",
        "Vanuatu",
        "Samoa",
        "Kosovo",
        "Yemen",
        "South Africa",
        "Zambia",
        "Zimbabwe",
    ],
    sst2=[
        "negative",
        "positive",
    ],
    imagenet=[
        "tench",
        "goldfish",
        "great white shark",
        "tiger shark",
        "hammerhead shark",
        "electric ray",
        "stingray",
        "rooster",
        "hen",
        "ostrich",
        "brambling",
        "goldfinch",
        "house finch",
        "junco",
        "indigo bunting",
        "American robin",
        "bulbul",
        "jay",
        "magpie",
        "chickadee",
        "American dipper",
        "kite (bird of prey)",
        "bald eagle",
        "vulture",
        "great grey owl",
        "fire salamander",
        "smooth newt",
        "newt",
        "spotted salamander",
        "axolotl",
        "American bullfrog",
        "tree frog",
        "tailed frog",
        "loggerhead sea turtle",
        "leatherback sea turtle",
        "mud turtle",
        "terrapin",
        "box turtle",
        "banded gecko",
        "green iguana",
        "Carolina anole",
        "desert grassland whiptail lizard",
        "agama",
        "frilled-necked lizard",
        "alligator lizard",
        "Gila monster",
        "European green lizard",
        "chameleon",
        "Komodo dragon",
        "Nile crocodile",
        "American alligator",
        "triceratops",
        "worm snake",
        "ring-necked snake",
        "eastern hog-nosed snake",
        "smooth green snake",
        "kingsnake",
        "garter snake",
        "water snake",
        "vine snake",
        "night snake",
        "boa constrictor",
        "African rock python",
        "Indian cobra",
        "green mamba",
        "sea snake",
        "Saharan horned viper",
        "eastern diamondback rattlesnake",
        "sidewinder rattlesnake",
        "trilobite",
        "harvestman",
        "scorpion",
        "yellow garden spider",
        "barn spider",
        "European garden spider",
        "southern black widow",
        "tarantula",
        "wolf spider",
        "tick",
        "centipede",
        "black grouse",
        "ptarmigan",
        "ruffed grouse",
        "prairie grouse",
        "peafowl",
        "quail",
        "partridge",
        "african grey parrot",
        "macaw",
        "sulphur-crested cockatoo",
        "lorikeet",
        "coucal",
        "bee eater",
        "hornbill",
        "hummingbird",
        "jacamar",
        "toucan",
        "duck",
        "red-breasted merganser",
        "goose",
        "black swan",
        "tusker",
        "echidna",
        "platypus",
        "wallaby",
        "koala",
        "wombat",
        "jellyfish",
        "sea anemone",
        "brain coral",
        "flatworm",
        "nematode",
        "conch",
        "snail",
        "slug",
        "sea slug",
        "chiton",
        "chambered nautilus",
        "Dungeness crab",
        "rock crab",
        "fiddler crab",
        "red king crab",
        "American lobster",
        "spiny lobster",
        "crayfish",
        "hermit crab",
        "isopod",
        "white stork",
        "black stork",
        "spoonbill",
        "flamingo",
        "little blue heron",
        "great egret",
        "bittern bird",
        "crane bird",
        "limpkin",
        "common gallinule",
        "American coot",
        "bustard",
        "ruddy turnstone",
        "dunlin",
        "common redshank",
        "dowitcher",
        "oystercatcher",
        "pelican",
        "king penguin",
        "albatross",
        "grey whale",
        "killer whale",
        "dugong",
        "sea lion",
        "Chihuahua",
        "Japanese Chin",
        "Maltese",
        "Pekingese",
        "Shih Tzu",
        "King Charles Spaniel",
        "Papillon",
        "toy terrier",
        "Rhodesian Ridgeback",
        "Afghan Hound",
        "Basset Hound",
        "Beagle",
        "Bloodhound",
        "Bluetick Coonhound",
        "Black and Tan Coonhound",
        "Treeing Walker Coonhound",
        "English foxhound",
        "Redbone Coonhound",
        "borzoi",
        "Irish Wolfhound",
        "Italian Greyhound",
        "Whippet",
        "Ibizan Hound",
        "Norwegian Elkhound",
        "Otterhound",
        "Saluki",
        "Scottish Deerhound",
        "Weimaraner",
        "Staffordshire Bull Terrier",
        "American Staffordshire Terrier",
        "Bedlington Terrier",
        "Border Terrier",
        "Kerry Blue Terrier",
        "Irish Terrier",
        "Norfolk Terrier",
        "Norwich Terrier",
        "Yorkshire Terrier",
        "Wire Fox Terrier",
        "Lakeland Terrier",
        "Sealyham Terrier",
        "Airedale Terrier",
        "Cairn Terrier",
        "Australian Terrier",
        "Dandie Dinmont Terrier",
        "Boston Terrier",
        "Miniature Schnauzer",
        "Giant Schnauzer",
        "Standard Schnauzer",
        "Scottish Terrier",
        "Tibetan Terrier",
        "Australian Silky Terrier",
        "Soft-coated Wheaten Terrier",
        "West Highland White Terrier",
        "Lhasa Apso",
        "Flat-Coated Retriever",
        "Curly-coated Retriever",
        "Golden Retriever",
        "Labrador Retriever",
        "Chesapeake Bay Retriever",
        "German Shorthaired Pointer",
        "Vizsla",
        "English Setter",
        "Irish Setter",
        "Gordon Setter",
        "Brittany dog",
        "Clumber Spaniel",
        "English Springer Spaniel",
        "Welsh Springer Spaniel",
        "Cocker Spaniel",
        "Sussex Spaniel",
        "Irish Water Spaniel",
        "Kuvasz",
        "Schipperke",
        "Groenendael dog",
        "Malinois",
        "Briard",
        "Australian Kelpie",
        "Komondor",
        "Old English Sheepdog",
        "Shetland Sheepdog",
        "collie",
        "Border Collie",
        "Bouvier des Flandres dog",
        "Rottweiler",
        "German Shepherd Dog",
        "Dobermann",
        "Miniature Pinscher",
        "Greater Swiss Mountain Dog",
        "Bernese Mountain Dog",
        "Appenzeller Sennenhund",
        "Entlebucher Sennenhund",
        "Boxer",
        "Bullmastiff",
        "Tibetan Mastiff",
        "French Bulldog",
        "Great Dane",
        "St. Bernard",
        "husky",
        "Alaskan Malamute",
        "Siberian Husky",
        "Dalmatian",
        "Affenpinscher",
        "Basenji",
        "pug",
        "Leonberger",
        "Newfoundland dog",
        "Great Pyrenees dog",
        "Samoyed",
        "Pomeranian",
        "Chow Chow",
        "Keeshond",
        "brussels griffon",
        "Pembroke Welsh Corgi",
        "Cardigan Welsh Corgi",
        "Toy Poodle",
        "Miniature Poodle",
        "Standard Poodle",
        "Mexican hairless dog (xoloitzcuintli)",
        "grey wolf",
        "Alaskan tundra wolf",
        "red wolf or maned wolf",
        "coyote",
        "dingo",
        "dhole",
        "African wild dog",
        "hyena",
        "red fox",
        "kit fox",
        "Arctic fox",
        "grey fox",
        "tabby cat",
        "tiger cat",
        "Persian cat",
        "Siamese cat",
        "Egyptian Mau",
        "cougar",
        "lynx",
        "leopard",
        "snow leopard",
        "jaguar",
        "lion",
        "tiger",
        "cheetah",
        "brown bear",
        "American black bear",
        "polar bear",
        "sloth bear",
        "mongoose",
        "meerkat",
        "tiger beetle",
        "ladybug",
        "ground beetle",
        "longhorn beetle",
        "leaf beetle",
        "dung beetle",
        "rhinoceros beetle",
        "weevil",
        "fly",
        "bee",
        "ant",
        "grasshopper",
        "cricket insect",
        "stick insect",
        "cockroach",
        "praying mantis",
        "cicada",
        "leafhopper",
        "lacewing",
        "dragonfly",
        "damselfly",
        "red admiral butterfly",
        "ringlet butterfly",
        "monarch butterfly",
        "small white butterfly",
        "sulphur butterfly",
        "gossamer-winged butterfly",
        "starfish",
        "sea urchin",
        "sea cucumber",
        "cottontail rabbit",
        "hare",
        "Angora rabbit",
        "hamster",
        "porcupine",
        "fox squirrel",
        "marmot",
        "beaver",
        "guinea pig",
        "common sorrel horse",
        "zebra",
        "pig",
        "wild boar",
        "warthog",
        "hippopotamus",
        "ox",
        "water buffalo",
        "bison",
        "ram (adult male sheep)",
        "bighorn sheep",
        "Alpine ibex",
        "hartebeest",
        "impala (antelope)",
        "gazelle",
        "arabian camel",
        "llama",
        "weasel",
        "mink",
        "European polecat",
        "black-footed ferret",
        "otter",
        "skunk",
        "badger",
        "armadillo",
        "three-toed sloth",
        "orangutan",
        "gorilla",
        "chimpanzee",
        "gibbon",
        "siamang",
        "guenon",
        "patas monkey",
        "baboon",
        "macaque",
        "langur",
        "black-and-white colobus",
        "proboscis monkey",
        "marmoset",
        "white-headed capuchin",
        "howler monkey",
        "titi monkey",
        "Geoffroy's spider monkey",
        "common squirrel monkey",
        "ring-tailed lemur",
        "indri",
        "Asian elephant",
        "African bush elephant",
        "red panda",
        "giant panda",
        "snoek fish",
        "eel",
        "silver salmon",
        "rock beauty fish",
        "clownfish",
        "sturgeon",
        "gar fish",
        "lionfish",
        "pufferfish",
        "abacus",
        "abaya",
        "academic gown",
        "accordion",
        "acoustic guitar",
        "aircraft carrier",
        "airliner",
        "airship",
        "altar",
        "ambulance",
        "amphibious vehicle",
        "analog clock",
        "apiary",
        "apron",
        "trash can",
        "assault rifle",
        "backpack",
        "bakery",
        "balance beam",
        "balloon",
        "ballpoint pen",
        "Band-Aid",
        "banjo",
        "baluster / handrail",
        "barbell",
        "barber chair",
        "barbershop",
        "barn",
        "barometer",
        "barrel",
        "wheelbarrow",
        "baseball",
        "basketball",
        "bassinet",
        "bassoon",
        "swimming cap",
        "bath towel",
        "bathtub",
        "station wagon",
        "lighthouse",
        "beaker",
        "military hat (bearskin or shako)",
        "beer bottle",
        "beer glass",
        "bell tower",
        "baby bib",
        "tandem bicycle",
        "bikini",
        "ring binder",
        "binoculars",
        "birdhouse",
        "boathouse",
        "bobsleigh",
        "bolo tie",
        "poke bonnet",
        "bookcase",
        "bookstore",
        "bottle cap",
        "hunting bow",
        "bow tie",
        "brass memorial plaque",
        "bra",
        "breakwater",
        "breastplate",
        "broom",
        "bucket",
        "buckle",
        "bulletproof vest",
        "high-speed train",
        "butcher shop",
        "taxicab",
        "cauldron",
        "candle",
        "cannon",
        "canoe",
        "can opener",
        "cardigan",
        "car mirror",
        "carousel",
        "tool kit",
        "cardboard box / carton",
        "car wheel",
        "automated teller machine",
        "cassette",
        "cassette player",
        "castle",
        "catamaran",
        "CD player",
        "cello",
        "mobile phone",
        "chain",
        "chain-link fence",
        "chain mail",
        "chainsaw",
        "storage chest",
        "chiffonier",
        "bell or wind chime",
        "china cabinet",
        "Christmas stocking",
        "church",
        "movie theater",
        "cleaver",
        "cliff dwelling",
        "cloak",
        "clogs",
        "cocktail shaker",
        "coffee mug",
        "coffeemaker",
        "spiral or coil",
        "combination lock",
        "computer keyboard",
        "candy store",
        "container ship",
        "convertible",
        "corkscrew",
        "cornet",
        "cowboy boot",
        "cowboy hat",
        "cradle",
        "construction crane",
        "crash helmet",
        "crate",
        "infant bed",
        "Crock Pot",
        "croquet ball",
        "crutch",
        "cuirass",
        "dam",
        "desk",
        "desktop computer",
        "rotary dial telephone",
        "diaper",
        "digital clock",
        "digital watch",
        "dining table",
        "dishcloth",
        "dishwasher",
        "disc brake",
        "dock",
        "dog sled",
        "dome",
        "doormat",
        "drilling rig",
        "drum",
        "drumstick",
        "dumbbell",
        "Dutch oven",
        "electric fan",
        "electric guitar",
        "electric locomotive",
        "entertainment center",
        "envelope",
        "espresso machine",
        "face powder",
        "feather boa",
        "filing cabinet",
        "fireboat",
        "fire truck",
        "fire screen",
        "flagpole",
        "flute",
        "folding chair",
        "football helmet",
        "forklift",
        "fountain",
        "fountain pen",
        "four-poster bed",
        "freight car",
        "French horn",
        "frying pan",
        "fur coat",
        "garbage truck",
        "gas mask or respirator",
        "gas pump",
        "goblet",
        "go-kart",
        "golf ball",
        "golf cart",
        "gondola",
        "gong",
        "gown",
        "grand piano",
        "greenhouse",
        "radiator grille",
        "grocery store",
        "guillotine",
        "hair clip",
        "hair spray",
        "half-track",
        "hammer",
        "hamper",
        "hair dryer",
        "hand-held computer",
        "handkerchief",
        "hard disk drive",
        "harmonica",
        "harp",
        "combine harvester",
        "hatchet",
        "holster",
        "home theater",
        "honeycomb",
        "hook",
        "hoop skirt",
        "gymnastic horizontal bar",
        "horse-drawn vehicle",
        "hourglass",
        "iPod",
        "clothes iron",
        "carved pumpkin",
        "jeans",
        "jeep",
        "T-shirt",
        "jigsaw puzzle",
        "rickshaw",
        "joystick",
        "kimono",
        "knee pad",
        "knot",
        "lab coat",
        "ladle",
        "lampshade",
        "laptop computer",
        "lawn mower",
        "lens cap",
        "letter opener",
        "library",
        "lifeboat",
        "lighter",
        "limousine",
        "ocean liner",
        "lipstick",
        "slip-on shoe",
        "lotion",
        "music speaker",
        "loupe magnifying glass",
        "sawmill",
        "magnetic compass",
        "messenger bag",
        "mailbox",
        "tights",
        "one-piece bathing suit",
        "manhole cover",
        "maraca",
        "marimba",
        "mask",
        "matchstick",
        "maypole",
        "maze",
        "measuring cup",
        "medicine cabinet",
        "megalith",
        "microphone",
        "microwave oven",
        "military uniform",
        "milk can",
        "minibus",
        "miniskirt",
        "minivan",
        "missile",
        "mitten",
        "mixing bowl",
        "mobile home",
        "ford model t",
        "modem",
        "monastery",
        "monitor",
        "moped",
        "mortar and pestle",
        "graduation cap",
        "mosque",
        "mosquito net",
        "vespa",
        "mountain bike",
        "tent",
        "computer mouse",
        "mousetrap",
        "moving van",
        "muzzle",
        "metal nail",
        "neck brace",
        "necklace",
        "baby pacifier",
        "notebook computer",
        "obelisk",
        "oboe",
        "ocarina",
        "odometer",
        "oil filter",
        "pipe organ",
        "oscilloscope",
        "overskirt",
        "bullock cart",
        "oxygen mask",
        "product packet / packaging",
        "paddle",
        "paddle wheel",
        "padlock",
        "paintbrush",
        "pajamas",
        "palace",
        "pan flute",
        "paper towel",
        "parachute",
        "parallel bars",
        "park bench",
        "parking meter",
        "railroad car",
        "patio",
        "payphone",
        "pedestal",
        "pencil case",
        "pencil sharpener",
        "perfume",
        "Petri dish",
        "photocopier",
        "plectrum",
        "Pickelhaube",
        "picket fence",
        "pickup truck",
        "pier",
        "piggy bank",
        "pill bottle",
        "pillow",
        "ping-pong ball",
        "pinwheel",
        "pirate ship",
        "drink pitcher",
        "block plane",
        "planetarium",
        "plastic bag",
        "plate rack",
        "farm plow",
        "plunger",
        "Polaroid camera",
        "pole",
        "police van",
        "poncho",
        "pool table",
        "soda bottle",
        "plant pot",
        "potter's wheel",
        "power drill",
        "prayer rug",
        "printer",
        "prison",
        "missile",
        "projector",
        "hockey puck",
        "punching bag",
        "purse",
        "quill",
        "quilt",
        "race car",
        "racket",
        "radiator",
        "radio",
        "radio telescope",
        "rain barrel",
        "recreational vehicle",
        "fishing casting reel",
        "reflex camera",
        "refrigerator",
        "remote control",
        "restaurant",
        "revolver",
        "rifle",
        "rocking chair",
        "rotisserie",
        "eraser",
        "rugby ball",
        "ruler measuring stick",
        "sneaker",
        "safe",
        "safety pin",
        "salt shaker",
        "sandal",
        "sarong",
        "saxophone",
        "scabbard",
        "weighing scale",
        "school bus",
        "schooner",
        "scoreboard",
        "CRT monitor",
        "screw",
        "screwdriver",
        "seat belt",
        "sewing machine",
        "shield",
        "shoe store",
        "shoji screen / room divider",
        "shopping basket",
        "shopping cart",
        "shovel",
        "shower cap",
        "shower curtain",
        "ski",
        "balaclava ski mask",
        "sleeping bag",
        "slide rule",
        "sliding door",
        "slot machine",
        "snorkel",
        "snowmobile",
        "snowplow",
        "soap dispenser",
        "soccer ball",
        "sock",
        "solar thermal collector",
        "sombrero",
        "soup bowl",
        "keyboard space bar",
        "space heater",
        "space shuttle",
        "spatula",
        "motorboat",
        "spider web",
        "spindle",
        "sports car",
        "spotlight",
        "stage",
        "steam locomotive",
        "through arch bridge",
        "steel drum",
        "stethoscope",
        "scarf",
        "stone wall",
        "stopwatch",
        "stove",
        "strainer",
        "tram",
        "stretcher",
        "couch",
        "stupa",
        "submarine",
        "suit",
        "sundial",
        "sunglasses",
        "sunglasses",
        "sunscreen",
        "suspension bridge",
        "mop",
        "sweatshirt",
        "swim trunks / shorts",
        "swing",
        "electrical switch",
        "syringe",
        "table lamp",
        "tank",
        "tape player",
        "teapot",
        "teddy bear",
        "television",
        "tennis ball",
        "thatched roof",
        "front curtain",
        "thimble",
        "threshing machine",
        "throne",
        "tile roof",
        "toaster",
        "tobacco shop",
        "toilet seat",
        "torch",
        "totem pole",
        "tow truck",
        "toy store",
        "tractor",
        "semi-trailer truck",
        "tray",
        "trench coat",
        "tricycle",
        "trimaran",
        "tripod",
        "triumphal arch",
        "trolleybus",
        "trombone",
        "hot tub",
        "turnstile",
        "typewriter keyboard",
        "umbrella",
        "unicycle",
        "upright piano",
        "vacuum cleaner",
        "vase",
        "vaulted or arched ceiling",
        "velvet fabric",
        "vending machine",
        "vestment",
        "viaduct",
        "violin",
        "volleyball",
        "waffle iron",
        "wall clock",
        "wallet",
        "wardrobe",
        "military aircraft",
        "sink",
        "washing machine",
        "water bottle",
        "water jug",
        "water tower",
        "whiskey jug",
        "whistle",
        "hair wig",
        "window screen",
        "window shade",
        "Windsor tie",
        "wine bottle",
        "airplane wing",
        "wok",
        "wooden spoon",
        "wool",
        "split-rail fence",
        "shipwreck",
        "sailboat",
        "yurt",
        "website",
        "comic book",
        "crossword",
        "traffic or street sign",
        "traffic light",
        "dust jacket",
        "menu",
        "plate",
        "guacamole",
        "consomme",
        "hot pot",
        "trifle",
        "ice cream",
        "popsicle",
        "baguette",
        "bagel",
        "pretzel",
        "cheeseburger",
        "hot dog",
        "mashed potatoes",
        "cabbage",
        "broccoli",
        "cauliflower",
        "zucchini",
        "spaghetti squash",
        "acorn squash",
        "butternut squash",
        "cucumber",
        "artichoke",
        "bell pepper",
        "cardoon",
        "mushroom",
        "Granny Smith apple",
        "strawberry",
        "orange",
        "lemon",
        "fig",
        "pineapple",
        "banana",
        "jackfruit",
        "cherimoya (custard apple)",
        "pomegranate",
        "hay",
        "carbonara",
        "chocolate syrup",
        "dough",
        "meatloaf",
        "pizza",
        "pot pie",
        "burrito",
        "red wine",
        "espresso",
        "tea cup",
        "eggnog",
        "mountain",
        "bubble",
        "cliff",
        "coral reef",
        "geyser",
        "lakeshore",
        "promontory",
        "sandbar",
        "beach",
        "valley",
        "volcano",
        "baseball player",
        "bridegroom",
        "scuba diver",
        "rapeseed",
        "daisy",
        "yellow lady's slipper",
        "corn",
        "acorn",
        "rose hip",
        "horse chestnut seed",
        "coral fungus",
        "agaric",
        "gyromitra",
        "stinkhorn mushroom",
        "earth star fungus",
        "hen of the woods mushroom",
        "bolete",
        "corn cob",
        "toilet paper",
    ],
    openimages=[
        "Accordion",
        "Aircraft",
        "Airplane",
        "Alpaca",
        "Animal",
        "Ant",
        "Antelope",
        "Apple",
        "Auto part",
        "Backpack",
        "Bagel",
        "Baked goods",
        "Ball",
        "Balloon",
        "Banjo",
        "Barge",
        "Barrel",
        "Baseball bat",
        "Baseball glove",
        "Bat",
        "Bathroom accessory",
        "Bathroom cabinet",
        "Bathtub",
        "Bear",
        "Bed",
        "Bee",
        "Beehive",
        "Beer",
        "Beetle",
        "Bell pepper",
        "Belt",
        "Bench",
        "Bicycle",
        "Bicycle helmet",
        "Bicycle wheel",
        "Bidet",
        "Billboard",
        "Billiard table",
        "Binoculars",
        "Bird",
        "Blender",
        "Boat",
        "Book",
        "Bookcase",
        "Boot",
        "Bottle",
        "Bottle opener",
        "Bowl",
        "Bowling equipment",
        "Box",
        "Boy",
        "Brassiere",
        "Bread",
        "Briefcase",
        "Broccoli",
        "Bronze sculpture",
        "Brown bear",
        "Building",
        "Bull",
        "Burrito",
        "Bus",
        "Bust",
        "Butterfly",
        "Cabinetry",
        "Cake",
        "Cake stand",
        "Camel",
        "Camera",
        "Canary",
        "Candle",
        "Candy",
        "Cannon",
        "Canoe",
        "Cantaloupe",
        "Car",
        "Carnivore",
        "Carrot",
        "Cart",
        "Cassette deck",
        "Castle",
        "Cat",
        "Cat furniture",
        "Caterpillar",
        "Cattle",
        "Ceiling fan",
        "Cello",
        "Centipede",
        "Chair",
        "Cheese",
        "Cheetah",
        "Chest of drawers",
        "Chicken",
        "Chopsticks",
        "Christmas tree",
        "Clock",
        "Closet",
        "Clothing",
        "Coat",
        "Cocktail",
        "Coconut",
        "Coffee",
        "Coffee cup",
        "Coffee table",
        "Coin",
        "Computer keyboard",
        "Computer monitor",
        "Computer mouse",
        "Convenience store",
        "Cookie",
        "Cooking spray",
        "Corded phone",
        "Cosmetics",
        "Couch",
        "Countertop",
        "Cowboy hat",
        "Crab",
        "Cream",
        "Crocodile",
        "Crown",
        "Cupboard",
        "Curtain",
        "Cutting board",
        "Dagger",
        "Dairy",
        "Deer",
        "Desk",
        "Dessert",
        "Diaper",
        "Dice",
        "Digital clock",
        "Dinosaur",
        "Dog",
        "Dog bed",
        "Doll",
        "Dolphin",
        "Door",
        "Door handle",
        "Doughnut",
        "Dragonfly",
        "Drawer",
        "Dress",
        "Drink",
        "Drinking straw",
        "Drum",
        "Duck",
        "Eagle",
        "Earrings",
        "Egg",
        "Elephant",
        "Eraser",
        "Falcon",
        "Fashion accessory",
        "Fast food",
        "Fedora",
        "Fire hydrant",
        "Fireplace",
        "Fish",
        "Flag",
        "Flower",
        "Flowerpot",
        "Flute",
        "Flying disc",
        "Food",
        "Football",
        "Football helmet",
        "Footwear",
        "Fork",
        "Fountain",
        "Fox",
        "French fries",
        "Frog",
        "Fruit",
        "Furniture",
        "Gas stove",
        "Giraffe",
        "Girl",
        "Glasses",
        "Glove",
        "Goat",
        "Goggles",
        "Goldfish",
        "Golf ball",
        "Golf cart",
        "Gondola",
        "Goose",
        "Grape",
        "Grapefruit",
        "Guacamole",
        "Guitar",
        "Hamburger",
        "Hamster",
        "Handbag",
        "Handgun",
        "Harbor seal",
        "Harp",
        "Harpsichord",
        "Hat",
        "Headphones",
        "Hedgehog",
        "Helicopter",
        "Helmet",
        "High heels",
        "Hiking equipment",
        "Hippopotamus",
        "Home appliance",
        "Honeycomb",
        "Horn",
        "Horse",
        "House",
        "Houseplant",
        "Human arm",
        "Human beard",
        "Human body",
        "Human ear",
        "Human eye",
        "Human face",
        "Human foot",
        "Human hair",
        "Human hand",
        "Human head",
        "Human leg",
        "Human mouth",
        "Human nose",
        "Ice cream",
        "Infant bed",
        "Insect",
        "Invertebrate",
        "Ipod",
        "Jacket",
        "Jacuzzi",
        "Jeans",
        "Jellyfish",
        "Jet ski",
        "Juice",
        "Kangaroo",
        "Kettle",
        "Kitchen & dining room table",
        "Kitchen appliance",
        "Kitchen knife",
        "Kite",
        "Knife",
        "Koala",
        "Ladder",
        "Ladybug",
        "Lamp",
        "Land vehicle",
        "Lantern",
        "Laptop",
        "Lavender",
        "Lemon",
        "Leopard",
        "Lifejacket",
        "Light switch",
        "Lighthouse",
        "Lily",
        "Limousine",
        "Lion",
        "Lipstick",
        "Lizard",
        "Lobster",
        "Loveseat",
        "Luggage and bags",
        "Lynx",
        "Mammal",
        "Man",
        "Maple",
        "Marine invertebrates",
        "Marine mammal",
        "Mechanical fan",
        "Medical equipment",
        "Microphone",
        "Microwave oven",
        "Milk",
        "Miniskirt",
        "Mirror",
        "Missile",
        "Mixer",
        "Mixing bowl",
        "Mobile phone",
        "Monkey",
        "Moths and butterflies",
        "Motorcycle",
        "Mouse",
        "Muffin",
        "Mug",
        "Mule",
        "Mushroom",
        "Musical instrument",
        "Musical keyboard",
        "Necklace",
        "Nightstand",
        "Office building",
        "Office supplies",
        "Orange",
        "Organ",
        "Ostrich",
        "Otter",
        "Oven",
        "Owl",
        "Paddle",
        "Palm tree",
        "Pancake",
        "Panda",
        "Paper towel",
        "Parachute",
        "Parking meter",
        "Parrot",
        "Pasta",
        "Pastry",
        "Peach",
        "Pear",
        "Pen",
        "Pencil case",
        "Penguin",
        "Perfume",
        "Person",
        "Personal care",
        "Piano",
        "Picture frame",
        "Pig",
        "Pillow",
        "Pineapple",
        "Pizza",
        "Pizza cutter",
        "Plant",
        "Plastic bag",
        "Plate",
        "Platter",
        "Plumbing fixture",
        "Polar bear",
        "Pomegranate",
        "Porch",
        "Porcupine",
        "Poster",
        "Potato",
        "Pretzel",
        "Pumpkin",
        "Punching bag",
        "Rabbit",
        "Raccoon",
        "Racket",
        "Raven",
        "Rays and skates",
        "Red panda",
        "Refrigerator",
        "Remote control",
        "Reptile",
        "Rhinoceros",
        "Rifle",
        "Rocket",
        "Roller skates",
        "Rose",
        "Rugby ball",
        "Ruler",
        "Salad",
        "Sandal",
        "Sandwich",
        "Saucer",
        "Saxophone",
        "Scarf",
        "Scissors",
        "Scoreboard",
        "Scorpion",
        "Sculpture",
        "Sea lion",
        "Sea turtle",
        "Seafood",
        "Seat belt",
        "Segway",
        "Sewing machine",
        "Shark",
        "Sheep",
        "Shelf",
        "Shirt",
        "Shorts",
        "Shotgun",
        "Shrimp",
        "Sink",
        "Skateboard",
        "Ski",
        "Skirt",
        "Skull",
        "Skunk",
        "Skyscraper",
        "Snack",
        "Snail",
        "Snake",
        "Snowboard",
        "Snowman",
        "Snowmobile",
        "Soap dispenser",
        "Sock",
        "Sofa bed",
        "Sombrero",
        "Sparrow",
        "Spider",
        "Spoon",
        "Sports equipment",
        "Sports uniform",
        "Squash",
        "Squirrel",
        "Stairs",
        "Starfish",
        "Stationary bicycle",
        "Stool",
        "Stop sign",
        "Strawberry",
        "Street light",
        "Stretcher",
        "Studio couch",
        "Suit",
        "Suitcase",
        "Sun hat",
        "Sunflower",
        "Sunglasses",
        "Surfboard",
        "Sushi",
        "Swan",
        "Swim cap",
        "Swimming pool",
        "Swimwear",
        "Sword",
        "Syringe",
        "Table",
        "Table tennis racket",
        "Tablet computer",
        "Tableware",
        "Taco",
        "Tank",
        "Tap",
        "Tart",
        "Taxi",
        "Tea",
        "Teapot",
        "Teddy bear",
        "Telephone",
        "Television",
        "Tennis ball",
        "Tennis racket",
        "Tent",
        "Tiara",
        "Tick",
        "Tie",
        "Tiger",
        "Tin can",
        "Tire",
        "Toilet",
        "Toilet paper",
        "Tomato",
        "Tool",
        "Toothbrush",
        "Tortoise",
        "Tower",
        "Toy",
        "Traffic light",
        "Traffic sign",
        "Train",
        "Tree",
        "Tripod",
        "Trombone",
        "Trousers",
        "Truck",
        "Trumpet",
        "Turkey",
        "Turtle",
        "Umbrella",
        "Unicycle",
        "Van",
        "Vase",
        "Vegetable",
        "Vehicle",
        "Vehicle registration plate",
        "Violin",
        "Volleyball",
        "Waffle",
        "Wall clock",
        "Wardrobe",
        "Washing machine",
        "Waste container",
        "Watch",
        "Watercraft",
        "Watermelon",
        "Weapon",
        "Whale",
        "Wheel",
        "Wheelchair",
        "Whisk",
        "Whiteboard",
        "Window",
        "Window blind",
        "Wine",
        "Wine glass",
        "Wine rack",
        "Wok",
        "Woman",
        "Wood-burning stove",
        "Woodpecker",
        "Zebra",
    ],
)
