# Spatial Dependency Networks (SDNs)
------------------------------------

# Repository content

train.py is a generic training script

lib/DensityVAE.py contains the VAE model used for density estimation experiments.

lib/DisentanglementVAE.py contains the VAE model used for disentanglement experiments.

lib/nn.py contains SDN modules.

# How to reproduce density estimation experiments ?

CelebAHQ256: python3 train.py --gpus 8  --exp_name NameExperimentSomehow --batch 4 --depth 17 --ds_list 4 7 9 11 13 15 --num_dirs 2 --max_scale_sdn 64 --min_scale_sdn 0 --lrate 0.001 --state0 400 --delta_state 80 --nbits 5 --post_model IAF --prior_model IsoGaussian --obs_model DML --mix_components 30 --free_bits 0.01 --ema_coef 0.999 --z_size 8 --h_size 200 --sampling_temperature 1 --amp  --make_checkpoint  --dataset CelebAHQ256 --distributed_backend ddp --num_workers 16 --random_seed 13 --figsize 20 --check_val_every_n_epoch 2 --root AddDataPath

CIFAR10: python3 train.py --gpus 8 --exp_name NameExperimentSomehow  --batch 32 --depth 15 --ds_list 5 10 --state0 360 --delta_state 128 --num_dirs 2 --max_scale_sdn 32 --min_scale_sdn 0 --lrate 0.002 --post_model IAF --prior_model IsoGaussian --obs_model DML --mix_components 5 --free_bits 0.01 --ema_coef 0.999 --z_size 4 --h_size 200 --sampling_temperature 0.95 --amp  --make_checkpoint  --dataset CIFAR10 --distributed_backend ddp --num_workers 16 --random_seed 17 --check_val_every_n_epoch 1 --root AddDataPath

ImageNet32: python3 train.py --gpus 8 --exp_name NameExperimentSomehow  --batch 32 --depth 16 --ds_list 3 7 11 --state0 0 --delta_state 0 --num_dirs 0 --max_scale_sdn 0 --lrate 0.002 --post_model IAF --prior_model IsoGaussian --obs_model DML --mix_components 10 --free_bits 0.01 --ema_coef 0.9995 --z_size 4 --h_size 200 --sampling_temperature 1.0 --amp  --make_checkpoint  --dataset ImageNet32 --distributed_backend ddp --num_workers 16 --random_seed 13 --check_val_every_n_epoch 1 --root AddDataPath

# How to reproduce disentanglement experiments ?

density estimation part: python3 train.py --gpus 1 --exp_name NameExperimentSomehow --max_scale_sdn 32 --min_scale_sdn 32 --num_dirs 1 --state0 200 --beta_rate 1e-05 --beta_final 32 --h_size 32 --batch 128 --lrate 0.001 --z_size 10 --obs_model DL --amp --dataset 3DShapes --num_workers 2 --random_seed 1234 --task disentanglement --figsize 7 --eval_iterations 10000 --root AddDataPath

disentanglement part: for this, one needs to integrate disentanglement lib on top, and then run the same command

# How to run baselines ?

In any of the above commands, simply set --max_scale_sdn 0

# Where to obtain data ?

CelebAHQ256: we followed instructions here https://github.com/NVlabs/NVAE

CIFAR10: a part of pytorch

ImageNet32: download from http://image-net.org/small/download.php

3DShapes: download from https://github.com/deepmind/3d-shapes and store the 3dshapes.h5 file into ./data/3DShapes/ directory.
