# ConcreTizer

## Installation
Our code is based on OpenPCDet v0.5.1.
Please install `pcdet v0.5.1` following the [`OpenPCDet`](https://github.com/open-mmlab/OpenPCDet).

## Dataset Preparation
The experiment configs are located within `tools/cfgs/inversion_attack`

### KITTI Dataset
* Please download the official [KITTI 3D object detection](http://www.cvlibs.net/datasets/kitti/eval_object.php?obj_benchmark=3d) dataset and organize the downloaded files as follows (the road planes could be downloaded from [[road plane]](https://drive.google.com/file/d/1d5mq0RXRnvHPVeKx6Q612z0YRO1t2wAp/view?usp=sharing), which are optional for data augmentation in the training):

```
ConcreTizer
├── data
│   ├── kitti
│   │   ├── ImageSets
│   │   │   ├──test.txt & train_rand.txt & train.txt & val.txt
│   │   ├── training
│   │   │   ├──calib & velodyne & label_2 & image_2 & (optional: planes) & (optional: depth_2)
│   │   ├── testing
│   │   │   ├──calib & velodyne & image_2
├── pcdet
├── tools
```

* Generate the data infos by running the following command: 
```python 
python -m pcdet.datasets.kitti.kitti_dataset create_kitti_infos tools/cfgs/dataset_configs/kitti_dataset.yaml
```

### Waymo Open Dataset
* Please download the official [Waymo Open Dataset](https://waymo.com/open/download/), 
including the training data `training_0000.tar~training_0031.tar` and the validation 
data `validation_0000.tar~validation_0007.tar`.
* Unzip all the above `xxxx.tar` files to the directory of `data/waymo/raw_data` as follows (You could get 798 *train* tfrecord and 202 *val* tfrecord ):  
```
ConcreTizer
├── data
│   ├── waymo
│   │   ├── ImageSets
│   │   ├── raw_data
│   │   │   ├── segment-xxxxxxxx.tfrecord
│   │   │   ├── ...
│   │   ├── waymo_processed_data_v0_5_0
│   │   │   ├── segment-xxxxxxxx/
│   │   │   ├── ...
│   │   ├── waymo_processed_data_v0_5_0_gt_database_train_sampled_1/
│   │   ├── waymo_processed_data_v0_5_0_waymo_dbinfos_train_sampled_1.pkl
│   │   ├── waymo_processed_data_v0_5_0_gt_database_train_sampled_1_global.npy (optional)
│   │   ├── waymo_processed_data_v0_5_0_infos_train.pkl (optional)
│   │   ├── waymo_processed_data_v0_5_0_infos_val.pkl (optional)
├── pcdet
├── tools
```
* Install the official `waymo-open-dataset` by running the following command: 
```shell script
pip3 install --upgrade pip
# tf 2.0.0
pip3 install waymo-open-dataset-tf-2-5-0 --user
```

* Extract point cloud data from tfrecord and generate data infos by running the following command (it takes several hours, 
and you could refer to `data/waymo/waymo_processed_data_v0_5_0` to see how many records that have been processed): 
```python 
python -m pcdet.datasets.waymo.waymo_dataset --func create_waymo_infos \
    --cfg_file tools/cfgs/dataset_configs/waymo_dataset.yaml
```

Note that you do not need to install `waymo-open-dataset` if you have already processed the data before and do not need to evaluate with official Waymo Metrics. 


## Training & Testing

### Pre-training feature extractor
```shell script
sh scripts/train_feature_extractor.sh ${CONFIGURATION_FILE_NAME}
ex) sh scripts/train_feature_extractor.sh kitti_models/second_iou_layer_wise_voxelbackbone
```


### Training inversion attack model
You need to set the pre-trained feature extractor path to the configuration yaml file.

[Point regression]
```shell script
sh scripts/train_inversion_pr.sh ${CONFIGURATION_FILE_NAME}
ex) sh scripts/train_inversion_pr.sh kitti_voxelbackbone/inversion_xconvout_naive
```
[Voxel pointness predction w/ BCE loss]
```shell script
sh scripts/train_inversion_vpc_bce.sh ${CONFIGURATION_FILE_NAME}
ex) sh scripts/train_inversion_vpc_bce.sh kitti_voxelbackbone/inversion_xconvout_cls_BCE
```
[Voxel pointness predction]
```shell script
sh scripts/train_inversion_vpc.sh ${CONFIGURATION_FILE_NAME}
ex) sh scripts/train_inversion_vpc.sh kitti_voxelbackbone/inversion_xconvout_cls
```
[ConcreTizer]
```shell script
sh scripts/train_inversion_concretizer.sh ${CONFIGURATION_FILE_NAME}
ex) sh scripts/train_inversion_concretizer.sh kitti_voxelbackbone
```

### Testing inversion attack model
You need to set the pre-trained model path to the configuration yaml file.

[Point regression]
```shell script
sh scripts/test_inversion_pr.sh ${CONFIGURATION_FILE_NAME}
ex) sh scripts/test_inversion_pr.sh kitti_voxelbackbone/inversion_xconvout_naive
```
[Voxel pointness predction w/ BCE loss]
```shell script
sh scripts/test_inversion_vpc_bce.sh ${CONFIGURATION_FILE_NAME}
ex) sh scripts/test_inversion_vpc_bce.sh kitti_voxelbackbone/inversion_xconvout_cls_BCE
```
[Voxel pointness predction]
```shell script
sh scripts/test_inversion_vpc.sh ${CONFIGURATION_FILE_NAME}
ex) sh scripts/test_inversion_vpc.sh kitti_voxelbackbone/inversion_xconvout_cls
```
[ConcreTizer]
```shell script
sh scripts/test_inversion_concretizer.sh ${CONFIGURATION_FILE_NAME}
ex) sh scripts/test_inversion_concretizer.sh kitti_voxelbackbone
```