
from .detector3d_template import Detector3DTemplate
from .second_net import SECONDNet
from .second_net_iou import SECONDNetIoU
from .second_net_iou_meanVFE import SECONDNetIoU_meanVFE
from .second_net_iou_backbone import SECONDNetIoU_Backbone

__all__ = {
    "Detector3DTemplate": Detector3DTemplate,
    "SECONDNet": SECONDNet,
    "SECONDNetIoU": SECONDNetIoU,
    "SECONDNetIoU_Backbone": SECONDNetIoU_Backbone,
    "SECONDNetIoU_meanVFE": SECONDNetIoU_meanVFE,
}


def build_detector(model_cfg, num_class, dataset):
    model = __all__[model_cfg.NAME](
        model_cfg=model_cfg,
        num_class=num_class,
        dataset=dataset,
    )

    return model