import numpy as np
import matplotlib.pyplot as plt

# Create a sample data array
x = [0.1,0.15,0.2,0.25,0.3,0.35,0.4]
minErr = [2767,4136,5636,6937,8446,9895,10000]
meanErr = [3062.55,4527.4,6020.65,7597.85,9196.25,9990.15,10000]
maxErr = [3669,4940,7050,8234,10000,10000,10000]
detErr = [1000,1500,2000,2500,3000,3500,4000]
plt.ylim(top=10100)
plt.xlim(left=0.1,right=0.4)

##x = [0.05,0.1,0.15,0.2,0.25,0.3,0.35]
##minErr = [95,204,309,416,530,605,731]
##meanErr = [99.1,215.3,329.7,450,555.8,665.8,788.4]
##maxErr = [104,242,367,505,611,726,861]
##detErr = [50,100,150,200,250,300,350]
##plt.ylim(top=10100)
##plt.xlim(left=0.05,right=0.35)

#plt.plot(x, maxErr)
plt.fill_between(x, minErr, maxErr, color='blue', alpha=0.1, label='Range')
#plt.plot(x, minErr)
plt.plot(x, meanErr, label="avg. rand. errs")

plt.plot(x, detErr, label="det. errs")
plt.legend(loc="upper left")

plt.ylabel('Actual Number of Errors')
plt.xlabel('Target (Amortized) Regret')

### Plot the mean as a red line
##plt.plot([0, len(data)-1], [mean, mean], 'r-', label='Mean')
##
### Plot the max and min as shaded areas
##plt.fill_between([0, len(data)-1], [max_val, max_val], [min_val, min_val], color='gray', alpha=0.3, label='Range')
##
### Set the x and y labels and the plot title
##plt.xlabel('Data Point Index')
##plt.ylabel('Value')
##plt.title('Mean and Range Plot')
##
### Add a legend to the plot
##plt.legend()
##

# Display the plot
plt.show()
