import numpy as np

# install
# pip install causal-learn


def solve_fci(X):
    from causallearn.search.ConstraintBased.FCI import fci
    graph, edges = fci(X, alpha=0.05)
    n = graph.get_num_nodes()

    W_est = np.zeros((n, n))
    Wbi = np.zeros((n, n))
    for i in range(n):
        for j in range(n):
            if i == j:
                continue
            # i --> j
            if graph.graph[j,i] == 1 and graph.graph[i,j] == -1:
                W_est[i,j] = 1
            elif graph.graph[j,i] == 1 and graph.graph[i,j] == 1:
                Wbi[i,j] = 1

    return W_est, Wbi